
Tornado_ADV =  {
      
		Name 			= 'Tornado_ADV',--AG
		DisplayName		= _('Tornado F3 ADV'),--AG
        Picture 		= "Tornado_ADV.png",
        Rate 			= "50",
        Shape			= "Tornado_ADV",--AG	
        WorldID			=  56, --WSTYPE_PLACEHOLDER
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'Tornado_ADV';--AG
			life  	 	= 15; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'Tornado_ADV';--AG
			index       =  56;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 56, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	14500,	-- kg  with pilot and nose load, F15
		M_nominal					=	19160,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	27985,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	4660,	-- kg (Internal Fuel Only)
		H_max						=	15240,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.55,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	250,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	71,		-- Take off speed in m/s (for AI)
		V_land						=	81,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,
		defFuelRatio = 1.00,
		input_profile_entry = 	"Tornado_ADV",

		nose_gear_pos 				                = {3.821, -2.107, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.754, -- in m
	
	    main_gear_pos 						 	    = {-1.323, -2.107, 1.541}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.972, -- in m

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	423,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	36.5,	-- wing area in m2
		thrust_sum_max				=	8150,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	14500,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.2,	-- Max speed in Mach (for AI)
		range						=	2740,	-- Max range in km (for AI)
		RCS							=	4,		-- Radar Cross Section m2
		Ny_max_e					=	6,		-- Max G (for AI)
		detection_range_max			=	230,
		IR_emission_coeff			=	0.6,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	2.2,		-- With afterburner
		tand_gear_max				=	0.57, --XX  1.732 FA18 3.73, 
		tanker_type					=	2,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	13.9,--XX  wing spain in m
		wing_type 					= 	1,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	16.7,
		height						=	5.7,
		crew_size					=	1, --XX
		engines_count				=	2, --XX
		wing_tip_pos 				= 	{-2.5, 0, 6.75},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
	{
		[1] = 
		{
			pos					=	{-6.45, 0.099, -0.483},
				elevation			=	0,
				diameter			=	0.817,
				exhaust_length_ab	=	4.0,
				exhaust_length_ab_K	=	0.76,
				smokiness_level		=	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
		}, -- end of [1]
		[2] = 
		{
			pos					=	{-6.45, 0.099, 0.483},
				elevation			=	0,
				diameter			=	0.817,
				exhaust_length_ab	=	4.0,
				exhaust_length_ab_K	=	0.76,
				smokiness_level		=	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
		}, -- end of [2]
		}, -- end of engines_nozzles
		crew_members = 
	{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	39,
				canopy_pos			= 	{3.34, 1.102, 0},
				pos					=	{3.34, 1.102, 0},
				pilot_body_arg		=	-1,
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	0,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{6.4, 0.63, 1.02},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.307,	1.511},
			[3] = 	{0.173,	-0.307,	-1.511},
			[4] = 	{-0.82,	0.265,	1.774},
			[5] = 	{-0.82,	0.265,	-1.774},
			[6] = 	{-0.82,	0.255,	2.274},
			[7] = 	{-0.82,	0.255,	-2.274},
			[8] = 	{-6.42, 0.099, -0.483},
			[9] = 	{-6.42, 0.099, 0.483},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/Tornado_ADV_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
	{
			[1] = 
			{
				dir = 	{0, -1.0, 0.2},
				pos = 	{-6.65, 0.029, -0.283},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0, -1.0, -0.2},
				pos = 	{-6.65, 0.029, 0.283},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 180,
chaff 				= {default = 90, increment = 30, chargeSz = 1},
flare 				= {default = 45, increment = 15, chargeSz = 2}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 	= "AN/APG-63",--F15
RWR 	= "Abstract RWR",--F15
IRST 	= "KOLS",--MIG29
},
Countermeasures = {
--ECM 			= "AN/ALQ-135"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns = {gun_mount("M_61", { count = 180 },{muzzle_pos = {5.834, -0.609, -0.646}}),--3.906000, 0.768000, -0.975000
},

pylons_enumeration = {1, 12, 2, 11, 3, 10, 4, 9, 5, 8, 6, 7},

	Pylons =     {

        pylon(1, 0, -3.745, 0.315, -3.35,
            {
                FiZ = 0,
		Type = 0,
		Order = 1,
            },
            {
			    { CLSID	= "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", attach_point_position = {0.3, -0.04, 0} }, --aim9m
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", attach_point_position = {0.3, -0.04, 0} }, --aim9p
			    { CLSID	= "{JAS39_ASRAAM}", attach_point_position = {0.8, -0.04, 0} }, --asraam
			    { CLSID	= "{AIM-9P5}", attach_point_position = {0.3, -0.04, 0} }, --aim9p5
			    { CLSID	= "{AIM-9L}", attach_point_position = {0.3, -0.04, 0} }, --aim9l
            }
        ),
	pylon(2, 0, -1.28, -0.485, -2.018,
            {
                FiZ = 0,
		Type = 1,
		Order = 2,
            },
            {
			    { CLSID	= "{PTB_800_MIG21}", attach_point_position = {0, 0.035, 0} }, --fuel
            }
        ),
        pylon(3, 0, -0.993, 0.013, -1.688,
            {
                FiX = 45,
		Type = 0,
		Order = 3,
            },
            {
			    { CLSID	= "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", attach_point_position = {0, 0.04, 0.03} }, --aim9m
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", attach_point_position = {0, 0.04, 0.03} }, --aim9p
			    { CLSID	= "{JAS39_ASRAAM}", attach_point_position = {0, 0.04, 0.03} }, --asraam
			    { CLSID	= "{AIM-9P5}", attach_point_position = {0, 0.04, 0.03} }, --aim9p5
			    { CLSID	= "{AIM-9L}", attach_point_position = {0, 0.04, 0.03} }, --aim9l
            }
        ),
        pylon(4, 0, 1.342, -1.003, -0.55,
            {
                FiZ = 0,
		Order = 4,
            },
            {
			    --
            }
        ),
        pylon(5, 0, 1.342, -1.003, -0.55,
            {
                FiX = 45,
		Type = 1,
		Order = 5,
            },
            {
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", attach_point_position = {-3.572, -0.06, 0.08} }, --aim120b
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", attach_point_position = {-3.572, -0.06, 0.08} }, --aim120c5
			    { CLSID	= "{Skflash1}", attach_point_position = {-3.572, 0.015, 0.08} }, --skyflash
            }
        ),
        pylon(6, 0, -1.73, -1.003, -0.55,
            {
                FiX = 45,
		Type = 1,
		Order = 6,
            },
            {
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", attach_point_position = {2.785, -0.06, 0.08} }, --aim120b
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", attach_point_position = {2.785, -0.06, 0.08} }, --aim120c5
			    { CLSID	= "{Skflash1}", attach_point_position = {2.785, 0.015, 0.08} }, --skyflash
            }
        ),
        pylon(7, 0, -1.73, -1.003, 0.55,
            {
                FiX = 45,
		Type = 1,
		Order = 7,
            },
            {
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", attach_point_position = {2.785, -0.06, 0.08} }, --aim120b
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", attach_point_position = {2.785, -0.06, 0.08} }, --aim120c5
			    { CLSID	= "{Skflash1}", attach_point_position = {2.785, 0.015, 0.08} }, --skyflash
            }
        ),
        pylon(8, 0, 1.342, -1.003, 0.55,
            {
                FiX = 45,
		Type = 1,
		Order = 8,
            },
            {
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", attach_point_position = {-3.572, -0.06, 0.08} }, --aim120b
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", attach_point_position = {-3.572, -0.06, 0.08} }, --aim120c5
			    { CLSID	= "{Skflash1}", attach_point_position = {-3.572, 0.015, 0.08} }, --skyflash
            }
        ),
        pylon(9, 0, 1.342, -1.003, 0.55,
            {
                FiZ = 0,
		Order = 9,
            },
            {
			    --
            }
        ),
        pylon(10, 0, -0.993, 0.013, 1.688,
            {
                FiX = 45,
		Type = 0,
		Order = 10,
            },
            {
			    { CLSID	= "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --aim9m
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --aim9p
			    { CLSID	= "{JAS39_ASRAAM}", attach_point_position = {0, 0.01, -0.03} }, --asraam
			    { CLSID	= "{AIM-9P5}" }, --aim9p5
			    { CLSID	= "{AIM-9L}" }, --aim9l
            }
        ),
        pylon(11, 0, -1.28, -0.485, 2.018,
            {
                FiZ = 0,
		Type = 1,
		Order = 11,
            },
            {
			    { CLSID	= "{PTB_800_MIG21}", attach_point_position = {0, 0.035, 0} }, --fuel
            }
        ),
        pylon(12, 0, -3.745, -0.315, 3.35,
            {
                FiZ = 0,
		Type = 0,
		Order = 12,
            },
            {
			    { CLSID	= "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", attach_point_position = {0.3, -0.04, 0} }, --aim9m
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", attach_point_position = {0.3, -0.04, 0} }, --aim9p
			    { CLSID	= "{JAS39_ASRAAM}", attach_point_position = {0.8, -0.04, 0} }, --asraam
			    { CLSID	= "{AIM-9P5}", attach_point_position = {0.3, -0.04, 0} }, --aim9p5
			    { CLSID	= "{AIM-9L}", attach_point_position = {0.3, -0.04, 0} }, --aim9l
            }
        ),

},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	6.6,
			Mzalfadt	=	1.0,
			kjx = 2.85,
			kjz = 0.00125,
			Czbe = -0.012,
			cx_gear = 0.015,
			cx_flap = 0.04,
			cy_flap = 0.3,
			cx_brk = 0.028,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.0235, 0.07, 0.024, 0.18, 0.5, 30, 1.1 }, { 0.2, 0.0235, 0.07, 0.024, 0.18, 1.5, 30, 1.1 }, { 0.4, 0.0235, 0.07, 0.024, 0.18, 2.5, 30, 1.1 }, { 0.6, 0.0235, 0.073, 0.024, 0.18, 3.5, 30, 1.1 }, { 0.7, 0.022, 0.076, 0.3, 0.052, 3.5, 28.666666666667, 1.0911111111111 }, { 0.8, 0.022, 0.079, 0.3, 0.052, 3.5, 27.333333333333, 1.0822222222222 }, { 0.9, 0.0235, 0.083, 0.324, 0.0536, 3.5, 26, 1.0733333333333 }, { 1, 0.03, 0.085, 0.348, 0.0552, 3.5, 24.666666666667, 1.0644444444444 },
				{ 1.05, 0.031, 0.0855, 0.36, 0.056, 3.5, 24, 1.06 }, { 1.1, 0.032, 0.086, 0.372, 0.0568, 3.15, 18, 1.04 }, { 1.2, 0.0325, 0.083, 0.396, 0.0584, 2.45, 17, 1.02 }, { 1.3, 0.032, 0.077, 0.42, 0.06, 1.75, 16, 1 }, { 1.5, 0.031, 0.062, 0.488571, 0.06, 1.5, 13, 0.9 }, { 1.7, 0.03, 0.051333333333333, 0.557143, 0.06, 0.9, 12, 0.7 }, { 1.8, 0.0295, 0.046, 0.591429, 0.06, 0.86, 11.4, 0.64 }, { 2, 0.029, 0.039, 0.66, 0.06, 0.78, 10.2, 0.52 }, { 2.2, 0.028, 0.034, 0.227, 3.2, 0.7, 9, 0.4 }, { 2.5, 0.027, 0.033, 0.25, 4.5, 0.7, 9, 0.4 }, { 3.9, 0.027, 0.033, 0.35, 6, 0.7, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0085,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	3000,
			dpdh_f	=	6200.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 77070.4, 146000 }, { 0.2, 72000, 138000 }, { 0.4, 70000, 137000 }, { 0.6, 70000, 135000 }, { 0.7, 72000, 135000 }, { 0.8, 72000, 140000 }, { 0.9, 70000, 146000 }, { 1, 64000, 149000 }, { 1.1, 58000, 152000 }, { 1.2, 57000, 155000 }, { 1.3, 57000, 160000 }, { 1.4, 55000, 165000 }, { 1.596, 50000, 162000 }, { 1.8, 44000, 146000 }, { 2.2, 49000, 127000 }, { 2.35, 47000, 127000 }, { 3.9, 90381.1, 130000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 5, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 5, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 5, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "TORNADO-OBLOMOK-WING-R", -- wing R
		[2] = "TORNADO-OBLOMOK-WING-L", -- wing L
	},
	
	lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 49, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", position = { 2.542, -0.826, 0.789 }, dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
}

add_aircraft(Tornado_ADV) --AG
