local wingOutbdPylonMass	= 58.1		-- [kg]	(128 lb)
local wingInbdPylonMass		= 55.3		-- [kg]	(122 lb)
local ctrPylonMass			= 77.1		-- [kg]	(170 lb)

local tips =
{
	{ CLSID = "{AIM-9B}"							  ,												Cx_gain = 0.302},			-- AIM_9B (GAR-8)
	{ CLSID = "{AIM-9P5}"							  ,												Cx_gain = 0.302},			-- AIM_9P5
	{ CLSID = "{AIM-9P3}"							  ,												Cx_gain = 0.302},			-- AIM_9P3
	{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",												                        Cx_gain = 0.302},			-- AIM_9P
        { CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",	                                                                                                                Cx_gain = 0.302},			-- AIM-9X
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",												Cx_gain = 0.22},			-- Smokewinder red
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",												Cx_gain = 0.22},			-- Smokewinder green
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",												Cx_gain = 0.22},			-- Smokewinder blue
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",												Cx_gain = 0.22},			-- Smokewinder white
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",												Cx_gain = 0.22},			-- Smokewinder yellow
	{ CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}",												Cx_gain = 0.22},			-- Smokewinder orange
}
local outboard =
{
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- Mk-82
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- Mk-82 Snakeye
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}",	arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- M117
	{ CLSID = "{CBU-52B}", 								arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- CBU-52
	{ CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- LAU-68-MK5
	{ CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- LAU-68-M151
	{ CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- LAU-68-MK156
	{ CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- LAU-68-M257
	{ CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},	-- LAU-68-W274
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{LAU68_FFAR_WP156}",						arg_value = 0.0, add_mass = wingOutbdPylonMass	},
	{ CLSID = "{LAU68_FFAR_MK1HE}",						arg_value = 0.0, add_mass = wingOutbdPylonMass	},
	{ CLSID = "{LAU68_FFAR_MK5HEAT}",					arg_value = 0.0, add_mass = wingOutbdPylonMass	},
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "LAU3_WP156",								arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},	-- LAU-3 - 19 MK156 WP
	{ CLSID = "LAU3_HE5",								arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},	-- LAU-3 - 19 MK5 HEAT
	{ CLSID = "LAU3_HE151",								arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},	-- LAU-3 - 19 MK151 HE
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{LAU3_FFAR_WP156}",						arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},
	{ CLSID = "{LAU3_FFAR_MK1HE}",						arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},
	{ CLSID = "{LAU3_FFAR_MK5HEAT}",					arg_value = 0.0, attach_point_position = {0.05,  0.0,  0.0}, add_mass = wingOutbdPylonMass	},
---------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{CAE48299-A294-4bad-8EE6-89EFC5DCDF00}", arg_value = 0.0, add_mass = wingOutbdPylonMass	},												-- SUU-25 8 LUU-2
}
local inboard =
{
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- Mk-82
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- Mk-82 Snakeye
	{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- Mk-83
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- M117
	{ CLSID = "{CBU-52B}",								arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- CBU-52
	{ CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-MK5
	{ CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-M151
	{ CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-MK156
	{ CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-M257
	{ CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 0.0, add_mass = wingInbdPylonMass	},	-- LAU-68-W274
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{LAU68_FFAR_WP156}",						arg_value = 0.0, add_mass = wingInbdPylonMass	},
	{ CLSID = "{LAU68_FFAR_MK1HE}",						arg_value = 0.0, add_mass = wingInbdPylonMass	},
	{ CLSID = "{LAU68_FFAR_MK5HEAT}",					arg_value = 0.0, add_mass = wingInbdPylonMass	},
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "LAU3_WP156",								arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},	-- LAU-3 - 19 MK156 WP
	{ CLSID = "LAU3_HE5",								arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},	-- LAU-3 - 19 MK5 HEAT
	{ CLSID = "LAU3_HE151",								arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},	-- LAU-3 - 19 MK151 HE
--------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{LAU3_FFAR_WP156}",						arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},
	{ CLSID = "{LAU3_FFAR_MK1HE}",						arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},
	{ CLSID = "{LAU3_FFAR_MK5HEAT}",					arg_value = 0.0, attach_point_position = {-0.06,  0.0,  0.0}, add_mass = wingInbdPylonMass	},
---------------------------------------------------------------------------------------------------------------------------------------------
	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0, add_mass = wingInbdPylonMass	},												-- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0, add_mass = wingInbdPylonMass	},												-- 150 gal drop tank
}
local centerline =
{
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- Mk-82
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0, add_mass = ctrPylonMass	},	-- Mk-82 Snakeye
	{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- Mk-83
	{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- Mk-84
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- M117
	{ CLSID = "{MER-5E_MK82x5}",						arg_value = 0.0,attach_point_position = {0.0, -0.005, 0.0}, add_mass = ctrPylonMass	},	-- MER-5E 5xMk-82
	{ CLSID = "{MER-5E_Mk82SNAKEYEx5}",					arg_value = 0.0,attach_point_position = {0.0, -0.005, 0.0}, add_mass = ctrPylonMass	},	-- MER-5E 5xMk-82 Snakeye
	{ CLSID = "{CBU-52B}",								arg_value = 0.0, add_mass = ctrPylonMass	},	-- CBU-52
	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0, add_mass = ctrPylonMass	},	-- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0, add_mass = ctrPylonMass	},	-- 150 gal drop tank
}

function f5e3_fc_settings(unit_name, display_name)
	local f5_local_settings = f5e3_settings(unit_name, display_name)

	f5_local_settings.encyclopedia_hidden = true
	f5_local_settings.Shape			= 'f-5e3_fc'
	f5_local_settings.Name			= unit_name
	f5_local_settings.desrt			= 'f-5e3_fc_oblomok'
	f5_local_settings.DamageParts 	= {
		[1] = "f-5e3_fc_oblomok_wing_r",
		[2] = "f-5e3_fc_oblomok_wing_l",
	}
	f5_local_settings.Pylons		= {
		pylon(1, 0, -1.319000, -0.332000, -4.099000,
			{
				use_full_connector_position = true,
				connector		= "Pylon1",
			},
			tips
		),
		pylon(2, 0, -1.122000, -0.861000, -3.132000,
			{
				use_full_connector_position = true,
				connector		= "Pylon2",
				arg				= 309,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_02",
			},
			outboard
		),
		pylon(3, 0, -1.190000, -0.922000, -2.334000,
			{
				use_full_connector_position = true,
				connector		= "Pylon3",
				arg				= 310,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_03",
			},
			inboard
		),
		pylon(4, 0,  0.065000, -0.930000,  0.000000,
			{
				use_full_connector_position = true,
				connector		= "Pylon4",
				arg				= 311,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_04c",
			},
			centerline
		),
		pylon(5, 0, -1.190000, -0.922000,  2.334000,
			{
				use_full_connector_position = true,
				connector		= "Pylon5",
				arg				= 312,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_05",
			},
			inboard
		),
		pylon(6, 0, -1.122000, -0.861000,  3.132000,
			{
				use_full_connector_position = true,
				connector		= "Pylon6",
				arg				= 313,
				arg_value		= 1,
				droppable_shape	= "F-5e3_fc_pylon_06",
			},
			outboard
		),
		pylon(7, 0, -1.319000, -0.332000,  4.099000,
			{
				use_full_connector_position = true,
				connector		= "Pylon7",
			},
			tips
		),
	}

	return f5_local_settings
end

make_tiger(f5e3_fc_settings('F-5E-3_FC', _('F-5E FC')))