var mapProjection;
var mapUrlBase;
var mapDetailUrlBase;
var mapMaxZoom;
var mapFileExtension;

function dcsMap() {
	mapProjection = 'EPSG:4326';
	mapUrlBase = "DCS-EPSG4326/";
	mapDetailUrlBase = "DCS-EPSG4326/";
	mapMaxZoom = 13;
	mapFileExtension = "png";
	createMap();
}

function createMap() {
	document.getElementById("intro").style.display = "hidden";
	document.getElementById("map").style.display = "block";
	
	var mapBounds = ol.proj.transform([37, 41, 45, 45.5], 'EPSG:4326', mapProjection);

	var layer = new ol.layer.Tile({
		source: new ol.source.TMS({
			tileUrlFunction: function(tileCoord, projection) {
				if (!tileCoord) return null;
				
				// see https://groups.google.com/forum/#!msg/ol3-dev/8Co4JhwioGQ/nkTcljlUsDsJ
				var z = tileCoord.z;
				var x = tileCoord.x;
				var y = (1 << z) - tileCoord.y - 1;
				//console.log(z);
				
				
				if (mapProjection == "EPSG:4326") {
					if (z == 1) x = x + 1;
					if (z == 2) x = x + 2;
					if (z == 3) x = x + 4;
					if (z == 4) x = x + 8;
					if (z == 5) x = x+16; // zoom 6
					if (z == 6) x = x + 32;
					if (z == 7) x = x + 64;
					if (z == 8) x = x + 128;
					if (z == 9) x = x + 256;
					if (z == 10) x = x + 512;
					if (z == 11) x = x + 1024;
					if (z == 12) x = x + 2048;
					if (z == 13) x = x + 4096;
					if (z == 14) x = x + 8192;
					if (z == 15) x = x + 16384;
				}
				if (z <= 9) {
					return mapUrlBase+z+"/"+x+"/"+y+"."+mapFileExtension;
				} else {
					return mapDetailUrlBase+z+"/"+x+"/"+y+"."+mapFileExtension;
				}
			},
			maxZoom: mapMaxZoom,
			extent: mapBounds,
			projection: mapProjection,
		})
	});

	var mousePositionControl = new ol.control.MousePosition({
		coordinateFormat: function(coord) {
			var lon_deg = Math.floor(coord[0]); var lon_frac = coord[0] - lon_deg;
			var lat_deg = Math.floor(coord[1]); var lat_frac = coord[1] - lat_deg;
			
			return 'N '+lat_deg+'°'+(lat_frac*60).toFixed(3) +'  E 0'+lon_deg+'°'+(lon_frac*60).toFixed(3);
		},
		projection: 'EPSG:4326',
		undefinedHTML: '&nbsp;'
	});

	var map = new ol.Map({
		target: 'map',
		controls: ol.control.defaults().extend([
			new ol.control.ZoomToExtent({
				extent: mapBounds,
			}),
			new ol.control.ZoomSlider(),
			mousePositionControl,
			new ol.control.ScaleLine(),
		]),
		layers: [layer],
		renderer: 'canvas',
		view: new ol.View2D({
			center: ol.proj.transform([41, 43.25], 'EPSG:4326', mapProjection),
			zoom: 7,
			projection: mapProjection,
		})
	});
}
