local cockpit = 1
-- 0 = SU-25T
-- 1 = F-15C
-- 2 = A-10A

declare_plugin("F-2",
{
installed 	 = true, -- if false that will be place holder , or advertising
dirName	  	 = current_mod_path,
version		 = "2.1.1",		 
state		 = "installed",
info		 = _("The F-2 is a multirole fighter used by the JASDF."),

InputProfiles =
	{
		["F-2A"]     = current_mod_path..'/Input/F-2A',
		["F-2B"]     = current_mod_path..'/Input/F-2B',
	},

Skins	= 
	{
		{
			name	= _("F-2"),
			dir		= "Theme"
		},
	},

--Missions =
--	{
--		{
--			name		= _("F-2A"),
--			dir			= "Missions",
--		},
--	},	

LogBook =
	{
		{
			name		= _("F-2A"),
			type		= "F-2A",
		},
		{
			name		= _("F-2B"),
			type		= "F-2B",
		},
	},	
})
---------------------------------------------------------------------------------------

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/F-2")
mount_vfs_texture_path  (current_mod_path.."/Textures")

-- aircraft
dofile(current_mod_path..'/F-2A.lua')
dofile(current_mod_path..'/F-2B.lua')

-- weapons
dofile(current_mod_path..'/Weapons/AAM-3.lua')
dofile(current_mod_path..'/Weapons/AAM-4.lua')
dofile(current_mod_path..'/Weapons/ASM-2.lua')
dofile(current_mod_path..'/Weapons/ASM-3.lua')
dofile(current_mod_path..'/Weapons/F-2-PTB.lua')

if cockpit == 1 then
	mount_vfs_model_path(current_mod_path.."/CockpitF15")
	dofile(current_mod_path.."/Views-F15Pit.lua")
	make_view_settings('F-2A', ViewSettings, SnapViews)
	make_flyable('F-2A', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', {'F-2A', nil, old = 6}, current_mod_path..'/comm.lua')
	make_view_settings('F-2B', ViewSettings, SnapViews)
	make_flyable('F-2B', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', {'F-2B', nil, old = 6}, current_mod_path..'/comm.lua')
elseif cockpit == 2 then
	mount_vfs_model_path(current_mod_path.."/CockpitA10")
	dofile(current_mod_path.."/Views-A10APit.lua")
	make_view_settings('F-2A', ViewSettings, SnapViews)
	make_flyable('F-2A', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', {'F-2A', nil, old = 17}, current_mod_path..'/comm.lua')
	make_view_settings('F-2B', ViewSettings, SnapViews)
	make_flyable('F-2B', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', {'F-2B', nil, old = 17}, current_mod_path..'/comm.lua')
else
	mount_vfs_model_path(current_mod_path.."/CockpitSU25")
	dofile(current_mod_path.."/Views-SU25TPit.lua")
	make_view_settings('F-2A', ViewSettings, SnapViews)
	make_flyable('F-2A', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', nil, current_mod_path..'/comm.lua')
	make_view_settings('F-2B', ViewSettings, SnapViews)
	make_flyable('F-2B', 'Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardRight/', nil, current_mod_path..'/comm.lua')
end

plugin_done()-- finish declaration , clear temporal data
