F_2A = 
{
	Name 				=   'F-2A',
	DisplayName			= _('F-2A'),
	HumanCockpit 		= true,
--	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	Picture 			= current_mod_path.."/F-2.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "F-2A",
	shape_table_data 	= 
	{
		{
			file  	 = 'F-2A';
			life  	 = 18; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'F-2A_destr'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'F-2A';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
--		{
--			name  = "F-2A_destr";
--			file  = "F-2A-destr";
--			fire  = { 240, 2};
--		},

	},
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Multirole fighters", "Refuelable",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	
	-------------------------

	--  \Scripts\Database\PlaneConst.lua̗ގ̋@̃f[^Q 	
	M_empty 					= 8853, -- kg
	M_nominal 					= 11000, -- kg
	M_max 						= 19187, -- kg
	M_fuel_max 					= 3104, -- kg
	H_max 					 	= 15240, -- m
	average_fuel_consumption 	= 0.245, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 60, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 220,-- Cruise speed (for AI)
	V_take_off 					= 65, -- Take off speed in m/s (for AI)
	V_land 						= 68, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 408, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 589, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 250, -- Max climb speed in m/s (for AI)
	Mach_max 					= 2.0, -- Max speed in Mach (for AI)
	Ny_min 						= -3, -- Min G (for AI)
	Ny_max 						= 8.0,  -- Max G (for AI)
	Ny_max_e 					= 8.0,  -- Max G (for AI)
	AOA_take_off 				= 0.16, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)
	has_afteburner 				= true, -- AFB yes/no
	has_speedbrake 				= true, -- Speedbrake yes/no
	nose_gear_pos 				= {3.146,	-1.55,	0}, -- nosegear coord
	main_gear_pos 				= { -0.9,	-1.55,	1.3}, -- main gear coords
	tand_gear_max 				= 0.4,
	tanker_type 				= 1, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 34.9, -- wing area in m2
	wing_span 					= 11.13, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 8054, -- thrust in kg (44kN)
	thrust_sum_ab 				= 13160, -- thrust inkg (71kN)
	length 						= 15.52, -- full lenght in m
	height 						= 4.96, -- height in m
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1500, -- Max range in km (for AI)
	RCS 						= 4, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.6, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 1.2, -- With afterburner
	wing_tip_pos 				=  {-2.1, 0.6, 5.6}, -- wingtip coords for visual effects
	nose_gear_wheel_diameter 	= 0.500, -- in m
	main_gear_wheel_diameter 	= 0.725, -- in m
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {-0.25,	0.911,	0}, -- refuel coords
	engines_count				= 1, -- Engines count
	engines_nozzles = 
	{
		[1] = 
		{
			pos					= {-6.0, 0.35, 0}, -- nozzle coords
			elevation			= 0, -- AFB cone elevation
			diameter			= 1.1, -- AFB cone diameter
			exhaust_length_ab	= 5, -- lenght in m
			exhaust_length_ab_K	= 0.76, -- AB animation
			smokiness_level		= 0.1,
		}, -- end of [1]
	}, -- end of engines_nozzles
	crew_size	 = 1,
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	17,
			drop_canopy_name	=	"F-2A-FONAR",
			pos        = {4.7, 0.6, 0},
			canopy_pos = {3.66, 0.93, 0}, -- t[㉺[̈ʒu
		}, -- end of [1]
	}, -- end of crew_members

	fires_pos = 
	{
		[1] = 	{-0.707,	0.553,	-0.213},
		[2] = 	{0.310,	0.433,	2.161},
		[3] = 	{0.160,	0.433,	-2.204},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	4.274},
		[7] = 	{-0.82,	0.255,	-4.274},
		[8] = 	{-5.003,	0.261,	0},
		[9] = 	{-5.003,	0.261,	0},
		[10] = 	{-0.836,	0.433,	1.780},
		[11] = 	{-0.864,	0.433,	-2.107},
	}, -- end of fires_pos
	
	
	-- Countermeasures
--	SingleChargeTotal	 	= 120,
--	CMDS_Incrementation 	= 4,
--	ChaffDefault 			= 64, 
--	ChaffChargeSize 		= 1,
--	FlareDefault 			= 64, 
--	FlareChargeSize 		= 1,
--	CMDS_Edit 				= true,
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 240,
		-- RR-170
		chaff = {default = 120, increment = 30, chargeSz = 1},
		-- MJU-7
		flare = {default = 60, increment = 15, chargeSz = 2}
    },
	chaff_flare_dispenser 	= 
	{
		[1] = 
		{
			dir =  {0, -1, -1},
			pos =  {-3, -1, 2},
		}, -- end of [1]
		[2] = 
		{
			dir =  {0, -1, 1},
			pos =  {-3, -1, -2},
		}, -- end of [2]
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 160,
	radar_can_see_ground 	 = true, -- this should be examined (what is this exactly?)
	CanopyGeometry = 
	{
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
    Sensors = {
		RADAR = "AN/APG-73",
		RWR = "Abstract RWR"
    },
	Countermeasures = {
		ECM = "AN/ALQ-135"
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	
	Guns = 
	{
	    gun_mount("M_61", { count = 511 },{muzzle_pos = {3.183,  0.50,-0.79}})
	},
	
		Pylons = 
	{
		pylon(1, 0, -0.700000, 0.500000, -5.630000,
		{
			FiZ = 0,
		},
		{
			{ CLSID = "{AAM4A}" },
			{ CLSID = "{AAM3A}" },
			--{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" },
			{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
			{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" },
		}
		),
		pylon(2, 0, -0.500000, 0.020000, -3.850000,
		{
			FiZ = -1,
		},
		{
			{ CLSID = "{AAM4A}" }, -- AAM4A
			{ CLSID = "{AAM3A}" },
			{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, -- AIM-7M
			{ CLSID = "LAU-127_AIM-9M" }, -- AIM-9M
			{ CLSID = "{AIM-9P-ON-ADAPTER}" }, -- AIM-9P
			--{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			--{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			--{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			--{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			--{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			--{ CLSID = "{CBU_103}" },
			--{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			--{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			--{ CLSID = "ASM_2" },
			--{ CLSID = "ASM_3" ,Type = 1},
		}
		),
		pylon(3, 0, -0.200000, 0.020000, -2.950000,
		{
			FiZ = -1,
		},
		{
			{ CLSID = "{AAM4A}" }, -- AAM4A
			{ CLSID = "{AAM3A}" },
			{ CLSID = "{LAU_115_2xAAM4A}" }, -- AAM4A*2
			{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, -- AIM-7M
			{ CLSID = "LAU-127_AIM-9M" }, -- AIM-9M
			{ CLSID = "{AIM-9P-ON-ADAPTER}" }, -- AIM-9P
			{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			{ CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" }, -- AGM-65K*3
			{ CLSID = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}" }, -- AGM-65D*3
			{ CLSID = "{71AAB9B8-81C1-4925-BE50-1EF8E9899271}" }, -- AGM-65E*3
			{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}" }, -- GBU-10
			{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			{ CLSID = "{GBU-31}" },
			{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			{ CLSID = "{CBU_103}" },
			{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, -- MK-84
			{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" }, -- MK-82*3
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			{ CLSID = "ASM_2" },
			{ CLSID = "ASM_3" ,Type = 1},
		}
		),
		pylon(4, 0, 0.350000, 0.065000, -1.750000,
		{
			FiZ = -2.0,
			use_full_connector_position=true,
		},
		{
			--{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" }, -- AIM-120B
			--{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" }, -- AIM-120C
			--{ CLSID = "LAU-127_AIM-9M" }, -- AIM-9M
			--{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, -- AIM-9P
			{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			{ CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" }, -- AGM-65K*3
			{ CLSID = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}" }, -- AGM-65D*3
			{ CLSID = "{71AAB9B8-81C1-4925-BE50-1EF8E9899271}" }, -- AGM-65E*3
			{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}" }, -- GBU-10
			{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			{ CLSID = "{GBU-31}" },
			{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			{ CLSID = "{CBU_103}" },
			{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, -- MK-84
			{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" }, -- MK-82*3
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			{ CLSID = "F_2_TANK_W" },
		}
		),
		pylon(5, 0, 0.000000, 0.100000, 0.000000,
		{
		},
		{
			--{ CLSID = "{CAAC1CFD-6745-416B-AFA4-CB57414856D0}" },
		}
		),
		pylon(6, 0, -0.050000, -0.690000, 0.000000,
		{
			use_full_connector_position=true,
		},
		{
			{ CLSID = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}" },
			{ CLSID = "F_2_TANK_C" },
		}
		),
		pylon(7, 0, 0.350000, 0.065000, 1.750000,
		{
			FiZ = -2.0,
			use_full_connector_position=true,
		},
		{
			--{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" }, -- AIM-120B
			--{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" }, -- AIM-120C
			--{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, -- AIM-9M
			--{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, -- AIM-9P
			{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			{ CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" }, -- AGM-65K*3
			{ CLSID = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}" }, -- AGM-65D*3
			{ CLSID = "{71AAB9B8-81C1-4925-BE50-1EF8E9899271}" }, -- AGM-65E*3
			{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}" }, -- GBU-10
			{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			{ CLSID = "{GBU-31}" },
			{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			{ CLSID = "{CBU_103}" },
			{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, -- MK-84
			{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" }, -- MK-82*3
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			{ CLSID = "F_2_TANK_W" },
		}
		),
		pylon(8, 0, -0.200000, 0.020000, 2.950000,
		{
			FiZ = -1,
		},
		{
			{ CLSID = "{AAM4A}" }, -- AAM4A
			{ CLSID = "{AAM3A}" },
			{ CLSID = "{LAU_115_2xAAM4A}" }, -- AAM4A*2
			{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, -- AIM-7
			{ CLSID = "LAU-127_AIM-9M" }, -- AIM-9M
			{ CLSID = "{AIM-9P-ON-ADAPTER}"}, -- AIM-9P
			{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			{ CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" }, -- AGM-65K*3
			{ CLSID = "{DAC53A2F-79CA-42FF-A77A-F5649B601308}" }, -- AGM-65D*3
			{ CLSID = "{71AAB9B8-81C1-4925-BE50-1EF8E9899271}" }, -- AGM-65E*3
			{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}" }, -- GBU-10
			{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			{ CLSID = "{GBU-31}" },
			{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			{ CLSID = "{CBU_103}" },
			{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, -- MK-84
			{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" }, -- MK-82*3
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			{ CLSID = "ASM_2" },
			{ CLSID = "ASM_3" ,Type = 1},
		}
		),
		pylon(9, 0, -0.500000, 0.020000, 3.850000,
		{
			FiZ = -1,
		},
		{
			{ CLSID = "{AAM4A}" }, -- AAM4A
			{ CLSID = "{AAM3A}" },
			--{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" }, -- AIM-120C
			{ CLSID = "LAU-127_AIM-9M" }, -- AIM-9M
			{ CLSID = "{AIM-9P-ON-ADAPTER}" }, -- AIM-9P
			--{ CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" }, -- AGM-65K
			--{ CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" }, -- AGM-65D
			--{ CLSID = "{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}" }, -- AGM-65E
			--{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}" }, -- GBU-12
			--{ CLSID = "{GBU-38}" },
			{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, -- CBU-97
			--{ CLSID = "{CBU_103}" },
			--{ CLSID = "{CBU_105}" },
			{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, -- Mk-82
			--{ CLSID = "{D5D51E24-348C-4702-96AF-97A714E72697}" }, -- MK-82*2
			{ CLSID = "LAU3_HE151" }, -- LAU-3 HE
			{ CLSID = "LAU3_WP156" }, -- LAU-3 WP
			--{ CLSID = "ASM_2" },
			--{ CLSID = "ASM_3" ,Type = 1},
		}
		),
		pylon(10, 0, -0.700000, 0.500000, 5.630000,
		{
			FiZ = 0,
		},
		{
			{ CLSID = "{AAM4A}" },
			{ CLSID = "{AAM3A}" },
			--{ CLSID = "{AIM-9P-ON-ADAPTER}" },
			{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
			{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" },
		}
		),
	},
	
	Tasks = 
	{
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(AFAC),
		aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	--  \Scripts\Database\SFM_Data.lua̗ގ̋@̃f[^Q 	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0,      -- zero AoA lift coefficient
			Mzalfa		=	4.355,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.75,    
			kjz			=	0.00125, 
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0268,    -- coefficient, drag, gear
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	0.52,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{	--      M		Cx0		 	Cya			B		 	B4	    	Omxmax		Aldop		Cymax
				[1] = 	{0,	0.0165,	0.07,	0.132,	0.032,	0.5,	30,	1.2},
				[2] = 	{0.2,	0.0165,	0.07,	0.132,	0.032,	1.5,	30,	1.2},
				[3] = 	{0.4,	0.0165,	0.07,	0.133,	0.032,	2.5,	30,	1.2},
				[4] = 	{0.6,	0.0165,	0.073,	0.133,	0.043,	3.5,	30,	1.2},
				[5] = 	{0.7,	0.017,	0.076,	0.134,	0.045,	3.5,	28.666666666667,	1.18},
				[6] = 	{0.8,	0.024,	0.079,	0.137,	0.052,	3.5,	27.333333333333,	1.16},
				[7] = 	{0.9,	0.041,	0.083,	0.143,	0.058,	3.5,	26,	1.14},
				[8] = 	{1,	0.062,	0.085,	0.18,	0.1,	3.5,	24.666666666667,	1.12},
				[9] = 	{1.05,	0.061,	0.0855,	0.1975,	0.095,	3.5,	24,	1.11},
				[10] = 	{1.1,	0.06,	0.086,	0.215,	0.09,	3.15,	18,	1.1},
				[11] = 	{1.2,	0.051,	0.083,	0.228,	0.12,	2.45,	17,	1.05},
				[12] = 	{1.3,	0.046,	0.077,	0.237,	0.17,	1.75,	16,	1},
				[13] = 	{1.49,	0.044,	0.062,	0.251,	0.2,	1.5125,	13.15,	0.905},
				[14] = 	{1.5,	0.043903225806452,	0.061483870967742,	0.25064516129032,	0.2058064516129,	1.5,	13,	0.9},
				[15] = 	{1.7,	0.041967741935484,	0.051161290322581,	0.24354838709677,	0.32193548387097,	0.9,	12,	0.7},
				[16] = 	{1.8,	0.041,	0.046,	0.24,	0.38,	0.86,	11.4,	0.64},
				[17] = 	{2,	0.042,	0.039,	0.222,	2.5,	0.78,	10.2,	0.52},
				[18] = 	{2.2,	0.041,	0.034,	0.227,	3.2,	0.7,	9,	0.4},
				[19] = 	{2.5,	0.039,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
				[20] = 	{3.9,	0.035,	0.033,	0.35,	6,	0.7,	9,	0.4},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	0.85, -- Military power state of the throttle
			ForsRUD	=	0.91, -- Afterburner state of the throttle
			typeng	=	1,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN = 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	19, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0144, -- Engine drag coeficient
			cemax	=	1.24, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	2.56, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	6200, --  altitude coefficient for max thrust
			dpdh_f	=	9500,  --  altitude coefficient for AB thrust
			table_data = 
			{		--   M		Pmax		 Pfor	
				[1] = 	{0,	77000,	108313.6},
				[2] = 	{0.2,	74000,	109850},
				[3] = 	{0.4,	74000,	115227.3},
				[4] = 	{0.6,	85000,	126750},
				[5] = 	{0.7,	85000,	145000},
				[6] = 	{0.8,	90000,	157000},
				[7] = 	{0.9,	94000,	166000},
				[8] = 	{1,	100000,	170000},
				[9] = 	{1.096,	96000,	171000},
				[10] = 	{1.2,	86000,	171000},
				[11] = 	{1.3,	68000,	173000},
				[12] = 	{1.4,	55000,	176000},
				[13] = 	{1.6,	56000,	176000},
				[14] = 	{1.8,	56000,	184000},
				[15] = 	{2.2,	52000,	173000},
				[16] = 	{2.35,	43000,	157000},
				[17] = 	{3.9,	25000,	120636.4},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	}, -- end of SFM_Data

	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = 
	{
		[59] = {critical_damage = 3, args = {148}}, -- NOSE_BOTTOM
		[1]  = {critical_damage = 3, args = {150}}, -- NOSE_LEFT_SIDE
		[2]  = {critical_damage = 3, args = {149}}, -- NOSE_RIGHT_SIDE
		[3]  = {critical_damage = 10, args = {65}}, -- COCKPIT
		[4]  = {critical_damage = 5, args = {154}}, -- CABIN_LEFT_SIDE
		[5]  = {critical_damage = 5, args = {153}}, -- CABIN_RIGHT_SIDE
		[6]  = {critical_damage = 5, args = {152}}, -- CABIN_BOTTOM
		[11] = {critical_damage = 3},
		[12] = {critical_damage = 3},
		[99] = {critical_damage = 5, args = {151}}, -- FUSELAGE_TOP
		[82] = {critical_damage = 5, args = {155}}, -- FUSELAGE_BOTTOM
		[56] = {critical_damage = 5, args = {158}}, -- TAIL_LEFT_SIDE
		[57] = {critical_damage = 5, args = {157}}, -- TAIL_RIGHT_SIDE
		[58] = {critical_damage = 5, args = {156}}, -- TAIL_BOTTOM
		[35] = {critical_damage = 5, args = {67}, deps_cells = {37}}, -- WING_L
		[36] = {critical_damage = 5, args = {68}, deps_cells = {38}}, -- WING_R
		[37] = {critical_damage = 2, args = {53}}, -- FLAP_L
		[38] = {critical_damage = 2, args = {54}}, -- FLAP_R
		[43] = {critical_damage = 2, args = {61}, deps_cells = {53}}, -- FIN_L_BOTTOM
		[51] = {critical_damage = 2, args = {59}}, -- ELEVATOR_L
		[52] = {critical_damage = 2, args = {60}}, -- ELEVATOR_R
		[53] = {critical_damage = 2, args = {57}}, -- RUDDER_L
	},  -- end of Damage
	
	DamageParts = 
	{  
		[1] = "F-2-OBLOMOK-WING-R",
		[2] = "F-2-OBLOMOK-WING-L",
	},


	lights_data = 
	{
		typename = "collection",
		lights = 
		{
			[1] = -- Xg{Cg
			{
		    	typename = "collection",
				lights = 
				{
					-- Left Anticollision Light
					{typename = "natostrobelight",
					connector = "WHITE_BEACON L",
					color = {1.0, 1.0, 1.0},
					argument_1 = 195,
					period = 1.2,
					phase_shift = 0
					}
				}
			},
			[2] = -- fBOCg
			{
				typename = "collection",
				lights =
				{
					{-- Landing/Taxi light
					typename = "spotlight",
					connector = "MAIN_SPOT_PTR_01",
					color = {1.0, 1.0, 1.0},
					argument = 208,
					dir_correction = {elevation = math.rad(3)}
					}
				}
			},
		    [3]	= -- irQ[VCg
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					connector = "BANO_1",
					color = {0.99, 0.11, 0.3},
					position  = {-1.4, 0.4, -5.4},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					connector = "BANO_2",
					color = {0, 0.894, 0.6},
					position  = {-1.4, 0.4, 5.4},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					connector = "BANO_0_BACK",
					color = {0.5, 0.5, 0.5},
					position  = {1.93, -0.94, 0},
					argument  = 203
					}
				}
			},
		    [4] = -- tH[[VCg
			{
		    	typename = "collection",
				lights = 
				{
--[[
					-- Tail formation lights
					{
						typename = "collection",
						lights =  -- Ƃ炷Cg
						{
							{
								-- Right Tail Formation Light
								typename = "spotlight",
								connector = "BANO_W_HR",
								color = {1.0, 1.0, 1.0},
								intensity_max = 6,
								angle_max = 0.3,
								argument = 205,
								dont_change_color = false,
								angle_change_rate = 0,
								pos_correction = {0.0, 0.0, 0.0},
								dir_correction = {azimuth = math.rad(130), elevation = math.rad(-20)}
							},
							{
								-- Left Tail Formation Light
								typename = "spotlight",
								connector = "BANO_W_HL",
								color = {1.0, 1.0, 1.0},
								intensity_max = 6,
								angle_max = 0.3,
								argument = 204,
								dont_change_color = false,
								angle_change_rate = 0,
								pos_correction = {0.0, 0.0, 0.0},
								dir_correction = {azimuth = math.rad(130), elevation = math.rad(20)}
							}
						}
					},
--]]
					-- я̃tH[[VCg
					{typename  = "argumentlight", argument = 200}
				}
			},
			[5]	=
			{
			}
		}
	},  -- end of lights_data
	

}
add_aircraft(F_2A)
