--dofile(LockOn_Options.script_path.."../Common/Macro_sequencies_common.lua")
dofile(LockOn_Options.script_path.."../Common/command_defs.lua") -- Common command_defs
dofile(LockOn_Options.script_path.."../Common/devices_common.lua") -- Common devices
dofile(LockOn_Options.script_path.."devices.lua") -- Aircraft-specific devices


std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local dt = 0.2 -- Default interval between commands in the stack.
local dt_mto = 10.0 -- Default message timeout time.
local start_sequence_time = 2 * 60 + 25 -- Quick startup takes about 2m25s
local stop_sequence_time = 0 * 60 + 20 -- Quick shutdown takes about 0m20s
local tarsyn_sync_time = 2* 60 + 5 -- TARSYN sync time, 2m5s, starts when Inverter switch is set to NORM.
local tarsyn_sync_timer = 0 -- Initialize the timer.

start_sequence_full	= {}
stop_sequence_full	= {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] = command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end

local count = 0
local function counter()
	count = count + 1
	return count
end

-- conditions to be added if pre auto start conditions are desired ie Thrust lever closed values taken from L39C format

count = -1
AVIOJET_AD_COMMON = counter();
AVIOJET_AD_ENGINE_START_RPM = counter();
AVIOJET_AD_ENGINE_RPM = counter();
AVIOJET_AD_THROTTLE_SET_TO_STOP = counter();
AVIOJET_AD_THROTTLE_SET_TO_IDLE = counter();
AVIOJET_AD_THROTTLE_AT_STOP = counter();
AVIOJET_AD_THROTTLE_AT_IDLE = counter();
AVIOJET_AD_ERROR = counter();
AVIOJET_AD_GROUND_SUPPLY_ON = counter();
AVIOJET_AD_GROUND_SUPPLY_OFF = counter();
AVIOJET_AD_GROUND_SUPPLY_IS_ON = counter();

--
alert_messages = {}
alert_messages[AVIOJET_AD_COMMON] = { message = _("AVIOJET ERROR"), message_timeout = 10}
alert_messages[AVIOJET_AD_ENGINE_START_RPM] = { message = _("ENGINE START RPM FAILURE"), message_timeout = 10}
alert_messages[AVIOJET_AD_ENGINE_RPM] = { message = _("ENGINE RPM FAILURE"), message_timeout = 10}
alert_messages[AVIOJET_AD_THROTTLE_SET_TO_STOP] = { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[AVIOJET_AD_THROTTLE_SET_TO_IDLE] = { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[AVIOJET_AD_THROTTLE_AT_STOP] = { message = _("THROTTLE MUST BE AT STOP"), message_timeout = 10}
alert_messages[AVIOJET_AD_THROTTLE_AT_IDLE] = { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[AVIOJET_AD_ERROR] = { message = _("FM MODEL ERROR"), message_timeout = 10}
alert_messages[AVIOJET_AD_GROUND_SUPPLY_ON] = { message = _("GROUND SUPPLY ON"), message_timeout = 10}
alert_messages[AVIOJET_AD_GROUND_SUPPLY_OFF] = { message = _("GROUND SUPPLY OFF"), message_timeout = 10}
alert_messages[AVIOJET_AD_GROUND_SUPPLY_IS_ON] = { message = _("NO GROUND ELECTRIC POWER"), message_timeout = 10}


-- Determine whether we're in the C-101CC or the C-101EB by checking which radios are available.  Depending on which plane, we'll turn on a few different systems during the startup.
local airplaneName = ''
if devices.VTWU740 and devices.VHF20B then
	airplaneName = 'C-101CC'
elseif devices.ARC164 and devices.ARC134 then -- IMPORTANT Use 'elseif', not 'else if', or it doesn't work.
	airplaneName = 'C-101EB'
end

-- FIXME This could probably be more efficient than having two functions, but not quite sure how...
local function turnOnRadios()
	if airplaneName == 'C-101CC' then
		-- V/TVU-740 radio, front instrument panel
		push_start_command(dt, {message = _("V/TVU-740 V/UHF radio - On"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.VTWU740, action = device_commands.Button_7, value = 0.1}) -- 0.0 = OFF, 0.1 = A3 (on), 0.2 = A3+G (on+guard), 0.3 = DF (not implemented)
		
		--  VHF-20B radio, right console
		push_start_command(dt, {message = _("VHF-20B VHF radio - On"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.VHF20B, action = device_commands.Button_4, value = 0.5}) -- 0.0 = OFF, 0.5 = PWR, 1.0 = TEST
	elseif airplaneName == 'C-101EB' then
		-- ARC-164(V) radio, front instrument panel
		push_start_command(dt, {message = _("ARC-164(V) UHF radio - On"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.ARC164, action = device_commands.Button_8, value = 0.25}) -- 0.0 = OFF, 0.25 = MAIN, 0.5 = BOTH, 0.75 = ADF
		
		-- ARC-134 radio, right console
		push_start_command(dt, {message = _("ARC-134 VHF radio - On"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.ARC134, action = device_commands.Button_1, value = 1.0}) -- 0.0 = OFF, 1.0 = ON
	end
end
local function turnOffRadios()
	if airplaneName == 'C-101CC' then
		-- V/TVU-740 radio, front instrument panel
		push_stop_command(dt, {message = _("V/TVU-740 V/UHF radio - Off"), message_timeout = dt_mto})
		push_stop_command(dt, {device = devices.VTWU740, action = device_commands.Button_7, value = 0.0}) -- 0.0 = OFF, 0.1 = A3 (on), 0.2 = A3+G (on+guard), 0.3 = DF (not implemented)
		
		--  VHF-20B radio, right console
		push_stop_command(dt, {message = _("VHF-20B VHF radio - Off"), message_timeout = dt_mto})
		push_stop_command(dt, {device = devices.VHF20B, action = device_commands.Button_4, value = 0.0}) -- 0.0 = OFF, 0.5 = PWR, 1.0 = TEST
	elseif airplaneName == 'C-101EB' then
		-- ARC-164(V) radio, front instrument panel
		push_stop_command(dt, {message = _("ARC-164(V) UHF radio - Off"), message_timeout = dt_mto})
		push_stop_command(dt, {device = devices.ARC164, action = device_commands.Button_8, value = 0.0}) -- 0.0 = OFF, 0.25 = MAIN, 0.5 = BOTH, 0.75 = ADF
		
		-- ARC-134 radio, right console
		push_stop_command(dt, {message = _("ARC-134 VHF radio - Off"), message_timeout = dt_mto})
		push_stop_command(dt, {device = devices.ARC134, action = device_commands.Button_1, value = 0.0}) -- 0.0 = OFF, 1.0 = ON
	end
end

local function turnOnGunsight()
	if airplaneName == 'C-101CC' then
		-- Gunsight
		push_start_command(dt, {message = _("Gunsight - On, Man"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_318, value = 1.0}) -- 0.0 = OFF, 1.0 = ON
		push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_317, value = 0.5}) -- 1.0 = AUTO, 0.5 = MAN, 0.0 = TEST (momentary, so set back to 0.5 afterwards if used)
	end
end
local function turnOffGunsight()
	if airplaneName == 'C-101CC' then
		-- Gunsight
		push_stop_command(dt, {message = _("Gunsight - Off, Auto"), message_timeout = dt_mto})
		push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_318, value = 0.0}) -- 0.0 = OFF, 1.0 = ON
		push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_317, value = 1.0}) -- 1.0 = AUTO, 0.5 = MAN, 0.0 = TEST (momentary, so set back to 0.5 afterwards if used)
	end
end


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence
local function doStartSequence()
	push_start_command(0.0, {message = _(airplaneName.." -- HAVOC'S QUICK AUTOSTART SEQUENCE IS RUNNING (2m25s)"), message_timeout = start_sequence_time})

	push_start_command(dt, {message = _("Circuit breakers - All in"), message_timeout = dt_mto})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_54, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_55, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_56, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_57, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_58, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_59, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_60, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_61, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_62, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_63, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_64, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_65, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_66, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_67, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_68, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_69, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_70, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_71, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_72, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_73, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_74, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_75, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_76, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_77, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_78, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_79, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_80, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_81, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_82, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_83, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_84, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_85, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_86, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_87, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_88, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_89, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_90, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_91, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_92, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_93, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_94, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_95, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_96, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_97, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_98, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_99, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_100, value = 0.0})
	push_start_command(0.0, {device = devices.SYSTEMS, action = device_commands.Button_101, value = 0.0})
	
	push_start_command(dt, {message = _("Ignition - Off"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_115, value = 0.0})

	push_start_command(dt, {message = _("Parking brake - Set"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_238, value = 1.0})
	
	push_start_command(dt, {message = _("Ground power supply - On (waiting 12s)"), message_timeout = 12, check_condition = AVIOJET_AD_GROUND_SUPPLY_ON})
	push_start_command(12.0, {message = _("Ground power is on"), message_timeout = dt_mto})
	
	push_start_command(dt, {message = _("Accelerometer - Reset"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_42, value = 1.0})

	push_start_command(dt, {message = _("Oxygen valve lever (Front seat) - Open"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_117, value = 1.0})
	push_start_command(dt, {message = _("Oxygen valve lever (Rear seat) - Open"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_429, value = 1.0})

	------- START UP
	push_start_command(dt, {message = _("Battery switch - On"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_1, value = 1.0})
	
	-- Reset MASTER WARNING and MASTER CAUTION
	push_start_command(dt, {message = _("MASTER WARNING - Reset"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 0.0})
	push_start_command(dt, {message = _("MASTER CAUTION - Reset"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 0.0})
	
	-- Radios
	turnOnRadios()
	
	-- Ground power on
	push_start_command(dt, {message = _("GPU - On (3s)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_38, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_38, value = 0.0})
	push_start_command(3.0, {message = _("Ground power supply is revved up"), message_timeout = dt_mto})

	push_start_command(dt, {message = _("Bus tie switch - On"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_6, value = 1.0})

	-- Reset MASTER WARNING and MASTER CAUTION
	push_start_command(dt, {message = _("MASTER WARNING - Reset"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 0.0})
	push_start_command(dt, {message = _("MASTER CAUTION - Reset"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 0.0})
	
	push_start_command(dt, {message = _("Inverter switch - Normal"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_9, value = 1.0})
	push_start_command(dt, {message = _("Waiting for TARSYN syncronization (2m5s)"), message_timeout = tarsyn_sync_time})
	tarsyn_sync_timer = t_start -- Start a timer for the TARSYN sync at the current t_start value.

	push_start_command(dt, {message = _("Transfer pump switches - Auto"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_50, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_51, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_52, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_53, value = 1.0})

	push_start_command(dt, {message = _("Fuselage tank pump button - On"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_44, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_46, value = 0.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_46, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_44, value = 0.0}) -- Cover close

	push_start_command(dt, {message = _("Fuel shutoff valve button - On (fuel flow enabled)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_45, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_47, value = 0.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_47, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_45, value = 0.0}) -- Cover close

	push_start_command(dt, {message = _("STARTING ENGINE (37s)"), message_timeout = 37})

	push_start_command(dt, {message = _("Ignition switch - Start (2s)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_115, value = 1.0})
	push_start_command(2.0, {device = devices.SYSTEMS, action = device_commands.Button_115, value = 0.0})

	push_start_command(dt, {message = _("At 10% N2: power lever - Idle"), message_timeout = dt_mto})
	push_start_command(5.0, {device = devices.SYSTEMS, action = 8014, value = 0.0})

	push_start_command(dt, {message = _("Wait for engine instruments to stabilize (30s)"), message_timeout = 30})
	push_start_command(30.0, {message = _("Engine instruments - Stabilized"), message_timeout = dt_mto})

	-- Ground power off
	push_start_command(dt, {message = _("GPU - Off"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_38, value = 0.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_38, value = 1.0})
	push_start_command(dt, {message = _("Ground power supply is off"), check_condition = AVIOJET_AD_GROUND_SUPPLY_OFF})

	push_start_command(dt, {message = _("Generator - Reset, then On"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_10, value = 0.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_10, value = 1.0})
	
	-- IFF
	push_start_command(dt, {message = _("IFF Master switch - NORM"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_204, value = 0.25}) -- 0.0 = EMER, 0.25 = NORM, 0.5 = LOW, 0.75 = STBY, 1.0 = OFF
	push_start_command(dt, {message = _("IFF Mode 4 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_211, value = 1.0})

	push_start_command(dt, {message = _("Standby artificial horizon - Uncage"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_241, value = 0.5})
	
	-- Gunsight (C-101CC only)
	turnOnGunsight()

	push_start_command(dt, {message = _("Flaps - Takeoff"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_224, value = 0.5})

	push_start_command(dt, {message = _("Canopy - Close and lock"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_40, value = 1.0}) -- Canopy safety latch
	push_start_command(3.2, {device = devices.SYSTEMS, action = device_commands.Button_41, value = 1.0})
	
	push_start_command(dt, {message = _("Air conditioning - Reset and On"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_120, value = 0.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_120, value = 1.0})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_124, value = 0.5})
	
	push_start_command(dt, {message = _("Ejection seat safety pin (Front seat) - Remove"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_246, value = 1.0})
	push_start_command(dt, {message = _("Ejection seat safety pin (Rear seat) - Remove"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_520, value = 1.0})
	
	-- Canopy Fracture Safety Pin (C-101CC only) (right console) -- FIXME Can't get this to be pulled automatically.  Can still eject even when pin is in though.
	--push_start_command(dt, {message = _("Canopy fracture satefy pin (Front seat) - Remove"), message_timeout = dt_mto})
	--push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_40, value = -1.0})
	--push_start_command(dt, {message = _("Canopy fracture satefy pin (Rear seat) - Remove"), message_timeout = dt_mto})
	--push_start_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_508, value = -1.0})

	-- Wait until the TARSYN sync is complete (total process time minus the difference between now and when the process started).
	push_start_command(tarsyn_sync_time - (t_start - tarsyn_sync_timer), {message = _("HAVOC'S QUICK AUTOSTART COMPLETE"), message_timeout = 60})

	push_start_command(dt, {message = _("Manual steps remaining:"), message_timeout = 60})
	push_start_command(dt, {message = _("Lights ... As needed"), message_timeout = 60})
	push_start_command(dt, {message = _("Radios ... As needed"), message_timeout = 60})
	push_start_command(dt, {message = _("Navigation ... As needed"), message_timeout = 60})
	push_start_command(dt, {message = _("Set altimeter to match QFE (airfield elevation) or QNH (sea level altitude) as desired"), message_timeout = 60})
end
doStartSequence()


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Stop sequence
local function doShutdownSequence()
	push_stop_command(0.0, {message = _("HAVOC'S QUICK AUTOSTOP SEQUENCE IS RUNNING (20s)"), message_timeout = stop_sequence_time})
	
	-- Master caution/warning reset
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0}) -- MC
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 1.0}) -- MW

	push_stop_command(dt, {message = _("Parking brake - Set"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_238, value = 1.0})

	--push_stop_command(dt, {message = _("Power lever - Idle"), message_timeout = dt_mto})

	--push_stop_command(dt, {message = _("Speed brake - Asrequired"), message_timeout = dt_mto})

	push_stop_command(dt, {message = _("Flaps - Up (4s)"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_224, value = 0.0})
	push_stop_command(4.0, {message = _("Flaps are up"), message_timeout = dt_mto})

	push_stop_command(dt, {message = _("Standby horizon - Cage"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_241, value = 1.0})

	-- Radios
	turnOffRadios()
	
	-- Gunsight (C-101CC only)
	turnOffGunsight()
	
	-- IFF
	push_stop_command(dt, {message = _("IFF Master switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_204, value = 1.0}) -- 0.0 = EMER, 0.25 = NORM, 0.5 = LOW, 0.75 = STBY, 1.0 = OFF
	push_stop_command(dt, {message = _("IFF Mode 4 switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_211, value = 0.0})

	push_stop_command(dt, {message = _("Air conditioning - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_124, value = 0.0})

	push_stop_command(dt, {message = _("Canopy - Open"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_41, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0}) -- MC
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_40, value = 0.0}) -- Canopy safety latch

	push_stop_command(dt, {message = _("Fuel boost pump switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_44, value = 1.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_46, value = 1.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_46, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_44, value = 0.0})

	-- Master caution/warning reset
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0}) -- MC
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 1.0}) -- MW

	push_stop_command(dt, {message = _("Fuel transfer pump switches - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_50, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_51, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_52, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_53, value = 0.0})

	push_stop_command(dt, {message = _("Throttle - Stop"), message_timeout = dt_mto})
	push_stop_command(1, {device = devices.SYSTEMS, action = 8014, value = -1.0})

	push_stop_command(dt, {message = _("Fuel shutoff valve switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_45, value = 1.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_47, value = 1.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_47, value = 0.0})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_45, value = 0.0})

	-- Master caution/warning reset
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_16, value = 1.0}) -- MC
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_18, value = 1.0}) -- MW

	push_stop_command(dt, {message = _("Inverter switch  - Standby"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_9, value = 0.5})

	push_stop_command(dt, {message = _("Generator switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_10, value = 0.5})

	push_stop_command(dt, {message = _("Bus tie switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_6, value = 0.0})
	
	push_stop_command(dt, {message = _("Battery switch - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_1, value = 0.0})

	push_stop_command(dt, {message = _("External lights - Off"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.LIGHTS, action = device_commands.Button_106, value = 0.0}) -- Anticollision beacon
	push_stop_command(dt, {device = devices.LIGHTS, action = device_commands.Button_107, value = 0.5}) -- Nav lights
	push_stop_command(dt, {device = devices.LIGHTS, action = device_commands.Button_108, value = 0.5}) -- Formation lights
	push_stop_command(dt, {device = devices.LIGHTS, action = device_commands.Button_109, value = 0.0}) -- Left taxi/landing light
	push_stop_command(dt, {device = devices.LIGHTS, action = device_commands.Button_110, value = 0.0}) -- Right taxi/landing light
	
	push_stop_command(dt, {message = _("Oxygen valve lever (Front seat) - Close"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_117, value = 0.0})
	push_stop_command(dt, {message = _("Oxygen valve lever (Rear seat) - Close"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SYSTEMS, action = device_commands.Button_429, value = 0.0})

	push_stop_command(dt, {message = _("HAVOC'S QUICK AUTOSTOP COMPLETE"), message_timeout = 30})
end
doShutdownSequence()
