local explosivePercent = 0.4

--------------------------------------------------------------------------
--								AGM-154									--
--------------------------------------------------------------------------


--[[declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{AGM_154C}",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, 132},
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "agm154.png",
	displayName		= _("AGM-154C - JSOW Unitary BROACH"),
	Weight			= 485,
	Elements  		= {{ShapeName = "agm-154"}},
})]]


AGM_154A =
{
	category		= CAT_MISSILES,
	name			= "AGM_154A",
	user_name		= _("AGM-154B"),
	display_name_short = "AGM-154",
	scheme			= "JSOW_AB",
	class_name		= "wAmmunitionCruise",
	model			= "agm-154",
	mass			= 485,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 485.0,
	H_max			= 28000.0,
	H_min			= 300,
	Diam			= 400.0,
	Cx_pil			= 8,
	D_max			= 130000.0,
	D_min			= 5000.0,
	Head_Form		= 1,
	Life_Time		= 9999,
	Nr_max			= 10,
	v_min			= 150.0,
	v_mid			= 200.0,
	Mach_max		= 1.7,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 0.0,
	Range_max		= 132000.0,
	H_min_t			= 0.0,
	Fi_start		= 3.14152,
	Fi_rak			= 3.14152,
	Fi_excort		= 3.14152,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0.0,
	Y_back			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.05,
	KillDistance	= 0.0,
		
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		10500,	19000,	25400,	31300,	35100,	37700,	39600,	41300,	
		500,	0,		0,		12600,	20600,	29800,	32800,	36700,	39300,	41300,	43100,	
		700,	0,		0,		14100,	22300,	31600,	34300,	38200,	40900,	42700,	44400,	
		1000,	0,		9400,	16400,	25000,	34400,	36600,	40600,	43200,	45200,	47000,	
		2000,	12200,	18400,	25200,	34200,	44000,	44200,	48200,	51000,	53200,	55000,	
		3000,	21400,	27400,	34200,	43400,	51400,	51400,	55800,	58800,	61000,	63200,	
		4000,	30000,	36000,	42500,	52000,	58500,	58500,	63000,	66500,	68500,	71000,	
		5000,	38500,	44500,	52500,	60500,	65500,	65500,	70000,	73500,	76000,	79000,	
		6000,	46500,	53000,	61000,	68000,	76500,	76500,	76500,	81000,	83500,	86500,	
		7000,	54500,	61000,	68500,	76000,	83000,	83000,	83000,	87000,	90500,	94000,	
		8000,	61500,	67500,	76500,	83250,	86250,	88500,	88500,	93000,	96750,	100500,	
		9000,	69000,	75750,	84000,	90000,	90000,	97500,	99000,	99000,	102750,	107250,	
		10000,	73500,	78000,	83250,	87000,	98250,	99750,	100500,	104250,	108750,	113250,	
		11000,	87000,	92250,	97500,	102750,	105750,	107250,	108000,	109500,	114750,	119250,	
		12000,	93000,	99000,	104000,	109000,	112000,	114000,	114000,	114000,	119000,	124000,	
		13000,	100000,	105000,	110000,	114000,	117000,	119000,	120000,	121000,	121000,	128000,	
		14000,	105000,	111000,	115000,	120000,	123000,	125000,	126000,	126000,	127000,	130000,	
		15000,	111000,	116000,	121000,	125000,	128000,	130000,	130000,	131000,	132000,	133000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		7800,	8300,	8800,	9200,	9500,	11500,	13800,	15600,	
		500,	0,		0,		7900,	8500,	9100,	9300,	9600,	11500,	13800,	16700,	
		700,	0,		0,		8000,	8600,	9200,	9400,	9700,	10300,	10600,	11100,	
		1000,	0,		7600,	8200,	9000,	9400,	9600,	11600,	12400,	12800,	13200,	
		2000,	7800,	8200,	8800,	9400,	10000,	10000,	10400,	10600,	11200,	10800,	
		3000,	8400,	8800,	9400,	10000,	10600,	10600,	10800,	11000,	11600,	11400,	
		4000,	9500,	9500,	10000,	11000,	11500,	11500,	12000,	12000,	12000,	12000,	
		5000,	10000,	10500,	11000,	11500,	12000,	12000,	12000,	13500,	12500,	15000,	
		6000,	11000,	11500,	11500,	12000,	12500,	12500,	12500,	13000,	13000,	13000,	
		7000,	12000,	12000,	12000,	12500,	13000,	13000,	13000,	13500,	13500,	14000,	
		8000,	11250,	12000,	13500,	12750,	13500,	13500,	13500,	13500,	14250,	14250,	
		9000,	12750,	12750,	13500,	13500,	13500,	14250,	14250,	14250,	14250,	15000,	
		10000,	12750,	12750,	12750,	13500,	14250,	14250,	14250,	29250,	15000,	15000,	
		11000,	13500,	13500,	14250,	14250,	15000,	15000,	15000,	15000,	15000,	15750,	
		12000,	13000,	14000,	14000,	15000,	15000,	15000,	15000,	15000,	15000,	16000,	
		13000,	14000,	14000,	15000,	15000,	15000,	15000,	15000,	15000,	15000,	18000,	
		14000,	14000,	15000,	15000,	15000,	16000,	16000,	16000,	17000,	18000,	20000,	
		15000,	15000,	15000,	15000,	16000,	16000,	16000,	17000,	18000,	20000,	21000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		76.1,		130.7,	132.6,	150.3,	159.5,	165.7,	170.1,	173.9,	
		500,	0,		0,		95.3,		140.6,	194.5,	156.9,	167.1,	173.1,	178.1,	182.3,	
		700,	0,		0,		105.6,	153.3,	205.5,	164,	173.9,	180.5,	183.7,	186.9,	
		1000,	0,		75,		119.7,	177.6,	222.4,	174.8,	185.1,	190.7,	195.1,	198.8,	
		2000,	104.7,	136.7,	186.3,	233.4,	276.7,	209.6,	217.8,	223.9,	229,	231.1,	
		3000,	160.9,	192.1,	238.2,	281.6,	306,	237.4,	247.2,	254.1,	257.9,	262.1,	
		4000,	201.9,	237.3,	277,	320.1,	330.5,	265.7,	275.4,	285.4,	286.5,	291.4,	
		5000,	238.9,	277.6,	294.5,	356.5,	354.1,	292.9,	303.7,	311.8,	315.6,	322.3,	
		6000,	270.4,	316.6,	331.2,	383.2,	408.4,	378,	328.1,	342.4,	344.6,	349.7,	
		7000,	331.7,	350.4,	357.8,	414.5,	426.3,	397.3,	352.7,	363.1,	370.1,	376.9,	
		8000,	361,	372.2,	388.5,	438.3,	500.9,	512.1,	370.9,	383.3,	391.8,	397,	
		9000,	393.3,	412.6,	414.5,	408.3,	534.9,	566.1,	568.1,	404.8,	411.3,	419.8,	
		10000,	354.3,	358.7,	366,	366.8,	417.6,	415.5,	413.2,	424.5,	432,	439.5,	
		11000,	429.3,	435.4,	437.8,	446.1,	447.8,	445.3,	442.1,	441.1,	454.5,	459.7,	
		12000,	442.8,	457.1,	460.5,	468.9,	470.8,	471.6,	462.8,	455.2,	469,	475.9,	
		13000,	469.6,	476.4,	481.8,	483.3,	484.9,	485,	484,	483.6,	475.3,	493.5,	
		14000,	483,	498.8,	497.1,	506.8,	507.7,	506.9,	506.6,	498.2,	495.5,	500.4,	
		15000,	508.1,	515.1,	521.9,	523.6,	523.7,	522.8,	515.4,	514,	510.3,	504,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		50.3,	37.8,	32.3,	29.3,	27.4,	31.4,	36.8,	40.5,		
		500,	0,		0,		49.5,	37.7,	35.1,	29.1,	27.4,	31.2,	36.5,	45.1,		
		700,	0,		0,		46.8,	37,		34.8,	29.5,	27.8,	27.5,	26.4,	26,		
		1000,	0,		59.7,	44.5,	39.8,	34.6,	29.8,	33.7,	33.8,	33,		32,		
		2000,	58.9,	49.4,	42.5,	38.5,	35.7,	31.9,	32,		30.1,	36.1,	26.5,		
		3000,	56.3,	49.2,	43.8,	39.8,	36.8,	32.4,	31.4,	29.3,	29.1,	27,		
		4000,	58.9,	50.6,	44,		41.6,	39.5,	34.9,	35.5,	32.8,	31.1,	29.4,		
		5000,	59.3,	54,		47.3,	42.8,	40.3,	36.7,	36.3,	37.1,	33,		36.4,		
		6000,	61.8,	56.9,	48.9,	44.4,	42.1,	39.5,	38,		36.5,	34.4,	32,		
		7000,	64.2,	58,		51.2,	46.2,	44.9,	42.4,	39.2,	38.1,	35.8,	34.4,		
		8000,	60.5,	57.8,	56.2,	48.2,	47.1,	44.7,	42.2,	38.3,	37.8,	34.8,		
		9000,	65.4,	61.1,	57.8,	52.5,	48.1,	47.6,	45.7,	40.6,	38.1,	36.7,		
		10000,	66.2,	60.8,	56.1,	53.3,	50.6,	48.2,	46.4,	84.1,	40.2,	37.3,		
		11000,	67.2,	61.2,	58.3,	54.4,	53.2,	50.8,	48.9,	47.1,	40.9,	39.3,		
		12000,	66.5,	63.6,	58.9,	57.5,	54.5,	52.1,	50.1,	48.3,	42,		40.6,		
		13000,	70.3,	64.8,	62.6,	58.8,	55.9,	53.5,	51.4,	49.5,	47.4,	44,		
		14000,	71.3,	68.5,	64,		60.3,	59.3,	56.8,	54.6,	54.4,	53.9,	47.2,		
		15000,	75,		69.7,	65.4,	63.7,	60.7,	58,		57.7,	57.3,	58.3,	56.8,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		63.3,	75.3,	73.8,	77,		78.5,	83.4,	88.6,	92.4,		
		500,	0,		0,		69.2,	78.4,	96.7,	79.7,	81.4,	86,		91.3,	97.9,		
		700,	0,		0,		71.4,	81.5,	101.1,	82.3,	84,		85.5,	85.6,	86.2,		
		1000,	0,		65.8,	75,		87.5,	108.1,	86.1,	92,		93.8,	94.5,	95,		
		2000,	82,		87.7,	92.2,	104.2,	133.5,	99.3,	101.4,	102.3,	103.7,	102.2,	
		3000,	104.8,	109.8,	111.4,	121,	127.7,	112.3,	114.7,	115.8,	116.9,	116.2,	
		4000,	124,	128.9,	127.4,	137,	138.1,	125.7,	128.8,	130.3,	129.3,	129.1,	
		5000,	138.9,	147.5,	147.7,	150.8,	147.1,	137.7,	139.8,	144.2,	141.8,	147.2,	
		6000,	152.6,	165,	162.1,	161.5,	166.5,	157.6,	150.9,	155.1,	154.4,	154.2,	
		7000,	165.3,	178.7,	173.3,	173.2,	175.6,	167.8,	162.1,	165,	166.1,	167.4,	
		8000,	196.4,	186.8,	187.8,	183.2,	178.5,	176.1,	171.2,	174.2,	176.9,	177.1,	
		9000,	213.9,	203.1,	197.3,	192.6,	181.9,	192,	190.2,	184.8,	185.6,	187.9,	
		10000,	184.4,	183.2,	180.5,	178.5,	195,	192.5,	189.9,	222,	195.6,	195.7,	
		11000,	211.7,	210.4,	209,	208.3,	208,	205.4,	202.5,	200.5,	203.6,	205.5,	
		12000,	216.3,	219.9,	217.4,	218.6,	216.8,	215,	210.5,	206.3,	208.3,	211.2,	
		13000,	227,	227.3,	227.5,	224.8,	223,	220.9,	218.2,	215.6,	210.3,	219.1,	
		14000,	232.2,	237.1,	233.8,	233.2,	232.9,	230.7,	227.7,	224.9,	223,	223.7,	
		15000,	241.8,	243.2,	242.2,	241.6,	239,	236.6,	233.5,	232.2,	231.5,	227.7,	
	},
	
	shape_table_data =
	{
		{
			name	 = "AGM_154A",
			file	 = "AGM-154",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("AGM-154A"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	warhead		= simple_warhead(0),

	fm =	{
		mass				= 485,
		caliber				= 0.4,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 4.06,
		I					= 1000,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 1.2,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.6,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff = {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 2,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
		target_point_always_on_surface	= 0,
	},
	
	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},
	
	control_block2 ={
		delay							= 0.3,
		add_y							= 500,
		wind_k							= 0,
		use_snake_maneuver				= 1,
		max_no_vert_offset_open_h		= 90,
		vert_offset_before_end_game_k	= 0.8,	
		can_update_target_pos			= 0,
	},

	open_trigger = {
		delay							= 0.1,
		trigger_add_time				= 0.3,
		bomblet_char_time				= 24,
		chute_bomblet_char_time			= 150,
		chute_open_time					= 0.5,
		chute_cut_time					= 500,
		char_time_vel_correction_coeff	= 0,
		char_time_h_correction_coeff	= 0,
		default_add_y					= 180,
		out_w_add_y						= 0,
		wind_correction_coeff			= 1.5,
		time_coeff_data 				= {	41,		1.92,	--900
											32.4,	1.78,	--700
											23.8,	1.55,	--500
											21.6,	1.3,	--450
											20.0,	1.08,	--400
											17.3,	1.0,	--350
											15,		1.2,	--300
											13,		1.2,	--250
											9.8,	0.96,	--180
											5.8,	0.85	},--90
	},
	
	autopilot =	{
		delay						= 0.3,
		K							= 200,
		Ki							= 0.00005,
		Kg							= 6,
		nw_K						= 32,
		nw_Ki						= 0.00012,
		nw_Kg						= 1.8,
		finsLimit					= 0.8,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.25,
		egm_Angle_K					= 0.25,
		egm_FinAngle_K				= 0.32,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.3,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 1,
		err_limit		= 0.5,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 1.3,
		fins_limit_x	= 0.01,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 4.0,
		Kx				= 0.04,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.5,
		Kpj					= 0.5,	
	},

	launcher =
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster, 
		{
			scheme = 
			{
				dispenser = 
					{
						op_time					= 9000,
						wind_sigma				= 20,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 360,
						caliber					= 0.45,
						L						= 2.5,
						I						= 100,
						Ma						= 0.228,
						Mw						= 2.33,
						cx_coeff				= {1, 1, 1, 1, 2},
						model_name				= "agm-154",
						set_start_args			= {0,12,13},
						spawn_args_change		= {{1,12,0},{1,1,0.6}},
						spawn_time				= {0.02, 0.22, 0.42},
						spawn_weight_loss		= {0, 150, 150},
						spawm_args_change		= {{1,1,1},{1,12,0},{2,2,1}},
						op_spawns				= 3,
					},
	
					empty_dispenser = 
					{
						op_time					= 50,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 45,
						caliber					= 0.45,
						L						= 2.5,
						I						= 2,
						Ma						= 0.03,
						Mw						= 0.3,
						cx_coeff				= {1, 1, 1, 1, 2},
						model_name				= "agm-154",
						set_start_args			= {0, 1, 2},
						spawn_options			= {{2, 2, 1}},
					},
	
					BLU_108 =
					{
						op_time					= 9000,
						count					= 6,
						effect_count			= 6,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 2,
						mass					= 29.5,
						caliber					= 0.133,
						L						= 0.7,
						I						= 0.4,
						Ma						= 0.90985,
						Mw						= 1.67549,
						cx_coeff				= {1, 0.39, 0.38, 0.236, 1.31},
						model_name				= "cbu97_blu108",
						set_start_args			= {13},
						connectors_model_name	= "cbu97_shaft",
						explosion_impulse_coeff	= 42,
						explosion_center		= {{0.36,0,0},{-0.44,0,0}},
						release_rnd_coeff		= 7,
						chute_open_time			= 0.5,
						chute_diam				= 2,
						chute_Cx				= 1.2,
						chute_rnd_coeff			= 0.5,
						spawn_options			= {{0,1,3},{0,2,3}},
			
						submunition_engine_impulse			= 50,
						submunition_engine_fuel_mass		= 0.1,
						submunition_engine_work_time		= 0.22,
						submunition_engine_rotation_moment	= 9,
						submunition_engine_start_height		= 32,
						skeets_release_delay				= 1.05,
						skeets_in_seq_release_delay			= 0.02,
						main_chute_open_speed				= 4,
						extr_chute_max_diam					= 0.3,
						opening_speed_k						= 2,
						jump_error_sum						= 440,
					},
	
					BLU_108_panel =
					{
						op_time 				= 50,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 5,
						caliber					= 0.1,
						L						= 1,
						I						= 1,
						Ma						= 0.5,
						Mw						= 1,
						cx_coeff				= {1, 0.4, 0.4, 0.4, 1.4},
						model_name				= "cbu97_blu108_panel",
						init_pos				= {{0,0,0}},
						init_impulse			= {{0,125,0}},
						spawn_options			= {{0,1,1}},
					},
	
					skeet = 
					{
						op_time					= 9000,
						count					= 4,
						effect_count			= 4,
						wind_sigma				= 1,
						impulse_sigma			= 1,
						moment_sigma			= 0.1,
						mass					= 5,
						caliber					= 0.1,
						L						= 1,
						I						= 1,
						Ma						= 1,
						Mw						= 1,
						cx_coeff				= {1, 0.4, 0.4, 0.4, 1.4},
						model_name				= "cbu97_skeet",
						init_pos				= {{0.02,-0.15,0},{0.02,0.15,0},{0.25,-0.15,0},{0.25,0.15,0}},
						omega_impulse_coeff		= 3.6,
						release_rnd_coeff		= 12,
						set_start_args			= 10,
						spawm_options			= {{2,2,1},{3,3,1},{4,4,1},{5,5,1}},
			
						shell_model_name		= "shell",
						seeker_local_point		= {{0.05, -0.07, 0}},
						seeker_rotation_point	= {0, 0, 0},
						seeker_max_angle		= 0.392699,
						seeker_max_range		= 160,
						seeker_activation_time	= 0.3,
						shot_error				= 0.05,
						aim_lock_efficiency		= 0.66,
						shell_speed				= 500,
					},
					warhead		= predefined_warhead("CBU97"),
			},
			
			name    		= _("BLU-108"),
			type_name		= _("cluster"),
			cluster_scheme	= "AGM-154B_cluster",
		}
		)
    },
}

declare_weapon(AGM_154A)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM-154A}",
	attribute		= AGM_154A.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "AGM154.png",
	displayName		= _("AGM-154B - JSOW Anti-Armour"),
	Weight			= AGM_154A.mass,
	Elements  		= {{ShapeName = "kab-500s"}},
	ejectVelocity   = 4,
})

AGM_154B =
{
	category		= CAT_MISSILES,
	name			= "AGM_154B",
	user_name		= _("AGM-154B"),
	display_name_short = "AGM-154",
	scheme			= "JSOW_AB",
	class_name		= "wAmmunitionCruise",
	model			= "agm-154",
	mass			= 485,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 485.0,
	H_max			= 28000.0,
	H_min			= 300,
	Diam			= 400.0,
	Cx_pil			= 8,
	D_max			= 130000.0,
	D_min			= 5000.0,
	Head_Form		= 1,
	Life_Time		= 9999,
	Nr_max			= 10,
	v_min			= 150.0,
	v_mid			= 200.0,
	Mach_max		= 1.7,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 0.0,
	Range_max		= 132000.0,
	H_min_t			= 0.0,
	Fi_start		= 3.14152,
	Fi_rak			= 3.14152,
	Fi_excort		= 3.14152,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0.0,
	Y_back			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.05,
	KillDistance	= 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		13000,	18300,	29100,	35100,	38600,	40800,	42500,	44300,	
		500,	0,		0,		12700,	19900,	30400,	36600,	40200,	42500,	44100,	46100,	
		700,	0,		9500,	13700,	21500,	31800,	38100,	41700,	44000,	45700,	47400,	
		1000,	0,		9200,	16000,	24200,	33800,	40200,	44000,	46200,	48200,	49800,	
		2000,	9000,	21200,	27800,	34000,	34000,	47800,	51600,	54200,	56200,	58000,	
		3000,	14400,	30400,	38600,	47600,	54800,	54800,	59400,	62000,	64200,	66200,	
		4000,	19500,	39000,	47000,	54500,	62000,	62000,	66000,	69500,	72000,	74000,	
		5000,	24000,	47500,	56000,	63500,	68500,	68500,	73000,	76500,	79500,	82000,	
		6000,	30000,	56000,	64500,	72000,	78500,	80000,	80000,	83500,	87000,	89500,	
		7000,	35000,	64500,	72500,	80000,	87000,	87000,	87000,	90500,	94500,	97500,	
		8000,	39750,	72000,	80250,	87750,	93750,	93750,	93750,	96750,	100500,	105000,	
		9000,	44250,	79500,	87750,	90750,	90750,	90750,	90750,	103500,	107250,	111750,	
		10000,	75750,	81750,	86250,	90750,	93750,	94500,	95250,	100500,	113250,	117750,	
		11000,	90000,	95250,	101250,	105750,	108750,	111000,	111750,	114750,	119250,	124500,	
		12000,	96000,	98000,	108000,	112000,	115000,	117000,	118000,	119000,	124000,	128000,	
		13000,	101000,	109000,	109000,	118000,	121000,	121000,	124000,	124000,	125000,	132000,	
		14000,	106000,	111000,	115000,	124000,	124000,	125000,	126000,	127000,	128000,	129000,	
		15000,	112000,	117000,	122000,	126000,	129000,	129000,	132000,	133000,	134000,	138000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		8400,	8700,	9400,	9800,	10000,	10200,	10300,	15200,	
		500,	0,		0,		8300,	8800,	9500,	9900,	10100,	10300,	10400,	15300,	
		700,	0,		8400,	8400,	9200,	9600,	10000,	10200,	10400,	10500,	10600,	
		1000,	0,		8200,	8600,	9400,	9800,	10200,	10400,	10600,	10600,	10800,	
		2000,	8200,	9000,	9400,	9800,	9800,	10600,	11000,	11000,	11200,	11400,	
		3000,	8600,	9600,	10000,	10600,	11200,	11200,	11400,	11600,	11800,	11800,	
		4000,	9000,	10000,	11000,	11000,	11500,	11500,	12000,	12000,	12500,	12500,	
		5000,	9500,	11000,	11500,	12000,	12000,	12000,	12500,	12500,	13000,	13000,	
		6000,	10000,	12000,	12000,	12500,	13000,	13000,	13000,	13000,	13500,	13500,	
		7000,	10500,	12500,	12500,	13000,	13500,	13500,	13500,	13500,	14000,	14000,	
		8000,	9750,	12000,	13500,	12750,	13500,	13500,	13500,	13500,	13500,	14250,	
		9000,	11250,	12750,	12750,	13500,	13500,	13500,	13500,	14250,	14250,	14250,	
		10000,	12000,	12750,	12750,	13500,	13500,	13500,	13500,	30000,	15000,	15000,	
		11000,	13500,	13500,	14250,	14250,	14250,	14250,	14250,	15000,	15000,	15750,	
		12000,	14000,	14000,	15000,	15000,	15000,	16000,	16000,	16000,	16000,	16000,	
		13000,	14000,	15000,	15000,	16000,	16000,	16000,	16000,	16000,	16000,	16000,	
		14000,	15000,	15000,	15000,	16000,	16000,	16000,	16000,	16000,	16000,	16000,	
		15000,	15000,	16000,	16000,	16000,	16000,	16000,	16000,	17000,	17000,	18000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		111.2,	118.3,	169.4,	186.7,	195.1,	199.5,	202.8,	207.3,	
		500,	0,		0,		104.9,	126.8,	175.6,	194.3,	203.2,	208.2,	210.4,	216.3,	
		700,	0,		101.1,	101.4,	134.5,	182.6,	201.7,	210.3,	215.2,	218,	221.1,	
		1000,	0,		82.5,	113.3,	148.5,	192,	211.4,	221.4,	225,	230,	232,	
		2000,	81.3,	178.5,	191.7,	195.7,	170.3,	247.4,	256.1,	262.1,	265.9,	268.2,	
		3000,	144.7,	232.7,	255.6,	288.1,	293.9,	277.6,	290.7,	294.1,	292.9,	291.6,	
		4000,	195.6,	276.3,	293.5,	300,	315.7,	296.2,	299.1,	311.5,	316.8,	315.9,	
		5000,	236,	328.2,	333.6,	339.7,	330.7,	317.4,	326.9,	335,	343.4,	345.7,	
		6000,	297.4,	349.1,	366.8,	372.7,	378.6,	358.4,	354.3,	362.7,	371.6,	371.6,	
		7000,	341.6,	386.9,	395.6,	400.4,	410.7,	380.1,	382.9,	389.5,	400.8,	402.7,	
		8000,	380.4,	412.7,	422.7,	426.2,	426.9,	401.5,	410.8,	410.9,	419.3,	430.2,	
		9000,	414.1,	441.9,	447.9,	411,	375.6,	359.7,	378.3,	438.5,	444.3,	452.3,	
		10000,	373.5,	391,	389.5,	394.3,	398.6,	390.4,	388,	410.4,	464.6,	471.4,	
		11000,	457.4,	461.2,	468.9,	470.7,	472.8,	476.9,	473.5,	480.4,	487.4,	497.8,	
		12000,	469.5,	448,	494.3,	493.7,	495.8,	497,	496.1,	496,	506.2,	503.4,	
		13000,	478.2,	512,	473.1,	516.3,	517.7,	501.1,	517.6,	508.5,	502.7,	522,	
		14000,	491.5,	498.3,	496.5,	540.6,	515.5,	507.5,	507.4,	506.5,	503.4,	490.4,	
		15000,	516.9,	523.3,	529.8,	531.3,	531.4,	516.2,	531.6,	530.1,	526,	543.9,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		52.6,	39,		33.9,	31,		29,		27.3,	28.2,	39.1,		
		500,	0,		0,		51.7,	38.4,	33.7,	30.9,	29,		27.3,	28.5,	39,		
		700,	0,		80,		49.2,	39.4,	33.3,	31.1,	29,		27.4,	25.7,	24.2,		
		1000,	0,		64.4,	46.7,	41,		33.3,	31.1,	28.9,	27.3,	25.5,	24.2,		
		2000,	66.6,	54.8,	45.9,	40.2,	34.3,	33,		31.4,	28.9,	27.6,	26.3,		
		3000,	60.5,	54.1,	47,		42.2,	38.7,	34.5,	33.3,	31.6,	30,		27.8,		
		4000,	58,		53.6,	49.1,	42.2,	38.8,	34.3,	33.7,	31.4,	30.8,	28.6,		
		5000,	57.6,	56.7,	50.3,	45.5,	41,		36.5,	35.6,	33.4,	32.6,	30.2,		
		6000,	58.1,	59.5,	51.8,	47.5,	44.6,	41.7,	37.5,	35.2,	34.3,	31.7,		
		7000,	58.9,	60.6,	53.6,	49.6,	47.6,	44.8,	39.4,	37.1,	35.9,	33.1,		
		8000,	55.7,	58.3,	57.2,	50.7,	48.8,	46.2,	40,		37.7,	35.2,	34,		
		9000,	60.9,	61.5,	55.9,	53.3,	49.8,	47.3,	45.5,	40,		37.4,	34.6,		
		10000,	63.3,	61.1,	56.9,	54.7,	51.3,	48.9,	46.9,	87,		39.6,	36.7,		
		11000,	67,		61,		58,		54,		51.1,	48.8,	47,		43.1,	40.4,	38.7,		
		12000,	69.3,	63.4,	61.1,	57.2,	54.2,	54,		52,		50,		42.9,	40,		
		13000,	70.2,	67.1,	62.4,	60.8,	57.7,	55.2,	53.2,	51.1,	48.9,	41.1,		
		14000,	73.9,	68.3,	63.8,	62.1,	59,		56.5,	54.4,	52.3,	49.9,	47.4,		
		15000,	74.9,	71.9,	67.3,	63.5,	60.4,	57.8,	55.6,	55.2,	52.5,	51.1,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		85.3,	72.2,	83.8,	86.1,	86.6,	86.6,	86.3,	97.7,		
		500,	0,		0,		70.2,	74.9,	85.7,	88.7,	89.4,	89.6,	89,		100.8,	
		700,	0,		86.6,	71.6,	78.7,	88,		91.3,	92,		92.2,	91.5,	91,		
		1000,	0,		71.4,	73.7,	83.8,	91.1,	94.6,	95.7,	95.5,	95.5,	95,		
		2000,	73.8,	103.6,	101.7,	101.1,	89.6,	107.6,	109.2,	109.4,	109.6,	109.1,	
		3000,	99.1,	123.8,	125.8,	131.8,	134.1,	120,	122.9,	123.3,	123.5,	122.6,	
		4000,	126.2,	140.8,	142.5,	141.2,	143.6,	132.2,	134.3,	135.9,	137,	135.5,	
		5000,	146,	158.6,	158.8,	157.6,	152,	143.3,	146.3,	147.7,	149.4,	148.4,	
		6000,	166.3,	175.5,	172.8,	170.6,	170.2,	165.3,	158.4,	159.5,	161.7,	160.2,	
		7000,	178.4,	190.2,	184.9,	182,	183.9,	176.3,	170.6,	171.3,	174,	173.1,	
		8000,	131.9,	199.1,	197.2,	191.5,	193.1,	185.9,	181.2,	180.6,	181.8,	184.5,	
		9000,	139.3,	211.9,	204.7,	193.8,	182.5,	176,	171.8,	192.8,	193.2,	194,	
		10000,	187.9,	192.1,	187.7,	186.3,	184.2,	180.2,	177.6,	214.8,	202.9,	203.5,	
		11000,	218,	216.3,	216.2,	213.6,	211.9,	210.9,	208.1,	210,	211.4,	241.4,	
		12000,	224.6,	217.5,	227.1,	224,	222.1,	222.3,	219.8,	217.6,	219,	218,	
		13000,	229,	237.2,	225.1,	234.3,	232.2,	226.3,	227.5,	223,	218.7,	222,	
		14000,	236.1,	236.9,	233.4,	242.6,	234.5,	230.4,	227.5,	224.5,	220.6,	213.3,	
		15000,	243.7,	246.9,	245.8,	243.2,	240.6,	234.5,	235.1,	233.7,	229.2,	230.8,	
	},
		
	shape_table_data =
	{
		{
			name	 = "AGM_154B",
			file	 = "AGM-154",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("AGM-154B"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	warhead		= simple_warhead(0),
	
	fm =	{
		mass				= 485,
		caliber				= 0.4,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 4.06,
		I					= 1000,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 1.2,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.6,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff	= {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 2,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
		target_point_always_on_surface	= 0,
	},
	
	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},
	
	control_block2 ={
		delay							= 0.5,
		add_y							= 180,
		wind_k							= 0,
		use_snake_maneuver				= 1,
		max_no_vert_offset_open_h		= 90,
		vert_offset_before_end_game_k	= 0.8,	
		can_update_target_pos			= 0,
	},

	open_trigger = {
		delay							= 0.1,
		trigger_add_time				= 0.5,
		bomblet_char_time				= 24,
		chute_bomblet_char_time			= 150,
		chute_open_time					= 0.5,
		chute_cut_time					= 500,
		char_time_vel_correction_coeff	= 0,
		char_time_h_correction_coeff	= 0,
		default_add_y					= 180,
		out_w_add_y						= 0,
		wind_correction_coeff			= 1.5,
		time_coeff_data 				= {	41,		1.92,	--900
											32.4,	1.78,	--700
											23.8,	1.55,	--500
											21.6,	1.3,	--450
											20.0,	1.08,	--400
											17.3,	1.0,	--350
											15,		1.2,	--300
											13,		1.2,	--250
											9.8,	0.96,	--180
											5.8,	0.85	},--90
	},
	
	autopilot =	{
		delay						= 0.5,
		K							= 200,
		Ki							= 0.00005,
		Kg							= 6,
		nw_K						= 32,
		nw_Ki						= 0.00012,
		nw_Kg						= 1.8,
		finsLimit					= 0.8,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.25,
		egm_Angle_K					= 0.25,
		egm_FinAngle_K				= 0.32,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.3,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 1,
		err_limit		= 0.5,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 1.3,
		fins_limit_x	= 0.01,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 4.0,
		Kx				= 0.04,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.5,
		Kpj					= 0.5,	
	},
	
	launcher =
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster, 
		{
			scheme = 
			{
				dispenser = 
					{
						op_time					= 9000,
						wind_sigma				= 20,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 360,
						caliber					= 0.45,
						L						= 2.5,
						I						= 100,
						Ma						= 0.228,
						Mw						= 2.33,
						cx_coeff				= {1, 1, 1, 1, 2},
						model_name				= "agm-154",
						set_start_args			= {0,12,13},
						spawn_args_change		= {{1,12,0},{1,1,0.6}},
						spawn_time				= {0.02, 0.22, 0.42},
						spawn_weight_loss		= {0, 150, 150},
						spawm_args_change		= {{1,1,1},{1,12,0},{2,2,1}},
						op_spawns				= 3,
					},
	
					empty_dispenser = 
					{
						op_time					= 50,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 45,
						caliber					= 0.45,
						L						= 2.5,
						I						= 2,
						Ma						= 0.03,
						Mw						= 0.3,
						cx_coeff				= {1, 1, 1, 1, 2},
						model_name				= "agm-154",
						set_start_args			= {0, 1, 2},
						spawn_options			= {{2, 2, 1}},
					},
	
					BLU_108 =
					{
						op_time					= 9000,
						count					= 6,
						effect_count			= 6,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 2,
						mass					= 29.5,
						caliber					= 0.133,
						L						= 0.7,
						I						= 0.4,
						Ma						= 0.90985,
						Mw						= 1.67549,
						cx_coeff				= {1, 0.39, 0.38, 0.236, 1.31},
						model_name				= "cbu97_blu108",
						set_start_args			= {13},
						connectors_model_name	= "cbu97_shaft",
						explosion_impulse_coeff	= 42,
						explosion_center		= {{0.36,0,0},{-0.44,0,0}},
						release_rnd_coeff		= 7,
						chute_open_time			= 0.5,
						chute_diam				= 2,
						chute_Cx				= 1.2,
						chute_rnd_coeff			= 0.5,
						spawn_options			= {{0,1,3},{0,2,3}},
			
						submunition_engine_impulse			= 50,
						submunition_engine_fuel_mass		= 0.1,
						submunition_engine_work_time		= 0.22,
						submunition_engine_rotation_moment	= 9,
						submunition_engine_start_height		= 32,
						skeets_release_delay				= 1.05,
						skeets_in_seq_release_delay			= 0.02,
						main_chute_open_speed				= 4,
						extr_chute_max_diam					= 0.3,
						opening_speed_k						= 2,
						jump_error_sum						= 440,
					},
	
					BLU_108_panel =
					{
						op_time 				= 50,
						wind_sigma				= 5,
						impulse_sigma			= 1,
						moment_sigma			= 1,
						mass					= 5,
						caliber					= 0.1,
						L						= 1,
						I						= 1,
						Ma						= 0.5,
						Mw						= 1,
						cx_coeff				= {1, 0.4, 0.4, 0.4, 1.4},
						model_name				= "cbu97_blu108_panel",
						init_pos				= {{0,0,0}},
						init_impulse			= {{0,125,0}},
						spawn_options			= {{0,1,1}},
					},
	
					skeet = 
					{
						op_time					= 9000,
						count					= 4,
						effect_count			= 4,
						wind_sigma				= 1,
						impulse_sigma			= 1,
						moment_sigma			= 0.1,
						mass					= 5,
						caliber					= 0.1,
						L						= 1,
						I						= 1,
						Ma						= 1,
						Mw						= 1,
						cx_coeff				= {1, 0.4, 0.4, 0.4, 1.4},
						model_name				= "cbu97_skeet",
						init_pos				= {{0.02,-0.15,0},{0.02,0.15,0},{0.25,-0.15,0},{0.25,0.15,0}},
						omega_impulse_coeff		= 3.6,
						release_rnd_coeff		= 12,
						set_start_args			= 10,
						spawm_options			= {{2,2,1},{3,3,1},{4,4,1},{5,5,1}},
			
						shell_model_name		= "shell",
						seeker_local_point		= {{0.05, -0.07, 0}},
						seeker_rotation_point	= {0, 0, 0},
						seeker_max_angle		= 0.392699,
						seeker_max_range		= 160,
						seeker_activation_time	= 0.3,
						shot_error				= 0.05,
						aim_lock_efficiency		= 0.66,
						shell_speed				= 500,
					},
					warhead		= predefined_warhead("CBU97"),
			},
			
			name    		= _("BLU-108"),
			type_name		= _("cluster"),
			cluster_scheme	= "AGM-154B_cluster",
		}
		)
    },
}

declare_weapon(AGM_154B)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM-154B}",
	attribute		= AGM_154B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "AGM154.png",
	displayName		= _("AGM-154B - JSOW Anti-Armour"),
	Weight			= AGM_154B.mass,
	Elements  		= {{ShapeName = "kab-500s"}},
	ejectVelocity   = 4,
})

JSOW_data =
{
	["AGM-154A"]		= {name = "AGM-154B - JSOW Anti-Armour",		payload_CLSID = "{AGM-154A}",								mass = AGM_154A.mass, wsType = AGM_154A.wsTypeOfWeapon,	Cx = 0.0018,	picture = "AGM154.png"},
	["AGM-154B"]		= {name = "AGM-154B - JSOW Anti-Armour",		payload_CLSID = "{AGM-154B}",								mass = AGM_154B.mass, wsType = AGM_154B.wsTypeOfWeapon,	Cx = 0.0018,	picture = "AGM154.png"},
	["AGM-154C"]		= {name = "AGM-154C - JSOW Unitary BROACH",		payload_CLSID = "{9BCC2A2B-5708-4860-B1F1-053A18442067}",	mass = 484,			  wsType = {4,	4,	8,	132},		Cx = 0.0018,	picture = "AGM154.png"},
}

local function bru_55_JSOW(clsid,element)
	local JSOW_variant = JSOW_data[element] or JSOW_data["AGM-154A"]
	local ret = {
		category			=	CAT_MISSILES,
		CLSID				=	clsid,
		Picture				=	JSOW_variant.picture,
		displayName			=	_("BRU-55 with 2 x "..JSOW_variant.name),
		wsTypeOfWeapon		=	JSOW_variant.wsType,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Count				=	2,
		Weight				=	bru_55VER_mass +  2*JSOW_variant.mass,
		Cx_pil				=	0.00244140625 + 2*JSOW_variant.Cx,
		Elements 			=	{{ShapeName	=	"BRU_55",IsAdapter  	   =   true, DrawArgs = {{3, 0.1}}  },}
	}
	ret.Elements[#ret.Elements + 1] = {payload_CLSID = JSOW_variant.payload_CLSID, connector_name =	"Point02"}
	ret.Elements[#ret.Elements + 1] = {payload_CLSID = JSOW_variant.payload_CLSID, connector_name =	"Point01"}

	declare_loadout(ret)
end

bru_55_JSOW("{BRU55_2*AGM-154A}",	"AGM-154A")
bru_55_JSOW("{BRU55_2*AGM-154C}",	"AGM-154C")

local function bru_57_JSOW(element)
	local JSOW_variant = JSOW_data[element] or JSOW_data["AGM-154A"]
	local ret = {
		category			=	CAT_MISSILES,
		CLSID				=	"{BRU57_2*"..element.."}",
		Picture				=	JSOW_variant.picture,
		displayName			=	_("BRU-57 with 2 x "..JSOW_variant.name),
		wsTypeOfWeapon		=	JSOW_variant.wsType,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Count				=	2,
		Weight				=	bru_57VER_mass +  2*JSOW_variant.mass,
		Cx_pil				=	0.00244140625 + 2*JSOW_variant.Cx,
		Elements 			=	{{ShapeName	=	"BRU_57",IsAdapter  	   =   true, DrawArgs = {{3, 0.1}}  },}
	}
	ret.Elements[#ret.Elements + 1] = {payload_CLSID = JSOW_variant.payload_CLSID, connector_name =	"Point02"}
	ret.Elements[#ret.Elements + 1] = {payload_CLSID = JSOW_variant.payload_CLSID, connector_name =	"Point01"}

	declare_loadout(ret)
end

bru_57_JSOW("AGM-154A")				-- {BRU57_2*AGM-154A}
bru_57_JSOW("AGM-154B")				-- {BRU57_2*AGM-154B}

--------------------------------------------------------------------------
--								GB-6									--
--------------------------------------------------------------------------

GB_6 =
{
	category		= CAT_MISSILES,
	name			= "GB-6",
	user_name		= _("GB-6"),
	display_name_short = "GB-6",
	scheme			= "JSOW_AB",
	class_name		= "wAmmunitionCruise",
	model			= "gb6",
	mass			= 620,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 620.0,
	H_max			= 28000.0,
	H_min			= 300,
	Diam			= 330.0,
	Cx_pil			= 8,
	D_max			= 126000.0,
	D_min			= 10000.0,
	Head_Form		= 1,
	Life_Time		= 9999,
	Nr_max			= 10,
	v_min			= 150.0,
	v_mid			= 200.0,
	Mach_max		= 1.7,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 0.0,
	Range_max		= 126000.0,
	H_min_t			= 0.0,
	Fi_start		= 3.14152,
	Fi_rak			= 3.14152,
	Fi_excort		= 3.14152,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0.0,
	Y_back			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.1,
	KillDistance	= 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		15600,	18800,	22600,	25000,	26600,	27700,	28600,	
		500,	0,		0,		10000,	17200,	20000,	23800,	26200,	27800,	28900,	29900,	
		700,	0,		0,		12000,	18800,	21200,	25000,	27400,	29000,	30200,	31300,	
		1000,	0,		0,		14000,	21000,	26800,	26800,	29200,	31000,	32000,	33200,	
		2000,	10800,	15800,	21200,	27600,	32800,	32800,	35600,	37400,	38600,	39800,	
		3000,	18400,	23400,	28600,	34000,	38800,	38800,	41800,	43600,	45000,	46200,	
		4000,	25500,	30000,	35500,	40000,	44500,	44500,	47500,	49500,	50500,	52000,	
		5000,	32000,	37500,	42000,	47000,	50500,	50500,	53500,	55500,	57000,	58500,	
		6000,	39000,	44000,	49000,	54000,	58500,	59000,	59000,	61500,	63000,	65000,	
		7000,	45500,	50500,	56000,	60500,	64500,	64500,	64500,	67000,	69000,	71000,	
		8000,	51750,	57000,	62250,	66750,	69750,	69750,	69750,	72750,	75000,	77250,	
		9000,	57000,	59250,	69000,	73500,	75000,	75000,	75000,	78750,	81000,	83250,	
		10000,	61500,	64500,	68250,	70500,	79500,	79500,	81000,	82500,	87000,	90000,	
		11000,	72750,	77250,	81000,	84750,	86250,	87750,	87750,	89250,	92250,	95250,	
		12000,	79000,	83000,	87000,	90000,	91000,	93000,	94000,	95000,	97000,	100000,	
		13000,	86000,	90000,	93000,	96000,	97000,	99000,	99000,	100000,	100000,	105000,	
		14000,	91000,	95000,	99000,	102000,	103000,	105000,	105000,	106000,	106000,	108000,	
		15000,	97000,	101000,	105000,	107000,	109000,	111000,	111000,	112000,	112000,	113000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		9000,	9300,	9500,	9700,	9800,	9900,	9900,	
		500,	0,		0,		8600,	9200,	9300,	9600,	9800,	9900,	10000,	10000,	
		700,	0,		0,		8800,	9300,	9400,	9700,	10000,	10300,	10800,	10800,	
		1000,	0,		0,		8800,	9400,	9800,	10400,	11600,	12000,	12000,	12400,	
		2000,	8600,	9000,	9400,	9800,	10200,	10200,	12400,	12800,	13400,	15000,	
		3000,	9200,	9600,	9800,	10200,	10600,	10600,	13600,	14000,	14000,	14000,	
		4000,	10000,	10000,	10500,	11000,	11000,	11000,	11500,	13000,	11500,	12000,	
		5000,	10500,	10500,	11000,	11500,	11500,	11500,	12000,	12000,	12000,	12000,	
		6000,	11000,	11000,	12000,	12000,	12000,	12000,	12000,	12500,	12500,	12500,	
		7000,	12000,	13500,	14000,	13500,	12500,	12500,	12500,	13500,	13000,	13000,	
		8000,	14250,	15000,	15000,	15000,	12750,	12750,	12750,	15000,	15000,	14250,	
		9000,	15000,	15750,	15750,	15000,	14250,	13500,	13500,	17250,	18000,	15750,	
		10000,	15000,	15000,	15750,	15000,	14250,	13500,	18000,	18750,	19500,	18750,	
		11000,	15750,	16500,	15750,	15000,	15000,	18000,	19500,	20250,	21750,	21000,	
		12000,	16000,	16000,	16000,	16000,	15000,	20000,	21000,	22000,	23000,	23000,	
		13000,	17000,	17000,	16000,	20000,	21000,	22000,	23000,	24000,	24000,	25000,	
		14000,	17000,	17000,	21000,	22000,	23000,	25000,	25000,	26000,	26000,	27000,	
		15000,	17000,	22000,	24000,	25000,	26000,	26000,	27000,	28000,	28000,	29000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		105.2,	103.5,	113.3,	118.4,	121.5,	123.1,	123.6,	
		500,	0,		0,		71.7,	115.3,	109.8,	119.2,	124,	127,	128.5,	129.8,	
		700,	0,		0,		88.4,	124.8,	115.7,	124.9,	129.6,	132.7,	135,	137.2,	
		1000,	0,		0,		99.1,	136.3,	173.6,	133.8,	138.2,	142.9,	143,	145.9,	
		2000,	95.5,	120.8,	138.5,	166.6,	203.4,	159,	166.5,	170.6,	171.9,	173.8,	
		3000,	145,	167.8,	179.1,	195.9,	205.5,	187,	195.3,	198.8,	201.2,	202,	
		4000,	181.7,	201.3,	213.1,	219.8,	227.7,	212.5,	219.8,	224.3,	222.4,	224.7,	
		5000,	210.2,	243.1,	242,	252.2,	250.8,	239.3,	246.9,	250.4,	251.7,	252.7,	
		6000,	267.7,	273.9,	274.7,	283.1,	289.9,	273.5,	269.2,	275.9,	276,	279.7,	
		7000,	300.4,	313,	306.6,	308.5,	309.4,	292.3,	291.3,	296.9,	299.9,	301.9,	
		8000,	329.1,	342.5,	330.6,	330.1,	323.7,	307.7,	311.4,	320,	323.5,	325.7,	
		9000,	383,	424.3,	359,	356.2,	339.1,	325.4,	332.1,	345.5,	347.2,	347.4,	
		10000,	322.1,	319.4,	319.8,	314.2,	359.7,	350.1,	356.2,	356.3,	371.4,	375.4,	
		11000,	390.2,	395.9,	390.4,	392.5,	388.2,	390.4,	383.5,	386.8,	390.6,	392.3,	
		12000,	412.6,	412.8,	411.8,	410.3,	402.5,	408.4,	409.5,	411.7,	409.7,	408.9,	
		13000,	442.2,	442.9,	435.7,	435.6,	427.4,	432.8,	425.5,	427.4,	420.6,	433.8,	
		14000,	454.3,	457.6,	461.7,	462.2,	453.1,	457.8,	450.3,	452,	444.2,	447.6,	
		15000,	480.1,	484.6,	489.7,	481,	479.7,	483.6,	476.2,	477.6,	468.9,	467,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		44.6,	36.8,	33.7,	31.7,	30.1,	29.9,	27.5,		
		500,	0,		0,		58.5,	44.2,	35.5,	32.7,	31.2,	29.8,	30,		28,		
		700,	0,		0,		55.7,	43.3,	35,		32.4,	31.9,	30.9,	31,		29.4,		
		1000,	0,		0,		51.7,	43.5,	38,		34.8,	36.6,	35.8,	34,		34.1,		
		2000,	69.6,	57.3,	47.9,	42.8,	38.2,	33.7,	38.5,	38,		38.2,	41.7,		
		3000,	63.8,	56.1,	48,		43.2,	39.6,	34.9,	42.2,	41.6,	39.9,	38.2,		
		4000,	64.2,	56.1,	50.2,	45,		40.4,	35.7,	36,		39.2,	34.1,	33.9,		
		5000,	63.1,	56.2,	50.9,	45.1,	40.8,	37.2,	37.1,	36.2,	35.4,	34.1,		
		6000,	63.6,	57.4,	54.3,	46.6,	42.8,	40.5,	38,		38.2,	37.6,	36.3,		
		7000,	70.4,	66.6,	60.9,	51.7,	45.2,	42.9,	40.5,	41.7,	39.5,	38.6,		
		8000,	79.5,	71.1,	64.2,	58.1,	47,		44.9,	42.6,	46.3,	45,		42.3,		
		9000,	80.7,	73,		66.9,	59,		52.2,	48.1,	46.2,	53.8,	52.9,	46.6,		
		10000,	74.9,	69.9,	67.2,	60.1,	52.7,	48.9,	58.8,	59,		57.1,	53.6,		
		11000,	75.8,	71.9,	64.5,	58.7,	56.3,	61.5,	63.8,	64,		63,		59.1,		
		12000,	77,		71,		66.3,	62.7,	57.5,	67.9,	68.7,	69.5,	69.6,	63.8,		
		13000,	80.7,	74.9,	67.7,	74.3,	73.9,	74.1,	74.8,	75.5,	73.1,	68.4,		
		14000,	81.5,	76,		82.1,	80.6,	80.1,	83,		80.7,	81.2,	78.6,	78,		
		15000,	82.5,	91,		91.4,	89.7,	89,		86.2,	86.4,	86.7,	83.9,	83.1,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		71.9,	64.1,	64,		64,		63.6,	63.1,	62.2,		
		500,	0,		0,		64.9,	75.4,	65.8,	66.1,	66.1,	65.7,	65.2,	64.5,		
		700,	0,		0,		72,		78.4,	67.8,	68.3,	68.1,	68.4,	69.1,	68.4,		
		1000,	0,		0,		72.4,	81.9,	91.8,	72.4,	74.9,	75.8,	74.6,	75.1,		
		2000,	82.7,	85.6,	86.3,	92.4,	103.8,	82.2,	88.2,	88.9,	89.5,	92.6,		
		3000,	100.5,	103.4,	101.5,	103.6,	104.7,	93.8,	102,	102.4,	101.7,	100.6,	
		4000,	116,	116.7,	115.8,	114.5,	113.5,	104.4,	106.2,	109.7,	104.6,	104.5,	
		5000,	127.4,	132.8,	127.5,	127,	123.1,	115.7,	117.9,	117.2,	116.2,	115,	
		6000,	139.8,	145.1,	141.7,	138.9,	137.6,	132.5,	126.6,	128.7,	128.5,	128.4,	
		7000,	175.4,	163.7,	157.9,	151.5,	147.1,	141.6,	136.8,	139.7,	138.6,	138.1,	
		8000,	193.5,	246.8,	168.7,	162.6,	154.8,	149.8,	145.8,	152.3,	152.5,	150.4,	
		9000,	192,	273.7,	179.9,	172.4,	165.4,	158.9,	155.7,	166.9,	168.5,	162.3,	
		10000,	174.7,	169.8,	166.7,	159.7,	170.6,	164.9,	174.6,	174.8,	180.5,	179,	
		11000,	199,	196.9,	189.9,	186.2,	183.2,	188.6,	188.4,	189.3,	192.2,	190.2,	
		12000,	206.4,	202.6,	199,	195.9,	189.7,	200.1,	200.9,	201.9,	200.4,	199.3,	
		13000,	218.1,	215.2,	207.9,	213.7,	211.4,	213.1,	211.5,	212.3,	208.1,	208.7,	
		14000,	223.6,	221.5,	227.8,	227,	224.5,	227.9,	224,	224.5,	220.1,	219.2,	
		15000,	231.9,	241.2,	243.4,	240.3,	239.6,	238.4,	236.4,	236.6,	231.8,	230.2,	
	},
	
	shape_table_data =
	{
		{
			name	 = "GB-6",
			file	 = "gb6",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("GB-6"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	warhead		= simple_warhead(0),

	fm =	{
		mass				= 620,
		caliber				= 0.54,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 4.5,
		I					= 1 / 12 * 620 * 4.5 * 4.5,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 1.8,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.85,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff = {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 2,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
		target_point_always_on_surface	= 0,
	},
	
	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	control_block2 ={
		delay							= 0.3,
		add_y							= 500,
		wind_k							= 0,
		use_snake_maneuver				= 0,
		max_no_vert_offset_open_h		= 90,
		vert_offset_before_end_game_k	= 0.8,	
		can_update_target_pos			= 0,
	},

	open_trigger = {
		delay							= 0.1,
		trigger_add_time				= 1,
		bomblet_char_time				= 21.22,
		chute_bomblet_char_time			= 49.6,
		chute_open_time					= 2.6,
		chute_cut_time					= 400,
		char_time_vel_correction_coeff	= -0.0132,
		char_time_h_correction_coeff	= 0.0,
		default_add_y					= 500,
		out_w_add_y						= 0,
		wind_correction_coeff			= 1,
		time_coeff_data 				= {	25,		0.9,
											18,		0.86,
											15,		0.8,
											11.7,	0.58,
											6.8,	0.3,
											3,		0.2	},
	},
	
	autopilot =	{
		delay						= 0.5,
		K							= 194,
		Ki							= 0.00007,
		Kg							= 2.5,
		nw_K						= 72,
		nw_Ki						= 0.00007,
		nw_Kg						= 0.8,
		finsLimit					= 0.7,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.2,
		egm_Angle_K					= 0.25,
		egm_FinAngle_K				= 0.32,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.35,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0.0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.4,
		err_limit		= 0.24,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.0024,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 4.0,
		Kx				= 0.03,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.4,
		Kpj					= 0.5,	
	},

	launcher =
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster,
        {
            scheme = 
            {
                dispenser = 
                {
                    mass                    = 620,
                    caliber                 = 0.55,
                    L                       = 3.5,
                    I                       = 270.0,
                    Ma                      = 1,
                    Mw                      = 3,
                    cx_coeff                = {1, 0.3, 0.65, 0.018, 1.6},
                    model_name              = "gb6",
                    set_start_args          = {},
                    spawn_time              = {0},
                    spawn_weight_loss       = {300},
                    spawn_args_change       = {},
                    op_spawns               = 2,
                    use_effects             = 0,
                    hide_effect_0           = 0,
                },
                
                bomblets =
                {
                    wind_sigma                  = 25,
                    impulse_sigma               = 2,
                    moment_sigma                = 0.1,
                    count                       = 150,
                    effect_count                = 60,
                    mass                        = 3,
                    caliber                     = 0.063,
                    cx_coeff                    = {1.0, 0.39, 0.38, 0.236, 1.31},
                    L                           = 1.68000,
                    I                           = 0.061333,
                    Ma                          = 0.2,
                    Mw                          = 0.8,
                    model_name                  = "PTAB-2_5KO",
                    connectors_model_name       = "RBK_250_PTAB_25M_tail",
                    explosion_impulse_coeff     = 15,
                    explosion_dont_use_x_axis   = 0,
                    release_rnd_coeff           = 0.8,
                    chute_open_time             = 2.6,
                    chute_cut_time              = 500.0,
                    chute_diam                  = 0.2,
                    chute_Cx                    = 0.7,
                    chute_rnd_coeff             = 0.5,
                    explosion_center            = {{0,0.3,0}},
                    spawn_options               = {{0,0,150}},
                },
				
				warhead		= predefined_warhead("JS_6"),
            },
            
            name            = _("GB-06"),
            type_name       = _("cluster"),
            cluster_scheme  = "disp_bomblets",
        }
        )
    },
	
}

declare_weapon(GB_6)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{GB-6}",
	attribute		= GB_6.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "gb6.png",
	displayName		= _("GB-6"),
	Weight			= 620,
	Elements  		= {{ShapeName = "gb6"}},
	ejectVelocity   = 3,
})

GB_6_SFW =
{
	category		= CAT_MISSILES,
	name			= "GB-6-SFW",
	user_name		= _("GB-6-SFW"),
	display_name_short = "GB-6",
	scheme			= "JSOW_AB",
	class_name		= "wAmmunitionCruise",
	model			= "gb6",
	mass			= 620,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 620.0,
	H_max			= 28000.0,
	H_min			= 300,
	Diam			= 330.0,
	Cx_pil			= 8,
	D_max			= 126000.0,
	D_min			= 10000.0,
	Head_Form		= 1,
	Life_Time		= 9999,
	Nr_max			= 10,
	v_min			= 150.0,
	v_mid			= 200.0,
	Mach_max		= 1.7,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 0.0,
	Range_max		= 126000.0,
	H_min_t			= 0.0,
	Fi_start		= 3.14152,
	Fi_rak			= 3.14152,
	Fi_excort		= 3.14152,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0.0,
	Y_back			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.1,
	KillDistance	= 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		15600,	18800,	22600,	25000,	26600,	27700,	28600,	
		500,	0,		0,		10000,	17200,	20000,	23800,	26200,	27800,	28900,	29900,	
		700,	0,		0,		12000,	18800,	21200,	25000,	27400,	29000,	30200,	31300,	
		1000,	0,		0,		14000,	21000,	26800,	26800,	29200,	31000,	32000,	33200,	
		2000,	10800,	15800,	21200,	27600,	32800,	32800,	35600,	37400,	38600,	39800,	
		3000,	18400,	23400,	28600,	34000,	38800,	38800,	41800,	43600,	45000,	46200,	
		4000,	25500,	30000,	35500,	40000,	44500,	44500,	47500,	49500,	50500,	52000,	
		5000,	32000,	37500,	42000,	47000,	50500,	50500,	53500,	55500,	57000,	58500,	
		6000,	39000,	44000,	49000,	54000,	58500,	59000,	59000,	61500,	63000,	65000,	
		7000,	45500,	50500,	56000,	60500,	64500,	64500,	64500,	67000,	69000,	71000,	
		8000,	51750,	57000,	62250,	66750,	69750,	69750,	69750,	72750,	75000,	77250,	
		9000,	57000,	59250,	69000,	73500,	75000,	75000,	75000,	78750,	81000,	83250,	
		10000,	61500,	64500,	68250,	70500,	79500,	79500,	81000,	82500,	87000,	90000,	
		11000,	72750,	77250,	81000,	84750,	86250,	87750,	87750,	89250,	92250,	95250,	
		12000,	79000,	83000,	87000,	90000,	91000,	93000,	94000,	95000,	97000,	100000,	
		13000,	86000,	90000,	93000,	96000,	97000,	99000,	99000,	100000,	100000,	105000,	
		14000,	91000,	95000,	99000,	102000,	103000,	105000,	105000,	106000,	106000,	108000,	
		15000,	97000,	101000,	105000,	107000,	109000,	111000,	111000,	112000,	112000,	113000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		9000,	9300,	9500,	9700,	9800,	9900,	9900,	
		500,	0,		0,		8600,	9200,	9300,	9600,	9800,	9900,	10000,	10000,	
		700,	0,		0,		8800,	9300,	9400,	9700,	10000,	10300,	10800,	10800,	
		1000,	0,		0,		8800,	9400,	9800,	10400,	11600,	12000,	12000,	12400,	
		2000,	8600,	9000,	9400,	9800,	10200,	10200,	12400,	12800,	13400,	15000,	
		3000,	9200,	9600,	9800,	10200,	10600,	10600,	13600,	14000,	14000,	14000,	
		4000,	10000,	10000,	10500,	11000,	11000,	11000,	11500,	13000,	11500,	12000,	
		5000,	10500,	10500,	11000,	11500,	11500,	11500,	12000,	12000,	12000,	12000,	
		6000,	11000,	11000,	12000,	12000,	12000,	12000,	12000,	12500,	12500,	12500,	
		7000,	12000,	13500,	14000,	13500,	12500,	12500,	12500,	13500,	13000,	13000,	
		8000,	14250,	15000,	15000,	15000,	12750,	12750,	12750,	15000,	15000,	14250,	
		9000,	15000,	15750,	15750,	15000,	14250,	13500,	13500,	17250,	18000,	15750,	
		10000,	15000,	15000,	15750,	15000,	14250,	13500,	18000,	18750,	19500,	18750,	
		11000,	15750,	16500,	15750,	15000,	15000,	18000,	19500,	20250,	21750,	21000,	
		12000,	16000,	16000,	16000,	16000,	15000,	20000,	21000,	22000,	23000,	23000,	
		13000,	17000,	17000,	16000,	20000,	21000,	22000,	23000,	24000,	24000,	25000,	
		14000,	17000,	17000,	21000,	22000,	23000,	25000,	25000,	26000,	26000,	27000,	
		15000,	17000,	22000,	24000,	25000,	26000,	26000,	27000,	28000,	28000,	29000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		105.2,	103.5,	113.3,	118.4,	121.5,	123.1,	123.6,	
		500,	0,		0,		71.7,	115.3,	109.8,	119.2,	124,	127,	128.5,	129.8,	
		700,	0,		0,		88.4,	124.8,	115.7,	124.9,	129.6,	132.7,	135,	137.2,	
		1000,	0,		0,		99.1,	136.3,	173.6,	133.8,	138.2,	142.9,	143,	145.9,	
		2000,	95.5,	120.8,	138.5,	166.6,	203.4,	159,	166.5,	170.6,	171.9,	173.8,	
		3000,	145,	167.8,	179.1,	195.9,	205.5,	187,	195.3,	198.8,	201.2,	202,	
		4000,	181.7,	201.3,	213.1,	219.8,	227.7,	212.5,	219.8,	224.3,	222.4,	224.7,	
		5000,	210.2,	243.1,	242,	252.2,	250.8,	239.3,	246.9,	250.4,	251.7,	252.7,	
		6000,	267.7,	273.9,	274.7,	283.1,	289.9,	273.5,	269.2,	275.9,	276,	279.7,	
		7000,	300.4,	313,	306.6,	308.5,	309.4,	292.3,	291.3,	296.9,	299.9,	301.9,	
		8000,	329.1,	342.5,	330.6,	330.1,	323.7,	307.7,	311.4,	320,	323.5,	325.7,	
		9000,	383,	424.3,	359,	356.2,	339.1,	325.4,	332.1,	345.5,	347.2,	347.4,	
		10000,	322.1,	319.4,	319.8,	314.2,	359.7,	350.1,	356.2,	356.3,	371.4,	375.4,	
		11000,	390.2,	395.9,	390.4,	392.5,	388.2,	390.4,	383.5,	386.8,	390.6,	392.3,	
		12000,	412.6,	412.8,	411.8,	410.3,	402.5,	408.4,	409.5,	411.7,	409.7,	408.9,	
		13000,	442.2,	442.9,	435.7,	435.6,	427.4,	432.8,	425.5,	427.4,	420.6,	433.8,	
		14000,	454.3,	457.6,	461.7,	462.2,	453.1,	457.8,	450.3,	452,	444.2,	447.6,	
		15000,	480.1,	484.6,	489.7,	481,	479.7,	483.6,	476.2,	477.6,	468.9,	467,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		44.6,	36.8,	33.7,	31.7,	30.1,	29.9,	27.5,		
		500,	0,		0,		58.5,	44.2,	35.5,	32.7,	31.2,	29.8,	30,		28,		
		700,	0,		0,		55.7,	43.3,	35,		32.4,	31.9,	30.9,	31,		29.4,		
		1000,	0,		0,		51.7,	43.5,	38,		34.8,	36.6,	35.8,	34,		34.1,		
		2000,	69.6,	57.3,	47.9,	42.8,	38.2,	33.7,	38.5,	38,		38.2,	41.7,		
		3000,	63.8,	56.1,	48,		43.2,	39.6,	34.9,	42.2,	41.6,	39.9,	38.2,		
		4000,	64.2,	56.1,	50.2,	45,		40.4,	35.7,	36,		39.2,	34.1,	33.9,		
		5000,	63.1,	56.2,	50.9,	45.1,	40.8,	37.2,	37.1,	36.2,	35.4,	34.1,		
		6000,	63.6,	57.4,	54.3,	46.6,	42.8,	40.5,	38,		38.2,	37.6,	36.3,		
		7000,	70.4,	66.6,	60.9,	51.7,	45.2,	42.9,	40.5,	41.7,	39.5,	38.6,		
		8000,	79.5,	71.1,	64.2,	58.1,	47,		44.9,	42.6,	46.3,	45,		42.3,		
		9000,	80.7,	73,		66.9,	59,		52.2,	48.1,	46.2,	53.8,	52.9,	46.6,		
		10000,	74.9,	69.9,	67.2,	60.1,	52.7,	48.9,	58.8,	59,		57.1,	53.6,		
		11000,	75.8,	71.9,	64.5,	58.7,	56.3,	61.5,	63.8,	64,		63,		59.1,		
		12000,	77,		71,		66.3,	62.7,	57.5,	67.9,	68.7,	69.5,	69.6,	63.8,		
		13000,	80.7,	74.9,	67.7,	74.3,	73.9,	74.1,	74.8,	75.5,	73.1,	68.4,		
		14000,	81.5,	76,		82.1,	80.6,	80.1,	83,		80.7,	81.2,	78.6,	78,		
		15000,	82.5,	91,		91.4,	89.7,	89,		86.2,	86.4,	86.7,	83.9,	83.1,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		71.9,	64.1,	64,		64,		63.6,	63.1,	62.2,		
		500,	0,		0,		64.9,	75.4,	65.8,	66.1,	66.1,	65.7,	65.2,	64.5,		
		700,	0,		0,		72,		78.4,	67.8,	68.3,	68.1,	68.4,	69.1,	68.4,		
		1000,	0,		0,		72.4,	81.9,	91.8,	72.4,	74.9,	75.8,	74.6,	75.1,		
		2000,	82.7,	85.6,	86.3,	92.4,	103.8,	82.2,	88.2,	88.9,	89.5,	92.6,		
		3000,	100.5,	103.4,	101.5,	103.6,	104.7,	93.8,	102,	102.4,	101.7,	100.6,	
		4000,	116,	116.7,	115.8,	114.5,	113.5,	104.4,	106.2,	109.7,	104.6,	104.5,	
		5000,	127.4,	132.8,	127.5,	127,	123.1,	115.7,	117.9,	117.2,	116.2,	115,	
		6000,	139.8,	145.1,	141.7,	138.9,	137.6,	132.5,	126.6,	128.7,	128.5,	128.4,	
		7000,	175.4,	163.7,	157.9,	151.5,	147.1,	141.6,	136.8,	139.7,	138.6,	138.1,	
		8000,	193.5,	246.8,	168.7,	162.6,	154.8,	149.8,	145.8,	152.3,	152.5,	150.4,	
		9000,	192,	273.7,	179.9,	172.4,	165.4,	158.9,	155.7,	166.9,	168.5,	162.3,	
		10000,	174.7,	169.8,	166.7,	159.7,	170.6,	164.9,	174.6,	174.8,	180.5,	179,	
		11000,	199,	196.9,	189.9,	186.2,	183.2,	188.6,	188.4,	189.3,	192.2,	190.2,	
		12000,	206.4,	202.6,	199,	195.9,	189.7,	200.1,	200.9,	201.9,	200.4,	199.3,	
		13000,	218.1,	215.2,	207.9,	213.7,	211.4,	213.1,	211.5,	212.3,	208.1,	208.7,	
		14000,	223.6,	221.5,	227.8,	227,	224.5,	227.9,	224,	224.5,	220.1,	219.2,	
		15000,	231.9,	241.2,	243.4,	240.3,	239.6,	238.4,	236.4,	236.6,	231.8,	230.2,	
	},
	
	shape_table_data =
	{
		{
			name	 = "GB-6-SFW",
			file	 = "gb6",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("GB-6-SFW"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	warhead		= simple_warhead(0),
	
	fm =	{
		mass				= 620,
		caliber				= 0.54,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 4.5,
		I					= 1 / 12 * 620 * 4.5 * 4.5,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 1.8,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.85,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff = {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 1,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
		target_point_always_on_surface	= 0,
	},
	
	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},
	
	control_block2 ={
		delay							= 0.5,
		add_y							= 180,
		wind_k							= 0,
		use_snake_maneuver				= 0,
		max_no_vert_offset_open_h		= 90,
		vert_offset_before_end_game_k	= 0.8,	
		can_update_target_pos			= 0,
	},

	open_trigger = {
		delay							= 0.1,
		trigger_add_time				= 0.5,
		bomblet_char_time				= 24,
		chute_bomblet_char_time			= 150,
		chute_open_time					= 0.3,
		chute_cut_time					= 500,
		char_time_vel_correction_coeff	= 0,
		char_time_h_correction_coeff	= 0,
		default_add_y					= 180,
		out_w_add_y						= 0,
		wind_correction_coeff			= 1.5,
		time_coeff_data 				= {	41,		1.92,	--900
											32.4,	1.78,	--700
											23.8,	1.55,	--500
											21.6,	1.3,	--450
											20.0,	1.08,	--400
											17.3,	1.0,	--350
											15,		1.2,	--300
											13,		1.2,	--250
											9.8,	0.96,	--180
											5.8,	0.85	},--90
	},
	
	autopilot =	{
		delay						= 0.5,
		K							= 194,
		Ki							= 0.00007,
		Kg							= 2.5,
		nw_K						= 72,
		nw_Ki						= 0.00007,
		nw_Kg						= 0.8,
		finsLimit					= 0.7,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.2,
		egm_Angle_K					= 0.25,
		egm_FinAngle_K				= 0.32,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.35,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0.0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.4,
		err_limit		= 0.24,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.0024,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 4.0,
		Kx				= 0.03,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.4,
		Kpj					= 0.5,	
	},

	launcher =
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster,
        {
            scheme = 
            {
                dispenser = 
                {
                    op_time                 = 9000,
                    wind_sigma              = 20,
                    impulse_sigma           = 1,
                    moment_sigma            = 1,
                    mass                    = 450,
                    caliber                 = 0.45,
                    L                       = 2.5,
                    I                       = 100,
                    Ma                      = 0.228,
                    Mw                      = 2.33,
                    cx_coeff                = {1, 1, 1, 1, 2},
                    model_name              = "gb6-body",
                    set_start_args          = {0,12,13},
                    spawn_args_change       = {{1,12,0},{1,1,0.6}},
                    spawn_time              = {0.02, 0.17, 0.32},
                    spawn_weight_loss       = {0, 150, 150},
                    spawn_args_change       = {{1,1,1},{1,12,0},{2,2,1}},
                    op_spawns               = 3,
                },

                empty_dispenser = 
                {
                    op_time                 = 50,
                    wind_sigma              = 5,
                    impulse_sigma           = 1,
                    moment_sigma            = 1,
                    mass                    = 45,
                    caliber                 = 0.45,
                    L                       = 2.5,
                    I                       = 2,
                    Ma                      = 0.03,
                    Mw                      = 0.3,
                    cx_coeff                = {1, 1, 1, 1, 2},
                    model_name              = "gb6-cap",
                    set_start_args          = {0, 1, 2},
                    spawn_options           = {{2, 2, 1}},
                },

                BLU_108 =
                {
                    op_time                 = 9000,
                    count                   = 12,
                    effect_count            = 12,
                    wind_sigma              = 5,
                    impulse_sigma           = 1,
                    moment_sigma            = 2,
                    mass                    = 29.5,
                    caliber                 = 0.133,
                    L                       = 0.7,
                    I                       = 0.4,
                    Ma                      = 0.90985,
                    Mw                      = 1.67549,
                    cx_coeff                = {1, 0.39, 0.38, 0.236, 1.31},
                    model_name              = "cbu97_blu108",
                    set_start_args          = {13},
                    connectors_model_name   = "cbu97_shaft",
                    explosion_impulse_coeff = 42,
                    explosion_center        = {{0.36,0,0},{-0.44,0,0}},
                    release_rnd_coeff       = 7,
                    chute_open_time         = 0.5,
                    chute_diam              = 2,
                    chute_Cx                = 1.2,
                    chute_rnd_coeff         = 0.5,
                    spawn_options           = {{0,1,6},{0,2,6}},
        
                    submunition_engine_impulse          = 60,
                    submunition_engine_fuel_mass        = 0.1,
                    submunition_engine_work_time        = 0.22,
                    submunition_engine_rotation_moment  = 9,
                    submunition_engine_start_height     = 48,
                    skeets_release_delay                = 1.00,
                    skeets_in_seq_release_delay         = 0.02,
                    main_chute_open_speed               = 4,
                    extr_chute_max_diam                 = 0.3,
                    opening_speed_k                     = 2,
                    jump_error_sum                      = 440,
                },

                BLU_108_panel =
                {
                    op_time                 = 50,
                    wind_sigma              = 5,
                    impulse_sigma           = 1,
                    moment_sigma            = 1,
                    mass                    = 5,
                    caliber                 = 0.1,
                    L                       = 1,
                    I                       = 1,
                    Ma                      = 0.5,
                    Mw                      = 1,
                    cx_coeff                = {1, 0.4, 0.4, 0.4, 1.4},
                    model_name              = "cbu97_blu108_panel",
                    init_pos                = {{0,0,0}},
                    init_impulse            = {{0,125,0}},
                    spawn_options           = {{0,1,1}},
                },

                skeet = 
                {
                    op_time                 = 9000,
                    count                   = 4,
                    effect_count            = 4,
                    wind_sigma              = 1,
                    impulse_sigma           = 1,
                    moment_sigma            = 0.1,
                    mass                    = 5,
                    caliber                 = 0.1,
                    L                       = 1,
                    I                       = 1,
                    Ma                      = 1,
                    Mw                      = 1,
                    cx_coeff                = {1, 0.4, 0.4, 0.4, 1.4},
                    model_name              = "cbu97_skeet",
                    init_pos                = {{0.02,-0.15,0},{0.02,0.15,0},{0.25,-0.15,0},{0.25,0.15,0}},
                    omega_impulse_coeff     = 3.6,
                    release_rnd_coeff       = 12,
                    set_start_args          = 10,
                    spawn_options           = {{2,2,1},{3,3,1},{4,4,1},{5,5,1}},
        
                    shell_model_name        = "shell",
                    seeker_local_point      = {{0.05, -0.07, 0}},
                    seeker_rotation_point   = {0, 0, 0},
                    seeker_max_angle        = 0.785,
                    seeker_max_range        = 160,
                    seeker_activation_time  = 0.1,
                    shot_error              = 0.05,
                    aim_lock_efficiency     = 0.85,
                    shell_speed             = 750,
                },
                warhead = predefined_warhead("CBU97"),
            },
            
            name            = _("MM-06"),
            type_name       = _("cluster"),
            cluster_scheme  = "AGM-154B_cluster",
        }
        )
    },
	
}

declare_weapon(GB_6_SFW)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{GB-6-SFW}",
	attribute		= GB_6_SFW.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "gb6.png",
	displayName		= _("GB-6-SFW"),
	Weight			= 620,
	Elements  		= {{ShapeName = "gb6"}},
	ejectVelocity   = 3,
})


GB_6_HE =
{
	category		= CAT_MISSILES,
	name			= "GB-6-HE",
	user_name		= _("GB-6-HE"),
	display_name_short = "GB-6",
	scheme			= "JSOW_C",
	class_name		= "wAmmunitionCruise",
	model			= "gb6",
	mass			= 620,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 620.0,
	H_max			= 28000.0,
	H_min			= 300,
	Diam			= 330.0,
	Cx_pil			= 8,
	D_max			= 126000.0,
	D_min			= 10000.0,
	Head_Form		= 1,
	Life_Time		= 9999,
	Nr_max			= 10,
	v_min			= 150.0,
	v_mid			= 200.0,
	Mach_max		= 1.7,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 0.0,
	Range_max		= 126000.0,
	H_min_t			= 0.0,
	Fi_start		= 3.14152,
	Fi_rak			= 3.14152,
	Fi_excort		= 3.14152,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0.0,
	Y_back			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.1,
	KillDistance	= 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		15600,	18800,	22600,	25000,	26600,	27700,	28600,	
		500,	0,		0,		10000,	17200,	20000,	23800,	26200,	27800,	28900,	29900,	
		700,	0,		0,		12000,	18800,	21200,	25000,	27400,	29000,	30200,	31300,	
		1000,	0,		0,		14000,	21000,	26800,	26800,	29200,	31000,	32000,	33200,	
		2000,	10800,	15800,	21200,	27600,	32800,	32800,	35600,	37400,	38600,	39800,	
		3000,	18400,	23400,	28600,	34000,	38800,	38800,	41800,	43600,	45000,	46200,	
		4000,	25500,	30000,	35500,	40000,	44500,	44500,	47500,	49500,	50500,	52000,	
		5000,	32000,	37500,	42000,	47000,	50500,	50500,	53500,	55500,	57000,	58500,	
		6000,	39000,	44000,	49000,	54000,	58500,	59000,	59000,	61500,	63000,	65000,	
		7000,	45500,	50500,	56000,	60500,	64500,	64500,	64500,	67000,	69000,	71000,	
		8000,	51750,	57000,	62250,	66750,	69750,	69750,	69750,	72750,	75000,	77250,	
		9000,	57000,	59250,	69000,	73500,	75000,	75000,	75000,	78750,	81000,	83250,	
		10000,	61500,	64500,	68250,	70500,	79500,	79500,	81000,	82500,	87000,	90000,	
		11000,	72750,	77250,	81000,	84750,	86250,	87750,	87750,	89250,	92250,	95250,	
		12000,	79000,	83000,	87000,	90000,	91000,	93000,	94000,	95000,	97000,	100000,	
		13000,	86000,	90000,	93000,	96000,	97000,	99000,	99000,	100000,	100000,	105000,	
		14000,	91000,	95000,	99000,	102000,	103000,	105000,	105000,	106000,	106000,	108000,	
		15000,	97000,	101000,	105000,	107000,	109000,	111000,	111000,	112000,	112000,	113000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		9000,	9300,	9500,	9700,	9800,	9900,	9900,	
		500,	0,		0,		8600,	9200,	9300,	9600,	9800,	9900,	10000,	10000,	
		700,	0,		0,		8800,	9300,	9400,	9700,	10000,	10300,	10800,	10800,	
		1000,	0,		0,		8800,	9400,	9800,	10400,	11600,	12000,	12000,	12400,	
		2000,	8600,	9000,	9400,	9800,	10200,	10200,	12400,	12800,	13400,	15000,	
		3000,	9200,	9600,	9800,	10200,	10600,	10600,	13600,	14000,	14000,	14000,	
		4000,	10000,	10000,	10500,	11000,	11000,	11000,	11500,	13000,	11500,	12000,	
		5000,	10500,	10500,	11000,	11500,	11500,	11500,	12000,	12000,	12000,	12000,	
		6000,	11000,	11000,	12000,	12000,	12000,	12000,	12000,	12500,	12500,	12500,	
		7000,	12000,	13500,	14000,	13500,	12500,	12500,	12500,	13500,	13000,	13000,	
		8000,	14250,	15000,	15000,	15000,	12750,	12750,	12750,	15000,	15000,	14250,	
		9000,	15000,	15750,	15750,	15000,	14250,	13500,	13500,	17250,	18000,	15750,	
		10000,	15000,	15000,	15750,	15000,	14250,	13500,	18000,	18750,	19500,	18750,	
		11000,	15750,	16500,	15750,	15000,	15000,	18000,	19500,	20250,	21750,	21000,	
		12000,	16000,	16000,	16000,	16000,	15000,	20000,	21000,	22000,	23000,	23000,	
		13000,	17000,	17000,	16000,	20000,	21000,	22000,	23000,	24000,	24000,	25000,	
		14000,	17000,	17000,	21000,	22000,	23000,	25000,	25000,	26000,	26000,	27000,	
		15000,	17000,	22000,	24000,	25000,	26000,	26000,	27000,	28000,	28000,	29000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		105.2,	103.5,	113.3,	118.4,	121.5,	123.1,	123.6,	
		500,	0,		0,		71.7,	115.3,	109.8,	119.2,	124,	127,	128.5,	129.8,	
		700,	0,		0,		88.4,	124.8,	115.7,	124.9,	129.6,	132.7,	135,	137.2,	
		1000,	0,		0,		99.1,	136.3,	173.6,	133.8,	138.2,	142.9,	143,	145.9,	
		2000,	95.5,	120.8,	138.5,	166.6,	203.4,	159,	166.5,	170.6,	171.9,	173.8,	
		3000,	145,	167.8,	179.1,	195.9,	205.5,	187,	195.3,	198.8,	201.2,	202,	
		4000,	181.7,	201.3,	213.1,	219.8,	227.7,	212.5,	219.8,	224.3,	222.4,	224.7,	
		5000,	210.2,	243.1,	242,	252.2,	250.8,	239.3,	246.9,	250.4,	251.7,	252.7,	
		6000,	267.7,	273.9,	274.7,	283.1,	289.9,	273.5,	269.2,	275.9,	276,	279.7,	
		7000,	300.4,	313,	306.6,	308.5,	309.4,	292.3,	291.3,	296.9,	299.9,	301.9,	
		8000,	329.1,	342.5,	330.6,	330.1,	323.7,	307.7,	311.4,	320,	323.5,	325.7,	
		9000,	383,	424.3,	359,	356.2,	339.1,	325.4,	332.1,	345.5,	347.2,	347.4,	
		10000,	322.1,	319.4,	319.8,	314.2,	359.7,	350.1,	356.2,	356.3,	371.4,	375.4,	
		11000,	390.2,	395.9,	390.4,	392.5,	388.2,	390.4,	383.5,	386.8,	390.6,	392.3,	
		12000,	412.6,	412.8,	411.8,	410.3,	402.5,	408.4,	409.5,	411.7,	409.7,	408.9,	
		13000,	442.2,	442.9,	435.7,	435.6,	427.4,	432.8,	425.5,	427.4,	420.6,	433.8,	
		14000,	454.3,	457.6,	461.7,	462.2,	453.1,	457.8,	450.3,	452,	444.2,	447.6,	
		15000,	480.1,	484.6,	489.7,	481,	479.7,	483.6,	476.2,	477.6,	468.9,	467,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		44.6,	36.8,	33.7,	31.7,	30.1,	29.9,	27.5,		
		500,	0,		0,		58.5,	44.2,	35.5,	32.7,	31.2,	29.8,	30,		28,		
		700,	0,		0,		55.7,	43.3,	35,		32.4,	31.9,	30.9,	31,		29.4,		
		1000,	0,		0,		51.7,	43.5,	38,		34.8,	36.6,	35.8,	34,		34.1,		
		2000,	69.6,	57.3,	47.9,	42.8,	38.2,	33.7,	38.5,	38,		38.2,	41.7,		
		3000,	63.8,	56.1,	48,		43.2,	39.6,	34.9,	42.2,	41.6,	39.9,	38.2,		
		4000,	64.2,	56.1,	50.2,	45,		40.4,	35.7,	36,		39.2,	34.1,	33.9,		
		5000,	63.1,	56.2,	50.9,	45.1,	40.8,	37.2,	37.1,	36.2,	35.4,	34.1,		
		6000,	63.6,	57.4,	54.3,	46.6,	42.8,	40.5,	38,		38.2,	37.6,	36.3,		
		7000,	70.4,	66.6,	60.9,	51.7,	45.2,	42.9,	40.5,	41.7,	39.5,	38.6,		
		8000,	79.5,	71.1,	64.2,	58.1,	47,		44.9,	42.6,	46.3,	45,		42.3,		
		9000,	80.7,	73,		66.9,	59,		52.2,	48.1,	46.2,	53.8,	52.9,	46.6,		
		10000,	74.9,	69.9,	67.2,	60.1,	52.7,	48.9,	58.8,	59,		57.1,	53.6,		
		11000,	75.8,	71.9,	64.5,	58.7,	56.3,	61.5,	63.8,	64,		63,		59.1,		
		12000,	77,		71,		66.3,	62.7,	57.5,	67.9,	68.7,	69.5,	69.6,	63.8,		
		13000,	80.7,	74.9,	67.7,	74.3,	73.9,	74.1,	74.8,	75.5,	73.1,	68.4,		
		14000,	81.5,	76,		82.1,	80.6,	80.1,	83,		80.7,	81.2,	78.6,	78,		
		15000,	82.5,	91,		91.4,	89.7,	89,		86.2,	86.4,	86.7,	83.9,	83.1,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		71.9,	64.1,	64,		64,		63.6,	63.1,	62.2,		
		500,	0,		0,		64.9,	75.4,	65.8,	66.1,	66.1,	65.7,	65.2,	64.5,		
		700,	0,		0,		72,		78.4,	67.8,	68.3,	68.1,	68.4,	69.1,	68.4,		
		1000,	0,		0,		72.4,	81.9,	91.8,	72.4,	74.9,	75.8,	74.6,	75.1,		
		2000,	82.7,	85.6,	86.3,	92.4,	103.8,	82.2,	88.2,	88.9,	89.5,	92.6,		
		3000,	100.5,	103.4,	101.5,	103.6,	104.7,	93.8,	102,	102.4,	101.7,	100.6,	
		4000,	116,	116.7,	115.8,	114.5,	113.5,	104.4,	106.2,	109.7,	104.6,	104.5,	
		5000,	127.4,	132.8,	127.5,	127,	123.1,	115.7,	117.9,	117.2,	116.2,	115,	
		6000,	139.8,	145.1,	141.7,	138.9,	137.6,	132.5,	126.6,	128.7,	128.5,	128.4,	
		7000,	175.4,	163.7,	157.9,	151.5,	147.1,	141.6,	136.8,	139.7,	138.6,	138.1,	
		8000,	193.5,	246.8,	168.7,	162.6,	154.8,	149.8,	145.8,	152.3,	152.5,	150.4,	
		9000,	192,	273.7,	179.9,	172.4,	165.4,	158.9,	155.7,	166.9,	168.5,	162.3,	
		10000,	174.7,	169.8,	166.7,	159.7,	170.6,	164.9,	174.6,	174.8,	180.5,	179,	
		11000,	199,	196.9,	189.9,	186.2,	183.2,	188.6,	188.4,	189.3,	192.2,	190.2,	
		12000,	206.4,	202.6,	199,	195.9,	189.7,	200.1,	200.9,	201.9,	200.4,	199.3,	
		13000,	218.1,	215.2,	207.9,	213.7,	211.4,	213.1,	211.5,	212.3,	208.1,	208.7,	
		14000,	223.6,	221.5,	227.8,	227,	224.5,	227.9,	224,	224.5,	220.1,	219.2,	
		15000,	231.9,	241.2,	243.4,	240.3,	239.6,	238.4,	236.4,	236.6,	231.8,	230.2,	
	},
	
	shape_table_data =
	{
		{
			name	 = "GB-6-HE",
			file	 = "gb6",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("GB-6-HE"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	warhead		= simple_warhead(0),

	fm =	{
		mass				= 620,
		caliber				= 0.54,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 4.5,
		I					= 1 / 12 * 620 * 4.5 * 4.5,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 1.8,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.85,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff = {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 1,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
		target_point_always_on_surface	= 0,
	},
	
	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	autopilot =	{
		delay						= 0.5,
		K							= 194,
		Ki							= 0.00007,
		Kg							= 2.5,
		nw_K						= 72,
		nw_Ki						= 0.00007,
		nw_Kg						= 0.8,
		finsLimit					= 0.7,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.2,
		egm_Angle_K					= 0.25,
		egm_FinAngle_K				= 0.40,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.35,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0.0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.4,
		err_limit		= 0.24,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.0024,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 4.0,
		Kx				= 0.03,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.4,
		Kpj					= 0.5,	
	},

	warhead     = predefined_warhead("GB-6-HE"),
	warhead_air = predefined_warhead("GB-6-HE"),	
	
}

declare_weapon(GB_6_HE)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{GB-6-HE}",
	attribute		= GB_6_HE.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "gb6.png",
	displayName		= _("GB-6-HE"),
	Weight			= 620,
	Elements  		= {{ShapeName = "gb6"}},
	ejectVelocity   = 3,
})

LS_6 =
{
	category		= CAT_MISSILES,
	name			= "LS_6",
	user_name		= _("LS-6-250"),
	display_name_short = "LS-250",
	scheme			= "JSOW_C",
	class_name		= "wAmmunitionCruise",
	model			= "ls-6-250",
	mass			= 275.0,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort          = 0,
    Head_Type       = 5,
    sigma           = {20, 20, 20},
    M               = 275.0,
    H_max           = 28000.0,
    H_min           = 100,
    Diam            = 299.0,
    Cx_pil          = 8,
    D_max           = 115000.0,
    D_min           = 10000.0,
    Head_Form       = 1,
    Life_Time       = 9999,
    Nr_max          = 10,
    v_min           = 10.0,
    v_mid           = 200.0,
    Mach_max        = 1.7,
    t_b             = 0.0,
    t_acc           = 0.0,
    t_marsh         = 0.0,
    Range_max       = 115000.0,
    H_min_t         = 0.0,
    Fi_start        = 3.14152,
    Fi_rak          = 3.14152,
    Fi_excort       = 3.14152,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    X_back          = 0.0,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.03,
    KillDistance    = 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		12000,	19200,	18200,	24200,	26200,	27600,	28400,	28600,	
		500,	0,		0,		13400,	20600,	21600,	26800,	30000,	32000,	33400,	34400,	
		700,	0,		0,		15000,	22200,	23400,	28400,	31600,	33600,	35000,	36200,	
		1000,	0,		11000,	17200,	24400,	32400,	31000,	34400,	36400,	37800,	39000,	
		2000,	13000,	18600,	24600,	31600,	40000,	38000,	41600,	43800,	45400,	47000,	
		3000,	20400,	26000,	32000,	37200,	42400,	44000,	47600,	50000,	52000,	54800,	
		4000,	28400,	32800,	38800,	44400,	48800,	49200,	53200,	56000,	58000,	60400,	
		5000,	35200,	40000,	45200,	50800,	55600,	54800,	59200,	61600,	64400,	66800,	
		6000,	41600,	46400,	52000,	57200,	62000,	64800,	64400,	67200,	70000,	72800,	
		7000,	48000,	52800,	57600,	64000,	68000,	70400,	68800,	72000,	74400,	81600,	
		8000,	53600,	58400,	64800,	70400,	73600,	76000,	73600,	76800,	80800,	87200,	
		9000,	60000,	64800,	71200,	76000,	80000,	81600,	83200,	81600,	84400,	90400,	
		10000,	65600,	67200,	70400,	72800,	74400,	76000,	76800,	86400,	89600,	94400,	
		11000,	73200,	78000,	80400,	84000,	86400,	87600,	88800,	90000,	93600,	98400,	
		12000,	79200,	82800,	86400,	90000,	92400,	92400,	92400,	93600,	97200,	102000,	
		13000,	84000,	87600,	92400,	93600,	96000,	97200,	98400,	98400,	99600,	104400,	
		14000,	88800,	92400,	96000,	99600,	102000,	103200,	103200,	104400,	104400,	106800,	
		15000,	93000,	98000,	101000,	104000,	106000,	108000,	108000,	109000,	112000,	115000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		8400,	9000,	9000,	9600,	9800,	9800,	10000,	10000,	
		500,	0,		0,		8600,	9200,	9400,	9800,	10000,	10200,	10400,	10400,	
		700,	0,		0,		8800,	9400,	9400,	10000,	10200,	10400,	10600,	10600,	
		1000,	0,		8400,	9000,	9600,	10200,	10200,	10400,	10600,	10800,	10800,	
		2000,	8600,	9000,	9600,	10200,	11000,	10800,	11200,	11400,	11400,	11600,	
		3000,	9200,	9600,	10400,	10800,	11200,	11600,	11600,	12000,	12000,	12000,	
		4000,	10000,	10400,	10800,	11600,	12000,	12000,	12400,	12400,	12800,	12800,	
		5000,	10800,	11200,	11600,	12000,	12400,	12400,	12800,	12800,	13200,	13600,	
		6000,	11200,	11600,	12000,	12400,	13200,	13200,	13200,	13600,	13600,	14000,	
		7000,	12000,	12000,	12800,	13600,	13600,	13600,	13600,	14400,	14400,	14000,	
		8000,	12800,	12800,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	14600,	
		9000,	12800,	13600,	14400,	14400,	15200,	15200,	15200,	15200,	15800,	15800,	
		10000,	13600,	13600,	13600,	14400,	14400,	14400,	14400,	15200,	16000,	16000,	
		11000,	13200,	14400,	14400,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	
		12000,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		13000,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	15600,	16800,	
		14000,	15600,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	13200,	
		15000,	15600,	15600,	15600,	16800,	16800,	16800,	16800,	16800,	16800,	18000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		78.7,	116,	82.3,	101.7,	103.1,	103.6,	102.3,	98.2,		
		500,	0,		0,		87,		123.5,	100.2,	114.9,	122.6,	126.4,	128.2,	128.1,	
		700,	0,		0,		96.8,	132.5,	109.4,	122.6,	130.1,	133.7,	135.4,	136.3,	
		1000,	0,		83.3,	109.3,	144.1,	180.3,	135.6,	143.9,	147.3,	148.7,	149.2,	
		2000,	108.4,	131.6,	149.3,	175.6,	215.9,	169.6,	178.1,	181.8,	183.5,	185.3,	
		3000,	149.1,	171.5,	186.4,	194.2,	204.4,	196.2,	203.7,	207.9,	211.4,	220.5,	
		4000,	189.6,	202.1,	216.7,	226,	228.9,	216.1,	225.8,	231.8,	234.1,	238.9,	
		5000,	218,	233.3,	242.6,	250.4,	255.4,	239,	250.5,	252.9,	259.4,	262.4,	
		6000,	242.3,	257.1,	270.6,	274.1,	278.2,	280.8,	270.4,	274.7,	279.8,	284,	
		7000,	266,	280.1,	288.2,	300.2,	298.5,	299.6,	285.1,	291.4,	292.5,	325.8,	
		8000,	283.2,	296.6,	316.5,	322.6,	317.2,	319.1,	303.1,	308.6,	319.2,	345.2,	
		9000,	306.2,	318.7,	339.4,	339.9,	342.6,	339.2,	340.7,	326.4,	332.9,	352.5,	
		10000,	320.8,	308.4,	307.2,	303.7,	301.4,	303,	301.4,	345.2,	347.7,	358.6,	
		11000,	354,	363.4,	354.1,	357.9,	359.8,	357.7,	358.9,	356.5,	360.9,	370.6,	
		12000,	377,	378,	379,	383.6,	385.3,	374.2,	367.3,	368.7,	374.6,	383.3,	
		13000,	393.1,	394.7,	405.9,	392.7,	394.1,	391,	392.7,	385.4,	383.2,	392.2,	
		14000,	411.6,	413.3,	415.5,	420.3,	420.8,	417.7,	410.8,	411.4,	400.9,	396.8,	
		15000,	422,	433.5,	435.5,	440,	430.6,	428.8,	421.5,	421.2,	428,	424.3,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		50.4,	45.3,	35.6,	34.1,	32.1,	29.5,	28.2,	27.1,		
		500,	0,		0,		52,		45.1,	36.4,	35,		32.6,	31,		29.7,	27.6,		
		700,	0,		0,		52.1,	45.6,	36,		34.9,	32.6,	31.3,	29.8,	27.8,		
		1000,	0,		61.4,	52.1,	46.1,	42.9,	37.3,	34.4,	32.8,	31.4,	29.2,		
		2000,	66.6,	58,		52.1,	47.9,	44.6,	37.1,	35.4,	34.2,	32.1,	30.7,		
		3000,	65.1,	58.8,	54.8,	49.4,	45.8,	39.9,	36.8,	36,		34.2,	31.8,		
		4000,	66.7,	61.6,	54.6,	50.2,	45.9,	41.5,	39.9,	37.1,	35.9,	33.7,		
		5000,	68.2,	64,		56.9,	51.4,	47.6,	40.9,	40.8,	37,		35.1,	33.7,		
		6000,	67.6,	64.4,	57.9,	53,		50.5,	50.6,	42.5,	39.8,	36.8,	34.9,		
		7000,	68.8,	64.9,	60.6,	56.9,	55.8,	52.9,	44.3,	42.6,	39.3,	35.5,	
		8000,	70.5,	66.9,	63.3,	57.8,	59.1,	52.8,	49.9,	43.7,	41.7,	35.6,	
		9000,	69.7,	69.1,	66.4,	61,		58.9,	56,		53.9,	45.8,	38.4,	36.5,		
		10000,	73.8,	66,		61.7,	59.4,	55.9,	53.3,	51.2,	49,		46.8,	44.2,		
		11000,	68.1,	66,		61.2,	57.3,	54.4,	52.1,	52.9,	50.9,	45.1,	43,		
		12000,	72.3,	66.9,	62.3,	61.4,	58.4,	56,		54,		51.9,	50.1,	45.7,		
		13000,	73.1,	68,		66.4,	62.7,	59.6,	57.2,	55,		52.9,	50.4,	46.9,		
		14000,	77.3,	72.1,	67.6,	63.9,	63.5,	60.9,	58.6,	56.3,	53.4,	45.2,		
		15000,	78.2,	73.3,	68.9,	67.8,	64.7,	62,		59.6,	57.1,	54,		52.7,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		64.4,	77.2,	57.3,	63.4,	62.1,	61.2,	60.1,	57.5,		
		500,	0,		0,		67.8,	80.8,	66,		69.1,	69.9,	70,		69.6,	68.2,		
		700,	0,		0,		72,		84.1,	69.6,	72.2,	73,		73.1,	72.7,	71.6,		
		1000,	0,		71,		77.1,	87.7,	102.5,	77.3,	78.6,	78.6,	78.2,	77,		
		2000,	87.2,	91.5,	94.2,	100,	119.8,	91,		92.9,	93.2,	92.5,	92.1,		
		3000,	105.6,	109.3,	110.8,	109.5,	109.6,	102.9,	103.8,	104.7,	104.5,	131.3,	
		4000,	123.7,	124.1,	123.5,	123.3,	120.8,	112.1,	114.7,	109.4,	109.7,	109.7,	
		5000,	136.3,	138.4,	135.5,	133.5,	131.7,	122.2,	119.1,	118.9,	120.4,	120.5,	
		6000,	145.8,	148.1,	146.9,	143.2,	142.7,	141.9,	128,	131.1,	131.1,	133.8,	
		7000,	155.7,	157.1,	155.7,	155.4,	152.3,	150.9,	134.2,	137.7,	137.5,	137.4,	
		8000,	163.1,	164.6,	167.6,	164.3,	162,	160.7,	150.7,	144,	148.4,	150.9,	
		9000,	170.1,	173.5,	177.3,	173.7,	173.5,	170.5,	169.2,	152.1,	154.2,	156.6,		
		10000,	173.8,	167.5,	163.1,	159.9,	156.4,	154.8,	152.6,	158.6,	159.9,	161.5,	
		11000,	183.9,	186.3,	180.5,	178.7,	177.1,	174.6,	175.4,	163.4,	163,	163.7,	
		12000,	194.2,	192.1,	189.4,	190.2,	188.4,	183.5,	179.5,	177.7,	165.9,	168.4,	
		13000,	199.9,	198.2,	200.8,	194.6,	192.7,	189.9,	188,	183.6,	179.8,	168.4,	
		14000,	208.6,	207.1,	205,	203.6,	203.8,	200.9,	196.4,	193.9,	187.7,	174.1,		
		15000,	214.7,	218.1,	214.9,	212.2,	209,	207.5,	202.8,	199.4,	196.3,	188.6,	
	},
	
	shape_table_data =
	{
		{
			name	 = "LS_6",
			file	 = "ls-6-250",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("LS-6-250"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm =	{
		mass				= 275.0,
		caliber				= 0.299,
		cx_coeff            = {1, 0.82, 0.8, 0.18, 1.5},
		L					= 2.48,
		I					= 1 / 12 * 275.0 * 2.48 * 2.48,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 0.4,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.5,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff	= {1, 0.42, 0.8, 0.10, 1.52},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 1,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
	},

	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		wo_wings_no_fin_stage		= 1,
		no_fin_stage_dive			= 0.5,
	},

	autopilot =	{
		delay						= 0.3,
		K							= 115,
		Ki							= 0.00008,
		Kg							= 2.6,
		nw_K						= 45,
		nw_Ki						= 0.00008,
		nw_Kg						= 1.6,
		finsLimit					= 0.8,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.25,
		egm_Angle_K					= 0.2,
		egm_FinAngle_K				= 0.3,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.3,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.5,
		err_limit		= 0.5,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.04,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 10.0,
		Kx				= 0.04,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.5,
		Kpj					= 0.5,	
	},	
	
	warhead     = predefined_warhead("LS_6_250"),
	warhead_air = predefined_warhead("LS_6_250"),	
}

declare_weapon(LS_6)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{LS-6-250}",
	attribute		= LS_6.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "ls-6.png",
	displayName		= _("LS-6-250"),
	Weight			= 275,
	Elements  		= {{ShapeName = "ls-6-250"}},
	ejectVelocity   = 3,
})

LS_6_500 =
{
	category		= CAT_MISSILES,
	name			= "LS_6_500",
	user_name		= _("LS-6-500"),
	display_name_short = "LS-500",
	scheme			= "JSOW_C",
	class_name		= "wAmmunitionCruise",
	model			= "ls-6",
	mass			= 525.0,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort          = 0,
    Head_Type       = 5,
    sigma           = {20, 20, 20},
    M               = 525.0,
    H_max           = 28000.0,
    H_min           = 100,
    Diam            = 377.0,
    Cx_pil          = 8,
    D_max           = 105000.0,
    D_min           = 9000.0,
    Head_Form       = 1,
    Life_Time       = 9999,
    Nr_max          = 10,
    v_min           = 10.0,
    v_mid           = 200.0,
    Mach_max        = 1.7,
    t_b             = 0.0,
    t_acc           = 0.0,
    t_marsh         = 0.0,
    Range_max       = 100000.0,
    H_min_t         = 0.0,
    Fi_start        = 3.14152,
    Fi_rak          = 3.14152,
    Fi_excort       = 3.14152,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    X_back          = 0.0,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.07,
    KillDistance    = 0.0,
	
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		9800,	16800,	18000,	23200,	26600,	29000,	30800,	32600,	
		500,	0,		0,		11400,	18200,	21200,	26400,	30400,	32800,	34800,	36600,	
		700,	0,		0,		12600,	19400,	22800,	28200,	31800,	34200,	36200,	38000,	
		1000,	0,		0,		14600,	21400,	29200,	30000,	33600,	36200,	38000,	40000,	
		2000,	10400,	15000,	21200,	28200,	36200,	35800,	39600,	42200,	44400,	46600,	
		3000,	16400,	21600,	27600,	33600,	40000,	41200,	45200,	48000,	50400,	52800,	
		4000,	23200,	28400,	34000,	40000,	45200,	46800,	50800,	53600,	56000,	58400,	
		5000,	29600,	34400,	40000,	46000,	51600,	51600,	55600,	58400,	61200,	64400,	
		6000,	36000,	40400,	46000,	52400,	57200,	60400,	60400,	63200,	66000,	69200,	
		7000,	40800,	46400,	51200,	57600,	62400,	64800,	64800,	67200,	70400,	73600,	
		8000,	47200,	52000,	56800,	63200,	67200,	70400,	68000,	72000,	74400,	74800,	
		9000,	52000,	56800,	62400,	68000,	72800,	74400,	68000,	75200,	75200,	75800,	
		10000,	56800,	60800,	64800,	67200,	69600,	71200,	72000,	77600,	57600,	85600,	
		11000,	63600,	68400,	70800,	75600,	78000,	79200,	80400,	81600,	85200,	88800,	
		12000,	68400,	72000,	75600,	79200,	80400,	82800,	84000,	84000,	87600,	91200,	
		13000,	72000,	75600,	80400,	82800,	85200,	86400,	87600,	88800,	90000,	92400,	
		14000,	75600,	80400,	82800,	86400,	88800,	90000,	91200,	92400,	92400,	95400,	
		15000,	79200,	82800,	86400,	90000,	92400,	92400,	93600,	94800,	96000,	97400,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		8200,	8800,	9000,	9400,	9800,	10000,	10200,	10200,	
		500,	0,		0,		8400,	9000,	9200,	9800,	10000,	10400,	10400,	10600,	
		700,	0,		0,		8400,	9200,	9400,	10000,	10200,	10400,	10600,	10800,	
		1000,	0,		0,		8600,	9200,	10000,	10000,	10400,	10600,	10800,	11000,	
		2000,	8200,	8800,	9200,	10000,	10600,	10600,	11000,	11200,	11400,	11600,	
		3000,	8800,	9200,	10000,	10400,	11200,	11200,	11600,	11600,	12000,	12000,	
		4000,	9600,	10000,	10400,	11200,	11600,	11600,	12000,	12400,	12400,	12800,	
		5000,	10000,	10400,	11200,	11600,	12000,	12000,	12400,	12800,	12800,	13200,	
		6000,	10800,	11200,	11600,	12000,	12400,	12800,	12800,	13200,	13200,	13600,	
		7000,	11200,	12000,	12000,	12800,	13600,	13600,	13600,	13600,	13600,	14400,	
		8000,	12000,	12000,	12800,	13600,	13600,	13600,	13600,	14400,	14400,	12000,	
		9000,	12000,	12800,	13600,	13600,	14400,	14400,	13600,	14400,	12800,	12800,	
		10000,	12800,	12800,	13600,	13600,	13600,	14400,	14400,	14400,	12800,	15200,	
		11000,	13200,	13200,	13200,	14400,	14400,	14400,	14400,	14400,	14400,	15600,	
		12000,	13200,	13200,	14400,	14400,	14400,	14400,	14400,	14400,	14400,	15600,	
		13000,	13200,	14400,	14400,	14400,	14400,	14400,	14400,	15600,	15600,	15600,	
		14000,	14400,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	15600,	15600,	
		15000,	14400,	14400,	14400,	15600,	15600,	15600,	15600,	16800,	18000,	16800,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		62.3,	97.2,	79.6,	94.7,	102.2,	107.1,	110,	112.8,	
		500,	0,		0,		72.5,	105.1,	95.3,	110.4,	121.3,	126.1,	130,	132.7,	
		700,	0,		0,		78.9,	111.2,	102.6,	118.8,	127.3,	132.1,	135.9,	138.4,	
		1000,	0,		0,		90.2,	121.8,	155.5,	126.4,	134.7,	140.4,	142.9,	146.3,	
		2000,	81.4,	103.3,	125.2,	152.5,	187.5,	150,	159,	164.3,	168.4,	172,	
		3000,	115.6,	137.3,	155,	167.4,	183.7,	170.3,	180.1,	185.9,	190.5,	194.3,	
		4000,	149.2,	168.3,	182.2,	193.1,	199.4,	192.4,	201.8,	207.2,	211,	213.8,	
		5000,	176,	190.8,	205.9,	215.2,	223.2,	210,	219.3,	224.2,	229.6,	236,	
		6000,	201.2,	212.3,	229,	239.1,	241.8,	246.3,	237.5,	241.8,	246.4,	251.8,	
		7000,	214,	233,	246.1,	253.6,	258.6,	259,	253.6,	255.1,	261.3,	265.8,	
		8000,	237.8,	250.5,	266.5,	271.8,	274,	280.1,	262.5,	273.6,	274.3,	278,	
		9000,	250.1,	262.3,	285.8,	286.7,	295.4,	291.8,	254.6,	283,	274.4,	280.4,	
		10000,	262,	267.7,	271.6,	268.2,	269.5,	269.7,	267.5,	283.6,	284.9,	304.7,	
		11000,	292.4,	301.8,	294.9,	306,	306.9,	304.2,	304.6,	303.1,	310.4,	315,	
		12000,	309,	311.2,	313.1,	317.2,	310.8,	315.2,	315.8,	308.9,	317.5,	322.3,	
		13000,	319.6,	322.1,	332.4,	329,	329.5,	326.9,	327.4,	327.1,	323.4,	323.1,	
		14000,	331.5,	342.4,	336.9,	341.3,	341.3,	339.5,	339.8,	338.7,	327.7,	322.3,	
		15000,	344.7,	347.2,	349.9,	354.2,	354.1,	345.6,	345.3,	343.5,	338.4,	331.6,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		49.8,	44.4,	35.3,	33.1,	31.5,	29.7,	28.4,	26.2,		
		500,	0,		0,		50.7,	44.3,	35,		35,		32.9,	31.8,	29.7,	28.4,		
		700,	0,		0,		49.3,	44.7,	35.4,	35.1,	32.7,	31.1,	29.9,	28.6,		
		1000,	0,		0,		49.4,	44.5,	40.7,	36.1,	34.8,	33.2,	31.9,	30.7,		
		2000,	60.4,	56.9,	50.4,	46.6,	41.3,	36.2,	34.8,	33.1,	31.5,	29.7,		
		3000,	59.3,	55.9,	52.1,	46.3,	43,		38.8,	37.6,	35.3,	34.1,	31.4,		
		4000,	61.7,	58.3,	53,		48.8,	44.5,	39,		39.5,	38.3,	34.5,	34,		
		5000,	61.7,	58.3,	55.4,	50.1,	46.2,	39.1,	40.3,	39.3,	36.3,	33.8,		
		6000,	63.3,	59.9,	56.4,	51.7,	48,		48.1,	42.1,	41,		37.6,	35.3,		
		7000,	63.4,	61.7,	57.6,	54.4,	54.3,	51.3,	44.8,	42.5,	38.9,	37.5,		
		8000,	65.4,	61.2,	59.8,	57.4,	53.3,	50.5,	46.3,	44.3,	40.9,	34.2,		
		9000,	65,		63.6,	62.4,	58.6,	56.5,	53.7,	47.3,	43.4,	38.6,	36.7,		
		10000,	69,		62.4,	60.4,	56.5,	53.3,	52.6,	50.2,	39.4,	41.9,	41.1,		
		11000,	67.7,	62.2,	57.6,	56.7,	53.6,	51.1,	49,		47.1,	45.9,	42.9,		
		12000,	68.4,	63.2,	61.7,	57.9,	54.8,	52.3,	50.2,	48.1,	46.7,	44.2,		
		13000,	69.3,	67.4,	62.9,	59.2,	56.1,	53.6,	51.5,	51.5,	48.7,	45.7,		
		14000,	73.5,	68.5,	64.2,	60.6,	59.9,	57.3,	54.9,	52.5,	49.6,	46,		
		15000,	74.5,	69.8,	65.6,	64.4,	61.2,	58.5,	56.1,	55.5,	54,		48.9,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		55.2,	69.1,	55.8,	60.1,	62,		62.6,	62.7,	62.3,		
		500,	0,		0,		60.4,	71.8,	63.1,	67.4,	69.3,	70.2,	70.1,	70.4,		
		700,	0,		0,		62.5,	74.4,	66.3,	70.6,	72,		72.5,	72.9,	72.8,		
		1000,	0,		0,		67.2,	77.9,	91.4,	73.4,	75.3,	76.3,	76.3,	76.6,		
		2000,	70.3,	77.8,	83.1,	89.1,	106.3,	83.9,	86.5,	87.5,	88.2,	88.3,		
		3000,	85.5,	93.5,	97.2,	97.8,	101.3,	93.7,	96.8,	95.3,	96.7,	95.7,		
		4000,	102.5,	108.4,	109,	109.9,	109.1,	103.4,	103.6,	104.7,	104.4,	104.3,	
		5000,	113.6,	118.1,	120.1,	119.5,	119.6,	111.1,	112,	113.2,	113.5,	114.9,	
		6000,	124.9,	128.3,	129.1,	129.4,	128.4,	129,	118.2,	119.7,	120,	123,	
		7000,	130.7,	137.7,	135.7,	137.6,	138.2,	136.5,	125.8,	125.4,	126.2,	127.3,	
		8000,	140.9,	143.6,	144.8,	146.9,	144.9,	144.8,	129.4,	133.7,	132.3,	129,		
		9000,	145.2,	149.6,	155.4,	152.9,	154.8,	151.6,	133.1,	137.2,	130.4,	130.6,		
		10000,	150.7,	150.6,	150.2,	145.4,	143,	142.5,	140,	140.4,	134.8,	139.9,	
		11000,	162.4,	162.2,	156.9,	159.7,	157.8,	155,	153.3,	144.2,	142.8,	142.6,	
		12000,	168.3,	166.2,	165.9,	164.4,	160.1,	159.6,	157.6,	153.3,	143.7,	142.8,	
		13000,	172.2,	172.8,	172.8,	169,	166.9,	164,	161.8,	161.4,	146.9,	141.2,	
		14000,	178.8,	179.6,	175.2,	173.7,	173.6,	170.7,	168.1,	165.1,	158.4,	157.3,		
		15000,	183.5,	182,	180,	180.6,	178.2,	172.9,	170.1,	168.7,	165.5,	157.5,	
	},
	
	shape_table_data =
	{
		{
			name	 = "LS_6_500",
			file	 = "ls-6",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("LS-6-500"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm =	{
		mass				= 525.0,
		caliber				= 0.377,
		cx_coeff            = {1, 0.82, 0.8, 0.18, 1.5},
		L					= 3.09,
		I					= 1 / 12 * 525.0 * 3.09 * 3.09,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 0.45,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.6,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff	= {1, 0.42, 0.8, 0.10, 1.52},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},
	
	seeker = {
		coalition						= 1,
		coalition_rnd_coeff				= 5.0,
		can_update_target_pos			= 1,
	},

	control_block =	{
		seeker_activation_dist		= 7000,
		default_cruise_height		= -1,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 2.2,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},

	autopilot =	{
		delay						= 0.3,
		K							= 120,
		Ki							= 0.00008,
		Kg							= 3.0,
		nw_K						= 50,
		nw_Ki						= 0.00008,
		nw_Kg						= 1.2,
		finsLimit					= 0.8,
		useJumpByDefault			= 0,
		J_Power_K					= 4.8,
		J_Diff_K					= 3.2,
		J_Int_K						= 0.0,
		J_Angle_W					= 0.1,
		hKp_err						= 50,
		Kx							= 0.014,
		Kxd							= 0.0,
		K_err_mlt					= 5.0,
		K_roll_diff_mlt				= 5.0,
		roll_limit					= 1.3,
		w_limit						= 1.3,
		fins_limit_x				= 0.25,
		egm_Angle_K					= 0.2,
		egm_FinAngle_K				= 0.3,
		egm_add_power_K				= 0.2,
		wings_depl_fins_limit_K		= 0.3,
		err_new_wlos_k				= 1.0,
		err_aoaz_k					= 0,
		err_aoaz_sign_k				= 0.0,
		
		alternative_roll_params	= 1,
		w_x_limit		= 0.5,
		err_limit		= 0.5,
		err_min			= 0.04,
		corr_err_min	= 0.006,
		roll_limit		= 0.9,
		fins_limit_x	= 0.04,
		K_err_mlt		= 4.0,
		K_roll_diff_mlt	= 10.0,
		Kx				= 0.04,
		
		alternative_jump_params	= 1,
		K_pitch_diff_mlt	= 5.0,
		w_limit				= 0.5,
		Kpj					= 0.5,	
	},

	warhead     = predefined_warhead("LS_6_500"),
	warhead_air = predefined_warhead("LS_6_500"),	
}

declare_weapon(LS_6_500)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{LS-6-500}",
	attribute		= LS_6_500.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "ls-6.png",
	displayName		= _("LS-6-500"),
	Weight			= 525,
	Elements  		= {{ShapeName = "ls-6"}},
	ejectVelocity   = 3,
})


--------------------------------------------------------------------------
--							BOMBKAPSEL-90								--
--------------------------------------------------------------------------

function BK_90 (name, user_name, scheme, cluster_name, cluster_scheme_, open_dist_k, bomblets_data)
	
	local bk ={}
	bk.category		= CAT_MISSILES
	bk.name			= name
	bk.user_name	= user_name
	bk.scheme		= scheme
	bk.class_name	= "wAmmunitionSelfHoming"
	bk.model		= "BK_90"
	bk.mass			= 605
	
	bk.wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER}

	bk.Escort			= 0
	bk.Head_Type		= 5
	bk.sigma			= {20, 20, 20}
	bk.M				= 605.0
	bk.H_max			= 1600.0
	bk.H_min			= 50
	bk.Diam				= 400.0
	bk.Cx     			= 0.0024
	bk.Cx_pil     		= 10
	bk.D_max			= 10000.0
	bk.D_min			= 1500.0
	bk.Head_Form		= 0
	bk.Life_Time		= 1000
	bk.Nr_max			= 4
	bk.v_min			= 170.0
	bk.v_mid			= 240.0
	bk.Mach_max			= 0.95
	bk.t_b				= 0.0
	bk.t_acc			= 0.0
	bk.t_marsh			= 0.0
	bk.Range_max		= 10000.0
	bk.H_min_t			= 0.0
	bk.Fi_start			= 1.57
	bk.Fi_rak			= 3.14152
	bk.Fi_excort		= 3.14152
	bk.Fi_search		= 99.9
	bk.OmViz_max		= 99.9
	bk.X_back			= 0.0
	bk.Y_back			= 0.0
	bk.Z_back			= 0.0
	bk.Reflection		= 0.15
	bk.KillDistance		= 0.0
	
	bk.LaunchDistData = 
	{		
		10,		8,
		
				160,	180,	200,	220,	240,	260,	280,	300,	
		50,		500,	2200,	3000,	4800,	6800,	8800,	9600,	10000,	
		100,	1200,	2600,	4000,	5800,	7600,	9500,	9800,	10000,	
		150,	1600,	3000,	4200,	6000,	8000,	9600,	9900,	10000,	
		200,	1800,	3000,	4400,	6200,	8200,	9600,	9900,	10000,	
		250,	2000,	3200,	4600,	6200,	8200,	9600,	10000,	10000,	
		300,	2200,	3300,	4600,	6400,	8400,	9700,	10000,	10000,	
		350,	2200,	3400,	4700,	6400,	8400,	9800,	10000,	10000,	
		400,	2400,	3400,	4700,	6600,	8500,	9800,	10000,	10000,	
		450,	2400,	3400,	4700,	6600,	8500,	9900,	10000,	10000,	
		500,	2500,	3500,	4800,	6700,	8600,	9900,	10000,	10000,	
	}
		
	bk.shape_table_data =
	{
		{
			name	 = name,
			file	 = "BK_90",
			life	 = 1,
			fire	 = { 0, 1},
			username = user_name,
			index	 = WSTYPE_PLACEHOLDER,
		},
	}
	
	bk.warhead		= simple_warhead(0)
	
	bk.fm =
	{
		mass        = 605.0,  
		caliber     = 0.55,  
		L           = 3.5,
		I           = 270,
		Ma          = 1.0,
		Mw          = 3.0,
		cx_coeff	= {1, 0.3, 0.65, 0.09, 1.4},
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		dCydA		= {0.09, 0.036},
		A			= 0.13,
		maxAoa		= 0.4,
		finsTau		= 0.2,
		Sw			= 0.3,
		Ma_x		= 1.0,
		Kw_x		= 0.01,
		I_x			= 25,
	}
	
	bk.autopilot =
	{
		delay				= 2.0,
		Kpv					= 0.024,
		Kdv					= 3.0,
		Kiv					= 0.000012,
		Kph					= 28.0,
		Kdh					= 2.0,
		Kih					= 0.0,
		glide_height		= 120.0,
		use_current_height	= 1,
		max_vert_speed 		= 40.0,
		altim_vel_k			= 1.0,
		finsLimit			= 0.8,
	}
	
	bk.open_trigger = 
	{
		delay			= 2.0,
		trigger_dist_k	= open_dist_k,
	}

	local scheme_data =  bomblets_data
	
	scheme_data.dispenser = 
	{
		mass					= 605,
		caliber					= 0.55,
		L						= 3.5,
		I						= 270.0,
		Ma						= 1,
		Mw						= 3,
		cx_coeff				= {1, 0.3, 0.65, 0.09, 1.4},
		model_name				= "BK_90",
		set_start_args			= {},
		spawn_time				=	{
										0,
										0.2,	0.22,	0.24,	0.26,
										0.4,	0.42,	0.44,	0.46,
										0.6,	0.62,	0.64,	0.66,
										0.8,	0.82,	0.84,	0.86,
										1.0,	1.02,	1.04,	1.06,
										1.2,	1.22,	1.24,	1.26,
									},
		spawn_weight_loss		= {0,	16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9,
										16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9,
										16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9, 16.9,},
		spawn_args_change		=	{
										{1,31,1},	{2,32,1},	{3,33,1},	{4,34,1},
										{5,35,1},	{6,36,1},	{7,37,1},	{8,38,1},
										{9,39,1},	{10,40,1},	{11,41,1},	{12,42,1},
										{13,43,1},	{14,44,1},	{15,45,1},	{16,46,1},
										{17,47,1},	{18,48,1},	{19,49,1},	{20,50,1},
										{21,51,1},	{22,52,1},	{23,53,1},	{24,54,1},
									},
		op_spawns				= 26,
		use_effects				= 0,
		hide_effect_0			= 1,
	}
	
	local levParam = 
	{
		scheme			= scheme_data,
		name    		= cluster_name,
		type_name		= _("cluster"),
		cluster_scheme	= cluster_scheme_,
	}
	
	bk.launcher =
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster, levParam),
    }
	
	declare_weapon(bk)
	return bk
end

local DWS39_MJ1 = BK_90("DWS39_MJ1", _("DWS39 MJ1"), "inertial_guided_glide_bomb", _("MJ1"), "disp_bomblets", 1.4, {
	bomblets =
	{
		wind_sigma					= 25,
		impulse_sigma				= 4,
		moment_sigma				= 0.1,
		count						= 72,
		effect_count				= 72,
		mass						= 6,
		caliber						= 0.132,
		cx_coeff					= {1, 0.39, 0.38, 0.236, 1.31},
		L							= 0.3,
		I							= 0.02,
		Ma							= 0.06,
		Mw							= 0.8,
		model_name					= "MUS_JAS_1",
		init_pos					=	{
											{1.0674599409103394,	0.12363214790821075,	-0.2},
											{1.0674599409103394,	0.12363214790821075,	0.0},
											{1.0674599409103394,	0.12363214790821075,	0.2},
											
											{1.0674779415130615,	-0.0071935374289751053,	-0.2},
											{1.0674779415130615,	-0.0071935374289751053,	0.0},
											{1.0674779415130615,	-0.0071935374289751053,	0.2},
											
											{0.90919733047485352,	-0.0064242500811815262,	-0.2},
											{0.90919733047485352,	-0.0064242500811815262,	0.0},
											{0.90919733047485352,	-0.0064242500811815262,	0.2},
											
											{0.90921545028686523,	0.12363214790821075,	-0.2},
											{0.90921545028686523,	0.12363214790821075,	0.0},
											{0.90921545028686523,	0.12363214790821075,	0.2},
											
											{0.75522589683532715,	0.12363214790821075,	-0.2},
											{0.75522589683532715,	0.12363214790821075,	0.0},
											{0.75522589683532715,	0.12363214790821075,	0.2},
											
											{0.75508940219879150,	-0.0071935374289751053,	-0.2},
											{0.75508940219879150,	-0.0071935374289751053,	0.0},
											{0.75508940219879150,	-0.0071935374289751053,	0.2},
											
											{0.59696328639984131,	-0.0064242500811815262,	-0.2},
											{0.59696328639984131,	-0.0064242500811815262,	0.0},
											{0.59696328639984131,	-0.0064242500811815262,	0.2},														
											
											{0.59682685136795044,	0.12363214790821075,	-0.2},
											{0.59682685136795044,	0.12363214790821075,	0.0},
											{0.59682685136795044,	0.12363214790821075,	0.2},
											
											{0.44255921244621277,	0.12363214790821075,	-0.2},
											{0.44255921244621277,	0.12363214790821075,	0.0},
											{0.44255921244621277,	0.12363214790821075,	0.2},
											
											{0.44267767667770386,	-0.0071935374289751053,	-0.2},
											{0.44267767667770386,	-0.0071935374289751053,	0.0},
											{0.44267767667770386,	-0.0071935374289751053,	0.2},
											
											{0.28429663181304932,	-0.0064242351800203323,	-0.2},
											{0.28429663181304932,	-0.0064242351800203323,	0.0},
											{0.28429663181304932,	-0.0064242351800203323,	0.2},
											
											{0.28441512584686279,	0.12363214790821075,	-0.2},
											{0.28441512584686279,	0.12363214790821075,	0.0},
											{0.28441512584686279,	0.12363214790821075,	0.2},
											
											{0.13067781925201416,	0.12363214790821075,	-0.2},
											{0.13067781925201416,	0.12363214790821075,	0.0},
											{0.13067781925201416,	0.12363214790821075,	0.2},
											
											{0.13079625368118286,	-0.0071935225278139114,	-0.2},
											{0.13079625368118286,	-0.0071935225278139114,	0.0},
											{0.13079625368118286,	-0.0071935225278139114,	0.2},
											
											{-0.027584791183471680,	-0.0064242351800203323,	-0.2},
											{-0.027584791183471680,	-0.0064242351800203323,	0.0},
											{-0.027584791183471680,	-0.0064242351800203323,	0.2},
											
											{-0.027466297149658203,	0.12363214790821075,	-0.2},
											{-0.027466297149658203,	0.12363214790821075,	0.0},
											{-0.027466297149658203,	0.12363214790821075,	0.2},
											
											{-0.18173396587371826,	0.12363214790821075,	-0.2},
											{-0.18173396587371826,	0.12363214790821075,	0.0},
											{-0.18173396587371826,	0.12363214790821075,	0.2},
											
											{-0.18187046051025391,	-0.0071935225278139114,	-0.2},
											{-0.18187046051025391,	-0.0071935225278139114,	0.0},
											{-0.18187046051025391,	-0.0071935225278139114,	0.2},
											
											{-0.33999657630920410,	-0.0064242351800203323,	-0.2},
											{-0.33999657630920410,	-0.0064242351800203323,	0.0},
											{-0.33999657630920410,	-0.0064242351800203323,	0.2},
											
											{-0.34013295173645020,	0.12363214790821075,	-0.2},
											{-0.34013295173645020,	0.12363214790821075,	0.0},
											{-0.34013295173645020,	0.12363214790821075,	0.2},
											
											{-0.49412250518798828,	0.12363214790821075,	-0.2},
											{-0.49412250518798828,	0.12363214790821075,	0.0},
											{-0.49412250518798828,	0.12363214790821075,	0.2},
											
											{-0.49410438537597656,	-0.0071935225278139114,	-0.2},
											{-0.49410438537597656,	-0.0071935225278139114,	0.0},
											{-0.49410438537597656,	-0.0071935225278139114,	0.2},
											
											{-0.65238511562347412,	-0.0064242649823427200,	-0.2},
											{-0.65238511562347412,	-0.0064242649823427200,	0.0},
											{-0.65238511562347412,	-0.0064242649823427200,	0.2},
											
											{-0.65236699581146240,	0.12363214790821075,	-0.2},
											{-0.65236699581146240,	0.12363214790821075,	0.0},
											{-0.65236699581146240,	0.12363214790821075,	0.2},
										},
										
		init_ypr					=	{
											{4.7123886426183308,0,0},
											{4.7123886426183308,0,0},
											{4.7123886426183308,0,0},
											{1.5707963148700226,0,0},
											{1.5707963148700226,0,0},
											{1.5707963148700226,0,0},
										},
										
		explosion_impulse_coeff		= 350,
		explosion_dont_use_x_axis	= 1,
		release_rnd_coeff			= 0.9,
		chute_open_time				= 0.4,
		chute_cut_time				= 500.0,
		chute_diam					= 0.8,
		chute_Cx					= 1,
		chute_rnd_coeff				= 0.5,
		explosion_center			=	{{0,0, -10000},{0,0,10000},},
		spawn_options				=	{
											{0,1,3}, {0,2,3}, {0,3,3}, {0,4,3},
											{0,5,3}, {0,6,3}, {0,7,3}, {0,8,3},
											{0,9,3}, {0,10,3}, {0,11,3}, {0,12,3},
											{0,13,3}, {0,14,3}, {0,15,3}, {0,16,3},
											{0,17,3}, {0,18,3}, {0,19,3}, {0,20,3},
											{0,21,3}, {0,22,3}, {0,23,3}, {0,24,3},
										},
	},
	warhead			=  simple_warhead(5.7, 120),
})

local DWS39_MJ2 = BK_90("DWS39_MJ2", _("DWS39 MJ2"), "inertial_guided_glide_bomb", _("MJ2"), "disp_bomblets", 1.5,{
	bomblets =
	{
		wind_sigma					= 25,
		impulse_sigma				= 4,
		moment_sigma				= 0.1,
		count						= 24,
		effect_count				= 24,
		mass						= 18,
		caliber						= 0.132,
		cx_coeff					= {1, 0.39, 0.38, 0.236, 1.31},
		L							= 0.5,
		I							= 0.061333,
		Ma							= 0.06,
		Mw							= 0.8,
		model_name					= "MUS_JAS_2",
		connectors_model_name		= "BK_90",
		explosion_impulse_coeff		= 550,
		explosion_dont_use_x_axis	= 1,
		release_rnd_coeff			= 0.9,
		chute_open_time				= 0.7,
		chute_cut_time				= 500.0,
		chute_diam					= 1.8,
		chute_Cx					= 1,
		chute_rnd_coeff				= 0.65,
		explosion_center			=	{{0,0, -10000},{0,0,10000},},
		spawn_options				=	{
											{0,1,1}, {0,2,1}, {0,3,1}, {0,4,1},
											{0,5,1}, {0,6,1}, {0,7,1}, {0,8,1},
											{0,9,1}, {0,10,1}, {0,11,1}, {0,12,1},
											{0,13,1}, {0,14,1}, {0,15,1}, {0,16,1},
											{0,17,1}, {0,18,1}, {0,19,1}, {0,20,1},
											{0,21,1}, {0,22,1}, {0,23,1}, {0,24,1},
										},
	},
	warhead			=  cumulative_warhead(16.7, 120),
})

local DWS39_MJ1_MJ2 = BK_90("DWS39_MJ1_MJ2", _("DWS39 MJ1-MJ2"), "inertial_guided_glide_bomb", _("MJ1-MJ2"), "disp_2bomblets", 1.6, {
	bomblets =
	{
		wind_sigma			= 25,
		impulse_sigma		= 4,
		moment_sigma		= 0.1,
		count				= 36,
		effect_count		= 36,
		mass				= 6,
		caliber				= 0.132,
		cx_coeff			= {1, 0.39, 0.38, 0.236, 1.31},
		L					= 0.3,
		I					= 0.02,
		Ma					= 0.06,
		Mw					= 0.8,
		model_name			= "MUS_JAS_1",
		init_pos			=	{
									{1.0674599409103394,	0.12363214790821075,	-0.2},
									{1.0674599409103394,	0.12363214790821075,	0.0},
									{1.0674599409103394,	0.12363214790821075,	0.2},
									
									{0.90919733047485352,	-0.0064242500811815262,	-0.2},
									{0.90919733047485352,	-0.0064242500811815262,	0.0},
									{0.90919733047485352,	-0.0064242500811815262,	0.2},
						
									{0.75522589683532715,	0.12363214790821075,	-0.2},
									{0.75522589683532715,	0.12363214790821075,	0.0},
									{0.75522589683532715,	0.12363214790821075,	0.2},
									
									{0.59696328639984131,	-0.0064242500811815262,	-0.2},
									{0.59696328639984131,	-0.0064242500811815262,	0.0},
									{0.59696328639984131,	-0.0064242500811815262,	0.2},														
												
									{0.44255921244621277,	0.12363214790821075,	-0.2},
									{0.44255921244621277,	0.12363214790821075,	0.0},
									{0.44255921244621277,	0.12363214790821075,	0.2},
									
									{0.28429663181304932,	-0.0064242351800203323,	-0.2},
									{0.28429663181304932,	-0.0064242351800203323,	0.0},
									{0.28429663181304932,	-0.0064242351800203323,	0.2},
									
									{0.13067781925201416,	0.12363214790821075,	-0.2},
									{0.13067781925201416,	0.12363214790821075,	0.0},
									{0.13067781925201416,	0.12363214790821075,	0.2},
									
									{-0.027584791183471680,	-0.0064242351800203323,	-0.2},
									{-0.027584791183471680,	-0.0064242351800203323,	0.0},
									{-0.027584791183471680,	-0.0064242351800203323,	0.2},
									
									{-0.18173396587371826,	0.12363214790821075,	-0.2},
									{-0.18173396587371826,	0.12363214790821075,	0.0},
									{-0.18173396587371826,	0.12363214790821075,	0.2},
									
									{-0.33999657630920410,	-0.0064242351800203323,	-0.2},
									{-0.33999657630920410,	-0.0064242351800203323,	0.0},
									{-0.33999657630920410,	-0.0064242351800203323,	0.2},
									
									{-0.49412250518798828,	0.12363214790821075,	-0.2},
									{-0.49412250518798828,	0.12363214790821075,	0.0},
									{-0.49412250518798828,	0.12363214790821075,	0.2},
									
									{-0.65238511562347412,	-0.0064242649823427200,	-0.2},
									{-0.65238511562347412,	-0.0064242649823427200,	0.0},
									{-0.65238511562347412,	-0.0064242649823427200,	0.2},
								},
										
		init_ypr			=	{
									{4.7123886426183308,0,0},
									{4.7123886426183308,0,0},
									{4.7123886426183308,0,0},
									{1.5707963148700226,0,0},
									{1.5707963148700226,0,0},
									{1.5707963148700226,0,0},
								},
		explosion_impulse_coeff		= 350,
		explosion_dont_use_x_axis	= 1,
		release_rnd_coeff			= 0.9,
		chute_open_time				= 0.4,
		chute_cut_time				= 500.0,
		chute_diam					= 0.8,
		chute_Cx					= 1,
		chute_rnd_coeff				= 0.5,
		explosion_center			=	{{0,0, -10000},{0,0,10000},},
		spawn_options				=	{
											{0,1,3}, {0,3,3}, 
											{0,5,3},  {0,7,3}, 
											{0,9,3},  {0,11,3},
											{0,13,3}, {0,15,3}, 
											{0,17,3}, {0,19,3},
											{0,21,3}, {0,23,3},
										},
	},
				
	bomblets2 =
	{
		wind_sigma				= 25,
		impulse_sigma			= 4,
		moment_sigma			= 0.1,
		count					= 12,
		effect_count			= 12,
		mass					= 18,
		caliber					= 0.132,
		cx_coeff				= {1, 0.39, 0.38, 0.236, 1.31},
		L						= 0.5,
		I						= 0.061333,
		Ma						= 0.06,
		Mw						= 0.8,
		model_name				= "MUS_JAS_2",
		init_pos				=	{
										{1.0674779415130615,	-0.0071935374289751053,	0.0},
										{0.90921545028686523,	0.12363214790821075,	0.0},
										{0.75508940219879150,	-0.0071935374289751053,	0.0},
										{0.59682685136795044,	0.12363214790821075,	0.0},
										{0.44267767667770386,	-0.0071935374289751053,	0.0},
										{0.28441512584686279,	0.12363214790821075,	0.0},
										{0.13079625368118286,	-0.0071935225278139114,	0.0},
										{-0.027466297149658203,	0.12363214790821075,	0.0},
										{-0.18187046051025391,	-0.0071935225278139114,	0.0},
										{-0.34013295173645020,	0.12363214790821075,	0.0},
										{-0.49410438537597656,	-0.0071935225278139114,	0.0},
										{-0.65236699581146240,	0.12363214790821075,	0.0},
									},
													
		init_ypr				=	{
										{4.7123886426183308,0,0},
										{1.5707963148700226,0,0},
									},
													
		explosion_impulse_coeff		= 550,
		explosion_dont_use_x_axis	= 1,
		release_rnd_coeff			= 0.9,
		chute_open_time				= 0.7,
		chute_cut_time				= 500.0,
		chute_diam					= 1.8,
		chute_Cx					= 1,
		chute_rnd_coeff				= 0.65,
		explosion_center			=	{{0,0, -10000},{0,0,10000},},
		spawn_options				=	{
											{0,2,1}, {0,4,1},
											{0,6,1}, {0,8,1},
											{0,10,1}, {0,12,1},
											{0,14,1}, {0,16,1},
											{0,18,1}, {0,20,1},
											{0,22,1}, {0,24,1},
										},
	},
	
	warhead			=  simple_warhead(5.7, 120),
	warhead2		=  cumulative_warhead(16.7, 120),
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{DWS39_MJ1}",
	attribute		= DWS39_MJ1.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= DWS39_MJ1.Cx,
	Picture			= "bk90.png",
	displayName		= DWS39_MJ1.user_name,
	Weight			= DWS39_MJ1.mass,
	Elements  		= {{ShapeName = "BK_90"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{DWS39_MJ2}",
	attribute		= DWS39_MJ2.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= DWS39_MJ2.Cx,
	Picture			= "bk90.png",
	displayName		= DWS39_MJ2.user_name,
	Weight			= DWS39_MJ2.mass,
	Elements  		= {{ShapeName = "BK_90"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{DWS39_MJ1_MJ2}",
	attribute		= DWS39_MJ1_MJ2.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= DWS39_MJ1_MJ2.Cx,
	Picture			= "bk90.png",
	displayName		= DWS39_MJ1_MJ2.user_name,
	Weight			= DWS39_MJ1_MJ2.mass,
	Elements  		= {{ShapeName = "BK_90"}},
})

GBU_39 =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon 	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_39},
	type    = 6,
    mass    = 130.0,
    hMin    = 400.0,
    hMax    = 15000.0,
    Cx      = 0.00264,
    VyHold  = -100.0,
    Ag      = -1.23,
	
	name			= "GBU_39",
	model			= "GBU-39",
	user_name		= _("GBU-39"),
	scheme			= "GBU-39",
	class_name		= "wAmmunitionChangeableTrajectory",
	display_name_short	= _("GBU-39"),
		
	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		10500,	19000,	25400,	31300,	35100,	37700,	39600,	41300,	
		500,	0,		0,		12600,	20600,	29800,	32800,	36700,	39300,	41300,	43100,	
		700,	0,		0,		14100,	22300,	31600,	34300,	38200,	40900,	42700,	44400,	
		1000,	0,		9400,	16400,	25000,	34400,	36600,	40600,	43200,	45200,	47000,	
		2000,	12200,	18400,	25200,	34200,	44000,	44200,	48200,	51000,	53200,	55000,	
		3000,	21400,	27400,	34200,	43400,	51400,	51400,	55800,	58800,	61000,	63200,	
		4000,	30000,	36000,	42500,	52000,	58500,	58500,	63000,	66500,	68500,	71000,	
		5000,	38500,	44500,	52500,	60500,	65500,	65500,	70000,	73500,	76000,	79000,	
		6000,	46500,	53000,	61000,	68000,	76500,	76500,	76500,	81000,	83500,	86500,	
		7000,	54500,	61000,	68500,	76000,	83000,	83000,	83000,	87000,	90500,	94000,	
		8000,	61500,	67500,	76500,	83250,	86250,	88500,	88500,	93000,	96750,	100500,	
		9000,	69000,	75750,	84000,	90000,	90000,	97500,	99000,	99000,	102750,	107250,	
		10000,	73500,	78000,	83250,	87000,	98250,	99750,	100500,	104250,	108750,	113250,	
		11000,	87000,	92250,	97500,	102750,	105750,	107250,	108000,	109500,	114750,	119250,	
		12000,	93000,	99000,	104000,	109000,	112000,	114000,	114000,	114000,	119000,	124000,	
		13000,	100000,	105000,	110000,	114000,	117000,	119000,	120000,	121000,	121000,	128000,	
		14000,	105000,	111000,	115000,	120000,	123000,	125000,	126000,	126000,	127000,	130000,	
		15000,	111000,	116000,	121000,	125000,	128000,	130000,	130000,	131000,	132000,	133000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		7800,	8300,	8800,	9200,	9500,	11500,	13800,	15600,	
		500,	0,		0,		7900,	8500,	9100,	9300,	9600,	11500,	13800,	16700,	
		700,	0,		0,		8000,	8600,	9200,	9400,	9700,	10300,	10600,	11100,	
		1000,	0,		7600,	8200,	9000,	9400,	9600,	11600,	12400,	12800,	13200,	
		2000,	7800,	8200,	8800,	9400,	10000,	10000,	10400,	10600,	11200,	10800,	
		3000,	8400,	8800,	9400,	10000,	10600,	10600,	10800,	11000,	11600,	11400,	
		4000,	9500,	9500,	10000,	11000,	11500,	11500,	12000,	12000,	12000,	12000,	
		5000,	10000,	10500,	11000,	11500,	12000,	12000,	12000,	13500,	12500,	15000,	
		6000,	11000,	11500,	11500,	12000,	12500,	12500,	12500,	13000,	13000,	13000,	
		7000,	12000,	12000,	12000,	12500,	13000,	13000,	13000,	13500,	13500,	14000,	
		8000,	11250,	12000,	13500,	12750,	13500,	13500,	13500,	13500,	14250,	14250,	
		9000,	12750,	12750,	13500,	13500,	13500,	14250,	14250,	14250,	14250,	15000,	
		10000,	12750,	12750,	12750,	13500,	14250,	14250,	14250,	29250,	15000,	15000,	
		11000,	13500,	13500,	14250,	14250,	15000,	15000,	15000,	15000,	15000,	15750,	
		12000,	13000,	14000,	14000,	15000,	15000,	15000,	15000,	15000,	15000,	16000,	
		13000,	14000,	14000,	15000,	15000,	15000,	15000,	15000,	15000,	15000,	18000,	
		14000,	14000,	15000,	15000,	15000,	16000,	16000,	16000,	17000,	18000,	20000,	
		15000,	15000,	15000,	15000,	16000,	16000,	16000,	17000,	18000,	20000,	21000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		76.1,		130.7,	132.6,	150.3,	159.5,	165.7,	170.1,	173.9,	
		500,	0,		0,		95.3,		140.6,	194.5,	156.9,	167.1,	173.1,	178.1,	182.3,	
		700,	0,		0,		105.6,	153.3,	205.5,	164,	173.9,	180.5,	183.7,	186.9,	
		1000,	0,		75,		119.7,	177.6,	222.4,	174.8,	185.1,	190.7,	195.1,	198.8,	
		2000,	104.7,	136.7,	186.3,	233.4,	276.7,	209.6,	217.8,	223.9,	229,	231.1,	
		3000,	160.9,	192.1,	238.2,	281.6,	306,	237.4,	247.2,	254.1,	257.9,	262.1,	
		4000,	201.9,	237.3,	277,	320.1,	330.5,	265.7,	275.4,	285.4,	286.5,	291.4,	
		5000,	238.9,	277.6,	294.5,	356.5,	354.1,	292.9,	303.7,	311.8,	315.6,	322.3,	
		6000,	270.4,	316.6,	331.2,	383.2,	408.4,	378,	328.1,	342.4,	344.6,	349.7,	
		7000,	331.7,	350.4,	357.8,	414.5,	426.3,	397.3,	352.7,	363.1,	370.1,	376.9,	
		8000,	361,	372.2,	388.5,	438.3,	500.9,	512.1,	370.9,	383.3,	391.8,	397,	
		9000,	393.3,	412.6,	414.5,	408.3,	534.9,	566.1,	568.1,	404.8,	411.3,	419.8,	
		10000,	354.3,	358.7,	366,	366.8,	417.6,	415.5,	413.2,	424.5,	432,	439.5,	
		11000,	429.3,	435.4,	437.8,	446.1,	447.8,	445.3,	442.1,	441.1,	454.5,	459.7,	
		12000,	442.8,	457.1,	460.5,	468.9,	470.8,	471.6,	462.8,	455.2,	469,	475.9,	
		13000,	469.6,	476.4,	481.8,	483.3,	484.9,	485,	484,	483.6,	475.3,	493.5,	
		14000,	483,	498.8,	497.1,	506.8,	507.7,	506.9,	506.6,	498.2,	495.5,	500.4,	
		15000,	508.1,	515.1,	521.9,	523.6,	523.7,	522.8,	515.4,	514,	510.3,	504,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		50.3,	37.8,	32.3,	29.3,	27.4,	31.4,	36.8,	40.5,		
		500,	0,		0,		49.5,	37.7,	35.1,	29.1,	27.4,	31.2,	36.5,	45.1,		
		700,	0,		0,		46.8,	37,		34.8,	29.5,	27.8,	27.5,	26.4,	26,		
		1000,	0,		59.7,	44.5,	39.8,	34.6,	29.8,	33.7,	33.8,	33,		32,		
		2000,	58.9,	49.4,	42.5,	38.5,	35.7,	31.9,	32,		30.1,	36.1,	26.5,		
		3000,	56.3,	49.2,	43.8,	39.8,	36.8,	32.4,	31.4,	29.3,	29.1,	27,		
		4000,	58.9,	50.6,	44,		41.6,	39.5,	34.9,	35.5,	32.8,	31.1,	29.4,		
		5000,	59.3,	54,		47.3,	42.8,	40.3,	36.7,	36.3,	37.1,	33,		36.4,		
		6000,	61.8,	56.9,	48.9,	44.4,	42.1,	39.5,	38,		36.5,	34.4,	32,		
		7000,	64.2,	58,		51.2,	46.2,	44.9,	42.4,	39.2,	38.1,	35.8,	34.4,		
		8000,	60.5,	57.8,	56.2,	48.2,	47.1,	44.7,	42.2,	38.3,	37.8,	34.8,		
		9000,	65.4,	61.1,	57.8,	52.5,	48.1,	47.6,	45.7,	40.6,	38.1,	36.7,		
		10000,	66.2,	60.8,	56.1,	53.3,	50.6,	48.2,	46.4,	84.1,	40.2,	37.3,		
		11000,	67.2,	61.2,	58.3,	54.4,	53.2,	50.8,	48.9,	47.1,	40.9,	39.3,		
		12000,	66.5,	63.6,	58.9,	57.5,	54.5,	52.1,	50.1,	48.3,	42,		40.6,		
		13000,	70.3,	64.8,	62.6,	58.8,	55.9,	53.5,	51.4,	49.5,	47.4,	44,		
		14000,	71.3,	68.5,	64,		60.3,	59.3,	56.8,	54.6,	54.4,	53.9,	47.2,		
		15000,	75,		69.7,	65.4,	63.7,	60.7,	58,		57.7,	57.3,	58.3,	56.8,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		63.3,	75.3,	73.8,	77,		78.5,	83.4,	88.6,	92.4,		
		500,	0,		0,		69.2,	78.4,	96.7,	79.7,	81.4,	86,		91.3,	97.9,		
		700,	0,		0,		71.4,	81.5,	101.1,	82.3,	84,		85.5,	85.6,	86.2,		
		1000,	0,		65.8,	75,		87.5,	108.1,	86.1,	92,		93.8,	94.5,	95,		
		2000,	82,		87.7,	92.2,	104.2,	133.5,	99.3,	101.4,	102.3,	103.7,	102.2,	
		3000,	104.8,	109.8,	111.4,	121,	127.7,	112.3,	114.7,	115.8,	116.9,	116.2,	
		4000,	124,	128.9,	127.4,	137,	138.1,	125.7,	128.8,	130.3,	129.3,	129.1,	
		5000,	138.9,	147.5,	147.7,	150.8,	147.1,	137.7,	139.8,	144.2,	141.8,	147.2,	
		6000,	152.6,	165,	162.1,	161.5,	166.5,	157.6,	150.9,	155.1,	154.4,	154.2,	
		7000,	165.3,	178.7,	173.3,	173.2,	175.6,	167.8,	162.1,	165,	166.1,	167.4,	
		8000,	196.4,	186.8,	187.8,	183.2,	178.5,	176.1,	171.2,	174.2,	176.9,	177.1,	
		9000,	213.9,	203.1,	197.3,	192.6,	181.9,	192,	190.2,	184.8,	185.6,	187.9,	
		10000,	184.4,	183.2,	180.5,	178.5,	195,	192.5,	189.9,	222,	195.6,	195.7,	
		11000,	211.7,	210.4,	209,	208.3,	208,	205.4,	202.5,	200.5,	203.6,	205.5,	
		12000,	216.3,	219.9,	217.4,	218.6,	216.8,	215,	210.5,	206.3,	208.3,	211.2,	
		13000,	227,	227.3,	227.5,	224.8,	223,	220.9,	218.2,	215.6,	210.3,	219.1,	
		14000,	232.2,	237.1,	233.8,	233.2,	232.9,	230.7,	227.7,	224.9,	223,	223.7,	
		15000,	241.8,	243.2,	242.2,	241.6,	239,	236.6,	233.5,	232.2,	231.5,	227.7,	
	},

	warhead		= simple_warhead(0),

	fm =
    {
		mass				= 130.0,
		caliber				= 0.19,
		cx_coeff			= {1, 0.85, 0.8, 0.15, 1.55},
		L					= 1.8,
		I_x					= 1.3,
		I					= 24.03,
		Ma					= 2,
		Mw					= 7,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		Sw					= 0.29,
		dCydA				= {0.07, 0.036},
		A					= 0.15,
		maxAoa				= 0.4,
		ideal_fins			= true,
		finsTau				= 0.2,
		Ma_x				= 2,
		Ma_z				= 2,
		Mw_x				= 1.4,

		addDeplSw			= 0.23,
		no_wings_A_mlt		= 2,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 9999,
		no_wings_cx_coeff = {1, 0.45, 0.8, 0.10, 1.55},
		
		release_rnd		= 0.3,
		release_rnd_x	= 0.0,
	},

	guidance_processor = {
		delay = 1.0,
		op_time = 999,
		waypoints = {},
		Knav = 3.0,
		Tf = 0.05,
		KD0 = 0.028 / 130.0,
		KDI = 0.15 * 130.0 / 0.52,
	},
	
	autopilot = {
		op_time = 999,
		delay = 1.0,
		Ka = 79.235,
		Tm = 28.66,
		Tc = 0.0,
		Kd = 122.46,
		Ks = 0.0,
		Krd = 0.0473,
		Kra = 5.0,
		gload_limit = 10,
		omega_limit = math.rad(90),
		integ_limit = math.rad(90),
		fins_limit = 0.349,
		fins_limit_x = 0.349,
		tail_control = false,
		yaw_control = false,
	},
	
	actuator = {
		Tf					= 0.005,
		D					= 250.0,
		T1					= 0.002,
		T2					= 0.006,
		max_omega			= math.rad(400),
		max_delta			= math.rad(20),
		fin_stall			= 0,
		sim_count			= 4,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU-39",
			file		= "GBU_39",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-39"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.55,
	},
}

declare_weapon(GBU_39)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU-39}",
	attribute		= GBU_39.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_39.Cx,
	Picture			= "GBU31.png",
	displayName		= _("GBU-39"),
	Weight			= GBU_39.mass,
	Elements  		= {{ShapeName = "GBU_39"}},
})
