dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

-----------------------------------------------------------------
------------------------DISCLAIMER-------------------------------
-----------------------------------------------------------------
--This startup macro has been configured by "DJBscout"
--Feel free to use, modify, and/or redistribute this file
--However, if you do so, please credit me for the work done
--On that note, this script was inspired by /u/SlipHavoc's scripts
-----------------------------------------------------------------
-----------------------CONFIGURATION-----------------------------
-----------------------------------------------------------------
--GENERAL:
local dt                = 0.1   -- Default interval between commands in the stack. Stock is 0.2s, 0.0 can break some things
local TotalRunTime      = 155   -- Total time from start to finish (doesn't include optional CM Readback)
--LIGHTING
local ExternalNav       = 2     --Desired % Brightness, 0% is off
local ExternalForm      = 100     --Desired % Brightness, 0% is off
local ExternalBcn       = 1     --Switch. 0=off, 1=on
local ExternalTaxi      = 1     --Switch. 0=off, 1=on 
                                --Will not turn on without Nav Lights set to at least 2%
--COUNTERMEASURES:
--place number that correlates to desired number of increases (e.g., for a chaff burst of 6, write "4")
local BurstChaff        = 2     -- 1-2-3-4-6-8      /0-5    ("2" presses twice, for chaff burst of 3)
local BurstIntvChaff    = 2     -- .1-.2-.3-.4      /0-3    ("2" presses twice, for burst interval of .3s)
local SalvoChaff        = 1     -- 1-2-4-8-C        /0-4    ("1" presses once, for chaff salvo of 2)
local SalvoIntvChaff    = 0     -- 1-2-3-4-5-8-R    /0-6    ("0" presses zero times, for salvo interval of 1s)
local BurstFlare        = 0     -- 1-2-4-8-C        /0-4    ("0" presses zero times, for flare burst of 1)
local BurstIntvFlare    = 0     -- 3-4-6-8-10       /0-4    (has no function if flare doesn't have multiple bursts per press)
local DemoCMStart       = 0     -- reads back CM programs immediately after setting. 0 = no, 1 = yes
local DemoCMEnd         = 1     -- readback after everything else completes
--INSTRUMENTS:
local SpeedIndex        = 325   --determines how far the index knob is turned. Calibrated for corner speed, 325KTS 
                                --(@175, index is 170kts, @200-180, @275-260, @300-290, @400-450)
local HSICourse         = 270   --set to desired course/heading, in degrees
local HSIHeading        = 0     --  ""
--NAVIGATION/COMMS:
local UHFHundreds       = 2     -- Set as desired, default settings give 253.000MHz
local UHFTens           = 5     --  ""
local UHFOnes           = 3     --  ""
local UHFTenths         = 0     --  ""
local UHFHundreths      = 0     -- not actually hundreths, see next line for guide
                                --0 = .000, 1 = .025, 2 = .050, 3 = .075
local TACANTens         = 8     --  Set as Desired, default settings are 31X
local TACANOnes         = 4     --  ""
local TACANXY           = "X"   --MUST BE CAPITAL FOR PROPER FUNCTION

----------------------------------------------------------------------------------------------------
--------------------------------IF YOU ARE AN IDIOT, GO NO LOWER------------------------------------
----------------------------------------------------------------------------------------------------
--------------------------------------YES, SERIOUSLY------------------------------------------------
----------------------------------------------------------------------------------------------------

--local QNH               = 29.72 --Pressure at sea level, "Hg. IIRC, should not change between maps
--local TargetAlt         = -100     --target altitude, in feet
--local QFE               = (QNH)*(((-TargetAlt/145366.45)+1)^(5.255)) --should correctly calculate target QFE
--NOTE: F-5 QFE range is from 28.10" to 31.00". This means your max QFE/Target Alt is ~1750ft (for a standard QNH of 29.92). This seems wrong, but hey who knows.
--local DeltaQFE          = QFE-28.10

----------------------------------------------------------------------------------------------------
-------HERE BE DRAGONS, DO NOT TOUCH (aka some guts that make config and readouts easier)-----------
----------------------------------------------------------------------------------------------------
local TACANXYConverted = 0
if TACANXY == "X"
    then TACANXYConverted = 0 
    else TACANXYConverted = 1
end
if TACANXY == "X"
    then TACANXYConverted = 0 
    else TACANXYConverted = 1
end
local ExternalBcnYN         = {[0]="OFF","ON"}
local ExternalTaxiYN        = {[0]="OFF","ON"}
local UHFHundrethsValue     = {[0]=0,25,50,75}
--CMDS LOOKUP TABLE:
local BurstChaffValue       = {[0]=1,2,3,4,6,8}
local BurstIntvChaffValue   = {[0]=0.1,0.2,0.3,0.4}
local SalvoChaffValue       = {[0]=1,2,4,8}
local SalvoIntvChaffValue   = {[0]=1,2,3,4,5,8}
local BurstFlareValue       = {[0]=1,2,4,8}
local BurstIntvFlareValue   = {[0]=3,4,6,8,10}
local TotalChaff            = 30
local TotalFlare            = 15
----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
start_sequence_full       = {}
stop_sequence_full        = {}
cockpit_illumination_full = {}

function push_command(sequence, run_t, command)
    sequence[#sequence + 1] =  command
    sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
    t_start = t_start + delta_t
    push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
    t_stop = t_stop + delta_t
    push_command(stop_sequence_full,t_stop, command)
end

--
local count = 0
local function counter()
    count = count + 1
    return count
end
-- conditions
count = -1

F5_AD_NO_FAILURE                    = counter()
F5_AD_LEFT_ENG_START_RPM            = counter()
F5_AD_RIGHT_ENG_START_RPM           = counter()
F5_AD_LEFT_ENG_IDLE_RPM             = counter()
F5_AD_RIGHT_ENG_IDLE_RPM            = counter()
F5_AD_LEFT_THROTTLE_SET_TO_STOP     = counter()
F5_AD_LEFT_THROTTLE_SET_TO_IDLE     = counter()
F5_AD_LEFT_THROTTLE_AT_STOP         = counter()
F5_AD_LEFT_THROTTLE_AT_IDLE         = counter()
F5_AD_RIGHT_THROTTLE_SET_TO_STOP    = counter()
F5_AD_RIGHT_THROTTLE_SET_TO_IDLE    = counter()
F5_AD_RIGHT_THROTTLE_AT_STOP        = counter()
F5_AD_RIGHT_THROTTLE_AT_IDLE        = counter()
F5_AD_LEFT_THROTTLE_DOWN_TO_IDLE    = counter()
F5_AD_RIGHT_THROTTLE_DOWN_TO_IDLE   = counter()
F5_AD_GROUND_AIR_SUPPLY_ON          = counter()
F5_AD_GROUND_AIR_SUPPLY_OFF         = counter()
F5_AD_GROUND_AIR_SUPPLY_IS_ON       = counter()
F5_AD_GROUND_AIR_APPLY              = counter()
F5_AD_GROUND_AIR_APPLY_LEFT_IS_ON   = counter()
F5_AD_GROUND_AIR_APPLY_RIGHT_IS_ON  = counter()
F5_AD_ERROR                         = counter()

--
alert_messages = {}

alert_messages[F5_AD_LEFT_ENG_START_RPM]            = { message = _("LEFT ENGINE RPM FAILURE: LESS THAN 10 PERCENT"),       message_timeout = 10}
alert_messages[F5_AD_RIGHT_ENG_START_RPM]           = { message = _("RIGHT ENGINE RPM FAILURE: LESS THAN 10 PERCENT"),      message_timeout = 10}
alert_messages[F5_AD_LEFT_ENG_IDLE_RPM]             = { message = _("LEFT ENGINE RPM FAILURE: LESS THAN 49 PERCENT"),       message_timeout = 10}
alert_messages[F5_AD_RIGHT_ENG_IDLE_RPM]            = { message = _("RIGHT ENGINE RPM FAILURE: LESS THAN 49 PERCENT"),      message_timeout = 10}
alert_messages[F5_AD_LEFT_THROTTLE_SET_TO_STOP]     = { message = _("LEFT THROTTLE - TO STOP"),                             message_timeout = 10}
alert_messages[F5_AD_LEFT_THROTTLE_SET_TO_IDLE]     = { message = _("LEFT THROTTLE - TO IDLE"),                             message_timeout = 10}
alert_messages[F5_AD_LEFT_THROTTLE_AT_STOP]         = { message = _("LEFT THROTTLE MUST BE AT STOP"),                       message_timeout = 10}
alert_messages[F5_AD_LEFT_THROTTLE_AT_IDLE]         = { message = _("LEFT THROTTLE MUST BE AT IDLE"),                       message_timeout = 10}
alert_messages[F5_AD_RIGHT_THROTTLE_SET_TO_STOP]    = { message = _("RIGHT THROTTLE - TO STOP"),                            message_timeout = 10}
alert_messages[F5_AD_RIGHT_THROTTLE_SET_TO_IDLE]    = { message = _("RIGHT THROTTLE - TO IDLE"),                            message_timeout = 10}
alert_messages[F5_AD_RIGHT_THROTTLE_AT_STOP]        = { message = _("RIGHT THROTTLE MUST BE AT STOP"),                      message_timeout = 10}
alert_messages[F5_AD_RIGHT_THROTTLE_AT_IDLE]        = { message = _("RIGHT THROTTLE MUST BE AT IDLE"),                      message_timeout = 10}
alert_messages[F5_AD_LEFT_THROTTLE_DOWN_TO_IDLE]    = { message = _("LEFT THROTTLE - DOWN TO IDLE"),                        message_timeout = 10}
alert_messages[F5_AD_RIGHT_THROTTLE_DOWN_TO_IDLE]   = { message = _("RIGHT THROTTLE - DOWN TO IDLE"),                       message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_SUPPLY_ON]          = { message = _("GROUND AIR SUPPLY - CONNECT"),                         message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_SUPPLY_OFF]         = { message = _("GROUND AIR SUPPLY - DISCONNECT"),                      message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_SUPPLY_IS_ON]       = { message = _("GROUND AIR SUPPLY FAILURE"),                           message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_APPLY]              = { message = _("GROUND AIR SUPPLY - APPLY"),                           message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_APPLY_LEFT_IS_ON]   = { message = _("GROUND AIR SUPPLY: LEFT ENGINE AIR APPLY FAILURE"),    message_timeout = 10}
alert_messages[F5_AD_GROUND_AIR_APPLY_RIGHT_IS_ON]  = { message = _("GROUND AIR SUPPLY: RIGHT ENGINE AIR APPLY FAILURE"),   message_timeout = 10}
alert_messages[F5_AD_ERROR]                         = { message = _("FM MODEL ERROR"),                                      message_timeout = 10}

----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence
push_start_command(2.0, {message = _("BISCUIT'S AUTOSTART SEQUENCE IS RUNNING"), message_timeout = TotalRunTime})
push_start_command(1.0, {device = devices.CPT_MECH,             action = cpt_commands.CanopyLever,              value = 1.0,    message = _("CANOPY - OPEN")})

--CMDS Config
push_start_command(0.5, {message = _("SETTING CMDS"), message_timeout = 6}) --information in AN_ALE40V.lua
push_start_command(dt,  {message = _("CHAFF PROGRAM: "..SalvoChaffValue[SalvoChaff].." Bursts of "..BurstChaffValue[BurstChaff].." releases "
..BurstIntvChaffValue[BurstIntvChaff].."s apart, with "..SalvoIntvChaffValue[SalvoIntvChaff].."s between each new burst"), message_timeout = 30.0})
for i = 1, BurstChaff, 1 do
    push_start_command(0.2, {device = devices.CMDS,             action = cmds_commands.ChangeChaffBurst,        value = 1.0})
end
for i = 1, BurstIntvChaff, 1 do
    push_start_command(0.2,  {device = devices.CMDS,            action = cmds_commands.ChangeChaffBurstIntv,    value = 1.0})
end
for i = 1, SalvoChaff, 1 do
    push_start_command(0.2,  {device = devices.CMDS,            action = cmds_commands.ChangeChaffSalvo,        value = 1.0})
end
for i = 1, SalvoIntvChaff, 1 do
    push_start_command(0.2,  {device = devices.CMDS,            action = cmds_commands.ChangeChaffSalvoIntv,    value = 1.0})
end
push_start_command(dt,  {message = _("CHAFF SET"), message_timeout = 3.0})

push_start_command(dt,  {message = _("FLARES: 1 Burst of "..BurstFlareValue[BurstFlare]..", "..BurstIntvFlareValue[BurstIntvFlare].."s apart"), message_timeout = 30.0})
for i = 1, BurstFlare, 1 do
    push_start_command(dt,  {device = devices.CMDS,             action = cmds_commands.ChangeFlareBurst,        value = 1.0})
end
for i = 1, BurstIntvFlare, 1 do
    push_start_command(dt,  {device = devices.CMDS,             action = cmds_commands.ChangeFlareBurstIntv,    value = 1.0})
end
push_start_command(dt,  {message = _("FLARES SET"), message_timeout = 3.0})

for i=1, DemoCMStart, 1 do
    push_start_command(0.5, {message = _("DEMONSTRATING CM PROGRAM(S)"), message_timeout = 5})
    for i = 1, SalvoChaffValue[SalvoChaff], 1 do
        push_start_command(SalvoIntvChaffValue[SalvoIntvChaff],   {message = _("CHAFF")})         --needs an extra to start each salvo or is one delay late
        for i = 2, BurstChaffValue[BurstChaff], 1 do --starts at 2 instead of 1 because of the extra dispense above to keep the total number correct
            push_start_command(BurstIntvChaffValue[BurstIntvChaff], {message = _("CHAFF")})
        end
    end
    for i = 1, BurstFlareValue[BurstFlare], 1 do
        push_start_command(BurstIntvFlareValue[BurstIntvFlare], {message = _("FLARE")})
    end
end

--lighting and bare-bones power
push_start_command(dt,  {device = devices.ELEC_INTERFACE,       action = electric_commands.BatterySw,           value = 1.0,    message = _("BATTERY - ON")})
push_start_command(1.0,  {message = _("LIGHTS"),         message_timeout = 1.0})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.Flood_knob,         value = 0.1,    message = _("FLOOD LIGHTS - LOW")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.EngInstr_knob,      value = 1.0,    message = _("ENGINE INSTRUMENT LIGHTS - BRT")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.FltInstr_knob,      value = 1.0,    message = _("FLIGHT INSTRUMENT LIGHTS - BRT")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.Compass_switch,     value = 1.0,    message = _("COMPASS LIGHT - ON")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.Console_knob,       value = 1.0,    message = _("CONSOLE LIGHTS - BRT")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.ArmtPanel_knob,     value = 1.0,    message = _("ARMAMENT LIGHTS - BRT")})
push_start_command(dt,  {device = devices.EXTLIGHTS_SYSTEM,     action = extlights_commands.NavKnob,            value = ExternalNav/100*.85,   message = _("NAV LIGHTS - "..ExternalNav.."%")})--
push_start_command(dt,  {device = devices.EXTLIGHTS_SYSTEM,     action = extlights_commands.Formation,          value = ExternalForm/100*.85,  message = _("FORMATION LIGHTS - "..ExternalForm.."%")})
push_start_command(dt,  {device = devices.EXTLIGHTS_SYSTEM,     action = extlights_commands.Beacon,             value = ExternalBcn,           message = _("BEACON - "..ExternalBcnYN[ExternalBcn])})
push_start_command(dt,  {device = devices.EXTLIGHTS_SYSTEM,     action = extlights_commands.LdgTaxi,            value = ExternalTaxi,          message = _("TAXI/LDG LIGHT - ")..ExternalTaxiYN[ExternalTaxi]})--doesn't actually work unless nav lights are on

--HSI Heading and Course Config
push_start_command(1.0,     {message = _("SETTING HSI COURSE - "..HSICourse..", HEADING - "..HSIHeading), message_timeout = 3.0})
for i=1, HSICourse, 1 do --sets Course to desired value via HSICourse
    push_start_command(.005, {device = devices.HSI,             action = hsi_commands.HSI_course,               value = .01750})--*lots* of trial and error to get this value lol
end
for i=1, HSIHeading, 1 do --sets to desired value via HSIHeading
    push_start_command(.005, {device = devices.HSI,             action = hsi_commands.HSI_heading,              value = .01750})--*lots* of trial and error to get this value lol 
end

--COCKPIT PREP
push_start_command(1.0,     {message = _("COCKPIT PREPARATION"),    message_timeout = 12.5})
push_start_command(dt,  {device = devices.GEAR_INTERFACE,       action = gear_commands.GearLever,               value = 0.0,    message = _("LANDING GEAR HANDLE - LG DOWN")})
push_start_command(dt,  {device = devices.GEAR_INTERFACE,       action = gear_commands.AltRelease,              value = 0.0,    message = _("LANDING GEAR ALTERNATE RELEASE HANDLE - STOW")})
push_start_command(dt,  {device = devices.CPT_MECH,             action = cpt_commands.CanopyJettisonTHandle,    value = 0.0,    message = _("CANOPY JETTISON T-HANDLE - IN")})
push_start_command(dt,  {device = devices.CPT_MECH,             action = cpt_commands.DragChuteHandle,          value = 0.0,    message = _("DRAG CHUTE T-HANDLE - IN")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.RudderPedalAdjust,    value = 0.0,    message = _("RUDDER PEDAL ADJUST T-HANDLE - STOW")})

push_start_command(1.0,     {message = _("ARMAMENT AND JETTISON SWITCHES - OFF AND SAFE"),  message_timeout = 1.3})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.BombsArm,             value = 0.2})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamrCover,     value = 1.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamr,          value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamrCover,     value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.ExtStoresSelect,      value = 0.2})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipLeft_Select,   value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.OutbdLeft_Select,     value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.InbdLeft_Select,      value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.Center_Select,        value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.InbdRight_Select,     value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.OutbdRight_Select,    value = 0.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipRight_Select,  value = 0.0})
push_start_command(dt,  {device = devices.JETTISON_SYSTEM,      action = jettison_commands.SelectJettSw,        value = 0.0})

push_start_command(1.0, {message = _("CIRCUIT-BREAKERS - ALL ON"),  message_timeout = 5})
local beginCBcommand = electric_commands.CB_WPN_PWR_LEFT_OUTBD
local endCBcommand = electric_commands.CB_LWR_FUS_LTS_L
for CB_command = beginCBcommand, endCBcommand, 1 do
    push_start_command(0.05, {device = devices.ELEC_INTERFACE,   action = CB_command,    value = 1.0})
end

-- oxygen
push_start_command(dt,  {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.SupplyLever,           value = 1.0,    message = _("OXYGEN SYSTEM - CHECK")})
push_start_command(dt,  {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.DiluterLever,          value = 0.0})
push_start_command(dt,  {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.EmergLever,            value = 0.0})
-- left console
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.RudderTrim,           value = 0.0,    message = _("RUDDER TRIM KNOB - CENTERED")})
push_start_command(dt,  {device = devices.AN_APQ159,            action = apq159_commands.ModeSelector,          value = 0.0,    message = _("RADAR MODE SELECTOR - OFF")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.FlapLever,            value = 0.0,    message = _("FLAP LEVER - THUMB SW")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.SpdBrk,               value = 0.0,    message = _("SPEED BRAKE SWITCH - NEUTRAL")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.FlapSwitch,           value = 1.0,    message = _("FLAP THUMB SWITCH - UP")})
push_start_command(dt,  {device = devices.GEAR_INTERFACE,       action = gear_commands.NoseStrut,               value = 0.0,    message = _("NOSE STRUT SWITCH - RETRACT")})
-- left vertical
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Left,   value = 1.0,    message = _("FUEL SHUTOFF SWITCHES - LEFT AND RIGHT (GUARDS CLOSED)")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Right,  value = 1.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoff_Left,        value = 0.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoff_Right,       value = 0.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Left,   value = 0.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Right,  value = 0.0}) 

-- instruments
push_start_command(dt,  {device = devices.AN_ASG31,             action = asg31_commands.ModeSelector,           value = 0.0,    message = _("OPTICAL SIGHT MODE SELECTOR - OFF")})

-- right vertical
push_start_command(dt,  {device = devices.ELEC_INTERFACE,       action = electric_commands.PitotHeater,         value = 0.0,    message = _("PITOT HEAT AND ENGINE ANTI-ICE SWITCHES - OFF")})
push_start_command(dt,  {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineAntiIce,         value = 0.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.ExtFuelTransfer_Cl,      value = 1.0,    message = _("EXTERNAL FUEL TRANSFER SWITCHES - **ON**")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.ExtFuelTransfer_Pylon,   value = 1.0})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelCrossfeed,           value = 1.0,    message = _("CROSSFEED SWITCH - **ON**")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelAutoLeft,            value = 0.0,    message = _("AUTO BALANCE SWITCH - CENTERED")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelAutoRight,           value = 0.0})

-- right console
push_start_command(dt,  {device = devices.IFF,                  action = device_commands.Button_8,              value = 0.1,    message = _("IFF/SIF - STBY")})

--ENGINES
push_start_command(1.0,     {message = _("ENGINE PREP"),    message_timeout = 11.6 })
--engine pre-start
push_start_command(dt,      {message = _("THROTTLES - OFF"),                check_condition = F5_AD_LEFT_THROTTLE_SET_TO_STOP})
push_start_command(dt,      {                                               check_condition = F5_AD_RIGHT_THROTTLE_SET_TO_STOP})
push_start_command(dt,  {device = devices.ELEC_INTERFACE,       action = electric_commands.LeftGeneratorSw,     value = 1.0,    message = _("LEFT GENERATOR - ON")})
push_start_command(dt,  {device = devices.ELEC_INTERFACE,       action = electric_commands.RightGeneratorSw,    value = 1.0,    message = _("RIGHT GENERATOR - ON")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelBoostPump_Left,      value = 1.0,    message = _("BOOST PUMPS - ON")})
push_start_command(dt,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelBoostPump_Right,     value = 1.0})
push_start_command(1.0,     {message = _("GROUND AIR SUPPLY - CONNECT"),   check_condition = F5_AD_GROUND_AIR_SUPPLY_ON})
push_start_command(10.0,    {message = _("GROUND AIR SUPPLY - CHECK"),     check_condition = F5_AD_GROUND_AIR_SUPPLY_IS_ON})

-- engines start
push_start_command(1.0,     {message = _("ENGINES START"),    message_timeout = 90})
-- left engine
push_start_command(dt,      {message = _("THROTTLES - CHECK"),              check_condition = F5_AD_LEFT_THROTTLE_AT_STOP})
push_start_command(dt,      {                                               check_condition = F5_AD_RIGHT_THROTTLE_AT_STOP})
push_start_command(1.0,     {message = _("START LEFT ENGINE"),              check_condition = F5_AD_GROUND_AIR_APPLY,   message_timeout = 42})
--Ask for rearm *immediately* after this command if you want to rearm without disturbing the script 
push_start_command(10.0,    {message = _("LEFT ENGINE RPM - CHECK"),        check_condition = F5_AD_LEFT_ENG_START_RPM})
push_start_command(dt,      {message = _("LEFT THROTTLE - IDLE"),           check_condition = F5_AD_LEFT_THROTTLE_SET_TO_IDLE})
push_start_command(1.0,     {message = _("LEFT THROTTLE - CHECK"),          check_condition = F5_AD_LEFT_THROTTLE_AT_IDLE})
push_start_command(0.5,  {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineStartLeft,       value = 1.0,   message = _("LEFT ENGINE - IGNITE")})
push_start_command(0.5,  {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineStartLeft,       value = 0.0})
push_start_command(28.0,    {message = _("LEFT ENGINE RPM - CHECK"),        check_condition = F5_AD_LEFT_ENG_IDLE_RPM})--28s should give 3s of leeway between a complete rearmament and next command
--**Start devices that require power and need time to warm up**
push_start_command(0.5,  {device = devices.RWR_IC,               action = ic_commands.Power,                     value = 1.0,    message = _("RWR - ON")}) --press RWR power
push_start_command(0.5,  {device = devices.AN_ALR87,             action = alr87_commands.Brightness,             value = 0.85,   message = _("RWR BRIGHTNESS - MAX")}) --Axis ranges from .15 to .85
push_start_command(0.5,  {device = devices.AN_APQ159,            action = apq159_commands.ModeSelector,          value = 0.1,    message = _("RADAR - STBY")}) --Switches radar mode to Stby

-- right engine
push_start_command(5.0,     {message = _("START RIGHT ENGINE"),             check_condition = F5_AD_GROUND_AIR_APPLY,   message_timeout = 42})
--Ask for rearm *immediately* after this command if you want to rearm without disturbing the script 
push_start_command(10.0,    {message = _("RIGHT ENGINE RPM - CHECK"),       check_condition = F5_AD_RIGHT_ENG_START_RPM})
push_start_command(dt,      {message = _("RIGHT THROTTLE - IDLE"),          check_condition = F5_AD_RIGHT_THROTTLE_SET_TO_IDLE})
push_start_command(1.0,     {message = _("RIGHT THROTTLE - CHECK"),         check_condition = F5_AD_RIGHT_THROTTLE_AT_IDLE})
push_start_command(0.5, {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineStartRight,      value = 1.0,    message = _("RIGHT ENGINE - IGNITE")})
push_start_command(0.5, {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineStartRight,      value = 0.0})
push_start_command(30.0,    {message = _("RIGHT ENGINE RPM - CHECK"),       check_condition = F5_AD_RIGHT_ENG_IDLE_RPM})--28s should give 3s of leeway between a complete rearmament and next command
push_start_command(6.0,     {message = _("GROUND AIR SUPPLY - DISCONNECT"), check_condition = F5_AD_GROUND_AIR_SUPPLY_OFF})

--ADDITIONS
push_start_command(dt,      {message = _("ADDITIONAL PREP"),    message_timeout = 20})
--engine post-start
push_start_command(dt,  {device = devices.CPT_MECH,             action = cpt_commands.CanopyLever,              value = 0.0,    message = _("CANOPY - CLOSE")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.MasterReset,        value = 1.0,    message = _("MASTER CAUTION BUTTON - RESET")})
push_start_command(dt,  {device = devices.INTLIGHTS_SYSTEM,     action = intlights_commands.MasterReset,        value = 0.0})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.SpdBrk,               value = 1.0,    message = _("SPEED BRAKE - IN")})
push_start_command(1.2, {device = devices.CONTROL_INTERFACE,    action = control_commands.SpdBrk,               value = 0.0})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.FlapSwitch,           value = -1.0,   message = _("FLAP THUMB SWITCH - AUTO")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.PitchDamper,          value = 1.0,    message = _("DAMPER - PITCH AND YAW")})
push_start_command(dt,  {device = devices.CONTROL_INTERFACE,    action = control_commands.YawDamper,            value = 1.0})

-- instruments
push_start_command(0.5,     {message = _("INSTRUMENTS"),    message_timeout = 7})
push_start_command(dt,  {device = devices.AAU34,                action = aau34_commands.AAU34_ClkCmd_ELECT,     value = -1.0,   message = _("ALTIMETER - ELECT")})
push_start_command(0.5, {device = devices.AAU34,                action = aau34_commands.AAU34_ClkCmd_ELECT,     value = 0.0})
push_start_command(dt,  {message = _("BACKUP ATTITUDE INDICATOR - UNCAGE"), message_timeout = 2.0})
for i = 0, 20, 1 do
    push_start_command(dt,  {device = devices.SAI,              action = sai_commands.CMD_SAI_PITCH_ZERO_SHIFT, value = 0.5})--this control is some voodoo fuckery, leave it alone
end
push_start_command(2.0, {message = _("SPEED INDEX - 325KTS (CORNER SPEED)"), message_timeout = 3})
for i=1, 10, 1 do --sets index to 0, as some servers seem to have varying default indices
    push_start_command(.02, {device = devices.IAS_MACH_INDICATOR,action = device_commands.Button_1,             value = -1.0})
end
for i=1, SpeedIndex, 1 do --sets to desired value (set in SpeedIndex)
    push_start_command(.01, {device = devices.IAS_MACH_INDICATOR,action = device_commands.Button_1,             value = .051})
end

push_start_command(0.5,     {message = _("COMM AND NAV PREP"),  message_timeout = 6})
--IFF (yeah I've got no frickin' clue if any of this section even matters at all)
push_start_command(dt,  {device = devices.IFF,                  action = device_commands.Button_8,              value = 0.3,    message = _("IFF MASTER - NORM")})--turns on IFF
push_start_command(dt,  {device = devices.IFF,                  action = device_commands.Button_9,              value = 1.0,    message = _("MODE 4 MONITOR SWITCH - AUDIO")})--*should* result in an audio cue if IFF'd
push_start_command(dt,  {device = devices.IFF,                  action = device_commands.Button_16,             value = 1.0,    message = _("IFF MODE 4 - ON")})--turns on Mode 4
--radio/TACAN
push_start_command(dt,  {device = devices.UHF_RADIO,            action = device_commands.Button_8,              value = 0.1,                    message = _("RADIO ON, MODE - MAIN")})
push_start_command(dt,      {message = _("TUNING UHF TO "..UHFHundreds..UHFTens..UHFOnes.."."..UHFTenths..UHFHundrethsValue[UHFHundreths]),     message_timeout = 1.0})
push_start_command(dt,  {device = devices.UHF_RADIO,           action = device_commands.Button_2,               value = UHFHundreds*-0.1+.4})    --UHF 100 MHz Selector. INVERSED. 0.0=400/A, 0.1=300, 0.2=200, 0.3=100
push_start_command(dt,  {device = devices.UHF_RADIO,           action = device_commands.Button_3,               value = UHFTens*-0.1+1})         --UHF 10 MHz Selctor--INVERSED. 0.1=90, 1.0=00, etc
push_start_command(dt,  {device = devices.UHF_RADIO,           action = device_commands.Button_4,               value = UHFOnes*-0.1+1})         --UHF 1 MHz Selctor--same as 10s
push_start_command(dt,  {device = devices.UHF_RADIO,           action = device_commands.Button_5,               value = UHFTenths*-0.1+1})       --UHF .1 MHz Selctor--same as 10s
push_start_command(dt,  {device = devices.UHF_RADIO,           action = device_commands.Button_6,               value = UHFHundreths*-.25+1})    --UHF .025 MHz Selctor--similar to the 100s
push_start_command(dt,      {message = _("UHF TUNED TO "..UHFHundreds..UHFTens..UHFOnes.."."..UHFTenths..UHFHundrethsValue[UHFHundreths]),      message_timeout = std_message_timeout})

push_start_command(dt,  {device = devices.TACAN_CTRL_PANEL,    action = device_commands.Button_6,               value = 0.2,                    message = _("TACAN ON, MODE - T/R")})
push_start_command(dt,  {device = devices.AHRS,                action = ahrs_commands.AHRS_NAV_MODE,            value = 0.1,                    message = _("NAV MODE - TACAN")})
push_start_command(dt,      {message = _("TUNING TACAN TO "..TACANTens..TACANOnes..TACANXY),    message_timeout = 1.0})
for i = 1, (TACANTens), 1 do --tunes 10s from 0 to TACANones
    push_start_command(0.2, {device = devices.TACAN_CTRL_PANEL,  action = device_commands.Button_1,             value = 0.1})--value doesn't matter, only positive or negative??
end
for i = 1, (TACANOnes), 1 do --tunes 1s from 0 to TACANones
    push_start_command(0.2, {device = devices.TACAN_CTRL_PANEL, action = device_commands.Button_2,              value = 0.1})--value doesn't seem to matter, only if +-
end
push_start_command(0.5, {device = devices.TACAN_CTRL_PANEL,     action = device_commands.Button_3,              value = TACANXYConverted})--relies on TACAN X/Y being at X by default. Otherwise it'll do the opposite
push_start_command(dt,      {message = _("TACAN TUNED TO "..TACANTens..TACANOnes..TACANXY),     message_timeout = std_message_timeout})
--for i = 1, 10, 1 do --sets TACAN volume
--  push_start_command(dt,  {device = devices.TACAN_CTRL_PANEL,     action = device_commands.Button_5,          value = -1.0})--"-1.0" tells TACAN to shut up
--end

--QFE (optional, doesn't work as well as I'd like. Plus the F-5 can handle a max target alt of something like 1700 feet, if that.)
--push_start_command(2.0, {message = _("ALTIMITER ZERO"), message_timeout = 3})
--for i=1, 182, 1 do --zero altimiter to 28.10" from 29.921 (1.82", 182 .01" decreases)
--    push_start_command(.02, {device = devices.AAU34,            action = aau34_commands.AAU34_ClkCmd_ZeroSetting,value = -.2533783784})
--end
--push_start_command(2.0, {message = _("SET QFE - "..QFE), message_timeout = 3})
--for i=1, DeltaQFE*100, 1 do --set altimiter to desired QFE
--    push_start_command(.02, {device = devices.AAU34,            action = aau34_commands.AAU34_ClkCmd_ZeroSetting,value = .2533783784})
--end
--value of zero: no effect
-- 1@-1.0 = 29.92->28.88
-- 5@-0.1 = 29.90ish
-- 11@-.05= 29.90 bang on the money
-- QED, .02" Hg = .55 on the axis
--so  .01" =.275, and .001 = .0275
--750@.0275 -> +.814"
--.25337 ~~ .01"

--CM
push_start_command(0.5, {message = _("COUNTERMEASURES PREP"),   message_timeout = 4.4})
push_start_command(2.0, {device = devices.RWR_IC,               action = ic_commands.SysTest,                   value = 1.0,    message = _("RWR - INITIATE TEST")}) --press and hold RWR TEST button
push_start_command(2.0, {device = devices.RWR_IC,               action = ic_commands.SysTest,                   value = 0.0}) --release test button
push_start_command(dt,  {device = devices.RWR_IC,               action = ic_commands.Mode,                      value = 1.0,    message = _("RWR MODE - PRIORITY")}) --press and release RWR Mode button
push_start_command(dt,  {device = devices.RWR_IC,               action = ic_commands.Mode,                      value = 0.0})
push_start_command(dt,  {device = devices.CMDS,                 action = cmds_commands.ChaffMode,               value = 0.2,    message = _("CHAFF SELECTOR - PRGM")})
push_start_command(dt,  {device = devices.CMDS,                 action = cmds_commands.FlareMode,               value = 0.1,    message = _("FLARE SELECTOR - SINGLE")})
for i=1, DemoCMEnd, 1 do
    push_start_command(0.5, {message = _("DEMONSTRATING CM PROGRAM(S)"), message_timeout = 5})
    for i = 1, SalvoChaffValue[SalvoChaff], 1 do
        push_start_command(SalvoIntvChaffValue[SalvoIntvChaff],   {message = _("CHAFF")})         --needs an extra to start each salvo or is one delay late
        for i = 2, BurstChaffValue[BurstChaff], 1 do --starts at 2 instead of 1 because of the extra dispense above to keep the total number correct
            push_start_command(BurstIntvChaffValue[BurstIntvChaff], {message = _("CHAFF")})
        end
    end
    for i = 1, BurstFlareValue[BurstFlare], 1 do
        push_start_command(BurstIntvFlareValue[BurstIntvFlare], {message = _("FLARE")})
    end
end
--Weapons
push_start_command(0.5, {message = _("ARMAMENT PREP"),          message_timeout = 1.0})
push_start_command(dt,  {device = devices.AN_APQ159,            action = apq159_commands.RangeSelector,         value = 0.2,    message = _("RADAR RANGE - 20NM")}) --Switches radar mode to Stby
push_start_command(dt,  {device = devices.AN_APQ159,            action = apq159_commands.ScaleKnob,             value = 1.0,    message = _("RADAR SCALE - BRT")}) --Brightens Radar Scale
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipLeft_Select,   value = 1.0})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipRight_Select,  value = 1.0,    message = _("MISSILES SELECTED")})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.MissileVolume,        value = 0.5,    message = _("MISSILE VOLUME - 50%")})
push_start_command(dt,  {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamrCover,     value = 1.0,    message = _("MASTER ARM COVER - OPEN")})
push_start_command(dt,  {device = devices.JETTISON_SYSTEM,      action = jettison_commands.EmerAllJettCap,      value = 1.0,    message = _("JETTISON CAP - REMOVED")})
--
push_start_command(dt,  {message = _("BISCUIT AUTOSTART COMPLETE, GOOD LUCK AND GOOD HUNTING"), message_timeout = std_message_timeout})
--


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Stop sequence
push_stop_command(2.0,  {message = _("AUTOSTOP SEQUENCE IS RUNNING"),   message_timeout = 35.0})
--

push_stop_command(1.0,  {device = devices.CONTROL_INTERFACE,    action = control_commands.FlapSwitch,           value = 1.0,    message = _("FLAP THUMB SWITCH - UP")})
push_stop_command(dt,   {device = devices.CONTROL_INTERFACE,    action = control_commands.SpdBrk,               value = -1.0,   message = _("SPEED BRAKE SWITCH - OUT")})
push_stop_command(dt,   {device = devices.AN_APQ159,            action = apq159_commands.ModeSelector,          value = 0.0,    message = _("RADAR MODE SELECTOR - OFF")})
push_stop_command(dt,   {device = devices.AN_ASG31,             action = asg31_commands.ModeSelector,           value = 0.0,    message = _("OPTICAL SIGHT MODE SELECTOR - OFF")})
push_stop_command(dt,   {device = devices.ELEC_INTERFACE,       action = electric_commands.PitotHeater,         value = 0.0,    message = _("PITOT HEAT AND ENGINE ANTI-ICE SWITCHES - OFF")})
push_stop_command(dt,   {device = devices.ENGINE_INTERFACE,     action = engine_commands.EngineAntiIce,         value = 0.0})
push_stop_command(dt,   {device = devices.IFF,                  action = device_commands.Button_8,              value = 0.0,    message = _("IFF/SIF - OFF")})

push_stop_command(1.0,  {device = devices.CPT_MECH,             action = cpt_commands.CanopyLever,              value = 1.0,    message = _("CANOPY - OPEN")})

push_stop_command(1.0,  {message = _("ARMAMENT AND JETTISON SWITCHES - OFF AND SAFE"),  message_timeout = std_message_timeout})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.BombsArm,             value = 0.2})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamrCover,     value = 1.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamr,          value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.GunsMslCamrCover,     value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.ExtStoresSelect,      value = 0.2})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipLeft_Select,   value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.OutbdLeft_Select,     value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.InbdLeft_Select,      value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.Center_Select,        value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.InbdRight_Select,     value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.OutbdRight_Select,    value = 0.0})
push_stop_command(dt,   {device = devices.WEAPONS_CONTROL,      action = weapons_commands.WingtipRight_Select,  value = 0.0})
push_stop_command(dt,   {device = devices.JETTISON_SYSTEM,      action = jettison_commands.SelectJettSw,        value = 0.0})

push_stop_command(1.0,  {device = devices.GEAR_INTERFACE,       action = gear_commands.GearLever,               value = 0.0,    message = _("LANDING GEAR HANDLE - LG DOWN")})
push_stop_command(dt,   {device = devices.GEAR_INTERFACE,       action = gear_commands.AltRelease,              value = 0.0,    message = _("LANDING GEAR ALTERNATE RELEASE HANDLE - STOW")})
push_stop_command(dt,   {device = devices.CPT_MECH,             action = cpt_commands.CanopyJettisonTHandle,    value = 0.0,    message = _("CANOPY JETTISON T-HANDLE - IN")})
push_stop_command(dt,   {device = devices.CONTROL_INTERFACE,    action = control_commands.RudderPedalAdjust,    value = 0.0,    message = _("RUDDER PEDAL ADJUST T-HANDLE - STOW")})

push_stop_command(1.0,  {message = _("CIRCUIT-BREAKERS - ALL ON"),  message_timeout = 12})
local beginCBcommand = electric_commands.CB_WPN_PWR_LEFT_OUTBD
local endCBcommand = electric_commands.CB_LWR_FUS_LTS_L
for CB_command = beginCBcommand, endCBcommand, 1 do
    push_stop_command(0.1,  {device = devices.ELEC_INTERFACE,   action = CB_command,    value = 1.0})
end

-- oxygen
push_stop_command(1.0,  {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.SupplyLever,           value = 1.0,    message = _("OXYGEN SYSTEM - CHECK")})
push_stop_command(dt,   {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.DiluterLever,          value = 0.0})
push_stop_command(dt,   {device = devices.OXYGEN_INTERFACE,     action = oxygen_commands.EmergLever,            value = 0.0})

push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Left,   value = 1.0,    message = _("FUEL SHUTOFF SWITCHES - LEFT AND RIGHT (GUARDS CLOSED)")})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Right,  value = 1.0})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoff_Left,        value = 0.0})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoff_Right,       value = 0.0})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Left,   value = 0.0})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelShutoffCover_Right,  value = 0.0})

push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.ExtFuelTransfer_Cl,      value = 0.0,    message = _("EXTERNAL FUEL TRANSFER SWITCHES - OFF")})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.ExtFuelTransfer_Pylon,   value = 0.0})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelCrossfeed,           value = 0.0,    message = _("CROSSFEED SWITCH - OFF")})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelAutoLeft,            value = 0.0,    message = _("AUTO BALANCE SWITCH - CENTERED")})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelAutoRight,           value = 0.0})


push_stop_command(1.0,      {message = _("THROTTLES - IDLE"),               check_condition = F5_AD_LEFT_THROTTLE_DOWN_TO_IDLE})
push_stop_command(dt,       {                                               check_condition = F5_AD_RIGHT_THROTTLE_DOWN_TO_IDLE})
push_stop_command(1.0,      {message = _("THROTTLES - CHECK"),              check_condition = F5_AD_LEFT_THROTTLE_AT_IDLE})
push_stop_command(dt,       {                                               check_condition = F5_AD_RIGHT_THROTTLE_AT_IDLE})

push_stop_command(1.0,      {message = _("THROTTLES - OFF"),                check_condition = F5_AD_LEFT_THROTTLE_SET_TO_STOP})
push_stop_command(dt,       {                                               check_condition = F5_AD_RIGHT_THROTTLE_SET_TO_STOP})
push_stop_command(1.0,      {message = _("THROTTLES - CHECK"),              check_condition = F5_AD_LEFT_THROTTLE_AT_STOP})
push_stop_command(dt,       {                                               check_condition = F5_AD_RIGHT_THROTTLE_AT_STOP})

push_stop_command(1.0,  {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelBoostPump_Left,      value = 0.0,    message = _("BOOST PUMPS - OFF")})
push_stop_command(dt,   {device = devices.FUEL_INTERFACE,       action = fuel_commands.FuelBoostPump_Right,     value = 0.0})

push_stop_command(1.0,  {device = devices.ELEC_INTERFACE,       action = electric_commands.LeftGeneratorSw,     value = 0.0,    message = _("LEFT GENERATOR - OFF")})
push_stop_command(dt,   {device = devices.ELEC_INTERFACE,       action = electric_commands.RightGeneratorSw,    value = 0.0,    message = _("RIGHT GENERATOR - OFF")})
push_stop_command(dt,   {device = devices.ELEC_INTERFACE,       action = electric_commands.BatterySw,           value = 0.0,    message = _("BATTERY - OFF")})

--
push_stop_command(3.0,  {message = _("AUTOSTOP COMPLETE"),  message_timeout = std_message_timeout})
--