package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {} --     

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setUpdateFunc('sceneVRUpdate')
	sceneAPI:setEnvironmentMap("Bazar/Graphics/VRMainScene.dds",0.9);
	sceneAPI:setSun(math.rad(-90), math.rad(0)) --       

	scene.m			= sceneAPI:addModel("Mirage-F1", 0, 2.12, 0);
	scene.m:setLivery("EC 2 30 Normandie Niemen", "Mirage-F1CT")
	scene.m:setArgument(0, 1);
	scene.m:setArgument(1, 0.5);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(38, 0.984);
	scene.m:setArgument(50, 0.9);
	scene.m:setArgument(70, 0.4);
	scene.m:setArgument(75, 1);
	scene.m:setArgument(90, 1);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);
	scene.m:setArgument(308, 1);
	scene.m:setArgument(309, 0.25);
	scene.m:setArgument(310, 0.15);
	scene.m:setArgument(443, 0.6);
	scene.m:setArgument(444, 0.1);
	scene.m:setArgument(445, 0.7);
	scene.m:setArgument(844, 1);
	scene.m:setArgument(902, 0.1);
	scene.m:setArgument(901, 0.0);
	scene.m:setArgument(985, 0.0);
	scene.m:setArgument(986, 0.1);
	scene.m:setArgument(987, 0.2);
	scene.m:setArgument(988, 0.2);
	scene.m:setArgument(989, 0.1);
	scene.m:setArgument(990, 0.501);
	scene.m:setArgument(991, 0.1);
	scene.m:setArgument(992, 0.1);
	scene.m:setArgument(993, 0);
	
	scene.magicII = sceneAPI:addModel("MAGIC-R550", 0, 0, 0);
	scene.magicII:attachTo(scene.m, "Pylon1");
	scene.barax = sceneAPI:addModel("BARAX", -0.4, 0.02, 0);
	scene.barax:attachTo(scene.m, "Pylon2");
	scene.gbu = sceneAPI:addModel("gbu-12", 0.41, -0.13, 0);
	scene.gbu:setArgument(2, 1);
	scene.gbu:attachTo(scene.m, "Pylon3");
	scene.bidon1 = sceneAPI:addModel("PTB_580G_F1", 0, 0, 0);
	scene.bidon1:attachTo(scene.m, "Pylon4");
	
	scene.c			= sceneAPI:addModel("carrier_lso_usa", 2.6, 0.00, 1.2);
	scene.c.transform:rotate(0,40.0,0);
	scene.cb			= sceneAPI:addModel("carrier_lso2_usa", -2, 0, -6);

	scene.tank			= sceneAPI:addModel("PTB_1200_F1_EMPTY", 4, 0.55, -8.1);
	scene.tank:setLivery("USA Company", "Mirage-F1CT")
	scene.tank.transform:rotate(0,0,2);
	scene.tankBis			= sceneAPI:addModel("PTB_1200_F1_EMPTY", 2, 0.62, 8);
	scene.tankBis:setLivery("USA Company", "Mirage-F1CT")
	scene.tankBis.transform:rotate(0,0,2);

	local cam_level = 1.8

	scene.cam		= sceneAPI:addCamera(8, cam_level , -6)
	scene.cam:setFarClip(1000.0)
	scene.cam:setFov(90)
	scene.cam.transform:lookAtPoint(14.5, cam_level, 0);


	scene.flr		= sceneAPI:addModel("shelter_floor", 0,0,0);
	scene.flr:drawToEnvironment(true);
	scene.flr.transform:scale(2,1.5,1.5);

	scene.sh		= sceneAPI:addModel("ukrytie", 0,0,0); 
	--scene.sh		= sceneAPI:addModel("Hangar_istres_ferme", 13.3,0,0); 
	scene.sh:drawToEnvironment(true);
	scene.sh.transform:scale(0.88,0.78,0.88);
	--scene.sh.transform:scale(1.2,1.2,1.2);

	scene.L1			= sceneAPI:addLightOmni(0, 25, 0,	1,0.8,0.5);
	scene.L1:setRadius(200);
	scene.L1:setAmount(1);

	scene.cam:setActive()

	preloadList = 
	{
		{"Mirage-F1", {}, {}},
		{"shelter_floor", {}, {}},
		{"ukrytie", 	  {}, {}},
		--{"Hangar_istres_ferme", 	  {}, {}},
	}
	sceneAPI:waitForModels(preloadList)	
end

--[0;1]
local function pingpong(length, t)
	local tt = (t%length)*2/length
	if tt>1 then tt = 2-tt end
	return tt
end


function sceneVRUpdate(t, dt)

end



