
dofile(LockOn_Options.script_path.."devices.lua")

dofile(LockOn_Options.script_path.."command_defs.lua")

function round(num, idp)
    local mult = 10^(idp or 0)
    return math.floor(num * mult + 0.5) / mult
end




local symbols={}
symbols['AH-64D']='64'
symbols['SH-60B']='UU'
symbols['A-50']='50'
symbols['B-1B']='B1'
symbols['B-52H']='52'
symbols['E-2C']='E2'
symbols['E-3A']='E3'
symbols['F-14A']='14'
symbols['F-15C']='15'
symbols['F-15E']='15'
symbols['F-16A MLU']='16'
symbols['F-16A']='16'
symbols['F-16C_50']='16'
symbols['F-16C bl.52d']='16'
symbols['F-16C bl.50']='16'
symbols['F-4E']='F4'
symbols['F/A-18A']='18'
symbols['F/A-18C']='18'
symbols['MiG-23MLD']='23'
symbols['MiG-25PD']='25'
symbols['MiG-29A']='29'
symbols['MiG-29G']='29'
symbols['MiG-29K']='29'
symbols['MiG-29S']='29'
symbols['MiG-31']='31'
symbols['Mirage 2000-5']='M2'
symbols['RQ-1A Predator']='RQ'
symbols['S-3B Tanker']='S3'
symbols['S-3B']='S3'
symbols['Su-24M']='24'
symbols['Su-27']='29'
symbols['Su-30']='30'
symbols['Su-33']='29'
symbols['Tornado GR4']='F2'
symbols['Tornado IDS']='F2'
symbols['Tu-142']='Tu'
symbols['Tu-160']='BJ'
symbols['Tu-22M3']='Tu'
symbols['Tu-95MS']='Tu'
symbols['J-11A']='29'
symbols['JF-17']='JF'
symbols['KJ-2000']='50'

symbols['2S6 Tunguska']='S6'
symbols['SA-11 Buk LN 9A310M1']='11'
symbols['Osa 9A33 ln']='S8'
symbols['Tor 9A331']='15'
symbols['Patriot ECS']='PT'
symbols['Gepard']='A'
symbols['Hawk pcp']='HK'
symbols['Vulcan']='A'
symbols['1L13 EWR']='EW'
symbols['Kub 1S91 str']='06'
symbols['S-300PS 40B6M tr']='10'
symbols['S-300PS 40B6MD sr']='10'
symbols['55G6 EWR']='EW'
symbols['S-300PS 64H6E sr']='10'
symbols['SA-11 Buk SR 9S18M1']='SD'
symbols['Dog Ear radar']='DE'
symbols['Hawk tr']='HK'
symbols['Hawk sr']='HK'
symbols['Patriot str']='PT'
symbols['Hawk cwar']='HK'
symbols['p-19 s-125 sr']='LB'
symbols['Roland Radar']='GR'
symbols['snr s-125 tr']='LB'
symbols['Roland ADS']='RO'
symbols['S-300PS 54K6 cp']='10'
symbols['ZSU-23-4 Shilka']='A'



symbols['Silkworm_SR']='SR'
symbols['SNR_75V']='FS'
symbols['rapier_fsa_blindfire_radar']='RS'
symbols['rapier_fsa_launcher']='RT'
symbols['HQ-7_LN_SP']='HQ'
symbols['HQ-7_STR_SP']='HQ'

symbols['VINSON']='48'
symbols['PERRY']='49'
symbols['TICONDEROG']='AE'
symbols['ALBATROS']='U'
symbols['KUZNECOW']='SW'
symbols['MOLNIYA']='PS'
symbols['MOSCOW']='T2'
symbols['NEUSTRASH']='TP'
symbols['PIOTR']='HN'
symbols['REZKY']='TP'
symbols['Type_052B']='CC'
symbols['Type_052C']='CC'
symbols['Type_054A']='CC'
symbols['Type_071']='CC'
symbols['Type_093']='CC'


symbols['MiG-21Bis']		= '21'
symbols['F-5E-3']			= 'F5'
symbols['F-16C_50']		= '16'
symbols['FA-18C_hornet']	= '18'
symbols['J-11A']			= '29'


symbols['rapier_fsa_blindfire_radar'] = 'RP'
symbols['rapier_fsa_launcher']		   = 'RT'
symbols['SNR_75V']					   = '2'
symbols['Hawk cwar']				   = 'HK'

symbols['CVN_71']			= 'SS'
symbols['CVN_72']			= 'SS'
symbols['CVN_73']			= 'SS'
symbols['Stennis']			= 'SS'

symbols['CV_1143_5']		= 'SW'

symbols['F-14A']		 = '14'
symbols['F-14B']		 = '14'
symbols['F-14D']		 = '14'
symbols['AIM_54A_Mk60'] = 'M'
symbols['AIM_54A_Mk47'] = 'M'

symbols['LHA_Tarawa']	 	= '40'
symbols['M-2000C']			= 'M2'
symbols['MiG-19P']			= '19'

symbols['KJ-2000']			= '50'
symbols['JF-17']			= 'JF'
symbols['HQ-7_LN_SP']		= '7'
symbols['HQ-7_STR_SP']		= 'HQ'
symbols['PL-12']			= 'M'
symbols['SD-10']			= 'M'


rwrPower = get_param_handle("RWR_POWER")
rwrBrightness = get_param_handle("RWR_BRIGHTNESS")
rwrLoudness = get_param_handle("RWR_LOUDNESS")

-- local scale  	 = get_param_handle("SCALE_PARAMETER")
-- local rotate  	 = get_param_handle("ROTATE_PARAMETER")

ac_ok = get_param_handle("AC_OK")
ac_ok:set(0)


rwrBrightness:set(0.5)
local RWR_Power=0

local gettext = require("i_18n")
_ = gettext.translate

update_time_step = 0.025
make_default_activity(update_time_step) 


local dev 	    = GetSelf()

local electric_system=GetDevice(devices.ELECTRIC_SYSTEM)



MaxThreats          = 12
EmitterLiveTime     = 7.0
EmitterSoundTime    = 0.5
LaunchSoundDelay    = 15.0

DefaultType          = 100

RWR_detection_coeff = 0.85
DEFAULT_TYPE_ = {DefaultType, DefaultType, DefaultType, DefaultType}

eyes ={}	-- sensor locations
eyes[1] =
	{
		position      = {x = 2.57,y = -0.7,z =  0.8}, --{Forward/Back,U/D,L/R}
		orientation   = {azimuth  = math.rad(45),elevation = math.rad(0.0)},
		field_of_view = math.rad(120) 
	}
eyes[2] =
	{
		position      = {x = 2.57,y = -0.7,z = -0.8},
		orientation   = {azimuth  = math.rad(-45),elevation = math.rad(0.0)},
		field_of_view = math.rad(120) 
	}
eyes[3] =
	{
		position      = {x = -3,y = 0.5,z =  0.3},
		orientation   = {azimuth  = math.rad(135),elevation = math.rad(0.0)},
		field_of_view = math.rad(120) 
	}
eyes[4] =
	{
		position      = {x = -3,y = 0.5,z =  -0.3},
		orientation   = {azimuth  = math.rad(-135),elevation = math.rad(0.0)},
		field_of_view = math.rad(120) 
	}


	
---------------------------------------------------------------------------------
---------------------------------------------------------------------------------


rwr = 	{}
for ia = 1,20  do	
	if ia  < 10 then
		i = "_0".. ia .."_"
	else
		i = "_".. ia .."_"
	end
	rwr[ia] =
	{
		elevation_h 	= get_param_handle("RWR_CONTACT" .. i .. "ELEVATION"),
		azimuth_h 		= get_param_handle("RWR_CONTACT" .. i .. "AZIMUTH"),
		power_h 		= get_param_handle("RWR_CONTACT" .. i .. "POWER"),
		unit_type_h			= get_param_handle("RWR_CONTACT" .. i .. "UNIT_TYPE"),
	
		general_type_h		= get_param_handle("RWR_CONTACT" .. i .. "GENERAL_TYPE"),
		priority_h		= get_param_handle("RWR_CONTACT" .. i .. "PRIORITY"),
		signal_h		= get_param_handle("RWR_CONTACT" .. i .. "SIGNAL"),
		time_h		= get_param_handle("RWR_CONTACT" .. i .. "TIME"),
		source_h		= get_param_handle("RWR_CONTACT" .. i .. "SOURCE"),
		
		unit_type_sym_h= get_param_handle("RWR_CONTACT" .. i .. "UNIT_TYPE_SYM"),
		unit_type_sym_num= get_param_handle("RWR_CONTACT" .. i .. "UNIT_TYPE_SYM_NUMERIC"),
		
		unit_type_is_num= get_param_handle("RWR_CONTACT" .. i .. "UNIT_TYPE_IS_NUMERIC"),
		power_sym_h 	= get_param_handle("RWR_CONTACT" .. i .. "POWER_SYM"),
		lock_sym_h 	= get_param_handle("RWR_CONTACT" .. i .. "LOCK_SYM"),
	}
end


function post_initialize()
	
	
	soundhost = create_sound_host("COCKPIT_RADAR_WARN","HEADPHONES",0,0,0)
    
	rwrWarn 	= soundhost:create_sound("Aircrafts/RWR/rwr_warn") 
	rwrLock 	= soundhost:create_sound("Aircrafts/RWR/rwr_lock") 
	
	
	update()
	
	local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 	
        dev:performClickableAction(device_commands.OnOffSwitch,1,true) 
    elseif birth=="GROUND_COLD" then
		dev:performClickableAction(device_commands.OnOffSwitch,0,true)	
    end
	dev:performClickableAction(device_commands.Brightness, 0.5) -- Brightness at 50%
	dev:performClickableAction(device_commands.Loudness, 0.5) -- Volume knobs at 50%
end

dev:listen_command(device_commands.OnOffSwitch)
dev:listen_command(device_commands.Brightness)
dev:listen_command(device_commands.Loudness)

function SetCommand(command,value)
    if command == device_commands.OnOffSwitch then
		RWR_Power = value
	end 	
	
	if command == device_commands.Brightness then
		rwrBrightness:set(value)
	end
	
	if command == device_commands.Loudness then
		volumeLock = math.pow((((round(value/0.5,2))*0.3)),3)
		volumeWarn = math.pow((((round(value/0.5,2))*0.4)),3)
		rwrLock:update(nil,volumeLock,nil)
		rwrWarn:update(nil,volumeWarn,nil)
	end
end

function update()
	
	local tmp_type,tmp_signal,tmp_gen_type
	local lock =false
	local warn = false
	for i = 1,20 do
	
		tmp_type 		= rwr[i].unit_type_h:get()
		
		--rwr[i].power_h:get(),rwr[i].signal_h:get()
		tmp_gen_type 	= rwr[i].general_type_h:get()
		if  tmp_type and tmp_type ~= "" then
			
			if tmp_type~=0 then
				--print_message_to_user("Unit:"..tmp_type..",power:"..rwr[i].power_h:get()..",signal:"..rwr[i].signal_h:get())	
				tmp_signal = rwr[i].signal_h:get()
				if tmp_signal == 2 then				-- 2 Lock
					lock=true
					rwr[i].lock_sym_h:set(0.5)
				elseif tmp_signal == 3 then			-- 3 Launch
					warn=true
					if rwr[i].lock_sym_h:get() == 1 then
						rwr[i].lock_sym_h:set(0.5)
						lock=true
					else
						rwr[i].lock_sym_h:set(0.5)
						lock=true
					end
				else								--else 1 - Search
					rwr[i].lock_sym_h:set(1.0)
				end
				
				
				symb=symbols[tmp_type]
				if symb==nil then
					--print_message_to_user("Unit:"..tmp_type)	
					symb="UU"
				end	
				--textfromparameter did not work from numeric text in string don't know why. Added an extra renderitem
				if tonumber(symb)~=nil then
					rwr[i].unit_type_sym_num:set(symb)
					rwr[i].unit_type_is_num:set(1.0)
				else
					rwr[i].unit_type_sym_h:set(symb)
					rwr[i].unit_type_is_num:set(0.5)
				end
				--tmp_gen_type: 1->plane, 2->SearchRadar,3->ship,0 ewr
				
			end
		end
		tmp = 1-rwr[i].power_h:get() + 0.1
		rwr[i].power_sym_h:set(tmp)
	end

	if ac_ok:get()==1 and RWR_Power ==1 then
		--print_message_to_user(volumeLock)
		if lock == false then
			if rwrLock:is_playing() then
				rwrLock:stop()
				rwrLock:update(nil,volumeLock,nil)
			end
		else
			
			if not rwrLock:is_playing() then
				
				rwrLock:play_continue()
				rwrLock:update(nil,volumeLock,nil)
			end
		end
			
		if warn == false then
			if rwrWarn:is_playing() then
				rwrWarn:stop()
			end
		else
			if not rwrWarn:is_playing() then
				rwrWarn:play_continue()
			end
		end
	else
		if rwrLock:is_playing() then
			--print_message_to_user("Stop")
			rwrLock:stop()
		end
		if rwrWarn:is_playing() then
				rwrWarn:stop()
		end
	end
		rwrLock:update(nil,volumeLock,nil)
		rwrWarn:update(nil,volumeWarn,nil)	
	
	if ac_ok:get()==1 and RWR_Power ==1 then
		rwrPower:set(1)
		dev:set_power(true)
	else
		rwrPower:set(0)
		dev:set_power(false)
	end	
	
	
end

