dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")
--dofile(LockOn_Options.script_path .. "sounds.lua")

local gettext = require("i_18n")
_ = gettext.translate

log.debug("RWR Clickable")
function default_2_position_tumb(hint_,device_,command_,arg_,animation_speed_)
	local	animation_speed_ = animation_speed_ or anim_speed_default
	return  {
				class			= {class_type.TUMB,class_type.TUMB},
				hint			= hint_,
				device			= device_,
				action			= {command_,command_},
				arg				= {arg_,arg_},
				arg_value		= {1,-1},
				arg_lim			= {{0,1},{0,1}},
				updatable		= true,
				use_OBB			= true,
				animated		= {true,true},
			    animation_speed	= {animation_speed_,animation_speed_},
				sound			= {}
			}
end

function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_,cycled_)
	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	
	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {{0,1}},
				updatable 	= updatable, 
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
				cycle 		= cycled_ or false,
				sound		= {}
			}
end

function default_axis_limited(hint_,device_,command_,arg_,default_,gain_,updatable_,relative_,arg_lim_)
	local	default = default_ or 0
	local	updatable = updatable_ or false
	local	relative  = relative_ or false
	local	cycled_ = false
	local	arg_lim = arg_lim_ or {0,1}

	local	element = default_axis(hint_,device_,command_,arg_,default,gain_,updatable,relative,cycled_)
	element.arg_lim   	= {arg_lim}
	element.use_OBB 	= false
	return element
end


elements = {}

elements["ONOFF_PTR"]	= default_2_position_tumb(_("RWR, ON/OFF"), devices.RWR, device_commands.OnOffSwitch,	0,16)
elements["Brightness_PTR"]	= default_axis_limited(_("RWR, Brightness"), 		devices.RWR, device_commands.Brightness, 1, 0.5)
elements["Loundness_PTR"]	= default_axis_limited(_("RWR, Loudness"), 		devices.RWR, device_commands.Loudness, 2, 0.5)