------------------------------------------------------------------------------------------------------------------
--**               Carro Armato Tedesco WWII  Panzer IV
--
-- 
-- Mod by Markindel (www.news3d.eu)  
------------------------------------------------------------------------------------------------------------------

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/Textures_Panzer_IV.zip")


-- T-55A
GT_t.CH_t.T55 = {
	life = 18,
	mass = 36000,
	length = 9,
	width = 3.27,
	max_road_velocity = 12,
	max_slope = 0.27,
	canSwim = false,
	canWade = true,
	engine_power = 580,
	gear_count = 7,
	max_vert_obstacle = 0.5,
	max_acceleration = 1.85185,
	min_turn_radius = 3,
	X_gear_1 = 2.062,
	Y_gear_1 = 0,
	Z_gear_1 = 1.346,
	X_gear_2 = -2.674,
	Y_gear_2 = 0,
	Z_gear_2 = 1.346,
	r_max = 0.46,
	r_track = 0.6,
	armour_thickness = 0.040,
}


GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_tank);

GT.armour_scheme = {
					hull_azimuth = { {0,35,5.2}, {35,80,1.3}, {80,180,0.8}},
					hull_elevation = { {-90,6,100},{6,8,0.13}, {8,24,1}, {24,90,0.5}, },

					turret_azimuth = { {0,56,5.2}, {56,150,3.6}, {150,180,0.8}, },
					turret_elevation = { {-90,45,1}, {45,90,0.2}, }
					};
set_recursive_metatable(GT.chassis, GT_t.CH_t.M1); -- armour_thickness = 0.1

GT.visual.shape = "Panzer_IV";
GT.visual.shape_dstr = "Panzer_IV_DSRT";


-- Turbine
---GT.turbine = true;
GT.turbine = false;
-- Turbine

-- Sound
GT.sound = {};



-- Engine params
GT.sound.engine = {};
GT.sound.engine.idle = "GndTech/T72EngineIdle";
GT.sound.engine.max = "GndTech/T72EngineMax";

GT.sound.engine.acc_start = "GndTech/T72EngineAccStart";
GT.sound.engine.acc_end = "GndTech/T55EngineAccEnd";

GT.sound.engine.idle_formula_gain = "0.2 x * 1 +";
GT.sound.engine.idle_formula_pitch = "1.2436 x * 0.7564 +";

GT.sound.engine.max_formula_gain = "0.75 x * 0.25 +";
GT.sound.engine.max_formula_pitch = "0.4363 x * 0.5637 +";
-- Engine params



-- Move params
GT.sound.move = {};
GT.sound.move.sound = "GndTech/TankMove";
GT.sound.move.pitch = {{0.0, 0.6}, {10.0, 1.2}};
GT.sound.move.gain = {{0.0, 0.01}, {0.5, 0.5}, {12.0, 1.0}};
GT.sound.move.start_move = "GndTech/TStartMove";
GT.sound.move.end_move = "GndTech/TEndMove";
-- Move params


GT.sound.noise = {};
GT.sound.noise.sound = "Damage/VehHit";

-- Sound

-- Physics
GT.physics = {};

-- Brake system
GT.physics.brake = {};
GT.physics.brake.delta = 0.15;
-- Brake system

-- Physics

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 2.713;
GT.airWeaponDist = 3500

--Burning after hit
GT.visual.fire_size = 1.0; --relative burning size
GT.visual.fire_pos[1] = 0; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 1200; --burning time (seconds)

-- weapon systems
GT.WS = {};
GT.WS.maxTargetDetectionRange = 6000;


--GT.WS[1]
local ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].center = 'CENTER_TOWER';
GT.WS[ws].angles = {
                    {math.rad(133), math.rad(-133), math.rad(-10), math.rad(20)},
                    {math.rad(-133), math.rad(133), math.rad(1), math.rad(20)},
                    };
GT.WS[ws].drawArgument1 = 0;
GT.WS[ws].drawArgument2 = 1;
GT.WS[ws].omegaY = math.rad(42);
GT.WS[ws].omegaZ = math.rad(42);

GT.WS[ws].pidY = {p=100, i=0.0, d=14.0, inn = 10};
GT.WS[ws].pidZ = {p=100, i=0.0, d=14.0, inn = 10};
GT.WS[ws].pointer = "POINT_GUN";
GT.WS[ws].stabilizer = true;
GT.WS[ws].laser = true;

--GT.WS[1].LN[1] ----- Mitragliatrice Coassiale --------------------------------------------
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_M240C); -- coaxial
set_recursive_metatable(__LN.sensor, GT_t.WSN_t[7]);
__LN.beamWidth = math.rad(1);
__LN.PL[1].ammo_capacity = 2800; --http://btvt.narod.ru/4/M1.htm
__LN.BR[1].connector_name = 'POINT_MGUN_01';
__LN.fireAnimationArgument = 44;

---- Mitragliatrice Coassiale
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
-----__LN.customViewPoint = { "genericAAA", {-3.5, 0.27, 0.32 }, };
__LN.customViewPoint = { "genericAAA",  {-35.5, 6.3, 0 }, };

--GT.WS[1].LN[2]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.tank_gun_120mm);
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.tank_gun_105mm); -- In attesa del 75mm
__LN.automaticLoader = false;
__LN.beamWidth = math.rad(1);
__LN.BR[1].connector_name = 'POINT_GUN';
__LN.PL[1].ammo_capacity = 11
__LN.PL[1].shot_delay = 6
__LN.PL[1].shell_name = {"M256_120_AP"};
__LN.PL[2].ammo_capacity = 14
__LN.PL[2].shot_delay = 18
__LN.PL[2].shell_name = {"M256_120_AP"};
__LN.customViewPoint = { "genericTankblue",  {-35.5, 6.3, 0 }, };


__LN = add_launcher(GT.WS[ws], __LN); -- HE rounds launcher
--__LN = add_launcher(GT.WS[ws], __t.LN_t.tank_gun_105mm); -- In attesa del 75mm
__LN.type = 6;
__LN.distanceMin = 300;
__LN.distanceMax = 8000;
__LN.PL[1].ammo_capacity = 7;
__LN.PL[1].shot_delay = 6;
__LN.PL[1].shell_name = {"M256_120_HE"};
__LN.PL[2].ammo_capacity = 10
__LN.PL[2].shot_delay = 18;
__LN.PL[2].shell_name = {"M256_120_HE"};
----__LN.customViewPoint = { "genericTankblueHE", {-3.5, 0.3, 0 }, };  Valore Originale
---- Cannone Principale da 105mm
__LN.customViewPoint = { "genericTankblueHE",  {-35.5, 6.3, 0 }, };


--GT.WS[2] ------- Mitragliatrice nello Scafo
ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].base = 1;
GT.WS[ws].center = 'CENTER_MGUN';
GT.WS[ws].angles = {
                    {math.rad(180), math.rad(65), math.rad(-8), math.rad(30)},
                    {math.rad(65), math.rad(45), math.rad(22), math.rad(30)},
                    {math.rad(45), math.rad(-3.5), math.rad(-8), math.rad(30)},
                    {math.rad(-3.5), math.rad(-45), math.rad(0), math.rad(30)},
                    {math.rad(-45), math.rad(-180), math.rad(-8), math.rad(30)},
                    };
GT.WS[ws].drawArgument1 = 25;
GT.WS[ws].drawArgument2 = 26;
GT.WS[ws].omegaY = math.rad(50);
GT.WS[ws].omegaZ = math.rad(50);
GT.WS[ws].pidY = {p=100,i=0.1,d=12,inn=50,};
GT.WS[ws].pidZ = {p=100,i=0.1,d=12,inn=50,};

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.type = 10; -- AA Machinegun
__LN.fireAnimationArgument = 23;
__LN.BR[1].connector_name = 'POINT_MGUN';
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
------__LN.customViewPoint = { "genericAAA", {-1.3, 0.1, 0 }, };
__LN.customViewPoint = { "genericAAA", {-8.0, 3.0, -1.0 }, };
__LN = nil;



GT.Name = "Panzer_IV";
GT.DisplayName = _("WWII Panzer IV");
GT.Rate = 10;

GT.Sensors = { OPTIC = {"TKN-3B day", "TKN-3B night",
                        "TSH-2-22 day","TPN1 night",
                        },
            };

GT.DetectionRange  = 0;
GT.ThreatRange =  GT.WS[1].LN[2].distanceMax;
GT.mapclasskey = "P0091000001";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,wsType_GenericTank,
                "Tanks",
                "Old Tanks",
                };
GT.category = "Armor";

---------------------------------------------------------------------------------------------------------------------------------------------------

add_surface_unit(GT)
