Terrain = require('terrain')
dofile(LockOn_Options.script_path.."nav/beacons.lua")
dofile(LockOn_Options.script_path.."nav/airports_data.lua")
dofile(LockOn_Options.script_path.."nav/town_data.lua")

local WPT_SIZE = get_param_handle('WPT_SIZE')
local maxRange_h = get_param_handle('MAX_RANGE')

local wpts = {}
local wpts_ufcp = {
    get_param_handle('WPTS_UFCP_Line_1'),
    get_param_handle('WPTS_UFCP_Line_2'),
    get_param_handle('WPTS_UFCP_Line_3'),
    get_param_handle('WPTS_UFCP_Line_4'),
}
local searchResult_ufcp = {
    get_param_handle('WPT_SEARCH_RESULT_L1'),
    get_param_handle('WPT_SEARCH_RESULT_L2'),
    get_param_handle('WPT_SEARCH_RESULT_L3'),
    get_param_handle('WPT_SEARCH_RESULT_L4'),
}

local searchResult = {}
local searchResultOffset = 0
local wptOffset = 0
local addWptUfcpPos = 0
local editIdx = 0
local terrain = require('terrain')

local dd,mm,ss = 0,0,0
function InputCoord(num)
    if Params_h.WPT_EDIT_LAT[2]==1 then
        if Params_h.WPT_TMP_LAT_WAY[2] == '?' and type(num) =="number" and (num == 2 or num==8) then
            if num == 2 then
                Params_h.WPT_TMP_LAT_WAY[2] = 'N'
            else
                Params_h.WPT_TMP_LAT_WAY[2] = 'S'
            end

        elseif dd<2 and type(num)=="number" and Params_h.WPT_TMP_LAT_WAY[2] ~= '?' then
            if dd==0 then
                Params_h.WPT_TMP_LAT_DD[2] = num*10
            else
                Params_h.WPT_TMP_LAT_DD[2] = num + Params_h.WPT_TMP_LAT_DD[2]
            end
            dd = dd + 1
        elseif mm<2 and type(num)=="number" and Params_h.WPT_TMP_LAT_WAY[2] ~= '?' then
            if mm==0 then
                Params_h.WPT_TMP_LAT_MM[2] = num*10
            else
                Params_h.WPT_TMP_LAT_MM[2] = num + Params_h.WPT_TMP_LAT_MM[2]
            end
            mm = mm + 1
        elseif ss<4 and type(num)=="number" and Params_h.WPT_TMP_LAT_WAY[2] ~= '?' then
            if ss==0 then
                Params_h.WPT_TMP_LAT_SS[2] = num*10
            elseif ss == 1 then
                Params_h.WPT_TMP_LAT_SS[2] = num + Params_h.WPT_TMP_LAT_SS[2]
            elseif ss == 2 then
                Params_h.WPT_TMP_LAT_SS[2] = num*0.1 + Params_h.WPT_TMP_LAT_SS[2]
            elseif ss == 3 then
                Params_h.WPT_TMP_LAT_SS[2] = num*0.01 + Params_h.WPT_TMP_LAT_SS[2]
            end
            ss = ss + 1
        end
    elseif Params_h.WPT_EDIT_LON[2]==1 then
        if Params_h.WPT_TMP_LON_WAY[2] == '?' and type(num) =="number" and (num == 4 or num==6) then
            if num == 6 then
                Params_h.WPT_TMP_LON_WAY[2] = 'E'
            else
                Params_h.WPT_TMP_LON_WAY[2] = 'W'
            end
        elseif dd<3 and type(num)=="number" and Params_h.WPT_TMP_LON_WAY[2] ~= '?' then
            if dd==0 then
                Params_h.WPT_TMP_LON_DD[2] = num*100
            elseif  dd == 1 then
                Params_h.WPT_TMP_LON_DD[2] = num*10 + Params_h.WPT_TMP_LON_DD[2]
            else
                Params_h.WPT_TMP_LON_DD[2] = num + Params_h.WPT_TMP_LON_DD[2]
            end
            dd = dd + 1
        elseif mm<2 and type(num)=="number" and Params_h.WPT_TMP_LON_WAY[2] ~= '?' then
            if mm==0 then
                Params_h.WPT_TMP_LON_MM[2] = num*10
            else
                Params_h.WPT_TMP_LON_MM[2] = num + Params_h.WPT_TMP_LON_MM[2]
            end
            mm = mm + 1
        elseif ss<4 and type(num)=="number" and Params_h.WPT_TMP_LON_WAY[2] ~= '?' then
            if ss==0 then
                Params_h.WPT_TMP_LON_SS[2] = num*10
            elseif ss == 1 then
                Params_h.WPT_TMP_LON_SS[2] = num + Params_h.WPT_TMP_LON_SS[2]
            elseif ss == 2 then
                Params_h.WPT_TMP_LON_SS[2] = num*0.1 + Params_h.WPT_TMP_LON_SS[2]
            elseif ss == 3 then
                Params_h.WPT_TMP_LON_SS[2] = num*0.01 + Params_h.WPT_TMP_LON_SS[2]
            end
            ss = ss + 1
        end
    end
end

function InputSearch(num)
    if Params_h.WPT_EDIT_SEARCH_KEY[2] == 1 then
        if (Params_h.WPT_TMP_SEARCH_KEY[2] == '' and type(num)=="string") or Params_h.WPT_TMP_SEARCH_KEY[2] ~= '' then
            Params_h.WPT_TMP_SEARCH_KEY[2] = Params_h.WPT_TMP_SEARCH_KEY[2]..tostring(num)
        end
    end
end

function InputAlt(num)
    if Params_h.WPT_EDIT_ALT[2] == 1 then
        if type(num)=="number" then
            local str = string.format('%.0f%.0f',Params_h.WPT_TMP_ALT[2],num)
            Params_h.WPT_TMP_ALT[2] = tonumber(str)
        end
    end
end

function InputSpeed(num)
    if Params_h.WPT_EDIT_SPD[2] == 1 then
        if type(num)=="number" then
            local str = string.format('%.0f%.0f',Params_h.WPT_TMP_SPD[2],num)
            Params_h.WPT_TMP_SPD[2] = tonumber(str)
        end
    end
end

function CheckInputCoord()
    if Params_h.WPT_EDIT_LAT[2] == 1 then
        Params_h.WPT_LAT_DD[2] = Params_h.WPT_TMP_LAT_DD[2]
        Params_h.WPT_LAT_MM[2] = Params_h.WPT_TMP_LAT_MM[2]
        Params_h.WPT_LAT_SS[2] = Params_h.WPT_TMP_LAT_SS[2]
        Params_h.WPT_LAT_WAY[2] = Params_h.WPT_TMP_LAT_WAY[2]
        dd,mm,ss = 0,0,0
        Params_h.WPT_EDIT_LAT[2] = 0
        Params_h.WPT_TMP_LAT_WAY[2] = ''
        Params_h.WPT_TMP_LAT_DD[2] = 0
        Params_h.WPT_TMP_LAT_MM[2] = 0
        Params_h.WPT_TMP_LAT_SS[2] = 0
    elseif Params_h.WPT_EDIT_LON[2] == 1 then
        Params_h.WPT_LON_DD[2] = Params_h.WPT_TMP_LON_DD[2]
        Params_h.WPT_LON_MM[2] = Params_h.WPT_TMP_LON_MM[2]
        Params_h.WPT_LON_SS[2] = Params_h.WPT_TMP_LON_SS[2]
        Params_h.WPT_LON_WAY[2] = Params_h.WPT_TMP_LON_WAY[2]
        dd,mm,ss = 0,0,0
        Params_h.WPT_EDIT_LON[2] = 0
        Params_h.WPT_TMP_LON_WAY[2] = ''
        Params_h.WPT_TMP_LON_DD[2] = 0
        Params_h.WPT_TMP_LON_MM[2] = 0
        Params_h.WPT_TMP_LON_SS[2] = 0
    end
end

function CheckInputSearch()
    Params_h.WPT_SEARCH_KEY[2] = Params_h.WPT_TMP_SEARCH_KEY[2]
    Params_h.WPT_TMP_SEARCH_KEY[2] = ''
    Params_h.WPT_EDIT_SEARCH_KEY[2] = 0
end

function CheckInputAlt()
    if Params_h.WPT_EDIT_ALT[2]==1 then
        Params_h.WPT_ALT[2] = Params_h.WPT_TMP_ALT[2]
        Params_h.WPT_TMP_ALT[2] = 0
        Params_h.WPT_EDIT_ALT[2]=0
    end
end

function CheckInputSpeed()
    if Params_h.WPT_EDIT_SPD[2]==1 then
        Params_h.WPT_SPD[2] = Params_h.WPT_TMP_SPD[2]
        Params_h.WPT_TMP_SPD[2] = 0
        Params_h.WPT_EDIT_SPD[2]=0
    end
end

function ClearData()
    Params_h.WPT_EDIT_ALT[2]=0
    Params_h.WPT_EDIT_SPD[2]=0
    Params_h.WPT_EDIT_SEARCH_KEY[2]=0
    Params_h.WPT_EDIT_LAT[2]=0
    Params_h.WPT_EDIT_LON[2]=0
    Params_h.WPT_TMP_ALT[2]=0
    Params_h.WPT_TMP_SPD[2]=0
    Params_h.WPT_TMP_SEARCH_KEY[2]=''
    Params_h.WPT_TMP_LAT_DD[2]=0
    Params_h.WPT_TMP_LAT_MM[2]=0
    Params_h.WPT_TMP_LAT_SS[2]=0
    Params_h.WPT_TMP_LAT_WAY[2]='?'
    Params_h.WPT_TMP_LON_DD[2]=0
    Params_h.WPT_TMP_LON_MM[2]=0
    Params_h.WPT_TMP_LON_SS[2]=0
    Params_h.WPT_TMP_LON_WAY[2]='?'
    Params_h.WPT_ALT[2]=0
    Params_h.WPT_TYPE[2]=0
    Params_h.WPT_SPD[2]=0
    Params_h.WPT_SEARCH_KEY[2]=''
    Params_h.WPT_LAT_DD[2]=0
    Params_h.WPT_LAT_MM[2]=0
    Params_h.WPT_LAT_SS[2]=0
    Params_h.WPT_LAT_WAY[2]='?'
    Params_h.WPT_LON_DD[2]=0
    Params_h.WPT_LON_MM[2]=0
    Params_h.WPT_LON_SS[2]=0
    Params_h.WPT_LON_WAY[2]='?'
end
local wpt_form = {
    lat = get_param_handle('WPT_FORM_LAT'),
    lon = get_param_handle('WPT_FORM_LON'),
    id = get_param_handle('WPT_FORM_ID'),
    alt = get_param_handle('WPT_FORM_ALT'),
    altType = get_param_handle('WPT_FORM_ALT_TYPE'),
    speed = get_param_handle('WPT_FORM_SPD'),
    type = get_param_handle('WPT_FORM_TYPE'),--0普通,1着陆,2攻击
    ok = get_param_handle('WPT_FORM_OK'),
}
function AddWpt()
    if Params_h.WPT_LAT_DD[2]==0 or Params_h.WPT_LON_DD[2]==0 then

    else
        local DD = DMS_to_DD(Params_h.WPT_LAT_WAY[2],Params_h.WPT_LAT_DD[2],Params_h.WPT_LAT_MM[2],Params_h.WPT_LAT_SS[2])
        wpt_form.lat:set(DD)
        DD = DMS_to_DD(Params_h.WPT_LON_WAY[2],Params_h.WPT_LON_DD[2],Params_h.WPT_LON_MM[2],Params_h.WPT_LON_SS[2])
        wpt_form.lon:set(DD)
        if editIdx == 0 then
            wpt_form.id:set(WPT_SIZE:get()+1)
        else
            wpt_form.id:set(editIdx)
        end
        if UNIT == 1 then
            wpt_form.speed:set(Params_h.WPT_SPD[2]/MS_TO_KNOTS)
            wpt_form.alt:set(Params_h.WPT_ALT[2]/METER_TO_INCH)
        else
            wpt_form.speed:set(Params_h.WPT_SPD[2]/MS_TO_KMH)
            wpt_form.alt:set(Params_h.WPT_ALT[2])
        end

        wpt_form.altType:set(Params_h.WPT_ALT_TYPE[2])
        wpt_form.ok:set(1)
        wpt_form.type:set(Params_h.WPT_TYPE[2])
        ClearData()
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPTS
    end
end

local function loadTargetWptInfo()
    if UNIT == 1 then
        Params_h.WPT_ALT[2]=wpts[editIdx].ALT:get()*METER_TO_INCH
        Params_h.WPT_SPD[2]=wpts[editIdx].SPD:get()*MS_TO_KNOTS
    else
        Params_h.WPT_ALT[2]=wpts[editIdx].ALT:get()
        Params_h.WPT_SPD[2]=wpts[editIdx].SPD:get()*MS_TO_KMH
    end

    if wpts[editIdx].ALT_TYPE:get() == 'BARO' then
        Params_h.WPT_ALT_TYPE[2] = 0
    else
        Params_h.WPT_ALT_TYPE[2] = 1
    end
    Params_h.WPT_TYPE[2] = wpts[editIdx].TYPE:get()
    Params_h.WPT_SEARCH_KEY[2]=''
    local scale = 40/maxRange_h:get()
    local lat = wpts[editIdx].LAT:get()/scale
    local lon = wpts[editIdx].LON:get()/scale
    lat,lon = terrain.convertMetersToLatLon(lat,lon)
    Params_h.WPT_LAT_WAY[2],Params_h.WPT_LAT_DD[2],Params_h.WPT_LAT_MM[2],Params_h.WPT_LAT_SS[2] = DD_to_D_M_S(lat,1)
    Params_h.WPT_LON_WAY[2],Params_h.WPT_LON_DD[2],Params_h.WPT_LON_MM[2],Params_h.WPT_LON_SS[2] = DD_to_D_M_S(lon,2)
end

local function search()
    if Params_h.WPT_SEARCH_TYPE[2] == 1 then -- 塔康
        for k, v in pairs(TCN_beacons) do
            if Params_h.WPT_SEARCH_KEY[2]=='' then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            elseif StringContains(v.callsign,Params_h.WPT_SEARCH_KEY[2]) then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            end
        end
    elseif Params_h.WPT_SEARCH_TYPE[2] == 2 then -- ILS
        for k, v in pairs(ILS_beacons) do
            if Params_h.WPT_SEARCH_KEY[2]=='' then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            elseif StringContains(v.callsign,Params_h.WPT_SEARCH_KEY[2]) then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            end
        end
    elseif Params_h.WPT_SEARCH_TYPE[2] == 3 then -- VOR
        for k, v in pairs(VOR_beacons) do
            if Params_h.WPT_SEARCH_KEY[2]=='' then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            elseif StringContains(v.callsign,Params_h.WPT_SEARCH_KEY[2]) then
                searchResult[#searchResult+1] = {lat = v.posGeo.latitude,lon=v.posGeo.longitude,label = v.callsign}
            end
        end
    elseif Params_h.WPT_SEARCH_TYPE[2] == 4 then -- 机场
        for k, v in pairs(AIRPORT_INFO) do
            if Params_h.WPT_SEARCH_KEY[2]=='' then
                searchResult[#searchResult+1] = {lat = v.LAT,lon=v.LON,label = v.CODE..k}
            elseif StringContains(v.CODE,Params_h.WPT_SEARCH_KEY[2]) then
                searchResult[#searchResult+1] = {lat = v.LAT,lon=v.LON,label = v.CODE..k}
            end
        end
    elseif Params_h.WPT_SEARCH_TYPE[2] == 5 then -- 城镇
        for k, v in pairs(Towns) do
            if Params_h.WPT_SEARCH_KEY[2]=='' then
                searchResult[#searchResult+1] = {lat = v.LAT,lon=v.LON,label = v.display_name}
            elseif StringContains(k,Params_h.WPT_SEARCH_KEY[2]) then
                searchResult[#searchResult+1] = {lat = v.LAT,lon=v.LON,label = v.display_name}
            end
        end
    end
    Params_h.NAV_SUB_PAGE[2]=Pages[Pages.NAV].SEARCH_RESULT
end

local function handleSearchResult(i)
    Params_h.WPT_LAT_WAY[2],Params_h.WPT_LAT_DD[2],Params_h.WPT_LAT_MM[2],Params_h.WPT_LAT_SS[2] = DD_to_D_M_S(searchResult[i+searchResultOffset].lat,1)
    Params_h.WPT_LON_WAY[2],Params_h.WPT_LON_DD[2],Params_h.WPT_LON_MM[2],Params_h.WPT_LON_SS[2] = DD_to_D_M_S(searchResult[i+searchResultOffset].lon,2)
    Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
    searchResult={}
    searchResultOffset = 0
end

-- 将第 idx 个航点设为当前激活导航点
local function activateNavPoint(idx)
    -- 检查索引有效性
    local maxWpts = WPT_SIZE:get()
    if idx < 1 or idx > maxWpts then
        return
    end
    -- 设置当前目标航点句柄值
    get_param_handle('TARGET_WPT'):set(idx)
end

function SetCommandNav(cmd,val)
    if cmd > UFCP_click_cmd.key0_up-1 and cmd < UFCP_click_cmd.key9_dn + 1 then
        local num = math.floor((cmd - UFCP_click_cmd.key0_up)*0.5)
        if Params_h.NAV_SUB_PAGE[2] >= Pages[Pages.NAV].WPTS and Params_h.NAV_SUB_PAGE[2] <= Pages[Pages.NAV].ALT then
            InputCoord(num)
            InputSearch(num)
            InputAlt(num)
            InputSpeed(num)
        end
    elseif cmd > Keybord_click_cmd.key_A - 1 and cmd < Keybord_click_cmd['key_+/-'] then
        if Params_h.NAV_SUB_PAGE[2] > Pages[Pages.NAV].WPT and Params_h.NAV_SUB_PAGE[2] <= Pages[Pages.NAV].ALT then
            local char = string.char(cmd-Keybord_click_cmd.key_A+65)
            InputCoord(char)
            InputSearch(char)
            InputAlt(char)
        end
    elseif cmd == UFCP_click_cmd.Enter_dn then
        if Params_h.WPT_EDIT_ALT[2]==1 then
            CheckInputAlt()
        elseif Params_h.WPT_EDIT_SPD[2]==1 then
            CheckInputSpeed()
        elseif Params_h.WPT_EDIT_LAT[2]==1 or Params_h.WPT_EDIT_LON[2]==1 then
            CheckInputCoord()
        elseif Params_h.WPT_EDIT_SEARCH_KEY[2]==1 then
            CheckInputSearch()
        end
    elseif cmd == UFCP_click_cmd.Clear_dn then
        Params_h.WPT_TMP_ALT[2]=0
        Params_h.WPT_TMP_SPD[2] = 0
        Params_h.WPT_TMP_SEARCH_KEY[2] = ''
        Params_h.WPT_TMP_LAT_DD[2] = 0
        Params_h.WPT_TMP_LAT_MM[2] = 0
        Params_h.WPT_TMP_LAT_SS[2] = 0
        Params_h.WPT_TMP_LAT_WAY[2] = '?'
        Params_h.WPT_TMP_LON_DD[2] = 0
        Params_h.WPT_TMP_LON_MM[2] = 0
        Params_h.WPT_TMP_LON_SS[2] = 0
        Params_h.WPT_TMP_LON_WAY[2] = '?'
        dd = 0
        mm = 0
        ss = 0
    end
end

function BoatCmdNav(val)
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        wptOffset = Limit(wptOffset + val,0,WPT_SIZE:get()-3)
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        searchResultOffset = Limit(searchResultOffset + val,0,#searchResult-4)
    end
end

function HandleL1Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].MENU then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].TCN
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
        editIdx = wptOffset + 1
        if editIdx <= WPT_SIZE:get() then
            loadTargetWptInfo()
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].COORD
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].COORD then
        Params_h.WPT_EDIT_LAT[2] = 1
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH then
        Params_h.WPT_EDIT_SEARCH_KEY[2] = 1
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].ALT then
        Params_h.WPT_EDIT_ALT[2] = 1
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(1)
    end
end

function HandleR1Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].MENU then

    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        -- 计算列表第一行对应的航点序号
        local firstWpt = wptOffset + 1
        -- 确保不超出总航点数
        if firstWpt <= WPT_SIZE:get() then
            activateNavPoint(firstWpt)
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.WPT_TYPE[2] = Params_h.WPT_TYPE[2] + 1
        if Params_h.WPT_TYPE[2]>2 then
            Params_h.WPT_TYPE[2] = 0
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(1)
    end
end

function HandleL2Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].MENU then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].ILS
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
        editIdx = wptOffset + 2
        if editIdx <= WPT_SIZE:get() then
            loadTargetWptInfo()
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].SEARCH
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].COORD then
        Params_h.WPT_EDIT_LON[2] = 1
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH then
        Params_h.WPT_SEARCH_TYPE[2] = LoopPlayAnimal(Params_h.WPT_SEARCH_TYPE[2],1,0,5)
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].ALT then
        Params_h.WPT_ALT_TYPE[2] = 1 - Params_h.WPT_ALT_TYPE[2]
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(2)
    end
end

function HandleR2Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        -- 计算列表第二行对应的航点序号
        local secondWpt = wptOffset + 2
        -- 确保不超出总航点数
        if secondWpt <= WPT_SIZE:get() then
            activateNavPoint(secondWpt)
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(2)
    end
end

function HandleL3Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].MENU then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].VOR
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
        editIdx = wptOffset + 3
        if editIdx <= WPT_SIZE:get() then
            loadTargetWptInfo()
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].ALT
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH then
        search()
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(3)
    end
end

function HandleR3Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        -- 计算列表第三行对应的航点序号
        local thirdWpt = wptOffset + 3
        -- 确保不超出总航点数
        if thirdWpt <= WPT_SIZE:get() then
            activateNavPoint(thirdWpt)
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        AddWpt()
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(3)
    end
end

function HandleL4Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].MENU then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPTS
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
        editIdx = wptOffset + 4
        if editIdx <= WPT_SIZE:get() then
            loadTargetWptInfo()
        end
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.WPT_EDIT_SPD[2] = 1
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        handleSearchResult(4)
    end
end

function HandleR4Nav()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPTS
        ClearData()
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].COORD then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].SEARCH_RESULT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].SEARCH
        searchResult = {}
        searchResultOffset = 0
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].ALT then
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].WPT
    elseif Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        -- 计算列表第四行对应的航点序号
        local forthWpt = wptOffset + 4
        -- 确保不超出总航点数
        if forthWpt <= WPT_SIZE:get() then
            activateNavPoint(forthWpt)
        end
    end
end

function InitWpts()
    for i = 1, 100, 1 do
        wpts[#wpts+1] = {
            N_LAT = get_param_handle(string.format('WPT_%02.0f_NEXT_REL_LAT',i)),
            N_LON = get_param_handle(string.format('WPT_%02.0f_NEXT_REL_LON',i)),
            NEXT = get_param_handle(string.format('WPT_%02.0f_NEXT',i)),
            LAT = get_param_handle(string.format('WPT_%02.0f_LAT',i)),
            LON = get_param_handle(string.format('WPT_%02.0f_LON',i)),
            NUM = get_param_handle(string.format('WPT_%02.0f_NUM',i)),
            ALT = get_param_handle(string.format('WPT_%02.0f_ALT',i)),
            ALT_TYPE = get_param_handle(string.format('WPT_%02.0f_ALT_TYPE',i)),
            SPD = get_param_handle(string.format('WPT_%02.0f_SPD',i)),
            TYPE = get_param_handle(string.format('WPT_%02.0f_TYPE',i)),
        }
    end
    Init_beacons()
    Init_airport_pos()
    Init_towns()
end

function UpdateWpt()
    local scale = 40/maxRange_h:get()
    if WPT_SIZE:get()>0 then
        for i = 1, WPT_SIZE:get() + 1, 1 do
            if i > wptOffset and i<= wptOffset + 4 then
                if i > WPT_SIZE:get() and (i == wptOffset + 4 or i < 4) then
                    wpts_ufcp[i-wptOffset]:set('\t\t\t  新增')
                    addWptUfcpPos = i-wptOffset
                    if i < 4 then
                        for j = i+1, 4, 1 do
                            wpts_ufcp[j]:set('')
                        end
                    end
                else
                    local lat = wpts[i].LAT:get()/scale
                    local lon = wpts[i].LON:get()/scale
                    lat,lon=terrain.convertMetersToLatLon(lat,lon)
                    wpts_ufcp[i-wptOffset]:set(string.format('%.0f\t%s %s',i,DD_to_DMS(lat,1),DD_to_DMS(lon,2)))
                end
            end
        end
    end
end

function UpdateSearchResultList()
    if Params_h.NAV_SUB_PAGE[2]==Pages[Pages.NAV].SEARCH_RESULT then
        for k, v in pairs(searchResult) do
            if k>searchResultOffset and k <= searchResultOffset + 4 then
                searchResult_ufcp[k-searchResultOffset]:set(v.label)
            end
        end
        Params_h.WPT_SEARCH_RESULT_LIST_SIZE[2] = #searchResult
    else
        for k, v in pairs(searchResult_ufcp) do
            v:set('')
        end
        Params_h.WPT_SEARCH_RESULT_LIST_SIZE[2] = 0
    end
end