dofile(LockOn_Options.common_script_path..'Radio.lua')
dofile(LockOn_Options.common_script_path.."mission_prepare.lua")

dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."displays/UFCP/Indicator/pages.lua")

dofile(LockOn_Options.script_path.."displays/UFCP/device/comm.lua")
dofile(LockOn_Options.script_path.."displays/UFCP/device/nav.lua")

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local UFCP = GetSelf()
local dayNight = 0
--local dayNight_h = get_param_handle('DAY_NIGHT')
local unit_h = get_param_handle('UNIT')

UFCP:listen_command(UFCP_click_cmd.key0_dn)
UFCP:listen_command(UFCP_click_cmd.key1_dn)
UFCP:listen_command(UFCP_click_cmd.key2_dn)
UFCP:listen_command(UFCP_click_cmd.key3_dn)
UFCP:listen_command(UFCP_click_cmd.key4_dn)
UFCP:listen_command(UFCP_click_cmd.key5_dn)
UFCP:listen_command(UFCP_click_cmd.key6_dn)
UFCP:listen_command(UFCP_click_cmd.key7_dn)
UFCP:listen_command(UFCP_click_cmd.key8_dn)
UFCP:listen_command(UFCP_click_cmd.key9_dn)
UFCP:listen_command(UFCP_click_cmd.Enter_dn)
UFCP:listen_command(UFCP_click_cmd.Clear_dn)
UFCP:listen_command(UFCP_click_cmd.L1_dn)
UFCP:listen_command(UFCP_click_cmd.L2_dn)
UFCP:listen_command(UFCP_click_cmd.L3_dn)
UFCP:listen_command(UFCP_click_cmd.L4_dn)
UFCP:listen_command(UFCP_click_cmd.R1_dn)
UFCP:listen_command(UFCP_click_cmd.R2_dn)
UFCP:listen_command(UFCP_click_cmd.R3_dn)
UFCP:listen_command(UFCP_click_cmd.R4_dn)
UFCP:listen_command(UFCP_click_cmd.comm_dn)
UFCP:listen_command(UFCP_click_cmd.Nav_dn)
UFCP:listen_command(UFCP_click_cmd.combat_dn)
UFCP:listen_command(UFCP_click_cmd.AP_dn)
UFCP:listen_command(UFCP_click_cmd.boat_dn)

Params_h = {
    UFCP_PAGE = {get_param_handle('UFCP_PAGE'),Pages.COMM},
    COMM1_FREQ = {get_param_handle('COMM1_FREQ'),0},
    COMM1_TMP_FREQ = {get_param_handle('COMM1_TMP_FREQ'),0},
    COMM1_ERR_FREQ = {get_param_handle('COMM1_ERR_FREQ'),0},
    COMM1_EDIT_FREQ = {get_param_handle('COMM1_EDIT_FREQ'),0},
    COMM1_AMFM = {get_param_handle('COMM1_AMFM'),'AM'},
    COMM1_PRE = {get_param_handle('COMM1_PRE'),1},
    COMM1_EDIT_PRE = {get_param_handle('COMM1_EDIT_PRE'),0},
    COMM1_PRE_MAN = {get_param_handle('COMM1_PRE_MAN'),0},
    COMM1_PRE_FREQ = {get_param_handle('COMM1_PRE_FREQ'),0},
    COMM2_FREQ = {get_param_handle('COMM2_FREQ'),0},
    COMM2_TMP_FREQ = {get_param_handle('COMM2_TMP_FREQ'),0},
    COMM2_ERR_FREQ = {get_param_handle('COMM2_ERR_FREQ'),0},
    COMM2_EDIT_FREQ = {get_param_handle('COMM2_EDIT_FREQ'),0},
    COMM2_AMFM = {get_param_handle('COMM2_AMFM'),'AM'},
    COMM2_PRE = {get_param_handle('COMM2_PRE'),1},
    COMM2_EDIT_PRE = {get_param_handle('COMM2_EDIT_PRE'),0},
    COMM2_PRE_MAN = {get_param_handle('COMM2_PRE_MAN'),0},
    COMM2_PRE_FREQ = {get_param_handle('COMM2_PRE_FREQ'),0},

    --IFF_INTERROGATOR_STATUS = {get_param_handle('IFF_INTERROGATOR_STATUS'),1,0},
    --IFF_STATUS = {get_param_handle('IFF_STATUS'),1,0},
    --NCTR_STATUS = {get_param_handle('NCTR_STATUS'),1,0},

    UFCP_BRT = {get_param_handle('UFCP_BRT'), 1, 0.98, 0.02},

    NAV_SUB_PAGE = {get_param_handle('NAV_SUB_PAGE'),0},

    WPT_LAT_WAY = {get_param_handle('WPT_LAT_WAY'),'?'},
    WPT_LAT_DD = {get_param_handle('WPT_LAT_DD'),0},
    WPT_LAT_MM = {get_param_handle('WPT_LAT_MM'),0},
    WPT_LAT_SS={get_param_handle('WPT_LAT_SS'),0},
    WPT_TMP_LAT_WAY = {get_param_handle('WPT_TMP_LAT_WAY'),'?'},
    WPT_TMP_LAT_DD = {get_param_handle('WPT_TMP_LAT_DD'),0},
    WPT_TMP_LAT_MM = {get_param_handle('WPT_TMP_LAT_MM'),0},
    WPT_TMP_LAT_SS={get_param_handle('WPT_TMP_LAT_SS'),0},
    WPT_EDIT_LAT = {get_param_handle('WPT_EDIT_LAT'),0},

    WPT_LON_WAY = {get_param_handle('WPT_LON_WAY'),'?'},
    WPT_LON_DD = {get_param_handle('WPT_LON_DD'),0},
    WPT_LON_MM = {get_param_handle('WPT_LON_MM'),0},
    WPT_LON_SS={get_param_handle('WPT_LON_SS'),0},
    WPT_TMP_LON_WAY = {get_param_handle('WPT_TMP_LON_WAY'),'?'},
    WPT_TMP_LON_DD = {get_param_handle('WPT_TMP_LON_DD'),0},
    WPT_TMP_LON_MM = {get_param_handle('WPT_TMP_LON_MM'),0},
    WPT_TMP_LON_SS={get_param_handle('WPT_TMP_LON_SS'),0},
    WPT_EDIT_LON = {get_param_handle('WPT_EDIT_LON'),0},

    WPT_SEARCH_KEY = {get_param_handle('WPT_SEARCH_KEY'),''},
    WPT_TMP_SEARCH_KEY = {get_param_handle('WPT_TMP_SEARCH_KEY'),''},
    WPT_EDIT_SEARCH_KEY = {get_param_handle('WPT_EDIT_SEARCH_KEY'),0},

    WPT_SEARCH_TYPE = {get_param_handle('WPT_SEARCH_TYPE'),1},

    WPT_SEARCH_RESULT_LIST_SIZE = {get_param_handle('WPT_SEARCH_RESULT_LIST_SIZE'),0},

    WPT_ALT = {get_param_handle('WPT_ALT'),0},
    WPT_TMP_ALT = {get_param_handle('WPT_TMP_ALT'),0},
    WPT_EDIT_ALT = {get_param_handle('WPT_EDIT_ALT'),0},

    WPT_ALT_TYPE = {get_param_handle('WPT_ALT_TYPE'),0},
    WPT_TYPE = {get_param_handle('WPT_TYPE'),0},

    WPT_SPD = {get_param_handle('WPT_SPD'),0},
    WPT_TMP_SPD = {get_param_handle('WPT_TMP_SPD'),0},
    WPT_EDIT_SPD = {get_param_handle('WPT_EDIT_SPD'),0},
}



local function handleLRFunction(cmd, val)
    local page = Params_h.UFCP_PAGE[2]
    local nav = Pages.NAV
    local comm = Pages.COMM

    if cmd == UFCP_click_cmd.L1_dn then
        if page == comm then
            HandleL1Comm()
        elseif page == nav then
            HandleL1Nav()
        end
    elseif cmd == UFCP_click_cmd.R1_dn then
        if page == comm then
            HandleR1Comm()
        elseif page == nav then
            HandleR1Nav()
        end
    elseif cmd == UFCP_click_cmd.L2_dn then
        if page == comm then
            HandleL2Comm()
        elseif page == nav then
            HandleL2Nav()
        end
    elseif cmd == UFCP_click_cmd.R2_dn then
        if page == comm then
            HandleR2Comm()
        elseif page == nav then
            HandleR2Nav()
        end
    elseif cmd == UFCP_click_cmd.L3_dn then
        if page == comm then
            HandleL3Comm()
        elseif page == nav then
            HandleL3Nav()
        end
    elseif cmd == UFCP_click_cmd.R3_dn then
        if page == comm then
            HandleR3Comm()
        elseif page == nav then
            HandleR3Nav()
        end
    elseif cmd == UFCP_click_cmd.L4_dn then
        if page == comm then
            HandleL4Comm()
        elseif page == nav then
            HandleL4Nav()
        end
    elseif cmd == UFCP_click_cmd.R4_dn then
        if page == comm then
            HandleR4Comm()
        elseif page == nav then
            HandleR4Nav()
        end
    end
end

function post_initialize()
    local birth = LockOn_Options.init_conditions.birth_place
    InitComm()
    InitWpts()
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then
        UFCP:performClickableAction(click_cmd.UFCPBrt, 1)
        Params_h.UFCP_BRT[2] = 1
        Params_h.UFCP_BRT[3] = 0.98
	--elseif birth=="GROUND_COLD" then
    end
end

function SetCommand(command,value)
    --print_message_to_user(string.format("UFCP SetCom:  %i Value: %.8f",command,value))
    if (command > UFCP_click_cmd.key0_up-1 and command < UFCP_click_cmd.Clear_dn + 1 and value == 1) or (command >= Keybord_click_cmd.key_A and command <= Keybord_click_cmd['key_+/-'] and value == 1) then
        if Params_h.UFCP_PAGE[2] == Pages.COMM then
            SetCommandComm(command,value)
        elseif Params_h.UFCP_PAGE[2]==Pages.NAV then
            SetCommandNav(command,value)
        end
    elseif command > UFCP_click_cmd.L1_up and command < UFCP_click_cmd.R4_dn + 1 and value == 1 then
        handleLRFunction(command,value)
    elseif command == UFCP_click_cmd.comm_dn and value == 1 then
        Params_h.UFCP_PAGE[2] = Pages.COMM
    elseif command == UFCP_click_cmd.Nav_dn and value == 1 then
        Params_h.UFCP_PAGE[2] = Pages.NAV
        Params_h.NAV_SUB_PAGE[2] = Pages[Pages.NAV].MENU
    elseif command == UFCP_click_cmd.combat_dn and value == 1 then
        Params_h.UFCP_PAGE[2] = Pages.COMBAT
    elseif command == UFCP_click_cmd.AP_dn and value == 1 then
        Params_h.UFCP_PAGE[2] = Pages.AP
    elseif command == UFCP_click_cmd.boat_dn and value == 1 then
        if Params_h.UFCP_PAGE[2]==Pages.NAV then
            BoatCmdNav(value)
        end
    elseif command == UFCP_click_cmd.boat_dn and value == -1 then
        if Params_h.UFCP_PAGE[2]==Pages.NAV then
            BoatCmdNav(value)
        end
    end
end

function update()
    UNIT = unit_h:get()
    --dayNight = dayNight_h:get()
    if Params_h.NAV_SUB_PAGE[2] == Pages[Pages.NAV].WPTS then
        UpdateWpt()
    end
    UpdateFreq()
    UpdateSearchResultList()
    for k, v in pairs(Params_h) do
        if type(v[3])~="nil"then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            if k == 'UFCP_BRT' then
                v[1]:set(v[3]*(1-0.8*dayNight))
            else
                v[1]:set(v[3])
            end
        else
			v[1]:set(v[2])
        end
    end
end

need_to_be_closed = false