local TOP_MASK_LEVEL = nil

-- 左发转速
local l_engRpm_sim = AddSimple(nil, {-0.94628175*width, -0.113475*height}, nil, T_Page_sim)
AddCircle(   nil, 0.441233*height, 0.384183*height, 270, 36, nil, nil, 'DBG_YELLOW',nil, TOP_MASK_LEVEL,  l_engRpm_sim)
AddCircle(   nil, 0.441233*height, 0.384183*height,  30, 36, nil,{90,0}, 'DBG_RED', nil, TOP_MASK_LEVEL,  l_engRpm_sim)
AddSimpleLine(
    nil,
    0.02*height,
    {{0,0.0},{0,0.384183*height}},
    nil, nil,
    'DBG_YELLOW',
    TOP_MASK_LEVEL,
    nil,
    l_engRpm_sim,
    {'L_ENG_RPM'},
    {
        {AnimalControllor.rotateUsingParameter, 0, math.rad(-2.7)}
    }
)
local txt = AddText(
    nil, nil, 'unicode_cn_white',
    {-0.30*height, 0.4*height}, nil,
    DEFAULT_FONT_SIZE[7],
    nil,
    TOP_MASK_LEVEL,
    l_engRpm_sim,
    {'%.1f'},
    {'L_ENG_RPM'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddBoxBorder(
    nil,
    0.30*height, 0.15*height, 0.02*height,
    nil, nil,
    'DBG_GREEN',
    TOP_MASK_LEVEL,
    nil,
    txt
)
AddText(
    nil, '左', 'unicode_cn_white',
    {0, 0.8*height}, nil,
    DEFAULT_FONT_SIZE[5],
    nil,
    TOP_MASK_LEVEL,
    l_engRpm_sim
)

-- 右发转速
local r_engRpm_sim = AddSimple(nil, {-0.87674485*width, -0.113475*height}, nil, T_Page_sim)
AddCircle(   nil, 0.441233*height, 0.384183*height, 270, 36, nil, nil, 'DBG_YELLOW',nil, TOP_MASK_LEVEL,  r_engRpm_sim)
AddCircle(   nil, 0.441233*height, 0.384183*height,  30, 36, nil,{90,0}, 'DBG_RED', nil, TOP_MASK_LEVEL,  r_engRpm_sim)
AddSimpleLine(
    nil,
    0.02*height,
    {{0,0.0},{0,0.384183*height}},
    nil, nil,
    'DBG_YELLOW',
    TOP_MASK_LEVEL,
    nil,
    r_engRpm_sim,
    {'R_ENG_RPM'},
    {
        {AnimalControllor.rotateUsingParameter, 0, math.rad(-2.7)}
    }
)
local txt = AddText(
    nil, nil, 'unicode_cn_white',
    {-0.30*height, 0.4*height}, nil,
    DEFAULT_FONT_SIZE[7],
    nil,
    TOP_MASK_LEVEL,
    r_engRpm_sim,
    {'%.1f'},
    {'R_ENG_RPM'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddBoxBorder(
    nil,
    0.30*height, 0.15*height, 0.02*height,
    nil, nil,
    'DBG_GREEN',
    TOP_MASK_LEVEL,
    nil,
    txt
)
AddText(
    nil, '右', 'unicode_cn_white',
    {0, 0.8*height}, nil,
    DEFAULT_FONT_SIZE[5],
    nil,
    TOP_MASK_LEVEL,
    r_engRpm_sim
)

-- 发动机信息区
local infoSimple = AddSimple(nil, {-0.82580565*width, 0}, nil, T_Page_sim)
AddText(
    nil, '左发涡温', 'unicode_cn_white',
    {0, 0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.1f℃'},
    {'L_ENG_TMP'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(
    nil, '右发涡温', 'unicode_cn_white',
    {0, 0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.1f℃'},
    {'R_ENG_TMP'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)

AddText(
    nil, '左发油耗', 'unicode_cn_white',
    {0, -0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.3fKG/S'},
    {'L_ENG_FUEL','UNIT'},
    {
        {AnimalControllor.textUsingParameter, 0},
        {AnimalControllor.parameterInRange, 1, -0.1, 0.1}
    }
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.3fLBS/S'},
    {'L_ENG_FUEL','UNIT'},
    {
        {AnimalControllor.textUsingParameter, 0},
        {AnimalControllor.parameterInRange, 1, 0.9, 1.1}
    }
)

AddText(
    nil, '右发油耗', 'unicode_cn_white',
    {0, -0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.3fKG/S'},
    {'R_ENG_FUEL','UNIT'},
    {
        {AnimalControllor.textUsingParameter, 0},
        {AnimalControllor.parameterInRange, 1, -0.1, 0.1}
    }
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.3fLBS/S'},
    {'R_ENG_FUEL','UNIT'},
    {
        {AnimalControllor.textUsingParameter, 0},
        {AnimalControllor.parameterInRange, 1, 0.9, 1.1}
    }
)

-- 导弹与弹舱数量区
infoSimple = AddSimple(nil, {-0.61974915*width, 0}, nil, T_Page_sim)
AddText(nil, '霹雳-15', 'unicode_cn_white', {0, 0.7*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'PL15_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, '霹雳-17', 'unicode_cn_white', {0, -0.7*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'PL17_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, '霹雳-12', 'unicode_cn_white', {0, 0.2*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'PL12_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, '霹雳-10E', 'unicode_cn_white', {0, -0.2*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'PL10E_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)

infoSimple = AddSimple(nil, {-0.49574915*width, 0}, nil, T_Page_sim)
AddText(nil, '雷电-10', 'unicode_cn_white', {0, 0.7*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'LD10_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, 'GBU-12', 'unicode_cn_white', {0, 0.2*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, 0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'GBU12_COUNT'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, '热诱弹', 'unicode_cn_white', {0, -0.2*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.2*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'FLARE_QTY'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(nil, '箔条', 'unicode_cn_white', {0, -0.7*height}, Align.LC, DEFAULT_FONT_SIZE[6], nil, TOP_MASK_LEVEL, infoSimple)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.08*width, -0.7*height}, Align.LC,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    infoSimple,
    {'%.0f'},
    {'CHAFF_QTY'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
-- TOF区
-- 在“导弹与弹舱数量区”之后，水平排列 6 个 TOF 表盘
do
    local MAX_TOF     	= 150                    -- 刻度上限（秒）
    local ANGLE_PER_S   = 300 / MAX_TOF       -- 每秒对应角度
    local R_o 			= 0.441233 * height     -- 表盘外径
	local R_w			= 0.05705  * height		-- 表盘线径
    local LINE_WIDTH    = 0.02 * height        -- 指针宽度
    local Y_TOF         = -0.113475 * height    -- 与发动机转速同 Y 线
    local X_START       = 0.55 * width    -- 第1 槽 X 起点（左侧）
    local X_STEP        = 0.07 * width     -- 每槽水平间距
	local Ring_color    = 'DBG_YELLOW'     		-- 表盘颜色
	local Ring_h_color	= 'DBG_RED'				-- 表盘高亮区颜色
	local Text_color	= 'unicode_cn_white'	-- 文字颜色
	local Box_color		= 'DBG_GREEN'			-- 框颜色	
	local LVL 			= TOP_MASK_LEVEL

	for i = 1, 6 do
		local x_off = X_START + (i-1) * X_STEP  -- 第1槽最左侧，依次向右排列
		-- 1. 在 Top 页创建一个定位容器容器
		local tofsim = AddSimple(
			nil,
			{x_off, Y_TOF},
			nil,
			T_Page_sim,
			{'HMD_MSL' .. i .. '_REMAIN'},
			{{ AnimalControllor.parameterInRange, 0, 0.099, MAX_TOF*1.35 }}
		)

		-- 2. 绘制外圈和内圈（与 rpmGauge 圆环样式一致）
		AddCircle(nil,R_o, R_o-R_w, 270, 36,	nil, {-30, 0},Ring_color,nil,LVL,	tofsim)
		AddCircle(nil,R_o-R_w, R_o-2*R_w,  30, 36,	nil, {0, 0},Ring_h_color,nil,	LVL, 	tofsim)

		-- 3. TOF 指针：旋转角度根据倒计时百分比改变（假设 MAX_TOF 秒对应一圈）

		AddSimpleLine(
			nil,
			LINE_WIDTH,
			{{0, 0}, {0, R_o}},
			nil, nil,
			'DBG_YELLOW',
            nil,
			LVL,
			tofsim,
			{'HMD_MSL'..i..'_REMAIN'},  -- 自定义的倒计时数值参数
			{
				{
					AnimalControllor.rotateUsingParameter,0,math.rad(-ANGLE_PER_S)  -- 每秒逆时针转一小段
				}
			}
		)

		-- 4. 数字倒计时显示（秒 → mm:ss 格式）
		local tof_text = AddText(
			nil, nil,
			Text_color,
			{-0.30 * height, 0.4 * height},
			nil,
			DEFAULT_FONT_SIZE[7],
			nil,
			LVL,
			tofsim,
			{'%.1f'},	--秒				
			{'HMD_MSL' .. i .. '_REMAIN'},    -- 同上参数
			{
				{ AnimalControllor.textUsingParameter, 0 }
			}
		)

		-- 5. 边框 + 槽位 标签
		AddBoxBorder(
			nil,
			0.30 * height, 0.15 * height, 0.02 * height,
			nil, nil,
			Box_color,
			LVL,
			nil,
			tof_text
		)
		AddText(
			nil, i,
			Text_color,
			{0, 0.8 * height},
			nil,
			DEFAULT_FONT_SIZE[5],
			nil,
			LVL,
			tofsim
		)
	end
end
--[[ TOF 同心表盘
do
    local MAX_TOF     	= 200               	-- 刻度上限（秒）
    local ANGLE_PER_S   = 270 / MAX_TOF     	-- 每秒对应角度
    local R_o 			= 0.44 * height     	-- 表盘外径
	local R_w			= 0.057  * height		-- 表盘线径
    local LINE_WIDTH    = 0.02 * height        	-- 指针宽度
    local Y_TOF         = -0.113475 * height    		--  Y 中心线
	local X_TOF         = 0.94 * width    		--  X 中心线
    local R_START       = 0.44 * height    		-- 第1 槽 X 起点（左侧）
    local R_STEP        = 0.1 * height     		-- 每槽水平间距
	local LINE_color	= 'DBG_BLUE'
	local Ring_color    = 'DBG_YELLOW'     		-- 表盘颜色
	local Ring_h_color	= 'DBG_RED'				-- 表盘高亮区颜色
	local Text_color	= 'unicode_cn_white'	-- 文字颜色
	local Box_color		= 'DBG_GREEN'			-- 框颜色
	local LVL 			= TOP_MASK_LEVEL

	for i = 1, 6 do
		local R_off = R_START + (i-1) * R_STEP  -- 第1槽最内侧，依次向外排列
		-- 1. 在 Top 页创建一个定位容器容器
		local tofsim = AddSimple(nil,{X_TOF, Y_TOF},nil,
			T_Page_sim ,
			{'HMD_MSL' .. i .. '_REMAIN'},
			{{ AnimalControllor.parameterInRange, 0, 0.099, MAX_TOF*1.35 }}
		)

		-- 2. 绘制外圈和内圈（与 rpmGauge 圆环样式一致）
		AddCircle(nil,R_off, R_off-R_w, 270, 36, nil, {-30, 0},	Ring_color,	nil,	LVL,  tofsim)
		AddCircle(nil,R_off, R_off-R_w,  30, 36, nil, {0, 0},	Ring_h_color, nil,	LVL, tofsim)

		-- 3. TOF 指针：旋转角度根据倒计时百分比改变（假设 MAX_TOF 秒对应一圈）
		AddSimpleLine(
			nil,
			LINE_WIDTH,
			{{0, 0}, {0, R_off}},
			nil, nil,
			LINE_color,
			LVL,
			nil,
			tofsim,
			{'HMD_MSL'..i..'_REMAIN'},  -- 自定义的倒计时数值参数
			{
				{ AnimalControllor.rotateUsingParameter,0,math.rad(-ANGLE_PER_S) }  -- 每秒逆时针转一小段
			}
		)

		-- 4. 数字倒计时显示（秒 → mm:ss 格式）
		local tof_text = AddText(
			nil, nil,
			Text_color,
			{-0.30 * height, 0.4 * height},
			nil,
			DEFAULT_FONT_SIZE[7],
			nil,
			LVL,
			tofsim,
			{'%.1f'},	--秒				
			{'HMD_MSL' .. i .. '_REMAIN'},    -- 同上参数
			{
				{ AnimalControllor.textUsingParameter, 0 }
			}
		)

		-- 5. 边框 + 槽位 标签
		AddBoxBorder(
			nil,
			0.30 * height, 0.15 * height, 0.02 * height,
			nil, nil,
			Box_color,
			LVL,
			nil,
			tof_text
		)
		AddText(
			nil, i,
			Text_color,
			{0, 0.8 * height},
			nil,
			DEFAULT_FONT_SIZE[5],
			nil,
			LVL,
			tofsim
		)
	end
end]]

-- 警告区
local txt = AddText(
    nil, '主警告', 'unicode_cn_white',
    {0, 0.4*height}, nil,
    DEFAULT_FONT_SIZE[4],
    nil,
    TOP_MASK_LEVEL,
    T_Page_sim,
    nil,
    {'MASTER_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)
AddBoxBorder(
    nil,
    0.05*width, 0.3*height, 0.05*height,
    nil, nil,
    'DBG_GREEN',
    TOP_MASK_LEVEL,
    nil,
    txt,
    {'MASTER_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)

local txt = AddText(
    nil, '飞控警告', 'unicode_cn_white',
    {-0.075*width, -0.4*height}, nil,
    DEFAULT_FONT_SIZE[5],
    nil,
    TOP_MASK_LEVEL,
    T_Page_sim,
    nil,
    {'FCS_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)
AddBoxBorder(
    nil,
    0.05*width, 0.3*height, 0.05*height,
    nil, nil,
    'DBG_GREEN',
    TOP_MASK_LEVEL,
    nil,
    txt,
    {'FCS_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)

local txt = AddText(
    nil, '火灾警告', 'unicode_cn_white',
    {0.075*width, -0.4*height}, nil,
    DEFAULT_FONT_SIZE[5],
    nil,
    TOP_MASK_LEVEL,
    T_Page_sim,
    nil,
    {'FCS_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)
AddBoxBorder(
    nil,
    0.05*width, 0.3*height, 0.05*height,
    nil, nil,
    'DBG_GREEN',
    TOP_MASK_LEVEL,
    nil,
    txt,
    {'FCS_CAU'},
    {
        {AnimalControllor.changeColorWhenParameterEqualToNumber, 0, 1, 1, 0, 0}
    }
)

-- 通信频率区
local commSimple = AddSimple(nil, {0.35*width, 0}, nil, T_Page_sim)
AddText(
    nil, '电台1', 'unicode_cn_white',
    {-0.05*width, 0}, nil,
    DEFAULT_FONT_SIZE[3],
    nil,
    TOP_MASK_LEVEL,
    commSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {-0.05*width, 0.5*height}, nil,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    commSimple,
    {'%.3f'},
    {'COMM1_FREQ'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(
    nil, nil, 'unicode_cn_white',
    {-0.05*width, -0.5*height}, nil,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    commSimple,
    {'%.3f'},
    {'COMM1_PRE_FREQ'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)

AddText(
    nil, '电台2', 'unicode_cn_white',
    {0.05*width, 0}, nil,
    DEFAULT_FONT_SIZE[3],
    nil,
    TOP_MASK_LEVEL,
    commSimple
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.05*width, 0.5*height}, nil,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    commSimple,
    {'%.3f'},
    {'COMM2_FREQ'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)
AddText(
    nil, nil, 'unicode_cn_white',
    {0.05*width, -0.5*height}, nil,
    DEFAULT_FONT_SIZE[6],
    nil,
    TOP_MASK_LEVEL,
    commSimple,
    {'%.3f'},
    {'COMM2_PRE_FREQ'},
    {
        {AnimalControllor.textUsingParameter, 0}
    }
)