
local radarMaskLevel = DEFAULT_MASK_LEVEL
local radarW = width*0.9
local radarH = height*0.7
AddBox(nil,width,radarH,{0,0.15*height},nil,'DBG_RED',radarMaskLevel,REWRITE_LEVEL,B_Page_radar_sim,nil,nil,true)
local radarSimple = AddSimple(nil,{0,0.15*height},nil,B_Page_radar_sim,{'SCAN_ZONE_ORIGIN_ELEVATION'},{
    {AnimalControllor.moveUpDownUsingParameter,0,-0.033}
})
local elevationCreated = false
for x = -1, 1, 0.5 do
    for y = -2, 2, 0.5 do
        AddSimpleLine(nil,0.02*radarH,{{-radarW,0},{radarW,0}},{0,y*radarH},nil,'LIGHT_BLUE',nil,radarMaskLevel,radarSimple)
        AddSimpleLine(nil,0.02*radarH,{{0,-2*radarH},{0,2*radarH}},{x*radarW,0},nil,'LIGHT_BLUE',nil,radarMaskLevel,radarSimple)
        if not elevationCreated then
            local align
            if y<0 then
                align = Align.LB
            elseif y>0 then
                align = Align.LT
            else
                align = Align.LC
            end
            AddText(nil,tostring(math.abs(y*30)),'radar_ui_font_lgBlue',{radarW,y*radarH},align,DEFAULT_FONT_SIZE[7],nil,radarMaskLevel,radarSimple)
        end
    end
    if not elevationCreated then
        elevationCreated = true
    end
    AddText(nil,tostring((x+1)*20/8),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,4.9,5.1},
    })
    AddText(nil,tostring((x+1)*20/4),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,9.9,10.1},
    })
    AddText(nil,tostring((x+1)*20/2),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,19.9,20.1},
    })
    AddText(nil,tostring((x+1)*20),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,39.9,40.1},
    })
    AddText(nil,tostring((x+1)*20*2),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,79.9,80.1},
    })
    AddText(nil,tostring((x+1)*20*4),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,159.9,160.1},
    })
    AddText(nil,tostring((x+1)*20*8),'unicode_cn_lg_blue',{x*radarW,-0.55*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,nil,B_Page_radar_sim,nil,{'MAX_RANGE'},{
        {AnimalControllor.parameterInRange,0,319.9,320.1},
    })
end

local scan = AddBox(nil,radarW,radarH,{0,0.15*height},nil,'DBG_RED',radarMaskLevel,INCREASE_IF_LEVEL,B_Page_radar_sim,nil,nil,true)

radarMaskLevel = radarMaskLevel + 1
local scanElSimple = AddSimple(nil,nil,nil,scan,{'SCAN_ZONE_ORIGIN_ELEVATION'},{
    {AnimalControllor.moveUpDownUsingParameter,0,-0.033}
})
local maxScanAngle = math.deg(math.atan((radarH*2)/(radarW*2)))*2
local scanZoneAngle = math.deg(math.atan(radarH/(radarW*2)))*2
local currentScanAngle = math.deg(math.atan((radarH*0.5)/(radarW*2)))

local elMaxScanSector = AddCircle(nil,2.1*radarW,0,maxScanAngle,36,{-radarW,0},{-(90-maxScanAngle*0.5),0},'RADAR_SCAN_MAX',nil,radarMaskLevel,scanElSimple)
local scanZoneEl = AddCircle(nil,2.1*radarW,0,scanZoneAngle,36,nil,{-(maxScanAngle-scanZoneAngle)*0.5,0},'RADAR_SCAN',nil,radarMaskLevel,elMaxScanSector,
	{'SCAN_ZONE_ORIGIN_ELEVATION_BP5'},{
    {AnimalControllor.rotateUsingParameter,0,1}
})

local lr_scale
if not BackUpIndicator then
    lr_scale 	= 0.00001144*radarW
else
    lr_scale 	= 0.00000255*radarW
end

IGNORE_BRT = true--使用自定义的透明度控制
for i = 1, Targetnum, 1 do
    AddCircle(nil,0.04*height,0,360,18,{-radarW,0},nil,'DBG_WHITE',nil,radarMaskLevel,scanElSimple,
    {
		string.format('RADAR_CONTACT_%02d_ELEVATION',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME_SCALE',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_IN_SC_LIMIT', i),
    },
    {
		--{"move_up_down_using_parameter"		,0,1.0},
        {AnimalControllor.rotateUsingParameter		,0,math.rad(scanZoneAngle)/math.rad(60)},
        {AnimalControllor.moveLeftRightUsingParameter	,2,lr_scale},
		{AnimalControllor.parameterInRange		,1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange		,2,5000,40000},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,4,-1,1,1,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,0,1,0,0},
		{AnimalControllor.changeColorWhenParameterEqualToNumber,4,1,0,1,0},
        { AnimalControllor.parameterInRange,                 5,0.01,10000},
        { AnimalControllor.parameterCompareWithNumber,       6,1},
    })
end
IGNORE_BRT = false--取消自定义透明度控制

AddCircle(nil,0.04*height,0,360,18,{-radarW,0},nil,'DBG_WHITE',nil,radarMaskLevel,scanElSimple,
{
	'RADAR_STT_ELEVATION',
    'RADAR_STT_RANGE_SCALE',
    'RADAR_STT_FRIENDLY',
    'RADAR_MODE',
},
{
    {AnimalControllor.rotateUsingParameter,0,math.rad(scanZoneAngle)/math.rad(60)},
    {AnimalControllor.moveLeftRightUsingParameter	,1,lr_scale},
    {AnimalControllor.changeColorWhenParameterEqualToNumber,2,-1,1,1,0},
	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,0,1,0,0},
	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,0,1,0},
    {AnimalControllor.parameterInRange,3,2.9,3.1}
})

AddCircle(nil,2.1*radarW,0,currentScanAngle,18,nil,{-(scanZoneAngle-currentScanAngle)*0.5,0},'RADAR_SCANNING',nil,radarMaskLevel,scanZoneEl,
	{'SCAN_BEAM_ELEVATION','RADAR_MODE'},{
    {AnimalControllor.rotateUsingParameter,0,math.rad(currentScanAngle/15)},
    {AnimalControllor.parameterInRange,1,0.9,1.1}
})
--[[
-------雷达随动
local beam_x_scale = radarW * 0.5 -- 根据实际页面比例调整
local beam_y_scale = radarH * 0.5

AddCircle(nil, 0.05*radarW, 0, 360, 24, nil, nil, 'DBG_YELLOW', nil, radarMaskLevel, radarSimple,
    {
        'SCAN_ZONE_ORIGIN_ELEVATION_BP5',
        'SCAN_ZONE_ORIGIN_AZIMUTH_BP5',
        'RADAR_WORK_MODE'
    },
    {
        {AnimalControllor.moveUpDownUsingParameter, 0, beam_y_scale},
        {AnimalControllor.moveLeftRightUsingParameter, 1, beam_x_scale},
        {AnimalControllor.parameterInRange, 2, 1.9, 3.1}
    }
)]]