SUB_PAGE_VAL        = SubPageVal
local ud_scale
local lr_scale
local deg_lr_scale
if not BackUpIndicator then
    ud_scale = 0.00000282 * 0.8
    lr_scale = 0.23 * 0.8 * width
	deg_lr_scale = 0.8 * width/240
else
    ud_scale = 0.000002535 * 0.8
    lr_scale = 0.05125 * 0.8 * width
end


--功能：绘制雷达显示区的网格和刻度，便于飞行员判读目标方位和距离。-------------------
local length        = 0.8 * width

for i = -2, 2 do
    AddSimpleLine(nil, 0.003 * width, { { 0, length }, { 0, -length } }, { 0.4 * i * width, 0 }, nil, 'DBG_GREEN', nil, nil, Page2_sim)
    AddSimpleLine(nil, 0.003 * width, { { length, 0 }, { -length, 0 } }, { 0, 0.4 * i * width }, nil, 'DBG_GREEN', nil, nil, Page2_sim)
    AddText(nil, tostring(math.abs(i * 30)), 'radar_ui_font', { i * 0.4 * width, -0.9 * height }, nil, DEFAULT_FONT_SIZE[5], nil, nil, Page2_sim)
end
--功能：在页面右上角显示当前雷达最大搜索距离。
AddText(nil, nil, 'radar_ui_font', { 0.9 * width, 0.9 * height }, nil, DEFAULT_FONT_SIZE[5], nil, nil, Page2_sim,
    { '%.0f' }, { 'MAX_RANGE' },
    {
        { AnimalControllor.textUsingParameter, 0 }
    }
)


local localSimle = AddSimple(nil, { 0, -0.8 * width }, nil, Page2_sim)

IGNORE_BRT = true--使用自定义的透明度控制
--目标显示
for i = 1, Targetnum do
    AddSimpleLine(nil, 0.025 * width, { { -0.06 * width, 0 }, { 0.06 * width, 0 } }, nil, nil, 'DBG_GREEN', nil, nil,
        localSimle, {
            string.format('RADAR_CONTACT_%02d_ELEVATION', i), --0
            string.format('RADAR_CONTACT_%02d_AZIMUTH', i), --1
            string.format('RADAR_CONTACT_%02d_RANGE_SCALE', i), --2
            string.format('RADAR_CONTACT_%02d_TIME_SCALE', i), --3
            string.format('RADAR_CONTACT_%02d_FRIENDLY', i), --4
            string.format('RADAR_CONTACT_%02d_RCS', i), --5
            string.format('RADAR_CONTACT_%02d_IN_SC_LIMIT', i), --6
            "UNIT" --7
        }, {
            { AnimalControllor.moveLeftRightUsingParameter,             1, lr_scale },
            { AnimalControllor.moveUpDownUsingParameter,                2, ud_scale },
            { AnimalControllor.parameterInRange,                        1, -math.rad(60), math.rad(60) },
            { AnimalControllor.parameterInRange,                        2, 500, 40000 },
            { AnimalControllor.opacityUsingParameter,                   3 },
            { AnimalControllor.changeColorWhenParameterEqualToNumber,   4, -1, 1, 1, 0 }, --未知显示黄色
            { AnimalControllor.changeColorWhenParameterEqualToNumber,   4,  0, 1, 0, 0 }, --敌方显示红色
            { AnimalControllor.changeColorWhenParameterEqualToNumber,   4,  1, 0, 1, 0 }, --友方显示绿色
        --  { AnimalControllor.parameterInRange,                        5,0.0001,10000},
            { AnimalControllor.parameterCompareWithNumber,              6,1},
        --  { AnimalControllor.parameterCompareWithNumber,              7,0},
        }
    )
end
IGNORE_BRT = false--取消自定义透明度控制
--TDC光标显示
local x_size = 0.04 * width
local y_size = 0.05 * height
local TDC_cursor = AddMultiLine(nil, 1.5, nil, { { -x_size, -y_size }, { -x_size, y_size }, { x_size, -y_size }, { x_size, y_size } },
    { 0, 1, 2, 3 }, { 0, 0 }, nil, 'DBG_YELLOW', Align.CC, nil, nil, localSimle,
    {
        "RADAR_TDC_RANGE_SCALE",
        "RADAR_TDC_AZIMUTH_RANGE",
        "RADAR_TDC_AZIMUTH",
        "RADAR_MODE",
    },
    {
        { AnimalControllor.moveUpDownUsingParameter,    0, ud_scale },
        { AnimalControllor.moveLeftRightUsingParameter, 2, lr_scale },
        { AnimalControllor.parameterInRange,            3, -0.1,    2.1 },
    }
)
--功能：显示当前雷达波束的方位线，实时反映波束中心的变化（如随头盔、STT目标等）
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, Page2_sim,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 0}
	}
)
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, Page2_sim,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 1}
	}
)
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, Page2_sim,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 4}
	}
)
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, Page2_sim,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 5}
	}
)
local BVRbox=AddBox(nil,0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 0, 0, 255, 64 }),nil,nil,Page2_sim,
	{ 'SCAN_ZONE_ORIGIN_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 0}
	}
)

local WACQbox=AddBox(nil,5/60*0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 255, 0, 0, 64 }),nil,nil,Page2_sim,
	{ 'HSI_ACM_ZONE',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, deg_lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 1}
	}
)
local BSTLbox=AddBox(nil,2.5/60*0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 255, 0, 0, 64 }),nil,nil,Page2_sim,
	{ 'HSI_ACM_ZONE',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, deg_lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 2}
	}
)
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, BSTLbox,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 2}
	}
)
local BSTSbox=AddBox(nil,1/60*0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 255, 0, 0, 64 }),nil,nil,Page2_sim,
	{ 'HSI_ACM_ZONE',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, deg_lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 3}
	}
)
AddSimpleLine(nil, 0.01 * width,
    { { 0, 0.8 * height }, { 0, -0.8 * height } },
    nil, nil, 'DBG_YELLOW', nil, nil, BSTSbox,
    { 'SCAN_BEAM_AZIMUTH',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 3}
	}
)
local VACQbox=AddBox(nil,4/60*0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 255, 0, 0, 64 }),nil,nil,Page2_sim,
	{ 'HSI_ACM_ZONE',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, deg_lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 4}
	}
)
local HACQbox=AddBox(nil,0.8*width,0.8*height,nil,nil,MakeMaterial(nil, { 255, 0, 0, 64 }),nil,nil,Page2_sim,
	{ 'HSI_ACM_ZONE',"RADAR_MODE","RADAR_WORK_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, deg_lr_scale },
		{ AnimalControllor.parameterInRange,            1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,  2, 5}
	}
)
--功能：在STT（单目标跟踪）模式下，显示锁定目标的方位、俯仰、距离，
--并根据友军/敌军状态变色。
local radar_STT = AddBox(nil, 0.03 * width, 0.03 * height, nil, nil, 'DBG_GREEN', nil, nil, localSimle,
    {
        "RADAR_STT_RANGE_SCALE",
        "RADAR_STT_AZIMUTH",
        "RADAR_STT_ELEVATION",
        "RADAR_MODE",
        "RADAR_STT_FRIENDLY"
    },
    {
        { AnimalControllor.moveUpDownUsingParameter,              0, ud_scale },
		{ AnimalControllor.moveLeftRightUsingParameter,           1, lr_scale },
        { AnimalControllor.parameterInRange,                      3,  2.9, 3.1 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4, -1,   1,  1, 0 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4,  0,   1,  0, 0 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4,  1,   0,  1, 0 },
    }
)
--功能：在STT模式下，显示锁定目标的十字光标，便于快速识别。
AddCrossHair(nil, 0.09 * width, 0.09 * height, 0.005 * width, nil, nil, 'DBG_GREEN', nil, nil, localSimle,
    {
        "RADAR_STT_RANGE_SCALE",
        "RADAR_STT_AZIMUTH",
        "RADAR_STT_ELEVATION",
        "RADAR_MODE",
		"RADAR_STT_FRIENDLY"
    },
    {
        { "move_up_down_using_parameter",    0, ud_scale },
		{ "move_left_right_using_parameter", 1, lr_scale },
        { "parameter_in_range",              3, 2.9, 3.1 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4, -1,   1,  1, 0 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4,  0,   1,  0, 0 },
        { AnimalControllor.changeColorWhenParameterEqualToNumber, 4,  1,   0,  1, 0 },
    }
)
--功能：在STT模式下，显示锁定目标的波束。
AddBox(nil, 5/60*0.8 * width, 0.8*height, nil, nil, MakeMaterial(nil, { 255, 0, 0, 64 }), nil, nil, Page2_sim,
    { 'RADAR_STT_AZIMUTH', "RADAR_MODE" },
    {
		{ AnimalControllor.moveLeftRightUsingParameter, 0, lr_scale },
		{ AnimalControllor.parameterInRange,	1, 2.9, 3.1 },
	}
)
AddText(nil,nil,'unicode_cn_red',{0,0},Align.CT,DEFAULT_FONT_SIZE[3],nil,nil,radar_STT,
    {'%s'},{
        "TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        {AnimalControllor.parameterInRange,		1,0.9,1.1}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,0},Align.CB,DEFAULT_FONT_SIZE[3],nil,nil,radar_STT,
    {'%.2fNM'},{
        "TARGET_RANGE_NM",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        {AnimalControllor.parameterInRange,		1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,	2,1}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,0},Align.CB,DEFAULT_FONT_SIZE[3],nil,nil,radar_STT,
    {'%.2fKM'},{
        "TARGET_RANGE",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        {AnimalControllor.parameterInRange,		1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,	2,0}
    }
)