dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local Nav_Level         = DEFAULT_LEVEL + 2
local Nav_Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 2

AddBox(nil,3*Width,3*Height,nil,nil,'DBG_RED',Nav_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,3*Width,3*Height,nil,nil,'DBG_CLEAR',Nav_Noclip_Level,INCREASE_IF_LEVEL)

IS_HUD = true
local base_simple = AddSimple()

--位置常驻信息类
--左上角
--全程最大过载显示
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,1.05*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'GM:%.0f'},{'MAX_G'},{{'text_using_parameter',0}})
--过载
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,0.85*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'G:%.1f'},{'OVER_G'},{{'text_using_parameter',0}})
--攻角
AddText(nil,nil,'unicode_cn_green',{-0.95*Width,0.75*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,{'攻角:%.1f','%s'},{'AOA_DEG'},{{'text_using_parameter',0}})
--左下角
--右上角
--显示最大Range
AddText(nil,nil,'unicode_cn_green',{0.8*Width,0.95*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'MAX:%.0f'},
	{'MAX_RANGE','ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter, 			0 },
        {AnimalControllor.parameterCompareWithNumber,	1,1 },
    	{AnimalControllor.parameterCompareWithNumber,	2,0 }
	}
)
--右下角
--右下航点显示第一行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.75*Height},Align.LC,DEFAULT_FONT_SIZE[5],nil,Nav_Level,base_simple,
    {'%s'},
    {
        'TARGET_NAME',
        'NAV_MODE',
		'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,			0},
        {AnimalControllor.parameterCompareWithNumber,	1,1},
		{AnimalControllor.parameterCompareWithNumber,	2,0}
    }
)
--右下航点显示第二行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.85*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
    {
        'TARGET_ETA_HH',
        'TARGET_ETA_mm',
        'TARGET_ETA_ss',
        'TARGET_ETA_dd',
        'NAV_MODE',
		'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.textUsingParameter,2,2},
        {AnimalControllor.textUsingParameter,3,3},
        {AnimalControllor.parameterCompareWithNumber,4,1},
		{AnimalControllor.parameterCompareWithNumber,5,0}
    }
)
--右下航点显示第三行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.95*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,
    {'导航模式:%s'},
    {
        'NAV_TYPE',
        'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterCompareWithNumber,1,0}
    }
)
-----------------------------------------------------------------
--中间的Pullup 告警
AddCrossHair(nil,0.5*Width,0.5*Width,0.006*Width,nil,{45,0},'DBG_YELLOW',nil,Nav_Level,base_simple,{'PULLUP_FLASH'},{{'parameter_in_range',0,0,1.1}})
-----------------------------------------------------------------
--武器相关
--STT
local x_scale = 1
local y_scale = 1
local boxa=0.2*Width
local boxt=0.01*Width
local stt_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_RED',Nav_Level,nil,base_simple,
	{
		'TARGET_BOX_DIS_ENABLE',
		'HMD_TARGET_BOX_Y',
		'HMD_TARGET_BOX_X',
		'HEAD_AZ'
	},
	{
		{AnimalControllor.parameterInRange,				0,0.9,1.1},
		{AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
		{AnimalControllor.moveLeftRightUsingParameter,	2,x_scale},
		{AnimalControllor.parameterInRange,				3,-60,60} -- 头向范围
	}
)
local stt_circle=AddCircle(nil,boxa,boxa-boxt,360,16,nil,nil,'DBG_RED',nil,Nav_Level,stt_box)
--STT连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
    {
		'TARGET_BOX_DIS_ENABLE',
		'HMD_TARGET_BOX_X',
		'HMD_TARGET_BOX_Y',
		'HMD_TARGET_BOX_X_2',
		'HMD_TARGET_BOX_Y_2',
		'HEAD_AZ'
	},
    {
        {AnimalControllor.parameterInRange,0,0.5,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale},
		{AnimalControllor.parameterInRange,				5,-60,60} -- 头向范围
    }
)
---------------------------------------------------------------------
-- 辅助函数：CreateTargetRangeText
-- 用于创建显示目标距离的文本元素。
-- 参数说明：
--   pos           - 显示位置（数组形式，例如 {-boxa, 0} 或 {0.65*Width, 0}）
--   parent        - 父元素（例如 stt_box 或 base_simple ）
--   fmtStr        - 格式化字符串（例如 '%.2fKM' 或 '%.2fNM'）
--   rangeParam    - 目标距离参数名称（例如 "TARGET_RANGE" 或 "TARGET_RANGE_NM"）
--   mappingRange2 - 对应第三个参数的区间设置（数组形式，例如 {-0.1, 0.1} 对 KM，{0.9, 1.1} 对 NM）
---------------------------------------------------------------------

local function CreateTargetRangeText(pos, parent, fmtStr, rangeParam, unit_value)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_red',   -- material
        pos,                -- 显示位置
        Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[1],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Nav_Level,          -- 层级（注意 Nav_Level 大小写）
        parent,             -- 父元素
        { fmtStr,' %s' },         -- 格式化输出数组（仅一项）
        {
            rangeParam,            	-- 第0项：目标距离（KM 或 NM）
			'TARGET_NCTR', 			-- 第1项：目标 NCTR
            'TARGET_BOX_DIS_ENABLE',-- 第2项
            'UNIT'                  -- 第3项
        },
        {
            {AnimalControllor.textUsingParameter,  	0,0},
			--{AnimalControllor.textUsingParameter,	1,1},
            {AnimalControllor.parameterCompareWithNumber, 2, 1},
            {AnimalControllor.parameterCompareWithNumber, 3, unit_value}
        }
    )
end


--另一种写法
--[[local function CreateTargetRangeText1(pos, parent, fmtStr, rangeParam, mappingRange2)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_red',   -- material
        pos,                -- 显示位置
        Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[1],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Nav_Level,          -- 层级（注意 Nav_Level 大小写）
        parent,             -- 父元素
        { fmtStr,' %s' },         -- 格式化输出数组（仅一项）
        {
            rangeParam,            	-- 第0项：目标距离（KM 或 NM）
			'TARGET_NCTR', 			-- 第1项：目标 NCTR
            'TARGET_BOX_DIS_ENABLE',-- 第2项
            'UNIT'                  -- 第3项
        },
        {
            {AnimalControllor.textUsingParameter,  	0,0},
			{AnimalControllor.textUsingParameter,	1,1},
            {AnimalControllor.parameterCompareWithNumber, 2, 1},
            {AnimalControllor.parameterInRange, 3, mappingRange2[1], mappingRange2[2]}
        }
    )
end]]
---------------------------------------------------------------------
-- 调用示例
-- 父元素为 stt_box
---------------------------------------------------------------------
CreateTargetRangeText({0,0.1*boxa}, stt_box, '%.2f', "TARGET_RANGE", 0)
CreateTargetRangeText({0,0.1*boxa}, stt_box, '%.2f', "TARGET_RANGE_NM", 1)
CreateTargetRangeText({0,1.4*boxa}, stt_box, '%s', 'TARGET_NCTR',0)
CreateTargetRangeText({0,1.4*boxa}, stt_box, '%s', 'TARGET_NCTR',1)
--CreateTargetRangeText1({0,boxa}, stt_box, '%.2fKM', "TARGET_RANGE", 	{-0.1, 0.1})
--CreateTargetRangeText1({0,boxa}, stt_box, '%.2fNM', "TARGET_RANGE_NM", {0.9, 1.1})
---------------------------------------------------------------------
-- 右侧区域，父元素为 base_simple
---------------------------------------------------------------------
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fKM', "TARGET_RANGE", 0)
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fNM', "TARGET_RANGE_NM", 1)
--CreateTargetRangeText1({0, -0.4*Height}, base_simple, '%.2fKM', "TARGET_RANGE", 	{-0.1, 0.1})
--CreateTargetRangeText1({0, -0.4*Height}, base_simple, '%.2fNM', "TARGET_RANGE_NM", {0.9, 1.1})


-- 计算 DLZ 点或叉的显示
-- 先算出半宽半高
local scale = boxa * 0.09
local W = boxa * 0.5
local H = boxa * 0.5
local Pad = boxt*2

-- 显示各阶段数据 父元素为 stt_box
local function CreateDLZRangeText(pos, parent,fmtStr, rangeParam, unit_value)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_blue',   -- material
        pos,                -- 显示位置
        Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[4],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Nav_Level,          -- 层级（注意 Nav_Level 大小写）
        parent,             -- 父元素
        { fmtStr },         -- 格式化输出数组（仅一项）
        { rangeParam ,'UNIT' },           	-- 第0项：目标距离（KM 或 NM）            
        { {AnimalControllor.textUsingParameter, 0},{AnimalControllor.parameterCompareWithNumber, 1, unit_value} }
    )
end

CreateDLZRangeText({ 1.0*boxa,1.05*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_KM",0) 		--右上角 武器最大射程KM
CreateDLZRangeText({-1.2*boxa,1.05*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_DYN",0) 		--左上角 动态最大射程KM
CreateDLZRangeText({   0*boxa,-0.3*boxa}, stt_box, '%.0f', "WS_DLZ_MARGIN_DYN",0)	--左上角 动态拦截余量KM
CreateDLZRangeText({-1.2*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_BEST_DYN",0) 	--左下角 动态最佳射程KM
CreateDLZRangeText({ 1.4*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MIN_DYN",0)		--右下角 动态最小射程KM
CreateDLZRangeText({ 1.4*boxa, 0.8*boxa}, stt_box, '%.1f', "WS_DLZ_MIN_KM",0)		--右上角 武器最小射程KM

CreateDLZRangeText({ 1.0*boxa,1.05*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_NM",1) 		--右上角 武器最大射程NM
CreateDLZRangeText({-1.2*boxa,1.05*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_DYN_NM",1) 	--左上角 动态最大射程NM
CreateDLZRangeText({   0*boxa,-0.3*boxa}, stt_box, '%.0f', "WS_DLZ_MARGIN_DYN_NM",1)--左上角 动态拦截余量NM
CreateDLZRangeText({-1.2*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_BEST_DYN_NM",1) 	--左下角 动态最佳射程NM
CreateDLZRangeText({ 1.4*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MIN_DYN_NM",1)	--右下角 动态最小射程NM
CreateDLZRangeText({ 1.4*boxa, 0.8*boxa}, stt_box, '%.1f', "WS_DLZ_MIN_NM",1)		--右上角 武器最小射程NM
--------------------------------------------------------------------------------
-- 1) “点”元素：黄点
--------------------------------------------------------------------------------
local dlz_dot = AddCircle(
    nil,                -- name
    Pad,           		-- radius_outer
    0,                  -- radius_inner
    360, 16,            -- arc, sides
    nil, nil,           -- pos, rot（由 controllers 推动）
    "DBG_RED",       -- material
    h_clip_relations.COMPARE,
    Nav_Level,
    stt_box,        -- 父节点
    {
        "WS_DLZ_SHOW_X",   -- [0] 控制显示：0=点可见
        "WS_DLZ_DOT_Y",    -- [1] Y 偏移
        "WS_DLZ_DOT_X"     -- [2] X 偏移
    },
    {
        { AnimalControllor.parameterCompareWithNumber, 0, 0 },  -- WS_DLZ_SHOW_X==0 时显示
        { AnimalControllor.moveUpDownUsingParameter,    1, scale },  -- 用第1个句柄做垂直位移
        { AnimalControllor.moveLeftRightUsingParameter, 2, scale }   -- 用第2个句柄做水平位移
    }
)

--------------------------------------------------------------------------------
-- 2) “叉”元素：红叉
--------------------------------------------------------------------------------
local dlz_cross = AddCrossHair(
    nil,              -- name
    boxa, boxa, boxt,       -- width, height, thickness
    nil, {45,0},         -- pos, rot
    "DBG_RED",        -- material
    h_clip_relations.COMPARE,
    Nav_Level,
    stt_circle,      -- 父节点
    { "WS_DLZ_SHOW_X" },                              -- [0] 控制显示：1=叉可见
    { { AnimalControllor.parameterCompareWithNumber, 0, 1 } }
)
-- TOF区
-- TOF 同心表盘
do
    local MAX_TOF     	= 150               	-- 刻度上限（秒）
    local ANGLE_PER_S   = 300 / MAX_TOF     	-- 每秒对应角度    
	local R_w			= 0.05 * Width			-- 表盘线径
    local LINE_WIDTH    = 0.005 * Width       	-- 指针宽度
    local Y_TOF         = -1*Height    		--  Y 中心线
	local X_TOF         = 0 *Width   		--  X 中心线
    local R_START       = 1 * boxa    		-- 第1 槽 X 起点（左侧）
    local R_STEP        = 0.075 * Height     	-- 每槽间距
	local LINE_color	= 'DBG_YELLOW'
	local Ring_color    = 'DBG_GREEN'     		-- 表盘颜色
	local Ring_h_color	= 'DBG_RED'				-- 表盘高亮区颜色
	local Text_color	= 'hud_font_base'	-- 文字颜色
	local LVL 			= Nav_Level
    local Parent_item   = base_simple
	for i = 1, 6 do
		local R_off = R_START + (i-1) * R_STEP  -- 第1槽最内侧，依次向外排列
		-- 1. 在 Top 页创建一个定位容器容器
		local tofsim = AddSimple(nil,{X_TOF,Y_TOF},nil,
			Parent_item,
			{'HMD_MSL' .. i .. '_REMAIN'},
			{{ AnimalControllor.parameterInRange, 0, 0.099, MAX_TOF*1.2 }}
		)

		-- 2. 绘制外圈和内圈（与 rpmGauge 圆环样式一致）
		AddCircle(nil,R_off, R_off-R_w, 270, 36, nil, {-30, 0},	Ring_color,	h_clip_relations.COMPARE,	LVL, tofsim)
		AddCircle(nil,R_off, R_off-R_w,  30, 36, nil, {0, 0},	Ring_h_color,h_clip_relations.COMPARE,	LVL, tofsim)

		-- 3. TOF 指针：旋转角度根据倒计时百分比改变（假设 MAX_TOF 秒对应一圈）
		AddSimpleLine(
			nil,
			LINE_WIDTH,
			{{0, 0}, {0, R_off}},
			nil, nil,
			LINE_color,
            h_clip_relations.COMPARE,
			LVL,
			tofsim,
			{'HMD_MSL'..i..'_REMAIN'},  -- 自定义的倒计时数值参数
			{
				{ AnimalControllor.rotateUsingParameter,0,math.rad(-ANGLE_PER_S) }  -- 每秒逆时针转一小段
			}
		)

		-- 4. 数字倒计时显示（秒 ）
		local tof_text = AddText(
			nil, nil,
			Text_color,
			{-0* boxa, R_off-R_w/2},
			Align.RC,
			DEFAULT_FONT_SIZE[3],
			h_clip_relations.COMPARE,
			LVL,
			tofsim,
			{'%.1f'},	--秒				
			{'HMD_MSL' .. i .. '_REMAIN'},    -- 同上参数
			{
				{ AnimalControllor.textUsingParameter, 0 }
			}
		)
	end
end


--IR弹
AddCircle(nil,0.3*Width,0.29*Width,360,72,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
	{'IR_SEEK_RANGE_DIS'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1}
    }
)
AddCircle(nil,0.15*Width,0.14*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
    {
        'HMD_TARGET_ROUND_DIS_ENABLE',
        'HMD_TARGET_ROUND_Y',
        'HMD_TARGET_ROUND_X'
    },
    {
    	{AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale}
    }
)
AddCrossHair(nil,0.35*Width,0.35*Height,0.01*Width,nil,{45,0},'DBG_YELLOW',nil,Nav_Level,base_simple,
    {'IR_SEEK_RANGE_DIS','IR_SEEK_LIMIT'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.parameterCompareWithNumber,	1,1}
    }
)
--武器信息
AddText(nil,nil,'unicode_cn_green',{0 , -0.5*Height},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'%s X ','%.0f'},
    {
		'WEAPON_NAME',
		'WEAPON_COUNT',
		'WEAPON_NAME_DIS',
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,			0,0},
        {AnimalControllor.textUsingParameter,			1,1},
        {AnimalControllor.parameterInRange,				2,0.5,1.1},
		{AnimalControllor.parameterInRange,				3,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,	4,0}
    }
)
AddText(nil,'SAFE','unicode_cn_red',{0*Width,-0.85*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,nil,
	{
		'MASTER_MODE',"HELMET_IN_HUD"
	},{
        { AnimalControllor.parameterCompareWithNumber, 	0,0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{0 , -0.5*Height},nil,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,
    {'%s X ','%.0f'},
    {
		'GUN_NAME',
		'GUN_COUNT',
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,			0,0},
        {AnimalControllor.textUsingParameter,			1,1},
		{AnimalControllor.parameterInRange,				2,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1}
    }
)
--目标航路点
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,0}})
local targetWpt = AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,targetWpt_sim,
	{'NAV_MODE','HMD_TARGET_WPT_EL','HMD_TARGET_WPT_AZ','ATK_MODE'},
	{
		{AnimalControllor.parameterCompareWithNumber,	0,1},
		{AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
		{AnimalControllor.moveLeftRightUsingParameter,	2,x_scale},
		{AnimalControllor.parameterCompareWithNumber,	3,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{0.07*Width,-0.07*Height},Align.LT,DEFAULT_FONT_SIZE[3],nil,Nav_Level,targetWpt,
	{'%s'},
	{'TARGET_WPT_RANGE','NAV_MODE','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,1},
		{ AnimalControllor.parameterCompareWithNumber,	2,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{-0.07*Width,-0.07*Height},Align.RT,DEFAULT_FONT_SIZE[3],nil,Nav_Level,targetWpt,
	{'%s'},
	{'TARGET_NAME','NAV_MODE','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,1},
		{ AnimalControllor.parameterCompareWithNumber,	2,0}
	}
)
--STT文字
AddText(nil,'STT','unicode_cn_red',{0*Width,0.15*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
        { AnimalControllor.parameterCompareWithNumber, 	1,3},
		{ AnimalControllor.parameterCompareWithNumber,	2,1}
	}
)
--孔径
local apertureRadius = math.rad(1)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange, 			0,  2.9, 3.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
AddText(nil,'孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,	2.9,3.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
--长孔径
apertureRadius = math.rad(2.5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
AddText(nil,'长孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Nav_Level,base_simple,nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,  1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,  1 }
	}
)
--垂扫
IGNORE_BRT = true
apertureRadius = math.rad(4)/HUD_AZ*Width
local line_height = math.rad(45)/HUD_EL*Width
AddMultiLine(nil,nil,nil,
	{
		{-apertureRadius, line_height},
		{-apertureRadius,-line_height},
		{ apertureRadius, line_height},
		{ apertureRadius,-line_height},
		{-apertureRadius, line_height},
		{ apertureRadius, line_height},
		{-apertureRadius,-line_height},
		{ apertureRadius,-line_height}
	},{0,1,2,3,4,5,6,7},nil,nil,'DBG_GREEN',nil,nil,Nav_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HEAD_AZ','HEAD_EL'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
		{ AnimalControllor.moveLeftRightUsingParameter,	3,math.rad(x_scale) },
		{ AnimalControllor.moveUpDownUsingParameter,	4,-math.rad(y_scale) }
	}
)
IGNORE_BRT = false
AddText(nil,'垂扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
	}
)
--平扫
IGNORE_BRT = true
apertureRadius = math.rad(5)/HUD_EL*Height
local line_width = math.rad(60)/HUD_AZ*Width
AddMultiLine(nil,nil,nil,
	{
		{-line_width, apertureRadius},
		{ line_width, apertureRadius},
		{-line_width,-apertureRadius},
		{ line_width,-apertureRadius},
		{-line_width, apertureRadius},
		{-line_width,-apertureRadius},
		{ line_width, apertureRadius},
		{ line_width,-apertureRadius}
	},{0,1,2,3,4,5,6,7},nil,nil,'DBG_GREEN',nil,nil,Nav_Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HEAD_AZ','HEAD_EL'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
		{ AnimalControllor.parameterInRange,			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
		{ AnimalControllor.moveLeftRightUsingParameter,	3,math.rad(x_scale) },
		{ AnimalControllor.moveUpDownUsingParameter,	4,-math.rad(y_scale) }
	}
)
IGNORE_BRT = false
AddText(nil,'平扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Nav_Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
		{ AnimalControllor.parameterInRange,			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
	}
)

local DmaxRange = 550 	--最大范围

--雷达扫描目标
--敌方红色方块，未知黄色，友方绿色
for i = 1, Targetnum do
	--敌方目标红色方块
	local contact_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_RED',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --2
			string.format('HMD_CONTACT_%02d_TIME', 			i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i), --7
			'HEAD_AZ'
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,0},
			{AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7},
			{AnimalControllor.parameterInRange,				8,-60,60} -- 头向范围
		}
	)
	--未知目标黄色方块
	local unknown_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_YELLOW',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --2
			string.format('HMD_CONTACT_%02d_TIME', 			i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i),  --7
			'HEAD_AZ'
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,-1},
			{AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7},
			{AnimalControllor.parameterInRange,				8,-60,60} -- 头向范围
		}
	)
	--友方绿色方块
	local friendly_box=AddBoxBorder(nil,0.1*Width,0.1*Width,0.004*Width,nil,nil,'DBG_GREEN',Nav_Level,nil,base_simple,
		{
			string.format('HMD_CONTACT_%02d_Y', 			i), --0
			string.format('HMD_CONTACT_%02d_X', 			i), --1
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --2
			string.format('HMD_CONTACT_%02d_TIME', 			i), --3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',	 								--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i),  --7
			'HEAD_AZ'
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
			{AnimalControllor.parameterCompareWithNumber,	2,1},
			{AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7},
			{AnimalControllor.parameterInRange,				8,-60,60} -- 头向范围
		}
	)
	--雷达扫描目标连线，绿色友方，黄色未知，红色敌方
	AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_GREEN',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			'HMD_TARGET_BOX_X_2',								--2
			'HMD_TARGET_BOX_Y_2',								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME', 			i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i),  --9
			'HEAD_AZ'
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,4.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,1},
			{AnimalControllor.opacityUsingParameter,		9},
			{AnimalControllor.parameterInRange,				10,-60,60} -- 头向范围
    	}
	)
	AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_YELLOW',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			'HMD_TARGET_BOX_X_2',								--2
			'HMD_TARGET_BOX_Y_2',								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME', 			i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i),  --9
			'HEAD_AZ'
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,-1},
			{AnimalControllor.opacityUsingParameter,		9},
			{AnimalControllor.parameterInRange,				10,-60,60} -- 头向范围
    	}
	)
	AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Nav_Level,base_simple,
    	{
			string.format('HMD_CONTACT_%02d_X', 			i), --0
			string.format('HMD_CONTACT_%02d_Y', 			i), --1
			'HMD_TARGET_BOX_X_2',								--2
			'HMD_TARGET_BOX_Y_2',								--3
			'ATK_MODE',											--4
			'RADAR_WORK_MODE',									--5
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i), --6
			string.format('HMD_CONTACT_%02d_TIME', 			i), --7
			string.format('HMD_CONTACT_%02d_FRIENDLY', 		i), --8
			string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i),  --9
			'HEAD_AZ'
		},
    	{
    	    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    	    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.parameterInRange,				7,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	8,0},
			{AnimalControllor.opacityUsingParameter,		9},
			{AnimalControllor.parameterInRange,				10,-60,60} -- 头向范围
    	}
	)

	AddText(nil,nil,'unicode_cn_red',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,contact_box,
		{'E%1.f\n',' %s\n',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_ID', 			i),
            string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
            {AnimalControllor.textUsingParameter,			2,2},
			{AnimalControllor.parameterCompareWithNumber,	3,0},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,				2,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_red',{0,0.1*Height},Align.CB,DEFAULT_FONT_SIZE[1],nil,Nav_Level,contact_box,
		{'E%1.f\n',' %s\n',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_ID', 			i),
            string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
            {AnimalControllor.textUsingParameter,			2,2},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
			{AnimalControllor.parameterInRange,				2,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_yellow',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,unknown_box,
		{'U %s',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterCompareWithNumber,	2,0},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_yellow',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,unknown_box,
		{'U %s',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterCompareWithNumber,	2,1},
			{AnimalControllor.parameterCompareWithNumber,	3,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange}
		}
	)
	AddText(nil,nil,'unicode_cn_green',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,friendly_box,
		{'F %s',' %.2fKM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_KM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange},
			{AnimalControllor.parameterCompareWithNumber,	2,0},
			{AnimalControllor.parameterCompareWithNumber,	3,1}
		}
	)
	AddText(nil,nil,'unicode_cn_green',{0,-0.1*Height},Align.CT,DEFAULT_FONT_SIZE[1],nil,Nav_Level,friendly_box,
		{'F %s',' %.2fNM'},
		{
			string.format('HMD_CONTACT_%02d_NCTR', 			i),
			string.format('HMD_CONTACT_%02d_RANGE_NM', 		i),
			'UNIT',
			'ATK_MODE'
		},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.parameterInRange,				1,0.09,DmaxRange},
			{AnimalControllor.parameterCompareWithNumber,	2,1},
			{AnimalControllor.parameterCompareWithNumber,	3,1}
		}
	)
end
--===============================
-- 雷达聚类目标显示模块（蓝色显示）
--===============================
-- 此处循环建立显示对象。循环次数可以使用 Targetnum 或者聚类目标数量（例如 clusterTargetCount）
--Life_time       = 2.081
--Life_time_low   = 0.8
for i = 1, Targetnum do
	-- 1. 用蓝色方块标识聚类目标位置
	local cluster_box = AddBoxBorder(
		nil,                                -- name
		0.05 * Width,                       -- 方块宽度
		0.05 * Width,                       -- 方块高度
		0.004 * Width,                      -- 边框厚度
		nil, nil,
		'DBG_BLUE',                         -- 材质使用蓝色（DBG_BLUE）
		Nav_Level,                          -- 层级
		nil,
		base_simple,                        -- 父元素
		{
			string.format('HMD_CLUSTER_TARGET_%02d_Y', i),          --0 用于获取Y坐标的参数名称
			string.format('HMD_CLUSTER_TARGET_%02d_X', i),          --1 用于获取X坐标的参数名称
			string.format('HMD_CLUSTER_TARGET_%02d_FRIENDLY', i),   --2 获取IFF属性
			string.format('HMD_CLUSTER_TARGET_%02d_TIME', i),       --3 时间参数（同扫描目标类似）
			'ATK_MODE',                                             --4 攻击模式参数（直接传字符串即可）
			'RADAR_WORK_MODE',                                      --5 雷达工作模式参数
			string.format('HMD_CLUSTER_TARGET_%02d_RANGE_KM', i),   --6 范围（海里，参考原显示）
			string.format('RADAR_CONTACT_%02d_TIME_SCALE', i),       --7 时间缩放参数
			'HEAD_AZ'
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,         0, y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,      1, x_scale},
			{AnimalControllor.parameterCompareWithNumber,       2, 0},
			{AnimalControllor.parameterInRange,                 3, Life_time_low, Life_time},
			{AnimalControllor.parameterCompareWithNumber,       4, 1},
        --	{AnimalControllor.parameterInRange,                 5, -0.9, 5.1}, -- 如有需要可添加
			{AnimalControllor.parameterInRange,                 6, 0.09, DmaxRange},
			{AnimalControllor.opacityUsingParameter,            7},
			{AnimalControllor.parameterInRange,                 8, -60,60} -- 头向范围
		}
	)

	--[[ 2. 用蓝色连线指示该蓝色方块位置，连线通常提示与前一目标盒（或一个固定点）的连线
	-- 此处连线的控制逻辑与参考类似，只是颜色改为 DBG_BLUE
	AddSimpleLine(
		nil,
		0.004 * Width,
		{{0,0}, {1,0}},
		nil, nil,
		'DBG_BLUE',													-- 连线材质用蓝色
		nil,
		Nav_Level,
		base_simple,
		{
			string.format('HMD_CLUSTER_TARGET_%02d_X', i),          --0 用于连线的目标 X 坐标参数
			string.format('HMD_CLUSTER_TARGET_%02d_Y', i),          --1 用于连线的目标 Y 坐标参数
			'HMD_TARGET_BOX_X_2',                                   --2 预定义的连线起点X坐标（由 Radar_init.lua 中更新）
			'HMD_TARGET_BOX_Y_2',                                   --3 连线起点Y坐标
			'ATK_MODE',                                             --4
			'RADAR_WORK_MODE',                                      --5
			string.format('HMD_CLUSTER_TARGET_%02d_RANGE_NM', i),   --6 连线中可用范围参数
		},
		{
			{AnimalControllor.lineObjectSetPointUsingParameters,    0, 0, 1, x_scale, y_scale},
			{AnimalControllor.lineObjectSetPointUsingParameters,    1, 2, 3, x_scale, y_scale},
			{AnimalControllor.parameterCompareWithNumber,           4, 1},
			{AnimalControllor.parameterInRange,                     5, -0.9, 5.1},
			{AnimalControllor.parameterInRange,                     6, 0.09, DmaxRange},
		}
	)]]

	-- 3. 在蓝色方块上附着文字信息，显示聚类目标的 id、range（单位 km）和 NCTR
	AddText(
		nil,
		nil,
		'unicode_cn_blue',                  -- 使用蓝色文字（unicode_cn_blue）
		{0, -0.1 * Height},                 -- 文字显示的位置，相对于方块，可根据需求调整
		Align.CT,                           -- 中间对齐
		DEFAULT_FONT_SIZE[1],               -- 字体大小
		nil,
		Nav_Level,
		cluster_box,                        -- 将文字依附于 blue 方块
		{
			"%1.f\n", "%.2fKM\n", "%s\n"
		},
		{
			string.format("HMD_CLUSTER_TARGET_%02d_ID", i),       -- 聚类目标的 ID 参数
			string.format("HMD_CLUSTER_TARGET_%02d_RANGE_KM", i),   -- 聚类目标的距离，单位 km
			string.format("HMD_CLUSTER_TARGET_%02d_NCTR", i)        -- 聚类目标的 NCTR 参数
		},
		{
			{AnimalControllor.textUsingParameter, 0, 0},
			{AnimalControllor.textUsingParameter, 1, 1},
			{AnimalControllor.textUsingParameter, 2, 2}
		}
	)
end
