dofile(LockOn_Options.script_path .. "Displays/Helmet/Indicator/definitions.lua")

AddBox(nil,3*Width,3*Height,nil,nil,'DBG_BLACK',DEFAULT_NOCLIP_LEVEL,REWRITE_LEVEL,nil,nil,nil,true)

IS_HUD = true
local base_simple = AddSimple()
local spd_clip = AddSimple(nil,AS_POS,nil,base_simple)
local alt_clip = AddSimple(nil,ALT_POS,nil,base_simple)
local hdg_clip = AddBox(nil,HDG_W,HDG_H,{0,0.9*Height},nil,'DBG_CLEAR',DEFAULT_NOCLIP_LEVEL,INCREASE_IF_LEVEL,base_simple)

--速度
--速度定位框
local maskFrame=AddBoxBorder(nil,0.15*Width,0.1*AS_H,0.005*Width,{-0.35*AS_W,0},nil,'DBG_GREEN',nil,DEFAULT_NOCLIP_LEVEL,spd_clip)
--速度显示 海拔高度大于5000时显示真空速
--表空速
AddText(nil,nil,'unicode_cn_green',{0.75*0.7*AS_W,0},Align.RC,DEFAULT_FONT_SIZE[1],nil,DEFAULT_NOCLIP_LEVEL,maskFrame,{'%.0f'},{'AS','ALT'},{{'text_using_parameter',0},{AnimalControllor.parameterInRange,1,0,5000}})
--真空速
AddText(nil,nil,'unicode_cn_green',{0.75*0.7*AS_W,0},Align.RC,DEFAULT_FONT_SIZE[1],nil,DEFAULT_NOCLIP_LEVEL,maskFrame,{'%.0f'},{'TAS','ALT'},{{'text_using_parameter',0},{AnimalControllor.parameterInRange,1,5000,5000000}})
--马赫
AddText(nil,nil,'unicode_cn_green',{0,0.12*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,DEFAULT_NOCLIP_LEVEL,spd_clip,{'%.1fM'},{'BASE_SENSOR_MACH'},{{'text_using_parameter',0}})

--高度
--高度定位框
maskFrame = AddBoxBorder(nil,0.15*Width,0.1*AS_H,0.005*Width,{0.35*AS_W,0},nil,'DBG_GREEN',nil,DEFAULT_NOCLIP_LEVEL,alt_clip)
--高度显示 雷达高度小于1500时显示雷达高度
--海拔高度
AddText(nil,nil,'unicode_cn_green',{-0.55*0.9*AS_W,0},Align.LC,DEFAULT_FONT_SIZE[1],nil,DEFAULT_NOCLIP_LEVEL,maskFrame,{'%.0f'},{'ALT','RALT'},{{'text_using_parameter',0},{AnimalControllor.parameterInRange,1,1500,5000000}})
--雷达高度
AddText(nil,nil,'unicode_cn_green',{-0.55*0.9*AS_W,0},Align.LC,DEFAULT_FONT_SIZE[1],nil,DEFAULT_NOCLIP_LEVEL,maskFrame,{'%.0f'},{'RALT'},{{'text_using_parameter',0},{AnimalControllor.parameterInRange,0,0,1500}})

--航向
local hdgBarMoveSim = AddSimple(nil,nil,nil,hdg_clip,{'HEAD_HDG'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.001556}})
--航向刻度条
local tickInterval = AS_H/9
for i = -24, 96, 1 do
    local scaleLength = 0.4*HDG_H
    local posX = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        local hdg = i*0.5
        local v
        if hdg<0 then
            hdg = 36+hdg
        end
        if hdg == 0 or hdg == 36 then
            v = 'N'
        elseif hdg == 9 or hdg == 45 then
            v = 'E'
        elseif hdg == 18 or hdg == 54 then
            v = 'S'
        elseif hdg == 27 or hdg == 63 then
            v = 'W'
        elseif hdg > 36 then
            v = tostring(36-hdg)
        else
            v = tostring(hdg)
        end
        AddText(nil,v,'unicode_cn_green',{posX,0.4*HDG_H},Align.CB,DEFAULT_FONT_SIZE[5],nil,nil,hdgBarMoveSim)
    end
    AddSimpleLine(nil,0.005*Width,{{posX,0},{posX,scaleLength}},nil,nil,'DBG_GREEN',nil,nil,hdgBarMoveSim)
end

local hdgFrameSim = AddSimple('航向框节点',{0,0.065*Height},nil,hdg_clip)

AddSimpleLine('航向框边条',0.005*Width,{
    {-0.07*Width,0.04*Height},{-0.035*Width,0.04*Height},{0,0.08*Height},{0.035*Width,0.04*Height},{0.07*Width,0.04*Height},{0.07*Width,-0.04*Height},{-0.07*Width,-0.04*Height},{-0.07*Width,0.04*Height}
},
    {0,-0.15*Height},nil,'DBG_GREEN',nil,nil,hdgFrameSim
)
AddText('航向值','000','unicode_cn_green',{0,-0.15*Height},nil,DEFAULT_FONT_SIZE[2],nil,nil,hdgFrameSim,{'%.0f'},
    {'HEAD_HDG'},{{AnimalControllor.textUsingParameter,0}}
)
IGNORE_BRT = true
AddBox(nil,10*Width,10*Height,nil,nil,'DBG_RED',DEFAULT_MASK_NOCLIP_LEVEL,REWRITE_LEVEL,base_sim,nil,nil,true)
AddBox(nil,10*Width,10*Height,nil,nil,'DBG_RED',DEFAULT_MASK_NOCLIP_LEVEL,INCREASE_IF_LEVEL,base_sim,nil,nil,true)

AddBox(nil,10*Width,10*Height,nil,nil,'DBG_RED',DEFAULT_MASK_LEVEL,nil,base_sim,{'BROKEN_WING_WARNING'},{
    {AnimalControllor.opacityUsingParameter,0}
})