-- hud显示控制机
dofile(LockOn_Options.common_script_path.."devices_defs.lua")
dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."cockpit_cfg.lua")

local dev 	    = GetSelf()

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)
local sensor_data = get_base_data()

local dayNight = 0 --0白天 1夜晚
local dayNight_h = get_param_handle('DAY_NIGHT')
local params_h = {
	hudBrt = {get_param_handle('HUD_BRT'),0,0,0.01},--{句柄,当前值，期待值,变化率}
	FD_x = {get_param_handle('FD_X'),0},
	FD_y = {get_param_handle('FD_Y'),0},
	HUD_Z = {get_param_handle('HUD_Z'),0},
	Target_in_HUD = {get_param_handle('TARGET_IN_HUD'),0}
}
--local count = 0
local TARGET_BOX_X = get_param_handle('TARGET_BOX_X')
local TARGET_BOX_Y = get_param_handle('TARGET_BOX_Y')

dev:listen_command(click_cmd.hudBrt)
dev:listen_command(click_cmd.hmdHudMFCD_change_dayNight)

local hud_limit = {
    x= HUD_AZ,
    y = HUD_EL
}
local function Update_Target_in_HUD()
	local target_in_hud = 0
	local hud_border = 0.9
	if TARGET_BOX_X:get() > -hud_limit.x * hud_border and TARGET_BOX_X:get() < hud_limit.x * hud_border and
	   TARGET_BOX_Y:get() > -hud_limit.y * hud_border and TARGET_BOX_Y:get() < hud_limit.y * hud_border then
		target_in_hud = 1
	end
	params_h.Target_in_HUD[2] = target_in_hud
	params_h.Target_in_HUD[1]:set(target_in_hud)
end

local function limit_xy(x, y, limit_x, limit_y, limit_x_down, limit_y_down)
    limit_x_down = limit_x_down or -limit_x
    limit_y_down = limit_y_down or -limit_y

    local limited_x = false
    local limited_y = false

    if (x > limit_x) and (y <= limit_y / limit_x * x) and (y >= limit_y_down / limit_x * x) then
        y = y * limit_x / x
        x = limit_x
        limited_x = true
    end

    if (x < limit_x_down)  and (y <= limit_y / limit_x_down * x) and (y >= limit_y_down / limit_x_down * x) then
        y = y * limit_x_down / x
        x = limit_x_down
        limited_x = true
    end

    if (y > limit_y) and (x < limit_x / limit_y * y) and (x > limit_x_down / limit_y * y) then
        x = x * limit_y / y
        y = limit_y
        limited_y = true
    end

    if (y < limit_y_down) and (x < limit_x / limit_y_down * y) and (x > limit_x_down / limit_y_down * y) then
        x = x * limit_y_down / y
        y = limit_y_down
        limited_y = true
    end

    local limited = (limited_x or limited_y) and 1 or 0
    return x, y, limited, limited_x, limited_y
end

local bitTime = 0

--[[local function bitProgram()
	bitTime = math.floor((bitTime + update_time_step)*100 + 0.5) / 100

	if bitTime == 17 then
		--右襟翼放下
		print_message_to_user('右襟翼放下')
	elseif bitTime == 19 then
		--右襟翼收起
		print_message_to_user('右襟翼收起')
	elseif bitTime == 21 then
		--左襟翼放下
		print_message_to_user('左襟翼放下')
	elseif bitTime == 23 then
		--左襟翼收起
		print_message_to_user('左襟翼收起')
	elseif bitTime == 25 then
		--右副翼向下偏转
		print_message_to_user('右副翼向下偏转')
	elseif bitTime == 27 then
		--右副翼复位
		print_message_to_user('右副翼复位')
	elseif bitTime == 29 then
		--右副翼向上偏转
		print_message_to_user('右副翼向上偏转')
	elseif bitTime == 31 then
		--右副翼复位
		print_message_to_user('右副翼复位')
	elseif bitTime == 33 then
		--左副翼向下偏转
		print_message_to_user('左副翼向下偏转')
	elseif bitTime == 35 then
		--左副翼复位
		print_message_to_user('左副翼复位')
	elseif bitTime == 37 then
		--左副翼向上偏转
		print_message_to_user('左副翼向上偏转')
	elseif bitTime == 39 then
		--左副翼复位
		print_message_to_user('左副翼复位')
	elseif bitTime == 41 then
		--右平尾翼向下偏转
		print_message_to_user('右平尾翼向下偏转')
	elseif bitTime == 43 then
		--右平尾复位
		print_message_to_user('右平尾复位')
	elseif bitTime == 45 then
		--右平尾翼向上偏转
		print_message_to_user('右平尾翼向上偏转')
	elseif bitTime == 47 then
		--右平尾复位
		print_message_to_user('右平尾复位')
	elseif bitTime == 49 then
		--左平尾翼向下偏转
		print_message_to_user('左平尾翼向下偏转')
	elseif bitTime == 51 then
		--左平尾复位
		print_message_to_user('左平尾复位')
	elseif bitTime == 53 then
		--左平尾翼向上偏转
		print_message_to_user('左平尾翼向上偏转')
	elseif bitTime == 55 then
		--左平尾复位
		print_message_to_user('左平尾复位')
	elseif bitTime == 57 then
		--垂尾向右偏转
		print_message_to_user('垂尾向右偏转')
	elseif bitTime == 59 then
		--垂尾复位
		print_message_to_user('垂尾复位')
	elseif bitTime == 61 then
		--垂尾向左偏转
		print_message_to_user('垂尾向左偏转')
	elseif bitTime == 63 then
		--垂尾复位
		print_message_to_user('垂尾复位')
	elseif bitTime == 65 then
		--扰流板打开
		print_message_to_user('扰流板打开')
	elseif bitTime == 67 then
		--扰流板关闭
		print_message_to_user('扰流板关闭')
	elseif bitTime == 69 then
		--襟翼、副翼、平尾、垂尾全部活动4秒
		print_message_to_user('襟翼、副翼、平尾、垂尾全部活动4秒')
	end
end]]

function post_initialize()
	local birth = LockOn_Options.init_conditions.birth_place
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		dev:performClickableAction(click_cmd.hudBrt, 1, false)
		params_h.hudBrt[2] = 1
		params_h.hudBrt[3] = 0.98
		params_h.HUD_Z[2] = 1
		count = 8
    elseif birth=="GROUND_COLD" then
		dev:performClickableAction(click_cmd.hudBrt, 0, false)
		count = 0
    end
end

function SetCommand(command,value)
	--DebugPrint(command..'..........'..value)
	if command == click_cmd.hudBrt then
		params_h.hudBrt[2] = value
	elseif command==click_cmd.hmdHudMFCD_change_dayNight then
        if value == 1 then
            dayNight = 0
        elseif value == -1 then
            dayNight = 1
        end
	end
end

function calFPM()
	local v_x, v_y, v_z = sensor_data:getSelfVelocity()
	local v = math.sqrt( v_x * v_x + v_y * v_y + v_z * v_z)
	local v_hdg = math.atan2(v_z, v_x)
	local v_pitch = 0
    if v ~= 0 then
        v_pitch = math.asin(v_y / v)
    end
	local p_pitch, p_roll, p_hdg
    p_pitch = sensor_data.getPitch()
	p_roll = sensor_data:getRoll()
    p_hdg = 2*math.pi - sensor_data:getHeading()
	local dif_hdg = (v_hdg - p_hdg) % (2*math.pi)
	if dif_hdg > math.pi then
		dif_hdg = dif_hdg - 2 * math.pi
	end
	local fpm_x = (dif_hdg) * math.cos(p_roll) - (-p_pitch + v_pitch) * math.sin(p_roll)
    local fpm_y = (-p_pitch + v_pitch) * math.cos(p_roll) + (dif_hdg) * math.sin(p_roll)
	local fpm_cross = 0
	fpm_x,fpm_y,fpm_cross = limit_xy(fpm_x,fpm_y,hud_limit.x,hud_limit.y*1.3)
	params_h.FD_x[2]=math.tan(fpm_x)*HUD_distance
	params_h.FD_y[2]=math.tan(fpm_y)*HUD_distance
end

local c = 0
function update()
	Update_Target_in_HUD()
	c = c + update_time_step
	if c > 36 then
		c = 0
	end
	dayNight=dayNight_h:get()
	if get_elec_primary_dc_ok() then
		calFPM()
		if params_h.HUD_Z[2]<0.99 and params_h.hudBrt[2]>0 then
			params_h.HUD_Z[2] = params_h.HUD_Z[2] + update_time_step*0.5
		end
		for k, v in pairs(params_h) do
			if type(v[3]) ~= "nil" then
				if v[2] > v[3] then
					v[3] = Limit(v[3] + v[4], 0, 1)
				elseif v[2] < v[3] then
					v[3] = Limit(v[3] - v[4], 0, 1)
				end
				if k == 'hudBrt' then
					v[1]:set(v[3]*(1-0.8*dayNight))
				else
					v[1]:set(v[3])
				end
			else
				v[1]:set(v[2])
			end
		end
	else
		for k, v in pairs(params_h) do

			if type(v[3]) ~= "nil" then
				v[3] = 0
				v[1]:set(v[3])
			else
				v[2] = 0
				v[1]:set(v[2])
			end
		end
	end
end