dofile(LockOn_Options.script_path.."Displays/HUD/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local debug_switch = Render_debug_info
if debug_switch == 0 then
	return
end

local Debug_Level = DEFAULT_LEVEL + 4
local Debug_Noclip_Level = DEFAULT_NOCLIP_LEVEL + 4

AddBox(nil,Width,Height,nil,nil,'DBG_RED',Debug_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Width,Height,nil,nil,'DBG_CLEAR',Debug_Noclip_Level,INCREASE_IF_LEVEL)
IS_HUD = true
local z_simple = AddSimple(nil,{0,0,-2},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
-----------------------------------------------------------------
--【HUD 显示调试信息：本机姿态】
-----------------------------------------------------------------
AddText(nil,nil,'unicode_cn_yellow', {0, 0.4 * Height}, -- 屏幕中间偏下
    Align.CC, DEFAULT_FONT_SIZE[4], nil, Debug_Level, base_simple,
    {
        '机体姿态 DEG PITCH: %.1f',' ROLL: %.1f\n',
        'HEAD_AZ: %.1f','  HEAD_EL: %.1f\n'
    },
    {
        'DEBUG_PITCH_DEG', 'DEBUG_ROLL_DEG',
        'HEAD_AZ', 'HEAD_EL',
        'DEBUG_SWITCH',
        "HELMET_IN_HUD"
    },
    {
        {AnimalControllor.textUsingParameter, 0,0},        {AnimalControllor.textUsingParameter, 1,1},
    --	{AnimalControllor.textUsingParameter, 2,2},        {AnimalControllor.textUsingParameter, 3,3},
        {AnimalControllor.parameterCompareWithNumber, 4,1},
        {AnimalControllor.parameterCompareWithNumber, 5,1}
    }
)
-----------------------------------------------------------------
--【HUD 显示调试信息：头盔姿态】
-----------------------------------------------------------------
AddText(nil,nil,'unicode_cn_yellow', {0, -0.4 * Height}, -- 屏幕中间偏下
    Align.CC, DEFAULT_FONT_SIZE[4], nil, Debug_Level, base_simple,
    {
        'DEG PITCH: %.1f',' ROLL: %.1f\n',
        'HEAD_AZ: %.1f','  HEAD_EL: %.1f\n'
    },
    {
        'DEBUG_PITCH_DEG', 'DEBUG_ROLL_DEG',
        'HEAD_AZ', 'HEAD_EL',
        'DEBUG_SWITCH',
        "HELMET_IN_HUD"
    },
    {
    --	{AnimalControllor.textUsingParameter, 0,0},        {AnimalControllor.textUsingParameter, 1,1},
        {AnimalControllor.textUsingParameter, 2,2},        {AnimalControllor.textUsingParameter, 3,3},
        {AnimalControllor.parameterCompareWithNumber, 4,1},
        {AnimalControllor.parameterCompareWithNumber, 5,1}
    }
)
--------------------------------------------------------------------------------
--【HUD 显示调试信息：雷达模式】
-- 显示 Radar.mode_h (DEBUG_RADAR_MODE) 和param_debug_acm.status(DEBUG_ACM_STATUS)的调试数据
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.85 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    Debug_Level,                          -- 层级（使用 Debug_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %.0f",             -- 第1字段
        " ACM阶段: %d"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS",
        'DEBUG_SWITCH',
        "HELMET_IN_HUD"
    },
    {                                   -- 控制映射
        {AnimalControllor.textUsingParameter, 0, 0},
	--  {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.parameterCompareWithNumber, 2,1},
        {AnimalControllor.parameterCompareWithNumber, 3,1}
    }
)
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.75 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    Debug_Level,                          -- 层级（使用 Debug_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %.0f",             -- 第1字段
        " ACM阶段: %d"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS",
        'DEBUG_SWITCH',
        "HELMET_IN_HUD"
    },
    {                                   -- 控制映射
        --{AnimalControllor.textUsingParameter, 0, 0},
		{AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.parameterCompareWithNumber, 2,1},
        {AnimalControllor.parameterCompareWithNumber, 3,1}
    }
)
--------------------------------------------------------------------------------
--【HUD 显示调试信息: 扫描中心】
-- 调用 AddText 将调试数据以格式化方式显示到屏幕上（显示层级使用 Debug_Level）。
-- 显示格式保持原来4行输出，每行内字段按要求拆开，并在行末添加换行符 "\n"。
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {-0.65 * Width,0.3*Height },                -- 位置
    Align.RC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    Debug_Level,                          -- 层级（使用 Debug_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出，共4行，每行内字段拆开：
        "扫描中心: AZ=%.1fdeg", " EL=%.1fdeg\n",       -- 第1行第1字段 -- 第1行第2字段
        "ACM状态: %1.f", " | 候选数: %1.f", " | 全局计时: %.1fs\n", -- 第2行第1字段 -- 第2行第2字段 -- 第2行第3字段
        "ID: %1.f", " | 目标距离: %.1fkm\n",           -- 第3行第1字段 -- 第3行第2字段
        "目标差值: AZ=%.1fdeg", " EL=%.1fdeg\n",        -- 第4行第1字段 -- 第4行第2字段
        "扫描范围: AZ=%.1fdeg", " EL=%.1fdeg\n"       -- 第5行第1字段 -- 第5行第2字段                         
    },
    {  -- 调试参数名称数组，顺序与上面格式字段依次对应
        "DEBUG_ACM_CENTER_AZ", "DEBUG_ACM_CENTER_EL",
        "DEBUG_ACM_STATUS", "DEBUG_ACM_CANDIDATE_COUNT", "DEBUG_ACM_GLOBAL_TIMEOUT",
        "DEBUG_ACM_TARGET", "DEBUG_ACM_CHOICE_RANGE",
        "DEBUG_ACM_AZ_DIFF", "DEBUG_ACM_EL_DIFF",
        "DEBUG_ACM_MAX_SCAN_AZ", "DEBUG_ACM_MAX_SCAN_EL",
        "DEBUG_SWITCH",           -- 调试开关（用于比对或控制显示）
        "HELMET_IN_HUD",
        "ATK_MODE",'RADAR_WORK_MODE'
    },
    {                                   -- 控制映射，将每个调试参数与显示占位符对应
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
        {AnimalControllor.textUsingParameter, 8, 8},
        {AnimalControllor.textUsingParameter, 9, 9},
        {AnimalControllor.textUsingParameter, 10, 10},
        {AnimalControllor.parameterCompareWithNumber, 11, 1},
        {AnimalControllor.parameterCompareWithNumber, 12, 1},
        {AnimalControllor.parameterCompareWithNumber, 13, 1},
        {AnimalControllor.parameterInRange, 14, 0.1, 5.1}
    }
)
-----------------------------------------------------------------