dofile(LockOn_Options.script_path .. "Displays/HUD/Indicator/definitions.lua")


AddBox(nil,1.2*Width,1.2*Height,nil,nil,'DBG_RED',DEFAULT_NOCLIP_LEVEL,REWRITE_LEVEL,nil,nil,nil,true)

IS_HUD = true
local z_simple = AddSimple(nil,{0,0,-2},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
local spd_clip = AddBox("速度条裁剪底",AS_W,AS_H,AS_POS,nil,'DBG_CLEAR',DEFAULT_NOCLIP_LEVEL,INCREASE_IF_LEVEL,base_simple)
local alt_clip = AddBox("高度条裁剪底",AS_W+0.1,AS_H,ALT_POS,nil,'DBG_CLEAR',DEFAULT_NOCLIP_LEVEL,INCREASE_IF_LEVEL,base_simple)
local hdg_clip = AddBox("航向条裁剪底",HDG_W,HDG_H,{0,0.9*Height},nil,'DBG_CLEAR',DEFAULT_NOCLIP_LEVEL,INCREASE_IF_LEVEL,base_simple)

--AddBox(nil,Width,Height,nil,nil,'DBG_RED',DEFAULT_NOCLIP_LEVEL,REWRITE_LEVEL,base_simple,nil,nil,true)

--速度

--AddBox(nil,AS_W,AS_H,nil,nil,'DBG_RED',DEFAULT_MASK_LEVEL,REWRITE_LEVEL,spd_simple,nil,nil,true)

local spd_mv_simple = AddSimple(nil,{AS_W},nil,spd_clip,{'AS'},{{AnimalControllor.moveUpDownUsingParameter,0,-0.001089}})
local tickInterval = AS_H/9
for i = 0, 600, 1 do
    local scaleLength = 0.4*AS_W
    local posY = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        AddText(nil,tostring(i*0.5),'hud_font_base',{-0.4*AS_W,posY},Align.RC,DEFAULT_FONT_SIZE[5],nil,nil,spd_mv_simple,nil,
        {'ATK_MODE'},{{AnimalControllor.parameterCompareWithNumber,0,0}}
		)
    end
    AddSimpleLine(nil,0.005*Width,{{0,posY},{-scaleLength,posY}},nil,nil,'SCREEN_COLOR',nil,nil,spd_mv_simple,
    {'ATK_MODE'},{{AnimalControllor.parameterCompareWithNumber,0,0}}
	)
end

local maskFrame=AddBoxBorder(nil,0.15*Width,0.1*AS_H,0.005*Width,{-0.4*AS_W,0},nil,'hud_font_base',nil,nil,spd_clip,{'ALT'},{{AnimalControllor.parameterInRange,0,0,5000}})
--速度显示
AddText(nil,nil,'hud_font_base',{0*AS_W,0},Align.RC,DEFAULT_FONT_SIZE[1],nil,nil,spd_clip,{'%.0f'},{'AS'},{{'text_using_parameter',0}}) --表空速
local TrueAS=AddText(nil,nil,'hud_font_base',{0*AS_W,0.12*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,nil,spd_clip,{'%.0f'},{'TAS'},{{'text_using_parameter',0}}) --真空速
AddBoxBorder(nil,0.15*Width,0.1*AS_H,0.005*Width,{-0.4*AS_W,0},nil,'hud_font_base',nil,nil,TrueAS,{'ALT'},{{AnimalControllor.parameterInRange,0,5000,5000000}})
--马赫
AddText(nil,nil,'hud_font_base',{0*AS_W,-0.12*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,nil,spd_clip,{'%.1fM'},{'BASE_SENSOR_MACH'},{{'text_using_parameter',0}})

--高度
local alt_mv_simple = AddSimple(nil,{-(AS_W+0.1),0},nil,alt_clip,{'ALT'},{{'move_up_down_using_parameter',0,-0.0001089}})
for i = 0, 560, 1 do
    local scaleLength = 0.4*AS_W
    local posY = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        AddText(nil,tostring(i*0.5),'hud_font_base',{0.4*AS_W,posY},Align.LC,DEFAULT_FONT_SIZE[5],nil,nil,alt_mv_simple,nil,
        {'ATK_MODE'},{
            {AnimalControllor.parameterCompareWithNumber,0,0}
        })
    end
    AddSimpleLine(nil,0.005*Width,{{0,posY},{scaleLength,posY}},nil,nil,'SCREEN_COLOR',nil,nil,alt_mv_simple,
    {'ATK_MODE'},{
        {AnimalControllor.parameterCompareWithNumber,0,0}
    })
end

maskFrame = AddBoxBorder(nil,0.7*AS_W,0.1*AS_H,0.005*Width,{0.15*AS_W,0},nil,'hud_font_base',nil,nil,alt_clip,{'RALT'},{{AnimalControllor.parameterInRange,0,1500,5000000}})
--高度显示
AddText(nil,nil,'hud_font_base',{-0.45*AS_W,0},Align.LC,DEFAULT_FONT_SIZE[1],nil,nil,alt_clip,{'%.0f'},{'ALT'},{{'text_using_parameter',0}})
--雷达高度
local Ralt=AddText(nil,nil,'hud_font_base',{-0.45*AS_W,0.12*Height},Align.LC,DEFAULT_FONT_SIZE[1],nil,nil,alt_clip,{'%.0f'},
    {'RALT'},
    {
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterInRange,0,0,1500},
})
AddBoxBorder(nil,0.7*AS_W,0.1*AS_H,0.005*Width,{0.15*AS_W,0},nil,'hud_font_base',nil,nil,Ralt,{'RALT'},{{AnimalControllor.parameterInRange,0,0,1500}})
--爬升率
AddText(nil,nil,'hud_font_base',{-0.45*AS_W,-0.12*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,nil,alt_clip,{'%.1fM/S'},
    {'VS','VS_VIS','UNIT'},
    {
        {AnimalControllor.textUsingParameter,0},
    --  {AnimalControllor.parameterInRange,1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,2,0},
})
AddText(nil,nil,'hud_font_base',{-0.45*AS_W,-0.12*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,nil,alt_clip,{'%.1fFT/S'},
    {'VS_FT','VS_VIS','UNIT'},
    {
        {AnimalControllor.textUsingParameter,0},
    --  {AnimalControllor.parameterInRange,1,0.9,1.1},
        {AnimalControllor.parameterCompareWithNumber,2,1},
})
--航向

local hdgBarMoveSim = AddSimple('航向条移动节点',{0,-0.525*HDG_H},nil,hdg_clip,{'HDG'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.001088}})
--航向刻度条
for i = -24, 96, 1 do
    local scaleLength = 0.4*HDG_H
    local posX = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        local hdg = i*0.5
        local v
        if hdg<0 then
            hdg = 36+hdg
        end
        if hdg == 0 or hdg == 36 then
            v = 'N'
            AddMeshPoly(nil,{{0,0},{-0.5*tickInterval,-tickInterval},{0.5*tickInterval,-tickInterval}},{0,1,2},{posX,0},nil,'SCREEN_COLOR',nil,nil,hdgBarMoveSim,
                {'TCN_AZ','TCN_WORKING'},
                {
                    {AnimalControllor.moveLeftRightUsingParameter,0,0.001088},
                    {AnimalControllor.parameterInRange,1,0.9,1.1}
                }
            )
        elseif hdg == 9 or hdg == 45 then
            v = 'E'
        elseif hdg == 18 or hdg == 54 then
            v = 'S'
        elseif hdg == 27 or hdg == 63 then
            v = 'W'
        elseif hdg > 36 then
            v = tostring(math.abs(36-hdg))
        else
            v = tostring(math.abs(hdg))
        end
        AddText(nil,v,'hud_font_base',{posX,0.4*HDG_H},Align.CB,DEFAULT_FONT_SIZE[5],nil,nil,hdgBarMoveSim,nil,
        {'ATK_MODE'},{
            {AnimalControllor.parameterInRange,0,-0.9,2.1}
        })
    end
    AddSimpleLine(nil,0.005*Width,{{posX,0},{posX,scaleLength}},nil,nil,'SCREEN_COLOR',nil,nil,hdgBarMoveSim,
    {'ATK_MODE'},{
        {AnimalControllor.parameterInRange,0,-0.9,2.1}
    })
end

local hdgFrameSim = AddSimple('航向框节点',{0,0.065*Height},nil,hdg_clip)

AddSimpleLine('航向框边条',0.005*Width,{{-0.07*Width,0.04*Height},{-0.035*Width,0.04*Height},{0,0.08*Height},{0.035*Width,0.04*Height},{0.07*Width,0.04*Height},{0.07*Width,-0.04*Height},{-0.07*Width,-0.04*Height},{-0.07*Width,0.04*Height}},
    {0,-0.3*Height},nil,'SCREEN_COLOR',nil,nil,hdgFrameSim
)
AddText('航向值','000','hud_font_base',{0,-0.3*Height},nil,DEFAULT_FONT_SIZE[4],nil,nil,hdgFrameSim,{'%.0f'},
    {'HDG'},{{AnimalControllor.textUsingParameter,0}}
)


