dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local sensor_data = get_base_data()

local Canopy = 71  --定义舱盖按键

local CANOPY_COMMAND = 1   --舱盖状态 0 关闭, 1 开启
local canopyRuning = 0

local last_eject_count = 0
local eject_count = 0
local eject_timer = 0

local canopy_system = GetSelf()
local params_h = {
    CANOPY_POS = {get_param_handle('CANOPY_POS'),0},
    CANOPY_ANI_INSIDE = {get_param_handle("CanopyInsideView"),0}
}
local aircraftArgumentVal = {
    canopy = {38,0,0.005}
}
canopy_system:listen_command(Canopy)
canopy_system:listen_command(Keys.Eject)
canopy_system:listen_event(CptEvntNames.canopyClose)
canopy_system:listen_event(CptEvntNames.canopyOpen)
local function InitCanopySounds()
	OpenSndCpt = sndhost:create_sound("Aircrafts/A-10/Cockpit/CanopyCloseCpt")
	CloseSndCpt = sndhost:create_sound("Aircrafts/A-10/Cockpit/CanopyOpenCpt")
    EndSndCpt = sndhost:create_sound("Aircrafts/A-10/Cockpit/CanopyEndCpt")
end
function post_initialize()
    sndhost = create_sound_host("COCKPIT", "3D", 0, 0, 0)
    InitCanopySounds()
    local birth = LockOn_Options.init_conditions.birth_place
    if birth=="GROUND_HOT" then
        CANOPY_COMMAND = 0
		aircraftArgumentVal.canopy[2] = 0
    elseif birth=="AIR_HOT" then
        CANOPY_COMMAND = 0
		aircraftArgumentVal.canopy[2] = 0
    elseif birth=="GROUND_COLD" then
        CANOPY_COMMAND = 1
		aircraftArgumentVal.canopy[2] = 0.9
    end

    -- set_aircraft_draw_argument_value(38,CANOPY_COMMAND)
end

function SetCommand(command,value)
	if (command == Canopy) then
        CANOPY_COMMAND = 1 - CANOPY_COMMAND
        canopyRuning = 1
        if (CANOPY_COMMAND == 1) then
            OpenSndCpt:play_continue()
            CloseSndCpt:stop()
        else
            OpenSndCpt:stop()
            CloseSndCpt:play_continue()
        end
    elseif command == Keys.Eject then
        eject_count = eject_count + 1
	end
end
local e = false
local ec = 0
local function eject()
    if eject_count > 0 then
        eject_timer = eject_timer + update_time_step
    else
        eject_timer = 0
    end
    if eject_timer > 1 and last_eject_count == eject_count then
        eject_count = 0
    elseif eject_timer < 1 and last_eject_count<eject_count then
        eject_timer = 0
    end
    if eject_timer < 1 and eject_count == 3 then
        if get_elec_primary_dc_ok() then
            for i = 1, 3, 1 do
                dispatch_action(nil,Keys.PlaneEject,1)
            end
            last_eject_count = 0
            eject_count = 0
            eject_timer = 0
            e = true
        else
            last_eject_count = 0
            eject_count = 0
            eject_timer = 0
        end
    end
    if e then
        ec = ec + update_time_step
    end
    if ec > 0.13 then
        params_h.CANOPY_ANI_INSIDE[2] = 1
        params_h.CANOPY_POS[2] = 1
        aircraftArgumentVal.canopy[2] = 1
        CANOPY_COMMAND = 1
    end
    last_eject_count = eject_count
end

function update()

	if (CANOPY_COMMAND == 0 and aircraftArgumentVal.canopy[2] > 0) then
		-- lower canopy in increments of 0.01 (50x per second)
		aircraftArgumentVal.canopy[2] = Limit(aircraftArgumentVal.canopy[2] - aircraftArgumentVal.canopy[3],0,0.9)
        if aircraftArgumentVal.canopy[2] <= 0.01 and canopyRuning == 1 then
            CloseSndCpt:stop()
            EndSndCpt:play_once()-- body
            canopyRuning = 0
        end
	elseif (CANOPY_COMMAND == 1 and aircraftArgumentVal.canopy[2] < 0.9) then
        -- raise canopy in increment of 0.01 (50x per second)
		aircraftArgumentVal.canopy[2] = Limit(aircraftArgumentVal.canopy[2] + aircraftArgumentVal.canopy[3],0,0.9)
        if aircraftArgumentVal.canopy[2] >= 0.9 and canopyRuning == 1 then
            OpenSndCpt:stop()
            EndSndCpt:play_once()-- body
            canopyRuning = 0
        end
    end
    eject()
    for k, v in pairs(aircraftArgumentVal) do
        set_aircraft_draw_argument_value(v[1],v[2])
    end
    params_h.CANOPY_POS[2]=aircraftArgumentVal.canopy[2]*45
    params_h.CANOPY_ANI_INSIDE[2]=aircraftArgumentVal.canopy[2]
    for k, v in pairs(params_h) do
        v[1]:set(v[2])
    end
end

function CockpitEvent(event, val)

end

need_to_be_closed = false