dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."cockpit_cfg.lua")

local flir = GetSelf()
local flirw = 1024 --640
local flirh = 1024 --480
local update_time_step = 0.02 --update will be called 50 times per second
make_default_activity(update_time_step)

export_prefix = "FLIR"

thermal = {
    fov = {math.rad(30), math.rad(5.7), math.rad(1.4)},    -- list, in rad
    digital_zoom = {1, 2},
    resolution = {flirw, flirh},                -- w, h, in pixels
    sensor_resolution = {flirw/2, flirh/2},         -- w, h, in pixels
    wavelength = {3, 5},                    -- min, max, in um
}

visible = {
    fov = {math.rad(2.7), math.rad(28)},    -- min, max, in rad
    color = true,
    resolution = {flirw, flirh},                -- w, h, in pixels
    digital_zoom = 12,                      -- max
}

spotter = {
    color = true,
    resolution = {flirw, flirh},                -- w, h, in pixels
    fov = 0.4,                              -- fixed
    default_code = 1688,
}

rangefinder = {
    max_range = 20000,                      -- in m
}

designator = {
    power = 2,                              -- in W
    default_code = 1688,
}

pointer = {
    power = 0.1,                            -- in W
}

electrical = {
--	power_bus_handle = "FLIR_POWER_OK"      -- comment to connect to avSimpleElectricSystem
    consumption = 200,                      -- in W
    voltage = {22, 29},                     -- min, max, in V
}

mechanical = {
    az = {math.rad(-180), math.rad(180)},      -- min, max, in rad
    el = {math.rad(-120), math.rad(30)},
    stabilization = true,
    max_airspeed = 850,                     -- kias
    station = 8,                            -- Weapon Station
    pos = {8.622,-0.649, 0},                     -- x along aircraft axis, y height, z lateral, in meters
    temperature = {-40, 55},                -- min, max, in deg celsius
}
if Type then
    mechanical.station = 12
end
local up = 0
local dn = 0
local l = 0
local r = 0
local lock = 0
local lockStatus = 0
local unit_h = get_param_handle('UNIT')
local flirParam = {
    FLIR_AZ = get_param_handle('FLIR_AZ'),
    FLIR_AZ_DEG = get_param_handle('FLIR_AZ_DEG'),
    FLIR_CAGED = get_param_handle('FLIR_CAGED'),
    FLIR_EL = get_param_handle('FLIR_EL'),
    FLIR_EL_DEG = get_param_handle('FLIR_EL_DEG'),
    FLIR_FOV = get_param_handle('FLIR_FOV'),
    FLIR_LASER_ON = get_param_handle('FLIR_LASER_ON'),
    FLIR_LOOK_ALT = get_param_handle('FLIR_LOOK_ALT'),
    FLIR_LOOK_EL = get_param_handle('FLIR_LOOK_EL'),
    FLIR_LOOK_AZ = get_param_handle('FLIR_LOOK_AZ'),
    FLIR_LOOK_LAT = get_param_handle('FLIR_LOOK_LAT'),
    FLIR_LOOK_LON = get_param_handle('FLIR_LOOK_LON'),
    FLIR_LOOK_WPT = get_param_handle('FLIR_LOOK_WPT'),
    FLIR_LOOK_WPT_SET = get_param_handle('FLIR_LOOK_WPT_SET'),
    FLIR_LOS_DIST = get_param_handle('FLIR_LOS_DIST'),
    FLIR_MODE = get_param_handle('FLIR_MODE'),
    FLIR_POL = get_param_handle('FLIR_POL'),
    FLIR_SEARCH = get_param_handle('FLIR_SEARCH'),
    FLIR_STATUS = get_param_handle('FLIR_STATUS'),
    FLIR_TGT_ALT = get_param_handle('FLIR_TGT_ALT'),
    FLIR_TGT_AVAILABLE = get_param_handle('FLIR_TGT_AVAILABLE'),
    FLIR_TGT_LAT = get_param_handle('FLIR_TGT_LAT'),
    FLIR_TGT_LON = get_param_handle('FLIR_TGT_LON'),
    FLIR_TRK = get_param_handle('FLIR_TRK'),
    FLIR_ZOOM = get_param_handle('FLIR_ZOOM')
}
local params = {
    FLIR_TGT_ALT_ = {get_param_handle('FLIR_TGT_ALT_'),0},
    FLIR_TGT_LAT_ = {get_param_handle('FLIR_TGT_LAT_'),''},
    FLIR_TGT_LON_ = {get_param_handle('FLIR_TGT_LON_'),''},
    EOTS_HUD_X = {get_param_handle('EOTS_HUD_X'),0},
    EOTS_HUD_Y = {get_param_handle('EOTS_HUD_Y'),0},
    FLIR_LASER_FLASH = {get_param_handle('FLIR_LASER_FLASH'),0,0,update_time_step},
}
local atkMode_h= get_param_handle('ATK_MODE')
local terrain = require('terrain')
function update()
    -- print_message_to_user("LR::avSimplestFLIR")
	local unit = unit_h:get()
    if unit==1 then
        params.FLIR_TGT_ALT_[2]=flirParam.FLIR_TGT_ALT:get()*METER_TO_INCH
    else
        params.FLIR_TGT_ALT_[2]=flirParam.FLIR_TGT_ALT:get()
    end
    local lat,lon = terrain.convertMetersToLatLon(flirParam.FLIR_TGT_LAT:get(),flirParam.FLIR_TGT_LON:get())
    params.FLIR_TGT_LAT_[2] = DD_to_DMS(lat,1)
    params.FLIR_TGT_LON_[2] = DD_to_DMS(lon,2)
    params.EOTS_HUD_X[2] = math.tan(flirParam.FLIR_AZ:get())*HUD_distance
    params.EOTS_HUD_Y[2] = math.tan(flirParam.FLIR_EL:get())*HUD_distance
    if flirParam.FLIR_LASER_ON:get()>0.9 then
        if params.FLIR_LASER_FLASH[3]>=1 then
            params.FLIR_LASER_FLASH[2] = 0
        elseif params.FLIR_LASER_FLASH[3]<=0 then
            params.FLIR_LASER_FLASH[2] = 1
        end
    else
        params.FLIR_LASER_FLASH[2] = 0
    end
    for k, v in pairs(params) do
        if type(v[3])~="nil" then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            v[1]:set(v[3])
        else
            v[1]:set(v[2])
        end
    end
end
--listen commands
    flir:listen_command(Keys.PlaneRadarUp)
	flir:listen_command(Keys.PlaneRadarDown)
    flir:listen_command(Keys.PlaneRadarLeft)
	flir:listen_command(Keys.PlaneRadarRight)
	flir:listen_command(Keys.PlaneRadarUpLeft)
	flir:listen_command(Keys.PlaneRadarUpRight)
	flir:listen_command(Keys.PlaneRadarDownLeft)
	flir:listen_command(Keys.PlaneRadarDownRight)
	flir:listen_command(flir_commands.WFOV)
	flir:listen_command(flir_commands.NFOV)
	flir:listen_command(flir_commands.SlewLeft)
	flir:listen_command(flir_commands.SlewRight)
	flir:listen_command(flir_commands.SlewUp)
	flir:listen_command(flir_commands.SlewDown)
	flir:listen_command(flir_commands.Power)
	flir:listen_command(flir_commands.Cage)
	flir:listen_command(JoyCmd.PlaneSelecterHorizontalAbs)
	flir:listen_command(JoyCmd.PlaneSelecterVerticalAbs)

    flir:listen_command(Keys.PlaneRadarStop)
	flir:listen_command(Keys.PlaneChangeLock)
    flir:listen_command(Keys.PlaneZoomIn)
    flir:listen_command(Keys.PlaneZoomOut)
    flir:listen_command(509) --lock start
	flir:listen_command(510) --lock finish
    flir:listen_command(MFD_click_cmd.FCS_HOLD_ON)
    flir:listen_command(MFD_click_cmd.FCS_HOLD_OFF)

function post_initialize()
    --print_message_to_user("LR::avSimplestFLIR")
end

function SetCommand(command, value)
 	--print_message_to_user("flir: command "..tostring(command).." = "..tostring(value))
	local flir = GetDevice(devices.FLIR)
	if atkMode_h:get()==2 then
        local flirMvSpd = 1
        if command == Keys.PlaneRadarUp and up == 0 then
            flir:SetCommand(flir_commands.SlewUp,flirMvSpd)
            up = 1
        elseif command == Keys.PlaneRadarDown and dn == 0 then
            flir:SetCommand(flir_commands.SlewDown,flirMvSpd)
            dn = 1
        elseif command == Keys.PlaneRadarLeft and l == 0 then
            flir:SetCommand(flir_commands.SlewLeft,flirMvSpd)
            l = 1
        elseif command == Keys.PlaneRadarRight and r == 0 then
            flir:SetCommand(flir_commands.SlewRight,flirMvSpd)
            r = 1
        elseif command == Keys.PlaneRadarUpLeft then
            flir:SetCommand(flir_commands.SlewUp,flirMvSpd)
            flir:SetCommand(flir_commands.SlewLeft,flirMvSpd)
            up=1
            l=1
        elseif command == Keys.PlaneRadarUpRight then
            flir:SetCommand(flir_commands.SlewUp,flirMvSpd)
            flir:SetCommand(flir_commands.SlewRight,flirMvSpd)
            up = 1
            r = 1
        elseif command == Keys.PlaneRadarDownLeft then
            flir:SetCommand(flir_commands.SlewDown,flirMvSpd)
            flir:SetCommand(flir_commands.SlewLeft,flirMvSpd)
            dn = 1
            l=1
        elseif command == Keys.PlaneRadarDownRight then
            flir:SetCommand(flir_commands.SlewDown,flirMvSpd)
            flir:SetCommand(flir_commands.SlewRight,flirMvSpd)
            dn = 1
            r = 1
        elseif command == Keys.PlaneRadarStop then
            if up == 1 then
                flir:SetCommand(flir_commands.SlewUp,0)
                up = 0
            end
            if dn == 1 then
                flir:SetCommand(flir_commands.SlewDown,0)
                dn = 0
            end
            if l == 1 then
                flir:SetCommand(flir_commands.SlewLeft,0)
                l = 0
            end
            if r == 1 then
                flir:SetCommand(flir_commands.SlewRight,0)
                r = 0
            end
		elseif command == JoyCmd.PlaneSelecterHorizontalAbs then
			if value >= 0 then
				flir:SetCommand(flir_commands.SlewRight, value)
			else
				flir:SetCommand(flir_commands.SlewLeft, math.abs(value))
			end
		elseif command == JoyCmd.PlaneSelecterVerticalAbs then
			if value >= 0 then
				flir:SetCommand(flir_commands.SlewUp, value)
			else
				flir:SetCommand(flir_commands.SlewDown, math.abs(value))
			end
        elseif command == Keys.PlaneZoomIn then
            flir:SetCommand(flir_commands.NFOV,1)
        elseif command == Keys.PlaneZoomOut then
            flir:SetCommand(flir_commands.WFOV,1)
        elseif command == MFD_click_cmd.FCS_HOLD_ON and value == 1 then
            flir:SetCommand(flir_commands.GainUp,1)
        elseif command == MFD_click_cmd.FCS_HOLD_OFF and value == 1 then
            flir:SetCommand(flir_commands.GainDown,1)
        elseif command == 509 then
            flir:SetCommand(flir_commands.TrackBrk,1)
        elseif command == 510 then
            if lockStatus == 0 then
                flir:SetCommand(flir_commands.Lock,1)
                lockStatus = 1
            else
                flir:SetCommand(flir_commands.Freeze,1)
                lockStatus = 0
            end
        end
    end
end

need_to_be_closed = false


