-- //    :
-- const int InfraredSeeker = 1;    //  IR (infrared seeker)
-- const int ActiveRadar        = 2;    // - (active radar (AR) (+)) 
-- const int AntiRadar          = 3;    //  (  +)
-- const int LaserHoming        = 4;    //   (+)
-- const int Autopilot          = 5;    //  (+, GPS,TV,IIR...)
-- const int SemiActiveRadar    = 6;    // - semi-active radar (SAR) -
-- const int SemiAutoAT	    = 7;	//      ,   woPoint,  woPoint  .

-- struct WEAPONS_API Rocket_Const //       . 
            -- //  
    -- unsigned char Name_;     //   
    -- int           Escort_;   //  : 0 - , 1 -  , 2 -  , 3 - c 
    -- int           Head_Type_;//    ()(c ) 
	--				sigma = {x, y, z},     ,   . x -   , y -   , z -   
    -- float         M_;        //     
    -- float         H_max_;    //    . 
    -- float         H_min_;    //    .  
    -- float         Diam_;     //      
    -- int           Cx_pil;    //  Cx  
    -- float         D_max_;    //       
    -- float         D_min_;    //    
    -- bool          Head_Form_;// false -   , 
                   -- // true   -  (~)
    -- float         Life_Time_;//    ( ), 
    -- double        Nr_max_;   //    
    -- float         v_min_;    //  . 
    -- float    v_mid_;  //  
    -- float         Mach_max_; //   .
    -- float         t_b_;      //   
    -- float         t_acc_;    //   
    -- float         t_marsh_;  //     
    -- float         Range_max_;//      
    -- float         H_min_t_;  //     , .     
    -- float         Fi_start_; //        
    -- float         Fi_rak_;   //     (rad)
    -- float         Fi_excort_;//   (.)  .
    -- float          Fi_search_;//    
    -- float          OmViz_max_;//    
    -- float         Damage_;// ,    
	-- /*   int           Engine_Type_; //  : 1 - ;
                             -- // 2 -   ()(); 
                             -- // 3 -    ; 
                             -- // 4 - -1+.
                             -- // 5 - 
                             -- // 6 -  +  
    -- int           Stage_;    //  .*/
    -- float         X_back_;   //      
    -- float         Y_back_; 
    -- float         Z_back_;
	-- float		 X_back_acc_; //       
	-- float		 Y_back_acc_;
	-- float		 Z_back_acc_;
    -- float          Reflection;   //   ,  

    -- // Kill distances - this distance is used to fire a fuze
    -- double        KillDistance;

    -- // These are warheads used to simulate explosions
    -- // Due to the architecture of blocksim we have to use two schemes - 
    -- // one for server object (which actually makes damage), and other for
    -- // client object (which does not make any damage)
	
	--    :
	--   +- 1 
	--   +- 5 

    
--Tail smoke color format {R, G, B, alpha}
--All values from 0 to 1
tail_solid = { 1, 1, 1, 1 };
tail_liquid = {0.9, 0.9, 0.9, 0.05 };

-- ATG Missiles' flight speed is too low. Need correction.
local ATGMMissiles_VelocityAdaptationCoeff = 340/295*340/295; -- woMissile.cpp: l. 906,907.

rockets = 
{
    {
        Name = R_550, -- R.550 Magic 2
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3}, 
        M = 89.0,
        H_max = 28000.0,
        H_min = 1.0,
        Diam = 157.0,
        Cx_pil = 2,
        D_max = 4000.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 40,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 1.88,
        t_marsh = 0.0,
        Range_max = 10000.0,
        H_min_t = 10.0,
        Fi_start = 0.96,
        Fi_rak = 3.14152,
        Fi_excort = 0.96,
        Fi_search = 0.09,
        OmViz_max = 0.52,
        warhead = warheads["R_550"],
        exhaust = tail_solid,
        X_back = -1.15,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 5.0,
		--seeker sensivity params
		SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. 
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
		ModelData = {   58 ,  -- model params count
						0.35 ,   -- characteristic square ( )
						
						--   x
						0.05 , -- Cx_k0  x0   ( M << 1)
						0.18 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.15, -- Cx_k3  Cx0   ( M >> 1)
						1.0 , -- Cx_k4      
						1.0 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.9	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	1.88,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	12.58,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	29750.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 20, --  , 
						 20.0, --   , 
						 0, --   , 
						 0.3, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 11000.0, --     180() ,  =10000, V=900/, 
						 4000.0, --   0( ) ,  =10000, V=900/, 
						 5000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 1.0, --  .        .     .
						 1.4, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					},
    },
    {
        Name = MICA_T, --MICA-IR
        Escort = 0,
        Head_Type = 1,
		sigma = {4, 4, 4},
        M = 110.0,
        H_max = 28000.0,
        H_min = 1.0,
        Diam = 160.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 24,
        v_min = 140.0,
        v_mid = 450.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 4.0,
        Range_max = 40000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.09,
        OmViz_max = 0.52,
        warhead = warheads["MICA_T"],
        exhaust = tail_solid,
        X_back = -1.072,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 7.0,
		--seeker sensivity params
		SeekerSensivityDistance = 25000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		ccm_k0 = 0.2,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
		
			ModelData = {   58 ,  -- model params count
						0.5 ,   -- characteristic square ( )
						
						--   x
						0.16 , -- Cx_k0  x0   ( M << 1)
						0.2 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.08, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						1.0 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	6.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	7.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	20000.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --   ,    ""         (      ),  
						 1.0e9, --      ,       "", 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
		
		
    },
    {
        Name = MICA_R, --MICA-RF
        Escort = 0,
        Head_Type = 2,
		sigma = {5.6, 5, 5.6},
        M = 110.0,
        H_max = 28000.0,
        H_min = 1.0,
        Diam = 160.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 60.0,
        Nr_max = 24,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 4.0,
        Range_max = 45000.0,
        H_min_t = 10.0,
        Fi_start = 1.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["MICA_R"],
        exhaust = tail_solid,
        X_back = -1.072,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 7.0,
		
		
			ModelData = {   58 ,  -- model params count
						0.5 ,   -- characteristic square ( )
						
						--   x
						0.15 , -- Cx_k0  x0   ( M << 1)
						0.18 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.043, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						1.0 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	6.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	7.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	20000.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --   ,    ""         (      ),  
						 1.0e9, --      ,       "", 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
		
    },
    {
        Name = Super_530D, --Super-530D
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 270.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 263.0,
        Cx_pil = 3,
        D_max = 12000.0,
        D_min = 600.0,
        Head_Form = 1,
        Life_Time = 55.0,
        Nr_max = 25,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 40000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 1.0,
        OmViz_max = 0.35,
        warhead = warheads["Super_530D"],
        exhaust = tail_solid,
        X_back = -1.202,
        Y_back = -0.0,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 10.0,
		ModelData = {   58 ,  -- model params count
						1.2 ,   -- characteristic square ( )
						
						--   x
						0.04 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.05 , -- Cx_k2       
						0.04, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.0 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.4 , -- Cy_k0  y0   ( M << 1)
						0.5	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.26 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	2.0,  		8.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	6.85,		5.375,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	38000.0,	15250.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 55.0, --  , 
						 55.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --   ,    ""         (      ),  
						 1.0e9, --      ,       "", 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 4800.0, --        Navail >= 1.0   H=2000
						 2.2, --           Navail >= 1.0   H
						 30.0, --        
						 0.75, --  .   
						 32.0, --     
						  -- DLZ.      (  )
						 35000.0, --     180() ,  =10000, V=900/, 
						 8000.0, --   0( ) ,  =10000, V=900/, 
						 12000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 0.7, --  .        .     .
						 2.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					},
    },
    {
        Name = P_40T, --R-40T
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 475.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 355.0,
        Cx_pil = 4,
        D_max = 7000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 65.0,
        Nr_max = 12,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.8,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 32000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_40T"],
        exhaust = tail_solid,
        X_back = -2.276,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 7.0,
		--seeker sensivity params
		SeekerSensivityDistance = 15000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
		ModelData = {   58 ,  -- model params count
						1.1 ,   -- characteristic square ( )
						
						--   x
						0.15 , -- Cx_k0  x0   ( M << 1)
						0.14 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.017, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.4 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.38  , -- Cy_k2  ()     
						
						0.23 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	6.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	25.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	50000.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 120.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1e9, --      ,       "", 
						 1e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
    },
    {
        Name = P_40R, --R-40R
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 475.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 355.0,
        Cx_pil = 4,
        D_max = 15000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 75.0,
        Nr_max = 12,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.8,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 40000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_40R"],
        exhaust = tail_solid,
        X_back = -2.276,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 7.0,

		ModelData = {   58 ,  -- model params count
						1.1 ,   -- characteristic square ( )
						
						--   x
						0.12 , -- Cx_k0  x0   ( M << 1)
						0.14 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.012, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.4 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.38  , -- Cy_k2  ()     
						
						0.23 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	6.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	25.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	50000.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 120.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1e9, --      ,       "", 
						 1e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
    },
    {
        Name = P_24R, --R-24R
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 215.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 200.0,
        Cx_pil = 3,
        D_max = 12000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 35000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_24R"],
        exhaust = tail_solid,
        X_back = -1.3281,
        Y_back = -0.102,
        Z_back = 0.0,
        Reflection = 0.036,
        KillDistance = 6.0,
		
		ModelData = {   58 ,  -- model params count
						0.9 ,   -- characteristic square ( )
						--   x
						0.05 , -- Cx_k0  x0   ( M << 1)
						0.12 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.07 , -- Cx_k3  Cx0   ( M >> 1)
						1.2  , -- Cx_k4      
						1.2  , --   
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						
						0.239 , -- 7 Alfa_max    , 
						0.0, --     
						
						--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,   6.0   ,   0.0,  0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   10.0   ,  0.0,  0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /)
						 0.0,     0.0 ,   40000.0,  0.0 , 0.0,         0.0,      0.0,           -- thrust 6000 by doc
						
						 1.0e9, --  , 
						 60.0, --   
						 0, --     , 
						 0.4, --    , 
						 1.0e9, -- 5000.0, --      ,       
						 1.0e9, -- 10000.0, --     ,        (     ) 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
    },
    {
        Name = P_24T, --R-24T
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 215.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 200.0,
        Cx_pil = 3,
        D_max = 10000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 100.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 25000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.96,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_24T"],
        exhaust = tail_solid,
        X_back = -1.328,
        Y_back = -0.101,
        Z_back = 0.0,
        Reflection = 0.0352,
        KillDistance = 6.0,
		--seeker sensivity params
		SeekerSensivityDistance = 15000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.		
		ModelData = {   58,  -- model params count
						0.9 ,   -- characteristic square ( )
						--   x
						0.06 , -- Cx_k0  x0   ( M << 1)
						0.14 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.1 , -- Cx_k3  Cx0   ( M >> 1)
						1.2  , -- Cx_k4      
						1.2  , --   
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						
						0.239 , -- 7 Alfa_max    , 
						0.0, --     
						
						--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,   6.0   ,   0.0,  0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   10.0   ,  0.0,  0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /)
						 0.0,     0.0 ,   40000.0,  0.0 , 0.0,         0.0,      0.0,           -- thrust 6000 by doc
						
						 1.0e9, --  , 
						 60.0, --   
						 0, --     , 
						 0.4, --    , 
						 1.0e9, -- 5000.0, --      ,       
						 1.0e9, -- 10000.0, --     ,        (     ) 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
    },
    {
        Name = P_60, --R-60
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 44.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 130.0,
        Cx_pil = 2.18,
        D_max = 4000.0,
        D_min = 200.0,
        Head_Form = 0,
        Life_Time = 20.0,
        Nr_max = 42,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 12000.0,
        H_min_t = 1.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["P_60"],
        exhaust = tail_solid,
        X_back = -1.166,
        Y_back = -0.069,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 3.0,
		--seeker sensivity params
		SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.		
		ModelData = {   58 ,  -- model params count
						0.2 ,   -- characteristic square ( )
						
						--   x
						0.1 , -- Cx_k0  x0   ( M << 1)
						0.1 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	4.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	2.6,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	6250.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 30.0, --  , 
						 25.0, --   , 
						 0, --   , 
						 0.3, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 5450.0,
						 0.627,
						 0.527,
						 0.75,
						 23,
						  -- DLZ.      (  )
						 13000.0, --     180() ,  =10000, V=900/, 
						 6000.0, --   0( ) ,  =10000, V=900/, 
						 7000.0, --   	180() , =1000, V=900/, 
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
    },
    {
        Name = P_33E, --R-33
        Escort = 0,
        Head_Type = 2,
		sigma = {10, 10, 10},
        M = 520.0,
        H_max = 28000.0,
        H_min = 10.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 40000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 360.0,
        Nr_max = 12,
        v_min = 140.0,
        v_mid = 800.0,
        Mach_max = 4.5,
        t_b = 0.1,
        t_acc = 6.0,
        t_marsh = 25.0,
        Range_max = 120000.0,
        H_min_t = 25.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_33E"],
        exhaust = tail_solid,
        X_back = -1.948,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.079,
        KillDistance = 12.0,
		
		ModelData = {   58 ,  -- model params count
						1.1 ,   -- characteristic square ( )
						
						--   x
						0.07 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.012, -- Cx_k3  Cx0   ( M >> 1)
						2.5 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.6 , -- Cy_k0  y0   ( M << 1)
						0.3	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.2 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	5.0,  		15.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	20.0,		3.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	70000.0,	12000.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 120.0, --   , 
						 0, --   , 
						 2.5, --     ( , ), 
						 80000.0, --      ,       "", 
						 80000.0, --   ,    ""         (      ),  
						 0.15,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
		
    },
	{
        Name = P_27P, --R-27R
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 253.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 230.0,
        Cx_pil = 2.21,
        D_max = 14000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 24,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 4.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 35000.0,
        H_min_t = 20.0,
        Fi_start = 0.87,
        Fi_rak = 3.14152,
        Fi_excort = 0.97,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_27P"],
        exhaust = tail_solid,
        X_back = -1.34,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.0479,
        KillDistance = 11.0,
		
		ModelData = {   58 ,  -- model params count
						0.9 ,   -- characteristic square ( )
						--   x
						0.038 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.045 , -- Cx_k3  Cx0   ( M >> 1)
						2.5  , -- Cx_k4      
						1.2  , --   
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
						--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,   6.0   ,   0.0,  0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   11.3   ,  0.0,  0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /),   68 .
						 0.0,     0.0 ,   25620.0,  0.0 , 0.0,         0.0,      0.0,           -- thrust 6000 by doc
						
						 1.0e9, --  , 
						 60.0, --   
						 0, --     , 
						 0.4, --    , 
						 1.0e9, -- 5000.0, --      ,       
						 1.0e9, -- 10000.0, --     ,        (     ) 
						 0.0,  --      
						 50.0, --    
						 0.0,
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 5000.0, --        Navail >= 1.0   H=2000
						 2.2, --           Navail >= 1.0   H
						 30.0, --        
						 0.75, --  .   
						 32.0, --     
						  -- DLZ.      (  )
						 35000.0, --     180() ,  =10000, V=900/, 
						 13000.0, --   0( ) ,  =10000, V=900/
						 15000.0, --   	180() , =1000, V=900/
						 0.5,     --              
						 0.3, --  .        .     .
						 2.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					}, 
    },
    {
        Name = P_27PE, --R-27ER
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 350.0,
        H_max = 27000.0,
        H_min = 1.0,
        Diam = 265.0,
        Cx_pil = 2.21,
        D_max = 14000.0, -- Max range at sea level. Use AI only.
        D_min = 500.0, -- Min range. Use AI only.
        Head_Form = 1,
        Life_Time = 1.0e9, -- Not used
        Nr_max = 24, -- Not used
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0, -- Not used
        t_acc = 4.0, -- Not used
        t_marsh = 6.0, -- Not used
        Range_max = 60000.0, -- Max range at max altitude. Use AI only.
        H_min_t = 20.0,
        Fi_start = 0.87, --  
        Fi_rak = 3.14152, --  
        Fi_excort = 0.97, --  
        Fi_search = 0.1, --   
        OmViz_max = 0.35,
        warhead = warheads["P_27PE"],
        exhaust = tail_solid,
        X_back = -2.0,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 11.0,
		
		ModelData = {   58 ,  -- model params count
						0.9 ,   -- characteristic square ( )
						
						--   x
						0.07 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.035, -- Cx_k3  Cx0   ( M >> 1)
						2.5 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	3.0,  		7.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	31.9,		6.32,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /),   140 
						 0.0,		0.0,	73500.0,	14560.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 1.5, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 8500.0, --        Navail >= 1.0   H=2000
						 5.5, -- .    
						 30.0, --        
						 0.75, --  .   
						 54.0, --     
						  -- DLZ.      (  )
						 60000.0, --     180() ,  =10000, V=900/, 
						 25000.0, --   0( ) ,  =10000, V=900/, 
						 25000.0, --   	180 , =1000, V=900/, 
						 0.5, --             .
						 0.3, --  .        .     .
						 2.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.7, --            .
					}, 
    },
    {
        Name = P_27T, --R-27T
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 245.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 230.0,
        Cx_pil = 2.23,
        D_max = 11000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 90.0,
        Nr_max = 24,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 25000.0,
        H_min_t = 1.0,
        Fi_start = 0.87,
        Fi_rak = 3.14152,
        Fi_excort = 0.97,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_27T"],
        exhaust = tail_solid,
        X_back = -1.34,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.0445,
        KillDistance = 11.0,
		--seeker sensivity params
		SeekerSensivityDistance = 25000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.		
		ModelData = {   58,  -- model params count
						0.9 ,   -- characteristic square ( )
						
						--   x
						0.038 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05 , -- Cx_k3  Cx0   ( M >> 1)
						2.5  , -- Cx_k4      
						1.2  , --   
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
												
						--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,   6.0   ,   0.0,      0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   11.3   ,  0.0,     0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /)
						 0.0,     0.0 ,   25620.0,  0.0 , 0.0,         0.0,      0.0,           -- thrust
						 
						 1.0e9, --  , 
						 60.0, --   
						 0, --   , 
						 0.4, --    , 
						 1.0e9, --      ,       
						 1.0e9, --     ,        (     ) 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 4800.0, --        Navail >= 1.0   H=2000
						 2.2, --           Navail >= 1.0   H
						 30.0, --        
						 0.75, --  .   
						 32.0, --     
						  -- DLZ.      (  )
						 27000.0, --     180() ,  =10000, V=900/, 
						 11000.0, --   0( ) ,  =10000, V=900/, 
						 12000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 0.7, --  .        .     .
						 2.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
						 }, 
    },
    {
        Name = P_27TE, --R-27ET
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 343.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 260.0,
        Cx_pil = 2.5,
        D_max = 20000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 90.0,
        Nr_max = 24,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 6.0,
        Range_max = 54000.0,
        H_min_t = 1.0,
        Fi_start = 0.87,
        Fi_rak = 3.14152,
        Fi_excort = 0.97,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_27TE"],
        exhaust = tail_solid,
        X_back = -2.0,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 11.0,
		--seeker sensivity params
		SeekerSensivityDistance = 25000, -- The range of target with IR value = 1. In meters.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
		ModelData = {   58 ,  -- model params count
						0.9 ,   -- characteristic square ( )
						
						--   x
						0.08 , -- Cx_k0  x0   ( M << 1)
						0.09 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						2.5 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	3.0,  		7.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	31.9,		6.32,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	73500.0,	14560.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 8000.0, --        Navail >= 1.0   H=2000
						 5.5, --           Navail >= 1.0   H
						 30.0, --        
						 0.75, --  .   
						 54.0, --     
						  -- DLZ.      (  )
						 58000.0, --     180() ,  =10000, V=900/, .
						 20000.0, --   0( ) ,  =10000, V=900/, .
						 24000.0, --   	180  (), =1000, V=900/, .
						 0.6, --             .
						 0.7, --  .        .     .
						 1.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					}, 
    },
    
    {
        Name = P_73, --R-73
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 105.0,
        H_max = 20000.0,
        H_min = -1,
        Diam = 170.0,
        Cx_pil = 1.9,
        D_max = 4000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 45,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.8,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 3.0,
        Range_max = 12000.0,
        H_min_t = 1.0,
        Fi_start = 0.79,
        Fi_rak = 3.14152,
        Fi_excort = 1.31,
        Fi_search = 0.09,
        OmViz_max = 1.05,
        warhead = warheads["P_73"],
        exhaust = tail_solid,
        X_back = -1.1,
        Y_back = -0.09,
        Z_back = 0.0,
        Reflection = 0.0262,
        KillDistance = 5.0,
		--seeker sensivity params
		SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
		
		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square ( )
						
						--   x
						0.05 , -- Cx_k0  x0   ( M << 1)
						0.12 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.062, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.0 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.78 , -- 7 Alfa_max    , 
						0.6, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	5.5,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	6.18,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	13847.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 23.0, --   , 
						 0, --   , 
						 0.35, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 8000.0, --        Navail >= 1.0   H=2000
						 1.077, --           Navail >= 1.0   H
						 0.9,
						 0.75, --  .   
						 28.0, --   
						  -- DLZ.      (  )
						 19000.0, --     180() ,  =10000, V=900/, 
						 6000.0, --   0( ) ,  =10000, V=900/, 
						 10000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 1.0, --  .        .     .
						 1.4, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					},
		
    },
    {
        Name = P_77, --R-77
        Escort = 0,
        Head_Type = 2,
		sigma = {5.6, 5, 5},
        M = 190.0,
        H_max = 20000.0,
        H_min = 1.0,
        Diam = 190.0,
        Cx_pil = 3.0,
        D_max = 15000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 40,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 6.0,
        Range_max = 50000.0,
        H_min_t = 3.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["P_77"],
        exhaust = tail_solid,
        X_back = -1.038,
        Y_back = -0.099,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 15.0,
		
		ModelData = {   58 ,  -- model params count
						0.6 ,   -- characteristic square ( )
						
						--   x
						0.07 , -- Cx_k0  x0   ( M << 1)
						0.1 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.015, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	7.85,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	8.57,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	22216.6,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 70.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 40000, --      ,       "", 
						 40000, --   ,    ""         (      ),  
						 0.17,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 25200.0, --        Navail >= 1.0   H=2000
						 2.9, --           Navail >= 1.0   H
						 2.5,
						 0.75, --  .   
						 52.0, --   
						  -- DLZ.      (  )
						 63000.0, --     180() ,  =10000, V=900/, 
						 24000.0, --   0( ) ,  =10000, V=900/
						 34000.0, --   	180() , =1000, V=900/
						 0.2, --             .
						 0.7, --  .        .     .
						 1.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .

					},
    },

   
    {
        Name = AIM_7, --AIM-7M
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 230.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 203.0,
        Cx_pil = 2.21,
        D_max = 20000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 25,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 3.3,
        t_marsh = 11.0,
        Range_max = 50000.0,
        H_min_t = 15.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["AIM_7"],
        exhaust = {0.78, 0.78, 0.78, 0.3};
        X_back = -1.8,
        Y_back = -0.11, --0.0,
        Z_back = 0.0, -- -0.1,
        Reflection = 0.0366,
        KillDistance = 12.0,
        ccm_k0 = 1.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		ModelData = {   58 ,  -- model params count
						0.9 ,   -- characteristic square ( )
				
						--   x
						0.03 , --  x0   ( M << 1)
						0.08 , --    
						0.02 , --       
						0.03 , --  Cx0   ( M >> 1)
						2.5  , --      
						1.0  , --   
						
						--   Cy
						0.7 , --  y0   ( M << 1)
						0.6	 , --  Cy0   ( M >> 1)
						1.2  , --  ()     

						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,  	3.26  ,  10.86,      0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   	11.8 ,  2.0,     0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /)
						 0.0,     0.0 ,   30645.0,  5194.0,   0.0,         0.0,      0.0,           -- thrust
					
						 1.0e9, --  , 
						 75.0, --   
						 0.0, --   , 
						 1.5, --    , 
						 1.0e9, --      ,       
						 1.0e9, --     ,        (     ) 
						 0.0,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 50000.0, --     180() ,  =10000, V=900/, 
						 18000.0, --   0( ) ,  =10000, V=900/
						 20000.0, --   	180() , =1000, V=900/
						 0.2,     --              
						 0.7, --  .        .     .
						 2.0, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					}, 
    },
    {
        Name = SeaSparrow, --RIM-7
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 230.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 203.0,
        Cx_pil = 4,
        D_max = 27000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 160.0,
        Nr_max = 32,
        v_min = 70.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 3.0,
        Range_max = 27500.0,
        H_min_t = 20.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.6,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SeaSparrow"],
        exhaust = tail_solid,
        X_back = -1.422,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0366,
        KillDistance = 10.0,
		ModelData = {   58 ,  -- model params count
						0.7 ,   -- characteristic square ( )
				
						--   x
						0.04 , --  x0   ( M << 1)
						0.12 , --    
						0.02 , --       
						0.066 , --  Cx0   ( M >> 1)
						1.2  , --      
						1.2  , --   
						
						--   Cy
						1.0 , --  y0   ( M << 1)
						0.8	 , --  Cy0   ( M >> 1)
						1.2  , --  ()     

						0.4 , -- 7 Alfa_max    , 
						0.0, --     
						
					--	t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
						-1.0,    -1.0 ,   3.2   ,  6.0,      0.0,		   0.0,      1.0e9,           -- time interval
						 0.0,     0.0 ,   4.53   ,  2.0,     0.0,         0.0,      0.0,           -- fuel flow rate in second kg/sec(    /)
						 0.0,     0.0 ,   50557.0,  25528.0,   0.0,         0.0,      0.0,           -- thrust
					
						 1.0e9, --  , 
						 60.0, --   
						 0, --   , 
						 1.0, --    , 
						 10000.0, --      ,       
						 15000.0, --     ,        (     ) 
						 0.17,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
    },
    {
        Name = AIM_9, --AIM-9M
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 88.0,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 7000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 40,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 14000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["AIM_9"],
        exhaust = { 0.7, 0.7, 0.7, 0.08 };
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0,
        Reflection = 0.0182,
        KillDistance = 7.0,
		--seeker sensivity params
		SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
		ModelData = {   58 ,  -- model params count
						0.35 ,   -- characteristic square ( )
						
						--   x
						0.04 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.0 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.9 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.4 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	5.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	5.44,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	12802.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 0.3, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 -- DLZ.      (  )
						 11000.0, --     180() ,  =10000, V=900/, 
						 5000.0, --   0( ) ,  =10000, V=900/, 
						 5000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 1.0, --  .        .     .
						 1.4, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					},
		
		
    },
    {
        Name = AIM_9P, --AIM-9P
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 4000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 0.0,
        Range_max = 11000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["AIM_9P"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
		--seeker sensivity params
		ccm_k0 = 1.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	--seeker sensivity params
		SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
		SeekerCooled			= false, -- True is cooled seeker and false is not cooled seeker.				
		
		ModelData = {   58 ,  -- model params count
						0.35 ,   -- characteristic square ( )
						
						--   x
						0.04 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	3.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	8.0,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	18800.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 30.0, --   , 
						 0, --   , 
						 0.5, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 9000.0, --     180() ,  =10000, V=900/, 
						 4000.0, --   0( ) ,  =10000, V=900/, 
						 4000.0, --   	180() , =1000, V=900/, 
						 0.2, --             .
						 1.0, --  .        .     .
						 1.4, --  .        .     .
						-3.0, --  .     ,  -  .
						0.5, --            .
					},
    },
    {
        Name = AIM_9X, --AIM-9X
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 7000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 14000.0,
        H_min_t = 1.0,
        Fi_start = 1.0,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["AIM_9X"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
    },
    {
        Name = AIM_54, --AIM-54
        Escort = 0,
        Head_Type = 2,
		sigma = {10, 10, 10},
        M = 463.0,
        H_max = 24400.0,
        H_min = 15.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 60000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 12,
        v_min = 140.0,
        v_mid = 800.0,
        Mach_max = 4.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 40.0,
        Range_max = 140000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.87,
        OmViz_max = 0.35,
        warhead = warheads["AIM_54"],
        exhaust = tail_solid,
        X_back = -1.794,
        Y_back = -0.195,
        Z_back = 0.0,
        Reflection = 0.076,
        KillDistance = 15.0,
		
		ModelData = {   58 ,  -- model params count
						1.1 ,   -- characteristic square ( )
						
						--   x
						0.07 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.012, -- Cx_k3  Cx0   ( M >> 1)
						2.5 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						
						--   Cy
						0.6 , -- Cy_k0  y0   ( M << 1)
						0.3	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.2 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	5.0,  		22.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	20.0,		3.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	70000.0,	12000.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 120.0, --   , 
						 0, --   , 
						 2.5, --     ( , ), 
						 80000.0, --      ,       "", 
						 80000.0, --   ,    ""         (      ),  
						 0.15,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					}, 
		
    },
    {
        Name = AIM_120, -- AIM-120B
        Escort = 0,
        Head_Type = 2,
		sigma = {5, 5, 5},
        M = 156.0,
        H_max = 20000.0,
        H_min = 1.0,
        Diam = 169.0,
        Cx_pil = 2.5,
        D_max = 14000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 40,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 57000.0,
        H_min_t = 3.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["AIM_120"],
        exhaust = {0.8, 0.8, 0.8, 0.05 };
        X_back = -1.61,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.0329,
        KillDistance = 15.0,
		
		ModelData = {   58 ,  -- model params count
						0.5 ,   -- characteristic square ( )
						
						--   x
						0.05 , -- Cx_k0  x0   ( M << 1)
						0.09 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.018, -- Cx_k3  Cx0   ( M >> 1)
						1.5 , -- Cx_k4      
						1.5 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.8 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	4.0,  		4.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	7.69,		3.94,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	19600.0,	10045.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 80.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 40000, --      ,       "", 
						 40000, --   ,    ""         (      ),  
						 0.17,  --      
						 50.0, --    
						 0.0,
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 19700.0, --        Navail >= 1.0   H=2000
						 3.69, --           Navail >= 1.0   H
						 3.2,
						 0.75, --  .   
						 67.0, --   
						  -- DLZ.      (  )
						  -- DLZ.      (  )
						 43000.0, --     180() ,  =10000, V=900/, 
						 20000.0, --   0( ) ,  =10000, V=900/
						 20000.0, --   	180() , =1000, V=900/
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
    },
    {
        Name = AIM_120C, -- AIM-120C
        Escort = 0,
        Head_Type = 2,
		sigma = {5, 5, 5},
        M = 161.5,
        H_max = 26000.0,
        H_min = 1.0,
        Diam = 160.0,
        Cx_pil = 2.5,
        D_max = 16000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 40,
        v_min = 140.0,
        v_mid = 700.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 6.0,
        Range_max = 61000.0,
        H_min_t = 1.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["AIM_120C"],
        exhaust = {0.8, 0.8, 0.8, 0.05 };
        X_back = -1.61,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.0329,
        KillDistance = 15.0,
		
		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square ( )
						
						--   x
						0.045 , -- Cx_k0  x0   ( M << 1)
						0.09 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.016, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.5 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.7 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	8.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	6.41,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	16325.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 100.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 40000, --      ,       "", 
						 40000, --   ,    ""         (      ),  
						 0.17,  --      
						 50.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 25200.0, --        Navail >= 1.0   H=2000
						 3.92, --           Navail >= 1.0   H
						 3.2,
						 0.75, --  .   
						 70.0, --   
						  -- DLZ.      (  )
						 63000.0, --     180() ,  =10000, V=900/, 
						 25000.0, --   0( ) ,  =10000, V=900/
						 22000.0, --   	180() , =1000, V=900/
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
    },
    {
        Name = X_22, --Kh-22
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 6800.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 1000.0,
        Cx_pil = 8,
        D_max = 140000.0,
        D_min = 40000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 6,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 3.5,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 50.0,
        Range_max = 300000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_22"],
        exhaust = tail_liquid,
        X_back = -5.7,
        Y_back = -0.487,
        Z_back = 0.0,
        Reflection = 0.82, -- RCS, square meters
        KillDistance = 0.0,
    },
    {
        Name = X_23, --Kh-23
        Escort = 1,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 288.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 4,
        D_max = 5000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_23"],
        exhaust = tail_solid,
        X_back = -0.86,
        Y_back = -0.14,
        Z_back = 0.0,
        Reflection = 0.0795,
        KillDistance = 5.0,
    },
    {
        Name = X_23L, --Kh-23L
        Escort = 1,
        Head_Type = 4,
		sigma = {10, 10, 10},
        M = 288.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 4,
        D_max = 5000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_23L"],
        exhaust = tail_solid,
        X_back = -0.86,
        Y_back = -0.14,
        Z_back = 0.0,
        Reflection = 0.0791,
        KillDistance = 0.0,
    },
    {
        Name = X_28, --Kh-28
        Escort = 0,
        Head_Type = 3,
		sigma = {15, 15, 15},
        M = 715.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 430.0,
        Cx_pil = 5,
        D_max = 90000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 500.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 500.0,
        Range_max = 90000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_28"],
        exhaust = tail_liquid,
        X_back = -2.440,
        Y_back = -0.210,
        Z_back = 0.0,
        Reflection = 0.15,
        KillDistance = 0.0,
    },
    {
        Name = X_25ML, --Kh-25ML
        Escort = 1,
        Head_Type = 4,
		sigma = {8, 8, 8},
        M = 316.0,
        H_max = 5000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 7000.0,
        D_min = 2500.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 4.0,
        Range_max = 8000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 0.7,
        OmViz_max = 0.12,
        warhead = warheads["X_25ML"],
        exhaust = {0.63, 0.67, 0.75, 0.2};
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.09,
        KillDistance = 0.0,
		
		
		ModelData = {   58 ,  -- model params count
						1.1 ,   -- characteristic square ( )
						
						--   x
						0.04 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						2.5 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.2	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.2 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	2.0,  		7.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	11.05,		8.62,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	22540.0,	17640.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 25.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 1.0,
						 1.0,
						 1.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
	}, 
	}, 
    {
        Name = X_25MP, --Kh-25MP
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 310.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 27000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 150.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.65,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 9.0,
        Range_max = 60000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_25MP"],
        exhaust = {0.63, 0.67, 0.75, 0.2};
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.09,
        KillDistance = 5.0,
    },
    {
        Name = X_25MR, --Kh-25MR
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 6, 5.6},
        M = 300.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 8000.0,
        D_min = 3000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 4.0,
        Range_max = 20000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_25MR"],
        exhaust = {0.63, 0.67, 0.75, 0.2};
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.09,
        KillDistance = 0.0,
    },
    {
        Name = X_58, --Kh-58
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 640.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 19.64,
        D_max = 40000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1000.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 3.6,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 15.0,
        Range_max = 100000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_58"],
        exhaust = tail_solid,
        X_back = -1.44,
        Y_back = -0.225,
        Z_back = 0.0,
        Reflection = 0.15,
        KillDistance = 5.0,
    },
    {
        Name = X_59M, --Kh-59M
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 850.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 19.64,
        D_max = 115000.0,
        D_min = 10000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 500.0,
        Range_max = 80000.0,
        H_min_t = 0.0,
        Fi_start = 0.37,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_59M"],
        -- No exhaust (turbo)
		exhaust1 = tail_solid,
        X_back = -1.6,
        Y_back = -0.7,
        Z_back = 0.0,
		-- accelerator exhaust coords
		X_back_acc = -3.0,
        Y_back_acc = -0.212,
        Z_back_acc = 0.0,
        Reflection = 0.1914,
        KillDistance = 0.0,
    },
    {
        Name = X_29L, --Kh-29L
        Escort = 1,
        Head_Type = 4,
		sigma = {8, 8, 8},
        M = 657.0,
        H_max = 5000.0,
        H_min = 0.2,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 8000.0,
        D_min = 3000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 10, --   -24
        v_min = 170.0,
        v_mid = 220.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 13000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.12,
        warhead = warheads["X_29L"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.196,
        Z_back = 0.0,
        Reflection = 0.175,
        KillDistance = 0.0,
    },
    {
        Name = X_29T, --Kh-29T
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 670.0,
        H_max = 5000.0,
        H_min = 0.2,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 10000.0,
        D_min = 3000.0,
        Head_Form = 0,
        Life_Time = 120.0,
        Nr_max = 10, --   -24
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 1.4,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 15000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_29T"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.202,
        Z_back = 0.0,
        Reflection = 0.1729,
        KillDistance = 0.0,
    },
    {
        Name = X_29TE, --Kh-29TE
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 690.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 20000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 16.0,
        t_marsh = 150.0,
        Range_max = 30000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_29TE"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.202,
        Z_back = 0.0,
        Reflection = 0.1729,
        KillDistance = 0.0,
    },
    {
        Name = X_55, --Kh-55
        Escort = 0,
        Head_Type = 5,
		sigma = {20, 20, 20},
        M = 1250.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 514.0,
        Cx_pil = 19.9,
        D_max = 600000.0,
        D_min = 9000.0,
        Head_Form = 0,
        Life_Time = 9200.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 230.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 9200.0,
        Range_max = 600000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_55"],
        -- No exhaust (turbo)
        X_back = -2.356,
        Y_back = -0.618,
        Z_back = 0.0,
        Reflection = 0.1656,
        KillDistance = 0.0,
    },
    {
        Name = X_65, --Kh-65
        Escort = 0,
        Head_Type = 5,
		sigma = {20, 20, 20},
        M = 1400.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 514.0,
        Cx_pil = 19.9,
        D_max = 2500000.0,
        D_min = 9000.0,
        Head_Form = 0,
        Life_Time = 12000.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 230.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 12000.0,
        Range_max = 2500000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_65"],
        -- No exhaust (turbo)
        X_back = -2.356,
        Y_back = -0.618,
        Z_back = 0.0,
        Reflection = 0.1656,
        KillDistance = 0.0,
    },
    
    {
        Name = X_31P, --Kh-31P
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 600.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 360.0,
        Cx_pil = 15.6,
        D_max = 80000.0,
        D_min = 15000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.54,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 300.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_31P"],
        exhaust1 = tail_solid,
        X_back = -1.341,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.3,
        KillDistance = 5.0,
    },
    {
        Name = X_31A, --Kh-31A
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 600.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 360.0,
        Cx_pil = 15.6,
        D_max = 50000.0,
        D_min = 7000.0,
        Head_Form = 1,
        Life_Time = 150.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.54,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 150.0,
        Range_max = 70000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_31A"],
        exhaust1 = tail_solid,
        X_back = -1.341,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.3,
        KillDistance = 0.0,
    },
    {
        Name = X_35, --Kh-35
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 480.0,
        H_max = 30000.0,
        H_min = -1,
        Diam = 420.0,
        Cx_pil = 17.2,
        D_max = 130000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 20,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 0.92,
        t_b = 0.0,
        t_acc = 0.0,
        t_marsh = 600.0,
        Range_max = 130000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_35"],
        exhaust1 = tail_solid,
        X_back = -1.636,
        Y_back = -0.196,
        Z_back = 0.0,
        Reflection = 0.191,
        KillDistance = 0.0,
    },
    {
        Name = X_41, --Kh-41
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 4500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 760.0,
        Cx_pil = 7,
        D_max = 100000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 850.0,
        Mach_max = 2.8,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 250000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_41"],
        exhaust1 = tail_solid,
        X_back = -6.2,
        Y_back = -0.376,
        Z_back = 0.0,
        Reflection = 0.41,
        KillDistance = 0.0,
    },
    {
        Name = Vikhr, --9A4172 Vikhr
        Escort = 1,
        Head_Type = 4,
		sigma = {3, 3, 3},
        M = 43.0,
        H_max = 5000.0,
        H_min = 5.0,
        Diam = 130.0,
        Cx_pil = 1,
        D_max = 7000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 461.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 5.0,
        Range_max = 11000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Vikhr"],
        exhaust = {0.63, 0.67, 0.75, 0.1};
        X_back = 0.382,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0121,
        KillDistance = 0.0,
    },
    {
        Name = Vikhr_M, --9A4172M Vikhr-M
        Escort = 1,
        Head_Type = 4,
		sigma = {3, 3, 3},
        M = 45.0,
        H_max = 5000.0,
        H_min = 5.0,
        Diam = 130.0,
        Cx_pil = 1,
        D_max = 7000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 461.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 5.0,
        Range_max = 11000.0,
        H_min_t = 0.0,
        Fi_start = 0.0175,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Vikhr_M"],
        exhaust = {0.63, 0.67, 0.75, 0.1};
        X_back = 0.208,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AT_6, --9M114 Shturm
        Escort = 1,
        Head_Type = 6,
		sigma = {4, 4, 4},
        M = 40.0,
        H_max = 8000.0,
        H_min = -1,
        Diam = 126.0,
        Cx_pil = 2,
        D_max = 5000.0,
        D_min = 800.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 1.2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.1,
        Fi_rak = 3.14152,
        Fi_excort = 0.4,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AT_6"],
        exhaust = {0.63, 0.67, 0.75, 0.1};
        X_back = -0.922,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0495,
        KillDistance = 0.0,
    },
	--[[{
        Name = Ataka_T, --9M120 Ataka-T
        Escort = 1,
        Head_Type = 6,
		sigma = {5.6, 0, 5.6},
        M = 49.5,
        H_max = 4000.0,
        H_min = -1,
        Diam = 130.0,
        Cx_pil = 2,
        D_max = 6000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 1.2,
        v_min = 170.0,
        v_mid = 375.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.1,
        Fi_rak = 3.14152,
        Fi_excort = 0.4,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AT_6"],
        exhaust = {0.63, 0.67, 0.75, 0.3 };
        X_back = -0.922,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0495,
        KillDistance = 0.0,
    },]]
    {
        Name = AGM_114, --AGM-114L
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 48.25,
        H_max = 28000.0,
        H_min = -1,
        Diam = 178.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 200.0,
        Mach_max = 1.6,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 8000.0,
        H_min_t = 0.0,
        Fi_start = 1.0,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_114"],
        exhaust = {0.9, 0.9, 0.85, 0.1};
        X_back = -0.813,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AGM_114K, --AGM-114K
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 45.7,
        H_max = 28000.0,
        H_min = -1,
        Diam = 178.0,
        Cx_pil = 2,
        D_max = 9000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 35.0,
        Nr_max = 2,
        v_min = 150.0,
        v_mid = 200.0,
        Mach_max = 1.6,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 9000.0,
        H_min_t = 0.0,
        Fi_start = 1.0,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_114K"],
        exhaust = {0.9, 0.9, 0.85, 0.1};
        X_back = -0.813,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AGM_45, --AGM-45
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 177.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 203.0,
        Cx_pil = 4,
        D_max = 12000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 15.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_45"],
        exhaust = tail_solid,
        X_back = -1.065,
        Y_back = -0.101,
        Z_back = 0.0,
        Reflection = 0.05,
        KillDistance = 5.0,
    },
    {
        Name = AGM_65K, --AGM-65K
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65K"],
        exhaust = {0.75, 0.75, 0.75, 0.1},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65D, --AGM-65D
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 218.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65D"],
        exhaust = {0.75, 0.75, 0.75, 0.1},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65H, --AGM-65H
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 208.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65H"],
        exhaust = {0.75, 0.75, 0.75, 0.1},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65G, --AGM-65G
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65G"],
        exhaust = {0.75, 0.75, 0.75, 0.1},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65G, --TGM-65G
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65D,  --TGM-65D
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 218.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65D"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = CATM_65K,  --CATM-65K
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["CATM_65K"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65H, --TGM-65H
        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 208.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65H"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65E, --AGM-65E
        Escort = 1,
        Head_Type = 4,
		sigma = {5, 5, 5},
        M = 286.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 11112.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 11112.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65E"],
        exhaust = {0.75, 0.75, 0.75, 0.1},
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84A, --AGM-84A
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 661.5,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 95000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 106000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84A"],
        -- No exhaust (turbo)
        X_back = -1.581,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84E, --AGM-84E
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 628.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 85000.0,
        D_min = 2000.0,
        Head_Form = 0,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 139000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84E"],
        -- No exhaust (turbo)
        X_back = -1.581,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = AGM_86, --AGM-86
        Escort = 0,
        Head_Type = 5,
		sigma = {20, 20, 20},
        M = 1500.0,
        H_max = 13000.0,
        H_min = -1,
        Diam = 697.0,
        Cx_pil = 8,
        D_max = 2500000.0,
        D_min = 10000.0,
        Head_Form = 0,
        Life_Time = 10000.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.95,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10000.0,
        Range_max = 2414000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_86"],
        -- No exhaust (turbo)
        X_back = -3.392,
        Y_back = 0.064,
        Z_back = 0.0,
        Reflection = 0.1691,
        KillDistance = 0.0,
    },
    {
        Name = AGM_88, --AGM-88
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 361.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 254.0,
        Cx_pil = 4,
        D_max = 48000.0,
        D_min = 10000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 120000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_88"],
        exhaust = {0.9, 0.9, 0.9, 0.2};
        X_back = -1.506,
        Y_back = -0.126,
        Z_back = 0.0,
        Reflection = 0.05, --     ""
        KillDistance = 7.0,
    },
    {
        Name = AGM_122, --AGM-122
        Escort = 0,
        Head_Type = 3,
		sigma = {4, 4, 4},
        M = 91.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 1,
        D_max = 3000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 2.0,
        Range_max = 16500.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_122"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.02,
        KillDistance = 0.0,
    },
    {
        Name = AGM_123, --AGM-123
        Escort = 1,
        Head_Type = 4,
		sigma = {10, 10, 10},
        M = 582.0,
        H_max = 24000.0,
        H_min = -1,
        Diam = 356.0,
        Cx_pil = 6,
        D_max = 10000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 25000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.75,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_123"],
        exhaust = tail_solid,
        X_back = -1.832,
        Y_back = -0.201,
        Z_back = 0.0,
        Reflection = 0.075,
        KillDistance = 0.0,
    },
    {
        Name = AGM_130, --AGM-130
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 1312.65,
        H_max = 24000.0,
        H_min = -1,
        Diam = 460.0,
        Cx_pil = 4,
        D_max = 40000.0,
        D_min = 2000.0,
        Head_Form = 0,
        Life_Time = 250.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 245.0,
        Range_max = 65000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_130"],
        -- No exhaust (turbo)
        X_back = -1.697,
        Y_back = -0.56,
        Z_back = 0.0,
        Reflection = 0.11,
        KillDistance = 0.0,
    },
    {
        Name = Sea_Eagle, --Sea Eagle
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 600.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 400.0,
        Cx_pil = 6,
        D_max = 100000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 465.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Sea_Eagle"],
        -- No exhaust (turbo)
        X_back = -1.97,
        Y_back = -0.199,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = ALARM, --ALARM
        Escort = 0,
        Head_Type = 3,
		sigma = {10, 10, 10},
        M = 268.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 224.0,
        Cx_pil = 4,
        D_max = 30000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.1,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 45000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["ALARM"],
        exhaust = tail_solid,
        X_back = -1.97,
        Y_back = -0.109,
        Z_back = 0.0,
        Reflection = 0.0741,
        KillDistance = 5.0,
    },
    {
        Name = Kormoran, --Kormoran
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 600.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 345.0,
        Cx_pil = 6,
        D_max = 20000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 400.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Kormoran"],
        exhaust = tail_solid,
        X_back = -1.562,
        Y_back = -0.151,
        Z_back = 0.0,
        Reflection = 0.1758,
        KillDistance = 0.0,
    },
    {
        Name = AGM_119, --AGM-119
        Escort = 0,
        Head_Type = 5,
		sigma = {8, 8, 8},
        M = 370.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 300.0,
        Cx_pil = 3,
        D_max = 30000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 450.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 1.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 400.0,
        Range_max = 35000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_119"],
        exhaust = tail_solid,
        X_back = -1.046,
        Y_back = -0.159,
        Z_back = 0.0,
        Reflection = 0.1741,
        KillDistance = 0.0,
    },
    {
        Name = SM_2, --SM-2 Standard
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 615.0,
        H_max = 24400.0,
        H_min = 10.0,
        Diam = 340.0,
        Cx_pil = 5,
        D_max = 40000.0,
        D_min = 4000.0,
        Head_Form = 1,
        Life_Time = 120.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 6.8,
        t_b = 0.0,
        t_acc = 15.0,
        t_marsh = 0.0,
        Range_max = 100000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SM_2"],
        exhaust = tail_solid,
        X_back = -1.507,
        Y_back = -0.0,
        Z_back = 0.0,
        Reflection = 0.1766,
        KillDistance = 15.0,
    },
    {
        Name = SA5B55, --5V55, S-300
        Escort = 3,
        Head_Type = 6,
	sigma = {10, 10, 10},
        M = 1480.0,
        H_max = 30000.0,
        H_min = 25.0,
        Diam = 508.0,
        Cx_pil = 8,
        D_max = 40000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 180.0,
        Nr_max = 25,
        v_min = 0.0,
        v_mid = 1000.0,
        Mach_max = 5.0,
        t_b = 0.0,
        t_acc = 25.0, -- Corrected by https://youtu.be/7i-UMYNKwcU video
        t_marsh = 0.0,
        Range_max = 75000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA5B55"],
        exhaust = tail_solid,
        X_back = -3.681,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 20.0,
		--[[
		ModelData = {   58 ,  -- model params count
						4.0 ,   -- characteristic square ( )
						
						--   x
						0.17 , -- Cx_k0  x0   ( M << 1)
						0.22 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.033, -- Cx_k3  Cx0   ( M >> 1)
						2.0 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						1.57 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.29 , -- 7 Alfa_max    , 
						0.5 , --      
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		1.2,	0.01,  		12.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	0.0,		40.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	0.0,		3.8e5,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 70.0, --   , 
						 0, --   , 
						 2.0, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 50.0, --    
						 30.0,--     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 2.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						  -- DLZ.      (  )
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0, 
						 
					}, 
			--]]		
    },
    {
        Name = SA48H6E2, --48N6
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 1900.0,
        H_max = 30000.0,
        H_min = 10.0,
        Diam = 519.0,
        Cx_pil = 8,
        D_max = 55000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 8.6,
        t_b = 0.0,
        t_acc = 12.0,
        t_marsh = 0.0,
        Range_max = 150000.0, 
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA48H6E2"],
        exhaust = tail_solid,
        X_back = -3.681,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 25.0,
    },
    {
        Name = SA9M82, --9M82
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 4600.0,
        H_max = 30000.0,
        H_min = 1000.0,
        Diam = 810.0,
        Cx_pil = 8,
        D_max = 60000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 27,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 5.0,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 100000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M82"],
        exhaust = tail_solid,
        X_back = 0.138,
        Y_back = 0.0,
        Z_back = 0.0,
		X_back_acc = -3.978,
        Reflection = 0.5099,
        KillDistance = 30.0,
    },
    {
        Name = SA9M83, --9M83
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 2400.0,
        H_max = 25000.0,
        H_min = 25.0,
        Diam = 810.0,
        Cx_pil = 8,
        D_max = 45000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 75.0,
        Nr_max = 27,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 5.3,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 75000.0,
        H_min_t = 250.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M83"],
        exhaust = tail_solid,
        X_back = 0.138,
        Y_back = 0.0,
        Z_back = 0.0,
		X_back_acc = -2.103,
        Reflection = 0.4212,
        KillDistance = 30.0,
    },
    {
        Name = SAV611, --V-611
        Escort = 3,
        Head_Type = 6,
		sigma = {15, 15, 15},
        M = 1844.0,
        H_max = 25000.0,
        H_min = -1,
        Diam = 600.0,
        Cx_pil = 8,
        D_max = 10000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 30000.0,
        H_min_t = 100.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SAV611"],
        exhaust = tail_solid,
        X_back = -1.917,
        Y_back = 0.121,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 15.0,
    },
    {
        Name = SA3M9M, --3M9M Kub
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 600.0,
        H_max = 8000.0,
        H_min = 30.0,
        Diam = 330.0,
        Cx_pil = 4,
        D_max = 25000.0,
        D_min = 4000.0,
        Head_Form = 1,
        Life_Time = 60.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 450.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 22.0,
        Range_max = 25000.0,
        H_min_t = 30.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA3M9M"],
        exhaust = tail_solid,
        X_back = -3.0,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.106,
        KillDistance = 12.0,
    },
    {
        Name = SA9M33, --9M33 Osa
        Escort = 3,
        Head_Type = 6,
		sigma = {5, 5, 5},
        M = 126.3,
        H_max = 5000.0,
        H_min = 25.0,
        Diam = 206.0,
        Cx_pil = 2,
        D_max = 8500.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 28.0,
        Nr_max = 14,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.1,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 10.0,
        Range_max = 10300.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M33"],
        exhaust = tail_solid,
        X_back = -1.593,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0404,
        KillDistance = 5.0,
    },
    {
        Name = SA9M31, --9M31 Strela-1
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 32.0,
        H_max = 3500.0,
        H_min = 30.0,
        Diam = 120.0,
        Cx_pil = 2,
        D_max = 4200.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 1.3,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 7.0,
        Range_max = 4200.0,
        H_min_t = 30.0,
        Fi_start = math.rad(1),
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M31"],
        exhaust = tail_solid,
        X_back = -0.95,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.04,
        KillDistance = 2.5,
		--seeker sensivity params
		SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters.
		SeekerCooled			= false, -- True is cooled seeker and false is not cooled seeker.
    },
    {
        Name = SA9M38M1, --9M38M1 Buk
        Escort = 3,
        Head_Type = 6,
		sigma = {8, 8, 8},
        M = 685.0,
        H_max = 22000.0,
        H_min = 22.0,
        Diam = 400.0,
        Cx_pil = 4,
        D_max = 25500.0,  --   
        D_min = 3320.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 19,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 3.4,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 12.0,
        Range_max = 35000.0, --   
        H_min_t = 15.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M38M1"],
        exhaust = tail_solid,
        X_back = -2.85,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0918,
        KillDistance = 13.0,
    },
    {
        Name = SA9M333, --9M333 Strela-10
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 39.0,
        H_max = 3500.0,
        H_min = 25.0,
        Diam = 120.0,
        Cx_pil = 2,
        D_max = 5000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 5000.0,
        H_min_t = 10.0,
        Fi_start = math.rad(1),
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M333"],
        exhaust = tail_solid,
        X_back = -1.126,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.05,
        KillDistance = 3.0,
		--seeker sensivity params
		SeekerSensivityDistance = 15000, -- The range of target with IR value = 1. In meters.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
    },
    {
        Name = SA9M330, --9M330 Tor, SA-15
        Escort = 3,
        Head_Type = 6,
		sigma = {5, 5, 5},
        M = 165.0,
        H_max = 6000.0,
        H_min = 10.0,
        Diam = 220.0,
        Cx_pil = 2,
        D_max = 12000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 30,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 6.0,
        Range_max = 12000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M330"],
        exhaust = tail_solid,
        X_back = -1.37,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0307,
        KillDistance = 7.0,
		
		--[[	ModelData = {   58 ,  -- model params count
							0.18 ,   -- characteristic square ( )
						
						--   x
						0.1 , -- Cx_k0  x0   ( M << 1)
						0.1 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.06, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.8 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.4 , -- 7 Alfa_max    , 
						1.3, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		1.8,	5.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	12.03,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	15000.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
						 30.0, --  , 
						 60.0, --   , 
						 0, --   , 
						 0.5, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 25.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 5.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 
						 0.0,
						 0.0,
						 0.0,
						 0.0, 
						 0.0,
						 0.0,
						0.0,
						0.0,
					}, ]]--
		
    },
    {
        Name = SA9M311, --9M311 Tunguska
        Escort = 3,
        Head_Type = 8,
		sigma = {5, 5, 5},
        M = 42.0,
        H_max = 3500.0,
        H_min = 14.5,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 8000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 600.0,
        Mach_max = 2.82,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 0.0,
        Range_max = 8000.0,
        H_min_t = 14.5, -- cause ASM fly on 14.9992 m above the sea level. NOT ON 15
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M311"],
        exhaust = tail_solid,
        X_back = -1.5,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0102,
        KillDistance = 5.0,
		
		ModelData = {   58 ,  -- model params count
						0.06 ,   -- characteristic square ( )
						
						--   x
						0.1 , -- Cx_k0  x0   ( M << 1)
						0.1 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.06, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.8 , -- Cy_k0  y0   ( M << 1)
						0.8	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.4 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	2.6,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	9.03,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,	11700.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
					
						 30.0, --  , 
						 60.0, --   , 
						 0, --   , 
						 0.5, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 30.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 3.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 
						 0.0,
						 0.0,
						 0.0,
						 0.0, 
						 0.0,
						 0.0,
						0.0,
						0.0,
					},
    },
    {
        Name = Igla_1E, --9M39 Igla
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 10.8,
        H_max = 3500.0,
        H_min = 1.0,
        Diam = 72.0,
        Cx_pil = 1,
        D_max = 4500.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 17.0,
        Nr_max = 16,
        v_min = 70.0,
        v_mid = 570.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 3.0,
        Range_max = 4500.0,
        H_min_t = 10.0,
        Fi_start = math.rad(1),
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Igla_1E"],
        exhaust = tail_solid,
        X_back = -0.781,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0044,
        KillDistance = 1.0,
		--seeker sensivity params
		SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.		
    },
    {
        Name = MIM_104, --MIM-104 Patriot
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 700.0,
        H_max = 24240.0,
        H_min = 45.0,
        Diam = 410.0,
        Cx_pil = 4,
        D_max = 30000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 600.0,
        Mach_max = 5.0,
        t_b = 0.0,
        t_acc = 12.0,
        t_marsh = 5.0,
        Range_max = 120000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 0.75,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MIM_104"],
        exhaust = tail_solid,
        X_back = -2.474,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.1066,
        KillDistance = 13.0,
    },
    {
        Name = MIM_72G, --MIM-72G Chaparrel
        Escort = 0,
        Head_Type = 1,
		sigma = {5, 5, 5},
        M = 84.0,
        H_max = 3000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 1,
        D_max = 8500.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 80.0,
        Nr_max = 30,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 8500.0,
        H_min_t = 5.0,
        Fi_start = math.rad(1),
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MIM_72G"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
		--seeker sensivity params
		SeekerSensivityDistance = 15000, -- The range of target with IR value = 1. In meters.
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
		ModelData = {   58,  -- model params count
						0.35 ,   -- characteristic square ( )
						
						--   x
						0.04 , -- Cx_k0  x0   ( M << 1)
						0.08 , -- Cx_k1    
						0.02 , -- Cx_k2       
						0.05, -- Cx_k3  Cx0   ( M >> 1)
						1.2 , -- Cx_k4      
						1.2 , --    ( sqrt (M^2-1))
						
						--   Cy
						0.5 , -- Cy_k0  y0   ( M << 1)
						0.4	 , -- Cy_k1  Cy0   ( M >> 1)
						1.2  , -- Cy_k2  ()     
						
						0.4 , -- 7 Alfa_max    , 
						0.0, --     
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
						-1.0,		-1.0,	 3.6,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
						 0.0,		0.0,	 3.55,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(    /)
						 0.0,		0.0,     18328.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
					
						 1.0e9, --  , 
						 60.0, --   , 
						 0, --   , 
						 1.0, --     ( , ), 
						 1.0e9, --      ,       "", 
						 1.0e9, --   ,    ""         (      ),  
						 0.0,  --      
						 30.0, --    
						 0.0, --     ,    
						 1.19, --   -,      K0
						 1.0, --   -,      K1
						 8.0, --   -,     
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 
						 0.0,
						 0.0,
						 0.0,
						 0.0,
						 0.2, 
						 0.6,
						 1.4,
						-3.0,
						0.5,
					},
    },
    {
        Name = FIM_92C, --FIM-92C
        Escort = 0,
        Head_Type = 1,
		sigma = {3, 3, 3},
        M = 10.1,
        H_max = 3500.0,
        H_min = 1.0,
        Diam = 70.0,
        Cx_pil = 1,
        D_max = 4500.0,
        D_min = 200.0,
        Head_Form = 1,
        Life_Time = 30.0, -- temporary    19 
        Nr_max = 18,
        v_min = 70.0,
        v_mid = 300.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 3.0,
        Range_max = 5200.0,
        H_min_t = 10.0,
        Fi_start = math.rad(1),
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["FIM_92C"],
        exhaust = tail_solid,
        X_back = -0.781,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0044,
        KillDistance = 0.0,
		--seeker sensivity params
		SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters.
		ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
		SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.		
    },
    {
        Name = SA5B27, --5V27 S-125
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 690.0,
        H_max = 18000.0,
        H_min = 20,
        Diam = 400.0,
        Cx_pil = 4,
        D_max = 11000.0,
        D_min = 3500.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 20.0,
        Range_max = 25000.0,
        H_min_t = 200.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA5B27"],
        exhaust = tail_solid,
        X_back = -0.6,
        Y_back = 0.0,
        Z_back = 0.0,
		X_back_acc = -2.49,
        Reflection = 0.1676,
        KillDistance = 14.0,
    },
    {
        Name = HAWK_RAKETA, --MIM-23K Hawk http://en.wikipedia.org/wiki/MIM-23_Hawk
        Escort = 3,
        Head_Type = 6,
		sigma = {10, 10, 10},
        M = 638.0,
        H_max = 18000.0,
        H_min = 60.0,
        Diam = 370.0,
        Cx_pil = 4,
        D_max = 22000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 15,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.3,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 21.0,
        Range_max = 45000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["HAWK_RAKETA"],
        exhaust = tail_solid,
        X_back = -2.4,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.1676,
        KillDistance = 12.0,
    },
    {
        Name = ROLAND_R, --Roland
        Escort = 3,
        Head_Type = 6,
		sigma = {5.6, 5, 5.6},
        M = 75.0,
        H_max = 6000.0,
        H_min = 10,
        Diam = 150.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 14,
        v_min = 170.0,
        v_mid = 570.0,
        Mach_max = 2.0,
        t_b = 0.3,
        t_acc = 3.0,
        t_marsh = 13.2,
        Range_max = 8000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["ROLAND_R"],
        exhaust = tail_solid,
        X_back = -1.200,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0196,
        KillDistance = 5.0,
    },
    {
        Name = P_35, --P-35
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 4500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 1,
        D_max = 300000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 442.0,
        Mach_max = 1.3,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 800.0,
        Range_max = 300000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_35"],
        exhaust1 = tail_solid,
        X_back = -4.734,
        Y_back = 0.277,
        Z_back = 0.0,
		X_back_acc = -4.712,
        Y_back_acc = -0.354,
        Z_back_acc = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_500, --P-500 ""
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 4800.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 950.0,
        Cx_pil = 1,
        D_max = 500000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 986.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 1800.0,
        Range_max = 500000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_500"],
        exhaust1 = tail_solid,
        X_back = -5.814,
        Y_back = 0.099,
        Z_back = 0.0,
        Reflection = 0.75,
        KillDistance = 0.0,
    },
    {
        Name = P_700, --P-700 ""
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 6900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 850.0,
        Cx_pil = 1,
        D_max = 550000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 850.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 1800.0,
        Range_max = 550000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_700"],
        exhaust1 = tail_solid,
        X_back = -4.231,
        Y_back = 0.0,
        Z_back = 0.0,
		X_back_acc = -5.231,
        Y_back_acc = 0.0,
        Z_back_acc = 0.0,
        Reflection = 0.79,
        KillDistance = 0.0,
    },
    {
        Name = P_15U, --P-15U
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 2325.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 470.0,
        Cx_pil = 1,
        D_max = 40000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 374.0,
        Mach_max = 1.1,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 800.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_15U"],
        exhaust1 = tail_solid,
        X_back = -3.373,
        Y_back = -0.124,
        Z_back = 0.0,
		X_back_acc = -2.273,
        Y_back_acc = -0.669,
        Z_back_acc = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_120,
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 2500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 720.0,
        Cx_pil = 1,
        D_max = 110000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 306.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_120"],
        exhaust1 = tail_solid,
        X_back = -4.421,
        Y_back = 0.086,
        Z_back = 0.0,
		X_back_acc = -4.078,
        Y_back_acc = -0.277,
        Z_back_acc = 0.0,
        Reflection = 0.21,
        KillDistance = 0.0,
    },
    {
        Name = R_85,
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 1900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 3,
        D_max = 350000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 350000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["R_85"],
        exhaust1 = tail_solid,
        exhaust2 = tail_liquid,
        X_back = -6.521,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = R_85U,
        Escort = 0,
        Head_Type = 5,
		sigma = {15, 15, 15},
        M = 1900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 3,
        D_max = 55000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 350.0,
        Mach_max = 1.0,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 55000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["R_85U"],
        exhaust1 = tail_solid,
        exhaust2 = tail_liquid,
        X_back = -3.6,
        Y_back = 0.294,
        Z_back = -0.403,
		X_back_acc = -3.577,
        Y_back_acc = -0.041,
        Z_back_acc = -0.403,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = BGM_109B, --BGM-109B Tomahawk
        Escort = 0,
        Head_Type = 5,
		sigma = {20, 20, 20},
        M = 1225.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 1,
        D_max = 460000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 7200.0,
        Nr_max = 17,
        v_min = 170.0,
        v_mid = 238.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 7200.0,
        Range_max = 460000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["BGM_109B"],
        exhaust1 = tail_solid,
        X_back = -3.463,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84S, --AGM-84S
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 661.5,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 95000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 306.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 241401.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84S"],
        exhaust1 = tail_solid,
        X_back = -2.235,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.1058,
        KillDistance = 0.0,
    },
    {
        Name = MALUTKA, --9M14 Malutka
        Escort = 1,
        Head_Type = 7,
		sigma = {5, 5, 5},
        M = 10.9,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 3000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 1.1,
        v_min = 105.0,
        v_mid = 115.0,
        Mach_max = 0.45*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 30.0,
        Range_max = 3000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MALUTKA"],
        exhaust = {0.9, 0.9, 0.9, 0.2};
        X_back = -0.372,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = KONKURS, --9M113 Konkurs
        Escort = 1,
        Head_Type = 7,
		sigma = {4, 4, 4},
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 75.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.2,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 0.65*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 0.1,
        t_marsh = 30.0,
        Range_max = 4000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["KONKURS"],
        exhaust = {0.9, 0.9, 0.9, 0.1},
        X_back = -0.2,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = P_9M117, --9M117 Bastion
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 17.6,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 20.0,
        Nr_max = 1.1,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 1.11*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 0.3,
        t_marsh = 30.0,
        Range_max = 4000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M117"],
        exhaust = {0.9, 0.9, 0.9, 0.1};
        X_back = 0.0,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
	{
        Name = REFLEX, -- 9M119 (AT-11 Sniper),  , -80
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 17.2,
        H_max = 3000.0,
        H_min = -1,
        Diam = 125.0,
        Cx_pil = 6,
        D_max = 5000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 20.0,
        Nr_max = 1.2,
        v_min = 150.0,
        v_mid = 260.0,
        Mach_max = 0.85*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 12.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M119"],
		exhaust = {0.9, 0.9, 0.9, 0.1};
        X_back = -0.1,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
	{
        Name = SVIR, -- 9M119 (AT-11 Sniper),  , -72
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 17.2,
        H_max = 3000.0,
        H_min = -1,
        Diam = 125.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 17.6,
        Nr_max = 1.2,
        v_min = 150.0,
        v_mid = 300.0,
        Mach_max = 1.15*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 12.0,
        Range_max = 4000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M119"],
		exhaust = {0.9, 0.9, 0.9, 0.1};
        X_back = -0.1,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = TOW, --BGM-71D Tow, wsType_AS_Missile, for aerial
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 150.0,
        Cx_pil = 6,
        D_max = 3000.0,
        D_min = 400.0, 
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 3.0,
        v_min = 105.0,
        v_mid = 150.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 30.0,
        Range_max = 3750.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TOW"],
        exhaust = {0.9, 0.9, 0.8, 0.1};
        X_back = -0.25,
        Y_back =  0.0,
        Z_back =  0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = AGM_154, --AGM-154
        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 450.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 1010.0,
        Cx_pil = 8,
        D_max = 27780.0,
        D_min = 750.0,
        Head_Form = 1,
        Life_Time = 6400.0,
        Nr_max = 10,
        v_min = 10.0,
        v_mid = 100.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.0,
        t_marsh = 600.0,
        Range_max = 74080.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["BLU-111B"],
        -- No exhaust (turbo)
        X_back = -2.552,
        Y_back = -0.252,
        Z_back = 0.0,
        Reflection = 0.0618,
        KillDistance = 0.0,
    },
    {
        Name = P_9M133, --9M133 Kornet
        Escort = 1,
        Head_Type = 4,
		sigma = {4, 4, 4},
        M = 27.0,
        H_max = 5000.0,
        H_min = -1,
        Diam = 152.0,
        Cx_pil = 6,
        D_max = 5000.0,
        D_min = 100.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.2,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 0.7*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 20.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M133"],
		exhaust = {0.9, 0.9, 0.9, 0.1};
        X_back = -0.5,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = S_25L, --S-25L
        Escort = 1,
        Head_Type = 4,
		sigma = {8, 8, 8},
        M = 485.0,
        H_max = 4000.0,
        H_min = -1,
        Diam = 340.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 1,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.7,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 7000.0,
        H_min_t = 0.0,
        Fi_start = 0.15,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["S_25L"],
        exhaust = {0.6, 0.6, 0.6, 0.5},
        X_back = -1.8,
        Y_back =  0,
        Z_back =  0.0,
        Reflection = 0.0704,
        KillDistance = 0.0,
    },
    {
        Name = TOW2, --BGM-71D Tow for ground units
        Escort = 3,
        Head_Type = 7,
		sigma = {4, 4, 4},
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 230.0, --150.0, -- 230    ,       
        Cx_pil = 6,
        D_max = 3800.0,
        D_min = 65.0, -- FM 23-34 Tow Weapons System
        Head_Form = 1,
        Life_Time = 23.0,
        Nr_max = 3.0,
        v_min = 105.0,
        v_mid = 150.0,
        Mach_max = 0.87*ATGMMissiles_VelocityAdaptationCoeff,
        t_b = 0.0,
        t_acc = 1.5, -- FM 3-22.1  M2 Bredley
        t_marsh = 0.0, 
        Range_max = 4200.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TOW"],
        exhaust = {0.9, 0.9, 0.8, 0.1};
        X_back = -0.22,
        Y_back =  0.0,
        Z_back =  0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = SCUD_RAKETA, 
        Escort = 0,
        Head_Type = 5,
		sigma = {20, 20, 20},
        M = 5862.0,
        H_max = 19000.0,
        H_min = -1,
        Diam = 880.0,
        Cx_pil = 1,
        D_max = 310000.0,
        D_min = 12000.0,
        Head_Form = 1,
        Life_Time = 6000.0,
        Nr_max = 17,
        v_min = 85.0,
        v_mid = 1420.0,
        Mach_max = 4.86,
        t_b = 0.0,
        t_acc = 65.0,
        t_marsh = 0.0,
        Range_max = 350000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SCUD_8F14"],
        exhaust1 = tail_solid,
        X_back = -5.35,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.45,
        KillDistance = 0.0,
    },
}

function calcDamage(rocket_data)
    if ( rocket_data.warhead.cumulative_factor and
         rocket_data.warhead.cumulative_factor ~= 0) then
         rocket_data.Damage = rocket_data.warhead.cumulative_factor*rocket_data.warhead.expl_mass*2.5;
    elseif (rocket_data.warhead.expl_mass) then
         rocket_data.Damage = rocket_data.warhead.expl_mass*2.5;
    else
         rocket_data.Damage = 0.0;
    end
	rocket_data.warhead.caliber = rocket_data.warhead.caliber or rocket_data.Diam --mm
end 

for _, v in pairs(rockets) do
	calcDamage(v)
end

