--[[
    FAC script by Don Rudi
    
    Purpose of the script:  the player flies around on the map freely, looking 
    for targets. If he finds a target, he request an air strike by one of the 
    available fighterbombers. He can select ordnance type and the amount to be
    dropped/fired.
	As options the player can select bombing pattern length and attack heading.
	
    He then marks the target with smoke rockets and upon confirmation by pressing
    spacebar, a bombing task will be pushed to the select AI group.
    
    Enjoy!
    
    Version 1.4, 09/2022
]]--

env.setErrorMessageBoxEnabled(true)

local scriptVersion = "v1.4"

-- Player and AI bomber data

--********************************************************************************
--********************************************************************************
-- 								user entries
--********************************************************************************
--********************************************************************************

local PLAYER = Unit.getByName('PLAYER')		--> Player aircraft (i.e. FAC) Unit Name in the mission editor.
local myCallsign = "PONY 5"					--> Player callsign, choose as you like.

local BOMBERS = {

--[[
	-- Sample entry
	["BOMBERx"]=							--> From Mission editor, BOMBERx with x being an ascending number
	{
	 ["group"]=			"BOMBERx",			--> identical to top entry
	 ["id"] = 			"A-4 North",		--> Name to identify group in F10 menu
	 ["IronBombs"] = 	6,					--> number of iron bombs per aircraft (Mk8x series, etc) assigned in the editor. Ideally use same loadout on all aircraft of a group.
	 ["ClusterBombs"] = 0,					--> number of cluster bombs per aircraft (CBUx series, etc) assigned in the editor. Ideally use same loadout on all aircraft of a group.
	 ["FireBombs"] = 	0,					--> number of fire bombs per aircraft (Mk 7x series, etc) assigned in the editor. Ideally use same loadout on all aircraft of a group.
											--> NOT recommend, as the release point of these bombs is coded wrong in DCS!
	 ["Rockets"] = 		"Full",				--> I recommend to only use heavy rockets, as some light rockets (Hydra) may not be identified as a valid ordnance.
											--> Set to "Full" if rockets are loaded, set to "nil" if no rockets are loaded.
	 ["ARM"] = 			0,					--> number of Anti Radiation Missiles. Not implemented yet!
	 ["Callsign"] = 	"LOBO 4",			--> Callsign of the group. Choose as you like.
	 ["orbitWP"] =		1					--> first waypoint of the groups orbit. By default set to 1 
	},
]]--

	["BOMBER1"]=
	{
	 ["group"]=			"BOMBER1",
	 ["id"] = 			"A-4 North",
	 ["IronBombs"] = 	6,
	 ["ClusterBombs"] = 0,
	 ["FireBombs"] = 	0,
	 ["Rockets"] = 		"Full",
	 ["ARM"] = 			0,
	 ["Callsign"] = 	"LOBO 4",
	 ["orbitWP"] = 		1
	},

	["BOMBER2"]=
	{
	 ["group"]=			"BOMBER2",
	 ["id"] = 			"A-4 South",
	 ["IronBombs"] = 	0,
	 ["ClusterBombs"] = 4,
	 ["FireBombs"] = 	0,
	 ["Rockets"] = 		"Full",
	 ["ARM"] = 			0,
	 ["Callsign"] = 	"DOGGO 2",
	 ["orbitWP"] = 		1
	},
	 
	["BOMBER3"]= 
	{
	 ["group"]=			"BOMBER3",
	 ["id"] = 			"F-5 East",
	 ["IronBombs"] = 	2,
	 ["ClusterBombs"] = 2,
	 ["FireBombs"] = 	0,
	 ["Rockets"] = 		"nil",
	 ["ARM"] = 			0,
	 ["Callsign"] = 	"TIGER 3",
	 ["orbitWP"] = 		1
	},
	
	["BOMBER4"]= 
	{
	 ["group"]=			"BOMBER4",
	 ["id"] = 			"F-4 West",
	 ["IronBombs"] = 	6,
	 ["ClusterBombs"] = 0,
	 ["FireBombs"] = 	0,
	 ["Rockets"] = 		"nil",
	 ["ARM"] = 			0,
	 ["Callsign"] = 	"WEASEL 6",
	 ["orbitWP"] = 		1
	},
	
	["BOMBER5"]= 
	{
	 ["group"]=			"BOMBER5",
	 ["id"] = 			"Helo center",
	 ["IronBombs"] = 	0,
	 ["ClusterBombs"] = 0,
	 ["FireBombs"] = 	0,
	 ["Rockets"] = 		"Full",
	 ["ARM"] = 			0,
	 ["Callsign"] = 	"HORSEMAN 6",
	 ["orbitWP"] = 		1
	},
}

--********************************************************************************
--********************************************************************************

local nBOMBERS = 0

for _ in pairs(BOMBERS) do nBOMBERS = nBOMBERS + 1 end

local vars = {}

-- Weapon impact calculation interval in s

local INTERVAL = 0.02

-- Task related variables

--local validTargetFlag = 100
local validTarget = false
local callMenu = false
local selectedGroup = {}
local selectedAmount = 0
local selectedWeapon = 0
local selectedOrdnance = ""
local selectedAltitude = 0
local selectedHeading = -1
local headingEnabled = false
--local taskCreated = "taskCreated"
local taskSet = false
local selectedPattern = 0
local bombingStyle = "Bombing"
local validMark = false
local validTask = false

local _amount = 0

-- Weapon flags

local IRONBOMB = 16
local CLUSTERBOMB = 256
local FIREBOMB = 192
local ROCKET = 30720
--local ARM = 32768
local GUN = 805306368

-- Attack parameters (in meter, m/s)

local ALT_dropLevel = 300
local ALT_firing = 800
local ALT_dropDive = 2000

-- misc

local myPosition = ""
local distance = ""
local alive = false

local taskDone = 0

-- smoke values

local GREEN 	= 0
local RED 		= 1
local WHITE 	= 2
local ORANGE 	= 3
local BLUE 		= 4

local smokeColor = WHITE		--> Color of the markersmoke
local smokeDelay = 5			--> time after which weapon smoke is replaced by ingame smoke

-- construct MGRS coordinate, returns MGRS coordinate as 2 digits string

local function constructMGRS ( _unit )

	local _posTarget = _unit:getPoint()
	local _lat, _lon, _alt = coord.LOtoLL (_posTarget)

	local _MGRS = coord.LLtoMGRS(_lat, _lon)
	local _MGRSstring = _MGRS.UTMZone .." " .._MGRS.MGRSDigraph .." " ..string.sub(_MGRS.Easting, 1, -4) .." " ..string.sub(_MGRS.Northing, 1, -4)
	
	return _MGRSstring

end

-- calculate distance

function getDist(_point1, _point2)

    local xUnit = _point1.x
    local yUnit = _point1.z
    local xZone = _point2.x
    local yZone = _point2.z

    local xDiff = xUnit - xZone
    local yDiff = yUnit - yZone

    return math.sqrt(xDiff * xDiff + yDiff * yDiff)

end

-- Bomber - FAC dialogue

function bomberDialogue1 (_selectedGroup)

	local _distance = math.floor(getDist(PLAYER:getPoint(), Group.getByName(_selectedGroup):getUnit(1):getPoint())/1850) .. "NM"
	trigger.action.outText( myCallsign .. ", " .. BOMBERS[_selectedGroup]["Callsign"] .. " - we are " .. _distance .. " from your position. Ready to copy task.", 45, false)

end

function bomberDialogue2(_selectedGroup)

	trigger.action.outText( BOMBERS[_selectedGroup]["Callsign"] .. ", " .. myCallsign .. " - request strike with " .. selectedOrdnance .. ". Amount: " .. selectedAmount ..".", 45, false)

end

function bomberDialogue3(_selectedGroup)

	trigger.action.outText("Roger, " .. BOMBERS[_selectedGroup]["Callsign"] .. " attacking with " .. selectedOrdnance ..". Mark the target!", 45, false)
	trigger.action.outText( "*** Mark the target with a rocket ***", 60, false)

end

function bomberDialogue4()

	trigger.action.outText(myCallsign .. ", " .. BOMBERS[selectedGroup]["Callsign"] .. ", rolling in, attacking your smoke!", 30, true)
	
end

-- Bomber calls off target

function bomberOff (_group)

	trigger.action.outText(BOMBERS[_selectedGroup]["Callsign"] .. " off target!", 30, false)

end

-- Check distance of bombers to target

function distanceToTarget(_target)

	local _distanceToTarget = getDist(Group.getByName(selectedGroup):getUnit(1):getPoint(), POSITION)
	
	if _distanceToTarget < 4000 then
	
		trigger.action.outText(BOMBERS[selectedGroup]["Callsign"] .. " - two miles!", 20, false)
		
	else
	
		timer.scheduleFunction(distanceToTarget, {}, timer.getTime() + 2)
		
	end

end

-- Process strike request from F10 menu

function taskCreated (_selectedN, _selectedWeapon, _selectedAmount)

	_selectedGroup = "BOMBER" .. _selectedN
	
	selectedGroup = _selectedGroup
	selectedWeapon = _selectedWeapon
	selectedAmount = _selectedAmount
	
	-- adjust amount of ordnance
	
	if _selectedAmount == "One" then
		_amount = 1
	elseif _selectedAmount == "Two" then
		_amount = 2
	elseif _selectedAmount == "All" then
		_amount = 0
	end
	
	-- set ordnance string for message
	
	if _selectedWeapon == 16 then
		selectedOrdnance = "iron bombs"
		if _amount == 1 or _amount == 2 then
			BOMBERS[_selectedGroup]["IronBombs"] =  BOMBERS[_selectedGroup]["IronBombs"] - _amount
		elseif _selectedAmount == "Half" then
		    BOMBERS[_selectedGroup]["IronBombs"] = math.ceil(BOMBERS[_selectedGroup]["IronBombs"]/2)
		else
			BOMBERS[_selectedGroup]["IronBombs"] = 0
		end
		
	elseif _selectedWeapon == 256 then
		selectedOrdnance = "cluster bombs"
		if _amount == 1 or _amount == 2 then
			BOMBERS[_selectedGroup]["ClusterBombs"] =  BOMBERS[_selectedGroup]["ClusterBombs"] - _amount
		elseif _selectedAmount == "Half" then
		    BOMBERS[_selectedGroup]["ClusterBombs"] = math.ceil(BOMBERS[_selectedGroup]["ClusterBombs"]/2)
		else
			BOMBERS[_selectedGroup]["ClusterBombs"] = 0
		end
	elseif _selectedWeapon == 192 then
		selectedOrdnance = "fire bombs"
		if _amount == 1 or _amount == 2 then
			BOMBERS[_selectedGroup]["FireBombs"] =  BOMBERS[_selectedGroup]["FireBombs"] - _amount
		elseif _selectedAmount == "Half" then
		    BOMBERS[_selectedGroup]["FireBombs"] = math.ceil(BOMBERS[_selectedGroup]["FireBombs"]/2)
		else
			BOMBERS[_selectedGroup]["FireBombs"] = 0
		end
	elseif _selectedWeapon == 30720 then
		selectedOrdnance = "rockets"
		if _selectedAmount == "Half" then
			BOMBERS[_selectedGroup]["Rockets"] = "Half"
		elseif _selectedAmount == "All" then
			BOMBERS[_selectedGroup]["Rockets"] = "nil"
		end
	--[[	
	elseif _selectedWeapon == 32768 then
		selectedOrdnance = "anti radiation missile"
		if _amount ~= 0 then
			BOMBERS[_selectedGroup]["ARM"] =  BOMBERS[_selectedGroup]["ARM"] - _amount
		else
			BOMBERS[_selectedGroup]["ARM"] = 0
		end
	]]--
	else
		--selectedOrdnance = "guns"
	end
	
	-- set attack altitude in m depending on selected weapon 
	
	if string.find(selectedOrdnance, "bombs") ~= nil then
		selectedAltitude = ALT_dropLevel
	else
		selectedAltitude = ALT_firing
	end

    -- tasking message 
    
	myPosition = constructMGRS (PLAYER)
	
	trigger.action.outText( BOMBERS[_selectedGroup]["Callsign"] .. ", " .. myCallsign .. " - position " .. myPosition .. ".\nReady to copy strike task?", 45, false)
	
	-- Dialogue
	
	timer.scheduleFunction(bomberDialogue1,_selectedGroup, timer.getTime() + 5)
	timer.scheduleFunction(bomberDialogue2,_selectedGroup, timer.getTime() + 10)
	timer.scheduleFunction(bomberDialogue3,_selectedGroup, timer.getTime() + 15)
	
	
	
	-- task needs to be confirmed by pressing spacebar (see triggers)
	-- due to this confirmation the player can attack targets, without a task being triggered
	
	validTarget = false 
	validTask = true
		
	--trigger.action.setUserFlag("TASKCREATED" , 1)		--moved to dialogue3
	
	timer.scheduleFunction(validTargetFunc, {}, timer.getTime() + 15)
	
	-- Rebuild F10 menus
	
	flushFACMenu ()
	buildFACMenu ()
	
end

-- Determine wether task is bombing or carpetbombing

function bombingPattern ( _length )

	selectedPattern = _length
	
	if selectedPattern > 0 then
		trigger.action.outText(BOMBERS[selectedGroup]["Callsign"] .. ", roger, will spread over " .. selectedPattern .. " meters.", 20, false)
	end

end

-- Set attack heading

function setAttackHeading ( _heading )
	
	-- Parameter "direction" is a from value --> desired attackheading +/- 180°. Convert from 360° to 2pi
	
	if _heading > 180 then
		selectedHeading = (_heading - 180) / 57.34
	else
		selectedHeading = (_heading + 180) / 57.34
	end
	
	trigger.action.outText(BOMBERS[selectedGroup]["Callsign"] .. ", roger, attack heading " .. _heading .. ".", 20, false)

end

-- player pressed spacebar (see triggers)

function validTargetFunc ()

	--local valid = trigger.misc.getUserFlag( 'MARKTARGET' )
	
	if validMark == true then
		trigger.action.outText( BOMBERS[selectedGroup]["Callsign"] .. ", attack my smoke!", 45, true)
		--trigger.action.setUserFlag("TASKCREATED", 0)
		--trigger.action.setUserFlag("MARKTARGET", 0)
		
		validTarget = true
	else
		timer.scheduleFunction(validTargetFunc, {}, timer.getTime() + 1)
	end
	
end

-- Reset strike request

function resetTask (_source)

	selectedGroup = {}
	selectedAmount = 0
	selectedWeapon = 0
	selectedOrdnance = ""
	selectedAltitude = 0
	selectedHeading = -1
	selectedPattern = 0
	validTarget = false
	validTask = false
	
	flushFACMenu ()
	buildFACMenu ()
	
	--trigger.action.setUserFlag("TASKCREATED", 0)
	if _source == "reset" then
	
		trigger.action.outText("*** Tasking reset ***", 15, true)
		
	end
	
end

-- Check if Group is alive

function groupAlive (_group)
	
	_group = Group.getByName(_group)
	if Group.getSize(_group) > 0 then
		return true
	else
		return false
	end

end

-- Build F10 menus

function buildFACMenu ()

	strikeGroup = missionCommands.addSubMenu("Request Strike")
	
	for i= 1, nBOMBERS, 1 do
		
		distance = ""
		--alive = groupAlive(vars["BOMBER" .. i])
		
		if Group.getByName("BOMBER" .. i) ~= nil then
			
			distance = math.floor(getDist(PLAYER:getPoint(), Group.getByName("BOMBER" .. i):getUnit(1):getPoint())/1850) .. "NM"
			
			vars["strikeGroup" .. i] = missionCommands.addSubMenu(BOMBERS["BOMBER" .. i]["id"] .. ", " .. distance, strikeGroup)
			
			if BOMBERS["BOMBER" .. i]["IronBombs"] > 0 then
				vars["strike" .. i .. "IronBomb"] = missionCommands.addSubMenu("Iron bombs", vars["strikeGroup" .. i])
				vars["s" .. i .. "ibs"] = missionCommands.addCommand("Single", vars["strike" .. i .. "IronBomb"], function () taskCreated(i, IRONBOMB, "One") end)
				if BOMBERS["BOMBER" .. i]["IronBombs"] > 1 then
				   vars["s" .. i .. "ibp"] = missionCommands.addCommand("Pair", vars["strike" .. i .. "IronBomb"], function () taskCreated(i, IRONBOMB, "Two") end)
				end
				if BOMBERS["BOMBER" .. i]["IronBombs"] > 2 then
				   vars["s" .. i .. "ibh"] = missionCommands.addCommand("Half", vars["strike" .. i .. "IronBomb"], function () taskCreated(i, IRONBOMB, "Half") end)
				   vars["s" .. i .. "iba"] = missionCommands.addCommand("All", vars["strike" .. i .. "IronBomb"], function () taskCreated(i, IRONBOMB, "All") end)
				end
			end
			if BOMBERS["BOMBER" .. i]["ClusterBombs"] > 0 then
				vars["strike" .. i .. "ClusterBomb"] = missionCommands.addSubMenu("Cluster Bombs", vars["strikeGroup" .. i])
				vars["s" .. i .. "cbs"] = missionCommands.addCommand("Single", vars["strike" .. i .. "ClusterBomb"], function () taskCreated(i, CLUSTERBOMB, "One") end)
				if BOMBERS["BOMBER" .. i]["ClusterBombs"] > 1 then
					vars["s" .. i .. "cbp"] = missionCommands.addCommand("Pair", vars["strike" .. i .. "ClusterBomb"], function () taskCreated(i, CLUSTERBOMB, "Two") end)
				end
				if BOMBERS["BOMBER" .. i]["ClusterBombs"] > 2 then
					vars["s" .. i .. "cbh"] =  missionCommands.addCommand("Half", vars["strike" .. i .. "ClusterBomb"], function () taskCreated(i, CLUSTERBOMB, "Half") end)
					vars["s" .. i .. "cba"] =  missionCommands.addCommand("All", vars["strike" .. i .. "ClusterBomb"], function () taskCreated(i, CLUSTERBOMB, "All") end)
				end
			end
			if BOMBERS["BOMBER" .. i]["FireBombs"] > 0 then
				vars["strike" .. i .. "FireBomb"] = missionCommands.addSubMenu("Fire bombs", vars["strikeGroup" .. i])
				vars["s" .. i .. "fbs"] = missionCommands.addCommand("Single", vars["strike" .. i .. "FireBomb"], function () taskCreated(i, FIREBOMB, "One") end)
				if BOMBERS["BOMBER" .. i]["FireBombs"] > 1 then
					vars["s" .. i .. "fbp"] = missionCommands.addCommand("Pair", vars["strike" .. i .. "FireBomb"], function () taskCreated(i, FIREBOMB, "Two") end)
				end
				if BOMBERS["BOMBER" .. i]["FireBombs"] > 2 then
					vars["s" .. i .. "fbh"] = missionCommands.addCommand("Half", vars["strike" .. i .. "FireBomb"], function () taskCreated(i, FIREBOMB, "Half") end)
					vars["s" .. i .. "fba"] = missionCommands.addCommand("All", vars["strike" .. i .. "FireBomb"], function () taskCreated(i, FIREBOMB, "All") end)
				end
			end
			if BOMBERS["BOMBER" .. i]["Rockets"] ~= "nil" then
				vars["strike" .. i .. "Rocket"] = missionCommands.addSubMenu("Rockets",vars["strikeGroup" .. i])
				vars["s" .. i .. "rh"] = missionCommands.addCommand("All", vars["strike" .. i .. "Rocket"], function () taskCreated(i, ROCKET, "All") end)
				if BOMBERS["BOMBER" .. i]["Rockets"] == "Full" then
					vars["s" .. i .. "ra"] = missionCommands.addCommand("Half", vars["strike" .. i .. "Rocket"], function () taskCreated(i, ROCKET, "Half") end)
				end
			end
			--vars["s" .. i .. "g"] = missionCommands.addCommand("Guns", vars["strikeGroup" .. i], function () taskCreated(i, GUN, "Quarter") end)
		
		end
	end
	
	options = missionCommands.addSubMenu("Strike options")
	optionsPattern = missionCommands.addSubMenu("Bombing pattern length", options)
	optionsHeading = missionCommands.addSubMenu("Attack heading", options)

	--bombPoint = missionCommands.addCommand("Point", optionsPattern, function () bombingPattern(0) end)
	--bombLength500 = missionCommands.addCommand("500 meters", optionsPattern, function () bombingPattern(500) end)
	--bombLength1000 = missionCommands.addCommand("1000 meters", optionsPattern, function () bombingPattern(1000) end)
	--bombLength5000 = missionCommands.addCommand("5000 meters", optionsPattern, function () bombingPattern(5000) end)
	
	attackHeading1 = missionCommands.addCommand("360°", optionsHeading, function () setAttackHeading (360) end)
	attackHeading2 = missionCommands.addCommand("045°", optionsHeading, function () setAttackHeading (45) end)
	attackHeading3 = missionCommands.addCommand("090°", optionsHeading, function () setAttackHeading (90) end)
	attackHeading4 = missionCommands.addCommand("135°", optionsHeading, function () setAttackHeading (135) end)
	attackHeading5 = missionCommands.addCommand("180°", optionsHeading, function () setAttackHeading (180) end)
	attackHeading6 = missionCommands.addCommand("225°", optionsHeading, function () setAttackHeading (225) end)
	attackHeading7 = missionCommands.addCommand("270°", optionsHeading, function () setAttackHeading (270) end)
	attackHeading8 = missionCommands.addCommand("315°", optionsHeading, function () setAttackHeading (315) end)
	
	reset = missionCommands.addCommand("Reset strike request",nil ,function () resetTask("reset") end)

end

function flushFACMenu ()
	
	missionCommands.removeItem(strikeGroup)
	
	for i = 1,nBOMBERS,1 do
	
		missionCommands.removeItem(vars["strikeGroup" .. i])
		missionCommands.removeItem(vars["strike" .. i .. "IronBomb"])
		missionCommands.removeItem(vars["strike" .. i .. "ClusterBomb"])
		missionCommands.removeItem(vars["strike" .. i .. "FireBomb"])
		missionCommands.removeItem(vars["strike" .. i .. "Rocket"])
		missionCommands.removeItem(vars["s" .. i .. "ibs"])
		missionCommands.removeItem(vars["s" .. i .. "ibp"])
		missionCommands.removeItem(vars["s" .. i .. "ibh"])
		missionCommands.removeItem(vars["s" .. i .. "iba"])
		missionCommands.removeItem(vars["s" .. i .. "cbs"])
		missionCommands.removeItem(vars["s" .. i .. "cbp"])
		missionCommands.removeItem(vars["s" .. i .. "cba"])
		missionCommands.removeItem(vars["s" .. i .. "cbh"])
		missionCommands.removeItem(vars["s" .. i .. "fbs"])
		missionCommands.removeItem(vars["s" .. i .. "fbp"])
		missionCommands.removeItem(vars["s" .. i .. "fbh"])
		missionCommands.removeItem(vars["s" .. i .. "fba"])
		missionCommands.removeItem(vars["s" .. i .. "rh"])
		missionCommands.removeItem(vars["s" .. i .. "ra"])
		--missionCommands.removeItem(vars["s" .. i .. "g"])
		
	end	
end

-- send AI back to orbit

function backToOrbit (_group)

	local TASK_ORBIT = {
		
		["enabled"] = true,
		["auto"] = false,
		["number"] = 1,
		["id"] = "SwitchWaypoint",
		["params"] = 
		{
			["goToWaypointIndex"] = BOMBERS[selectedGroup]["orbitWP"],
		}
	}
	--_group = Group.getByName(selectedGroup)
	
	_group:getController():setCommand(TASK_ORBIT)
	
	resetTask ("done")
	
	timer.scheduleFunction(bomberOff,_group, timer.getTime() + 5)
end

-- event weapon was fired

activeWeapon = {}
eventHandler = {
	onEvent = function (self, event)
		if event.id == world.event.S_EVENT_SHOT and event.weapon then
		
			local whoFired = event.initiator
			local WPN = event.weapon
			
			if PLAYER == whoFired and validTask == true and WPN:getCategory() == 2 then
		
				activeWeapon[#activeWeapon+1] = event.weapon
				validTask = false
				validTarget = true
				calc()
			end
			if string.find(whoFired:getName(), "BOMBER") ~= nil  then
				validTarget = false
				taskSet = false
				taskDone = 1
				
				-- Send AI back to original orbit
				
				if offTarget == false then
					_tempGroup = Unit.getGroup(whoFired)
					backToOrbit (_tempGroup)
					offTarget = true
				end
			end		
		end
	end
}

world.addEventHandler(eventHandler)

-- Push bomb impact position to AI bombing task 

function setTask(_target)
	
	if Group.getByName(selectedGroup) ~= nil then
	
		if validTarget == true then
			
			if selectedPattern == 0 then
				bombingStyle = "Bombing"
				selectedAttackType = ""
			else
				bombingStyle = "CarpetBombing"
				selectedAttackType = "carpet"
			end
			
			if selectedHeading > 0 then
				headingEnabled = true
			else
				headingEnabled = false
			end
			
			local TASK_BOMBING = {
				["enabled"] = true,
				["auto"] = false,
				["id"] = bombingStyle, --"Bombing",
				["number"] = 1,
				["params"] = 
				{
					["attackType"] = selectedAttackType,
					["direction"] = selectedHeading,
					["directionEnabled"] = headingEnabled,
					["attackQtyLimit"] = false,
					["attackQty"] = 1,
					["expend"] = selectedAmount,
					["x"] = _target.x,
					["y"] = _target.z,
					["altitude"] = selectedAltitude,
					["altitudeEnabled"] = true,
					["weaponType"] = selectedWeapon,
					["groupAttack"] = true,
					["carpetLength"] = selectedPattern,
				 }
			}

			local group = Group.getByName(selectedGroup)
			
			validMark = false
			
			timer.scheduleFunction(bomberDialogue4, {}, timer.getTime() + 5)
			
			timer.scheduleFunction(distanceToTarget, {_target}, timer.getTime() + 10)
			
			--group:getController():setSpeed(250)
			group:getController():pushTask(TASK_BOMBING)
			offTarget = false
			
		end
		
	else
	
		trigger.action.outText("Selected attacker not available.", 20, false)
		resetTask ("done")
		
	end
end

-- Optional: is weapon in a specified zone

local zoneName = "ZONE_TARGET"

local function checkInZone( pos)

  local _triggerZone = trigger.misc.getZone(zoneName)
        
  if _triggerZone ~= nil then
     
   local _dist = getDist(pos, _triggerZone.point)
        
    if _dist <= _triggerZone.radius  then
       return true
    end
     
  end
  return false

end

-- replace shortlived weapon smoke with smoke marker

function setSmoke ( _smokePos)

	trigger.action.smoke( _smokePos , smokeColor )
	
end


-- Calculate impact point

function calc()

	for i,v in pairs(activeWeapon) do
		if v ~= nil then
			if v:isExist() == true then
				POSITION = v:getPoint()
			else
				table.remove(activeWeapon, i)
				
				-- replace weapon smoke with white smoke marker
				if smokeColor == WHITE then
					smokeDelay = 5
				else
					smokeDelay = 0.2
				end
				
				timer.scheduleFunction(setSmoke, POSITION, timer.getTime() + smokeDelay)
				validMark = true
				
				setTask(POSITION)
								
				if checkInZone(POSITION) == true then
					trigger.action.setUserFlag("Marker" , true)
				else
					trigger.action.setUserFlag("Marker" , false)
				end
				
			end
		end
	end
	
	timer.scheduleFunction(calc, {}, timer.getTime() + INTERVAL)
	
end

-- Build F10 menu at mission start

flushFACMenu ()
buildFACMenu ()

-- successful script initialization 

trigger.action.outText( "*** FAC script " .. scriptVersion .. " loaded ***", 10, false)

