Eagle =  {
      
		Name 			= 'Eagle',
		DisplayName		= _('*A2*_Eagle_flying'),
--        Picture 		= "V22_Osprey.png",
        Rate 			= "50",
        Shape			= "Eagle",	
        WorldID			=  WSTYPE_PLACEHOLDER, 
		singleInFlight	= true,
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'Eagle';
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'Eagle_destr'; -- Name of destroyed object file name
			fire  	 	= { 3, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'Eagle_flying';
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "Eagle_destr";
			file  		= "Eagle_destr";
			fire  		= { 4, 2};
		},
	},
	
	LandRWCategories = 
		{
        [1] = 
        {
           Name = "HelicopterCarrier",
        },
        [2] = 
        {
           Name = "AircraftCarrier",
        },
    },
	TakeOffRWCategories = 
		{
        [1] = 
        {
            Name = "HelicopterCarrier",
        },
        [2] = 
        {
           Name = "AircraftCarrier",
        },
    },
	
		takeoff_and_landing_type = "VTOL",
	
		CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_BAD),

		mapclasskey 	= "P0091000029",
		attribute 		= {
		wsType_Air,
		wsType_Airplane,
		wsType_Cruiser,
		WSTYPE_PLACEHOLDER,
		"Transports",
		"Refuelable",
        "Datalink",
        "Link16",
		},

		Categories = {
        },

		M_empty						=	13380,	-- kg  with pilot and nose load, F15
		M_nominal					=	19000,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	30845,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	6103,	-- kg (Internal Fuel Only)
		InternalCargo = {
			nominalCapacity = 4536,
			maximalCapacity = 9350,
			para_unit_point = 10, -- Anzahl der Fallschirmjäger
			unit_point = 24, 	  -- Anzahl der Infanterie
			area = {6.34, 1.74, 1.67},-- Das Innenvolumen des Laderaums ist lang, breit, hoch, m
			unit_block = {0.76, 0.775}-- Abmessungen für einen Fallschirmjäger, Länge, Breite, m
		},
		H_max						=	762,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.1271,
		CAS_min						=	5,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	22,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	6,		-- Take off speed in m/s (for AI)
		V_land						=	7,		-- Land speed in m/s (for AI)
		has_afteburner				=	true, -- true VTOL
		has_speedbrake				=	false,
		radar_can_see_ground		=	true,

		nose_gear_pos 								= 	{0.902,	-1.80,	0},
	    nose_gear_amortizer_direct_stroke   		=	0,      -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  -0.24,      -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  -0.12,      -- down from nose_gear_pos
	    nose_gear_wheel_diameter					=	0.128,
	
	    main_gear_pos 								= 	{-0.0,	-1.95,	3.141},--??? 0.0 bis 0.8 Probleme
	    main_gear_amortizer_direct_stroke	 	    =   0,     --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =  -0.30,     --  up 
	    main_gear_amortizer_normal_weight_stroke    =  -0.15,     --  down from main_gear_pos
	    main_gear_wheel_diameter					=	0.197,

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	0,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	40,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	73,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	5.5,	-- wing area in m2
		thrust_sum_max				=	13347,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	21952,	-- thrust in kgf (95.1 kN)
		Vy_max						=	27,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	0.16,	-- Max speed in Mach (for AI)
		range						=	254,	-- Max range in km (for AI)
		RCS							=	1,		-- Radar Cross Section m2
		Ny_max_e					=	2,		-- Max G (for AI)
		detection_range_max			=	250,
		IR_emission_coeff			=	0.291,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	0,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	2,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	5.78,--XX  wing spain in m
		wing_type 					= 	0,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	7.48,
		height						=	1.63,--XX
		crew_size					=	1, --XX
		engines_count				=	1, --XX
		wing_tip_pos              	= 	{ -1.0,   0.74,   1.3}, 
		
		EPLRS 						= true,--?
		TACAN_AA					= true,
		--launch_bar_connected_arg_value	= 0.85,
		

		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-0.004,	0.438,	-3.293},
				elevation	=	0,
				diameter	=	0.01,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1, 
			}, -- end of [1]
--			[2] = 
--			{
--				pos = 	{-2.004,	0.438,	3.293},
--				elevation	=	0,
--				diameter	=	0.01,
--				exhaust_length_ab	=	8.629,
--				exhaust_length_ab_K	=	0.76,
--				smokiness_level     = 	0.1, 
--			}, -- end of [2]
		}, -- end of engines_nozzles
		
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{7.916,	0.986,	0},
				ejection_order = 1,
			}, -- end of [1]
--			[2] = 
--			{
--				ejection_seat_name	=	0,
--				drop_canopy_name	=	0,
--				pos = 	{3.949,	1.01,	0},
--				ejection_order = 2,
--			}, -- end of [2]
--			[3] = 
--			{
--				ejection_seat_name	=	0,
--				drop_canopy_name	=	0,
--				pos = 	{3.949,	1.01,	0},
--				ejection_order = 3,
--			}, -- end of [3]
		}, -- end of crew_members
		
		brakeshute_name	=	0,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{ 0,   0,   0 }, 
		fires_pos = 
		{
			[1] = 	{0.048,	1.008,	0},
			[2] = 	{0.048,	1.008,	2.322},
			[3] = 	{0.048,	1.008,	-2.322},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-0.267,	0.054,	3.293},
			[9] = 	{-0.267,	0.054,	-3.293},
			[10] = 	{-0.267,	0.054,	3.293},
			[11] = 	{-0.267,	0.054,	-3.293},
		}, -- end of fires_pos
		
		
Sensors = {
RADAR = "AN/APS-138",
RWR = "Abstract RWR"
},
Countermeasures = {
ECM = "AN/ALQ-135"--f15
},		

	Pylons = {
    },
	
	Tasks = {
        aircraft_task(Transport),
    },	
	DefaultTask = aircraft_task(Transport),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	6,
			Mzalfadt	=	1,
			kjx = 2.95,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.06,
			cy_flap = 0.4,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0.0,	0.0215,		0.055,		0.08,		0.22,	0.65,	25.0,	1.2 	},
				{0.2,	0.0215,		0.055,		0.08,		0.22,	1.80,	25.0,	1.2     },
				{0.4,	0.0215,		0.055,		0.08,	   	0.22,	3.00,	25.0,	1.2     },
				{0.6,	0.0215,		0.055,		0.05,		0.28,	4.20,	25.0,	1.2     },
				{0.7,	0.0215,		0.055,		0.05,		0.28,	4.20,	23.0,	1.15    },
				{0.8,	0.0215,		0.055,		0.05,		0.28,	4.20,	21.7,	1.1     },
				{0.9,	0.0230,		0.058,		0.09,		0.20,	4.20,	20.1,	1.07    },
				{1.0,	0.0320,		0.062,		0.17,		0.15,	4.20,	18.9,	1.04    },
				{1.1,	0.0430,		0.062,	   	0.235,		0.09,	3.78,	17.4,	1.02    },
				{1.2,	0.0460,		0.062,	   	0.285,		0.08,	2.94,	17.0,	1.00 	},		
				{1.3,	0.0470,		0.06,	   	0.29,		0.10,	2.10,	16.0,	0.92 	},				
				{1.4,	0.0470,		0.056,	   	0.3,		0.136,	1.80,	15.0,	0.80 	},					
				{1.6,	0.0470,		0.052,	   	0.34,		0.21,	1.08,	13.0,	0.7 	},					
				{1.8,	0.0460,		0.042,	   	0.34,		2.43,	0.96,	12.0,	0.55 	},		
				{2.2,	0.0420,		0.037,	   	0.49,		3.5,	0.84,	 10.0,	0.37 	},					
				{2.5,	0.0420,		0.033,		0.6,		4.7,	0.84,	 9.0,	0.3 	},		
				{3.9,	0.0400,		0.023,		0.9,		6.0,	0.84,	 7.0,	0.2		},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			--type	=	"TurboJet",
			type	=	"TurboProp", 	--MQ-9 Reaper
			hMaxEng	=	19.5,
			dcx_eng	=	0.0114,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6000,
			dpdh_f	=	14000.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0.0,	115000,		212000},
				{0.2,	 94000,		200000},
				{0.4,	 92000,		205000},
				{0.6,	103000,		207000},
				{0.7,	105000,		210000},
				{0.8,	105000,		220000},
				{0.9,	105000,		235000},
				{1.0,	107000,		250000},
				{1.1,	103000,		258000},
				{1.2,	 94000,		268000},
				{1.3,	 84000,		285000},
				{1.4,	 71000,		300000},
				{1.6,	 34000,		318000},
				{1.8,	 19000,		337000},
				{2.2,	 17000,		370000},
				{2.5,	 19000,		390000},
				{3.9,	 82000,		310000},
			}, -- end of table_data
		}, -- end of engine
	},
	
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
--	DamageParts = 
--	{  
--		[1] = "V22_Osprey-oblomok-wing-r", -- wing R
--		[2] = "V22_Osprey-oblomok-wing-l", -- wing L
--	},
	
-- VSN DCS World\Scripts\Aircrafts\_Common\Lights.lua

	lights_data = { typename = "collection", lights = {
	
    [1] = { typename = "collection", -- WOLALIGHT_STROBES
					lights = {	
						--{typename = "natostrobelight", argument = 192, period = 1.2, phase_shift = 0, color = {0.9, 1, 0.7}, connector = "BANO_0_BACK",intensity_max = 35},-- beacon light (white)
						{typename = "natostrobelight", argument = 196, period = 1.2, phase_shift = 0, color = {1, 0, 0}, connector = "BANO_0_BACK",intensity_max = 35},-- beacon light (red)
						{typename = "natostrobelight", argument = 195, period = 1.2, phase_shift = 0, color = {1, 0, 0}, connector = "BANO_0_BACK2",intensity_max = 35},-- beacon light (red)
							}
			},
	[2] = { typename = "collection",
					lights = {-- 1=Landing light -- 2=Landing/Taxi light
						{typename = "spotlight",	connector = "MAIN_SPOT_PTM",argument = 208,color = {1, 1, 1}},
						{typename = "spotlight",	connector = "MAIN_SPOT_PTM",argument = 209,color = {1, 1, 1}},
						{typename = "spotlight",	connector = "MAIN_SPOT_PTL",argument = 208,color = {1, 1, 1}},
						{typename = "spotlight",	connector = "MAIN_SPOT_PTR",argument = 208,color = {1, 1, 1}},
							}
			},
    [3]	= {	typename = "collection", -- nav_lights_default
					lights = {
						--{typename  = "omnilight",connector =  "BANO_1"  ,argument  =  190,color = {0.99, 0.11, 0.3}},-- Left Position(red)
						--{typename  = "omnilight",connector =  "BANO_2"  ,argument  =  191,color = {0, 0.894, 0.6}},-- Right Position(green)
						--{typename  = "omnilight",connector =  "BANO_0"  ,argument  =  192,color = {1, 1, 1}},-- Tail Position white)
						{typename = "argumentlight",argument = 190}, -- Left Position(red)
						{typename = "argumentlight",argument = 191}, -- Right Position(green)
						{typename = "argumentlight",argument = 192}, -- Tail Position white)
							}
			},
	[4] = { typename = "collection", -- formation_lights_default
					lights = {
						{typename  = "argumentlight" ,argument  = 200,},--formation_lights_tail_1 = 200;
						{typename  = "argumentlight" ,argument  = 201,},--formation_lights_tail_2 = 201;
						{typename  = "argumentlight" ,argument  = 202,},--formation_lights_left   = 202;
						{typename  = "argumentlight" ,argument  = 203,},--formation_lights_right  = 203;
						{typename  = "argumentlight" ,argument  =  88,},--old aircraft arg 
							}
			},
--[[			
	[5] = { typename = "collection", -- strobe_lights_default
					lights = {
						{typename  = "strobelight",connector =  "RED_BEACON"  ,argument = 193, color = {0.8,0,0}},-- Arg 193, 83,
						{typename  = "strobelight",connector =  "RED_BEACON_2",argument = 194, color = {0.8,0,0}},-- (-1"RESERV_RED_BEACON")
						{typename  = "strobelight",connector =  "RED_BEACON"  ,argument =  83, color = {0.8,0,0}},-- Arg 193, 83,
							}
			},
--]]			
	}},
}

add_aircraft(Eagle) 



