#ifndef _HELPER_HLSL
#define _HELPER_HLSL

#ifdef CONTEXT_HLSL
bool inVR()
{
	// detect VR (off-center projection)
	return any(gProj[2][0]);
}

#ifdef TEXTURE_2D
uint2 getBufferSize(in TEXTURE_2D(uint2, buf))
{
	uint2 bufSize;
#ifdef MSAA	
	uint samples;
	buf.GetDimensions(bufSize.x, bufSize.y, samples);
#else
	buf.GetDimensions(bufSize.x, bufSize.y);
#endif	
	return bufSize;
}
#endif
#endif

uint AToC(in float alpha) // alpha to coverage
{
  const uint msaa = countbits(COVERAGE_MASK);
  return (1 << (uint)floor(saturate(alpha) * msaa + 0.5)) - 1;
}

#endif
