// optimisations: change 1 to 0 to disable
#define ENABLE_SIMPLE_SHADOWS 0 // Use less samples in shadow mapping
#define ENABLE_SIMPLE_GRASS   0 // Simplified grass
#define ENABLE_SIMPLE_CANOPY  0 // Simplified canopy glass
#define ENABLE_SIMPLE_HG      1 // Simplified histogram calculation
#define ENABLE_NO_BLOOM       1 // Disable bloom & color grading
#define ENABLE_SIMPLE_TRANS   1 // Enable simple transparent object shading (propellers, smoke, etc.)

// improvements
#define ENABLE_DITHERING          1 // Use dithering in HDR tonemap to reduce banding, may cause moire artifacts at edges of lenses
#define ENABLE_DIFFUSE_SS         2 // Albedo texture supersampling. 0=off, 1=2x, 2=4x, 3=6x, 4=8x
#define ENABLE_TERRAIN_SHADOW_MS  1 // Read multi-sampled terrain shadows
#define ENABLE_ATOC               1 // Enable alpha-to-coverage
#define NVG_GAIN_ADJUSTS_POSITION 0 // with this enabled the NVG gain control instead adjusts the vertical position allowing in-game adjustment with fixed gain (NVG_VERTICAL_OFFSET is ignored)

// other settings
#define NVG_SIZE                  4.0     // size of the NVG scope (larger value = smaller scope)
#define NVG_VERTICAL_OFFSET       0.07    // vertical position of the NVG scope, for allowing to "look under" the goggles at instruments
#define NVG_NOISE_STR             0.035   // NVG noise strength
#define NVG_HOTPIXEL_THRESHOLD    0.99983 // NVG noise threshold for "hot" pixels
