
CLP_TU214 =  {

-----------------------
-- Name, Shape and Type
-----------------------

    Name 				= 'CLP_TU214',
    DisplayName         = _('Tu-204/214 (CLP)'),
    date_of_introduction= 1989.1,
    country_of_origin   = "RUSSIA",
    Picture             = "CLP_TU214.png",
    Rate                = 40, -- RewardPoint in Multiplayer
    Shape               = "CLP_TU214",

	WorldID 		= WSTYPE_PLACEHOLDER,

    debrisGeneration    = 1,

    shape_table_data    = {
        {
            file        = "CLP_TU214";
            life        = 18; -- life bar -- TODO
            vis         = 3; -- visibility gain -- TODO
            desrt       = "kc-135-oblomok"; -- Name of destroyed object file name
            fire        = {3600, 6}; -- Fire on the ground after destroyed
            username    = "CLP_TU214";
            index       = WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
            positioning = "BYNORMAL";
            drawonmap = true;
        },
        {
            name = "kc-135-oblomok";
            file = "kc-135-oblomok";
            fire = {3600, 6};
        },
    },

	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),

-----------------------
-- SENSORS RADIOS
-----------------------

        singleInFlight = false,

        attribute = {wsType_Air, wsType_Airplane, wsType_Cruiser, WSTYPE_PLACEHOLDER,
			"Aux",
        },
        Categories = {
        },
        Sensors = {

        },
		laserEquipment = {
--			laserDesignator = true,
--			laserRangefinder = true
		},


		EPLRS = true,
		radar_can_see_ground	=	true,

		mapclasskey = "P0091000029", --CARGO


		HumanRadio = {
		frequency = 243.0,
		editable = true,
		minFrequency = 30.000,
		maxFrequency = 399.975,
        rangeFrequency = {
			{min = 30.0,  max = 87.975},
			{min = 108.0, max = 115.975},
			{min = 118.0, max = 173.975},
			{min = 225.0, max = 399.975},
		},
		modulation = MODULATION_AM,
	},
--------


-----------------------
-- DEFINITION
-----------------------


		EmptyWeight = 59000,
        MaxFuelWeight = 32374,
        MaxHeight = 12100,
--        MaxSpeed =  980,
        MaxTakeOffWeight = 110750,
		TACAN = true,

    -----------------------------------------------------------------------------------------------

	M_empty 					= 59000 ,  -- kg
	M_nominal 					= 65317,  -- kg
	M_max 						= 110750,  -- kg
	M_fuel_max 					= 32374,   -- kg  (32374=40530l@1.251kg per l)
	H_max 					 	= 12100,	-- m
	average_fuel_consumption 	= 0.1893,  -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 56,
	V_opt 						= 220,  -- Cruise speed (for AI) 220M/S IS 792KPH
	V_take_off 					= 58,   -- Take off speed in m/s (for AI)
	V_land 						= 61,   -- Land speed in m/s (for AI)
	V_max_sea_level 			= 238.0,  -- Max speed at sea level in m/s (for AI) - 850kmh
	V_max_h 					= 238.0,  -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 10,   -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.9, -- Max speed in Mach (for AI)
	Ny_min 						= 0.5, -- Min G (for AI) was -4
	Ny_max 						= 2.5,  -- Max G (for AI)
	Ny_max_e 					= 2,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 45, -- Max bank angle (for AI)

    has_afteburner  = false, -- AFB yes/no
    has_speedbrake  = true, -- Air brake yes/no (spoiler substitute)
    has_differential_stabilizer = false, -- Differential stabilizers yes/no


    flaps_transmission = "Hydraulic",
--    undercarriage_transmission = "Hydraulic",
--    undercarriage_movement = 2,
    bomb_bay_movement = 2,
    doors_transmission = "Mechanical",
    doors_movement  = 1,

    tand_gear_max   = 3.73, --was 0.577, -- tang(a) <- a = steering angle

    ------------------------------------
	nose_gear_pos = 	{14.09, -4.013,	0}, -- nosegear coord wheel touch -TU214 (4.013 - 3.713)
	nose_gear_amortizer_direct_stroke   		=  0.0,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  		=  -0.3,
	nose_gear_amortizer_normal_weight_stroke 	=  -0.02,
	nose_gear_wheel_diameter 					=  0.628, -- in m

	main_gear_pos = 	{-2.96,	-4.218,	3.86},  --wheel touch -TU214 (4.218-3.918)
	main_gear_amortizer_direct_stroke	 	 	=   0, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  	 	=   -0.3, -- 1.9834-1.862
	main_gear_amortizer_normal_weight_stroke 	=  -0.11, -- -0.1,-- down from main_gear_pos
	main_gear_wheel_diameter 				 	=   1.07, -- in m -TU214
	------------------------------------

    wing_area       = 184.2, 	-- Wing area in m2
    wing_span       = 42.0, -- Wing span in metres
    -- change wing type to foldable to use mechanimation to force bomb bay closed if opened by option setting
	wing_type       = 0, -- 0 = Fixed wing
                         -- 1 = Variable geometry
                         -- 2 = Fold-able wing
 --   wing_ad_sections= {0, 0, 0, 1, 1, 2, 2},
    thrust_sum_max  = 32000, -- Thrust in kg
    thrust_sum_ab   = 32000, -- Thrust in kg
	length 						= 46.2, -- full lenght in m
	height 						= 13.9, -- height in m
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI) was 0.5
	range 						= 6500, -- Max range in km (for AI)
	RCS 						= 80, -- Radar Cross Section m2
	detection_range_max			= 500,
	IR_emission_coeff 			= 4, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	wing_tip_pos = 	{-9.22,	2.58,	20.92}, -- wingtip coords for visual effects
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	bigParkingRamp								=	true,

		is_tanker	=	false,
--		tanker_type	=	1,
--		air_refuel_receptacle_pos = 	{13.444,	2.04,	0.0},



    engines_count = 2, -- Engines count
	engines_nozzles = {
		[1] =
		{
 			pos 		=  {-0.496, -1.955,-6.49}, -- nozzle coords
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
			engine_number       = 1,
		}, -- end of [1]
		[2] =
		{
			pos 		=  {-0.496, -1.955, 6.49}, -- nozzle coords
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
			engine_number       = 2,
		}, -- end of [1]
	}, -- end of engines_nozzles

    -- Tasks
	Tasks = {
		aircraft_task(Transport),
    },
	DefaultTask = aircraft_task(Transport),

-----------------------
-- ANIMATIONS
-----------------------

	    crew_members = {
        [1] = {
            pilot_name          = "CLP_PILOT214",
			pos					 = {14.5, 1.07, 1.8},
            ejection_seat_name  = 0,
			drop_canopy_name	=	0,
            boarding_arg        = -1, --TEST
			canopy_arg = -1,
			pilot_body_arg      = 50,
            role                = "pilot",
            role_display_name   = _("Pilot"),
			bailout_arg = -1,
        }, -- end of [1]
        [2] = {
            pilot_name          = "CLP_PILOT214",
 			pos					 = {14.5, 1.07, 1.8},
            ejection_seat_name  = 0,
			drop_canopy_name	=	0,
			canopy_arg = -1,
            pilot_body_arg      = 50,
            role                = "copilot",
            role_display_name   = _("Copilot"),
			bailout_arg = -1,
        }, -- end of [2]
        [3] = {
            pilot_name          = "CLP_PILOT214",
 			pos					 = {14.5, 1.07, 1.8},
            ejection_seat_name  = 0,
			drop_canopy_name	=	0,
            boarding_arg        = -1, --TEST
			canopy_arg = -1,
            pilot_body_arg      = 50,
            role                = "flight_officer",
            role_display_name   = _("Navigator"),
			bailout_arg = -1,
        }, -- end of [3]

    }, -- end of crew_members
--    crew_stations = "HumanOrchestra",

    mechanimations = {

        LeftStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 1.0, "in", 13.0}, {"Arg", 116, "to", 1.0, "in", 13.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 0.0, "in", 15.0}, {"Arg", 116, "to", 0.0, "in", 15.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 5}, {"PosType", 6}, {"Arg", 5, "to", 0.5, "in", 2.0}, {"Arg", 116, "to", 0.5, "in", 2.0}}}}},
        },
        RightStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 1.0, "in", 13.0}, {"Arg", 115, "to", 1.0, "in", 13.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 0.0, "in", 15.0}, {"Arg", 115, "to", 0.0, "in", 15.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 3}, {"PosType", 7}, {"Arg", 3, "to", 0.5, "in", 2.0}, {"Arg", 115, "to", 0.5, "in", 2.0}}}}},
        },
        CentralStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 1.0, "in", 12.0}, {"Arg", 117, "to", 1.0, "in", 12.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 0.0, "in", 13.0}, {"Arg", 117, "to", 0.0, "in", 13.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 4}, {"PosType", 8}, {"Arg", 0, "to", 0.5, "in", 2.0}, {"Arg", 117, "to", 0.5, "in", 2.0}}}}},
        },

    },

    net_animation = { --TODO full list. is this needed for AI?
--        278, 279, 203
    },



-------- FLIGHT MODEL

	SFM_Data = {     --e-3
			aerodynamics =
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.015,
			cx_flap	=	0.05,
			cy_flap	=	1,
			cx_brk	=	0.06,
			table_data =
			{
				[1] = 	{0,	0.023,	0.117,	0.064,	0,	0.5,	20,	1.4},
				[2] = 	{0.2,	0.023,	0.117,	0.064,	0,	1.5,	20,	1.4},
				[3] = 	{0.4,	0.023,	0.117,	0.064,	0,	2.5,	20,	1.4},
				[4] = 	{0.6,	0.025,	0.117,	0.064,	0.022,	3.5,	20,	1.4},
				[5] = 	{0.7,	0.03,	0.117,	0.083,	0.031,	3.5,	20,	1.2},
				[6] = 	{0.8,	0.032,	0.117,	0.107,	0.04,	3.5,	20,	1},
				[7] = 	{0.9,	0.045,	0.117,	0.148,	0.058,	3.5,	20,	0.8},
				[8] = 	{1,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.7},
				[9] = 	{1.5,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.2},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine =
		{
			Nmg	=	60.00001,--67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	1,
			ForsRUD	=	1,
			type	=	"TurboJet",
			hMaxEng	=	19.5,
			dcx_eng	=	0.0085,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	9000,
			dpdh_f	=	9000,
			table_data =
			{
				[1] = 	{0,	373600,	373600},
				[2] = 	{0.2,	312756.6,	312756.6},
				[3] = 	{0.4,	279000,	279000},
				[4] = 	{0.6,	251000,	251000},
				[5] = 	{0.7,	253000,	253000},
				[6] = 	{0.8,	262000,	262000},
				[7] = 	{0.9,	274000,	274000},
				[8] = 	{1,	279000,	279000},
				[9] = 	{1.1,	280000,	280000},
				[10] = 	{1.2,	266000,	266000},
				[11] = 	{1.3,	95001.1,	95001.1},
			}, -- end of table_data
		}, -- end of engine
	},

-----------------------
-- WEAPONS
-----------------------

-- Guns
	Guns 	= {
	},

	AmmoWeight = 0,

--   ammo_type = {},

    Pylons =
	{
-- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)

	},

-----------------------
-- DAMAGE MODEL
-----------------------

			fires_pos =
		{
			[1] = 	{0,	-1.5,	0},  --Fuselage
			[2] = 	{0.09,	-0.4,	1.8}, -- Wing R In
			[3] = 	{0.09,	-0.4,	-1.8}, -- Wing L In
			[4] = 	{-1.5,	-0.2,	6.5},  -- Wing R Mid
			[5] = 	{-1.5,	-0.2,	-6.5},  -- Wing L Mid
			[6] = 	{-7.3,	0.68,	18.9}, -- Wing R Out
			[7] = 	{-7.3,	0.68,	-18.9}, -- Wing L Out
			[8] = 	{-0.496, -1.955, 6.49}, -- Engine R engine exhaust pos
			[9] = 	{-0.496, -1.955, -6.49}, -- Engine L In
			[10] = 	{4.8, -1.9, 6.5},  -- Engine R Out
			[11] = 	{4.8, -1.9, -6.5},  -- Engine L Out
		}, -- end of fires_pos



	Failures = {
	},



	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0] = {critical_damage = 5, args = {146}}, --NOSE_CENTER
	[3] = {critical_damage = 10, args = {65}}, --CABINA / COCKPIT
	[8] = {critical_damage = 10}, --FRONT_GEAR_BOX

	[9]  = {critical_damage = 3,  args = {154}},--FUSELAGE_LEFT_SIDE OK

	[11] = {critical_damage = 1,  args = {168}},--ENGINE_L
	[12] = {critical_damage = 1,  args = {162}},--ENGINE_R

	[15] = {critical_damage = 2,  args = {267}, deps_cells = {84}},--LEFT_GEAR_BOX
	[16] = {critical_damage = 2,  args = {266}, deps_cells = {85}},--RIGHT_GEAR_BOX
	[17] = {critical_damage = 3,  args = {168}},--ENGINE_L_OUT
	[18] = {critical_damage = 3,  args = {162}},--ENGINE_R_OUT

	[25] = {critical_damage = 2,  args = {226}},--ELERON_L
	[26] = {critical_damage = 2,  args = {216}},--ELERON_R
	[35] = {critical_damage = 20, args = {225}, deps_cells = {25, 37, 11, 17}},--WING_L_IN
	[36] = {critical_damage = 20, args = {215}, deps_cells = {26, 38, 12, 18}},--WING_R_IN
	[37] = {critical_damage = 2,  args = {227, 228}},--FLAP_L_IN
	[38] = {critical_damage = 2,  args = {217, 218}},--FLAP_R_IN

	[44] = {critical_damage = 2,  args = {242}, deps_cells = {53}},--FIN_R_BOTTOM

	[51] = {critical_damage = 2,  args = {240}},--ELEVATOR_L_IN
	[52] = {critical_damage = 2,  args = {238}},--ELEVATOR_R_IN
	[53] = {critical_damage = 2, args = {247}},  -- RUDDER_L
	[54] = {critical_damage = 2, args = {248}}, --RUDDER_R
	[55] = {critical_damage = 15, args = {81}, deps_cells = {51, 52}},  --tail

	[83] = {critical_damage = 3, args = {134}}, -- nose wheel
	[84] = {critical_damage = 3, args = {136}}, -- left wheel
	[85] = {critical_damage = 3, args = {135}}, -- right wheel

	},



	DamageParts =
	{
		"CLP_TU214_WING_R", -- wing R
		"CLP_TU214_WING_L" -- wing L
	},

-----------------------
-- LIGHTING
-----------------------

   lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- Landing Light
                        typename = "collection",
                        lights = {
							{
                                typename = "spotlight", connector = "LDG1_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG1_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG1_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG2_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							{
								typename = "argumentlight", argument = 202, --TAIL ILLUM
							},
							{
								typename = "argumentlight", argument = 203, --TAIL ILLUM
							},
                        },
                    },
                    { -- 1 -- Landing / Taxi Light
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "RESERV_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							 {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- NW Light
                        typename = "collection",
                        lights = {
							{
                                typename = "spotlight", connector = "TAXI_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "TAXI_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "TAXI_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
					{ -- 1 -- Landing / Taxi Light
                        typename = "collection",
                        lights = {


							{
                                typename = "spotlight", connector = "TAXI_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "TAXI_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "TAXI_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							{
                                typename = "spotlight", connector = "LDG1_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG1_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG1_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG2_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							{
								typename = "argumentlight", argument = 202, --TAIL ILLUM
							},

                        },
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_1", argument = 190,
                        proto = lamp_prototypes.BANO_7M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_1",
                                proto = lamp_prototypes.BANO_7M_red,
								range = 9.0,
                            },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_2", argument = 191,
                        proto = lamp_prototypes.BANO_7M_green, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_2",
                                proto = lamp_prototypes.BANO_7M_green,
--								range = 9.0,
                            },
                    { -- 2 -- Tail Position Light (WHITE)
                        typename = "Collection",
                        lights = {
--[[
                            {
                                typename = "Spot", connector = "BANO_0", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
							{
                                typename = "Spot", connector = "FLOW_001",
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_001",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
														                            {
                                typename = "Spot", connector = "FLOW_002",
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_002",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
--]]
                        },
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "collection",
                lights = {

                },
            },
            [WOLALIGHT_CABIN_BOARDING] = {
                typename = "collection",
                lights = {
                },
            },
			[WOLALIGHT_STROBES] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
						lights = {

							{
								typename = "natostrobelight", connector = "RED_BEACON2", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
														{
								typename = "natostrobelight", connector = "RED_BEACON3",
								proto = lamp_prototypes.SMI_2KM,
							},
							{
								typename = "natostrobelight", position = {-8.8,	1.0, 20, 0.020}, argument = 192,
								proto = lamp_prototypes.MPS_1,
							},
							{
								typename = "natostrobelight", position = {-8.8,	1.0, -20, 0.020},
								proto = lamp_prototypes.MPS_1,
							},
						},
					},
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
						lights = {
							{
								typename = "argumentlight", argument = 69,
							},
						},
					},
				},
			},
		},
    },
}


add_aircraft(CLP_TU214)
