package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {} -- сюда кладем все созданные объекты

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setUpdateFunc('sceneVRUpdate')
	sceneAPI:setEnvironmentMap("VRMainScene",0.9);
	scene.m			= sceneAPI:addModel("fa-18c", 0, 2, 0);
	
	-- tuned in model viewer and  pressed "Copy Args To Clipboard For Encyclopedia"
	local encyclopediaAnimation = {
	args = {
		[0] = 1.000000,
		[1] = 0.418000,
		[3] = 1.000000,
		[4] = 0.636000,
		[5] = 1.000000,
		[6] = 0.636000,
		[8] = 0.934000,
		[10] = 0.775000,
		[11] = 0.772000,
		[15] = -0.937000,
		[16] = -0.901000,
		[24] = 1.000000,
		[38] = 0.919000,
		[50] = 0.939000,
		[114] = 0.011000,
		[115] = 1.000000,
		[116] = 1.000000,
		[117] = 1.000000,
		[323] = 1.000000,	
		},
	}	
	
	for i,o in pairs(encyclopediaAnimation.args) do
		scene.m:setArgument(i,o);
	end

	scene.m:setLivery("VFA-122","FA-18C_hornet")

	local cam_level = 1.8

	scene.cam		= sceneAPI:addCamera(1, cam_level ,-3)
	scene.cam:setFarClip(1000.0)
	scene.cam:setFov(90)
	scene.cam.transform:lookAtPoint(-10.0, cam_level, 0);

	scene.sh		= sceneAPI:addModel("Nimitz_Hangar",-30,-8.71,0); 
	scene.sh:drawToEnvironment(true);
	scene.cam:setActive()

	preloadList = 
	{
		{"fa-18c", "VFA-122","FA-18C_hornet"},
		{"Nimitz_Hangar", {}, {}}
	}
	sceneAPI:waitForModels(preloadList)
end

function sceneVRUpdate(t, dt)

end



