local base = _G

module('me_training')

local U = base.require('me_utilities')
local form = base.require('me_training_form')
local Widget = base.require('Widget')
local ListBox = base.require('ListBox')
local Theme = base.require('Theme')
local U = base.require('me_utilities')
local MissionModule = base.require('me_mission')
local i18n = base.require('i18n')
local Tools = base.require('tools')
local lfs = base.require('lfs')
local video = base.require('ogvplayer')
local MsgWindow = base.require('MsgWindow')

i18n.setup(_M)

cdata = {
    training = _('TRAINING');
    leftBtn = _('BACK');
    rightBtn = _('START');
    
    trainingTask = _('Training Task');
    description = _('Description');
    lessons = _('Lessons');
	download = _('Download'),
}

tasks = {}

function create(x, y, w, h)
    startParameters = {x, y, w, h}
    
end

function doCreate(x, y, w, h)
	local searchPath = base.getSearchPath();
	local path = base.simPath .. 'Training/' .. searchPath[1]
	local dir = i18n.getLocalizedDirName(base.simPath .. 'Training/' .. searchPath[1]);  
	
	--base.print('dir=',dir,'path=',path)
	if (dir == nil)  or (dir..'/' == path ) then
		dir = path .. '/en'
	end
	--base.print('dir=',dir)
	loadDir(dir);

  
  --[[

    local fileName = base.getFileName(base.mainPath..'data/scripts/training/trainingData.lua', true);
    local f = i18n.loadTable(fileName)
    if f then    
        tasks = f.tasks;
    else
        base.print('Error loading ' .. fileName)
    end;

]]--
    window = form.create(x, y, w, h, cdata)
    listboxTasks = window.containerMain.containerTrainingTask.listboxTasks;
    listboxLessons = window.containerMain.containerLessons.listboxLessons;
    scrollpaneDescription = window.containerMain.containerLessons.scrollpaneDescription;
    scrollpaneDescription.widgetDescription:setWrapping(true);
    setupCallbacks();
    
    fillTasks();
    selectTask(1);
    created  = true;
end;

--
function compTable(tab1, tab2)
	--base.print('compare',tab1,tab2, tab1.name, tab2.name)
	if (tab1.keySort < tab2.keySort) then
		return true
	end
	return false
end


--      .
function loadDir(dirName)
	local numTask = 1
	for dirs in lfs.dir(dirName) do
		local fullNameDirs  = U.fixPath(dirName .. '/' .. dirs);
		--base.print('dirs = "'..dirs..'"');
		local d = lfs.attributes(fullNameDirs)	
		if d then
			if (d.mode == 'directory') and (dirs ~= '.') and (dirs~='..') then 		
				local numLesson = 1
				tasks[numTask] = tasks[numTask] or {}
				tasks[numTask].lessons	= tasks[numTask].lessons or {}
				
				loadTaskMissions(fullNameDirs, numTask, numLesson)
				
				if (isValidateTask(tasks[numTask])) then
					numTask = numTask + 1
				else
					base.table.remove(tasks, numTask)
				end
			end
		end		
	end
	
	--base.U.traverseTable(tasks,3)
	
	base.table.sort(tasks, compTable)
	for _, task in base.pairs(tasks) do
		--base.print("task.name=",task.name)
		base.table.sort(task.lessons, compTable)
	end
	--base.U.traverseTable(tasks[1],3)
end;

function loadTaskMissions(fullNameDirs, numTask, numLesson)
	for task in lfs.dir(fullNameDirs) do --      
		local fullNameTask  = U.fixPath(fullNameDirs .. '/' .. task);
		--base.print('Task = "'..fullNameTask..'"');
		local a = lfs.attributes(fullNameTask)			
		if a then						
			if (a.mode == 'directory') and (task ~= '.') and (task~='..') then 								
				tasks[numTask].lessons[numLesson] = tasks[numTask].lessons[numLesson] or {}		
				
				loadMission(fullNameTask, numTask, numLesson)				
				
				if (isValidateMission(tasks[numTask].lessons[numLesson])) then
					numLesson = numLesson + 1
				else
					base.table.remove(tasks[numTask].lessons, numLesson)
				end
			else
				if (task == 'task.lua') then
					local tableTask = Tools.safeDoFile(fullNameTask).task
					tasks[numTask].name 	= tableTask.name or _('no name')
					tasks[numTask].image	= fullNameDirs .. '/' .. tableTask.image	
					tasks[numTask].keySort 	= tableTask.keySort	or 1000															
				end
			end
		end					
	end	
end

function loadMission(fullNameTask, numTask, numLesson)
	for mis in lfs.dir(fullNameTask) do --      
		local fullNameMission  = U.fixPath(fullNameTask .. '/' .. mis);
		--base.print('Mission = "'..fullNameMission..'"', numLesson);
		local b = lfs.attributes(fullNameMission)					
		if b then									
			if (b.mode == 'directory') and (mis ~= '.') and (mis~='..') then 						
			else
				if (mis == 'lesson.lua') then
					local tableMis = Tools.safeDoFile(fullNameMission).lesson
					--base.U.traverseTable(tableMis)
					--base.print('Mission = ',fullNameTask .. '/' ..tableMis.file);
					tasks[numTask].lessons[numLesson].file 			= tableMis.file
					tasks[numTask].lessons[numLesson].path 			= fullNameTask 
					tasks[numTask].lessons[numLesson].name 			= tableMis.name or _('no name')
					tasks[numTask].lessons[numLesson].description 	= tableMis.description or _('no description')
					tasks[numTask].lessons[numLesson].keySort 		= tableMis.keySort	or 1000	
				end
			end
		end								
	end
end

function isEmptyTable(tab)
	for _, _ in base.pairs(tab) do
		return false
	end
	return true
end


function isValidateTask(a_task)
	if (a_task.name == nil) then
		return false
	end
	return true
end

function isValidateMission(mis)
	if (mis.file == nil) then
		return false
	end
	return true
end


function setupCallbacks()
    listboxTasks.onChange = onChangeListboxTask;
    listboxLessons.onChange = onChangeListboxLessons;
	window.containerMain.containerTrainingTask.downloadBtn.onChange = onButtonDownload;
    window.container_bottom.containerBottomButtons.leftBtn.onChange = onButtonBack;
    window.container_bottom.containerBottomButtons.rightBtn.onChange = onButtonStart;
    window.container_top.buttonClose.onChange = onButtonBack;

    window:addKeyCombination(onButtonBack, nil,'escape');    
    window:addKeyCombination(onButtonStart, nil,'enter');    
    window:addKeyCombination(onButtonStart, nil,'return');    
    
end;

function onButtonDownload()
	local lang = i18n.getLocale();
	
	local cmd
	
	if (lang == 'ru') then
		cmd = "start http://www.lockon.ru/fc2/training/video"
	else
		cmd =  "start http://lockon.co.uk/fc2/training/video"
	end
	
	
	--local cmd = "start http://lockon.eagle.ru/index.php?end_pos=1852\"&\"scr=default\"&\"lang="..lang
	--base.print("cmd=",cmd)
	base.os.execute(cmd)
end

function onButtonBack()
    show(false);
    base.mmw.show(true);
end;

function onButtonStart()    	
    --base.mmw.show(true);
    local item = listboxLessons:getSelectedItem();
	if (item == nil) then
		base.print("item == nil");
		return;
	end	
	
	show(false);
	
    local lesson = item.lesson;
    local file = lesson.file;
  --  local path = base.getFileName(base.mainPath .. '../Missions/Training/' .. file, true);
	local path = lesson.path .. '/' .. file;
	--base.print('path=',path)
    
	local posPoint = base.string.find(file, '.', 1, 1) 
	local type = base.string.sub(file, posPoint + 1)
	
	local TestFile = base.io.open(path, 'rb');
	base.print('file=',path, base.io.type(TestFile))
	
	if (base.io.type(TestFile) == 'file') then	
		TestFile:close()
		if (type ~= 'trk') then
            video.play(path)
			window:setVisible(true)
		else
			--MissionModule.applyOptions(path);
			--base.print('lesson:',path);
			MissionModule.play({ file = path, command = '--blocktrackviews'}, 'training', true)
		end
	else
		show(true);
	end
end;

function selectTask(index)
	if (tasks[index] == nil) then
		return
	end
    local item = tasks[index].item;
    listboxTasks:selectItem(item)
    listboxTasks:onChange(item)
    selectLesson(1)
end;

function selectLesson(index)
    local item = listboxTasks:getSelectedItem();
    local task = tasks[item.taskIndex];
    local lesson = task.lessons[index];
	if (lesson) then
		listboxLessons:selectItem(lesson.item)
		listboxLessons:onChange(lesson.item)
	end
end;

function onChangeListboxTask(self, item, dblClick)
    local theme = item:getTheme();
    theme.selectedTheme.image.file = tasks[item.taskIndex].image	--Theme.getImage('training-tasks.png');
    theme.selectedTheme.image.w = 256;
    theme.selectedTheme.image.h = 39;
    theme.selectedTheme.image.rect = {20,(item.taskIndex)*39, 256, 39};
    theme.selectedTheme.image.offset = {20,1};
    theme.selectedTheme.image.align = {'right', 'center'};
    theme.selectedTheme.color = {4/255, 171/255, 226/255};
    item:setTheme(theme);
    fillLessons(item.taskIndex);
end;

function onChangeListboxLessons(self, item, dblClick)
    local item = listboxLessons:getSelectedItem()
    local lesson = item.lesson;
    local description = lesson.description;
    updateLessonDescription(description) 
end;

function show(b, realMissionName)
    if b then
--		if (base.__LOP__ == false) then
--			local w = MsgWindow.new(_("Training tracks can't be played in patched version.  Sorry.   Please uninstall patch to view training tracks."),  _('Warning'), 'warning', 'OK')
--			w:setVisible(true);	
--			base.mmw.show(true);
--			return	
--		else
--			base.music.stop()
			if not created then    
				doCreate(base.unpack(startParameters))
			end;    
			if (realMissionName ~= nil) and (realMissionName ~= '') then
				local flag = false;
				for i,task in base.ipairs(tasks) do 
					for j,lesson in base.ipairs(task.lessons) do 
						if base.string.match(realMissionName, lesson.file) then
							selectTask(i);
							selectLesson(j);
							flag = true;
							break;
						end;
					end
					if flag == true then
						break;
					end;
				end
				if flag ~= true then
					selectTask(1);
				end;
			else
				selectTask(1);
			end;
--		end
--	else
--		base.music.start()
    end;
    if window then
        window:setVisible(b)
    end;
end

function fillTasks()
    for i,v in base.pairs(tasks) do 
        local item = ListBox.newItem(tasks[i].name)
        tasks[i].item = item;
        item:setTheme(Theme.newTrainingTasksListBoxItemTheme())
        item.taskIndex = i
        listboxTasks:insertWidget(item)
    end      
end;

function fillLessons(taskIndex)
    listboxLessons:clear();
    local task = tasks[taskIndex];
    for i,lesson in base.pairs(task.lessons) do 
        local item = ListBox.newItem(lesson.name)
        item:setTheme(Theme.newTrainingLessonsListboxItemTheme())
        item.lessonIndex = i
        item.lesson = lesson;
        lesson.item = item;
        listboxLessons:insertWidget(item)
    end
    selectLesson(1)
end;

function updateLessonDescription(description) 
    if description then
        scrollpaneDescription.widgetDescription:setText(description)
        local x,y,w,h = scrollpaneDescription:getBounds()
        scrollpaneDescription.widgetDescription:setBounds(10,10, w-30, h-12);
        _tmp, h = scrollpaneDescription.widgetDescription:calcSize();
        scrollpaneDescription.widgetDescription:setBounds(10,10, w-32, h);            
        scrollpaneDescription:setBounds(scrollpaneDescription:getBounds())
    else
        scrollpaneDescription.widgetDescription:setText('')
    end;

end;
