local base = _G

module('MainMenuForm')

local Widget = base.require('Widget')
local Button = base.require('Button')
local Window = base.require('Window')
local Theme = base.require('Theme')
local Container = base.require('Container')
local i18n = base.require('i18n')

i18n.setup(_M)

imagesPath = './data/images/'


cdata = {
    campaign = _('CAMPAIGN'),
    campaignBuilder = _('CAMPAIGN\nBUILDER'),
    editor = _('EDITOR'),
    logbook = _('LOGBOOK'),
    options = _('OPTIONS-MainMenu', 'OPTIONS'),
    exit = _('EXIT'),
    replay = _('REPLAY-MainMenu', 'REPLAY'),
    encyclopedia = _('ENCYCLOPEDIA'),
    training = _('TRAINING'),
    mission = _('MISSION'),    
    --instantAction = _('INSTANT ACTION'),    
	quickStart = _('QUICK START'),
	loversion = _('Версия 1.2.1'),
}

function createButton(menuParameter, container)
  -- local text = Widget.new()
  -- local textTheme = Theme.newMainMenuTextTheme()
  -- textTheme.image.rect = menuParameter.rect;
  -- textTheme.image.offset = menuParameter.offset;
  -- if menuParameter.align then
    -- textTheme.image.align = menuParameter.align;
  -- end;
  -- text:setTheme(textTheme)
  -- text:setBounds(base.unpack(menuParameter.bounds))
  -- container:insertWidget(text)
--[[    
  local Str = 'return function (fun)\n\t' .. menuParameter.name .. ' = fun()\nreturn ' .. menuParameter.name .. '\nend';
  --base.print(Str)
  local f = base.assert(base.loadstring(Str));
  base.setfenv(f,_M);
  local button = f()(Button.new);
--]]  
  _M[menuParameter.name] = Button.new();
  local theme = menuParameter.theme();
  local y = menuParameter.lineY or 0;
  local iconSize = 50;
  theme.upTheme.image.rect = { 0, y, 50, 50 };
  theme.hoverUpTheme.image.rect = { iconSize, y, 50, 50 };
  theme.downTheme.image.rect = { 2 * iconSize , y, 50, 50 };
  _M[menuParameter.name]:setTheme(theme);
  _M[menuParameter.name]:setBounds(base.unpack(menuParameter.bounds));
  _M[menuParameter.name]:setText(menuParameter.text);
  container:insertWidget(_M[menuParameter.name])     

end;

function create(x, y, w, h)
  window = Window.new(x, y, w, h)
  window:setTheme(Theme.newMainMenu2Theme())

  local container = Container.new();
  local theme = container:getTheme();
  theme.color = {1,0.5,0.3,0}
  container:setTheme(theme);
  local cx,cy,client_w,client_h = window:getClientRect();
  local dw = 0;
  if client_w > base.MAX_TEXTURE_SIZE then
	dw = (client_w - base.MAX_TEXTURE_SIZE)/2;
  end;
  
  --base.print(x, y, w, h, cx, cy, client_w, client_h)
  container:setBounds((client_w - 1024)/2, (client_h-768)/2, 1024, 768);
  window:insertWidget(container);
  
  local menuParameters = {
    {
    name = 'buttonCampaign',
    offset = {0, -25},
    rect = {0,11*50},
    lineY = 11*50;
    bounds = {403, 95, 212, 110},
    theme = Theme.newMainMenuTopButtonTheme,
    text = cdata.campaign,
    },
    {
    name = 'buttonQuickMission',
    offset = {0,25},
    rect = {0,9*16, 144, 16},
    lineY = 0*50;
    bounds = {398, 376, 222, 110},
    theme = Theme.newMainMenuCentralButtonTheme,
    text = cdata.quickStart,
    },
    {
    name = 'buttonExit',
    offset = {0,25},
    rect = {0,10*16, 37, 16},
    bounds = {404, 624, 212, 110},
    theme = Theme.newMainMenuBottomButtonTheme,
    text = cdata.exit,
    },
    {
    name = 'buttonOpenMission',
    offset = {-75, 0},
    rect = {0,3*16, 73, 16},
    bounds = {182, 177, 222, 74},
    theme = Theme.newMainMenuLeftButtonTheme,
    align = {'right', 'center'},
    lineY = 10*50;
    text = cdata.mission,
    },
    {
    name = 'buttonTraining',
    offset = {-75, 0},
    rect = {0,2*16, 83, 16},
    lineY = 9*50;
    bounds = {92, 300, 222, 74},
    theme = Theme.newMainMenuLeftButtonTheme,
    align = {'right', 'center'},
    text = cdata.training,
    },
    {
    name = 'buttonEncyclopedia',
    offset = {-72,0},
    rect = {0,1*16,131,16},
    lineY = 8*50;
    bounds = {92, 452, 222, 74},
    theme = Theme.newMainMenuLeftButtonTheme,
    align = {'right', 'center'},
    text = cdata.encyclopedia,
    },
    {
    name = 'buttonShowReplays',
    offset = {-75, 0},
    rect = {0,0*16,64,16},
    lineY = 5*50;
    bounds = {182, 575, 222, 74},
    theme = Theme.newMainMenuLeftButtonTheme,
    align = {'right', 'center'},
    text = cdata.replay,
    },
    {
    name = 'buttonCampaignBuilder',
    offset = {75, 0},
    rect = {0,4*16,96,32},
    lineY = 12*50;
    bounds = {616, 178, 222, 74},
    theme = Theme.newMainMenuRightButtonTheme,
    align = {'left', 'center'},
    text = cdata.campaignBuilder,
    },
    {
    name = 'buttonMissionEditor',
    offset = {75, 0},
    rect = {0,6*16,61,16},
    lineY = 13*50;
    bounds = {706, 300, 222, 74},
    theme = Theme.newMainMenuRightButtonTheme,
    align = {'left', 'center'},
    text = cdata.editor,
    },
    {
    name = 'buttonPilotLogbook',
    offset = {75, 0},
    rect = {0,7*16,86,16},
    lineY = 14*50;
    bounds = {706, 452, 222, 74},
    theme = Theme.newMainMenuRightButtonTheme,
    align = {'left', 'center'},
    text = cdata.logbook,
    },
    {
    name = 'buttonOptions',
    offset = {75, 0},
    rect = {0,8*16,76,16},
    lineY = 7*50;
    bounds = {616, 575, 222, 74},
    theme = Theme.newMainMenuRightButtonTheme,
    align = {'left', 'center'},
    text = cdata.options,
    },
  }
  
  for i = 1, #menuParameters do
    createButton(menuParameters[i], container)
  end;
  

  
    if base.__LOP__  == true then
      -- black shark logo
      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      theme.image.file = Theme.getImage('Lockon-logo.png')
      --theme.image.rect = {256,0,128,42};
      --theme.image.color = {0,0,0,0.5};
      theme.image.align = {'left', 'top'}
      --theme.border = Theme.newSimple1Border({0,0,0});
      --theme.text.font = Theme.fontsPath .. 'DejaVuLGCSansCondensed-Oblique.ttf'
      theme.text.font = Theme.fontsPath .. 'DejaVuLGCSansCondensed-BoldOblique.ttf'
      theme.text.size = 9.5
      theme.text.align = {'right', 'bottom'}
      theme.text.color = {1,1,1}
      theme.text.offset = {-31,-10};
      widget:setTheme(theme)
      --widget:setText(_('MODERN AIR COMBAT'));
      widget:setBounds(client_w - 256 - 15 - dw, 6, 256, 128)
      window:insertWidget(widget)    

      -- Eagle Dynamics logo
      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      --theme.border = Theme.newSimple1Border({0,0,0,1});
      theme.image.rect = {0,0,128,128};
      widget:setTheme(theme)
      --widget:setBounds(client_w - 128 - dw, client_h - 128, 128, 128)
      widget:setBounds(6 + dw, client_h - 127, 128, 128)
      window:insertWidget(widget)  

      -- Version text
      widget = Widget.new();
      --theme = Theme.newImagePreviewTheme()
      theme = widget:getTheme()
      theme.text.font = Theme.fontsPath .. 'DejaVuLGCSansCondensed-Bold.ttf'
      theme.text.size = 14
      theme.text.align = {'right', 'center'}
      theme.text.color = {0,0,0}
      theme.text.offset = {-8,0}
      widget:setTheme(theme)
      widget:setText(cdata.loversion);
      widget:setBounds(client_w - 256 - 20 - dw, 20 + 62, 246, 65)
      window:insertWidget(widget)      

	else  

	-- Kamov logo
      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      theme.image.rect = {128,0,128,128};
      widget:setTheme(theme)
      widget:setBounds(6 + dw, client_h - 127, 128, 128)
      window:insertWidget(widget)  
      
      -- Eagle Dynamics logo
      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      theme.image.rect = {0,0,128,128};
      widget:setTheme(theme)
      widget:setBounds(client_w - 128 - dw, client_h - 128, 128, 128)
      window:insertWidget(widget)  
      
      -- ka-50 and blackshark text
      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      theme.image.rect = {256,0,256,42};
      theme.image.color = {0,0,0};
      theme.image.align = {'right', 'center'}
      widget:setTheme(theme)
      widget:setBounds(client_w - 256 - 20 - dw, 20, 256, 42)
      window:insertWidget(widget)  

      widget = Widget.new();
      theme = Theme.newMainMenuLogoTheme()
      theme.image.rect = {256,44,256,19};
      theme.image.color = {237/255,33/255,39/255};
      theme.image.align = {'right', 'center'}
      --theme.border = Theme.newSimple1Border({0,0,0});
      widget:setTheme(theme)
      widget:setBounds(client_w - 256 - 20 - dw, 20 + 42, 256, 19)
      window:insertWidget(widget)      
      
      -- Version text
      widget = Widget.new();
      --theme = Theme.newImagePreviewTheme()
      theme = widget:getTheme()
      theme.text.font = Theme.fontsPath .. 'DejaVuLGCSansCondensed.ttf'
      theme.text.size = 11
      theme.text.align = {'right', 'center'}
      theme.text.color = {0,0,0}
      theme.text.offset = {-8,0}
      widget:setTheme(theme)
      widget:setText(_('Version 1.0.2'));
      widget:setBounds(client_w - 256 - 20 - dw, 20 + 62, 256, 19)
      window:insertWidget(widget)      
    end;  
  

  -- dcs logo
  widget = Widget.new();
  theme = widget:getTheme()
  theme.image.file = Theme.getImage('DCS-plate.png')
  theme.image.rect = {0,0,443,42}
  --theme.image.rect = {256,0,256,61};
  widget:setTheme(theme)
  widget:setBounds(0 + dw, 0, 443, 42)
  window:insertWidget(widget)  
  return;
end
