
MIG25P =  {
      
		Name 			= 'MIG25P',--AG
		DisplayName		= _('MiG-25P AI'),--AG
        Picture 		= "MIG25P.png",
        Rate 			= "50",
        Shape			= "MIG25P",--AG	
        WorldID			=  24, --WSTYPE_PLACEHOLDER
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'MIG25P';--AG
			life  	 	= 15; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'MIG25P';--AG
			index       =  24;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 24, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	20000,	-- kg  with pilot and nose load, F15
		M_nominal					=	35000,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	41000,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	15000,	-- kg (Internal Fuel Only)
		H_max						=	22500,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.415,
		CAS_min						=	78,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	310,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	71,		-- Take off speed in m/s (for AI)
		V_land						=	81,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,
		defFuelRatio = 0.66,
		input_profile_entry = 	"MIG25P",

		nose_gear_pos 				                = {4.594, -2.092, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.754, -- in m
	
	    main_gear_pos 						 	    = {-0.691, -2.028, 2.162}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.972, -- in m

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	5,		-- Max G (for AI)
		V_max_sea_level				=	423,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	34.5,	-- wing area in m2
		thrust_sum_max				=	16036,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	26500,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.8,	-- Max speed in Mach (for AI)
		range						=	2740,	-- Max range in km (for AI)
		RCS							=	15,		-- Radar Cross Section m2
		Ny_max_e					=	5,		-- Max G (for AI)
		detection_range_max			=	130,
		IR_emission_coeff			=	3,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	6,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	0,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	14.05,--XX  wing spain in m
		wing_type 					= 	1,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	19.43,
		height						=	5.63,
		crew_size					=	1, --XX
		engines_count				=	2, --XX
		wing_tip_pos 				= 	{-4.922, 0.206, 6.908},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
	{
		[1] = 
		{
			pos					=	{-6.862, 0.291, -0.796},
				elevation			=	0,
				diameter			=	1.512,
				exhaust_length_ab	=	15.77,
				exhaust_length_ab_K	=	0.76,
				smokiness_level		=	0.4,
				afterburner_effect_texture = "afterburner_f-16c",
		}, -- end of [1]
		[2] = 
		{
			pos					=	{-6.862, 0.291, 0.829},
				elevation			=	0,
				diameter			=	1.512,
				exhaust_length_ab	=	15.77,
				exhaust_length_ab_K	=	0.76,
				smokiness_level		=	0.4,
				afterburner_effect_texture = "afterburner_f-16c",
		}, -- end of [2]
		}, -- end of engines_nozzles
		crew_members = 
	{
			[1] = 
			{
				ejection_seat_name	=	17,
				drop_canopy_name	=	23,
				canopy_pos			= 	{4.282, 0.620, 0.00},
				pos					=	{6.972, 0.8, 0},
				pilot_body_arg		=	-1,
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	4,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{0,	0,	0},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.207,	1.511},
			[3] = 	{0.173,	-0.207,	-1.511},
			[4] = 	{-0.82,	0.165,	1.774},
			[5] = 	{-0.82,	0.165,	-1.774},
			[6] = 	{-0.82,	0.155,	2.274},
			[7] = 	{-0.82,	0.155,	-2.274},
			[8] = 	{-6.899,	-0.112,	0.611},
			[9] = 	{-6.899,	-0.112,	-0.611},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/MIG25P_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
	{
			[1] = 
			{
				dir = 	{0, -1.0, 0.3},
				pos = 	{-5.403, -0.302, 0.639},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0, -1.0, -0.3},
				pos = 	{-5.13, -0.1, 1.108},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 72,
chaff 				= {default = 36, increment = 12, chargeSz = 1},
flare 				= {default = 36, increment = 12, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 	= "N-008",--Mig23
IRST 	= "TP-23M",--Mig23
RWR 	= "Abstract RWR"--F15
},
Countermeasures = {
--ECM 			= "AN/ALQ-135"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns = {gun_mount("M_61", { count = 0 },{muzzle_pos = {3.11, -1.2, 0}}),--3.906000, 0.768000, -0.975000
},

pylons_enumeration = {1, 4, 2, 3},

	Pylons =     {

        pylon(1, 0, -0.9, 0.03, -4.615,
            {
                FiZ = 0, --payload angle, plus up, minus down.
            },
            {
			    { CLSID	= "{R-60}" }, --R60M
			    { CLSID	= "{mig25-r40r}" }, --R40R
			    { CLSID	= "{mig25-r40t}" }, --R40T
            }
        ),
		pylon(2, 0, 0.1, 0.031, -3.47,
            {
                FiZ = 0,
            },
            {
			    { CLSID	= "{mig25-r40r}" }, --R40R
			    { CLSID	= "{mig25-r40t}" }, --R40T
            }
        ),
        pylon(3, 0, 0.1, 0.031, 3.47,
            {
                FiZ = 0,
            },
            {
			    { CLSID	= "{mig25-r40r}" }, --R40R
			    { CLSID	= "{mig25-r40t}" }, --R40T
            }
        ),
        pylon(4, 0, -0.9, 0.03, 4.615,
            {
                FiZ = 0,
            },
            {
			    { CLSID	= "{R-60}" }, --R60M
			    { CLSID	= "{mig25-r40r}" }, --R40R
			    { CLSID	= "{mig25-r40t}" }, --R40T
            }
        ),

},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    	--aircraft_task(GroundAttack),
     	--aircraft_task(CAS),
        --aircraft_task(AFAC),
        --aircraft_task(RunwayAttack),
        --aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	4.35,
			Mzalfadt	=	0.8,
			kjx = 2.75,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.016,
			cx_flap = 0.075,
			cy_flap = 0.6,
			cx_brk = 0.03,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0.0,	0.0215,		0.055,		0.08,		0.22,	0.65,	25.0,	1.2 	},
				{0.1,	0.0215,		0.055,		0.08,		0.22,	1.80,	25.0,	1.2     },
				{0.2,	0.0215,		0.055,		0.08,	   	0.22,	3.00,	25.0,	1.2     },
				{0.31,	0.0215,		0.055,		0.05,		0.28,	4.20,	25.0,	1.2     },
				{0.42,	0.0215,		0.055,		0.05,		0.28,	4.20,	23.0,	1.15    },
				{0.54,	0.0215,		0.055,		0.05,		0.28,	4.20,	21.7,	1.1     },
				{0.64,	0.0230,		0.058,		0.09,		0.20,	4.20,	20.1,	1.07    },
				{0.76,	0.0320,		0.062,		0.17,		0.15,	4.20,	18.9,	1.04    },
				{0.86,	0.0430,		0.062,	   	0.235,		0.09,	3.78,	17.4,	1.02    },
				{0.94,	0.0460,		0.062,	   	0.285,		0.08,	2.94,	17.0,	1.00 	},		
				{1.04,	0.0470,		0.06,	   	0.29,		0.10,	2.10,	16.0,	0.92 	},				
				{1.12,	0.0470,		0.056,	   	0.3,		0.136,	1.80,	15.0,	0.80 	},					
				{1.31,	0.0470,		0.052,	   	0.34,		0.21,	1.08,	13.0,	0.7 	},					
				{1.5,	0.0460,		0.042,	   	0.34,		2.43,	0.96,	12.0,	0.55 	},		
				{1.9,	0.0420,		0.037,	   	0.49,		3.5,	0.84,	 10.0,	0.37 	},					
				{2.2,	0.0420,		0.033,		0.6,		4.7,	0.84,	 9.0,	0.3 	},		
				{2.6,	0.0420,		0.028,		0.7,		5.2,	0.84,	 8.0,	0.3 	},		
				{3.9,	0.0400,		0.023,		0.9,		6.0,	0.84,	 7.0,	0.2		},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	23,
			dcx_eng	=	0.0114,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6500,
			dpdh_f	=	12200.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0.0,	125000,		242000},
				{0.2,	118000,		230000},
				{0.4,	116000,		235000},
				{0.6,	123000,		237000},
				{0.7,	125000,		240000},
				{0.8,	125000,		250000},
				{0.9,	125000,		255000},
				{1.0,	127000,		280000},
				{1.1,	123000,		298000},
				{1.2,	114000,		308000},
				{1.3,	104000,		315000},
				{1.4,	101000,		320000},
				{1.6,	 44000,		338000},
				{1.8,	 29000,		347000},
				{2.2,	 27000,		357000},
				{2.5,	 29000,		340000},
				{3.0,	102000,		300000},
				{3.9,	102000,		220000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 5, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 5, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 5, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "MIG-25-OBLOMOK-WING-R", -- wing R
		[2] = "MIG-25-OBLOMOK-WING-L", -- wing L
	},
	
	lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 49, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", position = { 2.542, -0.826, 0.789 }, dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
}

add_aircraft(MIG25P) --AG
