
M2000_5 =  {
      
		Name 			= 'M2000_5',--AG
		DisplayName		= _('Mirage 2000-5 Mk2'),--AG
        Picture 		= "Mirage_2000-5.png",
        Rate 			= "50",
        Shape			= "M2000_5",--AG	
        WorldID			=  WSTYPE_PLACEHOLDER, 
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'M2000_5';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'M-2000C_destr'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'M2000_5';--AG
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "M-2000C_destr";
			file  		= "M-2000C_destr";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	7500,	-- kg  with pilot and nose load, F15
		M_nominal					=	11450,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	17000,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	3950,	-- kg (Internal Fuel Only)
		H_max						=	17060,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.23,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	61,		-- Take off speed in m/s (for AI)
		V_land						=	71,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,

		nose_gear_pos 							 = {2.9,-1.50, 0.0},		-- nosegear coord
		nose_gear_wheel_diameter				 =  0.274,		-- in m
		nose_gear_amortizer_direct_stroke        =  0.220,  	    -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke      = -0.015,		-- up
		nose_gear_amortizer_normal_weight_stroke =  0.1,		-- down from nose_gear_pos

		main_gear_pos 							 = {-1.9,-1.50, 1.75},	-- main gear coords
		main_gear_wheel_diameter				 =  0.457,				-- in m
		main_gear_amortizer_direct_stroke        =  0.21,		-- down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke      = -0.01, 		-- up
		main_gear_amortizer_normal_weight_stroke =  0.0,				-- down from main_gear_pos

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	41.5,	-- wing area in m2
		thrust_sum_max				=	6550,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	9700,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	0.5,
		Mach_max					=	2.2,	-- Max speed in Mach (for AI)
		range						=	2340,	-- Max range in km (for AI)
		RCS							=	2,		-- Radar Cross Section m2
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	140,
		IR_emission_coeff			=	0.8,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	1.7,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	2,-- F14=2/S33=4/M29=0/S27=0/F15=1/F16=1/To=0/F18=2/A10A=1/M29K=4/M2000=2/F4=0/F5=0/
		wing_span					=	9.13,  --XX
		wing_type 					= 	0,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	19.43,
		height						=	5.63,
		crew_size					=	1,    --XX
		engines_count				=	1,    --XX
		wing_tip_pos 				= 	{ -5.0, -0.100, 4.565},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		--launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"VelType", 3}, {"Arg", 38, "to", 0.9, "in", 5.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"VelType", 3}, {"Arg", 38, "to", 0.0, "in", 3.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"Arg", 909, "set", 1.0},},},},},
        },
        ServiceHatches = {
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        CrewLadder = {
            {Transition = {"Dismantle", "Erect"}, Sequence = {
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
                {C = {{"Arg", 91, "set", 1.0}}},
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
            }},
            {Transition = {"Erect", "Dismantle"}, Sequence = {
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
                {C = {{"Arg", 91, "set", 0.0}}},
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
            }},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] =
			{
				pos 		=  {-6.900, 0.525, 0.000}, -- nozzle coords
				elevation   =  0, -- AFB cone elevation
				diameter	 = 1.15, -- AFB cone diameter
				exhaust_length_ab   = 9, -- lenght in m
				exhaust_length_ab_K = 0.5, -- AB animation
				smokiness_level = 0.2,
			}, -- end of [1]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
			ejection_seat_name	= "M-2000C_pilotseat",
			drop_canopy_name	= "M-2000c_canopy",
			pos					= {2.679, 0.512, 0.0, },
			canopy_pos			= {2.739, 0.677, 0.0},
			g_suit 			    =  5
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	2,--su-27=4/mig-29=3/su-33=0/F-15=0/tornado=0/F-117=2
		is_tanker	=	false,
		air_refuel_receptacle_pos 	= {5.436, 1.027, 0.409}, -- refuel coords
		fires_pos = 
		{
			[1] = 	{-3.484, -0.004, -0.149}, -- After maingear, fuselage bottom
			[2] = 	{-2.518,  0.055,  1.216}, -- Wing inner Left
			[3] = 	{-2.518,  0.055, -1.216}, -- Wing inner Right
			[4] = 	{-6.250,  0.525,  0.000}, -- Engine damage big
			[5] = 	{-6.750,  0.525,  0.000}, -- Engine damage small
			[6] = 	{-2.346, -0.448,  0.000}, -- Air intake bottom L
			[7] = 	{ 2.346, -0.448,  0.000}, -- Air intake bottom R
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/M2000_5_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	-1,	-1},--0,	1,	0  vorne
				pos = 	{-5.827,  0.835, -0.108},---5.776,	1.4,	-0.422
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	-1,	-1},--0,	1,	0
     			pos = 	{-5.827, -0.835, -0.108},---5.776,	1.4,	0.422
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 128,
chaff 				= {default = 64, increment = 16, chargeSz = 1},
flare 				= {default = 32, increment = 16, chargeSz = 2}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 			= "RDY",--M2000
RWR 			= "Abstract RWR"--F15
},
Countermeasures = {
ECM 			= "AN/ALQ-165"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns =  {
        gun_mount("DEFA_554", { count = 125 },{muzzle_pos_connector = "GUN_POINT_L", muzzle_pos = {1.389,  0.325, -0.241}}),
		gun_mount("DEFA_554", { count = 125 },{muzzle_pos_connector = "GUN_POINT_R", muzzle_pos = {1.389, -0.325, -0.241}})
        },		 
--2  30-mm-Revolverkanonen DEFA Canon 30 M 550 F4 (M554) mit je 125 Schuss Munition (nur Einsitzer-Varianten Mirage 2000C/-5)

pylons_enumeration = {1, 9, 2, 8, 7, 3, 6, 4, 5},

	Pylons =     {

        pylon(1, 0, -3.086, -0.587, 3.311, {use_full_connector_position=true, connector = "str_pnt_001", arg = 308, arg_value = 0},
            {
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - yellow	
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550				
            }
        ),
       pylon(2, 0, -1.809, -0.556, 2.333, {use_full_connector_position=true, connector = "str_pnt_002", arg = 309, arg_value = 0},
            {
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}", arg_value = 0.15 },--SUPER 530F
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },--MICA RF
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },--MICA IR
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550	
            }
        ),
        pylon(3, 0,  0.870,  -0.467, 0.779,{use_full_connector_position=true, connector = "str_pnt_003", arg = 310, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- Mk-82
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
            }
        ),
        pylon(4, 0, -3.115, -0.467, 1.080, {use_full_connector_position=true, connector = "str_pnt_004", arg = 311, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
            }
        ),
        pylon(5, 0, -1.075, -0.589, 0.000, {use_full_connector_position=true, connector = "str_pnt_005", arg = 312, arg_value = 0},
            {
                {CLSID = "{M2KC_RPL_522}", arg_value = 0.15 }, -- RPL 522 FUEL TANK
				{ CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - yellow
            }
        ),
        pylon(6, 0, -3.115, -0.467, -1.080, {use_full_connector_position=true, connector = "str_pnt_007", arg = 314, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
            }
        ),
        pylon(7, 0,  0.870, -0.467, -0.779,{use_full_connector_position=true, connector = "str_pnt_006", arg = 313, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
            }
        ),
        pylon(8, 0, -1.809, -0.556, -2.333, {use_full_connector_position=true, connector = "str_pnt_008", arg = 315, arg_value = 0},
            {
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}", arg_value = 0.15 },--SUPER 530F
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },--MICA RF
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },--MICA IR
				{CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.35 }, -- MK-82
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550	
            }
        ),
        pylon(9, 0,  -3.086, -0.587, -3.311, {use_full_connector_position=true, connector = "str_pnt_009", arg = 316, arg_value = 0},
            {
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - yellow	
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550	
            }
        ),
},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
--  	aircraft_task(GroundAttack),
--     	aircraft_task(CAS),
--      aircraft_task(AFAC),
--	    aircraft_task(RunwayAttack),
--  	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(FighterSweep),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	6.6,
			Mzalfadt	=	1,
			kjx = 2.85,
			kjz = 0.00125,
			Czbe = -0.012,
			cx_gear = 0.02,
			cx_flap = 0.05,
			cy_flap = 0.6,
			cx_brk = 0.03,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.01, 0.081, 0.15, 0.11, 0.5, 24, 1.28 }, { 0.05, 0.01, 0.079, 0.15, 0.1, 1, 29, 1.14 }, { 0.1, 0.01, 0.074, 0.15, 0.09, 2.8, 17, 1.07 }, { 0.2, 0.01, 0.069, 0.15, 0.075, 3.28, 17, 0.98 }, { 0.3, 0.01, 0.067, 0.1442, 0.3897, 3.4, 17, 0.95 }, { 0.4, 0.011, 0.064, 0.1383, 0.7044, 4.363, 17, 0.95 },
				{ 0.6, 0.011, 0.065, 0.1265, 1.3339, 4.854, 17, 0.95 }, { 0.7, 0.012, 0.065, 0.1206, 1.6486, 4.829, 17, 0.93 }, { 0.8, 0.013, 0.066, 0.1148, 1.9633, 4.803, 17, 0.925 }, { 0.85, 0.013, 0.067, 0.1118, 2.1206, 4.778, 17, 0.92 }, { 0.9, 0.014, 0.071, 0.1089, 2.278, 4.752, 17, 0.915 }, { 1, 0.015, 0.082, 0.103, 2.5927, 4.726, 17, 0.91 }, { 1.05, 0.016, 0.085, 0.1, 2.75, 4.713, 17, 0.905 }, { 1.1, 0.016, 0.086, 0.1035, 2.7586, 4.701, 17, 0.9 }, { 1.2, 0.0165, 0.083, 0.1104, 2.7759, 4.675, 17, 0.9 }, { 1.3, 0.017, 0.077, 0.1173, 2.7931, 4.65, 16, 0.9 }, { 1.5, 0.018, 0.062, 0.1311, 2.8276, 4.598, 13, 0.9 }, { 1.7, 0.02, 0.051, 0.1449, 2.8621, 4.547, 12, 0.7 }, { 1.8, 0.021, 0.046, 0.1518, 2.8793, 4.522, 11.4, 0.64 }, { 2, 0.023, 0.039, 0.1656, 2.9138, 4.47, 10.2, 0.52 }, { 2.1, 0.024, 0.034, 0.1725, 2.931, 4.445, 9, 0.4 }, { 2.2, 0.0245, 0.034, 0.1794, 2.9483, 4.419, 9, 0.4 }, { 2.5, 0.03, 0.033, 0.2, 3, 3.5, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	51,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.2,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	4100,
			dpdh_f	=	12000.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 64300, 95000 }, { 0.2, 67000, 96000 }, { 0.4, 67000, 96000 }, { 0.6, 67000, 102000 }, { 0.7, 67000, 111000 }, { 0.8, 75000, 126000 }, { 0.9, 75000, 145000 }, { 1, 75000, 164000 }, { 1.1, 75000, 177000 }, { 1.2, 80000, 187000 }, { 1.3, 82000, 194000 }, { 1.5, 76000, 213000 }, { 1.8, 69246, 229000 }, { 2, 71719, 233000 }, { 2.2, 70483, 240000 }, { 2.5, 68009, 237000 }, { 3, 61827, 117436 },
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		-- NOSE, COCKPIT & AVIONICS
		[0]	 = {critical_damage =  3, args = {82}},		-- NOSE_CENTER
		[1]	 = {critical_damage =  5, args = {150}},	-- NOSE_LEFT_SIDE
		[2]	 = {critical_damage =  5, args = {149}},	-- NOSE_RIGHT_SIDE
		[3]	 = {critical_damage =  2, args = {65}},		-- COCKPIT
		[4]	 = {critical_damage =  5, args = {298}},	-- CABIN_LEFT_SIDE
		[5]	 = {critical_damage =  5, args = {299}},	-- CABIN_RIGHT_SIDE
		[90] = {critical_damage =  5},					-- PILOT
		[86] = {critical_damage =  4, args = {300}},	-- AVIONICS BAY 1 (PYLON1)
		[87] = {critical_damage =  4, args = {301}},	-- AVIONICS BAY 2 (PYLON2)
		[88] = {critical_damage =  4, args = {302}},	-- JAMMER (PYLON3)

		-- CONTROL SURFACES
		[53] = {critical_damage =  3, args = {248}},	-- RUDDER
		[25] = {critical_damage =  3, args = {226}},	-- AILERON L
		[51] = {critical_damage =  4, args = {240}},	-- ELEVATOR L IN
		[52] = {critical_damage =  4, args = {238}},	-- ELEVATOR R IN
		[26] = {critical_damage =  3, args = {216}},	-- AILERON R
		[21] = {critical_damage =  3, args = {232}},	-- SLAT L OUT
		[33] = {critical_damage =  4, args = {230}},	-- SLAT L IN
		[22] = {critical_damage =  3, args = {222}},	-- SLAT R OUT
		[34] = {critical_damage =  4, args = {220}},	-- SLAT R IN
		[19] = {critical_damage =  2, args = {183}},	-- AIRBRAKE LEFT
		[20] = {critical_damage =  2, args = {185}},	-- AIRBRAKE RIGHT

		-- ENGINE & FUEL TANKS
		[11] = {critical_damage = 5,  args = {271}},	-- ENGINE
		[61] = {critical_damage = 4,  args = {224}},	-- FUEL_TANK_LEFT_SIDE
		[62] = {critical_damage = 4,  args = {214}},	-- FUEL_TANK_RIGHT_SIDE
		[65] = {critical_damage = 4,  args = {155}},	-- FUEL_TANK_CENTER (BLADE_1_CENTER)
		[66] = {critical_damage = 3               },	-- BATTERY (BLADE_1_OUT)
		[67] = {critical_damage = 3               },	-- ALTERNATOR 1 (BLADE_2_IN)
		[68] = {critical_damage = 3               },	-- ALTERNATOR 2 (BLADE_2_CENTER)
		[69] = {critical_damage = 3               },	-- CONVERTER 1 (BLADE_2_OUT)
		[70] = {critical_damage = 3               },	-- CONVERTER 2 (BLADE_3_IN)
		[71] = {critical_damage = 3               },	-- HYD PUMP 1 (BLADE_3_CENTER)
		[72] = {critical_damage = 3               },	-- HYD PUMP 2 (BLADE_3_OUT)

		-- FUSELAGE & WINGS
		[39] = {critical_damage = 3,  args = {244}},								-- FIN L TOP
		[41] = {critical_damage = 4,  args = {245}, deps_cells = {39,53}},			-- FIN L CENTER
		[43] = {critical_damage = 5,  args = {246}, deps_cells = {41,88}},			-- FIN L BOTTOM
		[23] = {critical_damage = 3,  args = {223}, deps_cells = {21}},				-- WING_L_OUT
		[29] = {critical_damage = 5,  args = {224}, deps_cells = {19,23,84}},	    -- WING_L_CENTER
		[35] = {critical_damage = 4,  args = {225}, deps_cells = {23,21,29,33,61,15,84}},	-- WING_L_IN
		[36] = {critical_damage = 4,  args = {215}, deps_cells = {24,22,30,34,62,16,85}},	-- WING_R_IN
		[30] = {critical_damage = 5,  args = {214}, deps_cells = {20,24,85}},	    -- WING_R_CENTER
		[24] = {critical_damage = 3,  args = {213}, deps_cells = {22}},				-- WING_R_OUT
		[9]	 = {critical_damage = 5,  args = {154}},								-- FUSELAGE_LEFT_SIDE
		[82] = {critical_damage = 5,  args = {152}, deps_cells = {11}},				-- FUSELAGE_BOTTOM
		[10] = {critical_damage = 5,  args = {153}},								-- FUSELAGE_RIGHT_SIDE
		[55] = {critical_damage = 4,  args = {159}, deps_cells = {11}},				-- TAIL PIPE
		[56] = {critical_damage = 4,  args = {158}},								-- TAIL LEFT
		[57] = {critical_damage = 4,  args = {157}},								-- TAIL RIGHT
		[58] = {critical_damage = 4,  args = {156}, deps_cells = {11}}, 			-- TAIL BOTTOM

		-- LANDING GEAR
		[8]  = {critical_damage = 6, args = {265}, deps_cells = {83}},	-- FRONT_GEAR_BOX
		[15] = {critical_damage = 6, args = {267}, deps_cells = {84}},	-- LEFT_GEAR_BOX
		[16] = {critical_damage = 6, args = {266}, deps_cells = {85}},	-- RIGHT_GEAR_BOX
		[83] = {critical_damage = 3, args = {134}},						-- WHEEL F
		[84] = {critical_damage = 3, args = {135}},						-- WHEEL L
		[85] = {critical_damage = 3, args = {136}},						-- WHEEL R

		-- WEAPONS
		[7]  = {critical_damage = 3, args = {296}},						-- GUNS

	},
	
	DamageParts = 
	{  
		[1] = "M-2000c-oblomok-wing-R", -- wing R
		[2] = "M-2000c-oblomok-wing-L", -- wing L
		[1000 + 0]  = "M2KC-fragment-nose",
		[1000 + 1]  = "M2KC-fragment-nose-1",
		[1000 + 35] = "M-2000c-oblomok-wing-L",
		[1000 + 29] = "M-2000c-oblomok-wing-L",
		[1000 + 23] = "M-2000c-oblomok-wing-L",
		[1000 + 35] = "M-2000c-oblomok-wing-R",
		[1000 + 29] = "M-2000c-oblomok-wing-R",
		[1000 + 23] = "M-2000c-oblomok-wing-R",
		[1000 + 47] = "M2KC-fragment-stabilizador-L",
		[1000 + 48] = "M2KC-fragment-stabilizador-R",
		[1000 + 55] = "M2KC-fragment-tail",
		[1000 + 41] = "M2KC-fragment-fin-center",
		[1000 + 5]  = "M2KC-fragment-canopy",
		[1000 + 3]  = "M2KC-fragment-canopy-back",
	},
	

	lights_data =
	{
		typename =	"collection",
		lights 	 = 
		{
			[WOLALIGHT_STROBES]	= {
				typename	=	"collection",
				lights 		= {
					{typename = "argnatostrobelight",  argument = 83,  period = 1.333,  phase_shift = 0.0}, -- Top Strobe
					{typename = "argnatostrobelight",  argument = 802, period = 1.333,  phase_shift = 0.5}, -- Bottom Strobe
				},
			},--must be collection
			[WOLALIGHT_LANDING_LIGHTS]	= {
				typename	= 	"collection",
				lights		= {
					{typename = "argumentlight", argument = 208, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
					{typename = "argumentlight", argument = 208, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
				},
			},--must be collection
			[WOLALIGHT_TAXI_LIGHTS]	= {
				typename	= 	"collection",
				lights		= {
					{typename = "argumentlight", argument = 209, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
					{typename = "argumentlight", argument = 209, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
				},
			},--must be collection
			[WOLALIGHT_NAVLIGHTS]	= {
				typename 	= "collection",
				lights 		= {
					{typename = "argumentlight",  argument  = 190}, --Red Position
					{typename = "argumentlight",  argument  = 192}, --Green Position
					{typename = "argumentlight",  argument  = 191}, --White Position
				},
			},--must be collection
			[WOLALIGHT_FORMATION_LIGHTS] = {
				typename	= "collection",
				lights		= {
					{typename = "argumentlight",argument = 200}, -- form front
					{typename = "argumentlight",argument = 201}, -- form aft
				},		-- green bars
			},--must be collection
			-- REFUEL
			[WOLALIGHT_REFUEL_LIGHTS] = {
				typename = "collection",
				lights	 = {
					{typename = "argumentlight", connector = "CNT_RF1", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 903}, -- Right Side Low
					{typename = "argumentlight", connector = "CNT_RF2", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 907, speed = 1.0}, -- Right Side High
					{typename = "argumentlight", connector = "CNT_RF3", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 908, speed = 1.0}, -- Nose High
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{ typename = "argumentlight", argument = 69, },
				},
			},
		}, -- end of lights
	},-- end of lights_data
}

add_aircraft(M2000_5) --AG
