 local RAIL 	= 0
 local CATAPULT = 1

local BD4_pylons =
{
	[4] = "Point4_BD4",
	[7] = "Point7_BD4",
	[9] = "Point9_BD4",
}

local EMPTY_station =
{
	[2]  = "PYLON_2",
	[3]  = "PYLON_3",
	[4]  = "PYLON_4",
	[5]  = "PYLON_5",
	[6]  = "PYLON_6",
	[7]  = "PYLON_7",
	[8]  = "PYLON_8",
	[9]  = "PYLON_9",
	[10] = "PYLON_10"
}

local function BD4_(station,clsid)
	local conn = BD4_pylons[station]
	if conn ~= nil then
		return {CLSID = clsid,  connector = conn , arg_value = 0.1 }
	else
		return {CLSID = clsid}
	end
end

local function WITHOUT_BD(station,clsid,launch_type)
	local conn = EMPTY_station[station]
	if conn ~= nil then
		return {CLSID = clsid, connector = conn , arg_value = 1,Type = launch_type}
	else
		return {CLSID = clsid,Type = launch_type}
	end
end

local SIDE_R73		= { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}

local APU_R73		= { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 0.55}							-- R_73 APU-73

local AKU_R77		= { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", arg_value = 0.25,	Type = CATAPULT}		-- R-77 AKU-170

local AKU_R27R		= { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", arg_value = 0.3,	Type = CATAPULT}		-- R-27 AKU-470
local AKU_R27ER		= { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.3,	Type = CATAPULT}		-- R-27 AKU-470
local APU_R27R		= { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", arg_value = 0.35}							-- R-27 APU-470
local APU_R27ER		= { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.35}							-- R-27 APU-470

local AKU_R27T		= { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", arg_value = 0.3,	Type = CATAPULT}
local AKU_R27ET		= { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.3,	Type = CATAPULT}
local APU_R27T		= { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", arg_value = 0.35}
local APU_R27ET		= { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.35}

local function BD3(clsid)
	return {CLSID = clsid, arg_value = 0.05 }
end

local function MER_6xFAB100(station)
	return	WITHOUT_BD(station,"{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}")
end

local function MER_6xFAB250(station)
	return	WITHOUT_BD(station,"{53BE25A4-C86C-4571-9BC0-47D668349595}")
end

local function MER_5xFAB250(station)
	return	WITHOUT_BD(station,"{MBD3_U6_5*FAB-250}")
end

local ADD_LIST = function(dest,src)
	local t = dest or {}
	if src then
		for i,o in ipairs(src) do
			t[#t + 1] = o
		end
	end
	return t
end

local AG_MISSILES_APU68 = 
{
	---------------------------------------------------------------------
	{ CLSID = "{X-25MPU}",	arg_value = 0.35 },					--	Kh-25MPU
	{ CLSID = "{X-25ML}",	arg_value = 0.35 },					--	Kh-25ML
	{ CLSID = "{X-25MR}",	arg_value = 0.35 },					--	Kh-25MR
	---------------------------------------------------------------------
}

local AG_MISSILES = 
{
	---------------------------------------------------------------------
	{ CLSID = "{X-29T}", arg_value = 0.45, Type = CATAPULT },	--	Kh-29T
	{ CLSID = "DIS_BRM1_90", arg_value = 0.35 },                --  BRM-90
	{ CLSID = "{X-29L}", arg_value = 0.45, Type = CATAPULT },	--	Kh-29L
	{ CLSID = "{X-31A}", arg_value = 0.45, Type = CATAPULT },	--	Kh-31A
	{ CLSID = "{X-31P}", arg_value = 0.45, Type = CATAPULT },	--	Kh-31P
	{ CLSID = "{KH_59MK2}", arg_value = 0.45, Type = CATAPULT },	--	Kh-59MK2
	{ CLSID = "{B5CA9846-776E-4230-B4FD-8BCC9BFB1676}", arg_value = 0.45, Type = CATAPULT }, -- Kh-58U
	{ CLSID = "{TWIN_B13L_5OF}", arg_value = 1},
	{ CLSID = "{TWIN_B_8M1_S_8KOM}", arg_value = 1 },
	{ CLSID = "{TWIN_B_8M1_S_8_OFP2}", arg_value = 1 },
	{ CLSID = "{TWIN_B_8M1_S_8TsM}", arg_value = 1 },
	------------------------------------------------------------------
}

local ROCKETS = 
{
	---------------------------------------------------------------------
	BD3("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"),	--	B-8M1 - 20 S-8KOM
	BD3("{FC56DF80-9B09-44C5-8976-DCFAFF219062}"), 	--	B-13L - 5 S-13 OF
	------------------------------------------------------------------
}

local BOMBS_UP_TO_500 =
{
	BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),	--	BetAB-500
	BD3("{4203753F-8198-4E85-9924-6F8FF679F9FF}"),	--	RBK-250 PTAB-2.5M
	BD3("{RBK_250_275_AO_1SCH}"),					--	RBK-250-275 AO-1SCH
	BD3("{RBK_500U_OAB_2_5RT}"),					--	RBK-500U OAB-2.5RT
	BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),	--	RBK-500-255 PTAB-10-5
	BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),	--	RBK-500 PTAB-1M
	BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"),	--	FAB-250
	BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"),	--	FAB-500 M62
	BD3("{BA565F89-2373-4A84-9502-A0E017D3A44A}"),	--	KAB-500L
	BD3("{E2C426E3-8B10-4E09-B733-9CDC26520F48}"),	--	KAB-500Kr
	BD3("{KAB_500S_LOADOUT}"),						--	KAB-500S
	BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"),	--	SAB-100
	BD3("{FB3CE165-BF07-4979-887C-92B87F13276B}"),	--	FAB-100
	MER_6xFAB100(actual_index), 					--  6 * FAB-100
}

local BD_FAB_1500 = {CLSID	= "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15 }		--	FAB-1500 M54

local HEAVY_GUIDED_BOMBS = function(actual_index)
	return {
		BD4_(actual_index,"{39821727-F6E2-45B3-B1F0-490CC8921D1E}"),		--	KAB-1500L
		BD4_(actual_index,"{KAB_1500LG_LOADOUT}"),							--	KAB-1500LG-Pr
		BD4_(actual_index,"{KAB_1500Kr_LOADOUT}"),							--	KAB-1500Kr
	}
end

local DEFAULT_AG_ORDNANCE = function(actual_index)
	local t = {}
	ADD_LIST(t,AG_MISSILES)
	ADD_LIST(t,AG_MISSILES_APU68)
	ADD_LIST(t,ROCKETS)
	ADD_LIST(t,BOMBS_UP_TO_500)
	ADD_LIST(t,{
		{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" },	--	KMGU-2 - 96 AO-2.5RT
		{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" },	--	KMGU-2 - 96 PTAB-2.5KO
	})
	return t
end

local STATION_2 =
{
	APU_R73,
	AKU_R77,
}

local STATION_3 = function(actual_index)
	local t = DEFAULT_AG_ORDNANCE(actual_index)
	ADD_LIST(t,
	{
		APU_R73,
		AKU_R77,
		APU_R27R,
		APU_R27ER,
		APU_R27T,
		APU_R27ET,
		MER_5xFAB250(actual_index),
	})
	return t
end

local STATION_4 = function(actual_index)
	local t = DEFAULT_AG_ORDNANCE(actual_index)
	ADD_LIST(t,
	{
		AKU_R77,
		APU_R27R,
		APU_R27ER,
		APU_R27T,
		APU_R27ET,
		
		BD_FAB_1500,					--	FAB-1500 M54
		MER_5xFAB250(actual_index),
	})
	ADD_LIST(t,HEAVY_GUIDED_BOMBS(actual_index))
	
	local aku58_kh59 				   = WITHOUT_BD(actual_index,"{40AB87E8-BEFB-4D85-90D9-B2753ACF9514}",CATAPULT)
	aku58_kh59.attach_point_position = {0.43,0.03,0}
	
	ADD_LIST(t,
	{
		aku58_kh59
	})
	return t
end

local STATION_5 = function(actual_index)
	local t = {}
	ADD_LIST(t,
	{
		AKU_R77,
		AKU_R27R,
		AKU_R27ER,
		APU_R27T,
		APU_R27ET,
		MER_5xFAB250(actual_index),
	})
	ADD_LIST(t,AG_MISSILES)
	ADD_LIST(t,BOMBS_UP_TO_500)
	return t
end

local UNDERBELLY = function(actual_index)
	local t = ADD_LIST(nil,BOMBS_UP_TO_500)
	ADD_LIST(t,
	{
		--R77,
		AKU_R27R,
		AKU_R27ER,
		APU_R27T,
		APU_R27ET,
	})
	if actual_index == 7 then 
		ADD_LIST(t,HEAVY_GUIDED_BOMBS(actual_index))
		ADD_LIST(t,{MER_6xFAB250(actual_index)})
		ADD_LIST(t, {BD_FAB_1500})
	end
	return t
end

declare_loadout({
	category 		= CAT_PODS,
	CLSID	 		= "{ECM_POD_L_175V}",
	attribute		=	{4,	15,	45,	WSTYPE_PLACEHOLDER},
	displayName		=	_("L175V Khibiny ECM pod"),
	Cx_pil			=	0.000244140625,
	Picture			= 	"L005.png",
	Weight			= 	150,
	Elements		= 	{}
})

add_aircraft({
	Name 				=   'Su-34',
	DisplayName			= _('Su-34'),
	Picture 			=  'Su-34.png',
	Rate 				=  70, -- RewardPoint in Multiplayer
	Shape 				=  'Su-34',
	shape_table_data 	= 
	{
		{
			file  	 	= "Su-34";
			life  	 	= 24;
			vis  	 	= 3;
			desrt 	 	= "Fighter-1-crush";
			fire  	 	= { 300, 2};
			username 	= "Su-34";
			index 	 	= Su_34;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		}
	},
	
	country_of_origin	= "RUS",

	mapclasskey			=  "P0091000024",
	WorldID 			=  Su_34,
	Countries 			= {"Russia"},

	EmptyWeight 		= 22300,
	M_empty				= 22300,
	M_nominal			= 33325,
	M_fuel_max			= 9800,
	MaxFuelWeight 		= 9800,

	M_max				= 45000,
	MaxTakeOffWeight 	= 45000,
	WingSpan 			= 14.7,
	wing_area			= 62,
	wing_span			= 14.7,
	length				= 23.3,
	height				= 6,

	MaxHeight 			= 17000,
	H_max				= 15000,

	MaxSpeed 			= 1900,
	CAS_min				= 58,
	V_opt				= 170,
	V_take_off			= 75,
	V_land				= 65,
	AOA_take_off		= 0.14,
	V_max_sea_level		= 403,
	V_max_h				= 527.78,
	Mach_max			= 1.8,

	bank_angle_max		= 60,
	Ny_min				= -3,
	Ny_max				= 7,
	Ny_max_e			= 7,
	Vy_max				= 300,

	range						=	4000,
	average_fuel_consumption	=	0.2606,
	has_afteburner				=	true,
	has_speedbrake				=	false,
	brakeshute_name				=	4,

	radar_can_see_ground		=	true,
	detection_range_max			=	250,
	RCS							=	6,
	IR_emission_coeff			=	1,
	IR_emission_coeff_ab		=	5,
	tanker_type					=	4,
	air_refuel_receptacle_pos 	= 	{9.709,	0.941,	-1.561},
	wing_tip_pos 				=	{-4.5,	0.4,	7.5},
	flaps_maneuver				=	1,

	main_gear_pos				= 	{-0.29,	-2.819,	2.33},
	nose_gear_pos				= 	{6.78,	-2.587,	0},
	nose_gear_wheel_diameter	=	0.628,
	main_gear_wheel_diameter	=	1.011,


	nose_gear_amortizer_direct_stroke    	 =  0,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  	 =  2.25 - 2.587,  -- up
	main_gear_amortizer_direct_stroke	 	 =  0, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  	 = 	2.417 - 2.819, --  up
	nose_gear_amortizer_normal_weight_stroke = -0.1,-- down from nose_gear_pos
	main_gear_amortizer_normal_weight_stroke = -0.1,-- down from main_gear_pos


	tand_gear_max	=	0.577,

	thrust_sum_max	=	18000,
	thrust_sum_ab	=	25600,
	engines_count	=	2,

	engines_nozzles =
	{
		[1] =
		{
			pos = 	{-6.889,	-0.257,	-1.193},
			elevation	=	1.5,
			diameter	=	1.137,
			exhaust_length_ab	=	7,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.1,
		}, -- end of [1]
		[2] =
		{
			pos = 	{-6.889,	-0.257,	1.193},
			elevation	=	1.5,
			diameter	=	1.137,
			exhaust_length_ab	=	7,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.1,
		}, -- end of [2]
	}, -- end of engines_nozzles

	crew_members =
	{
		[1] =
		{
			ejection_seat_name	=	9,
			drop_canopy_name	=	"su-34-fonar-l",
            canopy_pos = {0, 0, 0},
            canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {7.99, 0.7, -0.367},
		}, -- end of [1]
		[2] =
		{
			ejection_seat_name	=	9,
			drop_canopy_name	=	"su-34-fonar-r",
            canopy_pos = {0, 0, 0},
            canopy_ejection_dir = {0.0, 0.5, 0.5},
			pos = {7.99, 0.7, 0.392},
            canopy_arg = 421,
		}, -- end of [2]
	}, -- end of crew_members

    mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "set", 0.9}}}}, Flags = {"Reversible"}},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "set", 0.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"PosType", 8}, {"Sleep", "for", 2.0}}}, {C = {{"JettisonCanopy", 0}}}}},
        },
        Door1 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 421, "set", 0.9}}}}, Flags = {"Reversible"}},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 421, "set", 0.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 1}}}}},
        },
    }, -- end of mechanimations

	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	chaff_flare_dispenser =
	{
		[1] =
		{
			dir = 	{0,	1,	0},
			pos = 	{-5.776,	1.4,	-0.422},
		}, -- end of [1]
		[2] =
		{
			dir = 	{0,	1,	0},
			pos = 	{-5.776,	1.4,	0.422},
		}, -- end of [2]
	}, -- end of chaff_flare_dispenser


	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 256,
		-- PPR-26
		chaff = {default = 128, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 128, increment = 3, chargeSz = 1}
	},

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},

	--pylons_enumeration = {12, 1, 11, 2, 3, 10, 4, 9, 5, 8, 7, 6},

    Guns = {gun_mount("GSh_30_1", { count = 150 },{muzzle_pos = {5.9, 0.48,  1.1},elevation_initial = 2.0}),
    },

	Pylons = {
	pylon(1,  RAIL, 	-1.835346, 0.097043,  -7.412458,{use_full_connector_position=true,connector = "Point1_APU73"	,arg = 308,arg_value = 0},
	{
		SIDE_R73,
		{ CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",	arg_value = 1,   required = {{station = 12,loadout = {"{44EE8698-89F9-48EE-AF36-5FD31896A82A}"}}}},--Sorbciya
		{ CLSID = "{ECM_POD_L_175V}",						arg_value = 0.1, required = {{station = 12,loadout = {"{ECM_POD_L_175V}"}}}},--Khibiny
	}),
	pylon(2,  RAIL, 	-2.276925, -0.134286, -6.328241,{use_full_connector_position=true,connector = "Point2_APU73"	,arg = 309,arg_value = 0},	STATION_2),
	pylon(3,  CATAPULT, -1.015399, -0.182422, -4.753561,{use_full_connector_position=true,connector = "Point3_BD3"		,arg = 310,arg_value = 0},	STATION_3(3)),
	pylon(4,  CATAPULT, -0.325835, -0.203349, -3.490985,{use_full_connector_position=true,connector = "Point_4_BD3"		,arg = 311,arg_value = 0},	STATION_4(4)),
	pylon(5,  CATAPULT,  0.154832, -1.263379, -1.195078,{use_full_connector_position=true,connector = "Point5_BD3"		,arg = 312,arg_value = 0},	STATION_5(5)),
	pylon(6,  CATAPULT, -4.626298, -0.280635, -0.000286,{use_full_connector_position=true,connector = "Point6_BD3"		,arg = 313,arg_value = 0},  
	{
	{ CLSID = "{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}", arg_value = 0.5, required = {{station = 6,loadout = {"{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}"}}}},--Mercury
	{ CLSID = "{0519A264-0AB6-11d6-9193-00A0249B6F00}", arg_value = 0.5, required = {{station = 6,loadout = {"{0519A264-0AB6-11d6-9193-00A0249B6F00}"}}}},--L081
	{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", arg_value = 0.35, required = {{station = 6,loadout = {"{9B25D316-0434-4954-868F-D51DB1A38DF0}"}}}},--R-27R APU-470
	{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.35, required = {{station = 6,loadout = {"{E8069896-8435-4B90-95C0-01A03AE6E400}"}}}},--R-27ER APU-470
	{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", arg_value = 0.35, required = {{station = 6,loadout = {"{88DAC840-9F75-4531-8689-B46E64E42E53}"}}}},--R-27T APU-470
	{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.35, required = {{station = 6,loadout = {"{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}}}},--R-27ET APU-470
	{ CLSID = "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15, required = {{station = 6,loadout = {"{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}"}}}},--FAB-1500 M54
	{ CLSID = "{39821727-F6E2-45B3-B1F0-490CC8921D1E}", required = {{station = 6,loadout = {"{39821727-F6E2-45B3-B1F0-490CC8921D1E}"}}}},--KAB-1500L
	{ CLSID = "{KAB_1500LG_LOADOUT}", required = {{station = 6,loadout = {"{KAB_1500LG_LOADOUT}"}}}},--KAB-1500LG-Pr
	{ CLSID = "{KAB_1500Kr_LOADOUT}", required = {{station = 6,loadout = {"{KAB_1500Kr_LOADOUT}"}}}},--KAB-1500Kr
	{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", required = {{station = 6,loadout = {"{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"}}}},--BOMBS-UP-TO-500
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", required = {{station = 6,loadout = {"{4203753F-8198-4E85-9924-6F8FF679F9FF}"}}}},
	{ CLSID = "{RBK_250_275_AO_1SCH}", required = {{station = 6,loadout = {"{RBK_250_275_AO_1SCH}"}}}},
	{ CLSID = "{RBK_500U_OAB_2_5RT}", required = {{station = 6,loadout = {"{RBK_500U_OAB_2_5RT}"}}}},
	{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", required = {{station = 6,loadout = {"{D5435F26-F120-4FA3-9867-34ACE562EF1B}"}}}},
	{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", required = {{station = 6,loadout = {"{7AEC222D-C523-425e-B714-719C0D1EB14D}"}}}},
	{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", required = {{station = 6,loadout = {"{3C612111-C7AD-476E-8A8E-2485812F4E5C}"}}}},
	{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", required = {{station = 6,loadout = {"{37DCC01E-9E02-432F-B61D-10C166CA2798}"}}}},
	{ CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", required = {{station = 6,loadout = {"{BA565F89-2373-4A84-9502-A0E017D3A44A}"}}}},
	{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", required = {{station = 6,loadout = {"{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}}}},
	{ CLSID = "{KAB_500S_LOADOUT}", required = {{station = 6,loadout = {"{KAB_500S_LOADOUT}"}}}},
	{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}", required = {{station = 6,loadout = {"{0511E528-EA28-4caf-A212-00D1408DF10A}"}}}},
	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", required = {{station = 6,loadout = {"{FB3CE165-BF07-4979-887C-92B87F13276B}"}}}},
	{ CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}", required = {{station = 6,loadout = {"{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"}}}},
	}),
	pylon(7,  CATAPULT,  0.297626, -0.268015, -0.000161,{use_full_connector_position=true,connector = "Point7_BD3"		,arg = 314,arg_value = 0}, 
	{
	{ CLSID = "{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}", arg_value = 0.5, required = {{station = 7,loadout = {"{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}"}}}},--Mercury
	{ CLSID = "{7D7EC917-05F6-49D4-8045-61FC587DD019}", arg_value = 0.15, required = {{station = 7,loadout = {"{7D7EC917-05F6-49D4-8045-61FC587DD019}"}}}},--PTB
	{ CLSID = "{0519A264-0AB6-11d6-9193-00A0249B6F00}", arg_value = 0.5, required = {{station = 7,loadout = {"{0519A264-0AB6-11d6-9193-00A0249B6F00}"}}}},--L081
	{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", arg_value = 0.35, required = {{station = 7,loadout = {"{9B25D316-0434-4954-868F-D51DB1A38DF0}"}}}},--R-27R APU-470
	{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.35, required = {{station = 7,loadout = {"{E8069896-8435-4B90-95C0-01A03AE6E400}"}}}},--R-27ER APU-470
	{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", arg_value = 0.35, required = {{station = 7,loadout = {"{88DAC840-9F75-4531-8689-B46E64E42E53}"}}}},--R-27T APU-470
	{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.35, required = {{station = 7,loadout = {"{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}}}},--R-27ET APU-470
	{ CLSID = "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15, required = {{station = 7,loadout = {"{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}"}}}},--FAB-1500 M54
	{ CLSID = "{39821727-F6E2-45B3-B1F0-490CC8921D1E}", required = {{station = 7,loadout = {"{39821727-F6E2-45B3-B1F0-490CC8921D1E}"}}}},--KAB-1500L
	{ CLSID = "{KAB_1500LG_LOADOUT}", required = {{station = 7,loadout = {"{KAB_1500LG_LOADOUT}"}}}},--KAB-1500LG-Pr
	{ CLSID = "{KAB_1500Kr_LOADOUT}", required = {{station = 7,loadout = {"{KAB_1500Kr_LOADOUT}"}}}},--KAB-1500Kr
	{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", required = {{station = 7,loadout = {"{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"}}}},--BOMBS-UP-TO-500
	{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", required = {{station = 7,loadout = {"{4203753F-8198-4E85-9924-6F8FF679F9FF}"}}}},
	{ CLSID = "{RBK_250_275_AO_1SCH}", required = {{station = 7,loadout = {"{RBK_250_275_AO_1SCH}"}}}},
	{ CLSID = "{RBK_500U_OAB_2_5RT}", required = {{station = 7,loadout = {"{RBK_500U_OAB_2_5RT}"}}}},
	{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", required = {{station = 7,loadout = {"{D5435F26-F120-4FA3-9867-34ACE562EF1B}"}}}},
	{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", required = {{station = 7,loadout = {"{7AEC222D-C523-425e-B714-719C0D1EB14D}"}}}},
	{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", required = {{station = 7,loadout = {"{3C612111-C7AD-476E-8A8E-2485812F4E5C}"}}}},
	{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", required = {{station = 7,loadout = {"{37DCC01E-9E02-432F-B61D-10C166CA2798}"}}}},
	{ CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", required = {{station = 7,loadout = {"{BA565F89-2373-4A84-9502-A0E017D3A44A}"}}}},
	{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", required = {{station = 7,loadout = {"{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}}}},
	{ CLSID = "{KAB_500S_LOADOUT}", required = {{station = 7,loadout = {"{KAB_500S_LOADOUT}"}}}},
	{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}", required = {{station = 7,loadout = {"{0511E528-EA28-4caf-A212-00D1408DF10A}"}}}},
	{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}", required = {{station = 7,loadout = {"{FB3CE165-BF07-4979-887C-92B87F13276B}"}}}},
	{ CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}", required = {{station = 7,loadout = {"{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"}}}},
	}),
	pylon(8,  CATAPULT,  0.154833, -1.263415,  1.195329,{use_full_connector_position=true,connector = "Point8_BD3"		,arg = 315,arg_value = 0},	STATION_5(8)),
	pylon(9,  CATAPULT, -0.337402, -0.201416,  3.490494,{use_full_connector_position=true,connector = "Point9_BD3"		,arg = 316,arg_value = 0},	STATION_4(9)),
	pylon(10, CATAPULT, -1.018391, -0.183166,  4.753661,{use_full_connector_position=true,connector = "Point10_BD3"		,arg = 317,arg_value = 0},	STATION_3(10)),
	pylon(11, RAIL, 	-2.276925, -0.134286,  6.329078,{use_full_connector_position=true,connector = "Point11_APU73"	,arg = 318,arg_value = 0},	STATION_2),
	pylon(12, RAIL, 	-1.835346,  0.097043,  7.411980,{use_full_connector_position=true,connector = "Point12_APU73"	,arg = 319,arg_value = 0},
	{
		SIDE_R73,
		{ CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",	arg_value = 1,   required = {{station = 1,loadout = {"{44EE8698-89F9-48EE-AF36-5FD31896A82F}"}}}},--Sorbciya
		{ CLSID = "{ECM_POD_L_175V}",						arg_value = 0.1, required = {{station = 1,loadout = {"{ECM_POD_L_175V}"}}}},--Khibiny
	})
	},
	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(GroundAttack),

	SFM_Data =
	{
		aerodynamics =
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.4,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.0268,
			cx_flap	=	0.05,
			cy_flap	=	0.5,
			cx_brk	=	0.06,
			table_data =
			{
				{0,		0.0165,		0.07,	0.1,	0.032,	0.5,	30,			1.6},
				{0.2,	0.0165,		0.07,	0.1,	0.032,	1.5,	30,			1.56667},
				{0.4,	0.0165,		0.07,	0.1,	0.032,	2.5,	30,			1.5333},
				{0.6,	0.0165,		0.073,	0.094,	0.043,	3.5,	30,			1.5},
				{0.7,	0.017,		0.076,	0.094,	0.045,	3.5,	28.6667,	1.43333},
				{0.8,	0.0178,		0.079,	0.094,	0.048,	3.5,	27.3333,	1.36667},
				{0.9,	0.0215,		0.083,	0.11,	0.05,	3.5,	26,			1.3},
				{1,		0.031,		0.085,	0.15,	0.1,	3.5,	24.6667,	1.2333},
				{1.05,	0.0366,		0.0855,	0.15,	0.1,	3.5,	24,			1.2},
				{1.1,	0.0422,		0.086,	0.15,	0.1,	3.15,	18,			1.1},
				{1.2,	0.044,		0.083,	0.14,	0.1,	2.45,	17,			1.05},
				{1.3,	0.0432,		0.077,	0.17,	0.096,	1.75,	16,			1},
				{1.5,	0.0423,		0.062,	0.23,	0.09,	1.5,	13,			0.9},
				{1.7,	0.04183,	0.0513,	0.23,	0.2833,	0.9,	12,		0.7},
				{1.8,	0.0416,		0.046,	0.23,	0.38,	0.86,	11.4,		0.64},
				{2,		0.0416,		0.039,	0.08,	2.5,	0.78,	10.2,		0.52},
				{2.2,	0.0416,		0.034,	0.16,	3.2,	0.7,	9,			0.4},
				{2.5,	0.041,		0.033,	0.25,	4.5,	0.7,	9,			0.4},
				{3.9,	0.0395,		0.033,	0.35,	6,		0.7,	9,			0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine =
		{
			Nmg		=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0124,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	8000,
			dpdh_f	=	17000,
			table_data =
			{
				{0.0,	126000,	185024},
				{0.2,	126000,	198744},
				{0.4,	126000,	208250},
				{0.6,	126000,	220892},
				{0.7,	124000,	226870},
				{0.8,	124000,	232887},
				{0.9,	122000,	250210},
				{1.0,	117000,	256102},
				{1.1,	113000,	265430},
				{1.2,	110000,	280300},
				{1.3,	102000,	298900},
				{1.5,	85000,	326000},
				{1.8,	30000,	350000},
				{2.0,	19000,	363000},
				{2.2,	17000,	384000},
				{2.5,	12000,	415000},
				{3.9,	10000,	260476},
			}, -- end of table_data
		}, -- end of engine
	},

    lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "collection",
                        lights = {
                            {
                                typename = "argumentlight", argument = 192,
                            },
                            {
                                typename = "argumentlight", argument = 190,
                            },
                            {
                                typename = "argumentlight", argument = 191,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_SPOTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "argumentlight", argument = 210,
                        exposure = {{0, 0.9, 1.0}}, movable = true,
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    {
                        typename = "argumentlight", argument = 210,
                        exposure = {{0, 0.9, 1.0}},
                    },
                },
            },
        },
    },

	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},
})
