local function joinTbl(orig, to, from)
	for i, value in ipairs(orig) do									
		to[i] = value
	end
	for i, value in ipairs(from) do									
		table.insert(to, value)
	end
	return to
end

local tips		= {		-- 1,9
	{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",	Cx_gain = 0.32},					-- AIM-9M
	{ CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",	Cx_gain = 0.32},					-- AIM-9X
	{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",	Cx_gain = 0.33},					-- AIM-120C
	{ CLSID = "{F16V_AIM120D}",	Cx_gain = 0.33},					-- AIM-120D
}

local outer 	= {		-- 2,8
	{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",	Cx_gain = 0.4},						-- AIM-9M
	{ CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",	Cx_gain = 0.4},						-- AIM-9X
	{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",	Cx_gain = 0.41},					-- AIM-120C
	{ CLSID = "{F16V_AIM120D}",	Cx_gain = 0.41},					-- AIM-120D
	{ CLSID = "<CLEAN>",								arg_value = 1, add_mass = -51.3},						-- Clean
}

local middle	= {		-- 3,7
	-- Adapter similar to 2,8 is needed
	{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",						Cx_gain = 0.4,	arg_value = 0.5, add_mass = -79.8},	-- AIM-9M
	{ CLSID = "{AIM-9L}",													Cx_gain = 0.4,	arg_value = 0.5, add_mass = -79.8},	-- AIM-9L
	{ CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",						Cx_gain = 0.4,	arg_value = 0.5, add_mass = -79.8},	-- AIM-9X
	{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}",						Cx_gain = 0.41,	arg_value = 0.5, add_mass = -79.8},	-- AIM-120B
	{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",						Cx_gain = 0.41,	arg_value = 0.5, add_mass = -79.8},	-- AIM-120C
	{ CLSID = "{F16V_AIM120D}",						Cx_gain = 0.41,	arg_value = 0.5, add_mass = -79.8},	-- AIM-120D
	{ CLSID = "CATM-9M",													Cx_gain = 0.4,	arg_value = 0.5, add_mass = -79.8},	-- CATM-9M
	{ CLSID = "{AIS_ASQ_T50}", attach_point_position = {0.25,  0.0,  0.0},	Cx_gain = 0.4,	arg_value = 0.5, add_mass = -79.8},	-- ACMI pod
	-- Normal wing pylon
	{ CLSID = "LAU3_WP156"},										-- 
	{ CLSID = "LAU3_WP1B"},											-- 
	{ CLSID = "LAU3_WP61"},											-- 
	{ CLSID = "LAU3_HE5"},											-- 
	{ CLSID = "LAU3_HE151"},										-- 

	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", Cx_gain = 1.0		},			-- Mk-82
	{ CLSID	= "{Mk82SNAKEYE}",							Cx_gain = 1.4		},			-- Mk-82 SNAKEYE
	{ CLSID	= "{Mk82AIR}",								Cx_gain = 1.4		},			-- Mk-82 AIR
	{ CLSID = "{TER_9A_3*MK-82}",						Cx_gain_item = 1.8	},		-- TER-9A + 3*MK-82
	{ CLSID = "{TER_9A_3*MK-82_Snakeye}",				Cx_gain_item = 1.57	},		-- TER-9A + 3*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_3*MK-82AIR}",					Cx_gain_item = 1.57	},		-- TER-9A + 3*MK-82 AIR
	{ CLSID	= "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", Cx_gain = 0.8		},			-- Mk-84

	{ CLSID	= "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}", Cx_gain = 1.0		},			-- GBU-10
	{ CLSID	= "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", Cx_gain = 0.62		},			-- GBU-12
	--{ CLSID	= "{AGM-154A}", Cx_gain = 1.0		},			-- AGM-154A
	{ CLSID	= "{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}", Cx_gain = 1.0		},			-- GBU-24
	{ CLSID	= "{GBU-31}", Cx_gain = 1.0		},			-- GBU-31
	--{ CLSID	= "{BRU57_2*AGM-154A}", Cx_gain = 1.8		},			-- 2*AGM-154A
	{ CLSID	= "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", Cx_gain = 0.6		},			-- AGM-88
	{ CLSID	= "LAU_88_AGM_65H", Cx_gain = 1.2		},			-- AGM-65H
	{ CLSID	= "LAU_88_AGM_65H_3", Cx_gain = 1.2		},			-- 3*AGM-65H

	{ CLSID = "{CBU-87}",								Cx_gain = 2.18		},			-- CBU-87
	{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}",	Cx_gain = 2.18		},			-- CBU-97

	{ CLSID = "{TER_9A_3*BDU-33}"										},			-- TER-9A + 3*BDU-33
	
	{ CLSID = "<CLEAN>",								arg_value = 1, add_mass = -131.1 },		-- Clean
}
local middleLeft = {}	-- 3 left
joinTbl(middle, middleLeft,{
	{ CLSID = "{TER_9A_2L*MK-82}",						Cx_gain_item = 1.8	},			-- TER-9A + 2*MK-82
	{ CLSID = "{TER_9A_2L*MK-82_Snakeye}", 				Cx_gain_item = 1.57	},			-- TER-9A + 2*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_2L*MK-82AIR}",					Cx_gain_item = 1.57	},			-- TER-9A + 2*MK-82 AIR
	{ CLSID = "{TER_9A_2L*GBU-12}",						Cx_gain_item = 1.2	},			-- TER-9A + 2*GBU-12
	
	{ CLSID = "{TER_9A_2L*CBU-87}",						Cx_gain_item = 2.66	},			-- TER-9A + 2*CBU-87
	{ CLSID = "{TER_9A_2L*CBU-97}",						Cx_gain_item = 2.66	},			-- TER-9A + 2*CBU-97
	})
local middleRight = {}	-- 7 right
joinTbl(middle, middleRight,{
	{ CLSID = "{TER_9A_2R*MK-82}",						Cx_gain_item = 1.8	},			-- TER-9A + 2*MK-82
	{ CLSID = "{TER_9A_2R*MK-82_Snakeye}", 				Cx_gain_item = 1.57	},			-- TER-9A + 2*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_2R*MK-82AIR}",					Cx_gain_item = 1.57	},			-- TER-9A + 2*MK-82 AIR
	{ CLSID = "{TER_9A_2R*GBU-12}",						Cx_gain_item = 1.2	},			-- TER-9A + 2*GBU-12
	
	{ CLSID = "{TER_9A_2R*CBU-87}",						Cx_gain_item = 2.66	},			-- TER-9A + 2*CBU-87
	{ CLSID = "{TER_9A_2R*CBU-97}",						Cx_gain_item = 2.66	},			-- TER-9A + 2*CBU-97
})

local inner		= {		-- 4,6
	{ CLSID = "LAU3_WP156",														arg_value = 0.5, add_mass = -82.5},					-- 
	{ CLSID = "LAU3_WP1B",														arg_value = 0.5, add_mass = -82.5},					-- 
	{ CLSID = "LAU3_WP61",														arg_value = 0.5, add_mass = -82.5},					-- 
	{ CLSID = "LAU3_HE5",														arg_value = 0.5, add_mass = -82.5},					-- 
	{ CLSID = "LAU3_HE151",														arg_value = 0.5, add_mass = -82.5},					-- 

	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", Cx_gain = 1.0,			arg_value = 0.5, add_mass = -82.5},		-- Mk-82
	{ CLSID	= "{Mk82SNAKEYE}",							Cx_gain = 1.4,			arg_value = 0.5, add_mass = -82.5},		-- Mk-82 SNAKEYE
	{ CLSID	= "{Mk82AIR}",								Cx_gain = 1.4, 			arg_value = 0.5, add_mass = -82.5},		-- Mk-82 AIR
	{ CLSID = "{TER_9A_3*MK-82}",						Cx_gain_item = 1.8,		arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 3*MK-82
	{ CLSID = "{TER_9A_3*MK-82_Snakeye}", 				Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 3*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_3*MK-82AIR}",					Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 3*MK-82 AIR
	{ CLSID	= "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",	Cx_gain = 0.8,			arg_value = 0.5, add_mass = -82.5},		-- Mk-84
	{ CLSID	= "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}", Cx_gain = 1.0,			arg_value = 0.5, add_mass = -82.5},		-- GBU-10
	{ CLSID	= "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", Cx_gain = 0.62,			arg_value = 0.5, add_mass = -82.5},		-- GBU-12
	{ CLSID	= "{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}", Cx_gain = 1.0,			arg_value = 0.5, add_mass = -82.5},		-- GBU-24
	{ CLSID	= "{GBU-31}", Cx_gain = 1.0		},			-- GBU-31
	{ CLSID	= "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", Cx_gain = 0.62,			arg_value = 0.5, add_mass = -82.5},		-- AGM-88

	{ CLSID = "{CBU-87}",								Cx_gain = 2.18,			arg_value = 0.5, add_mass = -82.5},			-- CBU-87
	{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}",	Cx_gain = 2.18,			arg_value = 0.5, add_mass = -82.5},			-- CBU-97
	{ CLSID = "{TER_9A_3*CBU-87}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 3*CBU-87
	{ CLSID = "{TER_9A_3*CBU-97}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 3*CBU-97

	{ CLSID = "{TER_9A_3*BDU-33}",												arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 3*BDU-33

	{ CLSID = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}" },			-- 370 gallon Fuel tank
	{ CLSID = "<CLEAN>",														arg_value = 1,	 add_mass = -133.8},						-- Clean
}
local innerLeft = {}	-- 4 left
joinTbl(inner, innerLeft,{
	{ CLSID = "{TER_9A_2L*MK-82}",						Cx_gain_item = 1.8,		arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82
	{ CLSID = "{TER_9A_2L*MK-82_Snakeye}",				Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_2L*MK-82AIR}",					Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82 AIR

	{ CLSID = "{TER_9A_2L*CBU-87}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 2*CBU-87
	{ CLSID = "{TER_9A_2L*CBU-97}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 2*CBU-97
	})
local innerRight = {}	-- 6 right
joinTbl(inner, innerRight,{
	{ CLSID = "{TER_9A_2R*MK-82}",						Cx_gain_item = 1.8,		arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82
	{ CLSID = "{TER_9A_2R*MK-82_Snakeye}",				Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82 SNAKEYE
	{ CLSID = "{TER_9A_2R*MK-82AIR}",					Cx_gain_item = 1.57,	arg_value = 0.5, add_mass = -82.5},		-- TER-9A + 2*MK-82 AIR

	{ CLSID = "{TER_9A_2R*CBU-87}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 2*CBU-87
	{ CLSID = "{TER_9A_2R*CBU-97}",						Cx_gain_item = 2.66,	arg_value = 0.5, add_mass = -82.5},			-- TER-9A + 2*CBU-97
})

local fuselageLeft	= {		-- 5L
}

local fuselageRight	= {		-- 5R
	{ CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",		arg_value = 0.0},			--Litening
}

local centerline	= {		-- 5
	{ CLSID = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}" },			-- 300 gallon Fuel tank

	{ CLSID = "<CLEAN>",								arg_value = 1, 				add_mass = -78.9},			-- Clean
}

F16CVBL70 =  {
      
		Name 			= 'F16CVBL70',--AG
		DisplayName		= _('F-16V bl.70 AI'),--AG
        Picture 		= "F-16C.png",
        Rate 			= "50",
        Shape			= "F16CVBL70",--AG		
        WorldID			=  WSTYPE_PLACEHOLDER,
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'F16CVBL70';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'F16CVBL70-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'F16CVBL70';--AG
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "F16CVBL70-oblomok";
			file  		= "F16CVBL70-oblomok";
			fire  		= { 0, 1};
		},

	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	8600,	-- kg  with pilot and nose load, F16
		M_nominal					=	11800,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	19190,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	3200,	-- kg (Internal Fuel Only)
		H_max						=	15100,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.224,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	61,		-- Take off speed in m/s (for AI)
		V_land						=	71,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,

		nose_gear_pos								=	{2.268, -2.021, 0},
		nose_gear_amortizer_direct_stroke				=	0.0,
		nose_gear_amortizer_reversal_stroke				=	-0.244,
		nose_gear_amortizer_normal_weight_stroke		=	-0.0,
		nose_gear_wheel_diameter						=	0.4572,
		nose_gear_door_close_after_retract			=	false,
	
	    main_gear_pos								=	{-1.803, -1.990, 1.094},	
		main_gear_amortizer_direct_stroke			=	0.0,
		main_gear_amortizer_reversal_stroke			=	-0.240,
		main_gear_amortizer_normal_weight_stroke	=	-0.0,
		main_gear_wheel_diameter					=	0.70485,
		main_gear_door_close_after_retract			=	false,
		
		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	28.2,	-- wing area in m2
		thrust_sum_max				=	13347,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	21952,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	1.8,	-- Max speed in Mach (for AI)
		range						=	2240,	-- Max range in km (for AI)
		RCS							=	1.3,		-- Radar Cross Section m2
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	210,
		IR_emission_coeff			=	0.6,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	2.2,		-- With afterburner
		tand_gear_max				=	0.62487,--XX  1.732 FA18 3.73, 
		tanker_type					=	1,-- F14=2/S33=4/M29=0/S27=0/F15=1/F16=1/To=0/F18=2/A10A=1/M29K=4/M2000=2/F4=0/F5=0/
		wing_span					=	9.95,
		wing_type 					= 	2,-- FIXED_WING = 0/VARIABLE_GEOMETRY = 1/FOLDED_WING = 2/ARIABLE_GEOMETRY_FOLDED = 3
		length						=	15.06,
		height						=	4.88,
		crew_size					=	1,
		engines_count				=	1,
		wing_tip_pos 				= 	{-2.704, 0.307, 4.649},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		
		mechanimations = "Default",
		
		engines_nozzles = 
		{
		[1] = 
		{
			pos					=	{-6.003,	0.261,	0},
				elevation			=	0,
				diameter			=	1.02,
				exhaust_length_ab	=	9,
				exhaust_length_ab_K	=	0.76,
				smokiness_level		=	0.05,
				afterburner_effect_texture = "afterburner_f-16c",
		}, -- end of [1]
	}, -- end of engines_nozzles
	
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	17,
				drop_canopy_name	=	23,
				canopy_pos			= 	{0,0,0},
				pos					=	{3.9,	1.4,	0},
				pilot_body_arg		=	-1,
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	0,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{-0.051, 0.911, 0.0},
		fires_pos = 
		{
		[1] =	{-0.707,	0.553,	-0.213},
		[2] =	{-0.037,	0.285,	1.391},
		[3] =	{-0.037,	0.285,	-1.391},
		[4] =	{-0.82,		0.265,	2.774},
		[5] =	{-0.82,		0.265,	-2.774},
		[6] =	{-0.82,		0.255,	4.274},
		[7] =	{-0.82,		0.255,	-4.274},
		[8] =	{-5.003,	0.261,	0},
		[9] =	{-5.003,	0.261,	0},
		[10] =	{-0.707,	0.453,	1.036},
		[11] =	{-0.707,	0.453,	-1.036},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/F16CVBL70_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	-1,	0},
				pos = 	{-1.185,	-1.728,	-0.878},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	-1,	0},
				pos = 	{-1.185,	-1.728,	0.878},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 120,
chaff 				= {default = 60, increment = 15, chargeSz = 1},
flare 				= {default = 60, increment = 15, chargeSz = 1}
 },
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 			= "F16V-AN/APG-83",--F16V
RWR 			= "Abstract RWR"--F15
},
Countermeasures = {
ECM 			= "AN/ALQ-135"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--			{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},


	Guns = {gun_mount("M_61", {count = 510}, {muzzle_pos_connector = "Gun_point_00"})},

--pylons_enumeration = {11, 9, 8, 2, 3, 7, 4, 6, 5},

	Pylons = {
		pylon(1, 0, -2.2, 0.002, -4.739,
			{
				arg = 308,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon1",
			},
			tips, 1
		),
		pylon(2, 0, -1.918, -0.454, -3.948000,
			{
				arg = 309,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon2",
				mass = 51.3,
			},
			outer, 2
		),
		pylon(3, 0, -2.05, -0.505, -3.050000,
			{
				arg = 310,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon3",
				mass = 131.1,
			},
			middleLeft, 3
		),
		pylon(4, 0, -1.053, -0.519, -1.813000,
			{
				arg = 311,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon4",
				mass = 133.8,
			},
			innerLeft, 4
		),
		pylon(5, 0, -0.704, -1.173, 0.000000,
			{
				arg = 312,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon5",
				DisplayName = _("5"),
				mass = 78.9,
			},
			centerline, 6
		),
		pylon(6, 0, -1.053, -0.519, 1.813000,
			{
				arg = 313,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon6",
 				DisplayName = _("6"),
				mass = 133.8,
			},
			innerRight, 8
		),
		pylon(7, 0, -2.05, -0.505, 3.050000,
			{
				arg = 314,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon7",
 				DisplayName = _("7"),
				mass = 131.1,
			},
			middleRight, 9
		),
		pylon(8, 0, -1.918, -0.454, 3.948000,
			{
				arg = 315,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon8",
 				DisplayName = _("8"),
				mass = 51.3,
			},
			outer, 10
		),
		pylon(9, 0, -2.2, 0.002, 4.739,
			{
				arg = 316,
				arg_value = 0,
				use_full_connector_position = true,
				connector = "Pylon9",
				DisplayName = _("9"),
			},
			tips, 11
		),
		pylon(10, 0, 2.7, -0.55, -0.55,
			{
				arg = 318,
				arg_value = 1,
				use_full_connector_position = true,
				connector = "Pylon11",
				DisplayName = _("POD"),
			},
			fuselageRight, 12
		),
	},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
		aircraft_task(PinpointStrike),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(AFAC),
	    aircraft_task(RunwayAttack),
	    aircraft_task(AntishipStrike),
	    aircraft_task(SEAD),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = --F16
		{
			Cy0	=	0,
			Mzalfa	=	4.35,
			Mzalfadt	=	0.8,
			kjx = 2.75,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.05,
			cy_flap = 0.52,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.0165, 0.07, 0.132, 0.025, 0.5, 30, 1.45 }, { 0.2, 0.0165, 0.07, 0.132, 0.025, 1.5, 30, 1.45 }, { 0.4, 0.0165, 0.07, 0.133, 0.028, 2.5, 30, 1.45 }, { 0.6, 0.0196, 0.073, 0.133, 0.032, 3.5, 30, 1.45 }, { 0.7, 0.0228, 0.076, 0.134, 0.034, 3.5, 28.666666666667, 1.45 }, { 0.8, 0.0314, 0.079, 0.137, 0.036, 3.5, 27.333333333333, 1.35 }, { 0.9, 0.0542, 0.083, 0.1327, 0.042, 3.5, 26, 1.3 }, { 1, 0.0707, 0.085, 0.1634, 0.1, 3.5, 24.666666666667, 1.12 },
				{ 1.05, 0.07, 0.0855, 0.1975, 0.095, 3.5, 24, 1.11 }, { 1.1, 0.0699, 0.086, 0.215, 0.09, 3.15, 18, 1.1 }, { 1.2, 0.0652, 0.083, 0.228, 0.12, 2.45, 17, 1.05 }, { 1.3, 0.0605, 0.077, 0.237, 0.17, 1.75, 16, 1 }, { 1.49, 0.05, 0.062, 0.241, 0.2, 1.5125, 13.15, 0.905 }, { 1.5, 0.0542, 0.061483870967742, 0.241, 0.2058064516129, 1.5, 13, 0.9 }, { 1.7, 0.05, 0.051161290322581, 0.24354838709677, 0.32193548387097, 0.9, 12, 0.7 }, { 1.8, 0.05, 0.046, 0.24, 0.38, 0.86, 11.4, 0.64 }, { 2, 0.0471, 0.039, 0.222, 2.5, 0.78, 10.2, 0.52 }, { 2.2, 0.0455, 0.034, 0.227, 3.2, 0.7, 9, 0.4 }, { 2.5, 0.039, 0.033, 0.25, 4.5, 0.7, 9, 0.4 }, { 3.9, 0.035, 0.033, 0.35, 6, 0.7, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.2,
			dcx_eng	=	0.0114,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6000,
			dpdh_f	=	13000.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 77000, 108313.6 }, { 0.2, 74000, 109850 }, { 0.4, 74000, 122000 }, { 0.6, 82000, 142000 }, { 0.7, 85000, 156000 }, { 0.8, 92000, 177000 }, { 0.9, 100000, 202000 }, { 1, 109000, 218000 }, { 1.096, 99000, 222000 }, { 1.2, 86000, 228000 }, { 1.3, 68000, 231000 }, { 1.4, 55000, 230000 }, { 1.6, 56000, 229000 }, { 1.8, 56000, 227000 }, { 2.2, 52000, 234000 }, { 2.35, 43000, 224000 }, { 3.9, 25000, 120636.4},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	
	[47] = {critical_damage = 2,  args = {235}},--240 STABILIZATOR_L
	[48] = {critical_damage = 2,  args = {233}},--238 STABILIZATOR_R
	
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "F-16C_oblomok_wing_R", -- wing R
		[2] = "F-16C_oblomok_wing_L", -- wing L
	},
	

	lights_data = {
		typename = "collection",
		lights = {
			-- STROBES
			[WOLALIGHT_STROBES] = {
				typename = "collection",
				lights = {
					{ typename = "argnatostrobelight", argument = 193,
						controller = "VariablePatternStrobe", mode = "1 Flash", period = 0.500, },
					{ typename = "Spot", position = {-6.8, 3.25, 0}, direction = {azimuth = math.rad(-90.0)}, argument = 193,
						proto = lamp_prototypes.MPS_1, range = 64, angle_max = math.rad(110.0), angle_min = math.rad(80.0),
						controller = "VariablePatternStrobe", mode = "1 Flash", period = 0.500, },
					{ typename = "Spot", position = {-6.8, 3.25, 0}, direction = {azimuth = math.rad(90.0)}, argument = 193,
						proto = lamp_prototypes.MPS_1, range = 64, angle_max = math.rad(110.0), angle_min = math.rad(80.0),
						controller = "VariablePatternStrobe", mode = "1 Flash", period = 0.500, },
				},
			},
			-- SPOTS
			[WOLALIGHT_LANDING_LIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- landing
					{ typename = "argumentlight", argument = 208, exposure = {{117, 0.9, 1.0}}, movable = true, },
					-- 1 -- taxi
					{ typename = "argumentlight", argument = 209, exposure = {{117, 0.9, 1.0}}, movable = true, },
					-- 2 -- aux light
					{ typename = "argumentlight", argument = 210, exposure = {{117, 0.9, 1.0}}, movable = true, },
				},
			},
			[WOLALIGHT_TAXI_LIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- taxi
					{ typename = "argumentlight", argument = 209, exposure = {{117, 0.9, 1.0}}, movable = true, },
					-- 1 -- aux light
					{ typename = "argumentlight", argument = 210, exposure = {{117, 0.9, 1.0}}, movable = true, },
				},
			},
			-- NAVLIGHTS
			[WOLALIGHT_NAVLIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- wing tips
					{ typename = "argumentlight", argument = 190,
						controller = "Strobe", period = 0.73, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.5, mode = 0, },
					-- 1 -- intake & tail
					{ typename = "argumentlight", argument = 191,
						controller = "Strobe", period = 0.73, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.5, mode = 0, },
				},
			},
			-- FORMATION
			[WOLALIGHT_FORMATION_LIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- fuselage upper formation
					{ typename = "argumentlight", argument = 200, },
					-- 1 -- fuselage lower formation
					{ typename = "argumentlight", argument = 201, },
					-- 2 -- fuselage formation/position
					{ typename = "argumentlight", argument = 202, },
				},
			},
			-- REFUEL
			[WOLALIGHT_REFUEL_LIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- AR light, tail-mounted flood
					{ typename = "argumentlight", argument = 207, },
				},
			},
			-- STROBE / ANTI-COLLISION
			[WOLALIGHT_BEACONS] = {
				typename = "collection",
				lights = {
					-- 0 -- Anti-collision strobe
					{ typename = "argnatostrobelight", argument = 192, period = 0.4, flash_time = 0.1, },
				},
			},
		}, -- end of lights
	},-- end of lights_data
}


add_aircraft(F16CVBL70) --AG
