local SENSOR_OPTICAL = 0
local SENSOR_RADAR = 1
local SENSOR_IRST = 2
local SENSOR_RWR = 3
local RADAR_AS = 0
local RADAR_SS = 1
local RADAR_MULTIROLE = 2
local ASPECT_HEAD_ON = 0
local ASPECT_TAIL_ON = 1
local HEMISPHERE_UPPER = 0
local HEMISPHERE_LOWER = 1
local ENGINE_MODE_FORSAGE = 0
local ENGINE_MODE_MAXIMAL = 1
local ENGINE_MODE_MINIMAL = 2
local OPTIC_SENSOR_TV = 0
local OPTIC_SENSOR_LLTV = 1
local OPTIC_SENSOR_IR = 2
J20_Sensors = {
  [SENSOR_OPTICAL] = {
    ["GD-20"] = {
      type = OPTIC_SENSOR_TV,
      scan_volume = {
        azimuth = {-90, 90},
        elevation = {-15, 60}
      },
      view_volume_max = {azimuth_sector = 4, elevation_sector = 4},
      magnifications = {10, 30},
      resolution = 0.1
    }
  },
  [SENSOR_RADAR] = {
    ['RD20'] = {
      type = RADAR_MULTIROLE,
      scan_volume = {
        azimuth = {-100, 100},
        elevation = {-60, 60}
      },
      --centered_scan_volume = {azimuth_sector = 60, elevation_sector = 60},
      max_measuring_distance = 550000,
      scan_period = 0.1,
      air_search = {
        centered_scan_volume = {azimuth_sector = 60, elevation_sector = 60},
        detection_distance = {
          [HEMISPHERE_UPPER] = {
            [ASPECT_HEAD_ON] = 500000,
            [ASPECT_TAIL_ON] = 350000
          },
          [HEMISPHERE_LOWER] = {
            [ASPECT_HEAD_ON] = 500000,
            [ASPECT_TAIL_ON] = 350000
          }
        },
        lock_on_distance_coeff = 0.85,
        multiple_targets_tracking = true,
		    TWS_max_targets = 4,
        velocity_limits = {
			radial_velocity_min = 100/3.6, --55.55555555555556, 
			relative_radial_velocity_min = 100/3.6 --41.666666666666664
		}
      },
      surface_search = {
        vehicles_detection = true,
        RCS = 100,
        RBM_detection_distance = 400000,
        GMTI_detection_distance = 500000,
        HRM_detection_distance = 100000
      }
    }
  },
  [SENSOR_IRST] = {
    ["HW-20"] = {
      scan_volume = {
        azimuth = {-90, 90},
        elevation = {-15, 60}
      },
      detection_distance_for_tail_on_Su_27 = {
        [ENGINE_MODE_FORSAGE] = 190000,
        [ENGINE_MODE_MAXIMAL] = 150000,
        [ENGINE_MODE_MINIMAL] = 130000
      },
      head_on_distance_coeff = 0.5,
      scan_period = 3,
      background_factor = 0.5,
      laserRanger = true
    }
  }
}
for category, sensors in pairs(J20_Sensors) do
  for name, sensor in pairs(sensors) do
    sensor.Name = name
    sensor.category = category
    declare_sensor(sensor)
  end
end
