--dofile(LockOn_Options.script_path.."fonts.lua")
dofile(LockOn_Options.common_script_path.."Fonts/fonts_cmn.lua")
dofile(LockOn_Options.common_script_path.."Fonts/symbols_locale.lua")

-------MATERIALS-------
materials = {}
materials.DBG_GREY    = {2, 2, 2, 255}
materials.DBG_BLACK   = {0, 0, 0, 255}
materials.DBG_YELLOW   = {255, 255, 0, 255}
materials.DBG_BLUE   = {0, 0, 100, 255}
materials.DBG_GREEN   = {0, 255, 0, 255}
materials.DBG_RED     = {255, 0, 0, 255}
materials.DBG_CLEAR   = {0, 0, 0, 0}
materials.DBG_WHITE   = {255, 255, 255, 255}
materials.LIGHT_GREY    = {128, 128, 128, 255}
materials.LIGHT_YELLOW   = {255, 255, 0, 128}
materials.LIGHT_BLUE   = {0, 128, 255, 255}
materials.LIGHT_PURPLE   = {255, 0, 255, 128}
materials.LIGHT_ORIGIN    = {255, 128, 0, 128}
materials.LIGHT_GREEN   = {0, 255, 0, 128}
materials.LIGHT_RED   = {255, 0, 0, 128}
materials.BLOB_COLOR = {0,128,0,192}
materials.TEST_MATERIAL 	= {17,80,7,20}
materials.RADAR_GRID = {0,100,0,192}
materials.RADAR_SCRIBE = {0,200,0,192}
materials.GUNSIGHT_GLASS = {0,120,0,128}
materials.TEST_COLOR = {50,250,0,255}
materials.HUD_DAY_COLOR          = {0,200,0,200}
materials.GREEN          = {0,255,0,255}
materials.UFCP_FONT					= {50, 255, 30, 255}
materials.TERRAIN_LAND   = {255, 255, 0, 32}
materials.TERRAIN_SEA   = {0, 128, 255, 32}
materials.RADAR_SCAN_MAX = {0, 64, 0, 64}
materials.RADAR_SCAN = {0, 128, 0, 64}
materials.RADAR_SCANNING = {128, 128, 0, 64}
materials.TEXTURE_COLOR = { 128,128,128,255 }

local IndicationFontPath = LockOn_Options.script_path.."../Textures/Fonts/"
-------TEXTURES-------
textures = {}

-------------------------------------------------------
-------FONTS-------
fontdescription = {}

MPCD_size_mult = 2
MPCD_xsize = 20 * MPCD_size_mult
MPCD_ysize = 40 * MPCD_size_mult

UFCP_xsize = 146
UFCP_ysize = 146

dofile(LockOn_Options.script_path.."fontUnicode.lua")
fontdescription.font_UTF = font_unicode(IndicationFontPath.."Font_UTF.dds")
fontdescription.font_UFCP = {
	texture    = IndicationFontPath.."FONT_UFCP.dds",
	size      = {7, 7},
	resolution = {1024, 1024},
	default = {146,146},
	chars	     = {
		[1]		= {symbol[' '],		UFCP_xsize, UFCP_ysize},
		[2]		= {symbol['0'],		UFCP_xsize, UFCP_ysize},
		[3]		= {symbol['1'],		UFCP_xsize, UFCP_ysize},
		[4]		= {symbol['2'],		UFCP_xsize, UFCP_ysize},
		[5]		= {symbol['3'],		UFCP_xsize, UFCP_ysize},
		[6]		= {symbol['4'],		UFCP_xsize, UFCP_ysize},
		[7]		= {symbol['5'],		UFCP_xsize, UFCP_ysize},
		[8]		= {symbol['6'],		UFCP_xsize, UFCP_ysize},
		[9]		= {symbol['7'],		UFCP_xsize, UFCP_ysize},
		[10]	= {symbol['8'],		UFCP_xsize, UFCP_ysize},
		[11]	= {symbol['9'],		UFCP_xsize, UFCP_ysize},
		[12]	= {symbol['~'],		UFCP_xsize, UFCP_ysize},	-- '2' от двадцатки
		[13]	= {latin['A'],		UFCP_xsize, UFCP_ysize},
		[14]	= {latin['B'],		UFCP_xsize, UFCP_ysize},
		[15]	= {latin['C'],		UFCP_xsize, UFCP_ysize},
		[16]	= {latin['D'],		UFCP_xsize, UFCP_ysize},
		[17]	= {latin['E'],		UFCP_xsize, UFCP_ysize},
		[18]	= {latin['F'],		UFCP_xsize, UFCP_ysize},
		[19]	= {latin['G'],		UFCP_xsize, UFCP_ysize},
		[20]	= {latin['H'],		UFCP_xsize, UFCP_ysize},
		[21]	= {latin['I'],		UFCP_xsize, UFCP_ysize},
		[22]	= {latin['J'],		UFCP_xsize, UFCP_ysize},
		[23]	= {latin['K'],		UFCP_xsize, UFCP_ysize},
		[24]	= {latin['L'],		UFCP_xsize, UFCP_ysize},
		[25]	= {latin['M'],		UFCP_xsize, UFCP_ysize},
		[26]	= {latin['N'],		UFCP_xsize, UFCP_ysize},
		[27]	= {latin['O'],		UFCP_xsize, UFCP_ysize},
		[28]	= {latin['P'],		UFCP_xsize, UFCP_ysize},
		[29]	= {latin['Q'],		UFCP_xsize, UFCP_ysize},
		[30]	= {latin['R'],		UFCP_xsize, UFCP_ysize},
		[31]	= {latin['S'],		UFCP_xsize, UFCP_ysize},
		[32]	= {latin['T'],		UFCP_xsize, UFCP_ysize},
		[33]	= {latin['U'],		UFCP_xsize, UFCP_ysize},
		[34]	= {latin['V'],		UFCP_xsize, UFCP_ysize},
		[35]	= {latin['W'],		UFCP_xsize, UFCP_ysize},
		[36]	= {latin['X'],		UFCP_xsize, UFCP_ysize},
		[37]	= {latin['Y'],		UFCP_xsize, UFCP_ysize},
		[38]	= {latin['Z'],		UFCP_xsize, UFCP_ysize},
		[39]	= {symbol['/'],		UFCP_xsize, UFCP_ysize},
		[40]	= {symbol['_'],		UFCP_xsize, UFCP_ysize},	-- тире
		[41]	= {symbol[':'],		UFCP_xsize, UFCP_ysize},
		[42]	= {symbol['*'],		UFCP_xsize, UFCP_ysize},
		[43]	= {symbol[','],		UFCP_xsize, UFCP_ysize},
		[44]	= {symbol['@'],		UFCP_xsize, UFCP_ysize},	-- градус
		[45]	= {symbol['.'],		UFCP_xsize, UFCP_ysize},
		[46]	= {symbol['\''],	UFCP_xsize, UFCP_ysize},
		[47]	= {symbol['-'],		UFCP_xsize, UFCP_ysize},
		[48]	= {symbol['`'],		UFCP_xsize, UFCP_ysize},	-- '1' от десятков
		[49]	= {symbol['|'],		UFCP_xsize, UFCP_ysize},
	}
}

    fonts = {}
    fonts.font_kneeboard		= {fontdescription_cmn.font_general_loc, 10, {0,0,0,255}}
    fonts.font_kneeboard_hint	= {fontdescription_cmn.font_general_loc, 10, {255,0,0,255}}
	fonts.radar_ui_font 		= {fontdescription_cmn.font_general_loc, 10, {0,255,0,255}}
	fonts.radar_ui_font_lgBlue  = {fontdescription_cmn.font_general_loc, 10, materials.LIGHT_BLUE}
	fonts.unicode_cn_white		= {fontdescription.font_UTF, 10, materials.DBG_WHITE }
	fonts.unicode_cn_red		= {fontdescription.font_UTF, 10, materials.DBG_RED }
	fonts.unicode_cn_green		= {fontdescription.font_UTF, 10, materials.DBG_GREEN }
	fonts.unicode_cn_yellow		= {fontdescription.font_UTF, 10, materials.DBG_YELLOW }
	fonts.unicode_cn_blue		= {fontdescription.font_UTF, 10, materials.DBG_BLUE }
	fonts.unicode_cn_lg_blue	= {fontdescription.font_UTF, 10, materials.LIGHT_BLUE }
	fonts.unicode_cn_hud		= {fontdescription.font_UTF, 10, materials.HUD_DAY_COLOR }
	fonts.hud_font_base			= {fontdescription.font_UTF, 10, materials.HUD_DAY_COLOR }
	fonts.font_UFCP				= {fontdescription.font_UFCP, 10, materials.UFCP_FONT}


-- force preload resources to avoid freeze on start (list of texture files)

-- preload_texture = {}
