SUB_PAGE_NAME = nil
SUB_PAGE_VAL = nil

AddBox(nil,width,height,nil,nil,'DBG_RED',DEFAULT_MASK_LEVEL,REWRITE_LEVEL,Page3_sim,nil,nil,true)

local posX = 0
local posY = -0.6*height
local hsiSim = AddSimple(nil,{posX,posY},nil,Page3_sim)
local planeLineVertical = {
    {0*width-posX,-0.5*height-posY},{-0.008810*width-posX,-0.553546*height-posY},{-0.039700*width-posX,-0.597872*height-posY},{-0.016575*width-posX,-0.597144*height-posY},{-0.016575*width-posX,-0.615045*height-posY},{-0.067509*width-posX,-0.674657*height-posY},{-0.067509*width-posX,-0.681903*height-posY},{-0.031180*width-posX,-0.691262*height-posY},{-0.031180*width-posX,-0.718091*height-posY},{-0*width-posX,-0.7*height-posY},
}

planeLineVertical = MirrorSimpleLine(planeLineVertical,'Y',0,false)
AddSimpleLine(nil,0.003*width,planeLineVertical,nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,hsiSim)

local hsiRotSim = AddSimple(nil,nil,nil,hsiSim,{'HDG','HSI_MAP'},{{AnimalControllor.rotateUsingParameter,0,math.rad(1)}})
AddCircle(nil,0.3025*width,0.3025*width-0.005*width,360,72,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})--东南西北的环
AddCircle(nil,0.6025*width,0.6025*width-0.005*width,360,72,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})--数字与东南西北中间的环
AddCircle(nil,0.9025*width,0.9025*width-0.005*width,360,72,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})--数字航向所在的环
AddCircle(nil,1.2025*width,1.2025*width-0.005*width,360,72,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})--最外环
local mirrorVertical = {{0,0.3*width},{0,0.332217*width}}
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
mirrorVertical = MirrorSimpleLine(mirrorVertical,'X',0,true)
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
mirrorVertical = {{0.3*width,0},{0.332217*width,0}}
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
mirrorVertical = MirrorSimpleLine(mirrorVertical,'Y',0,true)
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
--mirrorVertical ={{0,0.8975*width},{0,0.8975*width-0.03*width}}
--AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,hsiRotSim,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})

for i = 0, 360, 90 do
    local simple = AddSimple(nil,nil,{i,0},hsiRotSim)
    local symbol
    if i == 0 then
        symbol = 'N'
    elseif i == 90 then
        symbol = 'W'
    elseif i == 180 then
        symbol = 'S'
    elseif i == 270 then
        symbol = 'E'
    end
    local text = AddText(nil,symbol,'unicode_cn_white',{0,0.38*width},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,simple,nil,{'HDG','HSI_MAP'},{
        {AnimalControllor.rotateUsingParameter,0,math.rad(-1)},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0}
    })
    text.init_rot = {-i,0}
end

for i = 0, 11, 1 do --刻度 为VR模式简化
    local hdg = 30*i
	local linePos = {{0,0.8975*width},{0,0.8975*width-0.06*width}}
    local simple = AddSimple(nil,nil,{-hdg,0},hsiRotSim)
	local line = AddSimpleLine(nil,0.005*width,linePos,nil,nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,simple,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
    AddText(nil,hdg,'unicode_cn_white',{0,0.8*width},nil,DEFAULT_FONT_SIZE[5],nil,DEFAULT_MASK_LEVEL,simple,nil,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0}})
end

--显示比例
local scaleNum=AddText(nil,'40','unicode_cn_green',{0.95*width,0.56*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim,
    {'%.0f'},{'MAX_RANGE'},{
    {AnimalControllor.textUsingParameter,0}
})
---------------------------------------------------------------------------------------
local hdgFrameSim = AddSimple("HSI航向框节点",{0,1*width},nil,hsiSim)
AddSimpleLine("HSI航向框边条",0.005*width,{{-0.07*width,0.04*height},{0.07*width,0.04*height},{0.07*width,-0.04*height},{0.035*width,-0.04*height},{0,-0.08*height},{-0.035*width,-0.04*height},{-0.07*width,-0.04*height},{-0.07*width,0.04*height}},nil,nil,FrameEdgeMaterial,nil,DEFAULT_MASK_LEVEL,hdgFrameSim)
AddText("HSI航向值",'000','unicode_cn_white',nil,nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,hdgFrameSim,{'%.0f'},{'HDG','HSI_MAP'},{{AnimalControllor.textUsingParameter,0},{AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0}})

local navTxt = AddText(nil,'导航','unicode_cn_white',{-0.411*width,0.925*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim)
AddBoxBorder(nil,0.072*width,0.04*height,0.007*width,nil,nil,FrameEdgeMaterial,DEFAULT_MASK_LEVEL,nil,navTxt)

local magNorthTxt = AddText(nil,'磁北','unicode_cn_white',{0.411*width,0.925*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim)
AddBoxBorder(nil,0.072*width,0.04*height,0.007*width,nil,nil,FrameEdgeMaterial,DEFAULT_MASK_LEVEL,nil,magNorthTxt,{'HDG_TYPE'},{{AnimalControllor.parameterInRange,0,-0.1,0.1}})

AddText(nil,'菜\n单','unicode_cn_green',{-0.93*width,0.56*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim)

local txt = AddText(nil,'防\n拥','unicode_cn_white',{-0.9525*width,-0.547*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim)
AddBoxBorder(nil,0.04*width,0.08*height,0.007*width,nil,nil,FrameEdgeMaterial,DEFAULT_MASK_LEVEL,nil,txt)

local txt1 = AddText(nil,'地\n图','unicode_cn_green',{0.9525*width,-0.547*height},nil,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,Page3_sim,nil,{'HSI_MAP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1}})
AddBoxBorder(nil,0.04*width,0.08*height,0.007*width,nil,nil,FrameEdgeMaterial,DEFAULT_MASK_LEVEL,nil,txt1,{'HSI_MAP'},{{AnimalControllor.parameterInRange,0,0.9,1.1}})

mirrorVertical = {{0,0.176427*height},{-0.03*width,0.143015*height},{0.03*width,0.143015*height},{0,0.176427*height}}
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,scaleNum,{'HSI_SCALE_UP'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1}})
mirrorVertical = MirrorSimpleLine(mirrorVertical,'X',0,true)
AddSimpleLine(nil,0.005*width,mirrorVertical,nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,scaleNum,{'HSI_SCALE_DN'},{{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1}})

AddMeshPoly(nil,{{-0.078*width,0},{0.078*width,0},{0,0.09*height}},{0,1,2},{-0.882*width,0.894*height},nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,Page3_sim)
AddMeshPoly(nil,{{-0.06*width,0},{0.06*width,0},{0,0.07*height}},{0,1,2},{-0.882*width,0.904*height},nil,'LIGHT_BLUE',nil,DEFAULT_MASK_LEVEL,Page3_sim)

AddMeshPoly(nil,{{-0.078*width,0.09*height},{0.078*width,0.09*height},{0,0}},{0,1,2},{0.882*width,0.894*height},nil,'DBG_WHITE',nil,DEFAULT_MASK_LEVEL,Page3_sim)
AddMeshPoly(nil,{{-0.06*width,0.07*height},{0.06*width,0.07*height},{0,0}},{0,1,2},{0.882*width,0.904*height},nil,'LIGHT_BLUE',nil,DEFAULT_MASK_LEVEL,Page3_sim)
-----------------------------------------------------------------------------------
local ud_scale
local lr_scale
if not BackUpIndicator then
    ud_scale 	= 0.00000169
    lr_scale 	= 0.00000169
else
    ud_scale 	= 0.00000152
    lr_scale 	= 0.00000169
end
local life_time 	= 4.72
local life_time_low = 2.10
IGNORE_BRT = true--使用自定义的透明度控制
--雷达目标
for i = 1, Targetnum do
    local rdrContactRotSimple = AddSimple(nil,nil,nil,hsiSim,{string.format('RADAR_CONTACT_%02d_AZIMUTH',i)},{
        {AnimalControllor.rotateUsingParameter,0,-1}
    })
    local rdrContactSimple = AddSimple(nil,nil,nil,rdrContactRotSimple,{
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i)
    },{
        {AnimalControllor.moveUpDownUsingParameter		,0,ud_scale},
        {AnimalControllor.rotateUsingParameter,1,1}
    })
    AddCircle(nil,0.035*width,0.03*width,360,36,nil,nil,'LIGHT_BLUE',nil,DEFAULT_MASK_LEVEL,rdrContactSimple,{
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,0.9,1.1},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
    })
    AddSimpleLine(nil,0.005*width,{{0,0},{0,0.1*width}},nil,nil,'LIGHT_BLUE',nil,DEFAULT_MASK_LEVEL,rdrContactSimple,
    {
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
        string.format('RADAR_CONTACT_%02d_REL_HEAD',i),
    },
    {
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,0.9,1.1},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
		{AnimalControllor.rotateUsingParameter,5,math.rad(1)}
    })
    AddCircle(nil,0.035*width,0,360,36,nil,nil,'DBG_RED',nil,DEFAULT_MASK_LEVEL,rdrContactSimple,
    {
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,-0.1,0.1},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
    })
    AddSimpleLine(nil,0.005*width,{{0,0},{0,0.1*width}},nil,nil,'DBG_RED',nil,DEFAULT_MASK_LEVEL,rdrContactSimple,
    {
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
        string.format('RADAR_CONTACT_%02d_REL_HEAD',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,-0.1,0.1},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
        {AnimalControllor.rotateUsingParameter,5,math.rad(1)}
    })
    AddText(nil,'?','unicode_cn_yellow',nil,nil,DEFAULT_FONT_SIZE[5],nil,DEFAULT_MASK_LEVEL,rdrContactSimple,nil,{
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,-1.1,-0.9},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
    })
    AddSimpleLine(nil,0.005*width,{{0,0.035*width},{0,0.1*width}},nil,nil,'DBG_YELLOW',nil,DEFAULT_MASK_LEVEL,rdrContactSimple,
    {
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
        string.format('RADAR_CONTACT_%02d_REL_HEAD',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.parameterInRange,2,-1.1,-0.9},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.parameterInRange,4,-math.rad(60),math.rad(60)},
        {AnimalControllor.rotateUsingParameter,5,math.rad(1)}
    })
    AddText(nil,nil,'unicode_cn_yellow',{-0.1*height},nil,DEFAULT_FONT_SIZE[7],nil,DEFAULT_MASK_LEVEL,rdrContactSimple,{'%s'},{
        string.format('RADAR_CONTACT_%02d_RANGE_SCALE',i),
        string.format('RADAR_CONTACT_%02d_TIME',i),
        string.format('RADAR_CONTACT_%02d_FRIENDLY',i),
        string.format('RADAR_CONTACT_%02d_RCS',i),
        string.format('RADAR_CONTACT_%02d_NCTR',i),
        string.format('NCTR_STATUS',i),
        string.format('RADAR_CONTACT_%02d_AZIMUTH',i),
    },{
        {AnimalControllor.parameterInRange,0,30,50000},
        {AnimalControllor.parameterInRange,1,life_time_low,life_time},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,2,-1,1,1,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,2,0,1,0,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,0,1,0},
        {AnimalControllor.opacityUsingParameter,3},
        {AnimalControllor.textUsingParameter,4},
        {AnimalControllor.parameterInRange,5,0.9,1.1},
        {AnimalControllor.parameterInRange,6,-math.rad(60),math.rad(60)},
    })
end
IGNORE_BRT = false--取消自定义透明度控制
-----------------------------------------------------------------------------------
local x_size = 0.04*width
local y_size = 0.05*height
--BVR扫描扇区
AddCircle(nil,2*height,0,120,72,{0,0},{60,0},MakeMaterial(nil, { 0, 0, 255, 64 }),nil,DEFAULT_MASK_LEVEL,hsiSim,
    {'SCAN_ZONE_ORIGIN_AZIMUTH', "RADAR_WORK_MODE","RADAR_MODE"},
    {{AnimalControllor.rotateUsingParameter,0,1},{AnimalControllor.parameterCompareWithNumber, 1, 0},{AnimalControllor.parameterInRange, 2, -0.9,2.1}}
)
--ACM扇区
AddCircle(nil,width*1.2025*5/8 ,0,120,72,{0,0},{60,0},MakeMaterial(nil, { 255, 0, 0, 64 }),nil,DEFAULT_MASK_LEVEL,hsiSim,
    {"HSI_ACM_ZONE", "RADAR_WORK_MODE","MAX_RANGE","UNIT","RADAR_MODE"},
    {
        {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
        {AnimalControllor.parameterCompareWithNumber, 1, 5},
        {AnimalControllor.parameterCompareWithNumber, 2, 80},
        {AnimalControllor.parameterCompareWithNumber, 3, 1},
        {AnimalControllor.parameterInRange, 4, -0.9,2.1}
    }
)
local circleConfigs = {
    { -- 每个maxR对应的4个圆圈配置
        radii = {1, 5.5, 2, 0.5,  1*1.852, 5.5*1.852, 2*1.852, 0.5*1.852},        -- 半径倍数(10,55,20,0.5 NM;10,55,20,0.5 KM)
        scanWidths = {10, 5, 2, 4, 10, 5, 2, 4},     -- 扫描宽(角度)
        params = {                      -- 参数配置
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 1},
                    {AnimalControllor.parameterCompareWithNumber, 2, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 3, 1},
                    {AnimalControllor.parameterInRange, 4, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "HELMET_IN_RADAR_SCAN", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 2},
                    {AnimalControllor.parameterCompareWithNumber, 2, 1},
                    {AnimalControllor.parameterCompareWithNumber, 3, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 4, 1},
                    {AnimalControllor.parameterInRange, 5, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "HELMET_IN_RADAR_SCAN", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 3},
                    {AnimalControllor.parameterCompareWithNumber, 2, 1},
                    {AnimalControllor.parameterCompareWithNumber, 3, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 4, 1},
                    {AnimalControllor.parameterInRange, 5, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 4},
                    {AnimalControllor.parameterCompareWithNumber, 2, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 3, 1},
                    {AnimalControllor.parameterInRange, 4, -0.9,2.1}
                }
            },
			{
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 1},
                    {AnimalControllor.parameterCompareWithNumber, 2, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 3, 0},
                    {AnimalControllor.parameterInRange, 4, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "HELMET_IN_RADAR_SCAN", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 2},
                    {AnimalControllor.parameterCompareWithNumber, 2, 1},
                    {AnimalControllor.parameterCompareWithNumber, 3, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 4, 0},
                    {AnimalControllor.parameterInRange, 5, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "HELMET_IN_RADAR_SCAN", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 3},
                    {AnimalControllor.parameterCompareWithNumber, 2, 1},
                    {AnimalControllor.parameterCompareWithNumber, 3, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 4, 0},
                    {AnimalControllor.parameterInRange, 5, -0.9,2.1}
                }
            },
            {
                params = {"HSI_ACM_ZONE", "RADAR_WORK_MODE", "MAX_RANGE","UNIT","RADAR_MODE"},
                conditions = {
                    {AnimalControllor.rotateUsingParameter, 0, math.rad(-1)},
                    {AnimalControllor.parameterCompareWithNumber, 1, 4},
                    {AnimalControllor.parameterCompareWithNumber, 2, "maxR"},
					{AnimalControllor.parameterCompareWithNumber, 3, 0},
                    {AnimalControllor.parameterInRange, 4, -0.9,2.1}
                }
            }
        }
    }
}

local ranges = {5, 10, 20, 40, 80, 160, 320, 320}  -- 所有maxR值
local baseScale = width * 1.2025             -- 最大圆环的缩放比例

-- 通用创建函数
local function createCircles(maxR)

    local maxR_scale = baseScale / (maxR * 0.1)
    for i, config in ipairs(circleConfigs[1].params) do
        local radius = maxR_scale * circleConfigs[1].radii[i]
        local scanWidth = circleConfigs[1].scanWidths[i]

        -- 动态替换maxR参数
        local processedConditions = {}
        for _, condition in ipairs(config.conditions) do
            if condition[3] == "maxR" then
                table.insert(processedConditions, {condition[1], condition[2], maxR})
            else
                table.insert(processedConditions, condition)
            end
        end

        AddCircle(nil,radius,0,scanWidth,6,{0,0},{scanWidth/2,0},MakeMaterial(nil, {255, 0, 0, 64}),nil,DEFAULT_MASK_LEVEL,hsiSim,
            config.params,
            processedConditions
        )
    end
end

-- 批量创建所有圆环
for _, maxR in ipairs(ranges) do
    createCircles(maxR)
end
-------------------------------------------------------------
--tdc
local tdc_rot_sim = AddSimple(nil,nil,nil,hsiSim,
    {'RADAR_TDC_AZIMUTH','SCAN_ZONE_ORIGIN_AZIMUTH'},
    {
        {AnimalControllor.rotateUsingParameter,0,-1},
        {AnimalControllor.rotateUsingParameter,1, 1},
    }
)
local TDC_cursor = AddMultiLine(nil,1.5,nil,{{-x_size,-y_size},{-x_size,y_size},{x_size,-y_size},{x_size,y_size}},{0,1,2,3},{ 0, 0 },nil,'DBG_YELLOW',Align.CC,nil,DEFAULT_MASK_LEVEL,tdc_rot_sim,
	{
		"RADAR_TDC_RANGE_SCALE",
		"RADAR_MODE",
	},
	{
		{ AnimalControllor.moveUpDownUsingParameter, 0, ud_scale },
		{ AnimalControllor.parameterInRange, 1, -0.1, 2.1 },
	}
)
-----------------------------------------------------------------
--STT范围
AddCircle(nil,2*height,0,120,72,{0,0},{60,0},MakeMaterial(nil, { 0, 255, 0, 64 }),nil,DEFAULT_MASK_LEVEL,hsiSim,
    {'SCAN_ZONE_ORIGIN_AZIMUTH',"RADAR_MODE"},
    {{AnimalControllor.rotateUsingParameter,0,1},{AnimalControllor.parameterCompareWithNumber, 1, 3}}
)
AddCircle(nil,2*height,0,5,72,{0,0},{2.5,0},MakeMaterial(nil, { 0, 0, 0, 128 }),nil,DEFAULT_MASK_LEVEL,hsiSim,
	{'RADAR_STT_AZIMUTH','RADAR_MODE'},
	{
        {AnimalControllor.rotateUsingParameter,0,-1},
        {AnimalControllor.parameterInRange,1,2.9,3.1}
    }
)
local stt_rot_sim = AddSimple(nil,nil,nil,hsiSim,{'RADAR_STT_AZIMUTH'},{
    {AnimalControllor.rotateUsingParameter,0,-1}
})
local stt_circle = AddCircle(nil,0.015*width,0,360,36,nil,nil,'DBG_RED',nil,DEFAULT_MASK_LEVEL,stt_rot_sim,
    {
        'RADAR_STT_RANGE_SCALE',
        'RADAR_STT_FRIENDLY',
        'RADAR_MODE',
    },{
        {AnimalControllor.moveUpDownUsingParameter		,0,ud_scale},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,1,-1,1,1,0},
	    {AnimalControllor.changeColorWhenParameterEqualToNumber,1,0,1,0,0},
	    {AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
        {AnimalControllor.parameterInRange,2,2.9,3.1}
})
AddText(nil,nil,'unicode_cn_red',{0,0},Align.CT,DEFAULT_FONT_SIZE[4],nil,DEFAULT_MASK_LEVEL,stt_circle,
    {'%.2fKM \n',' %s'},{
        "TARGET_RANGE",
        "TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        {AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterCompareWithNumber,	2,1},
        {AnimalControllor.parameterCompareWithNumber,	3,0}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,0},Align.CT,DEFAULT_FONT_SIZE[4],nil,DEFAULT_MASK_LEVEL,stt_circle,
    {'%.2fNM \n',' %s'},{
        "TARGET_RANGE_NM",
        "TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        {AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterCompareWithNumber,	2,1},
        {AnimalControllor.parameterCompareWithNumber,	3,1}
    }
)
local magVarSimple = AddSimple(nil,nil,nil,hsiRotSim,{'MAG_VAR'},{
    {AnimalControllor.rotateUsingParameter,0,math.rad(1)}
})
local mapMvSimple = AddSimple(nil,nil,nil,magVarSimple,{'GPS_LAT_M_SC','GPS_LON_M_SC'},{
    {AnimalControllor.moveUpDownUsingParameter,0,-ud_scale},
    {AnimalControllor.moveLeftRightUsingParameter,1,-lr_scale},
})

local tcnSimple = AddSimple(nil,nil,nil,mapMvSimple,{
    'TCN_LAT_M',
    'TCN_LON_M',
},{
    {AnimalControllor.moveUpDownUsingParameter,0,ud_scale},
    {AnimalControllor.moveLeftRightUsingParameter,1,lr_scale}
})
local tcnSize = 0.08*width
local tcnLineP = {{0,0.498*tcnSize},{-0.278*tcnSize,0.498*tcnSize},{-0.635*tcnSize,0.69*tcnSize},{-0.906*tcnSize,0.202*tcnSize},{-0.576*tcnSize,0.003*tcnSize},{-0.273*tcnSize,-0.492*tcnSize},{-0.273*tcnSize,-0.923*tcnSize},{0,-0.923*tcnSize}}
tcnLineP=MirrorSimpleLine(tcnLineP,'Y',0)
AddSimpleLine(nil,0.006*width,tcnLineP,nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,tcnSimple,
    {'TCN_WORKING','HDG'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.rotateUsingParameter,1,-math.rad(1)}
    }
)
AddCircle(nil,0.148*tcnSize,0,360,18,nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,tcnSimple,
{'TCN_WORKING'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1}
    }
)

AddSimpleLine(nil,0.004*width,{{0,1.2*height},{0,-1.2*height}},nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,tcnSimple,
    {'TCN_WORKING','RUNWAY_AZ'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.rotateUsingParameter,1,-math.rad(1)}
    }
)
AddMeshPoly(nil,{{0,0.9025*width},{-0.05*width,1.0025*width},{0.05*width,1.0025*width}},{0,1,2},nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,hsiRotSim,
    {'TCN_STATUS','TCN_AZ'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.rotateUsingParameter,1,-math.rad(1)}
    }
)
--------------------------------------------------
--地形扫描像素点
-- local row = 200
-- local ceil = 200
-- local w = width/(ceil/2)
-- local h = height/(row/2)
-- local terrainSim = AddSimple(nil,{0,-0.4*height},nil,hsiSim)
-- for i = 1, row, 1 do
--     for j = 1, ceil, 1 do
--         AddBox(nil,w,h,{(j-100)*w,i*h},nil,'TERRAIN_LAND',DEFAULT_MASK_LEVEL,nil,terrainSim,{
--             string.format('TERRAIN_PIX_%.0f_%.0f_LAND',i,j),
--             'HSI_MAP'
--         },{
--             {AnimalControllor.parameterInRange,0,0.9,1.1},
--             {AnimalControllor.parameterInRange,1,0.9,1.1}
--         })
--         AddBox(nil,w,h,{(j-100)*w,i*h},nil,'TERRAIN_SEA',DEFAULT_MASK_LEVEL,nil,terrainSim,{
--             string.format('TERRAIN_PIX_%.0f_%.0f_LAND',i,j),
--             'HSI_MAP'
--         },{
--             {AnimalControllor.parameterInRange,0,1.9,2.1},
--             {AnimalControllor.parameterInRange,1,0.9,1.1}
--         })
--     end
-- end
--不要这玩意了，这个代价是性能的降低
--------------------------------------------------
---以下与VR不兼容
--[[for i = 1, 100, 1 do
    local wpt = AddCircle(nil,0.01*width,0*height,360,18,nil,nil,'DBG_RED',nil,DEFAULT_MASK_LEVEL,mapMvSimple,
    {
        string.format('WPT_%02.0f_LAT',i),
        string.format('WPT_%02.0f_LON',i)
    },{
        {AnimalControllor.moveUpDownUsingParameter,0,ud_scale},
        {AnimalControllor.moveLeftRightUsingParameter,1,lr_scale}
    })
    local sim = AddSimple(nil,nil,nil,wpt,{'HDG'},{{AnimalControllor.rotateUsingParameter,0,-math.rad(1)}})
    AddText(nil,nil,'unicode_cn_green',{0.05*width,-0.05*height},Align.CC,DEFAULT_FONT_SIZE[5],nil,DEFAULT_MASK_LEVEL,sim,{'%.0f'},
    {
        string.format('WPT_%02.0f_NUM',i),
        'TARGET_WPT'
    },{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,1,i,1,1,1}
    })
    AddSimpleLine(nil,0.002*width,{{0,0},{0,0}},nil,nil,'DBG_GREEN',nil,DEFAULT_MASK_LEVEL,wpt,
	{
        string.format('WPT_%02.0f_NEXT',i),
        string.format('WPT_%02.0f_NEXT_REL_LON',i),
        string.format('WPT_%02.0f_NEXT_REL_LAT',i),
        string.format('WPT_%02.0f_NEXT_REL_LON_2',i),
        string.format('WPT_%02.0f_NEXT_REL_LAT_2',i)
    },
	{
		{AnimalControllor.parameterInRange,0,0.9,1.1},
		{AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,lr_scale,ud_scale},
		{AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,lr_scale,ud_scale}
	})
end]]
--[[
local airdromes = get_terrain_related_data('Airdromes')

for i = 1, #airdromes, 1 do
    local airportSim = AddSimple(nil,nil,nil,mapMvSimple,{
        string.format('AIRPORT_%.0f_LAT_M',i),
        string.format('AIRPORT_%.0f_LON_M',i),
    },{
        {AnimalControllor.moveUpDownUsingParameter,0,ud_scale},
        {AnimalControllor.moveLeftRightUsingParameter,1,lr_scale},
    })
    local airport = AddCircle(nil,0.04*width,0,360,36,nil,nil,'DBG_BLUE',nil,DEFAULT_MASK_LEVEL,airportSim,{
        string.format('AIRPORT_%.0f_RUNWAY',i),
        string.format('AIRPORT_%.0f_RANGE_LAT_M',i),
        string.format('AIRPORT_%.0f_RANGE_LON_M',i),
    },{
        {AnimalControllor.rotateUsingParameter,0,math.rad(-10)},
        {AnimalControllor.parameterInRange,1,-20000,60000},
        {AnimalControllor.parameterInRange,2,-60000,60000},
    })
    AddBox(nil,0.01*width,0.05*height,nil,nil,'DBG_WHITE',DEFAULT_MASK_LEVEL,nil,airport,{
        string.format('AIRPORT_%.0f_RANGE_LAT_M',i),
        string.format('AIRPORT_%.0f_RANGE_LON_M',i),
    },{
        {AnimalControllor.parameterInRange,0,-20000,60000},
        {AnimalControllor.parameterInRange,1,-60000,60000},
    })
    local sim = AddSimple(nil,nil,nil,airportSim,{'HDG'},{{AnimalControllor.rotateUsingParameter,0,-math.rad(1)}})
    AddText(nil,nil,'unicode_cn_white',{0,-0.08*height},Align.CT,DEFAULT_FONT_SIZE[6],nil,DEFAULT_MASK_LEVEL,sim,{'%s'},{
        string.format('AIRPORT_%.0f_NAME',i),
        string.format('AIRPORT_%.0f_RANGE_LAT_M',i),
        string.format('AIRPORT_%.0f_RANGE_LON_M',i),
    },
    {
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterInRange,1,-20000,60000},
        {AnimalControllor.parameterInRange,2,-60000,60000},
    }
)
end]]