
dofile(LockOn_Options.script_path .. "devices.lua")
dofile(LockOn_Options.script_path .. "materials.lua") -- 加载材质
dofile(LockOn_Options.script_path .. "cockpit_cfg.lua")

if not Is20Type then
    return
end

-- set panel
MainPanel = { "ccMainPanel", LockOn_Options.script_path .. "mainpanel_init.lua" }

creators = {}

creators[devices.ELECTRIC_SYSTEM]  = { "avSimpleElectricSystem", 	LockOn_Options.script_path .. "Systems/electric_system.lua" }
creators[devices.HYDRAULIC_SYSTEM] = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/hydraulic_system.lua" }
creators[devices.ENGINE]           = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/engine.lua" }
creators[devices.PRISURFACE]       = { "avLuaDevice", 				LockOn_Options.script_path .. "priControlSurface.lua" }
creators[devices.CANOPY]           = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/canopy.lua" }
creators[devices.GEAR_SYSTEM]      = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/gear_system.lua" }
--creators[devices.SLAT_SYSTEM]	   = { "avLuaDevice",				LockOn_Options.script_path .. "Systems/slat_system.lua" }
creators[devices.BREAK_SYSTEM]     = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/break_system.lua" }
creators[devices.LIGHT]            = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/light_system.lua" }

if USE_EXT_DLL and Type then
	creators[devices.WEAPON_SYSTEM] = { "avSimplestWeaponSystem", LockOn_Options.script_path .. "Systems/weapon_system.lua" }
else
    creators[devices.WEAPON_SYSTEM] = { "avSimpleWeaponSystem", LockOn_Options.script_path .. "Systems/weapon_system.lua" }
end

-- creators[devices.TEST_SCREEN]  = { "avLuaDevice", LockOn_Options.script_path .. "Systems/test_screen.lua" }
creators[devices.SENSOR]           = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/sensor_system.lua" }
creators[devices.WARNING]          = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/warning_system.lua" }
creators[devices.UHF_RADIO]        = { "avUHF_ARC_164v2", 			LockOn_Options.script_path .. "radio/uhf_radio.lua", { devices.ELECTRIC_SYSTEM } }
creators[devices.VHF_AM_RADIO]     = { "avVHF_ARC_186", 			LockOn_Options.script_path .. "radio/vhf_am_radio.lua", { devices.ELECTRIC_SYSTEM }, LockOn_Options.script_path .. "radio/Radio_commands.lua" }
creators[devices.VHF_FM_RADIO]     = { "avVHF_ARC_186", 			LockOn_Options.script_path .. "radio/vhf_fm_radio.lua", { 'elec_system', devices.ELECTRIC_SYSTEM }, LockOn_Options.script_path .. "radio/Radio_commands.lua" }
creators[devices.INTERCOM]         = { "avIntercomV2", 				LockOn_Options.script_path .. "radio/Intercom.lua", { devices.ELECTRIC_SYSTEM, devices.UHF_RADIO, devices.VHF_AM_RADIO, devices.VHF_FM_RADIO, devices.ILS } }
creators[devices.RADIO_HACKER]     = { "avLuaDevice", 				LockOn_Options.script_path .. "radio/radioHacker.lua" }
creators[devices.RADAR_RAW]        = { "avSimpleRadar", 			LockOn_Options.script_path .. "displays/Radar/Device/Radar_init.lua", { devices.ELECTRIC_SYSTEM } }
creators[devices.HUD_DCMS]         = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/HUD/device/hud.lua" }
creators[devices.MP3]              = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/mp3Player.lua" }
creators[devices.ROD]              = { "avLuaDevice", 				LockOn_Options.script_path .. "Displays/Rod/device/Rod_init.lua" } -- 杆量指示器
creators[devices.RWR]              = { "avSimpleRWR", 				LockOn_Options.script_path .. "sensors/Rwr.lua", { devices.ELECTRIC_SYSTEM } }
creators[devices.UFCP]             = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/UFCP/device/device.lua", { devices.UHF_RADIO, devices.VHF_AM_RADIO } }
creators[devices.FUEL]             = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/fuel_system.lua" }
creators[devices.HSI]              = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/MFD/device/hsiDevice.lua" }
creators[devices.FCS]              = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/MFD/device/fcsDevice.lua" }
creators[devices.MFCD]             = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/MFD/device/mfcdDevice.lua" }
creators[devices.MFCD_BACKUP]      = { "avLuaDevice", 				LockOn_Options.script_path .. "displays/MFD-backUp/device/device.lua" }
creators[devices.TERRAIN]          = { "avLuaDevice", 				LockOn_Options.script_path .. "Systems/terrainScanner.lua" } -- 严重降低性能，弃用
creators[devices.NVG]              = { "avNightVisionGogglesV2" }
creators[devices.ILS]              = { "avILS", 					LockOn_Options.script_path .. "Systems/ils.lua", { devices.ELECTRIC_SYSTEM } }
creators[devices.HELMET]           = { "avLuaDevice",				LockOn_Options.script_path .. "displays/Helmet/device/device.lua", { devices.ELECTRIC_SYSTEM } }
creators[devices.NAV]              = { "avLuaDevice",				LockOn_Options.script_path .. "Nav/nav.lua" }
creators[devices.CLOCK]            = { "avA11Clock" }

if USE_EXT_DLL and Type then
    creators[devices.FLIR] 		   = { "LR::avSimplestFLIR", 		LockOn_Options.script_path .. "FLIR/device.lua" }
end

creators[#creators + 1] = { "avLuaDevice", LockOn_Options.script_path .. "Systems/cheat.lua" }

-- Indicators
indicators = {}

-- MFD
--indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "displays/MFD/Indicator/init.lua", nil, { { "MAIN_DP_C", "MAIN_DP_D", "MAIN_DP_R" }, {}, 1 } }
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "displays/MFD/Indicator/init.lua", {devices.MFCD,devices.HSI,devices.FCS}, { { "MAIN_DP_C", "MAIN_DP_D", "MAIN_DP_R" } } }
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "displays/MFD-backUp/Indicator/init.lua", devices.MFCD_BACKUP, { { "DOWN_DP_C", "DOWN_DP_D", "DOWN_DP_R" } } }

-- HUD
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "displays/HUD/Indicator/init.lua", devices.HUD_DCMS, { { "HUD_C", "HUD_D", "HUD_R" } } }
-- UFCP
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "displays/UFCP/Indicator/init.lua", devices.UFCP, { { "UFCP_C", "UFCP_D", "UFCP_R" } } }
-- ROD
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "Displays/Rod/Indicator/init.lua", devices.ROD, nil }
-- HMD
indicators[#indicators + 1] = { "ccIndicator", LockOn_Options.script_path .. "Displays/Helmet/Indicator/init.lua", devices.HELMET }

if USE_EXT_DLL and Type then
    indicators[#indicators + 1] = { "LR::ccCamera", LockOn_Options.script_path .. "FLIR/indicator.lua", devices.FLIR, { {} } }
end
