local weaponSystem     = GetSelf()
dofile(LockOn_Options.common_script_path.."devices_defs.lua")
--dofile(LockOn_Options.script_path.."Systems/stores_config.lua")
dofile(LockOn_Options.script_path.."cockpit_cfg.lua")
dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")

dofile(LockOn_Options.common_script_path .. "../../../Database/wsTypes.lua")
local avSimplestWeaponSystem = nil
if not (USE_EXT_DLL and Type) then
    package.cpath 			= package.cpath..";".. LockOn_Options.script_path.. "..\\..\\bin\\?.dll"
    avSimplestWeaponSystem = require('avSimplestWeaponSystem')
	--print_message_to_user("package avSimplestWeaponSystem")
end

local gunFire = 0
local gunFireTime = 0
local unlimited_weapons = false
local weaponLoading = false
local loadStationIdx = 0
local launchAuthorization = false
local gunPodIdx = {}

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local sensor_data = get_base_data()

local ir_selected = 0

-- 获取锁定状态
-- 是否锁定
local ir_missile_lock_param = get_param_handle("WS_IR_MISSILE_LOCK")
-- 锁定的红外目标的高程和方向
local ir_missile_az_param = get_param_handle("WS_IR_MISSILE_TARGET_AZIMUTH")
local ir_missile_el_param = get_param_handle("WS_IR_MISSILE_TARGET_ELEVATION")

local dlz_min_param = get_param_handle("WS_DLZ_MIN")
local dlz_max_param = get_param_handle("WS_DLZ_MAX")
local dlz_authorized_param = get_param_handle("WS_DLZ_AUTHORIZED")

local gun_piper_available_param = get_param_handle('WS_GUN_PIPER_AVAILABLE')
local gun_piper_az_param = get_param_handle('WS_GUN_PIPER_AZIMUTH')
local gun_piper_el_param = get_param_handle('WS_GUN_PIPER_ELEVATION')
local gun_piper_span_param = get_param_handle('WS_GUN_PIPER_SPAN')

local target_range_param = get_param_handle('WS_TARGET_RANGE')
local target_span_param = get_param_handle('WS_TARGET_SPAN')

-- 红外弹导引头相关
-- 方位角
local ir_missile_des_az_param = get_param_handle("WS_IR_MISSILE_SEEKER_DESIRED_AZIMUTH")
-- 高程
local ir_missile_des_el_param = get_param_handle("WS_IR_MISSILE_SEEKER_DESIRED_ELEVATION")

local ir_seek_az_offset = 0
local ir_seek_el_offset = 0
local ir_seek_az_limit = {-3,3}
local ir_seek_el_limit = {-3,3}
local ir_seek_el = 0
local ir_seek_az = 0
local ir_seek_scan_speed = update_time_step*10
local ir_seek_step_time = 0

local ccrp_status = false

-- 获取仪表weaponpage句柄

weaponSystem:listen_command(Keys.WeaponSelectNext)
weaponSystem:listen_command(Keys.WeaponLaunch)
weaponSystem:listen_command(Keys.DropChaff)
weaponSystem:listen_command(Keys.DropChaffAndFlare)
weaponSystem:listen_command(Keys.DropFlare)
weaponSystem:listen_command(Keys.A2A)
weaponSystem:listen_command(Keys.A2G)
weaponSystem:listen_command(Keys.GunMode)
weaponSystem:listen_command(Keys.ActiveJamming)
weaponSystem:listen_command(Keys.PlaneWingtipSmokeOnOff)
weaponSystem:listen_command(Keys.EmergJettion)
weaponSystem:listen_command(Keys.masterArm)
weaponSystem:listen_command(Keys.PlaneAHCPMasterArm)
weaponSystem:listen_command(Keys.PlaneAHCPMasterSafe)

weaponSystem:listen_event(CptEvntNames.weaponRearmComplete)
weaponSystem:listen_event(CptEvntNames.weaponRearmFirstStep)
weaponSystem:listen_event(CptEvntNames.weaponRearmSingleStepComplete)
weaponSystem:listen_event(CptEvntNames.unlimitedWeaponStationRestore)
weaponSystem:listen_event(CptEvntNames.initChaffFlarePayload)

terrainAirdromes = get_terrain_related_data("Airdromes")

local A2A_R = {'{J20A_PL17},{BayArm_J20_PL-17_x4},{J20A_PL15},J20_PL-15_DUAL,BayArm_J20_PL-15_DUAL,DIS_PL-12'}
local A2A_IR = {'{PLAAF_PL-10E},{BayArm_PLAAF_PL-10E_x4}'}

local master_Arm = 0

local weapon_name = {
	['DIS_LD-10'] = '雷电10',
	['DIS_LD-10_DUAL_L'] = '雷电-10',
	['DIS_PL-12'] = '霹雳12',
	['DIS_PL-12_DUAL_L'] = '霹雳-12',
	['{J20A_PL17}'] = '霹雳17',
	['{BayArm_J20_PL-17_x4}'] = '霹雳-17',
	['{J20A_PL15}'] = '霹雳15',
	['J20_PL-15_DUAL'] = '霹雳-15',
    ['BayArm_J20_PL-15_DUAL'] = '霹雳-15',
    ['{PLAAF_PL-10E}'] = '霹雳10E',
	['{BayArm_PLAAF_PL-10E_x4}'] = '霹雳-10E',
    ['DIS_GBU_12'] = 'GBU-12',
    ['DIS_MK_20'] = 'MK-20',
	['J_20A_AGM-65E'] = 'AGM-65E',
    ['DIS_DF4B_YJ12'] = '鹰击-12',
	['DIS_GDJ_YJ83K'] = '鹰击-83',
    ['J20C_Laser_Cannon_POD'] = '激光炮',
    ['J20C_EML_POD'] = '电磁线圈炮'
}


local snd_list = {}
local function initSnd()
    local sndHeadPhonehost = create_sound_host("COCKPIT_SIDEWINDER", "HEADPHONES", 0, 0, 0)
    local sndhost = create_sound_host("COCKPIT", "3D", 0, 0, 0)
    snd_list.sidewinder_high = sndHeadPhonehost:create_sound("Aircrafts/J-20A/Cockpit/TargetLock")
    snd_list.sidewinder_high:update(1,1,1)
    snd_list.sidewinder_low = sndHeadPhonehost:create_sound("Aircrafts/J-20A/Cockpit/TargetTrack")
    snd_list.sidewinder_low:update(1,1,1)
    snd_list.sidewinder_quiet = sndHeadPhonehost:create_sound("Aircrafts/Cockpits/SidewinderLowQuiet")
    snd_list.sidewinder_quiet:update(1,1,1)
    snd_list.msl_launch_in = sndhost:create_sound("Weapons/MissileShootIn")
    snd_list.drop_weapon = sndhost:create_sound("Aircrafts/DropWeaponIn")
    snd_list.flare_snd = sndhost:create_sound("Aircrafts/Cockpits/FlareIn")
    snd_list.chaff_snd = sndhost:create_sound("Weapons/Snare")
end
local t_hdg_h = get_param_handle('HDG_DEG')
local WPT_data = {}
local ATK_WPT_data = {}
local atk_wpt_h = get_param_handle('ATK_WPT')
local maxRange_h = get_param_handle('MAX_RANGE')
local function initWPTs()
    for i = 1, 100, 1 do
        WPT_data[#WPT_data+1] = {
            N_LAT = get_param_handle(string.format('WPT_%02.0f_NEXT_REL_LAT',i)),
            N_LON = get_param_handle(string.format('WPT_%02.0f_NEXT_REL_LON',i)),
            NEXT = get_param_handle(string.format('WPT_%02.0f_NEXT',i)),
            LAT = get_param_handle(string.format('WPT_%02.0f_LAT',i)),
            LON = get_param_handle(string.format('WPT_%02.0f_LON',i)),
            NUM = get_param_handle(string.format('WPT_%02.0f_NUM',i)),
            ALT = get_param_handle(string.format('WPT_%02.0f_ALT',i)),
            ALT_TYPE = get_param_handle(string.format('WPT_%02.0f_ALT_TYPE',i)),
            SPD = get_param_handle(string.format('WPT_%02.0f_SPD',i)),
            TYPE = get_param_handle(string.format('WPT_%02.0f_TYPE',i)),
        }
    end
end

local params_h = {
    CHAFF_QTY = {get_param_handle('CHAFF_QTY'),0},
    FLARE_QTY = {get_param_handle('FLARE_QTY'),0},
    ATK_MODE  = {get_param_handle('ATK_MODE'),0},--0:保险,1:AA,2:AG
    WPN_ROOM_STATUS = {get_param_handle('WPN_ROOM_STATUS'),0},
	PL17_COUNT  = {get_param_handle('PL17_COUNT'),0},
    PL15_COUNT  = {get_param_handle('PL15_COUNT'),0},
    PL12_COUNT  = {get_param_handle('PL12_COUNT'),0},
    PL10E_COUNT = {get_param_handle('PL10E_COUNT'),0},
    LD10_COUNT  = {get_param_handle('LD10_COUNT'),0},
    GBU12_COUNT = {get_param_handle('GBU12_COUNT'),0},
    TARGET_ROUND_DIS_ENABLE = {get_param_handle('TARGET_ROUND_DIS_ENABLE'),0},
    IR_SEEK_RANGE_DIS = {get_param_handle('IR_SEEK_RANGE_DIS'),0},
    TARGET_ROUND_X = {get_param_handle('TARGET_ROUND_X'),0},
    TARGET_ROUND_Y = {get_param_handle('TARGET_ROUND_Y'),0},
    HMD_TARGET_ROUND_DIS_ENABLE = {get_param_handle('HMD_TARGET_ROUND_DIS_ENABLE'),0},
    HMD_TARGET_ROUND_X = {get_param_handle('HMD_TARGET_ROUND_X'),0},
    HMD_TARGET_ROUND_Y = {get_param_handle('HMD_TARGET_ROUND_Y'),0},
    WEAPON_NAME  = {get_param_handle('WEAPON_NAME'),''},
    WEAPON_COUNT = {get_param_handle('WEAPON_COUNT'),0},
    WEAPON_DIS = {get_param_handle('WEAPON_NAME_DIS'),0},
    PYLON_IDX = {get_param_handle('PYLON_IDX'),0},
    CCIP_DIS_ENABLE = {get_param_handle('CCIP_DIS_ENABLE'),0},
    CCIP_Y = {get_param_handle('CCIP_Y'),0},
    CCIP_X = {get_param_handle('CCIP_X'),0},
    CCRP_DIS_ENABLE = {get_param_handle('CCRP_DIS_ENABLE'),0},
    CCRP_TIME = {get_param_handle('CCRP_TIME'),-1},
    CCRP_TIME_MAX_RANGE = {get_param_handle('CCRP_TIME_MAX_RANGE'),-1},
    CCRP_TIME_TO_IMPACT = {get_param_handle('CCRP_TIME_TO_IMPACT'),-1},
    CCRP_Y = {get_param_handle('CCRP_Y'),0},
    CCRP_X = {get_param_handle('CCRP_X'),0},
    ATK_WPT_MAX = {get_param_handle('ATK_WPT_MAX'),0},
    ECM_STATUS = {get_param_handle('ECM_STATUS'),0},
    IR_SEEK_LIMIT = {get_param_handle('IR_SEEK_LIMIT'),0},
    GUN_MODE = {get_param_handle('GUN_MODE'),0},
    GUN_TYPE = {get_param_handle('GUN_TYPE'),0},
    LASER_GUN_CD1 = {get_param_handle('LASER_GUN_CD1'),0,0,update_time_step,0,10},
    LASER_GUN_CD2 = {get_param_handle('LASER_GUN_CD2'),0,0,update_time_step,0,10},
    LASER_GUN_CHARGE = {get_param_handle('LASER_GUN_CHARGE'),0,0,update_time_step,0,3},
    CURRENT_GUN_IDX = {get_param_handle('CURRENT_GUN_IDX'),0},
    LaserCannonAmmo_L = {get_param_handle('LaserCannonAmmo_L'),0},
    LaserCannonAmmo_R = {get_param_handle('LaserCannonAmmo_R'),0},
    GUN_NAME = {get_param_handle('GUN_NAME'),''},
    GUN_CCIP_DIS_ENABLE = {get_param_handle('GUN_CCIP_DIS_ENABLE'),0},
    GUN_CCIP_X = {get_param_handle('GUN_CCIP_X'),0},
    GUN_CCIP_Y = {get_param_handle('GUN_CCIP_Y'),0},
    GUN_COUNT = {get_param_handle('GUN_COUNT'),648}
}

local hmdType_h = get_param_handle('HMD_TYPE')
local head_el = get_param_handle('HEAD_EL')
local head_az = get_param_handle('HEAD_AZ')
local store = 7
if Type then
    store = 11
end
for _i = 0, store, 1 do
    local i = _i + 1
    local k = string.format('MSL_%.0f_COUNT',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_USING',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_SELECTED',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_PL12',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_LD10',i)
    params_h[k] = {get_param_handle(k),0}
	k = string.format('MSL_%.0f_PL17',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_PL15',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_PL10E',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_BOMB',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_AGM65E',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_YJ12',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_YJ83',i)
    params_h[k] = {get_param_handle(k),0}
    k = string.format('MSL_%.0f_GUNPOD',i)
    params_h[k] = {get_param_handle(k),0}
end

local aircraftArgVal = {
    hideMainRoom={525,0,0.05},
    mainDoor={526,0,0.1},
    rightDoor={527,0,0.05},
    leftDoor={528,0,0.05}
}

local pylonData = {}
local groupWeaponId = {
    [1] = {maxType = 0},
    [2] = {maxType = 0}
}
local function updatePylonInfo()
    pylonData = {}
    groupWeaponId[1] = {maxType = 0} -- maxType是用来计数同一个攻击模式下导弹种类数量的
    groupWeaponId[2] = {maxType = 0}
    local gbu12 = 0
    local ld10  = 0
    local pl10e = 0
    local pl12  = 0
    local pl15  = 0
	local pl17  = 0
    gunPodIdx   = {}
    for i = 0, store, 1 do
        local station = weaponSystem:get_station_info(i)
        if station~=nil then
            local wsType = station.weapon
            if not (wsType.level1 == 1 and wsType.level2 == 3 and wsType.level3 == 43) then
                pylonData[i+1] = station
                local clsID = pylonData[i + 1].CLSID
                if clsID == 'DIS_PL-12' then
                    pl12 = pl12 + pylonData[i + 1].count
                elseif clsID == 'DIS_LD-10' then
                    ld10 = ld10 + pylonData[i + 1].count
                elseif clsID == 'DIS_GBU_12' then
                    gbu12 = gbu12 + pylonData[i + 1].count
                elseif clsID == "{PLAAF_PL-10E}" then
                    pl10e = pl10e + pylonData[i + 1].count
				elseif clsID == "{BayArm_PLAAF_PL-10E_x4}" then
                    pl10e = pl10e + pylonData[i + 1].count
                elseif clsID == "{J20A_PL15}" then
                    pl15 = pl15 + pylonData[i + 1].count
				elseif clsID == "{J20_PL-15_DUAL}" then
                    pl15 = pl15 + pylonData[i + 1].count
				elseif clsID == "BayArm_J20_PL-15_DUAL" then
                    pl15 = pl15 + pylonData[i + 1].count
				elseif clsID == "{J20A_PL17}" then
                    pl17 = pl17 + pylonData[i + 1].count
                elseif clsID == "{BayArm_J20_PL-17_x4}" then
                    pl17 = pl17 + pylonData[i + 1].count
                end
                local key = string.format('%.0f%.0f%.0f%.0f', wsType.level1, wsType.level2, wsType.level3, wsType.level4)
                if wsType.level1 == 4 and wsType.level2 == 4 and wsType.level3 == 7 then                    --A2A
                    if type(groupWeaponId[1][key]) == "nil" then
                        groupWeaponId[1][key] = {}
                        groupWeaponId[1][#groupWeaponId[1] + 1] = key
                        groupWeaponId[1].maxType = groupWeaponId[1].maxType + 1
                    end
                    groupWeaponId[1][key][#groupWeaponId[1][key] + 1] = i + 1
                elseif wsType.level1 == 4 and wsType.level2 == 6 and wsType.level3 == 10 then
                    gunPodIdx[#gunPodIdx + 1] = i
                else                    --A2G
                    if type(groupWeaponId[2][key]) == "nil" then
                        groupWeaponId[2][key] = {}
                        groupWeaponId[2][#groupWeaponId[2] + 1] = key
                        groupWeaponId[2].maxType = groupWeaponId[2].maxType + 1
                    end
                    groupWeaponId[2][key][#groupWeaponId[2][key] + 1] = i + 1
                end
            end
        end
    end
    params_h.PL17_COUNT[2] = pl17
	params_h.PL15_COUNT[2] = pl15
    params_h.PL12_COUNT[2] = pl12
    params_h.PL10E_COUNT[2] = pl10e
    params_h.GBU12_COUNT[2] = gbu12
    params_h.LD10_COUNT[2] = ld10
end

local usingPylon = {}
local usingType = 1
local usingPylonIdx = 0
--刷新应当使用的挂架索引
local function updateUsingPylon()
    local attackMode = params_h.ATK_MODE[2]
    if attackMode > 0 then
        local wpnGroup = groupWeaponId[attackMode]
        if params_h.GUN_MODE[2] == 1 and #gunPodIdx>0 then
            if params_h.LASER_GUN_CD1[3] == 0 and weaponSystem:get_station_info(8).count>0 then
                weaponSystem:select_station(8)
                params_h.CURRENT_GUN_IDX[2] = 8
            elseif params_h.LASER_GUN_CD2[3] == 0 and weaponSystem:get_station_info(8).count>0 then
                weaponSystem:select_station(9)
                params_h.CURRENT_GUN_IDX[2] = 9
            else
                params_h.CURRENT_GUN_IDX[2] = -1
            end
        end
        if wpnGroup.maxType>0 then
            local groupPylonIdx = wpnGroup[wpnGroup[usingType]]
            local qty = 0
            local weaponQty = 0
            usingPylonIdx = 0
            for i = 1, #groupPylonIdx, 1 do
                weaponQty = weaponQty + pylonData[groupPylonIdx[i]].count
                if pylonData[groupPylonIdx[i]].count > qty then
                    qty = pylonData[groupPylonIdx[i]].count --计算哪个剩余弹药最多，然后就使用哪个
                    usingPylonIdx = groupPylonIdx[i]
                end
            end
            if usingPylonIdx > 0 then
                if params_h.WPN_ROOM_STATUS[2] == 0 and not weaponLoading then
                    if usingPylonIdx > 0 and usingPylonIdx < 3 then
                        aircraftArgVal.leftDoor[2]  = Limit(aircraftArgVal.leftDoor[2] + aircraftArgVal.leftDoor[3], 0, 1)
                        aircraftArgVal.rightDoor[2] = Limit(aircraftArgVal.rightDoor[2] + aircraftArgVal.rightDoor[3], 0, 1)
                    else
                        aircraftArgVal.leftDoor[2]  = Limit(aircraftArgVal.leftDoor[2] - aircraftArgVal.leftDoor[3], 0, 1)
                        aircraftArgVal.rightDoor[2] = Limit(aircraftArgVal.rightDoor[2] - aircraftArgVal.rightDoor[3], 0, 1)
                    end
                end
                usingPylon = weaponSystem:get_station_info(usingPylonIdx - 1)
                weaponSystem:select_station(usingPylonIdx - 1)
            end
            params_h.WEAPON_NAME[2] = weapon_name[usingPylon.CLSID]
            launchAuthorization = params_h.WEAPON_NAME[2] ~= nil
            params_h.WEAPON_COUNT[2] = weaponQty
            params_h.PYLON_IDX[2] = usingPylonIdx
        else

        end
    elseif params_h.WPN_ROOM_STATUS[2] == 0 and not weaponLoading then
        usingPylonIdx = 0
        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]-aircraftArgVal.mainDoor[3],0,1)
        aircraftArgVal.leftDoor[2]=Limit(aircraftArgVal.leftDoor[2]-aircraftArgVal.leftDoor[3],0,1)
        aircraftArgVal.rightDoor[2]=Limit(aircraftArgVal.rightDoor[2]-aircraftArgVal.rightDoor[3],0,1)
    end
end
local function updateAircraftArgument()
    for k, v in pairs(aircraftArgVal) do
        set_aircraft_draw_argument_value(v[1],v[2])
    end
end

local fireHold = 0
local trgDn = false
local isFire = false
local function launchWpn()
    local attackMode = params_h.ATK_MODE[2]
    if attackMode > 0 then
        if trgDn then
            fireHold=fireHold+update_time_step
        else
            fireHold = 0
        end
        if usingPylon.CLSID~=nil then
            if usingPylon.weapon.level1 == 4 and usingPylon.weapon.level2 == 4  then
                --导弹类
                if params_h.WPN_ROOM_STATUS[2] == 0 and not weaponLoading then
                    if usingPylonIdx > 2 and usingPylonIdx < 9 and fireHold > 0 then
                        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]+aircraftArgVal.mainDoor[3],0,1)
                    else
                        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]-aircraftArgVal.mainDoor[3],0,1)
                    end
                end
                if fireHold > 1 and not isFire and launchAuthorization then
					weaponSystem:launch_station(usingPylonIdx-1)
                    isFire = true
                end
            elseif (usingPylon.weapon.level1 == 4 and usingPylon.weapon.level2 == 7 and usingPylon.weapon.level3 == 33)--火箭弹
            or (usingPylon.weapon.level1 == 4 and usingPylon.weapon.level2 == 5) then--炸弹
                if params_h.WPN_ROOM_STATUS[2] == 0 and not weaponLoading then
                    if usingPylonIdx > 2 and usingPylonIdx < 9 and fireHold > 0 then
                        --DebugPrint(weaponSystem:get_station_info(usingPylonIdx-1).weapon.level4)
                        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]+aircraftArgVal.mainDoor[3],0,1)
                    else
                        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]-aircraftArgVal.mainDoor[3],0,1)
                    end
                end
                if ccrp_status then
                    if params_h.CCRP_TIME[2] <= 0.05 and fireHold > 0.25 and launchAuthorization then
                        if usingPylon.CLSID == 'DIS_GBU_12' then
                            if isFire == false then
                                weaponSystem:launch_station(usingPylonIdx-1)
                                isFire = true
                            end
                        else
                            weaponSystem:launch_station(usingPylonIdx-1)
                        end
                    end
                else
                    if fireHold > 0.25 and launchAuthorization then
                        if usingPylon.CLSID == 'DIS_GBU_12' then
                            if isFire == false then
                                weaponSystem:launch_station(usingPylonIdx-1)
                                isFire = true
                            end
                        else
                            weaponSystem:launch_station(usingPylonIdx-1)
                        end
                    end
                end
            end
        end
    end
end

local function updateAntiMslInfo()
    params_h.CHAFF_QTY[2] = weaponSystem:get_chaff_count()
    params_h.FLARE_QTY[2] = weaponSystem:get_flare_count()
end

local function updateWPNPageInfo()
    --更新选择与未选择
    if params_h.ATK_MODE[2]>0 then
        local attackMode = params_h.ATK_MODE[2]
        local wpnGroup = groupWeaponId[attackMode]
        local groupPylonIdx = wpnGroup[wpnGroup[usingType]]--当前所选择的武器种类可用的挂架索引集(挂架索引从1开始)
        for k, v in pairs(pylonData) do
            local key = string.format('MSL_%.0f_SELECTED',k)
            local idx = GetIndexOfValInTbl(groupPylonIdx,k)
            if type(idx)~="nil" then
                params_h[key][2] = 1
            else
                params_h[key][2] = 0
            end
        end
    else
        for i = 1, 8, 1 do
            local k = string.format('MSL_%.0f_SELECTED',i)
            params_h[k][2]=0
        end
    end
    --更新武器是否存在以及武器种类以及是否正在使用
    for k, v in pairs(pylonData) do
        local key = string.format('MSL_%.0f_COUNT',k)
        params_h[key][2] = v.count
        key = string.format('MSL_%.0f_USING',k)
        if k == usingPylonIdx then
            params_h[key][2] = 1
        else
            params_h[key][2] = 0
        end
        local pl12Key = string.format('MSL_%.0f_PL12',k)
        local ld10Key = string.format('MSL_%.0f_LD10',k)
        local pl15Key = string.format('MSL_%.0f_PL15',k)
		local pl17Key = string.format('MSL_%.0f_PL17',k)
        local pl10eKey = string.format('MSL_%.0f_PL10E',k)
        local bombKey = string.format('MSL_%.0f_BOMB',k)
        local agm65eKey = string.format('MSL_%.0f_AGM65E',k)
        local yj83Key = string.format('MSL_%.0f_YJ83',k)
        local yj12Key = string.format('MSL_%.0f_YJ12',k)
        local gunKey = string.format('MSL_%.0f_GUNPOD',k)
        if v.CLSID == "DIS_PL-12" then
            params_h[pl12Key][2] = 1
            params_h[ld10Key][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif (v.CLSID == "{J20A_PL15}" or v.CLSID == 'J20_PL-15_DUAL' or v.CLSID == 'BayArm_J20_PL-15_DUAL') then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[pl15Key][2] = 1
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
		elseif (v.CLSID == "{J20A_PL17}" or v.CLSID == "{BayArm_J20_PL-17_x4}") then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 1
            params_h[pl10eKey][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif (v.CLSID == "{PLAAF_PL-10E}" or v.CLSID == "{BayArm_PLAAF_PL-10E_x4}") then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 1
            params_h[agm65eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif v.CLSID == "DIS_LD-10" then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 1
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif v.CLSID == "J_20A_AGM-65E" then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[agm65eKey][2] = 1
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif v.CLSID == 'DIS_DF4B_YJ12' then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 1
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        elseif v.CLSID == 'DIS_GDJ_YJ83K' then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 1
            params_h[gunKey][2] = 0
        elseif v.CLSID == 'J20C_Laser_Cannon_POD' or v.CLSID == 'J20C_EML_POD' then
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[bombKey][2] = 0
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 1
        elseif v.weapon.level1 == 4 and v.weapon.level2 == 5 then            --炸弹
            params_h[pl12Key][2] = 0
            params_h[ld10Key][2] = 0
            params_h[pl15Key][2] = 0
			params_h[pl17Key][2] = 0
            params_h[pl10eKey][2] = 0
            params_h[agm65eKey][2] = 0
            params_h[bombKey][2] = 1
            params_h[yj12Key][2] = 0
            params_h[yj83Key][2] = 0
            params_h[gunKey][2] = 0
        end
    end
end
local function updateIrMissileSeek()
    ir_seek_az=ir_seek_az+1
    if ir_seek_az > ir_seek_az_limit[2] then
        ir_seek_el = ir_seek_el + 1
        ir_seek_az = ir_seek_az_limit[1]
        if ir_seek_el > ir_seek_el_limit[2] then
            ir_seek_el = ir_seek_el_limit[1]
        end
    end
end
local hud_dis 			= get_param_handle('HUD_BRT')
local radarMode 		= get_param_handle('RADAR_MODE')
local stt_azimuth_h 	= get_param_handle("RADAR_STT_AZIMUTH")
local stt_elevation_h 	= get_param_handle("RADAR_STT_ELEVATION")
local stt_range_h 		= get_param_handle("RADAR_STT_RANGE")
local function update_ir_msl_status()
    if math.abs(head_az:get())>30 or math.abs(head_el:get())>30 then
        params_h.IR_SEEK_LIMIT[2] = 1
    else
        params_h.IR_SEEK_LIMIT[2] = 0
    end
    if ((usingPylonIdx == 1 or usingPylonIdx == 2) and (pylonData[usingPylonIdx].CLSID == '{PLAAF_PL-10E}' or pylonData[usingPylonIdx].CLSID == '{BayArm_PLAAF_PL-10E_x4}')) then
        if ir_selected == 0 then
            dispatch_action(devices.RADAR_RAW,Keys.setRadarStable,0)
            ir_selected = 1
        end
        params_h.IR_SEEK_RANGE_DIS[2] = 1
        if pylonData[usingPylonIdx].count > 0 then
            if ir_missile_lock_param:get() == 1 then
                params_h.IR_SEEK_RANGE_DIS[2] = 0
                params_h.TARGET_ROUND_DIS_ENABLE[2] = hud_dis:get()
                if snd_list.sidewinder_quiet:is_playing() then
                    snd_list.sidewinder_quiet:stop()
                end
                if snd_list.sidewinder_low:is_playing() then
                    snd_list.sidewinder_low:stop()
                end
                local temp_ir_az = ir_missile_az_param:get()
                local temp_ir_el = ir_missile_el_param:get()
                params_h.TARGET_ROUND_X[2] = math.tan(temp_ir_az) * HUD_distance
                params_h.TARGET_ROUND_Y[2] = math.tan(temp_ir_el) * HUD_distance
                --HMD
                params_h.HMD_TARGET_ROUND_X[2] = math.tan(temp_ir_az-math.rad(-head_az:get()))
                params_h.HMD_TARGET_ROUND_Y[2] = math.tan(temp_ir_el-math.rad(head_el:get()))
                ir_missile_des_az_param:set(temp_ir_az)
                ir_missile_des_el_param:set(temp_ir_el)
                if not snd_list.sidewinder_high:is_playing() then
                    snd_list.sidewinder_high:play_continue()
                end
            else
                ir_seek_step_time = ir_seek_step_time + update_time_step
                if ir_seek_step_time> ir_seek_scan_speed and radarMode:get() ~= 3 then
                    updateIrMissileSeek()
                    ir_seek_step_time = 0
                end
                params_h.TARGET_ROUND_DIS_ENABLE[2] = 1
                params_h.HMD_TARGET_ROUND_DIS_ENABLE[2] = 0
                params_h.TARGET_ROUND_X[2] = 0
                params_h.TARGET_ROUND_X[2] = 0
                if radarMode:get() == 3 then
                    ir_seek_az=math.deg(stt_azimuth_h:get())
                    ir_seek_el=math.deg(stt_elevation_h:get())
                    ir_seek_el_offset = 0
                    ir_seek_az_offset = 0
                elseif hmdType_h:get() == 0 and (math.abs(head_az:get())>7 or math.abs(head_el:get())>7) then
                    --头盔瞄准
                    ir_seek_el_offset = math.rad(head_el:get())
                    ir_seek_az_offset = math.rad(head_az:get())
                else
                    ir_seek_el_offset = 0
                    ir_seek_az_offset = 0
                end
                ir_missile_des_el_param:set(ir_seek_el_offset+math.rad(ir_seek_el))
                ir_missile_des_az_param:set(ir_seek_az_offset+math.rad(ir_seek_az))
                if snd_list.sidewinder_high:is_playing() then
                    snd_list.sidewinder_high:stop()
                end
                if not snd_list.sidewinder_low:is_playing() then
                    snd_list.sidewinder_low:play_continue()
                end
            end
        else
            if snd_list.sidewinder_high:is_playing() then
                snd_list.sidewinder_high:stop()
            end
            if snd_list.sidewinder_quiet:is_playing() then
                snd_list.sidewinder_quiet:stop()
            end
            if snd_list.sidewinder_low:is_playing() then
                snd_list.sidewinder_low:stop()
            end
            ir_missile_des_az_param:set(0)
            ir_missile_des_el_param:set(0)
            params_h.TARGET_ROUND_DIS_ENABLE[2] = 0
            params_h.HMD_TARGET_ROUND_DIS_ENABLE[2] = 0
            params_h.TARGET_ROUND_X[2] = 0
            params_h.TARGET_ROUND_Y[2] = 0
        end
    else
        if ir_selected == 1 then
            dispatch_action(devices.RADAR_RAW,Keys.setRadarStable,1)
            ir_selected = 0
        end
        params_h.IR_SEEK_RANGE_DIS[2] = 0
        if snd_list.sidewinder_high:is_playing() then
            snd_list.sidewinder_high:stop()
        end
        if snd_list.sidewinder_quiet:is_playing() then
            snd_list.sidewinder_quiet:stop()
        end
        if snd_list.sidewinder_low:is_playing() then
            snd_list.sidewinder_low:stop()
        end
        ir_missile_des_az_param:set(0)
        ir_missile_des_el_param:set(0)
        params_h.TARGET_ROUND_DIS_ENABLE[2] = 0
        params_h.TARGET_ROUND_X[2] = 0
        params_h.TARGET_ROUND_Y[2] = 0
    end
end
local Ralt_last = 1600
local Balt_last = 1600

local function updateCCIP()
    if usingPylon==nil or usingPylonIdx<=0 or params_h.CCRP_DIS_ENABLE[2]==1 then
        params_h.CCIP_DIS_ENABLE[2] = 0
        params_h.CCIP_Y[2] = 0
        params_h.CCIP_X[2] = 0
        do return end
    end
    local x, y, z = sensor_data.getSelfCoordinates()
    local Vx0, Vy0, Vz0 = sensor_data.getSelfVelocity()
    local p_roll = BASE_SENSOR.ROLL:get()
    local p_pitch = BASE_SENSOR.PITCH:get()
    local Ralt = BASE_SENSOR.RADALT:get()
    local Balt = BASE_SENSOR.BAROALT:get()
    if Ralt < 1600 then
        Ralt_last = Ralt
        Balt_last = Balt
    end
    local h0 = y - (Ralt_last + Balt - Balt_last) * math.cos(math.abs(p_pitch)) * math.cos(math.abs(p_roll))
    local valid, az, el, travel_dist = 0,0,0,0
    if USE_EXT_DLL and Type then
    	set_target_level(h0)
		valid, az, el, travel_dist = Calculate()
	elseif type(avSimplestWeaponSystem)~='nil' then
        avSimplestWeaponSystem.set_target_level(h0)
        valid, az, el, travel_dist = avSimplestWeaponSystem.Calculate()
	end
    if usingPylon.weapon.level1 == 4 and usingPylon.weapon.level2 == 5 then
        params_h.CCIP_DIS_ENABLE[2] = 1
        params_h.CCIP_Y[2] = math.tan(el)*HUD_distance
        params_h.CCIP_X[2] = math.tan(az)*HUD_distance
    else
        params_h.CCIP_DIS_ENABLE[2] = 0
        params_h.CCIP_Y[2] = 0
        params_h.CCIP_X[2] = 0
    end
end
--from A-29B
local function calculate_ccip_max_range(h0)
    local fly_time, Vx0, Vy0, Vz0, g
    local pitch = sensor_data.getPitch()
    g = -9.82 -- m/s2

    Vx0, Vy0, Vz0 = sensor_data.getSelfVelocity()
    local vel_temp = math.sqrt(Vx0^2 + Vy0^2 + Vz0^2)
    Vy0 = vel_temp / math.sqrt(2)

    local delta = Vy0^2 - 2 * g * (math.abs(h0))
    fly_time = (-Vy0  - math.sqrt(delta))/g                -- time to impact

    local Vx = Vy0                                  -- horizontal weapon velocity
    local Sx = Vx * fly_time                               -- horizontal distance travelled by weapon
    return Sx, fly_time, h0
end
local flir_tgt = {
    LAT = get_param_handle('FLIR_TGT_LAT'),
    LON = get_param_handle('FLIR_TGT_LON'),
    ALT = get_param_handle('FLIR_TGT_ALT'),
    Mode = get_param_handle('FLIR_MODE'),
}
local function update_ccrp()
    local atk_idx = atk_wpt_h:get()
    if params_h.ATK_MODE[2]==2 and (usingPylonIdx==5 or usingPylonIdx==6) and pylonData[usingPylonIdx]~=nil and GetTableLength(pylonData[usingPylonIdx])>0 then
        if #ATK_WPT_data<1 or atk_idx < 1 then
            if flir_tgt.Mode:get()~=3 then
                --无效攻击点
                params_h.CCRP_TIME[2]=-1
                params_h.CCRP_DIS_ENABLE[2]=0
                ccrp_status = false
                do return end
            end
        end
        local maxRange = maxRange_h:get()
        local x, y, z = sensor_data.getSelfCoordinates()
        local dx
        local dy
        local dz
        if flir_tgt.Mode:get()==3 then
            dx = flir_tgt.LAT:get() - x
            dy = flir_tgt.ALT:get() - y
            dz = flir_tgt.LON:get() - z
        else
            dx = ATK_WPT_data[atk_idx].LAT:get()*(maxRange/40) - x
            dy = ATK_WPT_data[atk_idx].ALT:get() - y
            dz = ATK_WPT_data[atk_idx].LON:get()*(maxRange/40) - z
        end

        local max_range = calculate_ccip_max_range(dy)

        local valid, az, el, travel_dist = 0, 0, 0, 0
        if USE_EXT_DLL and Type then
        	valid, az, el, travel_dist = Calculate()
		elseif type(avSimplestWeaponSystem) ~= 'nil' then
            valid, az, el, travel_dist = avSimplestWeaponSystem.Calculate()
		end
        local vx, vy, vz = sensor_data.getSelfVelocity()
        local gs = math.sqrt(vx*vx + vz*vz)
        local fly_time=travel_dist/gs

        local target_dist = math.sqrt(dx * dx + dy * dy +  dz * dz)
        local target_horiz_dist = math.sqrt(dx * dx +  dz * dz)

        local ccrp_dif = target_dist - travel_dist
        local ccrp_time = 0
        if ccrp_dif >= 0 then
            ccrp_time = ccrp_dif / gs
        end
        local ccrp_az = math.atan2(dz,dx)
        if ccrp_az<0 then
			ccrp_az=ccrp_az+math.rad(360)
		end
        ccrp_az = Limit(ccrp_az - math.rad(t_hdg_h:get()),-HUD_AZ,HUD_AZ)
        local time_to_max_range = (target_horiz_dist - max_range) / gs
        params_h.CCRP_TIME[2]=ccrp_time
        params_h.CCRP_TIME_MAX_RANGE[2]=time_to_max_range
        params_h.CCRP_TIME_TO_IMPACT[2]=fly_time
        params_h.CCRP_X[2]=math.tan(ccrp_az)*HUD_distance
        params_h.CCRP_Y[2]=math.tan(el)*HUD_distance
        params_h.CCRP_DIS_ENABLE[2]=1
        ccrp_status = true
    else
        params_h.CCRP_TIME[2]=-1
        params_h.CCRP_DIS_ENABLE[2]=0
        ccrp_status = false
    end
end

local function updateATK_wpts()
    ATK_WPT_data = {}
    for i = 1, 100, 1 do
        if WPT_data[i].TYPE:get()==2 then
            ATK_WPT_data[#ATK_WPT_data+1] = WPT_data[i]
        end
    end
    params_h.ATK_WPT_MAX[2] = #ATK_WPT_data
end

local function smokeOnOff(i)
    local station = weaponSystem:get_station_info(i)
    if station~=nil then
        weaponSystem:select_station(i)
        weaponSystem:launch_station(i)
    end
end

local function updateGunFire()
    if params_h.GUN_MODE[2] == 1 and gunFire == 1 then
        if params_h.GUN_TYPE[2] == 1 then
            if params_h.LASER_GUN_CHARGE[3] > 2 and not isFire and launchAuthorization then
                --蓄力完成，可以发射
                if params_h.LASER_GUN_CD1[3] == 0 and params_h.CURRENT_GUN_IDX[2] >= 0 then
                    weaponSystem:launch_station(params_h.CURRENT_GUN_IDX[2])
                    dispatch_action(nil,SND_cmd.LaserFire,1)
                    params_h.LASER_GUN_CD1[3] = 10--左激光炮进入冷却CD
                elseif params_h.LASER_GUN_CD1[3] > 0 and params_h.LASER_GUN_CD2[3] == 0 and params_h.CURRENT_GUN_IDX[2] >= 0 then
                    weaponSystem:launch_station(params_h.CURRENT_GUN_IDX[2])
                    dispatch_action(nil,SND_cmd.LaserFire,1)
                    params_h.LASER_GUN_CD2[3] = 10--右激光炮进入冷却CD
                end
                isFire = true
                params_h.LASER_GUN_CHARGE[2] = 0
                params_h.LASER_GUN_CHARGE[3] = 0
            elseif not isFire then
                if params_h.LASER_GUN_CHARGE[2] == 0 and (params_h.LASER_GUN_CD1[3] == 0 or params_h.LASER_GUN_CD2[3] == 0) then
                    params_h.LASER_GUN_CHARGE[2] = 2.1
                end
            end
        elseif params_h.GUN_TYPE[2] == 0 then
            gunFireTime= gunFireTime + update_time_step
            if gunFireTime < 12.96 then
                params_h.GUN_COUNT[2] = Limit(params_h.GUN_COUNT[2] - 1,0,648)
            end
            if params_h.GUN_COUNT[2] == 0 and unlimited_weapons then
                params_h.GUN_COUNT[2] = 648
            end
        end
    else
        gunFire = 0
        gunFireTime = 0
    end
    if #gunPodIdx>0 then
        local gunStation = weaponSystem:get_station_info(8)
        if gunStation then
            if gunStation.CLSID == 'J20C_Laser_Cannon_POD' then
                params_h.LaserCannonAmmo_L[2] = math.floor(gunStation.count/600)
            else
                params_h.LaserCannonAmmo_L[2] = gunStation.count
            end
        else
            params_h.LaserCannonAmmo_L[2] = 0
        end
        gunStation = weaponSystem:get_station_info(9)
        if gunStation then
            if gunStation.CLSID == 'J20C_Laser_Cannon_POD' then
                params_h.LaserCannonAmmo_R[2] = math.floor(gunStation.count/600)
            else
                params_h.LaserCannonAmmo_R[2] = gunStation.count
            end
        else
            params_h.LaserCannonAmmo_R[2] = 0
        end
    end
end

local function updateTarget()
    if radarMode:get()==3 then
        weaponSystem:set_target_range(stt_range_h:get())
    else
        weaponSystem:set_target_range(1000)
    end
end

local function update_cannon_track()
    if params_h.GUN_MODE[2] == 1 and params_h.GUN_TYPE[2] == 0 then
        params_h.GUN_CCIP_DIS_ENABLE[2] = 1
        params_h.GUN_CCIP_X[2] = math.tan(gun_piper_az_param:get())*HUD_distance
        params_h.GUN_CCIP_Y[2] = math.tan(gun_piper_el_param:get())*HUD_distance
    else
        params_h.GUN_CCIP_DIS_ENABLE[2] = 0
        params_h.GUN_CCIP_X[2] = 0
        params_h.GUN_CCIP_Y[2] = 0
    end
    if params_h.GUN_TYPE[2] == 0 then
        params_h.GUN_NAME[2] = '内置机炮'
    else
        if weaponSystem:get_station_info(gunPodIdx[1]).CLSID == 'J20C_Laser_Cannon_POD' then
            params_h.GUN_NAME[2] = '激光炮'
        elseif weaponSystem:get_station_info(gunPodIdx[1]).CLSID == 'J20C_EML_POD' then
            params_h.GUN_NAME[2] = '电磁炮'
        end
    end
end

local function emergJettion(stationIdx)
    local station = weaponSystem:get_station_info(stationIdx)
    if station then
        weaponSystem:emergency_jettison(stationIdx)
        if not station.container then
            if stationIdx == 8 then
                set_aircraft_draw_argument_value(210,0)
            elseif stationIdx == 9 then
                set_aircraft_draw_argument_value(211,0)
            elseif stationIdx == 10 then
                set_aircraft_draw_argument_value(212,0)
            elseif stationIdx == 11 then
                set_aircraft_draw_argument_value(213,0)
            end
        end
    end
end

function post_initialize()
	if not USE_EXT_DLL and Type and type(avSimplestWeaponSystem)~='nil' then
        avSimplestWeaponSystem.Setup()
	--	print_message_to_user("avSimplestWeaponSystem Setup")
	end
    initSnd()
    initWPTs()
    unlimited_weapons = LockOn_Options.flight.unlimited_weapons
end

function SetCommand(command,value)
--	print_message_to_user("Weapon:command "..tostring(command).." = "..tostring(value))
    if (command == Keys.WeaponSelectNext) then
        if params_h.GUN_MODE[2] == 1 and #gunPodIdx > 0 then
            params_h.GUN_TYPE[2] = 1 - params_h.GUN_TYPE[2] --切换内置机炮和外挂机炮
        elseif params_h.ATK_MODE[2]>0 then
            usingType = usingType + 1
            if usingType > groupWeaponId[params_h.ATK_MODE[2]].maxType then
                usingType = 1
            end
        end
    elseif (command == Keys.WeaponLaunch and master_Arm == 1) then
        if params_h.GUN_MODE[2] == 1 then
            gunFire = value
            if params_h.GUN_TYPE[2] == 0 then
                dispatch_action(nil,Keys.PlaneFire,1)
            end
        else
            if value==1 then
                trgDn = true
            end
        end
        if value == 0 then
            trgDn = false
            dispatch_action(nil,Keys.PlaneFireOff,1)
            isFire = false
        end
    elseif (command == Keys.DropChaff) then
        weaponSystem:drop_chaff()
    elseif (command == Keys.DropFlare) then
        weaponSystem:drop_flare()
    elseif (command == Keys.DropChaffAndFlare) then
        weaponSystem:drop_flare()
        weaponSystem:drop_chaff()
    elseif (command == Keys.masterArm) then
        weaponSystem:performClickableAction(click_cmd.masterArm,1-master_Arm)
	elseif (command == Keys.PlaneAHCPMasterArm) then
		weaponSystem:performClickableAction(click_cmd.masterArm,1)
		master_Arm = 1
	elseif (command == Keys.PlaneAHCPMasterSafe) then
		weaponSystem:performClickableAction(click_cmd.masterArm,0)
		master_Arm = 0
	elseif command == MFD_click_cmd.WPN_AAMODE then
        if params_h.ATK_MODE[2] == 1 then
            params_h.ATK_MODE[2] = 0
            dispatch_action(devices.MFCD,Keys.P2_to_fcsPage)
            params_h.GUN_MODE[2] = 0
            params_h.GUN_TYPE[2] = 0
        else
            params_h.ATK_MODE[2] = 1
            dispatch_action(devices.MFCD,Keys.P2_to_radarPage)
            usingType = 1
        end
        dispatch_action(devices.RADAR_RAW,Keys.STICK_SENSOR_CONTROL_RIGHT,1)
    elseif command == MFD_click_cmd.WPN_AGMODE then
        if params_h.ATK_MODE[2] == 2 then
            params_h.ATK_MODE[2] = 0
            dispatch_action(devices.MFCD,Keys.P2_to_fcsPage)
            params_h.GUN_MODE[2] = 0
            params_h.GUN_TYPE[2] = 0
        else
            params_h.ATK_MODE[2] = 2
            dispatch_action(devices.MFCD,Keys.P2_to_flirPage)
            usingType = 1
        end
    elseif command == MFD_click_cmd.WPN_DOOR_ON then
        params_h.WPN_ROOM_STATUS[2] = 1
    elseif command == MFD_click_cmd.WPN_DOOR_AUTO then
        params_h.WPN_ROOM_STATUS[2] = 0
    elseif command == click_cmd.masterArm then
        master_Arm = value
    elseif command == Keys.A2A then
        weaponSystem:performClickableAction(MFD_click_cmd.WPN_AAMODE,1)
    elseif command == Keys.A2G then
        weaponSystem:performClickableAction(MFD_click_cmd.WPN_AGMODE,1)
    elseif command == Keys.ActiveJamming then
        params_h.ECM_STATUS[2] = 1 - params_h.ECM_STATUS[2]
    elseif command == Keys.PlaneWingtipSmokeOnOff then
        smokeOnOff(9)
        smokeOnOff(10)
    elseif command == Keys.GunMode and params_h.ATK_MODE[2] > 0 then
        params_h.GUN_MODE[2] = 1 - params_h.GUN_MODE[2]
    elseif command == Keys.EmergJettion and get_elec_primary_ac_ok() then
        if aircraftArgVal.leftDoor[2]>0.99 and params_h.WPN_ROOM_STATUS[2] == 1 then
            emergJettion(0)
        end
        if aircraftArgVal.rightDoor[2]>0.99 and params_h.WPN_ROOM_STATUS[2] == 1 then
            emergJettion(1)
        end
        if aircraftArgVal.mainDoor[2]>0.99 and params_h.WPN_ROOM_STATUS[2] == 1 then
            emergJettion(2)
            emergJettion(3)
            emergJettion(4)
            emergJettion(5)
            emergJettion(6)
            emergJettion(7)
        end
        if Type then
            emergJettion(8)--Left In
            emergJettion(9)--Right In
            emergJettion(10)--Left Out
            emergJettion(11)--Right Out
        end
    end
end

function update()
    if usingPylonIdx > 0 then
        params_h.WEAPON_DIS[2] = 1
    else
        params_h.WEAPON_DIS[2] = 0
    end

    if get_elec_primary_ac_ok() then
        updatePylonInfo()
        updateUsingPylon()
        updateAntiMslInfo()
        updateWPNPageInfo()
        launchWpn()
        update_ir_msl_status()
        updateCCIP()
        update_ccrp()
        updateATK_wpts()
        updateGunFire()
        update_cannon_track()
        updateTarget()
        if params_h.ECM_STATUS[2] == 1 and not weaponSystem:get_ECM_status() then
            weaponSystem:set_ECM_status(true)
        elseif params_h.ECM_STATUS[2] == 0 and weaponSystem:get_ECM_status() then
            weaponSystem:set_ECM_status(false)
        end
    else
        if weaponSystem:get_ECM_status() then
            weaponSystem:set_ECM_status(false)
            params_h.ECM_STATUS[2] = 0
        end
    end

    if weaponLoading then
        if loadStationIdx == 1 then
            --EOTS安装完成
            aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]+0.02,0,1)
        elseif loadStationIdx == 7 then
            --主弹舱装弹完成
            aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]-0.02,0,1)
            aircraftArgVal.leftDoor[2]=Limit(aircraftArgVal.leftDoor[2]+0.02,0,1)
        elseif loadStationIdx == 8 then
            --左侧弹仓装弹完成
            aircraftArgVal.leftDoor[2]=Limit(aircraftArgVal.leftDoor[2]-0.02,0,1)
            aircraftArgVal.rightDoor[2]=Limit(aircraftArgVal.rightDoor[2]+0.02,0,1)
        elseif loadStationIdx == 9 then
            --右侧弹仓装弹完成
            aircraftArgVal.rightDoor[2]=Limit(aircraftArgVal.rightDoor[2]-0.02,0,1)
        end
    elseif params_h.WPN_ROOM_STATUS[2]==1 then
        --强制开启所有弹仓
        aircraftArgVal.mainDoor[2]=Limit(aircraftArgVal.mainDoor[2]+aircraftArgVal.mainDoor[3],0,1)
        aircraftArgVal.leftDoor[2]=Limit(aircraftArgVal.leftDoor[2]+aircraftArgVal.leftDoor[3],0,1)
        aircraftArgVal.rightDoor[2]=Limit(aircraftArgVal.rightDoor[2]+aircraftArgVal.rightDoor[3],0,1)
    end
    updateAircraftArgument()
    for k, v in pairs(params_h) do
        if type(v[3])~="nil" then
            local min = v[5] or 0
            local max = v[6] or 1
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],min,max)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],min,max)
            end
            v[1]:set(v[3])
        else
            v[1]:set(v[2])
        end
    end
end

function CockpitEvent(event,value)
    if event == CptEvntNames.initChaffFlarePayload then
        params_h.GUN_COUNT[2] = 648
        weaponLoading = true
    elseif event == CptEvntNames.weaponRearmFirstStep then
        loadStationIdx = 0
    elseif event == CptEvntNames.weaponRearmSingleStepComplete then
        loadStationIdx = loadStationIdx +1
    elseif event == CptEvntNames.weaponRearmComplete then
        loadStationIdx = -1
        weaponLoading = false
    end
end

need_to_be_closed = false