dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")

local gettext = require("i_18n")
_ = gettext.translate

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local cheat = GetSelf()
cheat:listen_command(Keys.autoStart)
cheat:listen_command(Keys.autoStop)
cheat:listen_command(Keys.ShowParamList)

local sensor_data = get_base_data()

local time = 0
local video_time = -1
local status = false --false未启动,true已启动
local action = 0 --0中立，1启动，-1关机
local ShowParamList = false
local autoStart_BGM
local stopBGM_delay = -1
local bgm_gain = 1

local CHN_LOADING_TIME = get_param_handle('CHN_LOADING_TIME')
local LOADING_DISPLAY = get_param_handle('LOADING_DISPLAY')

local apuRPM_handle = get_param_handle('APU_RPM')
function post_initialize()
    local birth = LockOn_Options.init_conditions.birth_place
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then
        status = true
    elseif birth=="GROUND_COLD" then
        status = false
    end
end

function SetCommand(command,value)
    if command == Keys.ShowParamList then
        ShowParamList = not ShowParamList
        show_param_handles_list(ShowParamList)
    end
end

local function interactive(elementName,cmd,device,val)
    local text = ''
    if action == 1 then
        text = '开启'
        dispatch_action(device,cmd,val)
    elseif action == -1 then
        text = '关闭'
        dispatch_action(device,cmd,0)
    end
    print_message_to_user(elementName..'-'..text)
end

local function click(msg,cmd,val)
    local text = ''
    if action == 1 then
        cheat:performClickableAction(cmd,val,false)
    elseif action == -1 then
        cheat:performClickableAction(cmd,val,false)
    end
    print_message_to_user(msg)
end

local function get_cockpit_arg_val(arg)
    return get_cockpit_draw_argument_value(arg)
end

local function autoStart()
    local apuRPM = apuRPM_handle:get()
    if get_cockpit_arg_val(10) == 0 then
        click(_("Open Battery"),click_cmd.Battery,1)
    elseif get_cockpit_arg_val(11) == 0 then
        click(_("Open Left AC Generator"),click_cmd.LeftAcGenerator,1)
    elseif get_cockpit_arg_val(12) == 0 then
        click(_("Open Right AC Generator"),click_cmd.RightAcGenerator,1)
    elseif get_cockpit_arg_val(14) == 0 then
        click(_('Startor Select To APU'),click_cmd.StartorSwitch,0.25)
    elseif get_cockpit_arg_val(14) == 0.25 then
        click(_('Press Start Button'),click_cmd.EngineStart_DN,1)
        cheat:performClickableAction(click_cmd.EngineStart_UP,0)
        print_message_to_user(_('Wait APU Started'))
    elseif get_cockpit_arg_val(38) >0.899 then
        interactive(_('Canopy'),Keys.PlaneFonar,devices.CANOPY,0)
    elseif get_cockpit_arg_val(14) == 0.25 and apuRPM > 99 then
        click(_('Startor Select To Left Engine'),click_cmd.StartorSwitch,0.5)
    elseif get_cockpit_arg_val(14) == 0.5 then
        click(_('Press Start Button'),click_cmd.EngineStart_DN,1)
        cheat:performClickableAction(click_cmd.EngineStart_UP,0)
        print_message_to_user(_('Wait Left Engine Started'))
    elseif get_cockpit_arg_val(14) == 0.5 and sensor_data.getEngineLeftRPM() > 45 then
        click(_('Startor Select To Right Engine'),click_cmd.StartorSwitch,0.75)
    elseif get_cockpit_arg_val(14) == 0.75 then
        click(_('Press Start Button'),click_cmd.EngineStart_DN,1)
        cheat:performClickableAction(click_cmd.EngineStart_UP,0)
    elseif get_cockpit_arg_val(175) == 0 then
        click(_('Adjust UFCP Brightness'),click_cmd.UFCPBrt,1)
    elseif get_cockpit_arg_val(176) == 0 then
        click(_('Adjust HUD Brightness'),click_cmd.hudBrt,1)
    elseif get_cockpit_arg_val(14) == 0.75 and sensor_data.getEngineRightRPM() > 43 then
        click(_('Startor Select To APU'),click_cmd.StartorSwitch,0.25)
    elseif get_cockpit_arg_val(14) == 0.25 and sensor_data.getEngineLeftRPM() > 43 and sensor_data.getEngineRightRPM() > 43 then
        click(_('Press The Start Button To Stop The APU From Running'),click_cmd.EngineStart_DN,1)
        cheat:performClickableAction(click_cmd.EngineStart_UP,0)
        print_message_to_user(_('end of autostart'),3)
        action = 0
    end
end

local function autoStop()

end

function update()
    time = time + update_time_step
    if time > 0.6 then
        if action == 1 then
            -- LOADING_DISPLAY:set(1)
            -- if not autoStart_BGM:is_playing() then
            --     autoStart_BGM:play_continue()
            -- end
            autoStart()
        elseif action == -1 then
            autoStop()
        end
        time = 0
    end
    -- if action == 0 and stopBGM_delay > 0 then
    --     stopBGM_delay = stopBGM_delay - update_time_step
    -- elseif action == 0 and stopBGM_delay ~= -1 then
    --     stopBGM_delay = -1
    --     autoStart_BGM:stop()
    --     bgm_gain = 1
    -- end
    -- if action == 0 and stopBGM_delay < 6 and stopBGM_delay > 0 then
    --     bgm_gain = bgm_gain - update_time_step*0.166
    -- end
    -- if autoStart_BGM:is_playing() then
    --     video_time = video_time + update_time_step
    --     if video_time > 122 then
    --         video_time = 0
    --     end
    -- else
    --     video_time = -1
    --     LOADING_DISPLAY:set(0)
    -- end
    -- autoStart_BGM:update(nil,bgm_gain,nil)
    -- CHN_LOADING_TIME:set(video_time)
end