FA_18E = 
{
	Name 				=   'FA-18E',
	DisplayName			= _('FA-18E'),
--	HumanCockpit 		= true,
--	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	Picture 			= current_mod_path.."/FA-18E.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "FA-18E",
	shape_table_data 	= 
	{
		{
			file  	 = 'FA-18E';
			life  	 = 18; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'FA-18E_destr'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'FA-18E';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
--		{
--			name  = "FA-18E_destr";
--			file  = "FA-18E-destr";
--			fire  = { 240, 2};
--		},

	},
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Multirole fighters", "Refuelable", "Datalink", "Link16",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
    LandRWCategories = 
    {
        [1] = 
        {
            Name = "AircraftCarrier",
        }, -- end of [1]
    }, -- end of LandRWCategories
    TakeOffRWCategories = 
    {
        [1] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, -- end of [1]
    }, -- end of TakeOffRWCategories
	-------------------------

	--  \Scripts\Database\PlaneConst.lua̗ގ̋@̃f[^Q 	
	M_empty 					= 10455, -- kg
	M_nominal 					= 16651, -- kg
	M_max 						= 25401, -- kg
	M_fuel_max 					= 4930, -- kg
	H_max 					 	= 15240, -- m
	average_fuel_consumption 	= 0.85, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 62, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 180,-- Cruise speed (for AI)
	V_take_off 					= 69, -- Take off speed in m/s (for AI)
	V_land 						= 65, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 361.1, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 541.7, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 254, -- Max climb speed in m/s (for AI)
	Mach_max 					= 1.8, -- Max speed in Mach (for AI)
	Ny_min 						= -3, -- Min G (for AI)
	Ny_max 						= 7,  -- Max G (for AI)
	Ny_max_e 					= 7.5,  -- Max G (for AI)
	AOA_take_off 				= 0.16, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)
	has_afteburner 				= true, -- AFB yes/no
	has_speedbrake 				= true, -- Speedbrake yes/no
	nose_gear_pos 				= {3.67,	-1.85, 0}, -- nosegear coord
	main_gear_pos 				= { -2.075,	-1.85,	1.685}, -- main gear coords
	tand_gear_max 				= 3.73,
	tanker_type 				= 2, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 37, -- wing area in m2
	wing_span 					= 11.43, -- wing spain in m
	wing_type 					= 2, --FOLDED_WING
	thrust_sum_max 				= 12000, -- thrust in kg (44kN)
	thrust_sum_ab 				= 19580, -- thrust inkg (71kN)
	length 						= 17.07, -- full lenght in m
	height 						= 4.66, -- height in m
	flaps_maneuver 				= 1, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1520, -- Max range in km (for AI)
	RCS 						= 5, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.58, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 1.16, -- With afterburner
	wing_tip_pos 				=  {-3.36,	0.15, 6.61}, -- wingtip coords for visual effects
	nose_gear_wheel_diameter 	= 0.595, -- in m
	main_gear_wheel_diameter 	= 0.779, -- in m
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {6.731,	0.825,	0.492}, -- refuel coords
	engines_count				= 2, -- Engines count
	engines_nozzles = 
	{
		[1] = 
		{
			pos					= {-8.0, 0.127, 0.516}, -- nozzle coords
			elevation			= 0, -- AFB cone elevation
			diameter			= 0.8, -- AFB cone diameter
			exhaust_length_ab	= 5, -- lenght in m
			exhaust_length_ab_K	= 0.76, -- AB animation
			smokiness_level		= 0.1,
		}, -- end of [1]
		[2] = 
		{
			pos					= {-8.0, 0.127, -0.519}, -- nozzle coords
			elevation			= 0, -- AFB cone elevation
			diameter			= 0.8, -- AFB cone diameter
			exhaust_length_ab	= 5, -- lenght in m
			exhaust_length_ab_K	= 0.76, -- AB animation
			smokiness_level		= 0.1,
		}, -- end of [2]
	}, -- end of engines_nozzles
	crew_size	 = 1,
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	17,
			drop_canopy_name	=	24,
			pos = 	{4.6, 1.4, 0.0},
			canopy_pos = {4.6, 1.4, 0.0},
		}, -- end of [1]
	}, -- end of crew_members

	fires_pos = 
	{
		[1] = 	{-0.232,	0.262,	0},
		[2] = 	{-2.508,	0.08,	3.094},
		[3] = 	{-2.815,	0.056,	-3.639},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	4.274},
		[7] = 	{-0.82,	0.255,	-4.274},
		[8] = 	{-7.128,	0.039,	0.5},
		[9] = 	{-7.728,	0.039,	-0.5},
		[10] = 	{-7.728,	0.039,	0.5},
		[11] = 	{-7.728,	0.039,	-0.5},
	}, -- end of fires_pos
	
	
	-- Countermeasures
--	SingleChargeTotal	 	= 120,
--	CMDS_Incrementation 	= 4,
--	ChaffDefault 			= 64, 
--	ChaffChargeSize 		= 1,
--	FlareDefault 			= 64, 
--	FlareChargeSize 		= 1,
--	CMDS_Edit 				= true,
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 240,
		-- RR-170
		chaff = {default = 120, increment = 30, chargeSz = 1},
		-- MJU-7
		flare = {default = 60, increment = 15, chargeSz = 2}
    },

	chaff_flare_dispenser = 
	{
		[1] = 
		{
			dir = 	{0,	-1,	0},
			pos = 	{-0.75,	-0.78,	-0.74},
		}, -- end of [1]
		[2] = 
		{
			dir = 	{0,	-1,	0},
			pos = 	{-0.75,	-0.78,	0.74},
		}, -- end of [2]
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
--	CanopyGeometry = 
--	{
--		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
--		elevation = {-50.0, 80.0} -- pilot view vertical (AI)
--	},
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_GOOD, LOOK_GOOD),

	Sensors = 
	{
        RADAR = "AN/APG-73",
        RWR = "Abstract RWR"
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	
	Guns = 
	{
	    gun_mount("M_61", { count = 511 },{muzzle_pos = {7.84,  0.50, 0.0}})
	},
	
Pylons = 
    {
        pylon(1, 0, -2.28, 0.17, -6.69,
            {
  				use_full_connector_position = true,
            },
            {
			
			    { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --aim 9M
                { CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}" }, --aim 9x
            }
        ),
        pylon(2, 0, -2.03, -0.30, -4.325,
            {
                FiZ = 0,
            },
            {
			    { CLSID = "LAU-127_AIM-9M", attach_point_position = {0.2,  0.1,  0.0}}, --AIM-9M
                { CLSID = "LAU-127_AIM-9X", attach_point_position = {0.2,  0.1,  0.0}}, --aim 9x
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "{LAU-115 - AIM-120B}" , attach_point_position = {-0.10,  0.1,  0.0}}, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C}" , attach_point_position = {-0.10,  0.1,  0.0}}, --AIM-120C
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{AMBER_2xAIM120C5}" , attach_point_position = {0.10,  0.1,  0.0}, Type = 1}, -- AIM-120C*2
				
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --mk82
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --mk20
				
            }
        ),
        pylon(3, 0, -1.25, -0.274, -3.425,
            {
                FiZ = 0,
            },
            {
				{ CLSID = "{LAU-115 - AIM-120B}" }, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C}" }, --AIM-120C
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "LAU-115_LAU-127_AIM-9X" }, --AIM-9X
				{ CLSID = "LAU-115_LAU-127_AIM-9M" }, --AIM-9M
				{ CLSID = "LAU-115_2*LAU-127_AIM-9X" }, --AIM-9X*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-9M" }, --AIM-9M*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120B" }, --AIM-120B*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120C" }, --AIM-120C*2
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84
				{ CLSID = "{Mk_84AIR_GP}" }, --MK-84AIR
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --MK-20
				{ CLSID = "{CBU-52B}" }, --CBU-52
				{ CLSID = "{CBU-87}" }, --CBU-87
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, --CBU-97
				{ CLSID = "{BRU33_2X_MK-82}" }, --MK-82*2
				{ CLSID = "{BRU33_2X_MK-82Y}" }, --MK-82Y*2
				{ CLSID = "{BRU33_2X_MK-83}" }, --MK-83*2
				{ CLSID = "{BRU33_2X_ROCKEYE}" }, --MK-20*2
				{ CLSID = "{BRU33_2X_CBU-99}" }, --CBU-99*2
				{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}" }, --LAU-10
				{ CLSID = "{BRU33_2*LAU10}" }, --LAU-10*2
				{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" }, --LAU-61
				{ CLSID = "{BRU33_2*LAU61}" }, --LAU-61*2
				{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" }, --LAU-61 WP
				{ CLSID = "{FPU_8A_FUEL_TANK}" },
				{ CLSID = "FA_18E_TANK" },
            }
        ),
        pylon(4, 0, -1.10, -0.230, -2.260,
            {
                FiZ = 0,
            },
            {
				{ CLSID = "{LAU-115 - AIM-120B}" }, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C}" }, --AIM-120C
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "LAU-115_LAU-127_AIM-9X" }, --AIM-9X
				{ CLSID = "LAU-115_LAU-127_AIM-9M" }, --AIM-9M
				{ CLSID = "LAU-115_2*LAU-127_AIM-9X" }, --AIM-9X*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-9M" }, --AIM-9M*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120B" }, --AIM-120B*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120C" }, --AIM-120C*2
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84
				{ CLSID = "{Mk_84AIR_GP}" }, --MK-84AIR
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --MK-20
				{ CLSID = "{CBU-52B}" }, --CBU-52
				{ CLSID = "{CBU-87}" }, --CBU-87
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, --CBU-97
				{ CLSID = "{BRU33_2X_MK-82}" }, --MK-82*2
				{ CLSID = "{BRU33_2X_MK-82Y}" }, --MK-82Y*2
				{ CLSID = "{BRU33_2X_MK-83}" }, --MK-83*2
				{ CLSID = "{BRU33_2X_ROCKEYE}" }, --MK-20*2
				{ CLSID = "{BRU33_2X_CBU-99}" }, --CBU-99*2
				{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}" }, --LAU-10
				{ CLSID = "{BRU33_2*LAU10}" }, --LAU-10*2
				{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" }, --LAU-61
				{ CLSID = "{BRU33_2*LAU61}" }, --LAU-61*2
				{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" }, --LAU-61 WP
				{ CLSID = "{FPU_8A_FUEL_TANK}" },
				{ CLSID = "FA_18E_TANK" },
            }
        ),
        pylon(5, 1, -2.50, -0.68, -1.263,
            {
				FiZ = -1,
            },
            {
                { CLSID = "{AAQ-28_LEFT}" }, --AN/AAQ-28 FLIR/LDT
                { CLSID = "{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}" , attach_point_position = {-0.8,  -0.05,  0.05}}, --AN/AAS-38 FLIR
               
				
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}"}, --AIM 120B
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"}, --AIM 120C
			--	{ CLSID = "{AIM-120D}" }, --AIM 120D
				{ CLSID = "{AN_ASQ_228}" }, --AN/AAQ-228 ATFLIR
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM 7
            }
        ),
        pylon(6, 1, 0.73, -0.600, 0,
            {
                FiZ = 0,
            },
            {
				{ CLSID = "{LegionPod_F18}" ,attach_point_position = {-0.0,  -0.2, 0.0}},
				{ CLSID = "{FPU_8A_FUEL_TANK}" },
				{ CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" }, --AN/AAQ-28 FLIR/LDT
				--{ CLSID = "{AN_ASQ_228}" }, --AN/AAQ-228 ATFLIR
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84
				{ CLSID = "{Mk_84AIR_GP}" }, --MK-84AIR
				
			}
        ),
        pylon(7, 1, -2.50, -0.68, 1.263,
            {
                FiZ = -1,
            },
            {
				{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}" }, --AIM 120B
                { CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}" }, --AIM 120C
			--	{ CLSID = "{AIM-120D}" }, --AIM 120D
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM 7
				{ CLSID = "{1C2B16EB-8EB0-43de-8788-8EBB2D70B8BC}", attach_point_position = {-0.8,  -0.05,  -0.05} }, --AN/ASQ-173 LST/SCAM
            }
        ),		
        pylon(8, 0, -1.10, -0.230, 2.260,
			{
                FiZ = 0,
            },
            {
				{ CLSID = "{LAU-115 - AIM-120B_R}" }, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C_R}" }, --AIM-120C
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "LAU-115_LAU-127_AIM-9X_R" }, --AIM-9X
				{ CLSID = "LAU-115_LAU-127_AIM-9M_R" }, --AIM-9M
				{ CLSID = "LAU-115_2*LAU-127_AIM-9X" }, --AIM-9X*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-9M" }, --AIM-9M*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120B" }, --AIM-120B*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120C" }, --AIM-120C*2
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84
				{ CLSID = "{Mk_84AIR_GP}" }, --MK-84AIR
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --MK-20
				{ CLSID = "{CBU-52B}" }, --CBU-52
				{ CLSID = "{CBU-87}" }, --CBU-87
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, --CBU-97
				{ CLSID = "{BRU33_2X_MK-82}" }, --MK-82*2
				{ CLSID = "{BRU33_2X_MK-82Y}" }, --MK-82Y*2
				{ CLSID = "{BRU33_2X_MK-83}" }, --MK-83*2
				{ CLSID = "{BRU33_2X_ROCKEYE}" }, --MK-20*2
				{ CLSID = "{BRU33_2X_CBU-99}" }, --CBU-99*2
				{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}" }, --LAU-10
				{ CLSID = "{BRU33_2*LAU10}" }, --LAU-10*2
				{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" }, --LAU-61
				{ CLSID = "{BRU33_2*LAU61}" }, --LAU-61*2
				{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" }, --LAU-61 WP
				{ CLSID = "{FPU_8A_FUEL_TANK}" },
				{ CLSID = "FA_18E_TANK" },
            }
        ),
        pylon(9, 0, -1.25, -0.274, 3.425,
            {
                FiZ = 0,
            },
            {
				{ CLSID = "{LAU-115 - AIM-120B_R}" }, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C_R}" }, --AIM-120C
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "LAU-115_LAU-127_AIM-9X_R" }, --AIM-9X
				{ CLSID = "LAU-115_LAU-127_AIM-9M_R" }, --AIM-9M
				{ CLSID = "LAU-115_2*LAU-127_AIM-9X" }, --AIM-9X*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-9M" }, --AIM-9M*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120B" }, --AIM-120B*2
				{ CLSID = "LAU-115_2*LAU-127_AIM-120C" }, --AIM-120C*2
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83
				{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" }, --MK-84
				{ CLSID = "{Mk_84AIR_GP}" }, --MK-84AIR
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --MK-20
				{ CLSID = "{CBU-52B}" }, --CBU-52
				{ CLSID = "{CBU-87}" }, --CBU-87
				{ CLSID = "{5335D97A-35A5-4643-9D9B-026C75961E52}" }, --CBU-97
				{ CLSID = "{BRU33_2X_MK-82}" }, --MK-82*2
				{ CLSID = "{BRU33_2X_MK-82Y}" }, --MK-82Y*2
				{ CLSID = "{BRU33_2X_MK-83}" }, --MK-83*2
				{ CLSID = "{BRU33_2X_ROCKEYE}" }, --MK-20*2
				{ CLSID = "{BRU33_2X_CBU-99}" }, --CBU-99*2
				{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}" }, --LAU-10
				{ CLSID = "{BRU33_2*LAU10}" }, --LAU-10*2
				{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" }, --LAU-61
				{ CLSID = "{BRU33_2*LAU61}" }, --LAU-61*2
				{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" }, --LAU-61 WP
				{ CLSID = "{FPU_8A_FUEL_TANK}" },
				{ CLSID = "FA_18E_TANK" },
            }
        ),
        pylon(10, 0, -2.03, -0.30, 4.325,
			{
                FiZ = 0,
            },
            {	
			    { CLSID = "LAU-127_AIM-9M", attach_point_position = {0.2,  0.1,  0.0}}, --AIM-9M
                { CLSID = "LAU-127_AIM-9X", attach_point_position = {0.2,  0.1,  0.0}}, --aim 9x
				--{ CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}" }, --AIM-7
				{ CLSID = "{LAU-115 - AIM-120B_R}" , attach_point_position = {-0.1,  0.1,  0.0}}, --AIM-120B
                { CLSID = "{LAU-115 - AIM-120C_R}" , attach_point_position = {-0.1,  0.1,  0.0}}, --AIM-120C
				{ CLSID = '{aargm}' }, --AARGM
				{ CLSID = "{AMBER_2xAIM120C5}" , attach_point_position = {0.10,  0.1,  0.0}, Type = 1}, -- AIM-120C*2
				
				
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --mk82
				{ CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" }, --mk20
            }
        ),
        pylon(11, 0, -2.28, 0.17, 6.69,
            {
  				use_full_connector_position = true,
            },
            {
                { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --aim 9M
                { CLSID = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}" }, --aim 9x
            }
        ),
    },
	
	Tasks = 
	{
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(AFAC),
		aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	--  \Scripts\Database\SFM_Data.lua̗ގ̋@̃f[^Q 	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0,      -- zero AoA lift coefficient
			Mzalfa		=	4.355,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.75,    
			kjz			=	0.00125, 
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0268,    -- coefficient, drag, gear
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	0.52,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{	--      M		Cx0		 	Cya			B		 	B4	    	Omxmax		Aldop		Cymax
				[1] = 	{0,	0.0151,	0.07,	0.134,	0.0567,	0.5,	30,	1.2},
				[2] = 	{0.2,	0.0154,	0.07,	0.134,	0.056,	1.5,	30,	1.2},
				[3] = 	{0.4,	0.0156,	0.07,	0.134,	0.0549,	2.5,	30,	1.2},
				[4] = 	{0.6,	0.0164,	0.073,	0.134,	0.0474,	3.5,	30,	1.2},
				[5] = 	{0.7,	0.0172,	0.076,	0.134,	0.052,	3.5,	28.666666666667,	1.18},
				[6] = 	{0.8,	0.0201,	0.079,	0.144,	0.0607,	3.5,	27.333333333333,	1.16},
				[7] = 	{0.9,	0.0284,	0.083,	0.159,	0.0666,	3.5,	26,	1.14},
				[8] = 	{1,	0.0538,	0.085,	0.219,	0.0812,	3.5,	24.666666666667,	1.12},
				[9] = 	{1.05,	0.053618181818182,	0.085454545454545,	0.24854545454545,	0.080972727272727,	3.5,	24,	1.11},
				[10] = 	{1.1,	0.053436363636364,	0.085909090909091,	0.27809090909091,	0.080745454545455,	3.15,	18,	1.1},
				[11] = 	{1.11,	0.0534,	0.086,	0.284,	0.0807,	3.08,	17.9,	1.095},
				[12] = 	{1.2,	0.0493,	0.083,	0.35,	0.0784,	2.45,	17,	1.05},
				[13] = 	{1.3,	0.04536,	0.077,	0.4,	0.078,	1.75,	16,	1},
				[14] = 	{1.4,	0.0432,	0.062,	0.468,	0.0751,	1.625,	14.5,	0.95},
				[15] = 	{1.5,	0.0429,	0.054,	0.545,	0.0708,	1.5,	13,	0.9},
				[16] = 	{1.6,	0.0426,	0.046,	0.622,	0.0665,	1.2,	12.5,	0.8},
				[17] = 	{1.7,	0.04145,	0.0425,	0.743,	0.0618,	0.9,	12,	0.7},
				[18] = 	{1.8,	0.0403,	0.039,	0.864,	0.0571,	0.86,	11.4,	0.64},
				[19] = 	{2.2,	0.0377,	0.034,	1,	0.048,	0.7,	9,	0.4},
				[20] = 	{2.35,	0.0377,	0.033,	1,	0.0448,	0.7,	9,	0.4},
				[21] = 	{3.9,	0.0377,	0.033,	1,	0.0448,	0.7,	9,	0.4},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	0.85, -- Military power state of the throttle
			ForsRUD	=	0.91, -- Afterburner state of the throttle
			typeng	=	1,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN = 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	19, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0144, -- Engine drag coeficient
			cemax	=	1.24, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	2.56, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	3500, --  altitude coefficient for max thrust
			dpdh_f	=	6500,  --  altitude coefficient for AB thrust
			table_data = 
			{		--   M		Pmax		 Pfor	
				[1] = 	{0,	68000,	140000},
				[2] = 	{0.2,	68000,	140000},
				[3] = 	{0.4,	73000,	140000},
				[4] = 	{0.6,	80000,	137000},
				[5] = 	{0.7,	92000,	140000},
				[6] = 	{0.8,	90000,	145000},
				[7] = 	{0.9,	86000,	143000},
				[8] = 	{1,	60000,	143000},
				[9] = 	{1.11,	27000,	145000},
				[10] = 	{1.2,	13000,	149000},
				[11] = 	{1.3,	7000,	145000},
				[12] = 	{1.4,	5000,	147000},
				[13] = 	{1.6,	3000,	149000},
				[14] = 	{1.8,	2000,	145000},
				[15] = 	{2.2,	1500,	113000},
				[16] = 	{2.35,	1000,	94000},
				[17] = 	{3.9,	0,	30000},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	}, -- end of SFM_Data

	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = 
	{
		[0]  = {critical_damage = 5,  args = {82}},	--"NOSE_CENTER"
		[3]  = {critical_damage = 10, args = {65}},	--"COCKPIT"
		[8]  = {critical_damage = 10},	--"FRONT_GEAR_BOX"
		[10] = {critical_damage = 3},	--"MAIN"
		[11] = {critical_damage = 3},	--"ENGINE_L"
		[12] = {critical_damage = 3},	--"ENGINE_R"
		[15] = {critical_damage = 10},	--"LEFT_GEAR_BOX"
		[16] = {critical_damage = 10},	--"RIGHT_GEAR_BOX"
		[17] = {critical_damage = 3},	--"MTG_L"
		[18] = {critical_damage = 3},	--"MTG_R"
		[23] = {critical_damage = 10, args = {67}, deps_cells = {25}},	--"WING_L_OUT"
		[24] = {critical_damage = 10, args = {68}, deps_cells = {26}},	--"WING_R_OUT"
		[25] = {critical_damage = 5,  args = {53}},	--"ELERON_L"
		[26] = {critical_damage = 5,  args = {54}},	--"ELERON_R"
		[35] = {critical_damage = 10, args = {225}, deps_cells = {23, 25, 37}},	--"WING_L_IN"
		[36] = {critical_damage = 10, args = {215}, deps_cells = {24, 26, 38}},	--"WING_R_IN"
		[37] = {critical_damage = 4,  args = {55}},	--"FLAP_L_IN"
		[38] = {critical_damage = 4,  args = {56}},	--"FLAP_R_IN"
		[43] = {critical_damage = 4,  args = {61}, deps_cells = {53}},	--"FIN_L_BOTTOM"
		[44] = {critical_damage = 4,  args = {62}, deps_cells = {54}},	--"FIN_R_BOTTOM"
		[51] = {critical_damage = 2,  args = {59}},	--"ELEVATOR_L_IN"
		[52] = {critical_damage = 2,  args = {60}},	--"ELEVATOR_R_IN"
		[53] = {critical_damage = 2,  args = {57}},	--"RUDDER_L"
		[54] = {critical_damage = 2,  args = {58}},	--"RUDDER_R"
		[55] = {critical_damage = 15, args = {81}},	--"TAIL"
	},  -- end of Damage
	
	DamageParts = 
	{  
--		[1] = "F-2-OBLOMOK-WING-R", -- wing R
--		[2] = "F-2-OBLOMOK-WING-L", -- wing L
	},


	lights_data = 
	{
		typename = "collection",
		lights = 
		{
			[1] = -- Xg{Cg
			{
		    	typename = "collection",
				lights = 
				{
					-- Left Anticollision Light
					{typename = "natostrobelight",
					connector = "WHITE_BEACON L",
					position  = {-5.72, 2.58, -1.81},
					color = {1.0, 0.0, 0.0},
					argument_1 = 195,
					period = 1.2,
					phase_shift = 0
					},
					-- Right Anticollision Light
					{typename = "natostrobelight",
					connector = "WHITE_BEACON R",
					position  = {-5.72, 2.58, 1.81},
					color = {1.0, 0.0, 0.0},
					argument_1 = 195,
					period = 1.2,
					phase_shift = 0
					}
				}
			},
			[2] = -- fBOCg
			{
				typename = "collection",
				lights =
				{
					-- Landing/Taxi light
					{
					typename = "spotlight",
					connector = "MAIN_SPOT_PTR_01",
					position  = {3.98, -0.58, 0.0},
					color = {1.0, 1.0, 1.0},
					argument = 208,
					dir_correction = {elevation = math.rad(3)}
					},
				}
			},
		    [3]	= -- irQ[VCg
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					connector = "BANO_1",
					color = {0.32, 0.0, 0.07},
					position  = {-2.68, 0.1, -5.15},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					connector = "BANO_2",
					color = {0, 0.26, 0.18},
					position  = {-2.68, 0.1, 5.15},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					connector = "BANO_0_BACK",
					color = {1, 1, 1},
					position  = {-6.87, 2.81, 1.81},
					argument  = 203
					},
				}
			},
		    [4] = -- tH[[VCg
			{
		    	typename = "collection",
				lights = 
				{
					-- я̃tH[[VCg
					{typename  = "argumentlight", argument = 200}
				}
			},
			[5]	=
			{
			}
		}
	},  -- end of lights_data
	

}

add_aircraft(FA_18E)
