--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)
--Return.PlaceLogistic("AirbaseName")						returns the logistics of a base in weight which can be increased by the landing of transport aircraft or helicopters


--List of Action functions for trigger actions:
--Action.None()																				--void action
--Action.Text("your briefing text")															--add briefing text
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--set campagn flag to value
--Action.AddCampFlag(flag-n, number)														--add or subtract to campaign flag
--Action.AddImage("filname.jpg")															--add briefing picture
--Action.CampaignEnd("win"/"draw"/"loss")													--end campaign
--Action.TargetActive("TargetName", boolean)												--set target active/inactive
--Action.AirUnitActive("UnitName", boolean)													--set unit active/inactive
--Action.SideBase("side", "BaseName")														--change le camp d'une base, ATTENTION, deplacer les unités avant--Action.SideBase("blue", "Incirlik Airbase")
--Action.AirUnitBase("UnitName", "BaseName")												--set unit base
--Action.AirUnitPlayer("UnitName", boolean)													--set unit playable
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--send reinforcement aircraft from one unit to another
--Action.AirUnitRepair()																	--repair damaged aircraft in all air units
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--add ground target intel updates to briefing
--Action.GroupHidden("GroupName", boolean)													--change vehicle/ship group hidden status
--Action.GroupProbability("GroupName", number 0-1)											--change vehicle/ship group probability status
																							--due to the way stats are reset for a new playrun upon completing a FirstMission, groups probability changed by trigger in first mission will not be carried over to second mission! Repeat trigger on second mission or use the trigger from mission 2 on only for flawless function.
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("Since 1974 Cyprus is divided between cyprus pro-turk population to the north and Cyprus pro-greek population to the south. June 2004,Pro-Turkish forces are trying to circle Nicosia with a surprised light columms attack. Their hope is to capture the city and win lot more territorial possessions. Your unit will try to resist and destroy this weak enemy columns in the suburbs of Nicosia. You are equiped with Mi-24P Hind and SA-342 Gazelle. Intel think that Turkey is ready to support massively this attack and our hope is that Greek army will help us if that occured.")',
			[2] = 'Action.Text("The Turkish Air Force is flying a mix of F-16C F-4E and F-5E-3 fighters. UH-1H Huey and AH-1 Cobra will support their ground forces directly.SAM systems like Rapier, Hawk and more mobile Avenger and Stinger Manpad will certainly be deployed if needed by turkey")',
			[3] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			-- [5] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
	
	----- CAMPAIGN END -----
	-- ["Campaign End Victory 1"] = {
		-- active = true,
		-- once = false,
		-- condition = 'GroundTarget["blue"].percent < 45',
		-- action = {
			-- [1] = 'Action.CampaignEnd("win")',
			-- [2] = 'Action.Text("The Allied units deployed to UEA have successfully destroyed all the targets that they were assigned by US Central Command with the precious help of the French fighters and Sweden Viggen. With the complete destruction of the Iranian airbases, the air campaign of this war comes to an end. Allied air power has once again proven its effectiveness and decisiveness. Well done.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Campaign End Victory 2"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitReady("81 TFS") + Return.AirUnitReady("23 TFS") + Return.AirUnitReady("91 TFS") + Return.AirUnitReady("41 TFS") + Return.AirUnitReady("72 TFS") + Return.AirUnitReady("51 TFS") + Return.AirUnitReady("21 TFS") + Return.AirUnitReady("83 TFS") + Return.AirUnitReady("21-2 TFS") < 4',
		-- action = {
			-- [1] = 'Action.CampaignEnd("win")',
			-- [2] = 'Action.Text("The Islamic Republic Iranian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Iranians are no longer able to produce any sorties or offer any resistance. The NATO now owns complete air superiority. Well done.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Campaign End Victory 3"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.TargetAlive("Lar Airbase") < 4 and Return.TargetAlive("Lar Airbase Strategics") < 4 and Return.TargetAlive("Abu Musa Island Airport") < 2 and Return.TargetAlive("Abu Musa Island Airport Strategics") < 4 and Return.TargetAlive("Sirri Island") < 3 and Return.TargetAlive("Sirri Island Airport Strategics") < 3 and Return.TargetAlive("Havadarya") < 4 and Return.TargetAlive("Havadarya Airport Strategics") < 7 and Return.TargetAlive("Bandar Abbas Intl") < 6 and Return.TargetAlive("Bandar Abbas Intl Strategics") < 14',
		-- action = {
			-- [1] = 'Action.CampaignEnd("win")',
			-- [2] = 'Action.Text("The Iranian Air Force is in ruins. All their bases are destroyed, Iran are no longer able to produce any sorties or offer any resistance. The Allied forces now owns complete air superiority. Well done.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Campaign End Loss"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.AirUnitAlive("13 TFS") + Return.AirUnitReady("R/13 TFS") < 4',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("Ongoing combat operations have exhausted 13 TFS. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Allied Air Force to attain air superiority, US Central Command has decided to call of the air campaign against the Iranians. Without destroying Iranians airbases it seems unlikely that the coalition will be able to win this war.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Campaign End Loss 3"] = {
		-- active = true,
		-- once = false,
		-- condition = 'GroundTarget["red"].percent < 20',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("Iranian airforce was able to destroy enough allied forces to decide US Command to ask for a cease fire  and stop any Air missions. This is a bitter failure for the Navy")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Campaign End Draw"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.Mission() >= 50',
		-- action = {
			-- [1] = 'Action.CampaignEnd("draw")',
			-- [2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Islamic Republic Iranian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Iranian will convince them to stop fortifications in the Persian Gulf")',
			-- [3] = 'NoMoreNewspaper = true',
		-- },
	-- },
	
	
		
	----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
			[2] = 'Action.Text("Les premières cibles ont été détruites. Continuez votre bon travail")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
			[2] = 'Action.Text("Les cibles ennemies ont subi des dommages moyens. Continuez votre bon travail")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
			[2] = 'Action.Text("Les cibles ennemies ont subi de gros dégâts. Les attaques au sol sont vraiment efficaces et nous gagnerons bientôt cette guerre")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
			[2] = 'Action.Text("Plus de la moitié de nos cibles sont neutralisées. Les renseignements pensent que l ennemi demandera bientôt un cessez-le-feu")',
		},
	},

	
	
	--- Flags 801 : Turkish involvement - 802 : Greek involvement  ---- 
	
	
	
	
	----- TROOPS MOVEMENTS ------
	
	["Cyprus Border Force 1 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Border Force 1 T1.stm")',
		[2] = 'Action.TargetActive("Cyprus Border Force 1", true)',
		[3] = 'Action.TemplateActive("Ercan Airbase Defenses T1.stm")',
		},
	},
	["Cyprus Border Force 6 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Border Force 6 T1.stm")',
		[2] = 'Action.TargetActive("Cyprus Border Force 6", true)',
		},
	},
	["North Cyprus Force 1 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 1 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus Force 1", true)',		
		[3] = 'Action.Text("North Cyprus columns crossed the No man s land and are coming from the far South west of Nicosia")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 2 T1.stm")',
		[5] = 'Action.TargetActive("Cyprus Border Force 2", true)',
		},
	},
	["North Cyprus Force 1 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus Force 1") < 40',
		action = {	
		[1] = 'Action.Text("North Cyprus columns to the far South west of Nicosia took heavy losses and are stopped")',
		},
	},
	["North Cyprus Force 2 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 2 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus Force 2", true)',		
		[3] = 'Action.Text("North Cyprus columns crossed the No man s land and are coming from the close south west of Nicosia")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 3 T1.stm")',
		[5] = 'Action.TargetActive("Cyprus Border Force 3", true)',
		},
	},
	["North Cyprus Force 2 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus Force 2") < 40',
		action = {		
		[1] = 'Action.Text("North Cyprus columns to the close south west of Nicosia took heavy losses and are stopped")',
		},
	},	
	["North Cyprus Force 3 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >0',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 3 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus Force 3", true)',		
		[3] = 'Action.Text("North Cyprus columns crossed the No man s land and are coming from the close South east of Nicosia")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 4 T1.stm")',
		[5] = 'Action.TargetActive("Cyprus Border Force 4", true)',
		},
	},
	["North Cyprus Force 3 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus Force 3") < 40',
		action = {
		[1] = 'Action.Text("North Cyprus columns to the close South east of Nicosia took heavy losses and are stopped")',
		},
	},
	["North Cyprus Force 4 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >0',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 4 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus Force 4", true)',		
		[3] = 'Action.Text("North Cyprus columns crossed the No man s land and are coming from the far South east of Nicosia")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 5 T1.stm")',
		[5] = 'Action.TargetActive("Cyprus Border Force 5", true)',
		},
	},
	["North Cyprus Force 4 stop 1"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus Force 4") < 40',
		action = {	
		[1] = 'Action.Text("North Cyprus columns to the far South east of Nicosia took heavy losses and are stopped")',
		},
	},
	["North Cyprus Force 1 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1 and (Return.TargetAlive("North Cyprus Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 1 T2.stm")',
		[2] = 'Action.Text("North Cyprus columns are still moving in the south west suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 1 T2.stm")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 2 T2.stm")',
		},
	},
	["North Cyprus Force 2 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1 and (Return.Mission() < 3 and Return.TargetAlive("North Cyprus Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 2 T2.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south west suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 3 T2.stm")',
		},
	},
	["North Cyprus Force 3 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1 and (Return.Mission() < 3 and Return.TargetAlive("North Cyprus Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 3 T2.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south east of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 4 T2.stm")'
		},
	},
	["North Cyprus Force 4 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1 and (Return.Mission() < 3 and Return.TargetAlive("North Cyprus Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 4 T2.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south east of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 5 T2.stm")',
		},
	},
	["North Cyprus Force 1 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2 and (Return.TargetAlive("North Cyprus Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 1 T3.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south west suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 1 T3.stm")',
		[4] = 'Action.TemplateActive("Cyprus Border Force 2 T3.stm")',
		},
	},
	["North Cyprus Force 2 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2 and (Return.TargetAlive("North Cyprus Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 2 T3.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south west suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 3 T3.stm")',
		},
	},
	["North Cyprus Force 3 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2 and (Return.TargetAlive("North Cyprus Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 3 T3.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south east suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 4 T3.stm")'
		},
	},
	["North Cyprus Force 4 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2 and (Return.TargetAlive("North Cyprus Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus Force 4 T3.stm")',	
		[2] = 'Action.Text("North Cyprus columns are still moving in the south east suburbs of Nicosia")',
		[3] = 'Action.TemplateActive("Cyprus Border Force 5 T3.stm")',
		},
	},		
	["North Cyprus Force First Victory - Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 4 and ((Return.TargetAlive("North Cyprus Force 1") > 40 or Return.TargetAlive("North Cyprus Force 2") > 40) and (Return.TargetAlive("North Cyprus Force 3") > 40 or Return.TargetAlive("North Cyprus Force 4") > 40))',
		action = {
		[1] = 'Action.AirUnitActive("EC 331", true)',
		[2] = 'Action.TargetActive("Paphos Airbase Alert", true)',
		[3] = 'Action.TargetActive("Paphos Airbase Alert 2", true)',
		[4] = 'Action.TargetActive("Paphos Airbase Alert 3", true)',
		[5] = 'Action.Text("North Cyprus columns are circling Nicosia and will soon be able to capture the city. Greece can t tolerate that and decided to help Cyprus. EC 331 is sent to help Cyprus to destroy North Cyprus forces with its Mirage 2000C and soon more Ground forces will be projected to protect Cyprus")',
		[6] = 'Action.SetCampFlag(802, Return.Mission())',
		[7] = 'Action.TemplateActive("Greek Naval Convoy T1.stm")',
		[8] = 'Action.TargetActive("Greek Naval Convoy", true)',
		[9] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Turkish involvement"] = {
		active = true,
		once = true,
		condition = '((Return.TargetAlive("North Cyprus Force 1") < 40 and Return.TargetAlive("North Cyprus Force 2") < 40) or (Return.TargetAlive("North Cyprus Force 3") < 40 and Return.TargetAlive("North Cyprus Force 4") < 40)) and (Return.CampFlag(802) <= 0 or  Return.CampFlag(802) == nil)',
		action = {
		[1] = 'Action.AirUnitActive("111.Filo", true)',
		[2] = 'Action.AirUnitActive("2nd KHA", true)',
		[3] = 'Action.TargetActive("Airlift Ercan Airbase 2", true)',
		[4] = 'Action.TargetActive("Airlift Ercan Airbase 3", true)',	
		[5] = 'Action.Text("North Cyprus columns have been crippled but it seems that turkish forces will try to rescue their allies sending heavy reinforcements")',
		[6] = 'Action.SetCampFlag(801, Return.Mission())',
		},
	},
	["Turkish involvement after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3)',
		action = {
		[1] = 'Action.AirUnitActive("111.Filo", true)',
		[2] = 'Action.AirUnitActive("2nd KHA", true)',
		[3] = 'Action.TargetActive("Airlift Ercan Airbase 2", true)',
		[4] = 'Action.TargetActive("Airlift Ercan Airbase 3", true)',	
		[5] = 'Action.Text("After Greece involvement it seems that turkish forces will try to rescue their allies sending heavy reinforcements")',
		},
	},
	["Cyprus Defense Forces activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 2)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T1.stm")',
		[2] = 'Action.TargetActive("Cyprus Defense Force 1", true)',
		[3] = 'Action.TemplateActive("Cyprus Defense Force 2 T1.stm")',
		[4] = 'Action.TargetActive("Cyprus Defense Force 2", true)',
		[5] = 'Action.TemplateActive("Cyprus Defense Force 3 T1.stm")',
		[6] = 'Action.TargetActive("Cyprus Defense Force 3", true)',
		[7] = 'Action.TemplateActive("Cyprus Defense Force 4 T1.stm")',
		[8] = 'Action.TargetActive("Cyprus Defense Force 4", true)',
		[9] = 'Action.TemplateActive("Cyprus Defense Force 5 T1.stm")',
		[10] = 'Action.TargetActive("Cyprus Defense Force 5", true)',
		[11] = 'Action.Text("After Turkish direct involment our Defense Forces have been mobilized and are moving to the frontline")',
		},
	},
	["Cyprus Defense Force 1 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Cyprus Defense Force 1") < 40',
		action = {
		[1] = 'Action.Text("Cyprus Defense Force 1 took heavy losses and is stopped")',
		},
	},
	["Cyprus Defense Force 1 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Cyprus Defense Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 1 is still moving")',
		},
	},
	["Cyprus Defense Force 1 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Cyprus Defense Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 1 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 2 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Cyprus Defense Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 2 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 2 is still moving")',
		},
	},
	["Cyprus Defense Force 2 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Cyprus Defense Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 2 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 2 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 3 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Cyprus Defense Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 3 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 3 is still moving")',
		},
	},
	["Cyprus Defense Force 4 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Cyprus Defense Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 4 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 4 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 5 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Cyprus Defense Force 5") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 5 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 5 is still moving")',
		},
	},
	["Cyprus Defense Force 5 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Cyprus Defense Force 5") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 5 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 5 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 2 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Cyprus Defense Force 2") < 40',
		action = {
		[1] = 'Action.Text("Cyprus Defense Force 2 took heavy losses and is stopped")',
		},
	},
	["Cyprus Defense Force 3 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Cyprus Defense Force 3") < 40',
		action = {
		[1] = 'Action.Text("Cyprus Defense Force 3 took heavy losses and is stopped")',
		},
	},
	["Cyprus Defense Force 4 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Cyprus Defense Force 4") < 40',
		action = {
		[1] = 'Action.Text("Cyprus Defense Force 4 took heavy losses and is stopped")',
		},
	},
	["Cyprus Defense Force 5 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Cyprus Defense Force 5") < 40',
		action = {
		[1] = 'Action.Text("Cyprus Defense Force 5 took heavy losses and is stopped")',
		},
	},
	["Cyprus Defense Forces activation after North Cyprus attack CORRECTION"] = {
		active = true,
		once = true,
		-- condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802))',
		condition = 'Return.CampFlag(802)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T1.stm")',
		[2] = 'Action.TargetActive("Cyprus Defense Force 1", true)',
		[3] = 'Action.TemplateActive("Cyprus Defense Force 2 T1.stm")',
		[4] = 'Action.TargetActive("Cyprus Defense Force 2", true)',
		[5] = 'Action.TemplateActive("Cyprus Defense Force 3 T1.stm")',
		[6] = 'Action.TargetActive("Cyprus Defense Force 3", true)',
		[7] = 'Action.TemplateActive("Cyprus Defense Force 4 T1.stm")',
		[8] = 'Action.TargetActive("Cyprus Defense Force 4", true)',
		[9] = 'Action.TemplateActive("Cyprus Defense Force 5 T1.stm")',
		[10] = 'Action.TargetActive("Cyprus Defense Force 5", true)',
		[11] = 'Action.Text("After North Cyprus attack our Defense Forces have been mobilized and are moving to the frontline")',
		},
	},
	["Cyprus Defense Force 1 move 2 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3) and (Return.TargetAlive("Cyprus Defense Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 1 is still moving")',
		},
	},
	["Cyprus Defense Force 1 move 3 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Cyprus Defense Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 1 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 1 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 2 move 2 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3) and (Return.TargetAlive("Cyprus Defense Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 2 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 2 is still moving")',
		},
	},
	["Cyprus Defense Force 2 move 3 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Cyprus Defense Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 2 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 2 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 3 move 2 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3) and (Return.TargetAlive("Cyprus Defense Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 3 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 3 is still moving")',
		},
	},
	["Cyprus Defense Force 4 move 3 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Cyprus Defense Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 4 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 4 reached defensives positions")',
		},
	},
	["Cyprus Defense Force 5 move 2 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3) and (Return.TargetAlive("Cyprus Defense Force 5") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 5 T2.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 5 is still moving")',
		},
	},
	["Cyprus Defense Force 5 move 3 after North Cyprus attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Cyprus Defense Force 5") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Cyprus Defense Force 5 T3.stm")',
		[2] = 'Action.Text("Cyprus Defense Force 5 reached defensives positions")',
		},
	},
	["North Cyprus-Turkish Force 1 initial positions"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 1)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus-Turkish Force 1", true)',		
		[3] = 'Action.Text("An heavy Turkish column has been detected on the main road between Famagusta and Nicosia just South of Gecitkale airbase. It seems that turkish army will get fully involved in this war. Be careful Turkish forces learned quickly from their allies defeat and heavy Air defenses are part of their columns now.")',
		},
	},
	["North Cyprus-Turkish Force 1 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus-Turkish Force 1") < 40',
		action = {
		[1] = 'Action.Text("Heavy Turkish column 1 took heavy losses and is stopped")',
		},
	},
	["North Cyprus-Turkish Force 1 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 3) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T2.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 is still moving")',
		},
	},
	["North Cyprus-Turkish Force 1 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T3.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 is still moving")',
		},
	},
	["North Cyprus-Turkish Force 1 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T4.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 stopped moving near ")',
		},
	},
	["North Cyprus-Turkish Force 1 initial positions after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 4)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus-Turkish Force 1", true)',		
		[3] = 'Action.Text("An heavy Turkish column has been detected on the main road between Famagusta and Nicosia just South of Gecitkale airbase. It seems that turkish army will get fully involved in this war. Be careful Turkish forces learned quickly from their allies defeat and heavy Air defenses are part of their columns now.")',
		[4] = 'Action.AddImage("NCTF1-1.png")',
		},
	},
	["North Cyprus-Turkish Force 1 move 2 after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 7) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T2.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 is still moving in the suburbs north east of Nicosia")',
		[3] = 'Action.AddImage("NCTF1-2.png")',
		},
	},
	["North Cyprus-Turkish Force 1 move 3 after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 9) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T3.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 is still moving few miles west of Nicosia")',
		[3] = 'Action.AddImage("NCTF1-3.png")',
		},
	},
	["North Cyprus-Turkish Force 1 move 4 after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 11) and (Return.TargetAlive("North Cyprus-Turkish Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 1 T4.stm")',
		[2] = 'Action.Text("Heavy Turkish column 1 stopped 10 nm west of Nicosia ")',
		[3] = 'Action.AddImage("NCTF1-4.png")',
		},
	},
	["North Cyprus Forces no more targeted CORRECTION"] = {
		active = true,
		once = true,
		-- condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801))',
		condition = 'Return.CampFlag(801)',
		action = {
		[1] = 'Action.TargetActive("North Cyprus Force 1", false)',
		[2] = 'Action.TargetActive("North Cyprus Force 2", false)',
		[3] = 'Action.TargetActive("North Cyprus Force 3", false)',
		[4] = 'Action.TargetActive("North Cyprus Force 4", false)',
		},
	},
	["Larnaca Airbase Attack"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 2)',
		action = {
		[1] = 'Action.TemplateActive("Larnaca Cyprus defenses T1.stm")',
		[2] = 'Action.TargetActive("Larnaca Cyprus defenses", true)',
		[3] = 'Action.TemplateActive("Larnaca Turkish Assault Force 1 T1.stm")',
		[4] = 'Action.TargetActive("Larnaca Turkish Assault Force 1", true)',
		[5] = 'Action.Text("Larnaca Airbase is under attack by a Marines Turkish force. We must try to defend it")',
		[6] = 'Action.AddImage("LarnacaAttack.png")',
		},
	},
	["Larnaca Airbase Attack after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5)',
		action = {
		[1] = 'Action.TemplateActive("Larnaca Cyprus defenses T1.stm")',
		[2] = 'Action.TargetActive("Larnaca Cyprus defenses", true)',
		[3] = 'Action.TemplateActive("Larnaca Turkish Assault Force 1 T1.stm")',
		[4] = 'Action.TargetActive("Larnaca Turkish Assault Force 1", true)',
		[5] = 'Action.Text("Larnaca Airbase is under attack by a Marines Turkish force. We must try to defend it")',
		[6] = 'Action.AddImage("LarnacaAttack.png")',
		},
	},
	["Larnaca Airbase Captured"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 4) and (Return.TargetAlive("Larnaca Turkish Assault Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Larnaca Cyprus defenses T2.stm")',
		[2] = 'Action.TemplateActive("Larnaca Turkish Assault Force 1 T2.stm")',
		[3] = 'Action.SideBase("red", "Larnaca Airbase")',
		[4] = 'Action.Text("Larnaca Airbase has been captured by Turkish forces.")',
		[5] = 'Action.SetCampFlag(804, Return.Mission())',
		},
	},
	["Larnaca Airbase Captured after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 6) and (Return.TargetAlive("Larnaca Turkish Assault Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Larnaca Cyprus defenses T2.stm")',
		[2] = 'Action.TemplateActive("Larnaca Turkish Assault Force 1 T2.stm")',
		[3] = 'Action.SideBase("red", "Larnaca Airbase")',
		[4] = 'Action.Text("Larnaca Airbase has been captured by Turkish forces.")',
		[5] = 'Action.SetCampFlag(804, Return.Mission())',
		},
	},
	["Larnaca Airbase AA Defenses CORRECTION"] = {
		active = true,
		once = true,
		-- condition = 'Return.CampFlag(804) and (Return.Mission() == Return.CampFlag(804))',
		condition = 'Return.CampFlag(804)',
		action = {
		[1] = 'Action.TemplateActive("Larnaca Turkish AA T1.stm")',
		},
	},
	["Turkish Artillery Force 1 activation"] = {
		active = true,
		once = false,
		condition = 'Return.CampFlag(801) and (Return.Mission() > Return.CampFlag(801) + 1)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Artillery Force 1 T1.stm","Turkish Artillery Force 1 T2.stm","Turkish Artillery Force 1 T3.stm")',
		[2] = 'Action.TargetActive("Turkish Artillery Force 1", true)',
		[3] = 'Action.Text("A Turkish artillery battery is pounding Lakatamia Airbase, it seems to move often so it will be difficult to localize it")',
		[4] = 'Action.AddImage("TurkishArtillery.jpg")',
		},
	},
	["Turkish Artillery Force 1 activation after Greece involvement"] = {
		active = true,
		once = false,
		condition = 'Return.CampFlag(802) and (Return.Mission() > Return.CampFlag(802) + 5)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Artillery Force 1 T1.stm","Turkish Artillery Force 1 T2.stm","Turkish Artillery Force 1 T3.stm")',
		[2] = 'Action.TargetActive("Turkish Artillery Force 1", true)',
		[3] = 'Action.Text("A Turkish artillery battery is pounding Lakatamia Airbase, it seems to move often so it will be difficult to localize it")',
		[4] = 'Action.AddImage("TurkishArtillery.jpg")',
		},
	},
	["Helicopters Squadron 1 Move"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801)) and (Return.AirUnitBase("450 M-E/P-2") == "Lakatamia Airbase")',
		action = {		
		[1] = 'Action.AirUnitBase("450 M-E/P-2", "Paphos Airbase")',		
		[2] = 'Action.Text("After our initial victory over North Cyprus invaders, Turkish sent massive reinforcement to help their allies. We must retreat our frontline helicopters units to Paphos airbase")',
		},
	},
	["Helicopters Squadron 1 Move after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802)) and (Return.AirUnitBase("450 M-E/P-2") == "Lakatamia Airbase")',
		action = {		
		[1] = 'Action.AirUnitBase("450 M-E/P-2", "Paphos Airbase")',		
		[2] = 'Action.Text("North Cyprus columns are circling Lakatamia airbase. Despite Greece involvement we must retreat our frontline helicopters units to Paphos airbase")',
		},
	},
	["Helicopters Squadron 2 Move"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 1) and (Return.AirUnitBase("450 M-E/P-1") == "Lakatamia Airbase")',
		action = {
		[1] = 'Action.AirUnitBase("450 M-E/P-1", "Paphos Airbase")',			
		[2] = 'Action.Text("After our initial victory over North Cyprus invaders, Turkish sent massive reinforcement to help their allies. We must retreat our frontline helicopters units to Paphos airbase")',
		[3] = 'Action.SetCampFlag(803, Return.Mission())',
		},
	},
	["Helicopters Squadron 2 Move after Greece Involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 1) and (Return.AirUnitBase("450 M-E/P-1") == "Lakatamia Airbase")',
		action = {
		[1] = 'Action.AirUnitBase("450 M-E/P-1", "Paphos Airbase")',			
		[2] = 'Action.Text("North Cyprus columns are circling Lakatamia airbase. Despite Greece involvement we must retreat our frontline helicopters units to Paphos airbase")',
		[3] = 'Action.SetCampFlag(803, Return.Mission())',
		},
	},
	["Helicopters Squadron 2 near front move"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(803) and (Return.Mission() == Return.CampFlag(803) + 1) and (Return.AirUnitBase("450 M-E/P-1") == "Paphos Airbase")',
		action = {
		[1] = 'Action.AirUnitBase("450 M-E/P-1", "FARP-London")',			
		[2] = 'Action.Text("After our quick Paphos Airbase redeployment, we decided to use a mountain FARP to be closer from the frontline. FARP-London will be perfect for that. FARP_London position is 16 NM from EWR-Eyeball to 115°")',		
		},
	},
	["Turkish Naval Convoi 1 activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 2)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T1.stm")',
		[2] = 'Action.TargetActive("Turkish Naval Convoy 1", true)',
		[3] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy just lived Turkish coasts to rejoin south east port in Cyprus")',
		},
	},
	["Turkish Naval Convoi 1 mouvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 4) and (Return.TargetAlive("Turkish Naval Convoy 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T2.stm")',
		[2] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is near a Famagusta port in East Cyprus")',
		},
	},
	["Turkish Naval Convoi 1 in port"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 6) and (Return.TargetAlive("Turkish Naval Convoy 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T3.stm")',
		[2] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T1.stm")',
		[3] = 'Action.TargetActive("North Cyprus-Turkish Force 2", true)',
		[4] = 'Action.TemplateActive("Turkish Hawk Battery 2 T1.stm")',
		[5] = 'Action.TargetActive("Turkish Hawk Battery 2", true)',
		[6] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Famagusta port in East Cyprus")',
		[7] = 'Action.AddImage("NCTF2-1.png")',
		[8] = 'Action.SetCampFlag(805, Return.Mission())',
		},
	},
	["Turkish Naval Convoi 1 activation after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T1.stm")',
		[2] = 'Action.TargetActive("Turkish Naval Convoy 1", true)',
		[3] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy just lived Turkish coasts to rejoin south east port in Cyprus")',
		},
	},
	["Turkish Naval Convoi 1 mouvement after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Turkish Naval Convoy 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T2.stm")',
		[2] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is near Famagusta port in East Cyprus")',
		},
	},
	["Turkish Naval Convoi 1 in port after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 7) and (Return.TargetAlive("Turkish Naval Convoy 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 1 T3.stm")',
		[2] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T1.stm")',
		[3] = 'Action.TargetActive("North Cyprus-Turkish Force 2", true)',
		[4] = 'Action.TemplateActive("Turkish Hawk Battery 2 T1.stm")',
		[5] = 'Action.TargetActive("Turkish Hawk Battery 2", true)',
		[6] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Famagusta port in East Cyprus")',
		[7] = 'Action.AddImage("NCTF2-1.png")',
		[8] = 'Action.SetCampFlag(805, Return.Mission())',
		},
	},
	["North Cyprus-Turkish Force 2 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(805) and (Return.Mission() == Return.CampFlag(805) + 3) and (Return.TargetAlive("North Cyprus-Turkish Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T2.stm")',
		[2] = 'Action.Text("Heavy Turkish column 2 is still moving just south of Famagusta")',
		},
	},
	["North Cyprus-Turkish Force 2 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(805) and (Return.Mission() == Return.CampFlag(805) + 5) and (Return.TargetAlive("North Cyprus-Turkish Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T3.stm")',
		[2] = 'Action.Text("Heavy Turkish column 2 is still moving 5 nm East of Kingsfield airbase")',
		},
	},
	["North Cyprus-Turkish Force 2 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(805) and (Return.Mission() == Return.CampFlag(805) + 7) and (Return.TargetAlive("North Cyprus-Turkish Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T4.stm")',
		[2] = 'Action.Text("Heavy Turkish column 2 is still moving on the road between Kingsfield Airbase and Larnaca City")',
		},
	},
	["North Cyprus-Turkish Force 2 move 5"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(805) and (Return.Mission() == Return.CampFlag(805) + 9) and (Return.TargetAlive("North Cyprus-Turkish Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 2 T5.stm")',
		[2] = 'Action.Text("Heavy Turkish column 2 stopped moving in Larnaca city")',
		[3] = 'Action.AddImage("NCTF2-5.png")',
		},
	},
	["North Cyprus-Turkish Force 2 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus-Turkish Force 2") < 40',
		action = {
		[1] = 'Action.Text("Heavy Turkish column 2 took heavy losses and is stopped")',
		},
	},
	["Turkish Naval Convoi 2 activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 3)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T1.stm")',
		[2] = 'Action.TargetActive("Turkish Naval Convoy 2", true)',
		[3] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy just lived Turkish coasts to rejoin south east port in Cyprus")',
		},
	},
	["Turkish Naval Convoi 2 mouvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Turkish Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T2.stm")',
		[2] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is near Kyrenia port in North Cyprus")',
		},
	},
	["Turkish Naval Convoi 2 in port"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Turkish Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T3.stm")',
		[2] = 'Action.TemplateActive("North Cyprus-Turkish Force 3 T1.stm")',
		[3] = 'Action.TargetActive("North Cyprus-Turkish Force 3", true)',
		[4] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Kyrenia port in North Cyprus")',
		[5] = 'Action.AddImage("NCTF3-1.png")',
		[6] = 'Action.SetCampFlag(806, Return.Mission())',
		},
	},
	["Turkish Naval Convoi 2 activation after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 4)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T1.stm")',
		[2] = 'Action.TargetActive("Turkish Naval Convoy 2", true)',
		[3] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy just lived Turkish coasts to rejoin south east port in Cyprus")',
		},
	},
	["Turkish Naval Convoi 2 mouvement after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 6) and (Return.TargetAlive("Turkish Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T2.stm")',
		[2] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is near Kyrenia port in North Cyprus")',
		},
	},
	["Turkish Naval Convoi 2 in port after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 8) and (Return.TargetAlive("Turkish Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Turkish Naval Convoy 2 T3.stm")',
		[2] = 'Action.TemplateActive("North Cyprus-Turkish Force 3 T1.stm")',
		[3] = 'Action.TargetActive("North Cyprus-Turkish Force 3", true)',
		[4] = 'Action.Text("Turkish naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Kyrenia port in North Cyprus")',
		[5] = 'Action.AddImage("NCTF3-1.png")',
		[6] = 'Action.SetCampFlag(806, Return.Mission())',
		},
	},
	["North Cyprus-Turkish Force 3 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(806) and (Return.Mission() == Return.CampFlag(806) + 3) and (Return.TargetAlive("North Cyprus-Turkish Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 3 T2.stm")',
		[2] = 'Action.Text("Heavy Turkish column 3 is still moving on the main road south of Pinarbashi Airbase")',
		},
	},
	["North Cyprus-Turkish Force 3 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(806) and (Return.Mission() == Return.CampFlag(806) + 5) and (Return.TargetAlive("North Cyprus-Turkish Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 3 T3.stm")',
		[2] = 'Action.Text("Heavy Turkish column 3 is still moving on the main road 15 nm west of Nicosia")',
		},
	},
	["North Cyprus-Turkish Force 3 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(806) and (Return.Mission() == Return.CampFlag(806) + 7) and (Return.TargetAlive("North Cyprus-Turkish Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 3 T4.stm")',
		[2] = 'Action.Text("Heavy Turkish column 3 stopped moving in Morphon City 20nm west of Nicosia")',
		[3] = 'Action.AddImage("NCTF3-4.png")',
		},
	},
	["North Cyprus-Turkish Force 3 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Cyprus-Turkish Force 3") < 40',
		action = {
		[1] = 'Action.Text("Heavy Turkish column 3 took heavy losses and is stopped")',
		},
	},
	["Turkish CAP activation CORRECTION"] = {
		active = true,
		once = true,
		-- condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801))',
		condition = 'Return.CampFlag(801)',
		action = {
		[1] = 'Action.TargetActive("CAP Cyprus", true)',
		[2] = 'Action.Text("It seems that enemy aircraft CAP are active over North part of Cyprus")',
		},
	},
	["Turkish CAP activation after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3)',
		action = {
		[1] = 'Action.TargetActive("CAP Cyprus", true)',
		[2] = 'Action.Text("It seems that enemy aircraft CAP are active over North part of Cyprus")',
		},
	},
	["Greek Air Force interception activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 1)',
		action = {
		[1] = 'Action.AirUnitActive("EC 331", true)',
		[2] = 'Action.TargetActive("Paphos Airbase Alert", true)',
		[3] = 'Action.TargetActive("Paphos Airbase Alert 2", true)',
		[4] = 'Action.TargetActive("Paphos Airbase Alert 3", true)',
		[5] = 'Action.Text("Greek Air Force sent EC 331 with its Mirage 2000C to protect Cyprus")',
		},
	},
	["Nord Cyprus Stinger Reinforcement activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 1)',
		action = {
		[1] = 'Action.TemplateActive("Nord Cyprus Stinger Reinforcement.stm")',
		[2] = 'Action.Text("Intels advice all our forces that large number of Stinger manpads were spread all over the Pro-Turkish territory so fly very carefully to avoid cities where they should try to ambush you")',
		},
	},
	["Nord Cyprus Stinger Reinforcement activation after Greece involvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 2)',
		action = {
		[1] = 'Action.TemplateActive("Nord Cyprus Stinger Reinforcement.stm")',
		[2] = 'Action.Text("Intels advice all our forces that large number of Stinger manpads were spread all over the Pro-Turkish territory so fly very carefully to avoid cities where they should try to ambush you")',
		},
	},
	["North Cyprus-Turkish Force 4 airborn Stats"] = {
        active = true,
        once = false,
        condition = 'Return.PlaceLogistic("Ercan Airbase") < 60000 ',
        action = {
        [1] = 'Action.LogisticObjectif("Ercan Airbase", 60000)',
        },
    },
	["North Cyprus-Turkish Force 4 airborn activation"] = {
        active = true,
        once = true,
        condition = 'Return.PlaceLogistic("Ercan Airbase") > 60000 and (Return.CampFlag(801) > 0 or Return.CampFlag(802) > 0)',
        action = {
        [1] = 'Action.TemplateActive("North Cyprus-Turkish Force 4 T1.stm")',
		[2] = 'Action.TargetActive("North Cyprus-Turkish Force 4", true)',
		[3] = 'Action.Text("Heavy Turkish Force 4 is readying in Ercan airbase")',
		[4] = 'Action.AddImage("NCTF4-1.png")',
		[5] = 'Action.SetCampFlag(807, Return.Mission())',
        },
    },
	["North Cyprus-Turkish Force 4 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(807) and (Return.Mission() == Return.CampFlag(807) + 3) and (Return.TargetAlive("North Cyprus-Turkish Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 4 T2.stm")',
		[2] = 'Action.Text("Heavy Turkish column 4 is still moving few nm south west of Ercan Airbase")',
		},
	},
	["North Cyprus-Turkish Force 4 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(807) and (Return.Mission() == Return.CampFlag(807) + 5) and (Return.TargetAlive("North Cyprus-Turkish Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("North Cyprus-Turkish Force 4 T3.stm")',
		[2] = 'Action.Text("Heavy Turkish column 4 stopped moving along a river 6 nm south east of Lakatamia airbase")',
		[3] = 'Action.AddImage("NCTF4-3.png")',
		},
	},
	["Greek Naval Convoy activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 3)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T1.stm")',
		[2] = 'Action.TargetActive("Greek Naval Convoy", true)',
		[3] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy mouvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 5) and (Return.TargetAlive("Greek Naval Convoy") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T2.stm")',
		[2] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy in port"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 7) and (Return.TargetAlive("Greek Naval Convoy") > 40)',
		-- condition = 'Return.Mission() == 1',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T3.stm")',
		[2] = 'Action.TemplateActive("Greek Expeditionary Force 1 T1.stm")',
		[3] = 'Action.TargetActive("Greek Expeditionary Force 1", true)',
		[4] = 'Action.TemplateActive("Greek Hawk Battery 1 T1.stm")',
		[5] = 'Action.TargetActive("Greek Hawk Battery 1", true)',
		[6] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops and a Hawk battery in Paphos harbor")',
		[7] = 'Action.AddImage("GEF1-1.png")',
		[8] = 'Action.SetCampFlag(808, Return.Mission())',
		},
	},
	["Greek Naval Convoy activation after NCF victory CORRECTION"] = {
		active = true,
		once = true,
		-- condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802))',
		condition = 'Return.CampFlag(802)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T1.stm")',
		[2] = 'Action.TargetActive("Greek Naval Convoy", true)',
		[3] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy mouvement after NCF victory"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 2) and (Return.TargetAlive("Greek Naval Convoy") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T2.stm")',
		[2] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy in port after NCF victory"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 4) and (Return.TargetAlive("Greek Naval Convoy") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy T3.stm")',
		[2] = 'Action.TemplateActive("Greek Expeditionary Force 1 T1.stm")',
		[3] = 'Action.TargetActive("Greek Expeditionary Force 1", true)',
		[4] = 'Action.TemplateActive("Greek Hawk Battery 1 T1.stm")',
		[5] = 'Action.TargetActive("Greek Hawk Battery 1", true)',
		[6] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops and a Hawk battery in Paphos harbor")',
		[7] = 'Action.AddImage("GEF1-1.png")',
		[8] = 'Action.SetCampFlag(808, Return.Mission())',
		},
	},	
	["Greek Expeditionary Force 1 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(808) and (Return.Mission() == Return.CampFlag(808) + 3) and (Return.TargetAlive("Greek Expeditionary Force 1") > 40)',
		-- condition = 'Return.Mission() == 2',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 1 T2.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 1 is still moving ")',
		},
	},
	["Greek Expeditionary Force 1 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(808) and (Return.Mission() == Return.CampFlag(808) + 5) and (Return.TargetAlive("Greek Expeditionary Force 1") > 40)',
		-- condition = 'Return.Mission() == 3',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 1 T3.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 1 is still moving ")',
		},
	},
	["Greek Expeditionary Force 1 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(808) and (Return.Mission() == Return.CampFlag(808) + 7) and (Return.TargetAlive("Greek Expeditionary Force 1") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 1 T4.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 1 stopped 20 nm West of Nicosia ")',
		[3] = 'Action.AddImage("GEF1-4.png")',
		},
	},
	["Greek Expeditionary Force 1 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Greek Expeditionary Force 1") < 40',
		action = {
		[1] = 'Action.Text("Greek Expeditionary column 1 took heavy losses and is stopped")',
		},
	},
	["Greek Naval Convoy 2 activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 4)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T1.stm")',
		[2] = 'Action.TargetActive("Greek Naval Convoy 2", true)',
		[3] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy 2 mouvement"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 6) and (Return.TargetAlive("Greek Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T2.stm")',
		[2] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy 2 in port"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 8) and (Return.TargetAlive("Greek Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T3.stm")',
		[2] = 'Action.TemplateActive("Greek Expeditionary Force 2 T1.stm")',
		[3] = 'Action.TargetActive("Greek Expeditionary Force 2", true)',
		[4] = 'Action.TemplateActive("Greek Expeditionary Force 3 T1.stm")',
		[5] = 'Action.TargetActive("Greek Expeditionary Force 3", true)',
		[6] = 'Action.TemplateActive("Greek Limassol defenses T1.stm")',
		[7] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Limassol harbor")',
		[8] = 'Action.AddImage("GEF2-3-1.png")',
		[9] = 'Action.SetCampFlag(809, Return.Mission())',
		},
	},
	["Greek Naval Convoy 2 activation after NCF victory"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 1)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T1.stm")',
		[2] = 'Action.TargetActive("Greek Naval Convoy 2", true)',
		[3] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},	
	["Greek Naval Convoy 2 mouvement after NCF victory"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 3) and (Return.TargetAlive("Greek Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T2.stm")',
		[2] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus.")',
		},
	},
	["Greek Naval Convoy 2 in port after NCF victory"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(802) and (Return.Mission() == Return.CampFlag(802) + 5) and (Return.TargetAlive("Greek Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Naval Convoy 2 T3.stm")',
		[2] = 'Action.TemplateActive("Greek Expeditionary Force 2 T1.stm")',
		[3] = 'Action.TargetActive("Greek Expeditionary Force 2", true)',
		[4] = 'Action.TemplateActive("Greek Limassol defenses T1.stm")',
		[5] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Limassol harbor")',
		[6] = 'Action.AddImage("GEF2-1.png")',
		[7] = 'Action.SetCampFlag(809, Return.Mission())',
		},
	},
	["Greek Expeditionary Force 2 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(809) and (Return.Mission() == Return.CampFlag(809) + 3) and (Return.TargetAlive("Greek Expeditionary Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 2 T2.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 2 is still moving ")',
		},
	},
	["Greek Expeditionary Force 2 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(809) and (Return.Mission() == Return.CampFlag(809) + 5) and (Return.TargetAlive("Greek Expeditionary Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 2 T3.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 2 is still moving ")',
		},
	},
	["Greek Expeditionary Force 2 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(809) and (Return.Mission() == Return.CampFlag(809) + 7) and (Return.TargetAlive("Greek Expeditionary Force 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 2 T4.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 2 stopped 5nm west of Larnaca City ")',
		[3] = 'Action.AddImage("GEF2-4.png")',
		},
	},
	["Greek Expeditionary Force 2 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Greek Expeditionary Force 2") < 40',
		action = {
		[1] = 'Action.Text("Greek Expeditionary column 2 took heavy losses and is stopped")',
		},
	},
	["Greek Expeditionary Force 3 Activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(809) and (Return.Mission() == Return.CampFlag(809) + 1) and (Return.TargetAlive("Greek Naval Convoy 2") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 3 T1.stm")',
		[2] = 'Action.TargetActive("Greek Expeditionary Force 3", true)',		
		[3] = 'Action.Text("Greek naval forces are shipping reinforcement to Cyprus. One convoy is unloading troops in Limassol harbor")',
		[4] = 'Action.AddImage("GEF2-3-1.png")',
		[5] = 'Action.SetCampFlag(810, Return.Mission())',
		},
	},
	["Greek Expeditionary Force 3 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(810) and (Return.Mission() == Return.CampFlag(810) + 2) and (Return.TargetAlive("Greek Expeditionary Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 3 T2.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 3 is still moving ")',
		},
	},
	["Greek Expeditionary Force 3 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(810) and (Return.Mission() == Return.CampFlag(810) + 4) and (Return.TargetAlive("Greek Expeditionary Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 3 T3.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 3 is still moving ")',
		},
	},
	["Greek Expeditionary Force 3 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(810) and (Return.Mission() == Return.CampFlag(810) + 6) and (Return.TargetAlive("Greek Expeditionary Force 3") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 3 T4.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 3 stopped 5nm south west of Larnaca Airbase")',
		[3] = 'Action.AddImage("GEF3-4.png")',
		},
	},
	["Greek Expeditionary Force 3 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Greek Expeditionary Force 3") < 40',
		action = {
		[1] = 'Action.Text("Greek Expeditionary column 3 took heavy losses and is stopped")',
		},
	},
	["Greek Expeditionary Force 4 airborn Stats"] = {
        active = true,
        once = false,
        condition = 'Return.PlaceLogistic("Paphos Airbase") < 60000 ',
        action = {
        [1] = 'Action.LogisticObjectif("Paphos Airbase", 60000)',
        },
    },
	["Greek Expeditionary Force 4 airborn activation"] = {
        active = true,
        once = true,
        condition = 'Return.PlaceLogistic("Paphos Airbase") > 60000 and (Return.CampFlag(801) > 0 or Return.CampFlag(802) > 0)',
        action = {
        [1] = 'Action.TemplateActive("Greek Expeditionary Force 4 T1.stm")',
		[2] = 'Action.TargetActive("Greek Expeditionary Force 4", true)',
		[3] = 'Action.Text("Greek Expeditionary Force 4 is readying in Paphos airbase")',
		[4] = 'Action.AddImage("GEF4-1.png")',
		[5] = 'Action.SetCampFlag(811, Return.Mission())',
        },
    },
	["Greek Expeditionary Force 4 move 2"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(811) and (Return.Mission() == Return.CampFlag(811) + 2) and (Return.TargetAlive("Greek Expeditionary Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 4 T2.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 4 is still moving ")',
		},
	},
	["Greek Expeditionary Force 4 move 3"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(811) and (Return.Mission() == Return.CampFlag(811) + 4) and (Return.TargetAlive("Greek Expeditionary Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 4 T3.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 4 is still moving ")',
		},
	},
	["Greek Expeditionary Force 4 move 4"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(811) and (Return.Mission() == Return.CampFlag(811) + 6) and (Return.TargetAlive("Greek Expeditionary Force 4") > 40)',
		action = {
		[1] = 'Action.TemplateActive("Greek Expeditionary Force 4 T4.stm")',
		[2] = 'Action.Text("Greek Expeditionary column 4 is Stopped 5 nm south west of Lakatamia airbase")',
		[3] = 'Action.AddImage("GEF4-1.png")',
		},
	},
	["Greek Expeditionary Force 4 stop"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Greek Expeditionary Force 4") < 40',
		action = {
		[1] = 'Action.Text("Greek Expeditionary column 4 took heavy losses and is stopped")',
		},
	},
	

	----- AIRBASE STRIKES -----
	-- ["Lar Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Lar Airbase") < 4 and Return.TargetAlive("Lar Airbase Strategics") < 4',
		-- action = {
			-- [1] = 'db_airbases["Lar Airbase"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Lar Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },
	-- ["Abu Musa Island Airport Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Abu Musa Island Airport") < 2 and Return.TargetAlive("Abu Musa Island Airport Strategics") < 4',
		-- action = {
			-- [1] = 'db_airbases["Abu Musa Island Airport"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Abu Musa Island Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },	
	-- ["Sirri Island Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Sirri Island") < 3 and Return.TargetAlive("Sirri Island Airport Strategics") < 3',
		-- action = {
			-- [1] = 'db_airbases["Sirri Island"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Sirri Island Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },
	-- ["Havadarya Airport Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Havadarya") < 4 and Return.TargetAlive("Havadarya Airport Strategics") < 7',
		-- action = {
			-- [1] = 'db_airbases["Havadarya"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Havadarya Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },
	-- ["Bandar Abbas Intl Disabled"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.TargetAlive("Bandar Abbas Intl") < 6 and Return.TargetAlive("Bandar Abbas Intl Strategics") < 14',
		-- action = {
			-- [1] = 'db_airbases["Bandar Abbas Intl"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Bandar Abbas Intl have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
			-- [3] = 'Action.AddImage("Bandar Abbas.jpg", "blue")',
		-- }
	-- },
	
	----- RED CAP -----
	-- ["CAP After EWR Destroyed"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.TargetAlive("EWR 1 131") == 0 and Return.TargetAlive("EWR 2 132") == 0 and Return.TargetAlive("EWR 3 133") == 0',
		-- action = {
			-- [1] = 'Action.TargetActive("CAP Qeshm", true)',
			-- [2] = 'Action.TargetActive("CAP Islands", true)',
			-- [3] = 'Action.TargetActive("Lar Airbase Alert", false)',
			-- [4] = 'Action.TargetActive("Shiraz Intl Alert", false)',
			-- [5] = 'Action.TargetActive("Sirri Island Alert", false)',
			-- [6] = 'Action.TargetActive("Qeshm Island Alert", false)',
			-- [7] = 'Action.TargetActive("Bandar Abbas Intl Alert", false)',
			-- [8] = 'Action.TargetActive("Bandar Abbas Intl 100 Km Alert", false)',
			-- [9] = 'Action.TargetActive("CAP Bandar Abbas", true)',
			-- [10] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		-- },
	-- },
----- BLUE CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR-Eyeball") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP-1-Greek", true)',
			[2] = 'Action.TargetActive("Paphos Airbase Alert", false)',
			[3] = 'Action.TargetActive("Paphos Airbase Alert 2", false)',
			[4] = 'Action.TargetActive("Paphos Airbase Alert 3", false)',
			[5] = 'Action.Text("With the recent destruction of our Early Warning Radar site we are not able to maintain Interceptions alerts on Paphos Airbase anymore . We will depend on Combat Air Patrols to compensate, though without the support of ground controllers these will be of limited effectiveness.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["Reinforce 450 M-E/P-1"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/450 M-E/P-1", "450 M-E/P-1", 6)',
	},	
	["Reinforce EC 331"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("EC 332", "EC 331", 8)',
	},
	["Reinforce 450 M-E/P-2"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/450 M-E/P-2", "450 M-E/P-2", 4)',
	},	
	["Reinforce 356th Tactical Transport Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/356th Tactical Transport Squadron", "356th Tactical Transport Squadron", 2)',
	},	
	["Reinforce 347th Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/347th Squadron", "347th Squadron", 8)',
	},
	["Reinforce 3rd KHA"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/3rd KHA", "3rd KHA", 6)',
	},
	["Reinforce 152 Filo"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/152 Filo", "152 Filo", 12)',
	},
	["Reinforce 222.Filo"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/222.Filo", "222.Filo", 6)',
	},
	["Reinforce 2nd KHA"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/2nd KHA", "2nd KHA", 2)',
	},
	["Reinforce 111.Filo"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/111.Filo", "111.Filo", 8)',
	},	
	-- ["Reinforce VFA-106"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/VFA-106", "VFA-106", 16)',
	-- },	
	-- ["Reinforce VF-101"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/VF-101", "VF-101", 16)',
	-- },
	-- ["Reinforce VF-32"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/VF-32", "VF-32", 16)',
	-- },	
	-- ["Reinforce 81 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("82 TFS", "81 TFS", 4)',
	-- },
	-- ["Reinforce 23 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("11 TFS", "23 TFS", 4)',
	-- },
	-- ["Reinforce 91 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("31 TFS", "91 TFS", 4)',
	-- },
	-- ["Reinforce 41 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("141 TFS", "41 TFS", 4)',
	-- },
	-- ["Reinforce 72 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("73 TFS", "72 TFS", 6)',
	-- },
	-- ["Reinforce 51 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("52 TFS", "51 TFS", 4)',
	-- },
	-- ["Reinforce 21 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("22 TFS", "21 TFS", 4)',
	-- },
	-- ["Reinforce 21-2 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("22-2 TFS", "21-2 TFS", 4)',
	-- },
	-- ["Reinforce 83 TFS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("84 TFS", "83 TFS", 4)',
	-- },	
	

	----- AVIATION UNIT STATUS -----
	-- ["13 TFS Alive 75%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("13 TFS") + Return.AirUnitReady("R/13 TFS") < 8',
		-- action = 'Action.Text("Aircraft strength of the 13 TFS has fallen below 75%.")',
	-- },
	-- ["13 TFS Alive 50%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("13 TFS") + Return.AirUnitReady("R/13 TFS") < 6',
		-- action = 'Action.Text("Aircraft strength of the 13 TFS has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	-- },
	-- ["13 TFS Alive 25%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("13 TFS") + Return.AirUnitReady("R/13 TFS") < 5',
		-- action = 'Action.Text("Aircraft strength of the 13 TFS has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	-- },
	-- ["Newspaper Nighthawk Down"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("417 TFS") < 4',
		-- action = {
			-- [1] = 'Action.AddImage("Newspaper_NighthawkDown.jpg", "blue")',
			-- [2] = 'NoMoreNewspaper = true',
		-- },
	-- },
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
		
}