--[[A variation of DOL's B29 mod that depicts a Tu-4. 
--All credit and thanks should be given to DOL as without his hardwork the DCS community 
--would not have it's first WW2/Korean bomber See DOL's work at http://virtualcockpits.web.fc2.com/

Defensive armaments
 2 x 23 mm NR-23 cannon, front dorsal turret (275 rpg = 550 total) 
 2 x 23 mm NR-23 cannon, front ventral turret (250 rpg = 500 total) 
 2 x 23 mm NR-23 cannon, rear dorsal turret (275 rpg = 550 total) 
 2 x 23 mm NR-23 cannon, rear ventral turret (500 rpg = 1,000 total) 
 2 x 23 mm NR-23 cannon, tail turret (275 rpg = 550 total) 

Payloads
 *48 x 50 kg FAB-50
 *48 x 100 kg FAB-100 (forged) bombs 
 *40 x 250 kg FAB-250M43 bombs 
 *12 x 500 kg FAB-500 (welded) bombs 
 8 x 1000 kg FAB-1000 (welded) bombs (N/a in DCS World)
 *8 x 1500 kg FAB-1500M-46 bombs 
 4 x 3000 kg FAB-3000M-46 bombs (N/a in DCS World)

	
DOL's Permission via PM:
================================================================================
From :	DOL
To :	Stonehouse
Date :	2016-06-16 00:54
Title :	Re: B29/Tu4
--------------------------------------------------------------------------------
[QUOTE=Stonehouse]Hi DOL,
 Hope you are well. Someone has asked if I could change the lua for the B29 to make a Tu-4 variant of your mod. I said the B29 is yours and I would want to ask permission before doing so and posting it up. 
  
 Would you be ok with this as long as all credit for the Tu-4 went to you only?
  
 Thanks and best regards,
 Stonehouse[/QUOTE]

That's OK. 
Good luck. 

DOL

CrazyEddie's Permission via PM:
================================================================================
From :	crazyeddie
To :	Stonehouse
Date :	2016-07-06 17:37
Title :	Re: B29 Russian Tu4
--------------------------------------------------------------------------------
[QUOTE=Stonehouse]Hi Eddie,
 Finally getting around to the Tu4 now while waiting for Mario to get to the stage where he needs me to work on the C47. 
 Generally it is going well although getting the custom 23 mm guns to work is turning out to be a pain. 
 Question for you however, are you ok with me including the Tu4 skin you did in the eventual bundle that gets released as long as it credits you for the skin in the main lua file and readme (if I do one) ? 
  
 The credit for the aircraft itself will go to DOL as that was my agreement with him in exchange for permission to clone his work. My name won't appear.[/QUOTE]

No problem at all Stonehouse, happy for you to use it in the bundle in any way you can.

Eddie
	
--]]
mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path  (current_mod_path.."/Textures")
mount_vfs_texture_path  (current_mod_path.."/Textures/Tu-4.zip")
mount_vfs_liveries_path (current_mod_path.."/Liveries")

declare_weapon({category = CAT_SHELLS,name =   "NR23_HEI_T",
  user_name		 = _("NR23_23x115_HEI_T"),
  model_name     = "tracer_bullet_crimson",
  v0    		 = 680,
  Dv0   		 = 0.0050,
  Da0     		 = 0.0007,
  Da1     		 = 0.0,
  mass      	 = 0.196,
  round_mass 	 = 0.340+0.071,		-- round + link
  cartridge_mass = 0.0,				-- 0.111+0.071, cartridges are ejected
  explosive      = 0.011,
  life_time      = 5.0,
  caliber        = 23.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx        	 = {1.0,0.74,0.65,0.150,1.78},
  k1        	 = 2.3e-08,
  tracer_off     = 1.5,
  tracer_on		 = 0.02,
  scale_tracer   = 1,
  scale_smoke    = 0, 
  smoke_tail_life_time = 0,
  cartridge		 = 0,
})

declare_weapon({category = CAT_SHELLS,name =   "NR23_API",
  user_name		 = _("NR23_23x115_API"),
  model_name     = "tracer_bullet_crimson",
  v0    		 = 680,
  Dv0   		 = 0.0050,
  Da0     		 = 0.0007,
  Da1     		 = 0.0,
  mass      	 = 0.199,
  round_mass 	 = 0.340+0.071,		-- round + link
  cartridge_mass = 0.0,				-- 0.111+0.071, cartridges are ejected
  explosive      = 0.000,
  life_time      = 5.0,
  caliber        = 37.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx        	 = {1.0,0.74,0.65,0.150,1.78},
  k1        	 = 2.3e-08,
  tracer_off     = -1,
  tracer_on		 = 0.02,
  scale_tracer   = 1,
  scale_smoke    = 0, 
  smoke_tail_life_time = 0,
  cartridge		 = 0,
})

function nr_23(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "NR-23"
	tbl.display_name	= "NR-23"
	tbl.supply 	 = 
	{
		shells = {"NR23_HEI_T","NR23_API"},
		mixes  = {{1,2,2,1,2,2}}, --  
		count  = 80,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 20,
		rates 			 = {850},
		recoil_coeff 	 = 1,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= tbl.ejector_dir or {0,2,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= true
	tbl.effective_fire_distance = 1000
	tbl.drop_cartridge 			= 0		-- shell_50cal
	tbl.muzzle_pos				= {0,0,0}	-- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	return declare_weapon(tbl)
end


--[[
    GSH23_HET = {
        category = CAT_SHELLS, name = "GSH23 HE_T", user_name = _("GSH23 HE_T"),
        model_name      = "tracer_bullet_yellow",
        mass            = 0.175,
        round_mass      = 0.44,
        --cartridge_mass  = 0.158,    -- cartridges retained
        explosive       = 0.175,
        v0              = 715.0,   -- 3350 fps
        Dv0             = 0.0050,
        Da0             = 0.0007,
        Da1             = 0.0,
        life_time       = 6,
        caliber         = 23.0,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {1.0,0.74,0.65,0.150,1.78},
        k1              = 2.3e-08,
        tracer_off      = 4,
        tracer_on       = 0.01,
        smoke_tail_life_time = 0,
        scale_tracer    = 1,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity
    }
    declare_weapon(GSH23_HET)

    -- Gsh23mm gun
function Gsh23(tbl)
    tbl.category = CAT_GUN_MOUNT
    tbl.name      = "Gsh23"
    tbl.supply      =
    {
        shells = {"GSH23_HET"},
        mixes  = {{1}},   -- 50% HE-i, 25% AP-I, 25% AP-T
        count  = 750,
    }
    if tbl.mixes then
       tbl.supply.mixes = tbl.mixes
       tbl.mixes        = nil
    end
    tbl.gun =
    {
        max_burst_length    = 25,
        rates               = {3400},
        recoil_coeff        = 0.7*1.3,
        barrels_count       = 1,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = tbl.ejector_pos or {0, 0, 0}
    tbl.ejector_pos_connector   = tbl.ejector_pos_connector     or  "Gun_point"
    tbl.ejector_dir             = {-1, -6, 0} -- left/right; back/front;?/?
    tbl.supply_position         = tbl.supply_position   or {0,  0.3, -0.3}
    tbl.aft_gun_mount           = true
    tbl.effective_fire_distance = 1500
    tbl.drop_cartridge          = 0
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {2.5,-0.4,0}     -- all position from connector
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  "Gun_point" -- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  0

 --if  tbl.effects == nil then
  --      tbl.effects = {{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
   --                    { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
    --                   { name = "SmokeEffect"}}
    --end

    return declare_weapon(tbl)
end
--]]
local FAB_50 = {
	category  = CAT_BOMBS,
	name      = "FAB_50",
	model     = "fab50_40x",
	user_name = _("FAB-50"),
	wsTypeOfWeapon = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
	scheme    = "bomb-common",
	type      = 0,
    mass      = 50.0,
    hMin      = 1000.0,
    hMax      = 12000.0,
    Cx        = 0.00035,
    VyHold    = -100.0,
    Ag        = -1.23,

	fm = {
        mass        = 50,  -- empty weight with warhead, wo fuel, kg
        caliber     = 0.200,  -- Caliber, meters 
        cx_coeff    = {1, 0.39, 0.38, 0.236, 1.31}, -- Cx
        L           = 1.040, -- Length, meters 
        I           = 4.507, -- kgm2 - moment of inertia  I = 1/12 ML2
        Ma          = 0.667,  -- dependence moment coefficient of  by  AoA angular acceleration  T / I
        Mw          = 1.094, --  rad/s  - 57.3/s - dependence moment coefficient by angular velocity (|V|*sin(?))/|r| -  Mw  =  Ma * t
        
        wind_sigma  = 10, -- dispersion coefficient
  
        cx_factor   = 100,
    },
  
	warhead = {
		mass                 = 25,
		expl_mass            = 25,
		other_factors        = {1, 1, 1},
		obj_factors          = {1, 1},
		concrete_factors     = {1, 1, 1},
		cumulative_factor    = 0,
		concrete_obj_factor  = 0,
		cumulative_thickness = 0,
		piercing_mass        = 5,
		caliber              = 200,
	},

	-- velK is calibrated to get arming time of 0.8 seconds at initial bomb speed of 150 m/s (540 km/h)
	arming_vane = {enabled = true, velK = 0.00834},
	-- overriding default setting (delay is enabled for all bombs by default)
	arming_delay = {enabled = false, delay_time = 0},
	
	shape_table_data = {
		{
			name     = "FAB_50",
			file     = "fab50_40x",
			life     = 1,
			fire     = {0, 1},
			username = "FAB-50",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
 
	targeting_data = {
		char_time = 20.87, -- characteristic time for sights 
	},
}
declare_weapon(FAB_50)

local FAB_100M = {
	category  = CAT_BOMBS,
	name      = "FAB_100M",
	model     = "fab100_40x",
	user_name = _("FAB-100M"),
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Bomb,wsType_Bomb_A,WSTYPE_PLACEHOLDER},
	scheme    = "bomb-common",
	type      = 0,
    mass      = 100.0,
    hMin      = 1000.0,
    hMax      = 12000.0,
    Cx        = 0.00035,
    VyHold    = -100.0,
    Ag        = -1.23,

	fm = {
        mass        = 100,  -- empty weight with warhead, wo fuel, kg
        caliber     = 0.280,  -- Caliber, meters 
        cx_coeff    = {1, 0.39, 0.38, 0.236, 1.31}, -- Cx
        L           = 1.040, -- Length, meters 
        I           = 9.0133, -- kgm2 - moment of inertia  I = 1/12 ML2
        Ma          = 0.68,  -- dependence moment coefficient of  by  AoA angular acceleration  T / I
        Mw          = 1.116, --  rad/s  - 57.3/s - dependence moment coefficient by angular velocity (|V|*sin(?))/|r| -  Mw  =  Ma * t
        
        wind_sigma  = 20, -- dispersion coefficient
  
        cx_factor   = 100,
    },
  
	warhead = {
		mass                 = 45,
		expl_mass            = 45,
		other_factors        = {1, 1, 1},
		obj_factors          = {1, 1},
		concrete_factors     = {1, 1, 1},
		cumulative_factor    = 0,
		concrete_obj_factor  = 0,
		cumulative_thickness = 0,
		piercing_mass        = 9,
		caliber              = 280,
	},
  
    -- velK is calibrated to get arming time of 0.8 seconds at initial bomb speed of 150 m/s (540 km/h)
	arming_vane = {enabled = true, velK = 0.00834},
	-- overriding default setting (delay is enabled for all bombs by default)
	arming_delay = {enabled = false, delay_time = 0},
	
	shape_table_data = {
		{
			name     = "FAB_100M",
			file     = "fab100_40x",
			life     = 1,
			fire     = {0, 1},
			username = "FAB-100M",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
 
	targeting_data = {
		char_time = 20.84, -- characteristic time for sights 
	},
}

declare_weapon(FAB_100M)

declare_loadout(
{
	category 		= CAT_BOMBS,
	CLSID	 		= "FAB_100Mx12",
	attribute		= FAB_100M.wsTypeOfWeapon,
	Count 			= 12,
	Cx_pil			= FAB_100M.Cx,
	Picture			= "fab100.png",
	displayName		= _("12 FAB-100M"),
	Weight			= FAB_100M.mass*12,
	Elements  = {
		{
			ShapeName = "fab100_40x",
		}, 
	},
}
)

declare_loadout(
{
	category 		= CAT_BOMBS,
	CLSID	 		= "FAB_50_12",
	attribute		= FAB_50.wsTypeOfWeapon,
	Count 			= 12,
	Cx_pil			= FAB_50.Cx,
	Picture			= "fab100.png",		-- TODO: "FAB50.png",
	displayName		= _("12 FAB-50"),
	Weight			= FAB_50.mass*12,
	Elements  = {
		{
			ShapeName = "fab50_40x",
		}, 
	},
}
)

FAB_250_10 = 
{
	CLSID        = "FAB_250_10",
	category     = CAT_BOMBS,
	Picture	=	"fab250.png",
	attribute	=	{4,	5,	9,	6},
	displayName	=	_("10 FAB-250"),
	Count	=	10,
	Weight	=	2500,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"fab-250-n1",
		}, 
	}, -- end of Elements
}
declare_loadout(FAB_250_10)

FAB_500_3 = 
{
	CLSID        = "FAB_500_3",
	category     = CAT_BOMBS,
	Picture	=	"fab500.png",
	attribute	=	{4,	5,	9,	7},
	displayName	=	_("3 FAB-500"),
	Count	=	3,
	Weight	=	1500,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"fab-500-n3",
		}, 
	}, -- end of Elements
}
declare_loadout(FAB_500_3)

FAB_1500_2 = 
{
	CLSID        = "FAB_1500_2",
	category     = CAT_BOMBS,
	Picture	=	"FAB1500.png",
	attribute	=	{4,	5,	9,	9},
	displayName	=	_("2 FAB 1500"),
	Count	=	2,
	Weight	=	3000,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"FAB-1500",
		}, 
	}, -- end of Elements
}
declare_loadout(FAB_1500_2)

Tu_4 = 
{
	Name 				=   'Tu-4',
	DisplayName			= _('Tu-4'),
--	HumanCockpit 		= false,
	Picture 			= current_mod_path.."/ImagesGui/Tu-4.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "B-29",
	shape_table_data 	= 
	{
		{
			file  	 = 'B-29';
			life  	 = 250; -- lifebar
			vis   	 = 4; -- visibility gain.
			desrt    = 'B-29_destr'; -- Name of destroyed object file name
			fire  	 = { 500, 4}; -- Fire on the ground after destoyed: 500sec 4m
			username = 'Tu-4';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "B-29_destr";
			file  = "B-29-destr";
			fire  = { 500, 4};
		},

	},
	mapclasskey = "P0091000027",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Intruder, WSTYPE_PLACEHOLDER , "Strategic bombers"},
	Categories 			= {},

	-------------------------
	M_empty 					= 31298, -- kg
	M_nominal 					= 54431, -- kg
	M_max 						= 61235, -- kg
	M_fuel_max 					= 22371, -- kg
	length 						= 30.2, -- full length in m
	height 						= 8.5, -- height in m
	wing_area 					= 161.3, -- wing area in m2
	wing_span 					= 43.1, -- wing span in m
	wing_type 					= 0,
	wing_tip_pos 				=  {3,	1.5, 21.65}, -- wingtip coords for visual effects
	nose_gear_pos 				= {12.448,	-2.587,	0}, -- nosegear coord
	main_gear_pos 				= {1.993,	-2.587,	4.503}, -- main gear coords
	tand_gear_max 				= 0.577,
	nose_gear_wheel_diameter 	= 0.793, -- in m
	main_gear_wheel_diameter 	= 1.395, -- in m
	stores_number				=	4,
	V_opt 						= 94,-- Cruise speed (for AI)
	V_take_off 					= 50, -- Take off speed in m/s (for AI) 288km/h
	V_land 						= 67, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 132, -- 306 mph/266kts Max speed at sea level in m/s (for AI)
	V_max_h 					= 156, -- 357 mph/310 kts Max speed at max altitude in m/s (for AI)
	Vy_max 						= 4.47, -- 940ft/min @ sea level @ 130,000 lbs @ 195 mph IAS but also 38 mins to 20K ft so have to adjust down(for AI)
	Mach_max 					= 0.6, -- Max speed in Mach (for AI)
	H_max 					 	= 10241, -- m
	Ny_min 						= -1.7, -- Min G (for AI)
	Ny_max 						= 2.67,  -- Max G (for AI)
	Ny_max_e 					= 2.67,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 30, -- Max bank angle (for AI)
	bigParkingRamp				= true, --controls whether the aircraft requires a large parking spot	
    singleInFlight 				= false,	
	average_fuel_consumption 	= 0.438, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	range 						= 5794, -- Max range in km (for AI) realistic operational range
	CAS_min 					= 47, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	thrust_sum_max 				= 50000,
	thrust_sum_ab 				= 50000,
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	flaps_maneuver 				= 0.26, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	RCS 						= 100, -- Radar Cross Section m2
	IR_emission_coeff 			= 1.5, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	engines_count				= 4, -- Engines count
	engines_nozzles = 
	{
		[1] = 
		{
			pos 		=  {4.522,	0.584,	-9.834}, -- nozzle coords
				elevation	=	0,
				diameter	=	0.3,
				exhaust_length_ab	=	0.794,
				exhaust_length_ab_K	=	0.16,
				smokiness_level     = 	0.03,
				engine_number  = 1, --both to first engine		
		},
		[2] = 
		{
			pos 		=  {4.522,	0,	-4.578}, -- nozzle coords
				elevation	=	0,
				diameter	=	0.3,
				exhaust_length_ab	=	0.794,
				exhaust_length_ab_K	=	0.16,
				smokiness_level     = 	0.03,
				engine_number  = 2, --both to first engine	
		},
		[3] = 
		{
			pos 		=  {4.522,	0,	4.578}, -- nozzle coords
				elevation	=	0,
				diameter	=	0.3,
				exhaust_length_ab	=	0.794,
				exhaust_length_ab_K	=	0.16,
				smokiness_level     = 	0.03,
				engine_number  = 3, --both to first engine
		},
		[4] = 
		{
			pos 		=  {4.522,	0.584,	9.834}, -- nozzle coords
				elevation	=	0,
				diameter	=	0.3,
				exhaust_length_ab	=	0.794,
				exhaust_length_ab_K	=	0.16,
				smokiness_level     = 	0.03,
				engine_number  = 4, --both to first engine
		},
	}, -- end of engines_nozzles

	crew_size	 = 11,
	crew_members = 
	{
			[1] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [1]
			[2] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [2]
			[3] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [3]
			[4] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [4]
			[5] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [5]
			[6] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{12,	-1.2,	0.75},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [6]
			[7] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{1,	-2.5,	0},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [7]
			[8] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{1,	-2.5,	0},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [8]	
			[9] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{1,	-2.5,	0},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [9]
			[10] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-6.5,	2,	0},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [10]
			[11] = 
			{	pilot_name          = "pilot_bf109",
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-6.5,	2,	0},
			    drop_parachute_name	 =  "pilot_bf109_parachute",
			}, -- end of [11]
	}, -- end of crew_members

	fires_pos = 
	{
		[1] = 	{-2.117,	-0.9,	0},
		[2] = 	{4.00,	0.213,	2.182},
		[3] = 	{4.00,	0.213,	-2.182},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	4.274},
		[7] = 	{-0.82,	0.255,	-4.274},
		[8] = 	{6.5,	-0.5,	4.578},
		[9] = 	{6.5,	-0.5,	-4.578},
		[10] = 	{6.0,	0.084,	9.834},
		[11] = 	{6.0,	0.084,	-9.834},
	}, -- end of fires_pos
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,
	chaff_flare_dispenser 	= 
	{
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = 
	makeAirplaneCanopyGeometry(LOOK_EXELLENT_B17,LOOK_EXELLENT_B17,LOOK_EXELLENT_B17),
	Sensors = 
	{
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Guns = 
	{
 
		nr_23({count = 700,
			muzzle_pos = {11.67, 1.57, 0.3},
			supply_position = {11.65, 1.57, 0.1}}), --fwd dorsal  
 		nr_23({count = 700, 
			muzzle_pos = {11.67, 1.57, -0.3},
			supply_position = {11.65, 1.57, -0.1}}), --fwd dorsal  
		nr_23({count = 700,
			muzzle_pos = {11.3, -1.57, 0.3},
			supply_position = {11.2, -1.57, 0.1}}),  --lower fwd
 		nr_23({count = 700,
			muzzle_pos = {11.2, -1.57, -0.3},
			supply_position = {11.2, -1.57, -0.1}}),  --lower fwd	
		nr_23({count = 700,
			muzzle_pos = {-3.16, 1.57, 0.3},
			supply_position = {-3.15, 1.57, 0.1}}), --top rear  
 		nr_23({count = 700,
			muzzle_pos = {-3.16, 1.57, -0.3},
			supply_position = {-3.15, 1.57, -0.1}}),  	--top rear
		nr_23({count = 700,
			muzzle_pos = {-8.77, -0.56, 0.3},
			supply_position = {-8.76, -0.56, 0.1}}),  --lower rear
 		nr_23({count = 700,
			muzzle_pos = {-8.77, -0.56, -0.3},
			supply_position = {-8.76, -0.56, -0.1}}),  --lower rear	
		nr_23({count = 700,
			muzzle_pos = {-14.48, 0.99, 0.3},
			supply_position = {-14.48, 0.99, 0.1}}),  --tail
 		nr_23({count = 700,
			muzzle_pos = {-14.48, 0.99, -0.3},
			supply_position = {-14.48, 0.99, -0.1}}),  --tail				
	},

	Pylons = 
    {
		-- Parameter 2 = Internal or External pylon, so if its set to 2 it fires the Argument #26
        pylon(1, 2, 7.7, -0.5, 0.4,
            {
            },
            {
				{ CLSID = "FAB_50_12",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},
				{ CLSID = "FAB_100Mx12" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},
				{ CLSID = "FAB_250_10" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},	
				{ CLSID = "FAB_500_3" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},			
				{ CLSID = "FAB_1500_2",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
													}					
				},
            }
        ),
        pylon(2, 2, 7.7, -0.5, -0.4,
            {
            },
			{
				{ CLSID = "FAB_50_12",forbidden = 	{
																		{station = 1, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 1, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 1, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},
				{ CLSID = "FAB_100Mx12" ,forbidden = 	{
																		{station = 1, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
																		{station = 1, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 1, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 1, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},
				{ CLSID = "FAB_250_10" ,forbidden = 	{
																		{station = 1, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 1, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 1, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},	
				{ CLSID = "FAB_500_3" ,forbidden = 	{
																		{station = 1, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 1, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 1, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},			
				{ CLSID = "FAB_1500_2",forbidden = 	{
																		{station = 1, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 1, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 1, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
													}					
				},
            }
        ),
        pylon(3, 2, 1.8, -0.5, 0.5,
            {
            },
			{
				{ CLSID = "FAB_50_12",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 1, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 1, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 1, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},
				{ CLSID = "FAB_100Mx12" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 1, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 1, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 1, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 1, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},
				{ CLSID = "FAB_250_10" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 1, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 1, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 1, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
														}				
				},	
				{ CLSID = "FAB_500_3" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 1, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 1, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 1, loadout = {"FAB_1500_2"}},
																		{station = 4, loadout = {"FAB_1500_2"}},
													}					
				},			
				{ CLSID = "FAB_1500_2",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 4, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 1, loadout = {"FAB_250_10"}},
																		{station = 4, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 1, loadout = {"FAB_500_3"}},
																		{station = 4, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 1, loadout = {"FAB_50_12"}},
																		{station = 4, loadout = {"FAB_50_12"}},
													}					
				},
            }
        ),
        pylon(4, 2, 1.8, -0.5, -0.5,
            {
            },
			{
				{ CLSID = "FAB_50_12",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 1, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 1, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 1, loadout = {"FAB_1500_2"}},
													}					
				},
				{ CLSID = "FAB_100Mx12" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 1, loadout = {"FAB_50_12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 1, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 1, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 1, loadout = {"FAB_1500_2"}},
														}				
				},
				{ CLSID = "FAB_250_10" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 1, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 1, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 1, loadout = {"FAB_1500_2"}},
														}				
				},	
				{ CLSID = "FAB_500_3" ,forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 1, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 1, loadout = {"FAB_50_12"}},	
																		{station = 2, loadout = {"FAB_1500_2"}},
																	    {station = 3, loadout = {"FAB_1500_2"}},
																		{station = 1, loadout = {"FAB_1500_2"}},
													}					
				},			
				{ CLSID = "FAB_1500_2",forbidden = 	{
																		{station = 2, loadout = {"FAB_100Mx12"}},
																	    {station = 3, loadout = {"FAB_100Mx12"}},
																		{station = 1, loadout = {"FAB_100Mx12"}},
																		{station = 2, loadout = {"FAB_250_10"}},
																	    {station = 3, loadout = {"FAB_250_10"}},
																		{station = 1, loadout = {"FAB_250_10"}},	
																		{station = 2, loadout = {"FAB_500_3"}},
																	    {station = 3, loadout = {"FAB_500_3"}},
																		{station = 1, loadout = {"FAB_500_3"}},	
																		{station = 2, loadout = {"FAB_50_12"}},
																	    {station = 3, loadout = {"FAB_50_12"}},
																		{station = 1, loadout = {"FAB_50_12"}},
													}					
				},
            }
        ),		
	},

	Tasks = 
	{
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(GroundAttack),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.0,  -- zero AoA lift coefficient
			Mzalfa		=	6.6,  -- coefficients for pitch agility
			Mzalfadt	=	0.5,    -- coefficients for pitch agility
			kjx			=	3.15,    
			kjz			=	0.00125, 
			Czbe		=	-0.012, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.01,    -- coefficient, drag, gear
			cx_flap		=	0.0155,   -- coefficient, drag, full flaps
			cy_flap		=	0.45,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0,   -- coefficient, drag, breaks
			table_data  = 
			{
			--   M		Cx0		Cya		B		B4			Omxmax	Aldop	Cymax
				{0,		0.0230,	0.155,	0.0780,	0.0,		0.23,	22,		1.2},
				{0.1,	0.0232,	0.155,	0.0780,	0.0,		0.26,	22,		1.2}, --66kts
				{0.2,	0.0234,	0.155,	0.0780,	0.0,		0.26,	22,		1.2}, --133kts
				{0.3,	0.0241,	0.143,	0.0760,	0.014,		0.26,	20,		1.2}, --200kts
				{0.398,	0.0286,	0.143,	0.0760,	0.017,		0.26,	20,		1.20}, --max sea level
				{0.4,	0.0286,	0.1251,	0.053,	0.018,		0.29,	18,		1.19}, --266.7 kts
				{0.465,	0.0295, 0.1251,	0.045,	0.020,		0.29,	18,		1.19}, --max 
				{0.5,	0.0315,	0.112,	0.0165,	0.022,		0.25,	12,		1.04}, --** compressibility warning 333.4kts
				{0.6,	0.0366,	0.099,	0.0275,	0.026,		0.21,	12,		0.94}, --400kts
				{0.7,	0.051,	0.165,	0.032,	0.12,		0.15,	11,		0.84}, --466.7kts
				{0.8,	0.077,	0.176,	0.049,	0.15,		0.07,	8,		0.76}, --533kts
				{0.9,	0.13,	0.181,	0.071,	0.17,		0.03,	4,		0.65}, --600 kts
				{1,		0.17,	0.191,	0.138,	0.2,		0.01,	2,		0.6}, --666.7 kts
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nominal_RPM = 2800.0,
			Nmg	=	22.0, -- RPM at idle 700 rpm
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			type    = "Radial",
			--cylinder_firing_order = {1, 12, 5, 16, 9, 2, 13, 6, 17, 10, 3, 14, 7, 18, 11, 4, 15, 8},
			--	E_TURBOJET = 0
			--	E_TURBOJET_AB = 1
			--	E_PISTON = 2
			--	E_TURBOPROP = 3
			--	E_TURBOFAN	= 4
			--	E_TURBOSHAFT = 5
			hMaxEng	=	12.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1200, --  altitude coefficient for max thrust
			dpdh_f	=	1200, --  altitude coefficient for AB thrust
			table_data = 
			{
				[1] = 	{0,		17395.9	,17395.9},
				[2] = 	{0.1,	17193.8	,17193.8},
				[3] = 	{0.2,	16995.6	,16995.6},
				[4] = 	{0.3,	16800.8	,16800.8},
				[5] = 	{0.4,	14773.3	,14773.3},
				[6] = 	{0.5,	12854.2	,12854.2},
				[7] = 	{0.6,	10029.2	,10029.2},
				[8] = 	{0.7,	8312.3	,8312.3},
				[9] = 	{0.8,	5719.3	,5719.3},
				[10] = 	{0.9,	3650	,3650},
			},	
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 147308,
			MAX_Manifold_P_2	= 160854,
			MAX_Manifold_P_3	= 171013,
			k_after_cool		= 0.5,
			Displ				= 54.86,
			k_Eps				= 6.85,
			Stroke				= 0.160,
			V_pist_0			= 12,
			Nu_0				= 1.2,
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1640540,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 5.08,
			MOI_prop			= 96,
			k_gearbox			= 2.857,
			P_oil				= 586054,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
		}, -- end of engine
	}, -- end of SFM_Data

	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
--[[
To break the entries down:

eg oh58d_cells_properties[0] = {critical_damage = 4, args = {161},deps_cells = {11,12},droppable=false}
   ----------green------- loc   ----------red------  ---blue----  ------yellow--------
Green is the model name and part# as referenced in the list at top of the damage.lua

Red, amount of damage it can sustain before something falls off or 
you get shot down. Some parts will have an extra section named deps_cells, 
I think these parts fall off when the particular part reaches its critical
damage amount unless droppable = false. 
Blue is 3D model argument # of the damage part
Yellow is the damage cells affected by damage on this location
	--]]
	Damage = 
	{
		[0]  = {critical_damage = 10}, --nose center
		[1]  = {critical_damage = 10}, --nose left
		[2]  = {critical_damage = 10}, --nose right
		[3]  = {critical_damage = 10}, --cockpit	
		[4]  = {critical_damage = 25}, --cabin left		
		[5]  = {critical_damage = 25}, --cabin right
		[6]  = {critical_damage = 25}, --cabin bottom		
		[8]  = {critical_damage = 6}, --gear front		
		[9]  = {critical_damage = 35}, --fuselage left	
		[10] = {critical_damage = 35}, --fuselage right
		[11] = {critical_damage = 12}, --engine in left
		[12] = {critical_damage = 12}, --engine in right
		[13] = {critical_damage = 12, args = {167}},  --Engine nacelle Left
		[14] = {critical_damage = 12, args = {161}},  --Engine nacelle Right		
		[15]  = {critical_damage = 6}, --gear left
		[16]  = {critical_damage = 6}, --gear right	
		[17] = {critical_damage = 12, args = {167}},  --Engine nacelle Left
		[18] = {critical_damage = 12, args = {161}},  --Engine nacelle Right			
		[21]  = {critical_damage = 8,deps_cells = {21},droppable = false}, --slat out left		
		[22]  = {critical_damage = 8,deps_cells = {22},droppable = false}, --slat out right						
		[23] = {critical_damage = 35, args = {223}}, --wing out left
		[24] = {critical_damage = 35, args = {213}}, --wing out right
		[25] = {critical_damage = 8, args = {49,51,53}}, --eleron left
		[26] = {critical_damage = 8, args = {50,52,54}}, --eleron right
		[29] = {critical_damage = 35,deps_cells = {37}}, --wing center left
		[30] = {critical_damage = 35,deps_cells = {38}}, --wing center right 
		[31]  = {critical_damage = 8,droppable = false}, --flap out left		
		[32]  = {critical_damage = 8,droppable = false}, --flap out right				
		[33]  = {critical_damage = 8,droppable = false}, --slat in left		
		[34]  = {critical_damage = 8,droppable = false}, --slat in right			
		[35] = {critical_damage = 35, args = {67}, deps_cells = {23, 25}}, --wing in left
		[36] = {critical_damage = 35, args = {68}, deps_cells = {24, 26}}, --wing in right
		[37] = {critical_damage = 8, args = {55}}, --flap in left
		[38] = {critical_damage = 8, args = {56}}, --flap in right
		[39] = {critical_damage = 25, args = {61}, droppable = false}, --fin top left
		[40] = {critical_damage = 25, args = {61}, droppable = false}, --fin top right
		[41] = {critical_damage = 25, args = {61}, droppable = false}, --fin centre left		
		[42] = {critical_damage = 25, args = {61}, droppable = false}, --fin centre right		
		[43] = {critical_damage = 25, args = {61}}, --fin bottom left
		[44] = {critical_damage = 25, deps_cells = {44},droppable = false}, --fin bottom right
		[45] = {critical_damage = 25}, --stabilizer out left		
		[46] = {critical_damage = 25}, --stabilizer out left				
		[47] = {critical_damage = 25, args = {63}}, --stabilizer in left
		[48] = {critical_damage = 25, args = {64}}, --stabilizer in right
		[51] = {critical_damage = 8, args = {59},droppable = false}, --elevator in left
		[52] = {critical_damage = 8, args = {60},droppable = false}, --elevator in right
		[53] = {critical_damage = 8, args = {57},droppable = false}, --rudder left
		[54] = {critical_damage = 8, args = {247},droppable = false}, --rudder right
		[55] = {critical_damage = 45, args = {81}}, --tail
		[56] = {critical_damage = 45,droppable = false}, --tail left
		[57] = {critical_damage = 45,droppable = false}, --tail right		
		[58] = {critical_damage = 45,droppable = false}, --tail bottom
		[59] = {critical_damage = 10}, --nose bottom		
		[61] = {critical_damage = 10}, --fuel tank front (left)
		[62] = {critical_damage = 10}, --fuel tank back (right)	
		[82] = {critical_damage = 45}, --fuselage bottom		
	},  -- end of Damage
	
	DamageParts = 
	{  
		[1] = "B-29-OBLOMOK-WING-R",
		[2] = "B-29-OBLOMOK-WING-L",
	},

	lights_data = 
	{
		typename = "collection",
		lights = 
		{
   			[1] = {typename = "collection",lights = {}},
    		[2] = {typename = "collection",lights = {}},
		    [3]	= 
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					color = {0.32, 0.0, 0.07},
					position  = {3.74, 1.44, -21.45},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					color = {0, 0.26, 0.18},
					position = {3.74, 1.44, 21.45},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					color = {0.8, 0.8, 0.8},
					position  = {-13.2, 0.33, 0.0},
					argument  = 203
					},
				}
			},
    		[4] = {typename = "collection",lights = {}},
    		[5] = {typename = "collection",lights = {}},		
		}
	},  -- end of lights_data

}

add_aircraft(Tu_4)
