--/N/ updated 14. MAR 2017.
--/N/ with "Redglyph" permission
--/N/ note: non-existing NDBs deleted, but reserved channels left


local long_modifier = -1

RSBN_data_Nevada = {

	map_location = 'NW',

	{
		airbase = 'MINA', --01
		lat = 38.56528,
		long = 118.03278 * long_modifier,
		alt = 2342,
		rwy = -1,
		length = -1,
		code = '-- ...- .- ' --/N/ MVA_
	},
	
	{
		airbase = 'COALDALE', --02
		lat = 38.00306,
		long = 117.77028 * long_modifier,
		alt = 1463,
		rwy = -1,
		length = -1,
		code = '--- .- .-.. ' --/N/ OAL_
	},

	{	
		airbase = 'TONOPAH', --03
		lat = 38.03056,
		long = 117.03333 * long_modifier,
		alt = 1629,
		rwy = -1,
		length = -1,
		code = '- .--. .... ' --/N/ TPH_
	},

	{	
		airbase = 'WILSON CREEK', --04
		lat = 38.25000,
		long = 114.39417 * long_modifier,
		alt = 2778,
		rwy = -1,
		length = -1,
		code = '.. .-.. -.-. ' --/N/ ILC_
	},	
	
	{	
		airbase = 'MILFORD', --05
		lat = 38.36028,
		long = 113.36028 * long_modifier,
		alt = 1690,
		rwy = -1,
		length = -1,
		code = '-- .-.. ..-. ' --/N/ MLF_
	},
    
	{
		airbase = 'BISHOP', --06
		lat = 37.37694,
		long = 118.36639 * long_modifier,
		alt = 1254,
		rwy = -1,
		length = -1,
		code = '-... .. .... ' --/N/ BIH_
	},

	{
        airbase = 'TONOPAH TEST RANGE', --07
        lat = 37.817221, 
        long = 116.790522 * long_modifier,
        alt = 1689,
        rwy = 337,
        length = 3600,
        code = '- --.- --.- ' -- /N/ TQQ_
	},
    
	{
		airbase = 'GROOM LAKE 336R', --08
		lat = 37.23444,
		long = 115.79333 * long_modifier,
		alt = 1361,
		rwy = 156,--L
		length = 3600,
		code = '--. .-.. .-. ' --/N/ GLR_
	},
	
	{
		airbase = 'GROOM LAKE 336L', --09
		lat	= 37.23472,
		long = 115.80083 * long_modifier,
		alt	= 1361,
		rwy	= 156,
		length	= 3600,
		code = '--. .-.. .-.. ' --/N/ GLL_
	},
	
	{
        airbase = 'ST. GEORGE', --10
		lat = 37.088212,
		long = 113.592167 * long_modifier,
        alt = 875,
        rwy = -1,
        length = -1,
		code = '..- - .. ' --/N/ UTI_
	},
    	
	{	
		airbase = 'CEDAR CITY', --11
		lat = 37.78722,
		long = 113.06806 * long_modifier,
		alt = 1665,
		rwy = -1,
		length = -1,
		code = '-.-. -.. -.-. ' --/N/ CDC_
	},
	
	{	
		airbase = 'BRYCE CANYON', --12
		lat = 37.68889,
		long = 112.30361 * long_modifier,
		alt = 2711,
		rwy = -1,
		length = -1,
		code = '-... -.-. . ' --/N/ BCE_
	},
  
	{	
		airbase = 'BEATTY', --13
		lat = 36.80056,
		long = 116.74750 * long_modifier,
		alt = 890,
		rwy = -1,
		length = -1,
		code = '-... - -.-- ' --/N/ BTY_
	},

	{
		airbase = 'CREECH 092', --14
		lat = 36.58333,
		long = 115.67806 * long_modifier,
		alt = 953,
		rwy = 92,
		length = 2700,
		code = '-.-. .-. . ' --/N/ CRE_
	},

	{	
		airbase = 'CREECH 145', --15
		lat = 36.58972,
		long = 115.67139 * long_modifier,
		alt = 953,
		rwy = 145,
		length = 1600,
		code = '-.-. .-. -.-. ' --/N/ CRC_
	},

	{
		airbase = 'INDIAN SPRINGS', --16
		lat = 36.58500,
		long = 115.67500 * long_modifier,
		alt = 953,
		rwy = -1,
		length = -1,
		code = '.. -. ... ' --/N/ INS_
	},
	
	{
        airbase = 'NORTH LAS VEGAS', --17
		lat = 36.203486,
		long = 115.185139 * long_modifier,
        alt = 681,
        rwy = 122.3,
        length = 1161,
		code = '.... .-- --. ' --/N/ HWG
	},

	{	
		airbase = 'NELLIS 220 L', --18
		lat = 36.23611,
		long = 115.03250 * long_modifier,
		alt = 562,
		rwy = 220,
		length = 3000,
		code = '-. . .-.. ' --/N/ NEL_
	},

	{
		airbase = 'NELLIS 220 R', --19
		lat = 36.23750,
		long = 115.03528 * long_modifier,
		alt = 564,
		rwy = 220,
		length = 3000,
		code = '-. . .-. ' --/N/ NER_
	},

	{	
		airbase = 'GOFFS', --20
		lat = 35.13111,
		long = 115.17639 * long_modifier,
		alt = 1225,
		rwy = -1,
		length = -1,
		code = '--. ..-. ... ' --/N/ GFS_
	},	
	
	{
		airbase = 'McCARRAN INT. 269 L', --21
		lat = 36.07389,
		long = 115.14222 * long_modifier,
		alt = 639,
		rwy = 89,
		length = 3000,
		code = '-- .. .-.. ' --/N/ MIL_
	},

	{
		airbase = 'McCARRAN INT. 269 R', --22
		lat = 36.076672,
		long = 115.14222 * long_modifier,
		alt = 639,
		rwy = 89,
		length = 3000,
		code = '-- .. .-. ' --/N/ MIR_
	},
	
	{
		airbase = 'McCARRAN INT. 024 L', --23
		lat = 36.08667,
		long = 115.16333 * long_modifier,
		alt = 657,
		rwy = 24,
		length = 3000,
		code = '-- -.-. .-.. ' --/N/ MCL_
	},
	
	{		
		airbase = 'McCARRAN INT. 024 R', --24
		lat = 36.08583,
		long = 115.16028 * long_modifier,
		alt = 658,
		rwy = 24,
		length = 3000,
		code = '-- -.-. .-.' --/N/ MCR_
	},
	
	{	
		airbase = 'MORMON MESA', --25
		lat = 36.76917,
		long = 114.27750 * long_modifier,
		alt = 641,
		rwy = -1,
		length = -1,
		code = '-- -- -- ' --/N/ MMM_
	},
	
	{	
		airbase = 'BOULDER CITY', --26
		lat = 35.99556,
		long = 114.86361 * long_modifier,
		alt = 1084,
		rwy = -1,
		length = -1,
		code = '-... .-.. -.. ' --/N/ BLD_
	},

	{
        airbase = 'KINGMAN', -- 27
		lat = 35.260535,
		long = 113.93413 * long_modifier,
        alt = 1039,
        rwy = -1,
        length = -1,
		code = '.. --. -- ' --/N/ IGM_
	},
    
	{	
		airbase = 'PEACH SPRINGS', --28
		lat = 35.62444,
		long = 113.54444 * long_modifier,
		alt = 1449,
		rwy = -1,
		length = -1,
		code = '.--. --. ... ' --/N/ PGS_
	},
	
	{
        airbase = 'GRAND CANYON', --29
		lat = 35.960444,
		long = 112.145901 * long_modifier,
        alt = 2024,
        rwy = -1,
        length = -1,
		code = '--. -.-. -. ' --/N/ GCN_
	},

	{
        airbase = 'DAGGETT', --30
		lat = 34.797214,
		long = 116.462929 * long_modifier,
        alt = 538,
        rwy = -1,
        length = -1,
		code = '-.. .- --. ' --/N/ DAG_
	},
    
	{
        airbase = 'HECTOR', --31
		lat = 34.797214,
		long = 116.462929 * long_modifier,
        alt = 565,
        rwy = -1,
        length = -1,
		code = '.... . -.-. ' --/N/ HEC_
	},
    
	{
        airbase = 'NEEDLES', --32
		lat = 34.765927,
		long = 114.473902 * long_modifier,
        alt = 198,
        rwy = -1,
        length = -1,
		code = '. . -.. ' --/N/ EED_
	},
    
    
	--[[ /N/ EXAMPLE of custom station -- 27
	{
		airbase = 'My Airbase or My station', --17
		lat = 41.99215, 
		long	= 42.20137,
		alt = 100, -- altitude in meters as in ME, add 1-2 for antenae altitude on airport, or 10-15 in hilly or city areas for better signals reception
		rwy = 44, --makes sense if the station is near the runway
		length = 3000, --makes sense if the station is near the runway
		code = '.- -... - ' --/N/ Abt_ Morse signals should be separated by an empty space + one empty space at the end of the sequence 
	},	
	
	]]

}


ARK_data_Nevada = {

	map_location = 'NW',

		--/N/ USA NEVADA - ARK sector 1 I, channels 1 - 9
        
	{   -- 1: Mercury
		country = 'USA - Nevada',
		freq = 326.0,
		lat = 36.62722,
		long = 116.02750 * long_modifier,
		location = 'unknown',
		code = '-- -.-. -.-- ' --/N/ MCY_
	},

	{   -- 2: Meggi
		country = 'USA - Nevada',
		freq = 217.0,
		lat = 37.791252,
		long = 113.020879 * long_modifier,
		location = 'unknown',
		code = '. -.-. ' --/N/ EC
	},

	{   -- 3: Colorado City
		country = 'USA - Nevada',
		freq = 403.0,
		lat = 36.959895,
		long = 113.008973 * long_modifier,
		location = 'unknown',
		code = '.- --.. -.-. ' --/N/ AZC
	},
	
	{   -- 4: 
		country = 0
	},
	
	{   -- 5: 
		country = 0
	},
	
	{   -- 6: 
		country = 0
	},
	
	{   -- 7: 
		country = 0
	},
	
	{   -- 8: 
	},
	
	{   -- 9: 
		country = 0
	},
	
	{
	--/N/ 10th channel must be empty
		country = 0
	},
	
	--/N/ sector 1 II, NE
    
	{   --1: 
		country = 0
	},	
	
	{   -- 2: 
		country = 0
	},
	
	{   --3: 
		country = 0
	},
	
	{   -- 4: 
		country = 0
	},

	{   --5: 
		country = 0
	},	
	
	{   -- 6: 
	},
	
	{   -- 7: 
		country = 0
	},
	
	{   -- 8: 
	},
	
	{   -- 9: 
		country = 0
	},
	
	{
		--/N/ 10th channel must be empty
		country = 0		
	},
	
	--/N/ sector 2 I, SW
    
	{   -- 1: 
		country = 0
	},
	
	{   -- 2: 
		country = 0
	},
	
	{   -- 3: 
		country = 0
	},

	{   -- 4: 
		country = 0
	},

	{   -- 5: 
		country = 0
	},
	
	{
		country = 0	
	},
	
	{
		country = 0	 --7
	},
	
	{
		country = 0	
	},
	
	{
		country = 0	 --9
	},
	
	{
		--/N/ 10th channel must be empty
		country = 0		
	},	
	
	--/N/ sector 2 II, SE
    
	{   -- 1: 
		country = 0
	},
	
	{   -- 2: 
		country = 0
	},
	
	{   -- 3: 
		country = 0
	},
	
	{   -- 4: 
		country = 0
	},
	
	{   -- 5: 
		country = 0
	},
	
	{
		country = 0	
	},
	
	{
		country = 0	 --7
	},
	
	{
		country = 0	
	},
	
	{
		country = 0	 --9
	},
	
	{
		--/N/ 10th channel must be empty
		country = 0		
	},	
	
	--/N/ ________ - ARK sector 3 I, channels 1 - 5 used
	{
		country = 0 --1 / absolute 41
	},
	
	{
		country = 0
	},
	
	{
		country = 0 --3
	},
	
	{
		country = 0
	},
	
	{
		country = 0 --5
	},
	
	{
		country = 0
	},
	
	{
		country = 0	--7	
	},	
	
	{
		country = 0	
	},

	{	
		country = 0	--9	
	},
	
	{
		--/N/ 10th channel must be empty
		country = 0		
	},
	
}

need_to_be_closed = true