MiG_29N =  {
      
		Name 			= 'MiG-29N',--AG
		DisplayName		= _('MiG-29N'),--AG
        Picture 		= "MiG-29.png",
        Rate 			= "50",
        Shape			= "MIG-29C",--AG	
        WorldID			=  32, 
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", preset = "MiG29"},
		},
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'MIG-29C';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'MIG-29C-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'MIG-29N';--AG
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "MIG-29C-oblomok";
			file  		= "MIG-29C-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey = "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Battleplanes"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	CanopyGeometry = { -0.17364817766693, -0.49640011097796, -0.81915204428899, -0.23856595048166, 0.34202014332567 },
	
		M_empty	=	11222,
		M_nominal	=	13240,
		M_max	=	19700,
		M_fuel_max	=	3493,
		H_max	=	18000,
		average_fuel_consumption	=	0.2743,
		CAS_min	=	60,
		V_opt	=	222,
		V_take_off	=	67,
		V_land	=	70,
		has_afteburner	=	true,
		has_speedbrake	=	true,
		radar_can_see_ground	=	false,
		input_profile_entry = 	"MiG-29N",

		nose_gear_pos 				                = {2.917, -1.644, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.57, -- in m
	    main_gear_pos 						 	    = {-0.68, -1.525, 1.55}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.84, -- in m

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		tand_gear_max				=	3.73,
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		tanker_type					=	0,
		wing_area					=	38.2,
		wing_span					=	11.4,
		wing_type 					= 1,
		thrust_sum_max				=	10147,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	16652,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		length						=	20.32,
		height						=	4.73,
		flaps_maneuver				=	1,
		Mach_max					=	2.2,
		range						=	2240,
		RCS							=   3,
		Ny_max_e					=	8,
		detection_range_max			=	200,
		IR_emission_coeff			=	0.71,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	3,		-- With afterburner
		engines_count				=	2,
		wing_tip_pos 				= 	{-3.8, 0.14, 5.8},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-5.534, -0.063, -0.909},
				elevation	=	-2.8,--3.7
				diameter	=	0.945,--0.965
				exhaust_length_ab	=	7.5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-5.534, -0.063, 0.909},
				elevation	=	-2.8,--3.7
				diameter	=	0.945,--0.965
				exhaust_length_ab	=	7.5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
			}, -- end of [2]
		}, -- end of engines_nozzles
	
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	41,
				pos = 	{4.403, 1.209, 0},
			}, -- end of [1]
		}, -- end of crew_members

		brakeshute_name	=	3,--Mig29=3/Su27=4/
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{9.898,	1.240,	-1.082},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.307,	1.511},
			[3] = 	{0.173,	-0.307,	-1.511},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-3.899,	-0.212,	0.611},
			[9] = 	{-3.899,	-0.212,	-0.611},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0, 0.999, 0.052},
				pos = 	{-0.937, 1.645, -1.726},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0, 0.999, -0.052},
				pos = 	{-0.937, 1.645, 1.726},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

		-- Countermeasures
		passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 96,
			-- PPR-26
			chaff = {default = 48, increment = 3, chargeSz = 1},
			-- PPI-26
			flare = {default = 48, increment = 3, chargeSz = 1}
        },
        Geometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },
        Sensors = {
            RADAR = "N-001",
            IRST = "KOLS",
            RWR = "Abstract RWR"
        },
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	Countermeasures = {
            ECM = "Gardenia"
        },
	HumanRadio = {
		frequency 		= 124.0,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},
	HumanCockpit = true,
	HumanCockpitPath = "./Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardLeft/",
	
Guns = {gun_mount("GSh_30_2", { count = 150 },{muzzle_pos = { 5.435, 0.268, -0.559 }})

},

pylons_enumeration = {1, 7, 2, 6, 3, 5, 4},

	Pylons =     {

        pylon(1, 0, -1.671, -0.121, -3.927,
            {
                arg = 308,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
		pylon(2, 0, -1.09, -0.097, -3.245,
            {
                arg = 309,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
				{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
				{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" ,arg_value = 0.35},--betab500
				{ CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" ,arg_value = 0.35},--betab500shp
				{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ,arg_value = 0.35},--FAB250
				{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" ,arg_value = 0.35},--FAB500
				{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}" ,arg_value = 0.35},--RBK250
				{ CLSID = "{RBK_250_275_AO_1SCH}" 				   ,arg_value = 0.35},
				{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" ,arg_value = 0.35},--RBK-500-255 PTAB-10-5
				{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}" ,arg_value = 0.35},--RBK-500 PTAB-1M
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ,arg_value = 0.35},--B-8M1 - 20 S-8KOM
				{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ,arg_value = 0.35},--S-24B	
				{ CLSID = "B-8M1 - 20 S-8OFP2"					   ,arg_value = 0.35},
				{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}" ,arg_value = 0.35},-- S-8TsM
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(3, 0, -0.553, -0.122, -2.44,
            {
                arg = 310,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
				{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
				{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" ,arg_value = 0.35},--betab500
				{ CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" ,arg_value = 0.35},--betab500shp
				{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ,arg_value = 0.35},--FAB250
				{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" ,arg_value = 0.35},--FAB500
				{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}" ,arg_value = 0.35},--RBK250
				{ CLSID = "{RBK_250_275_AO_1SCH}" 				   ,arg_value = 0.35},
				{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" ,arg_value = 0.35},--RBK-500-255 PTAB-10-5
				{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}" ,arg_value = 0.35},--RBK-500 PTAB-1M
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ,arg_value = 0.35},--B-8M1 - 20 S-8KOM
				{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ,arg_value = 0.35},--S-24B	
				{ CLSID = "B-8M1 - 20 S-8OFP2"					   ,arg_value = 0.35},
				{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}" ,arg_value = 0.35},-- S-8TsM
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(4, 0, -0.783, -0.15, 0,
            {
            },
            {
                { CLSID = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}" }, --Fuel_1400L
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(5, 0, -0.553, -0.122, 2.44,
            {
                arg = 312,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
				{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
				{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" ,arg_value = 0.35},--betab500
				{ CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" ,arg_value = 0.35},--betab500shp
				{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ,arg_value = 0.35},--FAB250
				{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" ,arg_value = 0.35},--FAB500
				{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}" ,arg_value = 0.35},--RBK250
				{ CLSID = "{RBK_250_275_AO_1SCH}" 				   ,arg_value = 0.35},
				{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" ,arg_value = 0.35},--RBK-500-255 PTAB-10-5
				{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}" ,arg_value = 0.35},--RBK-500 PTAB-1M
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ,arg_value = 0.35},--B-8M1 - 20 S-8KOM
				{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ,arg_value = 0.35},--S-24B	
				{ CLSID = "B-8M1 - 20 S-8OFP2"					   ,arg_value = 0.35},
				{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}" ,arg_value = 0.35},-- S-8TsM
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(6, 0, -1.09, -0.097, 3.245,
            {
                arg = 313,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
				{ CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
				{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}" ,arg_value = 0.35},--betab500
				{ CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}" ,arg_value = 0.35},--betab500shp
				{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ,arg_value = 0.35},--FAB250
				{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" ,arg_value = 0.35},--FAB500
				{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}" ,arg_value = 0.35},--RBK250
				{ CLSID = "{RBK_250_275_AO_1SCH}" 				   ,arg_value = 0.35},
				{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}" ,arg_value = 0.35},--RBK-500-255 PTAB-10-5
				{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}" ,arg_value = 0.35},--RBK-500 PTAB-1M
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" ,arg_value = 0.35},--KMGU2
				{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ,arg_value = 0.35},--B-8M1 - 20 S-8KOM
				{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ,arg_value = 0.35},--S-24B	
				{ CLSID = "B-8M1 - 20 S-8OFP2"					   ,arg_value = 0.35},
				{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}" ,arg_value = 0.35},-- S-8TsM
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(7, 0, -1.671, -0.121, 3.927,
            {
                arg = 314,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" , arg_value = 0.6 },--R-60M
				{ CLSID = "{R_60}" , arg_value = 0.6 },--R-60
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },--SMOKE
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },--SMOKE
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
},

	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        --aircraft_task(AFAC),
	    aircraft_task(RunwayAttack),
    	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(FighterSweep),

	SFM_Data = {
		aerodynamics = {
			Cy0 = 0,
			Czbe = -0.016,
			Mzalfa = 4.355,
			Mzalfadt = 0.8,
			cx_brk = 0.06,
			cx_flap = 0.035,
			cx_gear = 0.032,
			cy_flap = 0.24,
			kjx = 2.75,
			kjz = 0.00125,
			table_data = { { 0, 0.024, 0.07, 0.075, 0.12, 0.5, 30, 1.2 }, { 0.2, 0.024, 0.07, 0.075, 0.12, 1.5, 30, 1.2 }, { 0.4, 0.024, 0.07, 0.075, 0.12, 2.5, 30, 1.2 }, { 0.6, 0.0239, 0.073, 0.075, 0.12, 3.5, 30, 1.2 }, { 0.7, 0.024, 0.076, 0.075, 0.12, 3.5, 28.666666666667, 1.18 }, { 0.8, 0.0235, 0.079, 0.075, 0.12, 3.5, 27.333333333333, 1.16 }, { 0.9, 0.025, 0.083, 0.075, 0.125, 3.5, 26, 1.14 }, { 1, 0.044, 0.085, 0.14, 0.1, 3.5, 24.666666666667, 1.12 }, { 1.05, 0.0465, 0.0855, 0.1775, 0.125, 3.5, 24, 1.11 }, { 1.1, 0.049, 0.086, 0.215, 0.15, 3.15, 18, 1.1 }, { 1.2, 0.049, 0.083, 0.228, 0.17, 2.45, 17, 1.05 }, { 1.3, 0.049, 0.077, 0.237, 0.2, 1.75, 16, 1 }, { 1.5, 0.0475, 0.062, 0.251, 0.2, 1.5, 13, 0.9 }, { 1.7, 0.045166666666667, 0.051333333333333, 0.24366666666667, 0.32, 0.9, 12, 0.7 }, { 1.8, 0.044, 0.046, 0.24, 0.38, 0.86, 11.4, 0.64 }, { 2, 0.043, 0.039, 0.222, 2.5, 0.78, 10.2, 0.52 }, { 2.2, 0.041, 0.034, 0.227, 3.2, 0.7, 9, 0.4 }, { 2.5, 0.04, 0.033, 0.25, 4.5, 0.7, 9, 0.4 }, { 3.9, 0.035, 0.033, 0.35, 6, 0.7, 9, 0.4 } }
		},
		engine = {
			ForsRUD = 0.91,
			MaksRUD = 0.85,
			MaxRUD = 1,
			MinRUD = 0,
			Nmg = 71,
			cefor = 2.56,
			cemax = 1.24,
			dcx_eng = 0.0144,
			dpdh_f = 13200,
			dpdh_m = 6600,
			hMaxEng = 19,
			table_data = { { 0, 88000, 141000 }, { 0.2, 80000, 143000 }, { 0.4, 79000, 150000 }, { 0.6, 82000, 165000 }, { 0.7, 90000, 177000 }, { 0.8, 94000, 193000 }, { 0.9, 96000, 200000 }, { 1, 100000, 205000 }, { 1.1, 100000, 214000 }, { 1.2, 98000, 222000 }, { 1.3, 100000, 235000 }, { 1.5, 98000, 258000 }, { 1.8, 94000, 276000 }, { 2, 88000, 283000 }, { 2.2, 82000, 285000 }, { 2.5, 80000, 287000 }, { 3.9, 50000, 200000 } },
			type = "TurboJet"
		}
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "MIG-29C-oblomok-wing-l", -- wing R
		[2] = "MIG-29C-oblomok-wing-r", -- wing L
	},
	
	net_animation = {
        0, -- front gear
        3, -- right gear
        5, -- left gear
        9, -- right flap
        10, -- left flap
        11, -- right aileron
        12, -- left aileron
        15, -- right elevator
        16, -- left elevator
        17, -- rudder

        38,    -- canopy
        115, -- gear door
        116, -- gear door
        117, -- gear door

        190, -- left (red) navigation wing-tip light
        191, -- right (green) navigation wing-tip light
        192, -- tail (white) light

        198, -- anticollision (flashing red) top light
        199, -- anticollision (flashing red) bottom light
        208, -- taxi light (white) right main gear door
    },
	
lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 190, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
	
}

add_aircraft(MiG_29N)