local base = _G

module('me_units_list_form')

local Window = base.require('Window')
local Container = base.require('Container')
local ScrollGrid = base.require('ScrollGrid')
local Theme = base.require('Theme')
local U = base.require('me_utilities')
local i18n = base.require('i18n')
local Button = base.require('Button')

i18n.setup(_M)

cdata = {
    groupsList = _('GROUPS LIST'),
}

function create(x, y, w, h, filterCallback)
    local window = Window.new(x, y, w, h);
    local _aa,_aa,cw,ch = window:getClientRect();
    window:setTop(true);
    header = U.create_header(groupsList)
    header:setBounds(0, 0, w-U.widget_h, U.widget_h)
    window:addChild(header)
    btnClose = U.create_close_button()
    btnClose:setBounds(w-U.widget_h, 0, U.widget_h, U.widget_h)
    window:addChild(btnClose)
    
    local names = {
        _('Helicopters'),
        _('Planes'),
        _('Vehicles'),
        _('Ships'),
        _('Statics'),
    };
    local types = {
        'helicopter',
        'plane', 
        'vehicle',
        'ship',
        'static',
    }
    filters = {};
    local xPos, yPos, W, H = 0, U.widget_h+U.dist_h, U.text_long_w+15, U.widget_h;
    for i = 1, #types do
        xPos = (i-1)*W;
        filters[types[i]] = U.create_check_box(names[i], true);
        filters[types[i]]:setBounds(xPos, yPos, W, H);
        filters[types[i]].onChange = filterCallback;
        --filters[types[i]].type = types[i];
        window:addChild(filters[types[i]]);
    end;
    xPos = xPos + W;
    countryFilter = U.create_combo({});
    countryFilter:setBounds(xPos, yPos-1, W, H)
    countryFilter:setReadonly(true);
    window:addChild(countryFilter);
	
	-- Blind:
    
	xPos = xPos + W + 10 -- spacing war zuvor nicht notwendig, da chkb labels immer kuerzer waren
	W = 70
	showallBtn = Button.new(_('Show all'))
	showallBtn:setBounds(xPos, yPos, W, H)
	window:addChild(showallBtn)

	xPos = xPos + W + 3
	hideallBtn = Button.new(_('Hide all'))
	hideallBtn:setBounds(xPos, yPos, W, H)
	window:addChild(hideallBtn)

	xPos = xPos + W + 3
	toggleallBtn = Button.new(_('Toggle'))
	toggleallBtn:setBounds(xPos, yPos, W, H)
	window:addChild(toggleallBtn)
	
	xPos = xPos + W + 3 
	W = 70
	duplicateBtn = Button.new("CLONE")
	duplicateBtn:setBounds(xPos, yPos, W, H)
	window:addChild(duplicateBtn)
	duplicateBtn:setEnabled(false)

	--[[    local theme  = window:getTheme();
    theme.titleHeight = 10;
    window:setTheme(theme);--]]
    grid = ScrollGrid.new();
    grid:setBounds(0, 2*U.widget_h+U.dist_h, cw, ch - 2*U.widget_h+U.dist_h)
    grid:setTheme(Theme.newScrollGridTheme())
    grid:setEnabled(true);
    window:insertWidget(grid);
    return window;
end

