local base = _G

module('me_units_list')

local Widget = base.require('Widget')
local U = base.require('me_utilities')
local MapWindow = base.require('me_map_window')
local MsgWindow = base.require('MsgWindow')
local Theme = base.require('Theme')
local form = base.require('me_units_list_form')
local MissionModule = base.require('me_mission')
local DB = base.require('me_db_api')
local i18n = base.require('i18n')
local ComboBox = base.require('ComboBox')

i18n.setup(_M)
function initModule()
    cdata = {
        object = _('NAME'),
        side = _('COUNTRY'),
        status = _('STATUS'),
        quantity = _('QNTY'),
        hidden = _('HIDDEN'),
        allCountries = _('ALL'),
        red = _('RED'),
        blue = _('BLUE'),        
    }

    vdata = {
    }
end;


function applyFilter(group)
    if not group then
        return false;
    end;
    --base.print('country',group.boss.name);    
    local coalitionName = group.boss.boss.name;
    local countryName = group.boss.name;
    --base.print(group.type, filters[group.type])
    if filters[group.type]:getState() then
        local comboText =  form.countryFilter:getText();
        if comboText == cdata.allCountries then
            return true;
        end;
        if (comboText == cdata.red) and (coalitionName == 'RED') then
            return true;
        end;
        if (comboText == cdata.blue) and (coalitionName == 'BLUE') then
            return true;
        end;
        if (comboText == countryName) then
            return true;
        end;
        return false;
    else
        return false;
    end;
end;

function create(x, y, w, h)
    window = form.create(x, y, w, h, update)
    filters = form.filters
    form.grid:enableMouseCallback(true);
    --form.grid.onGridMouseDown = onGridMouseDown;
    --form.grid.onMouseClick = onGridMouseDown;
	
	-- Blind
	form.duplicateBtn.onChange = onClickDuplicate;
	form.showallBtn.onChange = onClickShowAll;
	form.hideallBtn.onChange = onClickHideAll;
	form.toggleallBtn.onChange = onClickToggleAll;
	
    updateCountriesCombo();
    form.countryFilter:setText(cdata.allCountries);
    form.countryFilter.onChange = onCountryChange;
    form.btnClose.onChange = btnCloseOnChange;
end;

function onCountryChange(self, item)
    update();
end; 

function btnCloseOnChange()
    show(false);
    base.toolbar.b_unit_list:setState(false);
end;

-- Blind
function onClickDuplicate()	
	if currentGroup then
		--local w = MsgWindow.new(currentGroup.name, 'Info', 'warning', 'OK')
		--w:setVisible(true);
		local g = MissionModule.duplicate_group(currentGroup)
		MissionModule.remove_group_map_objects(g)
		MissionModule.create_group_map_objects(g)
		selectGroup(g)
		selectRow(g, nil)
	end;

	MapWindow.mapView:updateUserList(true)
end;

function onClickShowAll()
	changeAll(true)
end;

function onClickHideAll()	
	changeAll(false)
end;

function onClickToggleAll()	
	changeAll()
end;

function changeAll(b)
    for i=1,form.grid:getRowsCount() do
        local w = form.grid:getCell(1, i);
        local group = w.data.group;
        if true == b then
            if group.hidden then
                MissionModule.create_group_map_objects(group)
				selectGroup(group);
            end;
            group.hidden = false;
        elseif false == b then
            if not group.hidden then
                MissionModule.remove_group_map_objects(group)
            end;
            group.hidden = true;
        else
            if group.hidden then
                MissionModule.create_group_map_objects(group)
				selectGroup(group);
            else
                MissionModule.remove_group_map_objects(group)
            end;
            group.hidden = not group.hidden;
        end;
		updateRow(group);
    end;
    MapWindow.mapView:updateUserList(true)
end;


function show(b)
    if b then
        update();
        updateCountriesCombo();
        if MapWindow.selectedGroup then --  - 
            selectGroup(MapWindow.selectedGroup);
        else --   
            --      
            --    
            local k = base.next(MissionModule.group_by_name, nil);
            if k then 
                local group = MissionModule.group_by_name[k]
                if group and (not group.hidden) then 
                    --    
                    selectGroup(group);
                    --    
                    selectRow(group);
                end;
            else
                window:setVisible(false);
                base.toolbar.b_unit_list:setState(false);
                return;
            end;
        end;
    else
        base.toolbar.form.b_unit_list:setState(false);
    end;
    window:setVisible(b);
end;

function update()
    form.grid:setEnabled(true);
    --  
    while  form.grid:getColumnsCount() > 0 do
        form.grid:removeColumn(1);
    end;
    while  form.grid:getRowsCount() > 0 do
        form.grid:removeRow(1);
    end;
    --   
    local _tmp,_tmp1,cw,ch = window:getClientRect();
    --     
    local header = {
        {name = cdata.object, w = 400},
        {name = cdata.side, w = 100},
        {name = cdata.status, w = 100},
        {name = cdata.quantity, w = 50},
    }

    for i = 1, #header do
        local u = Widget.new(header[i].name)
        u:setTheme(Theme.newGridColumnTheme())
        u:setText(header[i].name);
        form.grid:insertColumn(header[i].w, nil, u);
    end  

    local group_by_name = {};
    for r,group in base.pairs(MissionModule.group_by_name) do
        if group then 
            base.table.insert(group_by_name,group); 
        end;
    end;
    
    --   
    base.table.sort(group_by_name, function(p1, p2)
                        return p1.name < p2.name;
            end);
    
    local rowInd = 1;
    for r,group in base.pairs(group_by_name) do
        if group and applyFilter(group) then 
            form.grid:insertRow(20,rowInd);
            for c = 1,4 do
                local u = Widget.new()
                local hiddenStr = '';
                if group.hidden then 
                    hiddenStr = cdata.hidden; 
                end;
                local text = {group.name, group.boss.name, hiddenStr , #group.units};
                local data = {group = group, r = rowInd, c = c}
                u:setTheme(Theme.newUnitListGridCellTheme())
                u:setText(text[c]);
                u.data = data;
                u:enableMouseCallback(true);
                u:setEnabled(true);
                u.onMouseDblClick = onMouseDblClick
				u.onMouseDown = onGridMouseDown;
                form.grid:setCell(u, c, rowInd);
            end;
            rowInd = rowInd + 1; 
        end;
    end;
    -- 
    if MapWindow.selectedGroup then 
        selectRow(MapWindow.selectedGroup);
    end;
end;

function onMouseDblClick(self)
	self.data.group.hidden = not self.data.group.hidden
	--   
	updateRow(self.data.group);
	if self.data.group.hidden then --  ,     
		MissionModule.remove_group_map_objects(self.data.group)
	else   --  ,     
		MissionModule.create_group_map_objects(self.data.group)
		--    
		selectGroup(self.data.group);
	end;
	--  
	MapWindow.mapView:updateUserList(true)
	onGridMouseDown(self)
end

--     
function onGridMouseDown(self, x, y, button)
    if not applyFilter(self.data.group) then 
        return
    end;
    MapWindow.hideGroupPanels();
    selectGroup(self.data.group);
    selectRow(self.data.group, self.data.r);
end;

--    
function selectGroup(group)
    if not group or not applyFilter(group) then 
		form.duplicateBtn:setEnabled(false)
		currentGroup = nil
        return;
    end;
	form.duplicateBtn:setEnabled(true)
	currentGroup = group
	
    if group.hidden then
        MapWindow.unselectAll();
        MapWindow.selectedGroup = group;
        MapWindow.hideGroupPanels();
        setCheckBox(group.type, true)
        local selectedUnit = group.units[1];
        local mapObject = group.mapObjects.units[1];
        MapWindow.selectedUnit = selectedUnit;
        MapWindow.respondToSelectedUnit(mapObject, group, selectedUnit)
        return;
    end;
    local mapObject;
    if group.mapObjects.route then
        mapObject = group.mapObjects.route.points[1];
    else
        mapObject = group.mapObjects.units[1].userObject;
        mapObject.userObject = group.mapObjects.units[1].userObject;
    end;
    setCheckBox(group.type, false)
    if not mapObject then 
        return;
    end;
    local unit = group.mapObjects.units[1].userObject;
    MapWindow.unselectAll()
    local selectedUnit = group.units[1];
    MapWindow.respondToSelectedUnit(mapObject, group, selectedUnit)
    base.panel_route.update()
    if window:isVisible() then
        MapWindow.mapView:setCamera(group.lat, group.long);
        local mx,my,mw,mh = base.MapWindow.window:getBounds()
        local _x,_y = MapWindow.window:widgetToWindow((mw - base.right_toolbar_w)/2,(mh - 300)/2)
        local lat,lon =  MapWindow.mapView:getMapPoint(_x,_y);
        MapWindow.mapView:setCamera(2*group.lat - lat, 2*group.long - lon);        
    end;
    
end;

--    
function selectRow(group, row)
    if not applyFilter(group) then 
        form.grid:selectRow(nil);
        return
    end;
    if not row then 
        for r = 1,form.grid:getRowsCount() do 
            local widget = form.grid:getCell(1,r);
            if widget.data.group == group then 
                form.grid:selectRow(r);
                selection = r;
            end;
        end;
    else
        form.grid:selectRow(row);
    end;
    --base.print('selecting row: '.. row .. ' group '.. base.tostring(group));
end;

--    
function updateRow(group)
    --base.print('updateRow', group);
    if not applyFilter(group) then 
        return
    end;
    for r = 1,form.grid:getRowsCount() do 
        local widget = form.grid:getCell(1,r);
        if widget.data.group == group then 
            widget:setText(group.name);
            --base.print('group.name', group.name);
            
            widget = form.grid:getCell(2,r);
            widget:setText(group.boss.name);
            --base.print('group.boss.name', group.boss.name);
            
            widget = form.grid:getCell(3,r);
            local hiddenStr = '';
            if group.hidden then hiddenStr = cdata.hidden end;
            widget:setText(hiddenStr);
            --base.print('hiddenStr', hiddenStr);
            
            widget = form.grid:getCell(4,r);
            widget:setText(base.tostring(#group.units));
            --base.print('#group.units', #group.units);
        end;
    end;
end;

--      
function setCheckBox(type, b)
    if (type == 'plane') or (type == 'helicopter') then
        base.panel_aircraft.hiddenCheckbox:setState(b);
    elseif type == 'ship' then
        base.panel_ship.hiddenCheckbox:setState(b);
    elseif type == 'vehicle' then
        base.panel_vehicle.hiddenCheckbox:setState(b);
    elseif type == 'static' then
        base.panel_static.hiddenCheckbox:setState(b);
    end;
end;

function selectNextGroup()
    --local k,v = base.next(MissionModule.group_by_name)
    --local rowInd = form.grid:getSelectedRow();
    local rowsCount = form.grid:getRowsCount();
    if selection then
        if selection > rowsCount then
            selection = rowsCount
        end;
        
        if selection and (selection > 0)then
            local w = form.grid:getCell(1, selection);
            local data = w.data;
            --base.print('selecting new ', data.group.name)
            selectGroup(data.group);
            selectRow(data.group, selection);
        else
            show(false);
            MapWindow.selectedGroup = nil
            base.toolbar.untoggle_all_except()        
        end;
    end;
--[[    
    if v then 
        selectGroup(v)     
        selectRow(v)
    else
        show(false);
        MapWindow.selectedGroup = nil
        base.toolbar.untoggle_all_except()
    end;
--]]    
end;

function saveSelection()
    selection = form.grid:getSelectedRow();
end;

function updateCountriesCombo()
    if MissionModule.mission == nil then
        return;
    end;
    form.countryFilter:clear();
    local countries = {};
    base.table.insert(countries, cdata.allCountries);
    base.table.insert(countries, cdata.red);
    base.table.insert(countries, cdata.blue);
    for i,countryName in base.ipairs(MissionModule.mission.coalitions.red) do 
        --base.print('i,countryID',i,countryID);
        --local countryName = DB.country_by_id[countryID].Name;
        base.table.insert(countries, countryName);        
    end
    for i,countryName in base.ipairs(MissionModule.mission.coalitions.blue) do 
        --local countryName = DB.country_by_id[countryID].Name;
        base.table.insert(countries, countryName);        
    end
    local firstEntries = { cdata.allCountries, cdata.red, cdata.blue};
    base.table.sort(countries, base.U.listFirstComparator(firstEntries))
    base.U.fill_combo(form.countryFilter, countries);
    -- for i, v in base.ipairs(countries) do
      -- local item = ComboBox.newItem(v)
      -- form.countryFilter:insertWidget(item);
    -- end
    -- form.countryFilter:setText(cdata.allCountries);
end; 

initModule();
